<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  23/01/11, 20:53
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  \class shopping_cart_action
  \brief Traitement des action sur le shopping cart par l'intermediaire d'une fonction
*/

class shopping_cart_action
  extends shoppingCart{
  /**
    Panier d'achat client
  */
  public $cart;

  /**
    @var array action block and exe by class
  */
  protected static $actionCart = array('load','resetCart','update_product','add_product','add_buy_now','buy_now');

  function __construct() {
  }

  /**
    @fn addActionExe($action)
    @brief add action for customers
  */
  public static function addActionExe($action){
    if(!in_array($action, self::$actionCart)) array_push(self::$actionCart,$action);
  }

  /**
   * \fn  update_product()
  */
  private function update_product(){
    global $cart;
    for ($i=0, $n=sizeof($_POST['products_id']); $i<$n; $i++) {
      if (isset($_POST['cart_delete']) && in_array($_POST['products_id'][$i], (is_array($_POST['cart_delete']) ? $_POST['cart_delete'] : array()) )) {
	  $cart->remove($_POST['products_id'][$i]);
      } else {
	$attributes = (isset($_POST['id'][$_POST['products_id'][$i]]) ? $_POST['id'][$_POST['products_id'][$i]] : '');
	$cart->add_cart($_POST['products_id'][$i], (int)tep_output_string_protected($_POST['cart_quantity'][$i]), $attributes, false);
      }
    }
  }

  /**
   * \fn  add_product()
  */
  private function add_product(){
    global $cart;
    if (isset($_POST['products_id']))
      $cart->add_cart($_POST['products_id'], $cart->get_quantity(tep_get_uprid($_POST['products_id'], @$_POST['id']))+(int)tep_output_string_protected($_POST['products_quantity']), @$_POST['id']);
  }

  /**
   * \fn  add_buy_now()
  */
  private function add_buy_now(){
    global $cart;
    if (isset($_POST['products_id']) && is_numeric($_POST['products_id'])) {
      if (tep_has_product_attributes($_POST['products_id'])) {
        tep_redirect(tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $_POST['products_id']));
      } else {
        $cart->add_cart($_POST['products_id'], $cart->get_quantity($_POST['products_id'])+(int)tep_output_string_protected($_POST['products_quantity']));
      }
    }
  }

  /**
   * \fn  buy_now()
  */
  private function buy_now(){
    global $cart;
    if (isset($_GET['products_id'])) {
      if (tep_has_product_attributes($_GET['products_id'])) {
        tep_redirect(tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $_GET['products_id']));
      } else {
        $cart->add_cart($_GET['products_id'], $cart->get_quantity($_GET['products_id'])+1);
      }
    }
  }

  /**
   * \fn  cust_order()
  */
  private function cust_order(){
    global $cart;
    if (tep_session_is_registered('customer_id') && isset($_GET['pid'])) {
      if (tep_has_product_attributes($_GET['pid'])) {
        tep_redirect(tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $_GET['pid']));
      } else {
        $cart->add_cart($_GET['pid'], $cart->get_quantity($_GET['pid'])+1);
      }
    }
  }

  /**
   * \fn  add2_product()
   *\brief Specifique aca + major oscss
    generation d'un coupon de la valeur * qty produits
  */
  private function add2_product(){
    global $page;
    if (isset($_POST['products_id']) && is_numeric($_POST['products_id'])) {
    $module=$page->new_class('product');
    $module=$module->ret_modules();
    $product_info =$module['portefeuil']->new_coupon_for_id((int)$_POST['products_id'],tep_output_string_protected($_POST['products_quantity']));
    }

  }

  /**
   * \private
   * \fn  resetCart()
   */
  private function resetCart(){
    global $cart;

    $cart->reset(true);
  }


  /**
   * \fn  init($action)
   * \brief Execution des action liée au panier

    NOTE: Les moduels complementaire, sotn appelé par la class order total, qui fournis les metodes de modification
      Les module ssont prioritaire par rapport au core

   * @param $action boolean $_GET['noredirect'] block la redirection apres ajout au panier
  */
  public function init($action){
    global $page, $cart;
    $this->action=$action;

    if(!in_array($this->action,self::$actionCart))return;

    /// force login for shopping cart
    if (!_cst_bool('NO_SHOPPING_CART_FOR_GUEST') && !tep_session_is_registered('customer_id') ) {
      $navigation=navigation_history::getInstance();
      $navigation->set_snapshot();
      tep_redirect(FILENAME_LOGIN);
    }

    //! chargement des order total , pour calcul cout , reduction.etc
    if( ($order_total_modules=$page->return_object('order_total_modules')) ===false){
      if(!class_exists('order_total')) require(DIR_WS_CLASSES . 'order_total.php');
      $order_total_modules = new order_total(false);
      $page->add_object('order_total_modules',$order_total_modules);
    }


    if (_cst_bool('DISPLAY_CART')) {
      $goto =  FILENAME_SHOPPING_CART;
      $parameters = array('action', 'cPath', 'products_id', 'pid');
    } else {
      $b=basename($_SERVER['REQUEST_URI']);
      $goto = substr($b,0,strpos($b,'?') ) ;
      $parameters = array('action', 'pid','language');
      unset($b);
    }

    /**
      Execution des actions des modules order_totals
      Si action, pas de suite , redirect contenu dans l'action
      Les action des modules ot_xxx doivent avoir une methode shopping_cart_action
    */
    $href=$order_total_modules->shopping_cart_action();

    if(!$href)
      switch ($action) {
	default:
	  $this->$action();
	  if(!isset($_GET['noredirect']))  tep_redirect(tep_href_link($goto, tep_get_all_get_params($parameters)));
      }
  }

}
?>