<?php if (!defined('HTTP_SERVER')) die('You can not access this file directly!');
/**
 *\licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
 *\portion code Copyright (c) 2002 osCommerce
 *\package osCSS-2 <www http://www.oscss.org>
 *\version 2.0.9
 *\date  19/06/10, 21:07
 *\author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
 *\encode UTF-8
 *\file whos_online.php
 *\dir includes/functions/
 *\class tagCloud
 *\brief Tag Cloud
*/
class tagCloud {

  var $version = '1.0.1';
  var $wordsArray = array();

  /**
    \brief PHP 5 Constructor
    \a $words array 
    @return void
  */
  function __construct($words = false) {
    // If we are trying to parse some works, in any format / type
    if ($words !== false) {
      // If we have a string
      if (is_string($words)) {
	$this->addString($words);
      } elseif (count($words)) {
	foreach ($words as $key => $value) $this->addWord($value);
      }
    }
    return;
  }

  /**
    \brief Convert a string into a cloud
    \a $string
    @return void
  */
  function addString($string){
    // remove all other chars apart from a-z
    $string = preg_replace('[^a-z]', '', strip_tags(strtolower($string)));
    $words = array();
    $words = explode(' ', $string);
    if (count($words)) {
      foreach ($words as $key => $value) $this->addWord($value);
    }
  }

  /**
    \brief Display user friendly message, for debugging mainly
    \a string $string
    \a array $value
    @return bool
  */
  function notify($string, $value){
	  echo '<pre>';
	  print_r($string);
	  print_r($value);
	  echo '</pre>';
	  return false;
  }

  /**
    \brief Assign word to array
    \a string $word
    @return string
  */
  function addWord($wordAttributes = array()) {
    if (is_string($wordAttributes))$wordAttributes = array('word' => $wordAttributes);

    if (!array_key_exists('size', $wordAttributes))$wordAttributes = array_merge($wordAttributes, array('size' => 1));

    if (!array_key_exists('word', $wordAttributes))return $this->notify('no word attribute', print_r($wordAttributes, true));

    $word = strtolower($wordAttributes['word']);
    if (empty($this->wordsArray[$word]))$this->wordsArray[$word] = array();

    if (!empty($this->wordsArray[$word]['size']) && !empty($wordAttributes['size']))$wordAttributes['size'] = ($this->wordsArray[$word]['size'] + $wordAttributes['size']);
    elseif (!empty($this->wordsArray[$word]['size'])) $wordAttributes['size'] = $this->wordsArray[$word]['size'];

    $this->wordsArray[$word] = $wordAttributes;
    return $this->wordsArray[$word];
  }

  /**
    \brief Shuffle associated names in array
    @return array $this->wordsArray
  */
  function shuffleCloud(){
    $keys = array_keys($this->wordsArray);
    shuffle($keys);
    if (count($keys) && is_array($keys)) {
      $tmpArray = $this->wordsArray;
      $this->wordsArray = array();
      foreach ($keys as $key => $value)
	$this->wordsArray[$value] = $tmpArray[$value];
    }
    return $this->wordsArray;
  }

  /**
    \brief Get the class range using a percentage
    @returns int $class
  */
  function getClassFromPercent($percent){
    if ($percent >= 99)
	    $class = 9;
    elseif ($percent >= 70)
	    $class = 8;
    elseif ($percent >= 60)
	    $class = 7;
    elseif ($percent >= 50)
	    $class = 6;
    elseif ($percent >= 40)
	    $class = 5;
    elseif ($percent >= 30)
	    $class = 4;
    elseif ($percent >= 20)
	    $class = 3;
    elseif ($percent >= 10)
	    $class = 2;
    elseif ($percent >= 5)
	    $class = 1;
    else
	    $class = 0;
    return $class;
  }

  /**
   *\fn setLimit($limit) 
    \brief Sets a limit for the amount of clouds
    \a string $limit
    @returns string $this->limitAmount
  */
  function setLimit($limit) {
    if (!empty($limit)) {
	    $this->limitAmount = $limit;
    }
    return $this->limitAmount;
  }

  /**
   *\fn limitCloud()
    \brief Gets the limited amount of clouds
    @returns string $wordCloud
  */
  function limitCloud(){
    $i = 1;
    foreach ($this->wordsArray as $key => $value) {
	    if ($this->limitAmount < $i) {
		    $wordsArray[$value['word']] = $value;
	    }
	    $i++;
    }
    $this->wordsArray = array();
    $this->wordsArray = $wordsArray;
    return $this->wordsArray;
  }

  /**
    \brief Finds the maximum value of an array
    \a string $word
    @returns void
  */
  function removeWord($word){
    $this->removeWords[] = strtolower($word);
  }

  /**
   *\fn removeWords()
    \brief Removes tags from the whole array
    @returns array $this->wordsArray
  */
  function removeWords()  {
    foreach ($this->wordsArray as $key => $value) {
	    if (!in_array($value['word'], $this->removeWords)) {
		    $wordsArray[$value['word']] = $value;
	    }
    }
    $this->wordsArray = array();
    $this->wordsArray = $wordsArray;
    return $this->wordsArray;
  }

  /**
   *\fn orderBy($field, $direction = 'ASC')
    \brief Assign the order field and order direction of the cloud
    \a array $field
    \a string $sortway
    @returns void
  */
  function orderBy($field, $direction = 'ASC') {
    return $this->orderBy = array('field' => $field, 'direction' => $direction);
  }

  /**
   *\fn orderCloud($unsortedArray, $sortField, $sortWay = 'SORT_ASC')
    \brief Orders the cloud by a specific field
    \a array $unsortedArray
    \a string $sortField
    \a string $sortWay
    @returns array $unsortedArray
  */
  function orderCloud($unsortedArray, $sortField, $sortWay = 'SORT_ASC'){
    $sortedArray = array();
    foreach ($unsortedArray as $uniqid => $row) {
      foreach ($row as $key => $value) {
	$sortedArray[$key][$uniqid] = strtolower($value);
      }
    }
    if ($sortWay) {
      array_multisort($sortedArray[$sortField], constant($sortWay), $unsortedArray);
    }
    return $unsortedArray;
  }

  /**
   *\fn getMax()
    \brief Finds the maximum value of an array
    @returns string $max
  */
  function getMax() {
    $max = 0;
    if (!empty($this->wordsArray)) {
      $p_size = 0;
      foreach ($this->wordsArray as $cKey => $cVal) {
	$c_size = $cVal['size'];
	if ($c_size > $p_size)
		$max = $c_size;
	$p_size = $c_size;
      }
    }
    return $max;
  }

  /**
   * \fn showCloud($returnType = 'html')
    \brief Create the HTML code for each word and apply font size.
    @returns string/array $return
  */
  function showCloud($returnType = 'html') {
    if (empty($this->orderBy)) {
      $this->shuffleCloud();
    } else {
      $orderDirection = strtolower($this->orderBy['direction']) == 'desc' ? 'SORT_DESC' : 'SORT_ASC';
      $this->wordsArray = $this->orderCloud($this->wordsArray, $this->orderBy['field'], $orderDirection);
    }
    if (!empty($this->limitAmount))$this->limitCloud();

    if (!empty($this->removeWords))  $this->removeWords();

    $this->max = $this->getMax();
    if (is_array($this->wordsArray)) {
      $return = ($returnType == 'html' ? '' : ($returnType == 'array' ? array() : ''));
      foreach ($this->wordsArray as $word => $arrayInfo) {
	$sizeRange = $this->getClassFromPercent(($arrayInfo['size'] / $this->max) * 100);
	$arrayInfo['range'] = $sizeRange;
	if ($returnType == 'array') {
	  $return [$word] = $arrayInfo;
	} elseif ($returnType == 'html') {
	  $return .= "<span class='word size{$sizeRange}'> &nbsp; {$arrayInfo['word']} &nbsp; </span>";
	}
      }
      return $return;
    }
  }
}
?>