<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  16/09/10, 21:52
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/
$acount=account::getInstance();
$aca_account=$page->return_object('account');
?>
<div id="accountHistoryInfo">

  <h2 class="content title  <?php echo $language ;?>"><?php echo HEADING_TITLE; ?></h2>
  <h3><?php echo sprintf(HEADING_ORDER_NUMBER,$order->info['orders_prefix'].$_GET['order_id']) . ' <small>(' . $order->info['orders_status'] . ')</small>'; ?></h3>
  <h4><?php echo HEADING_ORDER_DATE . ' ' . tep_date_long($order->info['date_purchased']); ?></h4>


     <table class="invoice invoiceAdress" cellspacing="0" summary="<?php echo HEADING_TITLE; ?>">
    <thead>
        <tr>
         <th class="deliveryAddress"><?php echo HEADING_DELIVERY_ADDRESS; ?></th>
         <th class="billingAdress"><?php echo HEADING_BILLING_ADDRESS; ?></th>
        </tr>
    </thead>
    <tbody>
      <tr>
      <td class="deliveryAddress"><?php echo tep_address_format($order->delivery['format_id'], $order->delivery, 1, ' ', '<br />'); ?></td>
        <td class="billingAdress"><?php echo tep_address_format($order->billing['format_id'], $order->billing, 1, ' ', '<br />'); ?></td>
    </tr>
    </tbody>
   </table>

    <table class="invoice invoiceDetails" cellspacing="0" summary="<?php echo HEADING_TITLE; ?>">
    <thead>
        <tr>
         <th class="invoiceProducts"><?php echo HEADING_PRODUCTS; ?></th>
	<th class="invoiceQty"><?php echo HEADING_PRODUCTS_QTY; ?></th>
	<th class="invoiceTaxes"><?php echo HEADING_TAX; ?></th>
	<th class="invoicePrice"><?php echo HEADING_PRODUCTS_PRICE; ?></th>
        </tr>
    </thead>
    <tbody>
    <?php reset($order->products); foreach($order->products as $prdct) { ?>
      <tr>
	<td class="invoiceProducts tleft">
	<?php echo implode(',',$acount->displayInForProducts(array_merge(array('order_id'=>$_GET['order_id'], 'orders_status_id'=>$order->info['orders_status_id']), $prdct))).'<br />' ;
	      echo $prdct['name'] ;
		if ( (isset($prdct['attributes'])) && (sizeof($prdct['attributes']) > 0) )
		  foreach($prdct['attributes'] as $attrib) echo '<br /><span class="invoiceAttributes">&nbsp; - ' . $attrib['option'] . ': ' . $attrib['value'] .'</span>' ;
	?> </td>
	<td class="invoiceQty tcenter"><?php echo $prdct['qty'] ;?></td>
	<td class="invoiceTaxes tcenter taxe"><?php echo tep_display_tax_value($prdct['tax']) . '%' ; ?></td>
	<td class="invoicePrice tright pu"><?php echo $currencies->format($prdct['final_price'] , true, $order->info['currency'], $order->info['currency_value']) ; ?></td>
	<td class="invoicePrice tright totht"><?php echo $currencies->format($prdct['final_price'] * $prdct['qty'], true, $order->info['currency'], $order->info['currency_value']) ; ?></td>
	<td class="invoicePrice tright totttc"><?php  echo $currencies->format(tep_add_tax($prdct['final_price'], $prdct['tax'],true) * $prdct['qty'], true, $order->info['currency'], $order->info['currency_value']) ;  ?></td>
      </tr>
    <?php } ?>
    </tbody>
   </table>

    <table class="invoice invoiceTotal" cellspacing="0">
    <tbody>
      <?php for ($i=0, $n=sizeof($order->totals); $i<$n; $i++) { ?>
	<tr>
	  <td colspan="3" class="otTtitle"><?php echo $order->totals[$i]['title'] ;?></td>
	  <td class="otText totttc"><?php echo $order->totals[$i]['text'];?></td>
	</tr>
      <?php } ?>
    </tbody>
   </table>


    <?php if (tep_not_null($order->info['shipping_method'])) { ?>
      <p><?php echo HEADING_SHIPPING_METHOD . ':' . $order->info['shipping_method']; ?></p>
    <?php } ?>
    <p><?php echo HEADING_PAYMENT_METHOD . ':' . $order->info['payment_method']; ?></p>


    <h5><?php echo HEADING_ORDER_HISTORY; ?></h5>

    <table class="invoiceHistory" cellspacing="0" summary="<?php echo HEADING_ORDER_HISTORY; ?>">
      <thead>
        <tr>
          <th><?php echo HEADING_HISTORY_DATE; ?></th>
          <th><?php echo HEADING_HISTORY_STATUS; ?></th>
          <th><?php echo HEADING_HISTORY_COMMENT; ?></th>
        </tr>
      </thead>
      <tbody>
      <?php
        $statuses_query = tep_db_query("select os.orders_status_name, osh.date_added, osh.comments from " . TABLE_V_ORDERS_STATUS . " os, " . TABLE_ORDERS_STATUS_HISTORY . " osh where osh.orders_id = '" . (int)$_GET['order_id'] . "' and osh.orders_status_id = os.orders_status_id and os.language_id = '" . (int)$languages_id . "' order by osh.date_added");
        while ($statuses = tep_db_fetch_array($statuses_query)) {
          echo '<tr>' . "\n" .
          '<td>' . tep_date_short($statuses['date_added']) . '</td>' . "\n" .
              '<td>' . $statuses['orders_status_name'] . '</td>' . "\n" .
              '<td>' . (empty($statuses['comments']) ? '&nbsp;' : nl2br(tep_output_string_protected($statuses['comments']))) . '</td>' . "\n" .
            '</tr>' . "\n" ;

        }
      ?>
      </tbody>
    </table>

    <?php if (_cst_bool('DOWNLOAD_ENABLED')) include(DIR_WS_MODULES . 'downloads.php'); ?>

    <div class="navBt">
      <?php echo '<a class="navBt" href="' . tep_href_link(FILENAME_ACCOUNT, 'action=history', 'SSL'). '">' . IMAGE_BUTTON_BACK . '</a>'; ?>
    </div>

</div>