<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  16/09/10, 21:54
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/
?>
<div id="createAccount">
  <?php $page->messageStack->_draw('create_account');?>

  <h2 class="content title <?php echo $language ;?>"><?php echo HEADING_TITLE; ?></h2>

  <?php echo sprintf(TEXT_ORIGIN_LOGIN, tep_href_link(FILENAME_LOGIN, tep_get_all_get_params(), 'SSL')); ?>

  <p class="notice"><?php echo FORM_REQUIRED_INFORMATION; ?></p>

  <?php echo tep_draw_form('create_account', tep_href_link(FILENAME_CREATE_ACCOUNT, , tep_get_all_get_params(array('action','process')), 'SSL'), 'post') ;?>

    <fieldset>
      <legend><?php echo CATEGORY_PERSONAL; ?></legend>
      <?php if (_cst_bool('ACCOUNT_GENDER')): ?>
        <p>
          <label><?php echo ENTRY_GENDER; ?></label>
          <?php echo tep_draw_radio_field('gender','male','m') . '&nbsp;&nbsp;' . MALE . '&nbsp;&nbsp;' . tep_draw_radio_field('gender','female','f') . '&nbsp;&nbsp;' . FEMALE . '&nbsp;&nbsp;' . tep_draw_radio_field('gender','mlle','l') . '&nbsp;&nbsp;' . MLLE .'&nbsp;' . (tep_not_null(ENTRY_GENDER_TEXT) ? '<span class="notice">' . ENTRY_GENDER_TEXT . '</span>': ''); ?>
          <?php $page->messageStack->_draw_inline('gender'); ?>
        </p>
      <?php endif; ?>
      <p>
        <label for="firstname"><?php echo ENTRY_FIRST_NAME; ?></label>
        <?php echo tep_draw_input_field('firstname','firstname') . '&nbsp;' . (tep_not_null(ENTRY_FIRST_NAME_TEXT) ? '<span class="notice">' . ENTRY_FIRST_NAME_TEXT . '</span>': ''); ?>
        <?php $page->messageStack->_draw_inline('firstname'); ?>
      </p>
      <p>
        <label for="lastname"><?php echo ENTRY_LAST_NAME; ?></label>
        <?php echo tep_draw_input_field('lastname','lastname') . '&nbsp;' . (tep_not_null(ENTRY_LAST_NAME_TEXT) ? '<span class="notice">' . ENTRY_LAST_NAME_TEXT . '</span>': ''); ?>
        <?php $page->messageStack->_draw_inline('lastname'); ?>
      </p>
      <?php if (_cst_bool('ACCOUNT_DOB')) { ?>
        <p>
          <label for="dob"><?php echo ENTRY_DATE_OF_BIRTH; ?></label>
          <?php echo tep_draw_input_field('dob','dob') . '&nbsp;' . (tep_not_null(ENTRY_DATE_OF_BIRTH_TEXT) ? '<span class="notice">' . ENTRY_DATE_OF_BIRTH_TEXT . '</span>': ''); ?>
          <?php $page->messageStack->_draw_inline('dob'); ?>
        </p>
      <?php } ?>
      <p>
        <label for="email_address"><?php echo ENTRY_EMAIL_ADDRESS; ?></label>
        <?php echo tep_draw_input_field('email_address','email_address') . '&nbsp;' . (tep_not_null(ENTRY_EMAIL_ADDRESS_TEXT) ? '<span class="notice">' . ENTRY_EMAIL_ADDRESS_TEXT . '</span>': ''); ?>
        <?php $page->messageStack->_draw_inline('email_address'); ?>
      </p>
    </fieldset>

    <?php if (_cst_bool('ACCOUNT_COMPANY')): ?>
      <fieldset>
        <legend><?php echo CATEGORY_COMPANY; ?></legend>
        <p>
          <label for="company"><?php echo ENTRY_COMPANY; ?></label>
          <?php echo tep_draw_input_field('company','company') . '&nbsp;' . (tep_not_null(ENTRY_COMPANY_TEXT) ? '<span class="notice">' . ENTRY_COMPANY_TEXT . '</span>': ''); ?>
        </p>
        <p>
          <label for="company"><?php echo ENTRY_COMPANY_TAX_ID; ?></label>
          <?php echo tep_draw_input_field('company_tax_id','company_tax_id') . '&nbsp;' . (tep_not_null(ENTRY_COMPANY_TAX_ID_TEXT) ? '<span class="notice">' . ENTRY_COMPANY_TAX_ID_TEXT . '</span>': ''); ?>
        </p>
      </fieldset>
    <?php  endif; ?>

    <fieldset>
      <legend><?php echo CATEGORY_ADDRESS; ?></legend>
      <p>
        <label for="street_address"><?php echo ENTRY_STREET_ADDRESS; ?></label>
        <?php echo tep_draw_input_field('street_address','street_address') . '&nbsp;' . (tep_not_null(ENTRY_STREET_ADDRESS_TEXT) ? '<span class="notice">' . ENTRY_STREET_ADDRESS_TEXT . '</span>': ''); ?>
        <?php $page->messageStack->_draw_inline('street_address'); ?>
      </p>
      <?php if (_cst_bool('ACCOUNT_SUBURB')): ?>
        <p>
          <label for="suburb"><?php echo ENTRY_SUBURB; ?></label>
          <?php echo tep_draw_input_field('suburb','suburb') . '&nbsp;' . (tep_not_null(ENTRY_SUBURB_TEXT) ? '<span class="notice">' . ENTRY_SUBURB_TEXT . '</span>': ''); ?>
        </p>
      <?php endif; ?>
      <p>
        <label for="postcode"><?php echo ENTRY_POST_CODE; ?></label>
        <?php echo tep_draw_input_field('postcode','postcode') . '&nbsp;' . (tep_not_null(ENTRY_POST_CODE_TEXT) ? '<span class="notice">' . ENTRY_POST_CODE_TEXT . '</span>': ''); ?>
        <?php $page->messageStack->_draw_inline('postcode'); ?>
      </p>
      <p>
        <label for="city"><?php echo ENTRY_CITY; ?></label>
        <?php echo tep_draw_input_field('city','city') . '&nbsp;' . (tep_not_null(ENTRY_CITY_TEXT) ? '<span class="notice">' . ENTRY_CITY_TEXT . '</span>': ''); ?>
        <?php $page->messageStack->_draw_inline('city'); ?>
      </p>

      <?php if (_cst_bool('ACCOUNT_COUNTRY')): ?>
        <p>
          <label><?php echo ENTRY_COUNTRY; ?></label>
          <?php echo tep_get_country_list('country','country') . '&nbsp;' . (tep_not_null(ENTRY_COUNTRY_TEXT) ? '<span class="notice">' . ENTRY_COUNTRY_TEXT . '</span>': ''); ?>
          <?php $page->messageStack->_draw_inline('country'); ?>
        </p>
      <?php endif; ?>
      <?php if (_cst_bool('ACCOUNT_STATE')): ?>
        <p>
          <label for="state"><?php echo ENTRY_STATE; ?></label>
          <?php
          if ($process == true) {
            if ($entry_state_has_zones == true) {
            $zones_array = array();
            $zones_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' order by zone_name");
            while ($zones_values = tep_db_fetch_array($zones_query)) {
              $zones_array[] = array('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);
            }
            echo tep_draw_pull_down_menu('state','state', $zones_array);
          } else {
            echo tep_draw_input_field('state','state');
          }
          } else {
            echo tep_draw_input_field('state','state');
          }

          if (tep_not_null(ENTRY_STATE_TEXT)) echo '&nbsp;<span class="notice">' . ENTRY_STATE_TEXT . '</span>' . "\n";
          ?>
          <?php $page->messageStack->_draw_inline('state'); ?>
        </p>
      <?php endif; ?>
    </fieldset>

    <fieldset>
      <legend><?php echo CATEGORY_CONTACT; ?></legend>
      <p>
        <label for="telephone"><?php echo ENTRY_TELEPHONE_NUMBER; ?></label>
        <?php echo tep_draw_input_field('telephone','telephone') . '&nbsp;' . (tep_not_null(ENTRY_TELEPHONE_NUMBER_TEXT) ? '<span class="notice">' . ENTRY_TELEPHONE_NUMBER_TEXT . '</span>': ''); ?>
        <?php $page->messageStack->_draw_inline('telephone'); ?>
      </p>
      <?php if (_cst_bool('ACCOUNT_FAXNUM')): ?>
        <p>
          <label for="fax"><?php echo ENTRY_FAX_NUMBER; ?></label>
          <?php echo tep_draw_input_field('fax','fax') . '&nbsp;' . (tep_not_null(ENTRY_FAX_NUMBER_TEXT) ? '<span class="notice">' . ENTRY_FAX_NUMBER_TEXT . '</span>': ''); ?>
        </p>
      <?php endif; ?>
    </fieldset>

      <!-- // BOF Customers extra fields -->
      <?php echo tep_get_extra_fields($customer_id,$languages_id);?>
      <?php $page->messageStack->_draw_inline('extra_fields'); ?>
      <!-- // EOF Customers extra fields -->

    <fieldset>
      <legend><?php echo CATEGORY_OPTIONS; ?></legend>
      <p>
        <label for="newsletter"><?php echo ENTRY_NEWSLETTER; ?></label>
        <?php echo tep_draw_checkbox_field('newsletter','newsletter','1') . '&nbsp;' . (tep_not_null(ENTRY_NEWSLETTER_TEXT) ? '<span class="notice">' . ENTRY_NEWSLETTER_TEXT . '</span>': ''); ?>
      </p>
    </fieldset>
    <fieldset>
      <legend><?php echo CATEGORY_PASSWORD; ?></legend>
      <p>
        <label for="password"><?php echo ENTRY_PASSWORD; ?></label>
        <?php echo tep_draw_password_field('password','password') . '&nbsp;' . (tep_not_null(ENTRY_PASSWORD_TEXT) ? '<span class="notice">' . ENTRY_PASSWORD_TEXT . '</span>': ''); ?>
        <?php $page->messageStack->_draw_inline('password'); ?>
      </p>
      <p>
        <label for="confirmation"><?php echo ENTRY_PASSWORD_CONFIRMATION; ?></label>
        <?php echo tep_draw_password_field('confirmation','confirmation') . '&nbsp;' . (tep_not_null(ENTRY_PASSWORD_CONFIRMATION_TEXT) ? '<span class="notice">' . ENTRY_PASSWORD_CONFIRMATION_TEXT . '</span>': ''); ?>
        <?php $page->messageStack->_draw_inline('confirmation'); ?>
      </p>
    </fieldset>
    <p class="formBt ieExtractFieldset">
      <?php echo tep_draw_hidden_field('action','process'); ?>
      <input type="submit" class="submitBt" value="<?php echo IMAGE_BUTTON_CONTINUE; ?>"  />
    </p>
  </form>
</div>