<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  22/01/11, 20:42
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8

  @brief Page content for view detail products

  NOTE:

    var $product_info contient un array du produit courant
    var $module contient le detail de chaque module sous forme d'object
    var $cart contient le detail du panier courant
*/
  //! element module aca class
  $module=$page->_call('product','ret_modules');
  $i=1;
?>
<div id="productInfo">
  <?php $page->messageStack->_draw('review');?>

<?php if (_test_bool($product_info)) { ?>

  <div class="infoText"><?php echo TEXT_PRODUCT_NOT_FOUND; ?></div>

  <div class="navBt">
    <?php echo '<a class="navBt" href="' . tep_href_link(FILENAME_DEFAULT) . '">' . IMAGE_BUTTON_CONTINUE . '</a>'; ?>
  </div>

<?php } else { ?>

  <h2 class="content title <?php echo $language ;?> productName"><?php echo $product_info['products_name']; ?></h2>

  <?php if (tep_not_null($product_info['products_image'])) { ?>
    <div id="productImagesGlb" class="images">
      <div id="productImage">
	<?php /** Le block principal de l'image du produit.  */ ?>
	<?php if ( ($replace=$page->prop_ctrl('products_image', $product_info['products_image'])) !=false) echo $replace($product_info);
	      else { ?>
	      <script type="text/javascript"><!--
		document.write('<?php echo '<p><a href="' . tep_href_link(FILENAME_POPUP_IMAGE, 'pID=' . $product_info['products_id']) . '" onclick="popupWindow(this.href); return false" >' . tep_image(DIR_WS_IMAGES . $product_info['products_image'], addslashes($product_info['products_name']), $page->_conf_value('HEADING_IMAGE_WIDTH'), $page->_conf_value('HEADING_IMAGE_HEIGHT'), ' id="image_master" ') . '</a></p>'; ?>');
	      //--></script>
	      <noscript>
		<?php echo '<p><a href="' . tep_href_link(DIR_WS_IMAGES . $product_info['products_image']) . '">' . tep_image(DIR_WS_IMAGES . $product_info['products_image'], $product_info['products_name'], $page->_conf_value('HEADING_IMAGE_WIDTH'), $page->_conf_value('HEADING_IMAGE_HEIGHT'), ' id="image_master" ') . '</a><br /><a href="' . tep_href_link(DIR_WS_IMAGES . $product_info['products_image']) . '">' . TEXT_CLICK_TO_ENLARGE . '</a></p>'; ?>
	      </noscript>
	  <?php } ?>
      </div>
      <?php /** Liste des images dans la pile des images du produits (toutes les images) */ ?>
      <div id="productImagelistMini">
	<ul>
	<?php if(is_array($page->product->pile_img)) foreach($page->product->pile_img as $img) : ?>
	  <li>
	  <?php /*if ( ($replace=$page->prop_ctrl('products_image', $img)) !=false) echo $replace($product_info);
		else {*/ ?>
		  <?php echo '<a class="fancy" href="' .  tep_image(DIR_WS_IMAGES . $img, $product_info['products_name'], $page->_conf_value('POPUP_IMAGE_WIDTH'), $page->_conf_value('POPUP_IMAGE_HEIGHT'), "", true) . '" onmouseover="change_image_master(\'' .  tep_image(DIR_WS_IMAGES . $img, $product_info['products_name'],  $page->_conf_value('HEADING_IMAGE_WIDTH'),$page->_conf_value('HEADING_IMAGE_HEIGHT') ,"", true) . '\',\'' .  tep_image(DIR_WS_IMAGES . $img, $product_info['products_name'],$page->_conf_value('POPUP_IMAGE_WIDTH'), $page->_conf_value('POPUP_IMAGE_HEIGHT'), "", true) . '\')" rel="example_group">' . tep_image(DIR_WS_IMAGES . $img, $product_info['products_name'], $page->_conf_value('STACK_IMAGE_WIDTH'), $page->_conf_value('STACK_IMAGE_HEIGHT')) . '</a>'; ?>
	    <?php /*}*/ ?>
	  </li>
	<?php endforeach; ?>
	</ul>
      </div>
    </div>
  <?php } ?>

  <div id="productInfoSpec">
    <p class="productModel"><?php echo $product_info['products_model']; ?></p>
    <p id="price_master" class="productPrice"><?php echo print_products_price_rv($product_info); ?></p>
  </div>

  <?php if (_test_bool($product_info['action']['buy'])): ?>
    <?php echo tep_draw_form('cart_quantity', tep_href_link(FILENAME_PRODUCT_INFO, tep_get_all_get_params(array('action')) . 'action=add_product')); ?>

      <?php /** Aca Attribute Products */ if(isset($module['attributeManager'])) echo $module['attributeManager']->display_view_master($product_info['products_id']);?>

      <p class="formQt"><?php echo TEXT_PREFIX_QTY.tep_draw_input_field('products_quantity', 'products_quantity', '1', 'size="2"'); ?></p>
      <p class="formBt">
	<input class="submitBt" type="submit" value="<?php echo IMAGE_BUTTON_IN_CART; ?>"  />
      </p>
      <p><?php echo tep_draw_hidden_field('products_id', $product_info['products_id']); ?></p>
    </form>
  <?php endif ; ?>

  <?php  if (tep_not_null($product_info['products_url'])) { ?>
    <p id="productUrl"><?php echo sprintf(TEXT_MORE_INFORMATION, tep_href_link(FILENAME_REDIRECT, 'action=url&amp;goto=' . urlencode($product_info['products_url']), 'NONSSL', true, false)); ?></p>
  <?php } ?>

  <?php if ($product_info['products_date_available'] > date('Y-m-d H:i:s')) { ?>
    <p id="productDateAvalaible" class="date"><?php echo sprintf(TEXT_DATE_AVAILABLE, tep_date_long($product_info['products_date_available'])); ?></p>
  <?php } else { ?>
    <p id="productDateAdded" class="date"><?php echo sprintf(TEXT_DATE_ADDED, tep_date_long($product_info['products_date_added'])); ?></p>
  <?php } ?>

  <div id="productInfoBack" class="navBt">
      <?php echo '<a class="navBt" href="javascript: history.go(-1)">' . IMAGE_BUTTON_BACK . '</a>'; ?>
  </div>

<?php } ?>
</div>