<?php
/**
 @licence GPL 2005-2009  The osCSS developers - osCSS Open Source E-commerce
  @package oscss-2 <www http://www.oscss.org>
  @version Rc-3
  @date  21/03/10, 10:10
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @original code Dave Howarth http://www.box25.net sales@box25.net

  Tag Cloud Generator for osCommerce v3.0A4

  @param
    @a int le product_id sinon list tous
 */
function calculCloud($array) {

  require_once(DIR_WS_CLASSES.'tagcloud.php');
  // globalise the database and language
  $page=page::getInstance();
  $DB=Database::getInstance();
  $languages_id=$page->the_var('languages_id');
  // initialise the cloud
  $cloud = new tagCloud();

  if (isset($array['products']) && is_numeric($array['products']) )$type='products';
  elseif (isset($array['content']) && is_numeric($array['content']) )$type='content';
  elseif (isset($array['cPath']))$type='cat';
  else return '';

  switch ($type){
    case 'products': $xhe=" ft.page_id  ='".$array['products']."' and ft.page_type='product'  and  "; break;
    case 'content':  $xhe=" ft.page_id  ='".$array['content']."' and ft.page_type='content'  and  "; break;
    case 'cat': $xhe=" ft.page_id  ='".$page->the_var('current_category_id')."' and ft.page_type='cat' and "; break;
  }
  $Qlisting = $DB->query($sql="select ftd.head_keywords_tag from " . TABLE_FULL_TAG . " ft, "  . TABLE_FULL_TAG_DESCRIPTION .  " ftd where   ".$xhe." ft.tag_id=ftd.tag_id  and   ftd.language_id = '" . (int)$languages_id. "'   order by rand() limit 20");

  while($random = $Qlisting->fetchAssoc()){
    $t=explode(',',$random['head_keywords_tag']);
    foreach($t as $v) $cloud->addWord($v);
  }

  return $cloud->showCloud('array');;
}
/**
  quick function to generate a random text size
*/
function randSize() {
  // create a random number between 8, and 24
  $css = rand(8,28);
  return $css;
}

/**
  quick function to create a random six digit hex color code
*/
function randColor() {
  $str1 = 'abcdef1234567890';
  $tail ='';
  for ($j=0; $j<6; ++$j) {
    $tail .= substr($str1,rand(0,15),1);
  }
  return $tail;
}


/**
  Sortie d'une liste
*/
function generateList($array){
 $myCloud = calculCloud($array);
 $returnData = '';
   if (is_array($myCloud)) {
    foreach ($myCloud as $key => $value) {
    $returnData .= ' <a href="' . tep_href_link(FILENAME_ADVANCED_SEARCH, 'keywords='.str_replace('+',' ',urlencode(strip_tags($value['word']))) ).'">'.$value['word'].'</a> ';
    }
  }
  return $returnData;
}

/**
  @return sortie d'un nuage tag, couleur et taille random
*/
function generateCloud($array) {
  $myCloud = calculCloud($array);
  $returnData = '';
  $tag_style = 'font-family: Verdana, Tahoma, Arial; padding: 4px 4px 4px 4px; letter-spacing: 3px; text-decoration: none; font-weight: normal;';

  if (is_array($myCloud)) {
    foreach ($myCloud as $key => $value) {
    $size = randSize();
    $color = randColor();
    $returnData .= ' <a href="' . tep_href_link(FILENAME_ADVANCED_SEARCH, 'keywords='.str_replace('+',' ',urlencode(strip_tags($value['word']))) ).'" style="' . $tag_style . 'font-size:' . $size . 'px; color:#' . $color . ';">'.$value['word'].'</a> ';
    }
  }

  return '<div class="moduleBox"><div class="content">' . $returnData . '</div></div>';
}

?>