<?php
/*
  $Id: gzip_compression.php,v 1.2 2005/05/21 17:14:01 manmachine Exp $
+-----------------------------------------------------------------------+
|                  osCSS Open Source E-commerce                         |
+-----------------------------------------------------------------------+
| Copyright (c) 2005 The osCSS developers                               |
|                                                                       |
| http://www.oscss.org                                       |
|                                                                       |
| Portions Copyright (c) 2003 osCommerce                                |
+-----------------------------------------------------------------------+
| This source file is subject to version 2.0 of the GPL license,        |
| available at the following url:                                       |
| http://www.oscss.org/license/2_0.txt.                      |
+-----------------------------------------------------------------------+
*/

  function tep_check_gzip() {
// >>> BEGIN REGISTER_GLOBALS
//    global $HTTP_ACCEPT_ENCODING;
// <<< END REGISTER_GLOBALS
    if (headers_sent() || connection_aborted()) {
      return false;
    }

// >>> BEGIN REGISTER_GLOBALS
    if (strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'x-gzip') !== false) return 'x-gzip';

    if (strpos($_SERVER['HTTP_ACCEPT_ENCODING'],'gzip') !== false) return 'gzip';
// <<< END REGISTER_GLOBALS

    return false;
  }

/* $level = compression level 0-9, 0=none, 9=max */
  function tep_gzip_output($level = 5) {
    if ($encoding = tep_check_gzip()) {
      $contents = ob_get_contents();
      ob_end_clean();

      header('Content-Encoding: ' . $encoding);

      $size = strlen($contents);
      $crc = crc32($contents);

      $contents = gzcompress($contents, $level);
      $contents = substr($contents, 0, strlen($contents) - 4);

      echo "\x1f\x8b\x08\x00\x00\x00\x00\x00";
      echo $contents;
      echo pack('V', $crc);
      echo pack('V', $size);
    } else {
      ob_end_flush();
    }
  }
?>
