<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  22/01/11, 20:23
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
 *\file initialize.php
 *\brief Function de base, appelé en tete de application_top, equivalent preload
	Rassemble les function mini avant chargement appli
*/


/**
  @brief class chargeur autoload by sort level
  @class autoload
  @example
    Add path for level 45
      autoload::addPath(DIR_FS_TEMPLATES.TEMPLATE_NAME.'/'.DIR_WS_CLASSES .'%s.php',4);
*/
class autoload {
  public static $path=array();
  protected static $_instance;

  private function __construct(){
    self::addPath(DIR_FS_CATALOG.DIR_WS_CLASSES .'%s.php');// standard
    self::addPath(DIR_FS_CATALOG.DIR_WS_CLASSES .'page.%s.php'); // page contructeur
    self::addPath(DIR_FS_CATALOG.DIR_WS_CLASSES .'driver.%s.php');  // data ressource type
    self::addPath(DIR_FS_CATALOG.DIR_WS_CLASSES .'osCSS.%s.php');
    self::addPath(DIR_FS_CATALOG.DIR_WS_COMMON_CLASSES .'%s.php');//   Common
  }

  /**
    @brief singeltown call
  */
  public static function getInstance() {
      if(self::$_instance == null) self::$_instance = new self();
      return self::$_instance;
  }

  /**
    @fn getPath($strClassName)
    @brief call in __autoload()
    @param $strClassName
    @return path or false
  */
  public static function getPath($strClassName){
     ksort(self::$path );
    foreach(self::$path as $level => $array)
      foreach($array as $path)
	if (file_exists(sprintf($path,$strClassName )) ){
	  return(sprintf($path,$strClassName ));
	}

    return false;
  }

  /**
    @brief add path for autoload function
    @param $string string for sprintf
    @param $level niveau de priorite
  */
  public static function addPath($string, $level=5){
    self::$path[(int)$level][]=$string;
    ksort(self::$path );
  }
}

/**
  @brief magic function php , load class
  @param $strClassName string
*/
function __autoload($strClassName) {
  autoload::getInstance();
  if( ($path=autoload::getPath($strClassName)) && $path != false) include_once($path);
//   trigger_error(sprintf(__CLASS__.'Could not load class %s', $strClassName), E_USER_ERROR);
}

/**
  \brief Scan a directory and return its files and folders as array
  \original-code TYPOlight Open Source CMS Copyright (C) 2005-2010 Leo Feyer
  \param $strFolder string
  \return array
*/
function scan($strFolder) {
  global $arrScanCache;

  // Add trailing slash
  if (substr($strFolder, -1, 1) != '/') $strFolder .= '/';

  // Load from cache
  if (isset($arrScanCache[$strFolder]))  return $arrScanCache[$strFolder];

  $arrReturn = array();
  // Scan directory
  foreach (scandir($strFolder) as $strFile) {
    if ($strFile == '.' || $strFile == '..') continue;
    $arrReturn[] = $strFile;
  }

  $arrScanCache[$strFolder] = $arrReturn;
  return $arrReturn;
}

/**
  @fn exception_handler()
  @brief Gestionnaire d'exception
*/
function exception_handler() {
   try {
// //         throw new MyException();
	throw new Exception();
    }
    catch (MyException $e) {
//        echo $e->getMessage();
      echo("FATAL:: '{$e->__toString()}')\n{$e}\n" );

    }
    catch (Exception $e) {
        echo $e->getMessage();
//       print_r($e);
    }
}

/**
  \author oscim - OscssTeam
  \brief Test si une constante est défini , si celle-ci existe, renvoi sa valeur, sinon return (string)'false'
*/
function tep_cst_define($text){
    if(defined(strtoupper($text))) return constant(strtoupper($text));
    else return 'false';
}


/**
 * \fn _cst_bool($text)
 * \a string/boolean défini par une constante!
 * \return boolean true/false
*/
function _cst_bool($text){
    if(!tep_not_null($text)) return false;
    $value=tep_cst_define($text);
    if( (is_string($value) && strtoupper($value)=='TRUE')||( is_bool($value) && $value==TRUE)  )  return true;
    elseif( (is_string($value) && (strtoupper($value)=='FALSE'))  || ( is_bool($value) && $value==FALSE)  ) return false;
    return false;
}

/**
 * \fn _test_bool($value)
 * \a string/boolean
 * \return boolean true/false
*/
function _test_bool($value){
  if(!tep_not_null($value)) return false;
  if( (is_string($value) && (strtoupper($value)=='TRUE' || $value=='1' ) )||( is_bool($value) && ($value==TRUE || $value==1) ) || (is_numeric($value) && $value=1)  )  return true;
  elseif( (is_string($value) && (strtoupper($value)=='FALSE'))  || ( is_bool($value) && $value==FALSE)  ) return false;
  return false;
}


/**
  @fn ($file,$name='svn')
  @brief Recuperation des element de svn basé sur le fichier oscss.version.xml
  @param $file  string path file xml oscss.version.xml
  @param $name balise html
  @return content balise xml
*/
function get_info_core($file,$name='svn'){
  if(!file_exists($file)) return die(__("erreur recuperation fichier"));
  $SimpleParser = simplexml_load_file($file);
  if(!isset($SimpleParser->$name)) die(__("erreur recuperation n° revision courant")) ;
  else return $SimpleParser->$name;
}

/**
  @fn __($str)
  @brief Convertion de langue Generation 2
  @param $str string for convert lang
*/
function __($str) {
  global $lang;
  return isset($lang[$str]) ? $lang[$str] : $str;
}

/**
  @fn tep_not_null($value)
  @brief check if is not null value , return boolean
  @param $value string
  @return boolean
*/
function tep_not_null($value) {
  if (is_array($value)) {
    if (sizeof($value) > 0)  return true;
    else  return false;
  } else {
    if (($value != '') && (strtolower($value) != 'null') && (strlen(trim($value)) > 0))  return true;
    else return false;
  }
}
?>