<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  29/08/10, 09:58
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/
if (STORE_SESSIONS == 'mysql') {
  if (constant('SESSION_LIFE_PUBLIC') =='') $SESS_LIFE = 1440;
  else $SESS_LIFE = (SESSION_LIFE_PUBLIC*60);

  function _sess_open($save_path, $session_name) {
    return true;
  }

  function _sess_close() {
    return true;
  }

  function _sess_read($key) {
    $DB=Database::getInstance();
    $value_query = $DB->query("select value from " . TABLE_SESSIONS . " where sesskey = '" . tep_db_input($key) . "' and expiry > '" . time() . "'");
    $value = $value_query->fetchAssoc();

    if (isset($value['value'])) {
      return $value['value'];
    }
    return false;
  }

  function _sess_write($key, $val) {
    global $SESS_LIFE;
    $DB=Database::getInstance();

    $expiry = time() + $SESS_LIFE;
    $value = $val;

    $check_query = $DB->query("select count(*) as total from " . TABLE_SESSIONS . " where sesskey = '" . tep_db_input($key) . "'");
    $check = $check_query->fetchAssoc();

    if ($check['total'] > 0) {
      $DB->query("update " . TABLE_SESSIONS . " set expiry = '" . tep_db_input($expiry) . "', value = '" . tep_db_input($value) . "' where sesskey = '" . tep_db_input($key) . "'");
      return true;
    } else {
      $DB->query("insert into " . TABLE_SESSIONS . " values ('" . tep_db_input($key) . "', '" . tep_db_input($expiry) . "', '" . tep_db_input($value) . "')");
      return true;
    }
  }

  function _sess_destroy($key) {
    $DB=Database::getInstance();
    $DB->query("delete from " . TABLE_SESSIONS . " where sesskey = '" . tep_db_input($key) . "'");
    return true;
  }

  function _sess_gc($maxlifetime) {
    $DB=Database::getInstance();
    $DB->query("delete from " . TABLE_SESSIONS . " where expiry < '" . time() . "'");

    return true;
  }

  session_set_save_handler('_sess_open', '_sess_close', '_sess_read', '_sess_write', '_sess_destroy', '_sess_gc');
}

function tep_session_start() {
  global $_GET, $_POST, $_COOKIE;

  $sane_session_id = true;

  if (isset($_GET[tep_session_name()])) {
    if (preg_match('/^[a-zA-Z0-9]+$/', $_GET[tep_session_name()]) == false) {
      unset($_GET[tep_session_name()]);

      $sane_session_id = false;
    }
  } elseif (isset($_POST[tep_session_name()])) {
    if (preg_match('/^[a-zA-Z0-9]+$/', $_POST[tep_session_name()]) == false) {
      unset($_POST[tep_session_name()]);

      $sane_session_id = false;
    }
  } elseif (isset($_COOKIE[tep_session_name()])) {
    if (preg_match('/^[a-zA-Z0-9]+$/', $_COOKIE[tep_session_name()]) == false) {
      $session_data = session_get_cookie_params();

      setcookie(tep_session_name(), '', time()-42000, $session_data['path'], $session_data['domain']);

      $sane_session_id = false;
    }
  }

  if ($sane_session_id == false) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT, '', 'NONSSL', false));
    }

    $success = session_start();

    // Work-around to allow disabling of register_globals - map all defined
    // session variables
    if ($success && count($_SESSION))
    {
      $session_keys = array_keys($_SESSION);
      foreach($session_keys as $variable)
      {
        link_session_variable($variable, true);
      }
    }

    return $success;
// <<< END REGISTER_GLOBALS
  }

  function tep_session_register($variable) {
    global $session_started;

    $success = false;

    if ($session_started == true) {
// -skip-   return session_register($variable);

      // Work-around to allow disabling of register_globals - map session variable
      link_session_variable($variable, true);
      $success = true;
    }

    return $success;
  }

  function tep_session_is_registered($variable) {
    return (isset($_SESSION) && array_key_exists($variable,$_SESSION));
  }

  function tep_session_unregister($variable) {
    // Work-around to allow disabling of register_gloabls - unmap session variable
    link_session_variable($variable, false);
    unset($_SESSION[$variable]);

//  return session_unregister($variable);
    return true;

  }


  // Work-around function to allow disabling of register_globals in php.ini
  // This is pretty crude but it works. What it does is map session variables to
  // a corresponding global variable.
  // In this way, the main application code can continue to use the existing
  // global varaible names but they are actually redirected to the real session
  // variables
  //
  // If the global variable is already set with a value at the time of the mapping
  // then it is copied over to the real session variable before being mapped back
  // back again
  //
  // Parameters:
  // var_name - Name of session variable
  // map - true = map variable, false = unmap varaible
  //
  // Returns:
  // None
  function link_session_variable($var_name, $map)
  {
    if ($map)
    {
      // Map global to session variable. If the global variable is already set to some value
      // then its value overwrites the session varibale. I **THINK** this is correct behaviour
      /* if (isset($GLOBALS[$var_name]))
      {
        $_SESSION[$var_name] = $GLOBALS[$var_name];
      }

      $GLOBALS[$var_name] =& $_SESSION[$var_name]; */
      if (array_key_exists($var_name,$GLOBALS)) {
        $_SESSION[$var_name] =& $GLOBALS[$var_name];
      } else {
        $GLOBALS[$var_name] =& $_SESSION[$var_name];
      }
    }
    else
   {
      // Unmap global from session variable (note that the global variable keeps the value of
      // the session variable. This should be unnecessary but it reflects the same behaviour
      // as having register_globals enabled, so in case the OSC code assumes this behaviour,
      // it is reproduced here
      $nothing = 0;
      $GLOBALS[$var_name] =& $nothing;
      unset($GLOBALS[$var_name]);
      $GLOBALS[$var_name] = @$_SESSION[$var_name];
    }
  }


function tep_session_id($sessid = '') {
  if (!empty($sessid)) return session_id($sessid);
  else  return session_id();
}

function tep_session_name($name = '') {
  if (!empty($name))  return session_name($name);
  else   return session_name();
}


/**
* @package oscss
*/
function tep_session_close() {
  if (isset($_SESSION) && count($_SESSION)) {
    $session_keys = array_keys($_SESSION);
    foreach($session_keys as $variable) {
      link_session_variable($variable, false);
    }
  }

  @session_write_close();
}

function tep_session_destroy() {
  if (count($_SESSION)) {
    $session_keys = array_keys($_SESSION);
    foreach($session_keys as $variable) {
      link_session_variable($variable, false);
      unset($_SESSION[$variable]);
    }
  }

  return @session_destroy();
}

function tep_session_save_path($path = DIR_FS_SESSIONS) {
  if (STORE_SESSIONS == 'mysql') return false;
  if (!empty($path)) return session_save_path($path);
  else  return session_save_path();
}

function tep_session_recreate() {
  $session_backup = $_SESSION;
  unset($_COOKIE[tep_session_name()]);
  tep_session_destroy();
  if (STORE_SESSIONS == 'mysql')  session_set_save_handler('_sess_open', '_sess_close', '_sess_read', '_sess_write', '_sess_destroy', '_sess_gc');
  session_start();
  $_SESSION = $session_backup;
  // Work-around to allow disabling of register_globals - map all defined
  // session variables
  if (count($_SESSION)) {
    $session_keys = array_keys($_SESSION);
    foreach($session_keys as $variable) {
      link_session_variable($variable, true);
    }
  }
  unset($session_backup);
}
?>