<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  22/01/11, 22:42
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8

  \file
  \dir includes/functions/
  \brief lib for front template usage, function for display
*/


/**
 * \fn tep_extrac_querystring($query='')
 * \brief Extraction chaine en tableau
 * @param $query string type Query_string
 * @return array key=>value
*/
function tep_extrac_querystring($query=''){
  $s=(!empty($query))?$query : $_SERVER['QUERY_STRING'];

  $r=explode('&',$s);
  foreach($r as $e){
    $i=strpos($e,'=');
    $f[substr($e,0,$i)]=substr($e,($i+1));
  }
  return $f;
}


/**
 * \fn tep_build_tree($tree, $categories_string='',$entry, $last_member = false, $level = 0, $path = '')
 * \brief Specific boxes categories_dropdown
 * @param $tree
 * @param $categories_string
 * @param $entry
 * @param $last_member
 * @param $level
 * @param $path
 */
function tep_build_tree($tree, $categories_string='',$entry, $last_member = false, $level = 0, $path = '') {
 global $page;
  $prefix = '';
  $pinc = '';
  if(empty($cpath))$cPath=$page->the_var('cPath');


  for ($i = 0; $i <= $level; $i++) {
    $prefix .= ' ';
  }

  if (_cst_bool('SHOW_COUNTS'))
    $pinc = (($products_in_category=tep_count_products_in_category($entry)) >0)? ' (' . $products_in_category . ')' : '';


  if ($path == '')  $new_path = $entry;
  else $new_path = $path . '_' . $entry;

  $categories_string .= $prefix . '<li><a href="' . tep_href_link(FILENAME_DEFAULT, 'cPath=' . $new_path) . '">'. addslashes($tree[$entry]['name']) . $pinc .'</a>';

      $array_size = sizeof($tree[$entry]['children']);
  if ($array_size > 0) {
    $categories_string .= "\n" . '<ul class="cats">' . "\n";
    $children = $tree[$entry]['children'];
    reset($children);
    end($children);
    $end_key = key($children);
    reset($children);
    while (list($key, $new_entry) = each($children)) {
      $new_last_member = ($key == $end_key) ? true : false;
      $categories_string = tep_build_tree($tree, $categories_string,$new_entry, $new_last_member, $level + 1, $new_path);
    }
    $categories_string .= $prefix;
    $categories_string .= ($last_member == true) ? '</li>'. "\n" . '</ul>' : '</li>';
    $categories_string .= "\n";
  } else {
    $categories_string .= ($last_member == true) ? '</li>'. "\n" . '</ul>' : '</li>';
    $categories_string .= "\n";
  }

  return $categories_string;
}


/**
 * \fn in_menu_info($format='  <li class="informationBox"><a href="%s">%s</a></li>')
 * \brief   Construit liste des page content de "class" (informationBox_)
 * @param  $format string for printf
 * @return string
*/
function in_menu_info($format='  <li class="informationBox"><a href="%s">%s</a></li>'){
  global $template,$page;
  $s='';
  $language=$page->the_var('language');
  $content_query=content::get_query('','informationBox_','',array('limit'=>20));
  if($content_query ==false) return false;

  foreach($content_query as $content)
    $s.= sprintf($format."\n",$content->href,$content->title);

  return $s;
}

/**
 * \fn in_menu_cat($arg=array())
 * \brief Consrtuit la liste des categories
 * @param $arg string  catID=1&max_level=1
 */
function in_menu_cat($arg=array()){
  global $page;
  $cf=tep_extrac_querystring($arg);
  $max_level=(isset($cf['max_level'])? $cf['max_level'] : 1);
  $catID=(isset($cf['catID'])? $cf['catID'] : 0);
  $ParentGroupString=(isset($cf['ParentGroupString'])? $cf['ParentGroupString'] : '');

  $osC_CategoryTree = new category_tree();

    if(!empty($ParentGroupString)) $osC_CategoryTree->setParentGroupString('<'.$ParentGroupString.'>'."\n", '</'.$ParentGroupString.'>'."\n");
    else $osC_CategoryTree->setParentGroupString(''."\n", ''."\n");

  $osC_CategoryTree->setChildString('<li %s>', '</li>'."\n");
  $osC_CategoryTree->setRootString('<li %s>', '</li>'."\n");
  $osC_CategoryTree->setSpacerString(' ', 1);
  $osC_CategoryTree->setMaximumLevel($max_level);
  $osC_CategoryTree->setCategoryProductCountString(' (',')');

  return $osC_CategoryTree->buildTree($catID) ;
}

/**
 * \fn templ_draw_list($arg=array())
 * \brief
  	Consrtuit L'appel et l'incrementation de la pile,
  	utilisé dans les boucles de module, boxes et plugin du template
 * @param $arg array , catID=1&max_level=1
 * @return object
*/
function templ_draw_list($arg=array()){
  global $page;
  $cf=tep_extrac_querystring($arg);
  $sortie=array();
  $pile=(isset($cf['pile'])? $cf['pile'] : 'center'); /* center, rght, left */
  $type=(isset($cf['type'])? $cf['type'] : 'modules'); /* modules, boxes */
  $methode='oscss_'.$type;
  $page->pos_init($type,$pile,$page->$methode->_call('',$pile));
  $key=$page->pos_next($type,$pile);

  return TempModRes('type='.$type.'&key='.$key);
}

/**
 * \fn TempModRes($arg=array())
 * \brief return object current in pile
 * @param $arg array key=>value
*/
function TempModRes($arg=array()){
  global $page;
  $cf=tep_extrac_querystring($arg);

  $sortie=array();
  $type=(isset($cf['type'])? $cf['type'] : 'modules'); /* modules, boxes */
  $methode='oscss_'.$type;
  if(!isset($cf['key'])) return false;
  $key=$cf['key'] ;

  $mo =$page->$methode->_return($key);

  if(is_array($mo) && !isset($mo['result_sql'])) $page->$methode->_call($key);
  elseif(is_object($mo) && !isset($mo->result_sql)) $page->$methode->_call($key);

  if(( $mod=$page->$methode->_in_obj($mo)) !=false){

    if(is_array($mo)) {
      $sortie['id']=$mo['name_clean'].'Box';
      $sortie['css_class']=$key.' '.$mo['name_clean'];
      $sortie['key']=$key;
      $sortie['template']=$type.'.php';
      $sortie['module_db']=$mod;
      return new objectInfo($sortie);
    }elseif(is_object($mo)) {
      return $mo;
    }
    else  return false;
  }
  else  return false;
}

/**
 * \fn the_description($mod='desc_base')
 * \brief Specific Products Display desc min by module type products, desc_base
 * @param $mod string module name
 * @return string module->content
*/
function the_description($mod='desc_base'){
  global $module;
  if(!isset($module[$mod])) return;
  $ele=$module[$mod]->display_view($_GET['products_id']);
  return unhtmlentities($ele[0]->content);
}
?>