<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  16/09/10, 22:15
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/
// look in your $PATH_LOCALE/locale directory for available locales
// or type locale -a on the server.
// Examples:
// on RedHat try 'en_US'
// on FreeBSD try 'en_US.ISO_8859-1'
// on Windows try 'en', or 'English'
@setlocale(LC_TIME, 'fr_FR.UTF-8');

define('DATE_FORMAT_SHORT', '%d/%m/%Y');  // this is used for tep_strftime()
define('DATE_FORMAT_LONG', '%A %d %B %Y'); // this is used for tep_strftime()
define('DATE_FORMAT', 'd/m/Y'); // this is used for date()
define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');

if(function_exists('date_default_timezone_set')) date_default_timezone_set('Europe/Paris');

////
// Return date in raw format
// $date should be in format mm/dd/yyyy
// raw date is in format YYYYMMDD, or DDMMYYYY
function tep_date_raw($date, $reverse = false) {
  if ($reverse) {
    return substr($date, 0, 2) . substr($date, 3, 2) . substr($date, 6, 4);
  } else {
    return substr($date, 6, 4) . substr($date, 3, 2) . substr($date, 0, 2);
  }
}

// Liste du nom des mois version française //
define('NameOf_MONTH_01', 'janvier');
define('NameOf_MONTH_02', 'février');
define('NameOf_MONTH_03', 'mars');
define('NameOf_MONTH_04', 'avril');
define('NameOf_MONTH_05', 'mai');
define('NameOf_MONTH_06', 'juin');
define('NameOf_MONTH_07', 'juillet');
define('NameOf_MONTH_08', 'août');
define('NameOf_MONTH_09', 'septembre');
define('NameOf_MONTH_10', 'octobre');
define('NameOf_MONTH_11', 'novembre');
define('NameOf_MONTH_12', 'décembre');
define('NameOf_MONTH_MINI_01', 'jan.');
define('NameOf_MONTH_MINI_02', 'fév.');
define('NameOf_MONTH_MINI_03', 'mar.');
define('NameOf_MONTH_MINI_04', 'avr.');
define('NameOf_MONTH_MINI_05', 'mai');
define('NameOf_MONTH_MINI_06', 'juin');
define('NameOf_MONTH_MINI_07', 'juil.');
define('NameOf_MONTH_MINI_08', 'août');
define('NameOf_MONTH_MINI_09', 'sept.');
define('NameOf_MONTH_MINI_10', 'oct.');
define('NameOf_MONTH_MINI_11', 'nov.');
define('NameOf_MONTH_MINI_12', 'déc.');
// --- //

// Liste du nom des jours version française //
define('NameOf_DAY_1', 'lundi');
define('NameOf_DAY_2', 'mardi');
define('NameOf_DAY_3', 'mercredi');
define('NameOf_DAY_4', 'jeudi');
define('NameOf_DAY_5', 'vendredi');
define('NameOf_DAY_6', 'samedi');
define('NameOf_DAY_0', 'dimanche');
define('NameOf_DAY_MINI_1', 'lun.');
define('NameOf_DAY_MINI_2', 'mar.');
define('NameOf_DAY_MINI_3', 'mer.');
define('NameOf_DAY_MINI_4', 'jeu.');
define('NameOf_DAY_MINI_5', 'ven.');
define('NameOf_DAY_MINI_6', 'sam.');
define('NameOf_DAY_MINI_0', 'dim.');
// --- //

// if USE_DEFAULT_LANGUAGE_CURRENCY is true, use the following currency, instead of the applications default currency (used when changing language)
define('LANGUAGE_CURRENCY', 'EUR');

// Global entries for the <html> tag
define('HTML_PARAMS','xml:lang="fr" lang="fr" dir="ltr"');

// charset for web pages and emails
define('CHARSET', 'utf-8');

// Class to select and format correct product price
define('TAX_SYMBOL','TTC');
define('NOTAX_SYMBOL','HT');

// Define your email address to appear on all pages
define('HEAD_REPLY_TAG_ALL',STORE_OWNER_EMAIL_ADDRESS);

// header text in includes/header.php
define('HEADER_TITLE_CREATE_ACCOUNT', 'Créer un compte');
define('HEADER_TITLE_MY_ACCOUNT', 'Mon compte');
define('HEADER_TITLE_CART_CONTENTS', 'Voir mon panier');
define('HEADER_TITLE_CHECKOUT', 'Commander');
define('HEADER_TITLE_TOP', 'Accueil');
define('HEADER_TITLE_CATALOG', 'Catalogue');
define('HEADER_TITLE_LOGOFF', 'Fermeture de session');
define('HEADER_TITLE_LOGIN', 'Ouverture de session');

// footer text in includes/footer.php
define('FOOTER_TEXT_REQUESTS_SINCE', 'requêtes depuis le');

// text for gender
define('MALE', 'M.');
define('FEMALE', 'M<sup>me</sup>');
define('MLLE', 'M<sup>lle</sup>');
define('MALE_ADDRESS', 'Mr.');
define('FEMALE_ADDRESS', 'Mme.');
define('MLLE_ADDRESS', 'Mlle.');

// text for date of birth example
define('DOB_FORMAT_STRING', 'jj/mm/aaaa');

// login box text in includes/boxes/login_box.php
define('BOX_HEADING_LOGIN_BOX', 'Votre compte');
define('BOX_LOGIN_LINK1', 'Mon compte');
define('BOX_LOGIN_LINK2', 'Historique des commandes');
define('BOX_LOGIN_LINK3', 'Modifier mon compte');
define('BOX_LOGIN_LINK4', 'Carnet d\'adresses');
define('BOX_LOGIN_LINK5', 'Fermeture de session');

define('BOX_HEADING_SELECTIONS', 'Selection');

// categories box text in includes/boxes/categories.php
define('BOX_HEADING_CATEGORIES', 'Catégories');

// reviews box text in includes/boxes/reviews.php
define('BOX_HEADING_REVIEWS', 'Critiques');
define('BOX_REVIEWS_WRITE_REVIEW', 'écrire un commentaire pour ce produit !');
define('BOX_REVIEWS_NO_REVIEWS', 'Il n\'y a actuellement aucun commentaires pour ce produit');
define('BOX_REVIEWS_TEXT_OF_5_STARS', '%s sur 5 étoiles !');

// notifications box text in includes/boxes/products_notifications.php
define('BOX_HEADING_NOTIFICATIONS', 'Notifications');
define('BOX_NOTIFICATIONS_NOTIFY', 'Me prévenir des mises à jour de <strong>%s</strong>');
define('BOX_NOTIFICATIONS_NOTIFY_REMOVE', 'Ne plus me prévenir des mises à jour de <strong>%s</strong>');

// information box text in includes/boxes/information.php
define('BOX_HEADING_INFORMATION', 'Informations');
define('BOX_INFORMATION_PRIVACY', 'Vie privée');
define('BOX_INFORMATION_CONDITIONS', 'Conditions d\'utilisation');
define('BOX_INFORMATION_SHIPPING', 'Expédition &amp; retours');
define('BOX_INFORMATION_CONTACT', 'Contactez-nous');
define('BOX_INFORMATION_SITEMAP', 'Plan du site');
define('BOX_INFORMATION_TEMPLATE', 'Template');

// featured box text in includes/boxes/featured.php
define('BOX_CATALOG_FEATURED_PRODUCTS', 'Prod. recommandés');
define('BOX_HEADING_FEATURED', 'Recommandés');


// checkout procedure text
define('CHECKOUT_BAR_DELIVERY', 'Information de livraison');
define('CHECKOUT_BAR_PAYMENT', 'Information de paiement');
define('CHECKOUT_BAR_CONFIRMATION', 'Confirmation');
define('CHECKOUT_BAR_FINISHED', 'Fini !');

// pull down default text
define('PULL_DOWN_DEFAULT', 'Choisissez');
define('TYPE_BELOW', 'Tapez ci-dessous');

// javascript messages
define('JS_ERROR', 'Des erreurs sont survenues durant le traitement de votre formulaire.Veuillez effectuer les corrections suivantes :');

define('JS_ERROR_NO_PAYMENT_MODULE_SELECTED', 'Veuillez choisir une méthode de paiement pour votre commande.\n');

define('JS_ERROR_SUBMITTED', 'Ce formulaire a déjà été soumis. Veuillez appuyer sur Ok et attendez jusqu\'à ce que le traitement soit fini.');

define('ERROR_NO_PAYMENT_MODULE_SELECTED', 'Veuillez choisir une méthode de paiement pour votre commande.');

define('CATEGORY_COMPANY', 'Détails sociétés');
define('CATEGORY_PERSONAL', 'Vos informations personnelles');
define('CATEGORY_ADDRESS', 'Votre adresse');
define('CATEGORY_CONTACT', 'Votre adresse');
define('CATEGORY_OPTIONS', 'Options');
define('CATEGORY_PASSWORD', 'Votre mot de passe');

define('ENTRY_COMPANY', 'Nom de la société :');
define('ENTRY_COMPANY_ERROR', '');
define('ENTRY_COMPANY_TEXT', '');
define('ENTRY_COMPANY_TAX_ID', 'Société Num Tva');
define('ENTRY_COMPANY_TAX_ID_ERROR', '');
define('ENTRY_COMPANY_TAX_ID_TEXT', '');
define('ENTRY_GENDER', 'Civilité :');
define('ENTRY_GENDER_ERROR', 'Veuillez choisir votre genre.');
define('ENTRY_GENDER_TEXT', '*');
define('ENTRY_FIRST_NAME', 'Prénom :');
define('ENTRY_FIRST_NAME_ERROR', 'Votre prénom doit contenir un minimum de ' . ENTRY_FIRST_NAME_MIN_LENGTH . ' caractères.');
define('ENTRY_FIRST_NAME_TEXT', '*');
define('ENTRY_LAST_NAME', 'Nom :');
define('ENTRY_LAST_NAME_ERROR', 'Votre nom doit contenir un minimum de ' . ENTRY_LAST_NAME_MIN_LENGTH . ' caractères.');
define('ENTRY_LAST_NAME_TEXT', '*');
define('ENTRY_DATE_OF_BIRTH', 'Date de naissance :');
define('ENTRY_DATE_OF_BIRTH_ERROR', 'Votre date de naissance doit avoir ce format : JJ/MM/AAAA (ex. 21/05/1970)');
define('ENTRY_DATE_OF_BIRTH_TEXT', '* (ex. 21/05/1970)');
define('ENTRY_EMAIL_ADDRESS', 'Adresse e-mail :');
define('ENTRY_EMAIL_ADDRESS_ERROR', 'Votre adresse e-mail doit contenir un minimum de ' . ENTRY_EMAIL_ADDRESS_MIN_LENGTH . ' caractères.');
define('ENTRY_EMAIL_ADDRESS_CHECK_ERROR', 'Votre adresse e-mail ne semble pas être valide - veuillez effectuer toutes les corrections nécessaires.');
define('ENTRY_EMAIL_ADDRESS_ERROR_EXISTS', 'Votre adresse e-mail est déjà enregistrée sur notre site - Veuillez ouvrir une session avec cette adresse e-mail ou créez un compte avec une adresse différente.');
define('ENTRY_EMAIL_ADDRESS_TEXT', '*');
define('ENTRY_STREET_ADDRESS', 'Adresse :');
define('ENTRY_STREET_ADDRESS_ERROR', 'Votre adresse doit contenir un minimum de ' . ENTRY_STREET_ADDRESS_MIN_LENGTH . ' caractères.');
define('ENTRY_STREET_ADDRESS_TEXT', '*');
define('ENTRY_SUBURB', 'Complément d\'adresse :');
define('ENTRY_SUBURB_ERROR', '');
define('ENTRY_SUBURB_TEXT', '');
define('ENTRY_POST_CODE', 'Code postal :');
define('ENTRY_POST_CODE_ERROR', 'Votre code postal doit contenir un minimum de ' . ENTRY_POSTCODE_MIN_LENGTH . ' caractères.');
define('ENTRY_POST_CODE_TEXT', '*');
define('ENTRY_CITY', 'Ville: ');
define('ENTRY_CITY_ERROR', 'Votre ville doit contenir un minimum de ' . ENTRY_CITY_MIN_LENGTH . ' caractères.');
define('ENTRY_CITY_TEXT', '*');
define('ENTRY_STATE', 'état/Département :');
define('ENTRY_STATE_ERROR', 'Votre état doit contenir un minimum de ' . ENTRY_STATE_MIN_LENGTH . ' caractères.');
define('ENTRY_STATE_ERROR_SELECT', 'Veuillez choisir un état à partir de la liste déroulante.');
define('ENTRY_STATE_TEXT', '*');
define('ENTRY_COUNTRY', 'Pays :');
define('ENTRY_COUNTRY_ERROR', 'Veuillez choisir un pays à partir de la liste déroulante.');
define('ENTRY_COUNTRY_TEXT', '*');
define('ENTRY_TELEPHONE_NUMBER', 'Numéro de téléphone :');
define('ENTRY_TELEPHONE_NUMBER_ERROR', 'Votre numéro de téléphone doit contenir un minimum de ' . ENTRY_TELEPHONE_MIN_LENGTH . ' caractères.');
define('ENTRY_TELEPHONE_NUMBER_TEXT', '*');
define('ENTRY_FAX_NUMBER', 'Numéro de fax :');
define('ENTRY_FAX_NUMBER_ERROR', '');
define('ENTRY_FAX_NUMBER_TEXT', '');
define('ENTRY_NEWSLETTER', 'Bulletin d\'information :');
define('ENTRY_NEWSLETTER_TEXT', '');
define('ENTRY_NEWSLETTER_YES', 'S\'abonner');
define('ENTRY_NEWSLETTER_NO', 'Ne pas s\'abonner');
define('ENTRY_NEWSLETTER_ERROR', '');
define('ENTRY_PASSWORD', 'Mot de passe :');
define('ENTRY_PASSWORD_ERROR', 'Votre mot de passe doit contenir un minimum de ' . ENTRY_PASSWORD_MIN_LENGTH . ' caractères.');
define('ENTRY_PASSWORD_ERROR_NOT_MATCHING', 'Le mot de passe de confirmation doit être identique à votre mot de passe.');
define('ENTRY_PASSWORD_TEXT', '*');
define('ENTRY_PASSWORD_CONFIRMATION', 'Confirmation du mot de passe :');
define('ENTRY_PASSWORD_CONFIRMATION_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT', 'Mot de passe actuel :');
define('ENTRY_PASSWORD_CURRENT_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT_ERROR', 'Votre mot de passe doit contenir un minimum de ' . ENTRY_PASSWORD_MIN_LENGTH . ' caractères.');
define('ENTRY_PASSWORD_NEW', 'Nouveau mot de passe :');
define('ENTRY_PASSWORD_NEW_TEXT', '*');
define('ENTRY_PASSWORD_NEW_ERROR', 'Votre nouveau mot de passe doit contenir un minimum de ' . ENTRY_PASSWORD_MIN_LENGTH . ' caractères.');
define('ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING', 'Le mot de passe de confirmation doit être identique à votre nouveau mot de passe.');
define('PASSWORD_HIDDEN', '--CACHE--');

define('FORM_REQUIRED_INFORMATION', '* Information requise');
define('TEXT_FIELD_REQUIRED', FORM_REQUIRED_INFORMATION);

// constants for use in tep_prev_next_display function
define('TEXT_RESULT_PAGE', 'Pages de résultat :');
define('TEXT_DISPLAY_NUMBER_OF', 'Afficher <strong>%d</strong> à <strong>%d</strong> (sur <strong>%d</strong>)');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS', TEXT_DISPLAY_NUMBER_OF);
define('TEXT_DISPLAY_NUMBER_OF_ORDERS', TEXT_DISPLAY_NUMBER_OF);
define('TEXT_DISPLAY_NUMBER_OF_REVIEWS', TEXT_DISPLAY_NUMBER_OF);
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW', TEXT_DISPLAY_NUMBER_OF);
define('TEXT_DISPLAY_NUMBER_OF_SPECIALS', TEXT_DISPLAY_NUMBER_OF);

define('PREVNEXT_TITLE_FIRST_PAGE', 'Première page');
define('PREVNEXT_TITLE_PREVIOUS_PAGE', 'Page précédente');
define('PREVNEXT_TITLE_NEXT_PAGE', 'Page suivante');
define('PREVNEXT_TITLE_LAST_PAGE', 'Dernière page');
define('PREVNEXT_TITLE_PAGE_NO', 'Page %d');
define('PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE', 'Ensemble précédent de %d pages');
define('PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE', 'Ensemble suivant de %d pages');
define('PREVNEXT_BUTTON_FIRST', '&lt;&lt;PREMIER');
define('PREVNEXT_BUTTON_PREV', '[&lt;&lt;&nbsp;Préc.]');
define('PREVNEXT_BUTTON_NEXT', '[Suiv.&nbsp;&gt;&gt;]');
define('PREVNEXT_BUTTON_LAST', 'DERNIER&gt;&gt;');

define('IMAGE_BUTTON_ADD_ADDRESS', 'Ajouter une adresse');
define('IMAGE_BUTTON_ADDRESS_BOOK', 'Carnet d\'adresses');
define('IMAGE_BUTTON_BACK', 'Retour');
define('IMAGE_BUTTON_BUY_NOW', 'Acheter maintenant');
define('IMAGE_BUTTON_CHANGE_ADDRESS', 'Changez l\'adresse');
define('IMAGE_BUTTON_CHECKOUT', 'Commander');
define('IMAGE_BUTTON_CONFIRM_ORDER', 'Confirmer la commande');
define('IMAGE_BUTTON_CONTINUE', 'Continuer');
define('IMAGE_BUTTON_CONTINUE_SHOPPING', 'Continuer vos achats');
define('IMAGE_BUTTON_DELETE', 'Supprimer');
define('IMAGE_BUTTON_EDIT_ACCOUNT', 'éditez le compte');
define('IMAGE_BUTTON_HISTORY', 'Historique des commandes');
define('IMAGE_BUTTON_LOGIN', 'Valider');
define('IMAGE_BUTTON_IN_CART', 'Acheter');
define('IMAGE_BUTTON_NOTIFICATIONS', 'Notifications');
define('IMAGE_BUTTON_QUICK_FIND', 'Recherche rapide');
define('IMAGE_BUTTON_REMOVE_NOTIFICATIONS', 'Supprimer les notifications');
define('IMAGE_BUTTON_REVIEWS', 'Critiques');
define('IMAGE_BUTTON_SEARCH', 'Rechercher');
define('IMAGE_BUTTON_SHIPPING_OPTIONS', 'Options d\'expédition');
define('IMAGE_BUTTON_TELL_A_FRIEND', 'Envoyer à un ami');
define('IMAGE_BUTTON_UPDATE', 'Mise à jour');
define('IMAGE_BUTTON_UPDATE_CART', 'Mise à jour du panier');
define('IMAGE_BUTTON_RESET_CART', 'Vider le panier');
define('IMAGE_BUTTON_WRITE_REVIEW', 'écrire une critique');

define('SMALL_IMAGE_BUTTON_DELETE', 'Supprimer');
define('SMALL_IMAGE_BUTTON_EDIT', 'éditer');
define('SMALL_IMAGE_BUTTON_VIEW', 'Afficher');

define('ICON_ARROW_RIGHT', 'plus');
define('ICON_CART', 'Dans le panier');
define('ICON_ERROR', 'Erreur');
define('ICON_SUCCESS', 'Réussi');
define('ICON_WARNING', 'Attention');

define('TEXT_GREETING_PERSONAL', '<span class="greetUser">%s !</span>');
define('TEXT_GREETING_PERSONAL_RELOGON', '<small>Si vous n\'êtes pas %s, merci de vous <a href="%s">reconnecter</a> avec votre compte.</small>');
define('TEXT_GREETING_GUEST', 'Bienvenue <span class="greetUser">visiteur !</span> Voulez vous <a href="%s">ouvrir une session</a> ? Ou préférez vous <a href="%s">créer un compte</a> ?');

define('TEXT_SORT_PRODUCTS', 'Trier les produits ');
define('TEXT_DESCENDINGLY', 'décroissant');
define('TEXT_ASCENDINGLY', 'croissant');
define('TEXT_BY', ' par ');
define('TEXT_SHOW_TYPE', ' Choisir le type ');

define('TEXT_REVIEW_BY', 'par %s');
define('TEXT_REVIEW_WORD_COUNT', '%s mots');
define('TEXT_REVIEW_RATING', 'Classement : %s [%s]');
define('TEXT_REVIEW_DATE_ADDED', 'Date d\'ajout : %s');
define('TEXT_NO_REVIEWS', 'Il n\'y a pour le moment aucune critique sur ce produit.');
define('TEXT_REVIEWS_UNREGISTERED_USER','Vous devez être <a href="%s">enregistré</a> pour commenter un article');

define('TEXT_NO_NEW_PRODUCTS', 'Il n\'y a pour le moment aucun produit.');

define('TEXT_UNKNOWN_TAX_RATE', 'Taux de taxation inconnu');

define('TEXT_REQUIRED', '<strong class="errorText">Requis</strong>');

define('ERROR_TEP_MAIL', '<strong class="errorText">TEP ERROR :</strong> Impossible d\'envoyer l\'e-mail par le serveur SMTP spécifié. Vérifiez le fichier PHP.INI et corrigez le nom du serveur SMTP si nécessaire.');


define('TEXT_CCVAL_ERROR_INVALID_DATE', 'La date d\'expiration entrée pour cette carte de crédit n\'est pas valide. Veuillez vérifier la date et réessayez.');
define('TEXT_CCVAL_ERROR_INVALID_NUMBER', 'Le numéro entrée pour cette carte de crédit n\'est pas valide. Veuillez vérifier le numéro et réessayez.');
define('TEXT_CCVAL_ERROR_UNKNOWN_CARD', 'Le code à 4 chiffres que vous avez entré est : %s. Si ce code est correct, nous n\'acceptons pas ce type de carte de crédit. S\'il est erroné veuillez réessayer.');

define('TABLE_HEADING_QUANTITY', 'Quantité disponible :');
define('TABLE_HEADING_MODEL', 'Modèle');

define('TABLE_HEADING_MANUFACTURER', 'Fabricant :');
define('TABLE_HEADING_PRICE', 'Prix :');
define('TABLE_HEADING_WEIGHT', 'Poids :');
define('TABLE_HEADING_IMAGE', '');
define('TABLE_HEADING_FEATURED_PRODUCTS', 'Produits recommandés');
define('TABLE_HEADING_FEATURED_PRODUCTS_CATEGORY', 'Produits recommandés dans %s');

define('ALERT_CST_MAIN_ABS', 'Afficher un texte en ajoutant un text ayant pour nom: %s');
define('TEXT_PREFIX_QTY', 'Quantité :');
define('BOX_INFORMATION_RETURNS', 'Suivre un retour');

define('SET_AS_PRIMARY', 'Définir comme adresse par defaut');

define('ENTRY_DISCOUNT_COUPON_ERROR', 'Ce code de coupon est invalide');
define('ENTRY_DISCOUNT_COUPON_AVAILABLE_ERROR', 'Le coupon que vous avez utilisé n\'est plus valide');
define('ENTRY_DISCOUNT_COUPON_USE_ERROR', 'Nos dossiers indiquent que vous avez déjà utilisé ce coupon %s fois (s)');
define('ENTRY_DISCOUNT_COUPON_MIN_PRICE_ERROR', 'The minimum order total for this coupon is %s');
define('ENTRY_DISCOUNT_COUPON_MIN_QUANTITY_ERROR', 'The minimum number of products required for this coupon is %s');
define('ENTRY_DISCOUNT_COUPON_EXCLUSION_ERROR', 'Some or all of the products in your cart are excluded.' );
define('ENTRY_DISCOUNT_COUPON', 'Portfeuil disponible/coupon(s):');
define('TABLE_HEADING_COUPON', 'Coupon de réduction:');
define('ENTRY_DISCOUNT_COUPON_SHIPPING_CALC_ERROR', 'Your calculated shipping charges have changed.');

define('PAGE_ACCOUNT', 'Mon compte');
define('PAGE_ACCOUNT_EDIT', 'Édition de compte');
define('PAGE_ADDRESS_BOOK', 'Carnet d\'adresses');
define('PAGE_ACCOUNT_HISTORY', 'Historique d\'achat');
define('PAGE_ACCOUNT_NOTIFICATIONS', 'S\'abonner à la Newsletter');
define('PAGE_SHOPPING_CART', 'Mon panier');
define('PAGE_CHECKOUT_SHIPPING', 'Mes achats');
define('PAGE_ADVANCED_SEARCH', 'Recherche avancée');
define('PAGE_PRODUCTS_NEW', 'Nouveaux produits');
define('PAGE_SPECIALS', 'Promotions');
define('PAGE_REVIEWS', 'Commentaires');
define('PAGE_BEST_SELLERS', 'Les plus achetés');
define('PAGE_SMALL_PRICE', 'Petits prix');

define('TEXT_HEADING_CHILD_PRODUCT', 'Produits de la categorie');
define('HEADING_CHILD_CAT', 'Sous  categorie(s)');

define('ENTRY_NAME_CHECK_ERROR', 'Vous devez preciser votre nom');
/*
  The following copyright announcement can only be
  appropriately modified or removed if the layout of
  the site theme has been modified to distinguish
  itself from the default osCSS-copyrighted
  theme.

  Please leave this comment intact together with the
  following copyright announcement.
*/
define('FOOTER_TEXT_BODY', 'Powered by <a href="http://www.oscss.org" >osCSS-2</a><br />');


?>