<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  03/04/11, 11:48
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @brief module base new products
  @note
      function sql , name: sql_ name current file
      function in_obj_ name: in_obj_ name current file
*/

/**
  @brief Cherche les nouveauté d'ordre general, ou sur le parent de la catégorie en cours
	Ne recupere que que l'id products
  @param $new_products_category_id int
  @return bool false or ressource db
*/
function sql_new_products(){
  global $new_products_category_id;

  $page=page::getInstance();
  $DB=Database::getInstance();
  $languages_id=$page->the_var('languages_id');

  if ( (!empty($new_products_category_id)) || ((int)$new_products_category_id == 0) ) {
    $new_products_query = $DB->query($sql="select distinct p.products_id  from " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_PRODUCTS . " p left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c, " . TABLE_CATEGORIES . " c where p.products_id = p2c.products_id and p2c.categories_id = c.categories_id and p.products_id = pd.products_id and language_id='".$languages_id."' and products_status = '1' and c.categories_status = '1' and p.products_date_added > SUBDATE(now(), INTERVAL  ".(int)MAX_DATEADDED_FOR_NEWX_PRODUCT." DAY)  order by p.products_date_added desc limit " . $page->_conf_value('MAX_DISPLAY_NEW_PRODUCTS'));
  } else {
    $new_products_query = $DB->query($sql="select distinct p.products_id from " . TABLE_PRODUCTS . " p left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c, " . TABLE_CATEGORIES . " c where p.products_id = p2c.products_id and p2c.categories_id = c.categories_id and c.parent_id = '" . (int)$new_products_category_id . "' and p.products_status = '1' and c.categories_status = '1' and p.products_date_added > SUBDATE(now(), INTERVAL  ".(int)MAX_DATEADDED_FOR_NEWX_PRODUCT." DAY)  order by p.products_date_added desc limit " . $page->_conf_value('MAX_DISPLAY_NEW_PRODUCTS'));
  }

  if ($new_products_query->__get('NumRows') > 0) return $new_products_query;
  else return false;
}


/**
  @brief Prepa et passage en object du module, affichage dans le gabarit des modules
  @return array (title, content)
*/
function in_obj_new_products(){

  $page=page::getInstance();

  $languages_id=$page->the_var('languages_id');
  $currencies=$page->return_object('currencies');
  $mod=$page->oscss_modules->_return('product_listing');
  /** init aca module */
  $aca_listing=$page->new_class('listing');
  $p=array();
  if( ($res=$page->oscss_modules->_resultsql('new_products')) ==false ) return null;
  while ($new_products = $res->fetchAssoc()){
    $pd=product::get_item($new_products['products_id']);
    $pd->aca=$aca_listing->return_db_min($new_products['products_id']);
    $p[]=$pd;
  }

  return new objectInfo(array('title'=>sprintf(__('table heading new products'),constant('NameOf_MONTH_'.date('m')) ), 'content'=>$p ));

}

?>