<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  09/01/11, 12:43
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @brief total shipping
*/
class ot_shipping {
  public $title;
  public $output;

  function ot_shipping() {
    $this->code = 'ot_shipping';
    $this->title = MODULE_ORDER_TOTAL_SHIPPING_TITLE;
    $this->description = MODULE_ORDER_TOTAL_SHIPPING_DESCRIPTION;
    $this->sort_order = (defined('MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER')) ? MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER : 3 ;
    $this->enabled = true;

    $this->output = array();
  }

  function process() {
    global $order, $currencies;

    $shipping_cost_ht=0;

    if (_cst_bool('MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING')) {
      switch (MODULE_ORDER_TOTAL_SHIPPING_DESTINATION) {
        case 'national':
          if ($order->delivery['country_id'] == STORE_COUNTRY) $pass = true; break;
        case 'international':
          if ($order->delivery['country_id'] != STORE_COUNTRY) $pass = true; break;
        case 'both':
          $pass = true; break;
        default:
          $pass = false; break;
      }

      if ( ($pass == true) && ( ($order->info['total'] - $order->info['shipping_cost']) >= MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER) ) {
        $order->info['shipping_method'] = FREE_SHIPPING_TITLE;
        $order->info['total'] -= $order->info['shipping_cost'];
        $order->info['shipping_cost'] = $order->info['shipping_cost_ht'] =  0;
      }
    }

    $module = substr($GLOBALS['shipping']['id'], 0, strpos($GLOBALS['shipping']['id'], '_'));


    if (tep_not_null($order->info['shipping_method'])) {
      if ( !_cst_bool('MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING')){
        $shipping_tax = tep_get_tax_rate($GLOBALS[$module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
        $shipping_tax_description = tep_get_tax_description($GLOBALS[$module]->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
      } else {
	$shipping_tax=0;
	$shipping_tax_description='';
      }
        $order->info['tax'] += ($order->info['shipping_cost']-$order->info['shipping_cost_ht']);
        @$order->info['tax_groups']["$shipping_tax_description"] += ($order->info['shipping_cost']-$order->info['shipping_cost_ht']);
        $order->info['total'] += $order->info['shipping_cost'];

        $shipping_cost_ht +=$order->info['shipping_cost_ht'];

        $order->info['subtotal_ht'] += $order->info['shipping_cost_ht'];

      $this->output[] = $b=array('title' => $order->info['shipping_method'] . ':',
                              'text_ht' => $currencies->format($shipping_cost_ht, true, $order->info['currency'], $order->info['currency_value']),
                              'text' => $currencies->format($order->info['shipping_cost'], true, $order->info['currency'], $order->info['currency_value']),
                              'value_ht' => $order->info['shipping_cost_ht'],
                              'value' => $order->info['shipping_cost'],
                                );

    }
  }

  function check() {
    if (!isset($this->_check)) {
      $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_SHIPPING_STATUS'");
      $this->_check = tep_db_num_rows($check_query);
    }

    return $this->_check;
  }

  function keys() {
    return array( 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION');
  }

    function install() {

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de tri', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '2', 'Ordre de tri pour l\'affichage (Le plus petit nombre est montr&eacute; en premier).', '6', '2', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Permettre la livraison gratuite', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'false', 'Voulez vous accepter les livraisons gratuites en fonction du montant ?', '6', '3', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, date_added) values ('Livraison gratuite pour commande au dessus', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', '50', 'Permettre la livraison gratuite pour les commandes au dessus du montant suivant.', '6', '4', 'currencies->format', now())");

      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Attacher livraison gratuite pour les destinations', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 'Livraison gratuite pour des commandes envoy&eacute;s &agrave; l\'ensemble des destinations.<br />(both=tous les deux)', '6', '5', 'tep_cfg_select_option(array(\'national\', \'international\', \'both\',\'none\'), ', now())");
    }

  function remove() { return false;}
}
?>