<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  24/05/10, 21:06
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

class ot_subtotal
  implements InterfaceModule, InterfaceAcaOrderTotal{
  public $title;

  public $output;

  function __construct() {
    $this->code = __CLASS__;
    $this->title = __('module order total subtotal title');
    $this->description = __('module order total subtotal description');
    $this->sort_order = (defined('MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER')) ? MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER : 0;
    $this->enabled = true;
    $this->shopping_cart=true; // active mode process
    $this->output = array();
    $this->pre_output = array();
  }

  /**
     depend checkout_xxx
  */
  public function process() {
    global $order, $currencies;

    $this->output[] = array('title' => $this->title . ':',
                            'text_ht' => $currencies->format($order->info['subtotal_ht'], true, $order->info['currency'], $order->info['currency_value']),
                            'text' => $currencies->format($order->info['subtotal'], true, $order->info['currency'], $order->info['currency_value']),
                            'value_ht' => $order->info['subtotal_ht'],
                            'value' => $order->info['subtotal']
                            );
  }

  /**
    @page/depend/shopping_cart
  */
  public function show_list_total() {
    global  $currencies,  $cart;
    $this->pre_output = new objectInfo(array('text'=>$this->title,
					    'value'=> $cart->ListTotal
					    )
				      );
   ;

    return $this->pre_output;
  }


  /**
   Sepcific for module
  */
  function check() {
    if (!isset($this->_check)) {
      $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS'");
      $this->_check = tep_db_num_rows($check_query);
    }

    return $this->_check;
  }

  function keys() {
    return array(/*'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS',*/ 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER');
  }

    function install() {
//       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Affichage du sous-total', 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true', 'Voulez-vous montrer le sous-total de la commande ?', '6', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de tri', 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '1', 'Ordre de tri pour l\'affichage (Le plus petit nombre est montr&eacute; en premier).', '6', '2', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
}
?>