<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  25/05/10, 18:50
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

class ot_total
  implements InterfaceModule, InterfaceAcaOrderTotal{
  var $title, $output;

  public function __construct() {
    $this->code = __CLASS__;
    $this->title = __('module order total total title');
    $this->description = __('module order total total description');
    $this->sort_order = (defined('MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER')) ? MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER : 5;
    $this->enabled = true;

    $this->output = array();
  }

  public function process() {
    global $order, $currencies;

    $this->output[] = array('title' => $this->title . ':',
                            'text_ht' => '<strong>' . $currencies->format($order->info['total_ht'], true, $order->info['currency'], $order->info['currency_value']) . '</strong>',
                            'text' => '<strong>' . $currencies->format($order->info['total'], true, $order->info['currency'], $order->info['currency_value']) . '</strong>',
                            'value_ht' => $order->info['total_ht'],
                            'value' => round($order->info['total'],2)
                            );
  }

  public function check() {
    if (!isset($this->_check)) {
      $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_TOTAL_STATUS'");
      $this->_check = tep_db_num_rows($check_query);
    }

    return $this->_check;
  }

  public function keys() {
    return array('MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER');
  }

  public function install() {
    tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de tri', 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '4', 'Ordre de tri pour l\'affichage (Le plus petit nombre est montr&eacute; en premier).', '6', '2', now())");
  }

  public function remove() {
    tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
  }
}
?>