<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  19/06/10, 21:35
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

class moneyorder implements InterfaceModule,InterfaceAcaPayment{
  var $code, $title, $description, $enabled;


  public function __construct() {
    global $order;

    $this->code = 'moneyorder';
    $this->title = __('module payment moneyorder text title');
    $this->description = __('module payment moneyorder text description');
    $this->sort_order = (defined('MODULE_PAYMENT_MONEYORDER_SORT_ORDER')? MODULE_PAYMENT_MONEYORDER_SORT_ORDER : 0);
    $this->icon = (tep_not_null('MODULE_PAYMENT_MONEYORDER_ICON')? substr(MODULE_PAYMENT_MONEYORDER_ICON,strlen(DIR_WS_CATALOG))  : '');
    $this->enabled = true;

    if ((int)MODULE_PAYMENT_MONEYORDER_ORDER_STATUS_ID > 0)$this->order_status = MODULE_PAYMENT_MONEYORDER_ORDER_STATUS_ID;

    if (is_object($order)) $this->update_status();

    //! texte supp dans email commande
    $this->email_footer = __('MODULE_PAYMENT_MONEYORDER_TEXT_EMAIL_FOOTER');
  }


  public  function update_status() {
  global $order;

    if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_MONEYORDER_ZONE > 0) ) {
      $check_flag = false;
      $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_MONEYORDER_ZONE . "' and (zone_country_id = '" . $order->delivery['country']['id'] . "' OR zone_country_id ='0') order by zone_id");
      while ($check = tep_db_fetch_array($check_query)) {
	if ($check['zone_id'] < 1) {
	    $check_flag = true;
	    break;
	} elseif ($check['zone_id'] == $order->billing['zone_id']) {
	    $check_flag = true;
	    break;
	}
      }

      if ($check_flag == false)  $this->enabled = false;
    }
  }

  public  function javascript_validation() { return false; }

  public  function selection() {
    return array( 'id' => $this->code,
		  'module' => $this->title,
		  'icon'=>tep_image($this->icon, $this->title)
		);
  }

  public  function pre_confirmation_check() { return false; }

  public  function confirmation() {
    return array('title' => __('module payment moneyorder text title'));
  }

  public  function process_button() { return false; }
  public  function before_process() { return false; }
  public  function after_process() { return false; }

  /**
    Retour des éléments de num order, de order de cheque, et des liens vers account
  */
  public  function payment_succes() {
    $s=__('note succes monyeyorder');
    if(tep_session_is_registered('the_order_formated'))  $s.=sprintf(__('link succes monyeyorder'),$_SESSION['the_order_formated']);
    elseif(tep_session_is_registered('the_order_id')) $s.=sprintf(__('link succes monyeyorder'),$_SESSION['the_order_id']);
    return $s;
  }

  public function get_error() { return false; }

  public function check() {
    $DB=Database::getInstance();
    if (!isset($this->_check)) {
      $check_query = $DB->query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key LIKE 'MODULE_PAYMENT_MONEYORDER%' ");
      if( $check_query->__get('numRows') ==  count($this->keys()) ) $this->_check=true;
      else {
	$this->remove();
	$this->_check=false;
      }
    }
    return $this->_check;
  }

  public  function install() {
    $DB=Database::getInstance();
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('".addslashes(__("Payable à..."))."', 'MODULE_PAYMENT_MONEYORDER_PAYTO', '', '".addslashes(__("A qu'elle ordre doit être effectue le paiement ?"))."', '6', '0', now());");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('".addslashes(__("Ordre de tri"))."', 'MODULE_PAYMENT_MONEYORDER_SORT_ORDER', '0', '".addslashes(__("Ordre de tri pour l'affichage (Le plus petit nombre est montré en premier)."))."', '6', '1', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Zone de paiement', 'MODULE_PAYMENT_MONEYORDER_ZONE', '0', '".addslashes(__("Permettre seulement cette méthode de paiement pour la zone choisie."))."', '6', '2', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('".addslashes(__("Etat de la commande"))."', 'MODULE_PAYMENT_MONEYORDER_ORDER_STATUS_ID', '0', '".addslashes(__("Sélectionner l'état de la commande que vous voulez par défault."))."', '6', '1', 'tep_cfg_pull_down_order_statuses(', 'tep_get_order_status_name', now())");

    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) values ('".__('Icone pour ce mode paiement')."', 'MODULE_PAYMENT_MONEYORDER_ICON', '', '".addslashes(__("Choix d'un icone"))."', '6', '5', 'tep_cfg_choose_img(', NULL, now())");
  }

  public  function remove() {
    $DB=Database::getInstance();
    $DB->query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
  }

  public  function keys() {
    return array( 'MODULE_PAYMENT_MONEYORDER_ZONE', 'MODULE_PAYMENT_MONEYORDER_ORDER_STATUS_ID', 'MODULE_PAYMENT_MONEYORDER_SORT_ORDER', 'MODULE_PAYMENT_MONEYORDER_PAYTO','MODULE_PAYMENT_MONEYORDER_ICON');
  }
}
?>