<?php
/**
  \licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  \portion code Copyright (c) 2002 osCommerce
  \package osCSS-2 <www http://www.oscss.org>
  \version 2.0.9
  \date  24/08/10, 11:16
  \author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  \encode UTF-8
  \class desc_base
  \brief Description product
*/
class desc_base
  extends AbstractProduct
    implements InterfaceModule {

  /**
    Var access in .gab
  */
  public static $products_description;
  /**
   * 
   * @var string
   */
  public static $products_url;

  /**
   * \fn __construct($page='')
   * @param $page
   */
  function __construct($page=''){
    global $page;
    $this->code = __CLASS__;
    $this->title = __('desc base text title');
    $this->description = __('description produit dans la page produit');
    $this->sort_order = (defined('MODULE_ACAPRO_DESC_BASE_SORT_ORDER')) ? MODULE_ACAPRO_DESC_BASE_SORT_ORDER : 0 ;
    $this->enabled = true;

    if(!is_object($page))  return null;
    $this->language_id=$page->the_var('languages_id');
  }

  /**
   *  \fn get_header($action='')
   * @param $action
   */
  function get_header($action=''){
    global $page;
    $this->pID=(int)$_GET['products_id'];
    $this->load_db_values((int)$this->pID);
    //! calcu des images présente et ajout dans la pile des produits
    $c=explode('<img',$this->content['products_description']);
    foreach($c as $l){
      if( (preg_match_all('/src=.([a-zA-Z0-9.:\/_-]*)/i', strip_tags($l) , $match)) !=false){
	$lg=strlen(HTTP_SERVER.DIR_WS_CATALOG.DIR_WS_IMAGES);
	$img=substr($match[1][0], ( (substr($match[1][0],0, $lg)==HTTP_SERVER.DIR_WS_CATALOG.DIR_WS_IMAGES) ? $lg :strlen(DIR_WS_IMAGES) ) );
	if(!in_array( $img,$page->product->pile_img)) $page->product->pile_img[]=$img;
      }
    }
  }

  /**
   * \fn load_db_values($pID)
   * \brief load db for id
   * @param unknown_type $pID
   */
  public function load_db_values($pID){
    $DB=Database::getInstance();
    $product_query = $DB->query("select pd.products_id, pd.language_id, pd.products_name , pd.products_description,pd.products_url from  " . TABLE_PRODUCTS_DESCRIPTION . " pd where  pd.products_id= '" . $pID . "' and language_id='".$this->language_id."' ");
    $this->content=$product_query->fetchAssoc();
  }

  /**
   * \brief display
   * @param $pID int product id 
   * @param $class null
   */
  public function display_view($pID,$class=''){
    $this->load_db_values((int)$pID);

    self::$products_description= $this->content['products_description'];
    self::$products_url= $this->content['products_url'];

    $v=$this->content;
    $v['title']=__('tab products desc base');
    $v['content']=tep_output_string_protected(tep_get_include_contents(__CLASS__.'.'.__FUNCTION__), false, true);

    return array(new objectInfo($v));
  }

/** implements InterfaceModule depend */
  public function check() {}
  public function install() {}
  public function remove() {}
  public function keys() {}
}
?>