<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  09/01/11, 12:42
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/

class flat
 implements InterfaceModule, InterfaceAcaShipping{
  public $code;
  public $title;
  public $description;
  public $icon;
  public $enabled;

  function __construct() {
    $this->code =__CLASS__;
    $this->title = __('module shipping flat text title');
    $this->description = __('module shipping flat text description');
    $this->sort_order = (defined('MODULE_SHIPPING_FLAT_SORT_ORDER')? MODULE_SHIPPING_FLAT_SORT_ORDER : 0) ;
    $this->icon = (tep_not_null('MODULE_SHIPPING_FLAT_ICON')? MODULE_SHIPPING_FLAT_ICON : '');
    $this->tax_class = (defined('MODULE_SHIPPING_FLAT_TAX_CLASS')?MODULE_SHIPPING_FLAT_TAX_CLASS: 0);
    $this->enabled = true;


    global $order;
    if (is_object($order)) $this->update_status($order);
  }

/** Interface InterfaceAcaShipping */
  public function quote($method = '') {
    global $order;


    $this->quotes = array('id' => $this->code,
                          'module' => __('module shipping flat text title in shipping'),
                          'methods' => array(array('id' => $this->code,
					     'tax'=>0,
					    'title' => __('module shipping flat text way'),
					    'cost_ht' => MODULE_SHIPPING_FLAT_COST,
					    'cost' => MODULE_SHIPPING_FLAT_COST))
			    );
    /* Si taxe, on refefini */
    if ($this->tax_class > 0) {
      $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
      $this->quotes['methods'][0]['cost'] = tep_add_tax(MODULE_SHIPPING_FLAT_COST, $this->quotes['tax']);
      $this->quotes['methods'][0]['cost_ht'] = MODULE_SHIPPING_FLAT_COST;
    }

    if (tep_not_null($this->icon)) $this->quotes['icon'] = shipping::get_icon($this->icon, $this->title);

    return $this->quotes;
  }

  /**
  */
  public function update_status($order) {
    if ($this->enabled == true ) {
      $this->enabled = false;
      if ( ((int)MODULE_SHIPPING_FLAT_ZONE > 0) && ((int)MODULE_SHIPPING_FLAT_ZONE == shipping::getGeoZoneID($order->delivery['country']['id'], $order->delivery['zone_id'])) )
	$this->enabled = true;
      elseif ((int)MODULE_SHIPPING_FLAT_ZONE == 0)
	$this->enabled = true;
    }
  }


/** Interface InterfaceModule */
  public function check() {
    if (!isset($this->_check)) {
      $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key LIKE 'MODULE_SHIPPING_FLAT%' ");
	if( tep_db_num_rows($check_query) ==  count($this->keys()) ) $this->_check=true;
	else {
	$this->remove();
	$this->_check=false;
      }
    }
    return $this->_check;
  }

  public function install() {
    $DB=Database::getInstance();
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Coût de livraison', 'MODULE_SHIPPING_FLAT_COST', '5.00', 'Coût de livraison pour tous les commandes en utilisant cette méthode.', '6', '0', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Type de taxe', 'MODULE_SHIPPING_FLAT_TAX_CLASS', '0', 'Employez la classe suivante de taxe sur les coûts de livraison.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Zone de livraison', 'MODULE_SHIPPING_FLAT_ZONE', '0', 'Permettre seulement cette méthode de livraison pour la zone choisie.', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_shipping(', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de tri', 'MODULE_SHIPPING_FLAT_SORT_ORDER', '0', 'Ordre de tri pour l\'affichage (Le plus petit nombre est montré en premier).', '6', '0', now())");

    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added,set_function) values ('".addslashes(__("Icone"))."', 'MODULE_SHIPPING_FLAT_ICON', '', '".addslashes(__("Choix d'un icone"))."', '6', '0', now(),'tep_cfg_choose_img(')");
  }

  public function remove() {
    tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
  }

  public function keys() {
    return array( 'MODULE_SHIPPING_FLAT_COST', 'MODULE_SHIPPING_FLAT_TAX_CLASS', 'MODULE_SHIPPING_FLAT_ZONE', 'MODULE_SHIPPING_FLAT_SORT_ORDER','MODULE_SHIPPING_FLAT_ICON');
  }
}
?>