<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  20/06/10, 15:01
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/
class item
  implements InterfaceModule,InterfaceAcaShipping {
  var $code, $title, $description, $icon, $enabled;

// class constructor
  public function __construct() {
    $this->code = 'item';
    $this->title = __('module shipping item text title');
    $this->description = __('module shipping item text description');
    $this->sort_order = (defined('MODULE_SHIPPING_ITEM_SORT_ORDER;')? MODULE_SHIPPING_ITEM_SORT_ORDER: 0);
    $this->icon = (tep_not_null('MODULE_SHIPPING_ITEM_ICON')? substr(MODULE_SHIPPING_ITEM_ICON,strlen(DIR_WS_CATALOG)) : '');
    $this->tax_class = MODULE_SHIPPING_ITEM_TAX_CLASS;
    $this->enabled =  true ;

    global $order;
    if (is_object($order)) $this->update_status($order);
  }

/** Interface InterfaceAcaShipping */
  public function quote($method = '') {
    global $order, $total_count;

    $this->quotes = array('id' => $this->code,
			  'module' => __('module shipping item text title in shipping'),
			  'methods' => array(array('id' => $this->code,
					    'tax'=>0,
					    'title' => __('module shipping item text way'),
					    'cost_ht' => ((MODULE_SHIPPING_ITEM_COST * $total_count) + MODULE_SHIPPING_ITEM_HANDLING),
					    'cost' => ((MODULE_SHIPPING_ITEM_COST * $total_count) + MODULE_SHIPPING_ITEM_HANDLING) ))
			    );
    /* Si taxe, on refefini */
    if ($this->tax_class > 0) {
      $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
      $this->quotes['methods'][0]['cost'] = tep_add_tax(((MODULE_SHIPPING_ITEM_COST * $total_count) + MODULE_SHIPPING_ITEM_HANDLING), $this->quotes['tax']);
      $this->quotes['methods'][0]['cost_ht'] = ((MODULE_SHIPPING_ITEM_COST * $total_count) + MODULE_SHIPPING_ITEM_HANDLING);
    }
    if (tep_not_null($this->icon)) $this->quotes['icon'] = shipping::get_icon($this->icon, $this->title);

    return $this->quotes;
  }
  /**
  */
  public function update_status($order) {
    if ($this->enabled == true ) {
      $this->enabled = false;
      if ( ((int)MODULE_SHIPPING_ITEM_ZONE > 0) && ((int)MODULE_SHIPPING_ITEM_ZONE == shipping::getGeoZoneID($order->delivery['country']['id'], $order->delivery['zone_id'])) )
	$this->enabled = true;
      elseif ((int)MODULE_SHIPPING_ITEM_ZONE == 0)
	$this->enabled = true;
    }
  }


/** Interface InterfaceModule */

  public function check() {
    $DB=Database::getInstance();
    if (!isset($this->_check)) {
      $check_query = $DB->query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key LIKE 'MODULE_SHIPPING_ITEM%' ");
      if( $check_query->__get('numRows') ==  count($this->keys()) ) $this->_check=true;
      else {
	$this->remove();
	$this->_check=false;
      }
    }
    return $this->_check;
  }

  public function install() {
    $DB=Database::getInstance();
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Co&ucirc;t de livraison', 'MODULE_SHIPPING_ITEM_COST', '2.50', 'Le co&ucirc;t de livraison sera multipli&eacute; par le nombre d\'articles dans la commande employant cette m&eacute;thode.', '6', '0', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Co&ucirc;ts de manutention', 'MODULE_SHIPPING_ITEM_HANDLING', '0', 'Les co&ucirc;ts de manutention pour cette m&eacute;thode de livraison.', '6', '0', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Type de taxe', 'MODULE_SHIPPING_ITEM_TAX_CLASS', '0', 'Employez la classe suivante de taxe sur les co&ucirc;ts de livraison.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Zone de livraison', 'MODULE_SHIPPING_ITEM_ZONE', '0', 'Permettre seulement cette m&eacute;thode de livraison pour la zone choisie.', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_shipping(', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de tri', 'MODULE_SHIPPING_ITEM_SORT_ORDER', '0', 'Ordre de tri pour l\'affichage (Le plus petit nombre est montr&eacute; en premier).', '6', '0', now())");

    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added,set_function) values ('".addslashes(__("Icone"))."', 'MODULE_SHIPPING_ITEM_ICON', '', '".addslashes(__("Choix d'un icone"))."', '6', '0', now(),'tep_cfg_choose_img(')");
  }

  public function remove() {
    $DB=Database::getInstance();
    $DB->query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
  }

  public function keys() {
    return array( 'MODULE_SHIPPING_ITEM_COST', 'MODULE_SHIPPING_ITEM_HANDLING', 'MODULE_SHIPPING_ITEM_TAX_CLASS', 'MODULE_SHIPPING_ITEM_ZONE', 'MODULE_SHIPPING_ITEM_SORT_ORDER','MODULE_SHIPPING_ITEM_ICON');
  }
}
?>