<?php
/**
 @licence GPL 2005-2009  The osCSS developers - osCSS Open Source E-commerce
  @package oscss-2 <www http://www.oscss.org>
  @version Rc-3
  @date  18/04/10, 16:17
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
   @encode UTF-8
*/

class mzmt
  implements InterfaceModule, InterfaceAcaShipping {
  var $code, $title, $description, $icon, $enabled, $num_zones, $num_tables, $delivery_geozone, $geozone_mode, $order_total;

  function __construct() {


    $this->code = __CLASS__;
    $this->title = __('module shipping mzmt text title');
    $this->description = __('module shipping mzmt text description');
    $this->sort_order = (defined('MODULE_SHIPPING_MZMT_SORT_ORDER') ? MODULE_SHIPPING_MZMT_SORT_ORDER : 0);
    $this->tax_class = (defined('MODULE_SHIPPING_MZMT_TAX_CLASS') ? MODULE_SHIPPING_MZMT_TAX_CLASS : '');
    $this->icon = '';
    $this->enabled = true;

    $this->num_geozones = (defined('MODULE_SHIPPING_MZMT_NUMBER_GEOZONES') ? MODULE_SHIPPING_MZMT_NUMBER_GEOZONES : 3 );
    $this->num_tables = (defined('MODULE_SHIPPING_MZMT_NUMBER_TABLES') ? MODULE_SHIPPING_MZMT_NUMBER_TABLES : 3 );

    global $order;
    //! block suite si BO
    if(!is_object($order)) return false;
    else $this->update_status($order);

  }

/** Interface InterfaceAcaShipping */

  public function quote($method = '') {
    global $order, $shipping_weight;

    $combined_quote_weight = (shipping::$shipping_num_boxes * $shipping_weight);
    $this->quotes = array('id' => $this->code,
			'module' => __('module shipping mzmt geozone ' . $this->delivery_geozone . ' text title') . ' (' . $combined_quote_weight . ' '.UNIT_WEIGHT_NAME.')',
			'methods' => array());

    $this->determineTableMethod(constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $this->delivery_geozone . '_MODE'));


    if ($method) {
      $j = substr($method, 5);

      $shipping = $this->determineShipping(preg_split("/[:,]/" , constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $this->delivery_geozone . '_TABLE_' . $j)));

      $this->quotes['methods'][] = array('id' => 'table' . $j,
					  'title' => __('module shipping mzmt geozone ' . $this->delivery_geozone . ' table ' . $j . ' text way'),
					  'cost_ht' => $shipping + constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $this->delivery_geozone . '_HANDLING'),
					  'cost' => $shipping + constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $this->delivery_geozone . '_HANDLING')
					);
    }
    else {
      for ($j=1; $j<=$this->num_tables; $j++) {
	if (!tep_not_null(constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $this->delivery_geozone . '_TABLE_' . $j))) continue;

	$shipping = $this->determineShipping(preg_split("/[:,]/" , constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $this->delivery_geozone . '_TABLE_' . $j)));

	$this->quotes['methods'][] = array('id' => 'table' . $j,
					    'title' => __('module shipping mzmt geozone ' . $this->delivery_geozone . ' table ' . $j . ' text way'),
					    'cost_ht' => $shipping + constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $this->delivery_geozone . '_HANDLING'),
					    'cost' => $shipping + constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $this->delivery_geozone . '_HANDLING')
					  );
      }
    }

    if ($this->tax_class > 0) {
      $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
      $this->quotes['methods'][0]['cost'] = tep_add_tax(((MODULE_SHIPPING_ITEM_COST * $total_count) + MODULE_SHIPPING_ITEM_HANDLING), $this->quotes['tax']);
      $this->quotes['methods'][0]['cost_ht'] = ((MODULE_SHIPPING_ITEM_COST * $total_count) + MODULE_SHIPPING_ITEM_HANDLING);
    }

    if (defined('MODULE_SHIPPING_MZMT_GEOZONE_' . $this->delivery_geozone . '_ICON')) {
      if ( tep_not_null(constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $this->delivery_geozone . '_ICON')) )
	$this->quotes['icon'] = shipping::get_icon(constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $this->delivery_geozone . '_ICON'), $this->title);
    }

    return $this->quotes;
  }

  public function update_status($order) {
    if ($this->enabled == true ) {
      $this->enabled = false;
      for ($n=1; $n<=$this->num_geozones; $n++) {
	if ( ((int)constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $n . '_ID') > 0) && ((int)constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $n . '_ID') == shipping::getGeoZoneID($order->delivery['country']['id'], $order->delivery['zone_id'])) ) {
	  $this->enabled = true;
	  $this->delivery_geozone = $n;
	  break;
	} elseif ( ((int)constant('MODULE_SHIPPING_MZMT_GEOZONE_' . $n . '_ID') == 0) && ($n == (int)$this->num_geozones) ) {
	  $this->enabled = true;
	  $this->delivery_geozone = $n;
	  break;
	}
      }
    }
  }

/** Interface InterfaceModule */

  public function check() {
    if (!isset($this->_check)) {
      $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key LIKE 'MODULE_SHIPPING_MZMT_%' ");
	if( tep_db_num_rows($check_query) ==  (4+ ($this->num_geozones* 4)+(+$this->num_tables *$this->num_geozones) ) ) $this->_check=true;
	else {
	$this->remove();
	$this->_check=false;
      }
    }
    return $this->_check;
  }

  public function install() {
    $DB=Database::getInstance();

    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('tax class', 'MODULE_SHIPPING_MZMT_TAX_CLASS', '0', 'use the following tax class on the shipping fee.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('sort order', 'MODULE_SHIPPING_MZMT_SORT_ORDER', '0', 'sort order of display.', '6', '0', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order,  date_added) values ('number geozones', 'MODULE_SHIPPING_MZMT_NUMBER_GEOZONES', '".(defined('MODULE_SHIPPING_MZMT_NUMBER_GEOZONES')? MODULE_SHIPPING_MZMT_NUMBER_GEOZONES : '3')."', 'use the following tax class on the shipping fee.', '6', '0', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('number tables', 'MODULE_SHIPPING_MZMT_NUMBER_TABLES', '".(defined('MODULE_SHIPPING_MZMT_NUMBER_TABLES')? MODULE_SHIPPING_MZMT_NUMBER_TABLES : '3')."', 'Sort order of display.', '6', '0', now())");

    for ($n=1; $n<=$this->num_geozones; $n++) {
      $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('<hr />Geo Zone $n', 'MODULE_SHIPPING_MZMT_GEOZONE_".$n."_ID', '', 'Enable this for the following geo zone.', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_shipping(', now())");
      $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Geo Zone $n Table Method', 'MODULE_SHIPPING_MZMT_GEOZONE_".$n."_MODE', 'weight', 'The shipping cost is based on the total weight, total price, or total count of the items ordered.', '6', '0', 'tep_cfg_select_option(array(\'weight\', \'price\', \'count\'), ', now())");
      $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Geo Zone $n Handling Fee', 'MODULE_SHIPPING_MZMT_GEOZONE_".$n."_HANDLING', '0', 'Handling Fee for this shipping geo zone', '6', '0', now())");
      $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added,set_function) values ('choose icon', 'MODULE_SHIPPING_MZMT_GEOZONE_".$n."_ICON', '', 'choose icon transporteur', '6', '0', now(),'tep_cfg_choose_img(')");


      for ($j=1; $j<=$this->num_tables; $j++) {
	$DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Geo Zone $n Shipping Table $j', 'MODULE_SHIPPING_MZMT_GEOZONE_".$n."_TABLE_".$j."', '', 'Shipping table $j for this geo zone', '6', '0', now())");
      }


    }
  }

  public function remove() {
    tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key  LIKE  'MODULE_SHIPPING_MZMT_%' ");
  }

  public function keys() {
    $keys = array( 'MODULE_SHIPPING_MZMT_TAX_CLASS', 'MODULE_SHIPPING_MZMT_SORT_ORDER','MODULE_SHIPPING_MZMT_NUMBER_GEOZONES','MODULE_SHIPPING_MZMT_NUMBER_TABLES');

    for ($n=1; $n<=$this->num_geozones; $n++) {
      $keys[] = 'MODULE_SHIPPING_MZMT_GEOZONE_' . $n . '_ID';
      $keys[] = 'MODULE_SHIPPING_MZMT_GEOZONE_' . $n . '_MODE';
      $keys[] = 'MODULE_SHIPPING_MZMT_GEOZONE_' . $n . '_HANDLING';
      $keys[] = 'MODULE_SHIPPING_MZMT_GEOZONE_' . $n . '_ICON';

      for ($j=1; $j<=$this->num_tables; $j++) {
	$keys[] = 'MODULE_SHIPPING_MZMT_GEOZONE_' . $n . '_TABLE_' . $j;
      }
    }

    return $keys;
  }


/** PRIVATE/PUBLIC  Specific module */



  /**
    Mode base calcul
  */
  private function determineTableMethod($geozone_mode) {
    global $total_count, $shipping_weight;

    $this->geozone_mode = $geozone_mode;

    if ($this->geozone_mode == 'price') {
      $this->order_total = $_SESSION['cart']->show_total();
    } elseif ($this->geozone_mode == 'count') {
      $this->order_total = $total_count;
    } else {
      $this->order_total = $shipping_weight;
    }

    return null;
  }

  /**
    Calcul shipping
  */
  private function determineShipping($table_cost) {
    $shipping_factor=0;
    for ($i=0, $n=sizeof($table_cost); $i<$n; $i+=2){
      if ($this->order_total <= $table_cost[$i] && isset($table_cost[$i+1]) && tep_not_null($table_cost[$i+1]) ){
	$shipping_factor = $table_cost[$i+1];
	break;
      }
    }

    //! calcul pour table de prix en %
    if (substr_count($shipping_factor, '%') > 0)
      $shipping = ((($this->order_total*10)/10)*((str_replace('%', '', $shipping_factor))/100));
    else
      $shipping = str_replace('$', '', $shipping_factor);


    //! majoration tare emballage
    if ($this->geozone_mode == 'weight')
      $shipping = $shipping * shipping::$shipping_num_boxes;

    return $shipping;
  }

}

?>
