<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @osCommerce, Open Source E-Commerce Solutions Copyright (c) 2003 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  23/05/10, 15:22
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @CONTRIB is Store Pickup Shipping Module (http://www.oscommerce.com/community/contributions,164)
  Made to work with latest check-out procedure by Matthijs (Mattice) >> e-mail:    mattice@xs4all.nl >> site:      http://www.matthijs.org

  NOTE: Utilise fichier text pour les langue et __()
*/
class spu
  implements InterfaceModule, InterfaceAcaShipping{
  var $code;
  var $title;
  var $description;
  var $icon;
  var $enabled;

  /**
    class constructor
  */
  function __construct() {
    $this->code = __CLASS__;
    $this->title = __('Récupération des articles au magasin');
    $this->description = __('Récupération des articles au magasin durant les heures ouvrées.');
    $this->sort_order = (defined('MODULE_SHIPPING_SPU_SORT_ORDER;')? MODULE_SHIPPING_SPU_SORT_ORDER: 0);
    $this->icon = (tep_not_null('MODULE_SHIPPING_SPU_ICON')? MODULE_SHIPPING_SPU_ICON : '');
    $this->enabled =  true ;

    global $order;
    if (is_object($order)) $this->update_status($order);
  }


/** Interface InterfaceAcaShipping */

  /**
  */
  public function quote($method = '') {
    global $order,$customer_id;

    $codep_query = tep_db_query("select c.configuration_value, ab.entry_postcode from " . TABLE_CONFIGURATION . " c, " . TABLE_ADDRESS_BOOK . " ab where c.configuration_key = 'MODULE_SHIPPING_SPU_ZIP' and ab.customers_id = '" . (int)$customer_id . "'");
    $codep = tep_db_fetch_array($codep_query);
    $dept_allow = split("[, ]", $codep['configuration_value']);
    $cust_cp = substr($codep['entry_postcode'], 0, 2);
    if((in_array($cust_cp, $dept_allow))||($codep['configuration_value'] == '')){
		  $this->quotes = array('id' => $this->code,
				'module' => __('Récupération des articles au magasin'),
				'methods' => array(array('id' => $this->code,
							  'tax'=>0,
							  'title' => __("Veuillez nous téléphoner avant de passer afin de confirmer la disponibilité et les horaires d'ouverture. "),
							  'cost_ht' => MODULE_SHIPPING_SPU_COST,
							  'cost' =>  MODULE_SHIPPING_SPU_COST
					    ))
				);
    return $this->quotes;
    }else{
      return $this->quotes=false;
    }
    if (tep_not_null($this->icon)) $this->quotes['icon'] = shipping::get_icon($this->icon, $this->title);

  }


  /**
  */
  public function update_status($order) {
    if ($this->enabled == true ) {
      $this->enabled = false;
      if ( ((int)MODULE_SHIPPING_SPU_ZONE > 0) && ((int)MODULE_SHIPPING_SPU_ZONE == shipping::getGeoZoneID($order->delivery['country']['id'], $order->delivery['zone_id'])) )
	$this->enabled = true;
      elseif ((int)MODULE_SHIPPING_SPU_ZONE == 0)
	$this->enabled = true;
    }
  }


/** Interface InterfaceModule */
  /**
  */
  public function check() {
    if (!isset($this->_check)) {
      $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key LIKE 'MODULE_SHIPPING_SPU%' ");
      if( tep_db_num_rows($check_query) ==  count($this->keys()) ) $this->_check=true;
      else {
	$this->remove();
	$this->_check=false;
      }
    }
    return $this->_check;
  }

  /**
  */
  public function install() {
    $DB=Database::getInstance();
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('".addslashes(__('Store Pickup Cost'))."', 'MODULE_SHIPPING_SPU_COST', '0.00', '".addslashes(__('Preciser le cout'))."', '6', '0', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('".__('Shipping Zone')."', 'MODULE_SHIPPING_SPU_ZONE', '0', '".addslashes(__('If a zone is selected, only enable this shipping method for that zone.'))."', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_shipping(', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('".addslashes(__('Sort order'))."', 'MODULE_SHIPPING_SPU_SORT_ORDER', '0', '".addslashes(__('Preciser un nombre pour le tri'))."', '6', '0', now())");
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added,set_function) values ('choose icon', 'MODULE_SHIPPING_SPU_ICON', '', 'choose icon transporteur', '6', '0', now(),'tep_cfg_choose_img(')");

    // chargée sur demande
    $DB->query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, configuration_type) values ('".addslashes(__('Store Pick Up Zip Code Allowed'))."', 'MODULE_SHIPPING_SPU_ZIP', '01, 07, 26, 38, 42, 69, 74', '".addslashes(__("Departement autorisé pour le retrait magasin ? laisser vide si vous ne l'utilisez pas"))."', '6', '0', now(),0)");
  }

  /**
  */
  public function remove() {
    $keys = '';
    $keys_array = $this->keys();
    for ($i=0; $i<sizeof($keys_array); $i++) {
      $keys .= "'" . $keys_array[$i] . "',";
    }
    $keys = substr($keys, 0, -1);

    tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in (" . $keys . ")");
  }

  /**
  */
  public function keys() {
    return array( 'MODULE_SHIPPING_SPU_COST', 'MODULE_SHIPPING_SPU_SORT_ORDER', 'MODULE_SHIPPING_SPU_ZONE', 'MODULE_SHIPPING_SPU_ZIP','MODULE_SHIPPING_SPU_ICON');
  }
}
?>