<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  16/06/10, 10:54
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/
$le_Y=0;
$marge_block=3;
$padding_block=5;
// Add the first page
$pdf->AddPage();

/**
Ligne + titre doc
*/
$pdf->Cell(50);
$pdf->SetY(60);
$pdf->SetDrawColor(153,153,153);
$pdf->Cell(15,.1,'',1,1,'L',1);
$pdf->SetFont('Arial','BI',15);
$pdf->SetTextColor(153,153,153);
$pdf->Text(22,61.5,tep_correct_entitie_put_pdf(PRINT_INVOICE_HEADING));
$pdf->SetY(60);
$pdf->SetDrawColor(153,153,153);
$pdf->Cell(38);
$pdf->Cell(160,.1,'',1,1,'L',1);

/**
Block des Adresse client
*/
$le_Y=67;
$hauteur_block=35;

//Draw Box for Invoice Address
$pdf->SetDrawColor(0);
$pdf->SetLineWidth(0.2);
$pdf->SetFillColor(245);
$pdf->RoundedRect(6, $le_Y, 90, $hauteur_block, 2, 'DF');

//Draw the invoice address text
$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(0);
$pdf->Text(11,77, tep_correct_entitie_put_pdf(ENTRY_SOLD_TO) );
$pdf->SetX(0);
$pdf->SetY(80);
$pdf->Cell(9);
$pdf->MultiCell(70, 3.3, tep_correct_entitie_put_pdf(tep_address_format(1, $order->customer, '', '', "\n")),0,'L');

//Draw Box for Delivery Address
$pdf->SetDrawColor(0);
$pdf->SetLineWidth(0.2);
$pdf->SetFillColor(255);
$pdf->RoundedRect(108, $le_Y, 90, $hauteur_block, 2, 'DF');

//Draw the invoice delivery address text
$pdf->SetFont('Arial','B',10);
$pdf->SetTextColor(0);
$pdf->Text(113,77,tep_correct_entitie_put_pdf(ENTRY_SHIP_TO));
$pdf->SetX(0);
$pdf->SetY(80);
$pdf->Cell(111);
$pdf->MultiCell(70, 3.3, tep_correct_entitie_put_pdf(tep_address_format(1, $order->delivery, '', '', "\n")),0,'L');


/**
Block order id et date
*/
$le_Y=($le_Y+$hauteur_block+$marge_block);
$hauteur_block=11;
//Draw Box for Order Number, Date & Payment method
$pdf->SetDrawColor(0);
$pdf->SetLineWidth(0.2);
$pdf->SetFillColor(245);
$pdf->RoundedRect(6, $le_Y, 192, $hauteur_block, 2, 'DF');

//Draw Order Number Text
$temp = tep_correct_entitie_put_pdf(PRINT_INVOICE_ORDERNR);
$pdf->Text(10,113, $temp . $order->info['orders_prefix'].$orders['orders_id']);
//Draw Date of Order Text
$temp = tep_correct_entitie_put_pdf (PRINT_INVOICE_DATE);
$pdf->Text(130,113,$temp . tep_correct_entitie_put_pdf(tep_date_short($order->info['date_purchased'])));

/**
Method payement
*/
if (isset($_POST) && isset($_POST['show_pay_method'])){
$le_Y=($le_Y+$hauteur_block+$marge_block);
$hauteur_block=11;

$pdf->SetDrawColor(0);
$pdf->SetLineWidth(0.2);
$pdf->SetFillColor(245);
$pdf->RoundedRect(6, $le_Y, 192, $hauteur_block, 2, 'DF');
$pdf->Text(10,127,tep_correct_entitie_put_pdf(ENTRY_PAYMENT_METHOD . ' ' . $order->info['payment_method']), 0, 0, 'R');
}

/**
Block detail commande
*/
//Fields Name position
$Y_Fields_Name_position = ($le_Y+$hauteur_block+$marge_block);
$item_count=0;
//Table position, under Fields Name
$Y_Table_Position = ($Y_Fields_Name_position+6);

output_table_heading($Y_Fields_Name_position);
//Show the products information line by line
for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
  $hauteur_block=$hauteur_block_r=6;
  $nbr_l=1;
//. cesure general name produits
  if (strlen($order->products[$i]['name']) > 40 ) {
    $r=tep_wordwrap($order->products[$i]['name'], 40);
    $order->products[$i]['name'] =$r['txt'];
    $nbr_l +=$r['nbr'];
  }
// concat des attribut de produits  sur les nom, avec saut de ligne
  if (isset($order->products[$i]['attributes']) && (($k = sizeof($order->products[$i]['attributes'])) > 0)) {
    for ($j = 0; $j < $k; $j++) {
      $ligne="\n - ".$order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'];
      if (strlen($ligne) > 40 ) {
	$r=tep_wordwrap($ligne, 40);
	$order->products[$i]['name'] .=$r['txt'];
	$nbr_l +=$r['nbr'];
      } else {
	$order->products[$i]['name'] .=$ligne;
	$nbr_l +=1;
      }
    }
  }
  $hauteur_block_r=($nbr_l*$hauteur_block_r);
// qty
  $pdf->SetFont('Arial','',10);
  $pdf->SetY($Y_Table_Position);
  $pdf->SetX(6);
  $pdf->MultiCell(9,$hauteur_block_r,$order->products[$i]['qty'],1,'C');
// modele
  $pdf->SetY($Y_Table_Position);
  $pdf->SetX(15);
  $pdf->SetFont('Arial','',8);
  $pdf->MultiCell(25,$hauteur_block_r,tep_correct_entitie_put_pdf($order->products[$i]['model']),1,'C');
// name
  $pdf->SetY($Y_Table_Position);
  $pdf->SetX(40);
  $pdf->SetFont('Arial','',8);
  $pdf->MultiCell(78,$hauteur_block,tep_correct_entitie_put_pdf($order->products[$i]['name']),1,'L');
// totaux / prix
  $pdf->SetY($Y_Table_Position);
  $pdf->SetX(118);
  $pdf->SetFont('Arial','',10);
  $pdf->MultiCell(20,$hauteur_block_r,tep_correct_entitie_put_pdf($currencies->format($order->products[$i]['final_price'], true, $order->info['currency'], $order->info['currency_value'])),1,'C');
  $pdf->SetY($Y_Table_Position);
  $pdf->SetX(138);
  $pdf->MultiCell(20,$hauteur_block_r,tep_correct_entitie_put_pdf($currencies->format(tep_add_tax($order->products[$i]['final_price'], $order->products[$i]['tax']), true, $order->info['currency'], $order->info['currency_value'])),1,'C');
  $pdf->SetY($Y_Table_Position);
  $pdf->SetX(158);
  $pdf->MultiCell(20,$hauteur_block_r,tep_correct_entitie_put_pdf($currencies->format($order->products[$i]['final_price'] * $order->products[$i]['qty'], true, $order->info['currency'], $order->info['currency_value'])),1,'C');
  $pdf->SetY($Y_Table_Position);
  $pdf->SetX(178);
  $pdf->MultiCell(20,$hauteur_block_r,tep_correct_entitie_put_pdf($currencies->format(tep_add_tax($order->products[$i]['final_price'], $order->products[$i]['tax']) * $order->products[$i]['qty'], true, $order->info['currency'], $order->info['currency_value'])),1,'C');

  /* Check for product line overflow*/
  $item_count++;
  if ((is_long($item_count / 32) && $i >= 20) || ($i == 20)){
      $pdf->AddPage();
      //Fields Name position
      $Y_Fields_Name_position = 125;
      //Table position, under Fields Name
      $Y_Table_Position = 70;
      output_table_heading($Y_Table_Position-$hauteur_block_r);
      if ($i == 20) $item_count = 1;
  }
  $Y_Table_Position=$Y_Table_Position+$hauteur_block_r;
}


// Order Totals
for ($i = 0, $n = sizeof($order->totals); $i < $n; $i++) {
  $Y_Table_Position +=5;
  $pdf->SetY($Y_Table_Position );
  $pdf->SetX(36);
  $temp = substr ($order->totals[$i]['text'],0 ,3);
  $pdf->MultiCell(130,6,tep_correct_entitie_put_pdf($order->totals[$i]['title'],true) ,0,'R');
  $pdf->SetY($Y_Table_Position );
  $pdf->SetX(146);
  $pdf->MultiCell(50,6, tep_correct_entitie_put_pdf($order->totals[$i]['text'],false),0,'R');
}

if (isset($_POST) && isset($_POST['show_pay_method'])){
  $DB=Database::getInstance();
  $innum = $orders['orders_prefix'].$orders['orders_id'];
  $orders_comments_query = $DB->query("select comments,date_added from " . TABLE_ORDERS_STATUS_HISTORY . " where orders_id = '$innum' order by date_added");
  if ($orders_comments_query->__get('NumRows')>0) {
    $Y_Table_Position=($Y_Table_Position+$marge_block);
    while ($orders_comments = $orders_comments_query->fectAssoc()) {
      if(tep_not_null($orders_comments['comments'])){
	$pdf->SetFont('Arial','',10);
	$pdf->SetY($Y_Table_Position);
	$pdf->SetX(6);
	$pdf->MultiCell(35,6,date(TEXT_ORDER_FORMAT, strtotime($orders_comments['date_added'])),0,'C');
	$pdf->SetY($Y_Table_Position);
	$pdf->SetX(41);
	$pdf->MultiCell(100,6,tep_correct_entitie_put_pdf("Comments: " . $orders_comments['comments']),0,'C');
	$Y_Table_Position += 5;
      }
    }
  }
}
?>