<?php
/**
 *\licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
 *\portion code Copyright (c) 2002 osCommerce
 *\package osCSS-2 <www http://www.oscss.org>
 *\version 2.1.0
 *\date  28/11/10, 22:44
 *\author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
 *\encode UTF-8
 *\file
 *\example example_RacinePage.php
 *\mainpage index.php
 *\brief process principal for display pages frontend
 *\section introduction
 *		Ce fichier prend en charge la majorité des affichages public, il assure ainsi l'affichage des produits, catagorie, listing, content, home \n
 *		Les autres fichiers de la racine assure les traitements specialisé sur des affichage particulier . Dans tous les affichage generic, c'est ce fichier qui prend en charge l'affichage.\n
 *
 *		Pour Ajouter un fichier à la racine simplement, utiliser la base example
*/
  require_once('includes/application_top.php');

  //! Choix du mode affichage des listign et priorité
  $category_depth = 'top';
  if (isset($cPath) && tep_not_null($cPath)) {
    if ( ($count_cat=categorie::get_has_category_subcategories((int)$current_category_id)) && $count_cat > 0)  $category_depth = 'nested'; // navigate through the categories
    elseif($current_category_id==0)$category_depth = 'top';
    else {
      $count_p=categorie::get_count_products_in_category((int)$current_category_id);
      $count_c=categorie::get_count_content_in_category((int)$current_category_id);

      if ($count_p > 0 && $count_p>=$count_c) $category_depth = 'products';
      elseif ($count_c > 0 && $count_c>=$count_p ) $category_depth = 'pages';
      else $category_depth = 'top';
    }
  }
  if(isset($_GET['type_object']) && tep_not_null($_GET['type_object']))$category_depth = $_GET['type_object'];
  if(isset($_GET['manufacturers_id']) && $category_depth == 'top') $category_depth = 'products';

  $page->add_var_page('category_depth',$category_depth);

if ($category_depth == 'top') {

/**
 * \section Page Customer public
 */
  if (isset($_GET['customers_id']) ) {
    $page->init('customers.php',$language);

    $aca_account=$account=$page->new_class('account',$customer_id);
    $account=$page->_call('customer','the_customer');
    $page_content = $page->force_content('customers.php');

  }elseif (isset($_GET['products_id']) ) {
    $page->init('404.php',$language);

    $page_content = $page->force_content('404.php');


 /** HOME */
  }else {
    $page->init('home.php',$language);

    $page_content = $page->force_content('home.php');
  }

  unset($category_cfils,$category_pfils,$category_parent);


/**
  @brief Modes Avec heritage des informations sur la categories en cours,
*/
}else{

  /**
    @brief element communs categories
  */
  // Get the right image for the top-right
    $image = DIR_WS_IMAGES . 'table_background_list.gif';

  if(!isset($_GET['manufacturers_id'])) {
    //! Recup des element cat en cours
      categorie::resetCacheId((int)$current_category_id);
      if( ($categories=categorie::get_item((int)$current_category_id)) ==false){
	if($current_category_id !=0) $category_depth='nofound' ;
	$image='';
	$categories=new objectInfo(array());
      }
      else
	$image=$categories->categories_image;

    //! List des categorie enfant
      $categories_query = $DB->query($sql="select c.categories_id from " . TABLE_CATEGORIES . " c where c.parent_id = '" . (int)$current_category_id . "'  and c.categories_status='1' ");
      $lis="'" . (int)$current_category_id . "', ";
      while ($cat= $categories_query->fetchAssoc() ){ $lis .="'".$cat['categories_id']."',"; }
      $categories->list=$list= $current_category_id;

      $categories->products_total=(isset($count_p)? $count_p : 0 );
      $categories->contents_total=(isset($count_c)?$count_c:0);
      $categories->categories_total=(isset($count_cat)?$count_cat:0);

      unset($count_p,$count_c,$count_cat);
      /**
	Stock la categories en cours
	@param array (categories_name, categories_description, categories_image, list,products_total,contents_total,categories_total )
      */
      $page->add_var_page('categories',$categories);

  }


  /**
    @brief Uniq Products Page
    use /content/products_info.php
  */
  if (/*$category_depth == 'products' &&*/ isset($_GET['products_id']) ) {
    $page->init('product_info.php',$language);

    /** init aca module */
    $aca_product=$page->new_class('product',true);

    if (isset($_GET['action'])) {
        if ($aca_product->check_action('',$_GET['action']) ) {
          $aca_product->after_check_action('',$_GET['action']);
          tep_redirect(tep_href_link(FILENAME_PRODUCT_INFO, tep_get_all_get_params(array('action'))));
        }
    }

    //! produit nom trouvé
    if  ( ($obj_product_info =product_info((int)$_GET['products_id'])) ==false ) tep_redirect(tep_href_link(FILENAME_DEFAULT) );
    $product_info=arrayInfo($obj_product_info);
    $page->add_var_page('product_info',$product_info);

    $page->title=$product_info['title'];
    $breadcrumb->add($product_info['title'], tep_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $_GET['products_id'].'&amp;cPath=' . $cPath . ''));

    /**
      Incremente nbr de vus du produits
    */
    $DB->query("update " . TABLE_PRODUCTS_DESCRIPTION . " set products_viewed = products_viewed+1 where products_id = '" . (int)$_GET['products_id'] . "' and language_id = '" . (int)$languages_id . "'");

    /**
    Specifique au bloite récement vu. Enregistrement désactivier si OSCSS__B_RECENTLY_VIEWED et a false
    */
    if($page->_conf_value('OSCSS__B_RECENTLY_VIEWED')) {
      if (!tep_session_is_registered('recently_viewed')){
        tep_session_register('recently_viewed');
        $recently_viewed = $_GET['products_id'] . ';';
      }
      $check_not_duplicate = $_GET['products_id'];
      $temp_recent = $recently_viewed;
      if (preg_match('/'.$check_not_duplicate.'/', $temp_recent ) )  $recently_viewed = preg_replace('/'.$check_not_duplicate.'/',"",$temp_recent);
      $recently_viewed = $_GET['products_id'] . ';' . $recently_viewed ;
    }
    $page->product->pile_img[]=$product_info['products_image'];
    $page_content = $page->force_content(FILENAME_PRODUCT_INFO);

  }

  /**
    @brief Unqi Page 404
    use /content/404.php
  */
  elseif ( $category_depth == 'nofound') {
    $page->init('404.php',$language);

    $page_content = $page->force_content('404.php');
  }

  /**
    @brief Listing Page / Mutli prodycts / cms
      use /content/index_listing.php
  */
  elseif  (in_array($category_depth,array( 'products', 'pages', 'nested')) ) {

      $page->init(basename(__FILE__),$language);

      $listing=listing::getInstance();
      $listing->_reset();
      $listing_split = $listing->listing(@$_GET['type_object'],$category_depth);

      /// get the categorie name and put it on the header
      if (isset($_GET['manufacturers_id'])) {
	$man=$DB->query("select * from " . TABLE_MANUFACTURERS . " m  where m.manufacturers_id = '" . (int)$_GET['manufacturers_id'] . "' ");
	$manuf= $man->fetchAssoc();
	tep_db_free_result($man);
	$image = $manuf['manufacturers_image'];
	$page->breadcrumb->add($manuf['manufacturers_name'], tep_href_link(FILENAME_DEFAULT, 'manufacturers_id=' . $_GET['manufacturers_id']));
	$page->add_var_page('manufacturers',$manuf);
      }

      $listing_query = $DB->query($listing_split->sql_query);
      $page_content = $page->force_content('index_listing.php');

    }


}


  $page->post_init(false);
  require($page->path_gabarit());

  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>