<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  22/01/11, 20:42
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8

  @brief Page content for view detail products

  NOTE:

    var $product_info contient un array du produit courant
    var $module contient le detail de chaque module sous forme d'object
    var $cart contient le detail du panier courant
*/
  global $cart;
  //! element module aca class
  $module=$page->_call('product','ret_modules');
  $i=1;
?>
<div id="productInfo">
  <?php $page->messageStack->_draw('review');?>

<?php if (_test_bool($product_info)) { ?>

  <div class="infoText"><?php echo TEXT_PRODUCT_NOT_FOUND; ?></div>

  <div class="navBt">
    <?php echo '<a class="navBt" href="' . tep_href_link(FILENAME_DEFAULT) . '">' . IMAGE_BUTTON_CONTINUE . '</a>'; ?>
  </div>

<?php } else { ?>

  <h2 class="center_title_bar <?php echo $language ;?>">
    <?php /** Nom produit ou modele si present */ ?>
    <?php echo ((!empty($product_info['products_model'])) ? $product_info['products_model'] :$product_info['products_name'] ); ?>

    <?php /** Indication par un icone de la presence de cet artcile dans le cart ou la liste des favoris  */ ?>
    <span class="action infoProduct">
      <?php if($cart->count_contents()>0 && $cart->get_quantity($product_info['products_id'])>0):  /** Si dans panier*/  ?>
	<a href="<?php echo tep_href_link(FILENAME_SHOPPING_CART) ?>" title="header=[<?php echo __('text article deja dans votre panier') ?>] body=[&nbsp;] fade=[on]"><img src="<?php echo $page->getPathTemplate() ?>images/cart.gif" alt="<?php echo __('deja dans votre panier') ?>" /></a>
      <?php endif; ?>
      <?php if(class_exists('wishlist') && wishlist::inwishlist($product_info['products_id']) ) :  /** Si favoris */  ?>
	<a href="<?php echo tep_href_link(FILENAME_WISHLIST) ?>" title="header=[<?php echo __('text article deja dans vos favoris') ?>] body=[&nbsp;] fade=[on]" ><img src="<?php echo $page->getPathTemplate() ?>images/favs.gif" alt="<?php echo __('deja dans vos favoris') ?>" /></a>
      <?php endif; ?>
    </span>

  </h2>

  <div class="prod_box_big">
    <div class="top_prod_box_big"></div>
      <div class="center_prod_box_big">
      <div id="productInfoBack" class="navBt">
	  <?php echo '<a class="navBt" href="javascript: history.go(-1)">' . IMAGE_BUTTON_BACK . '</a>'; ?>
      </div>
	<?php if (tep_not_null($product_info['products_image'])) { ?>
	  <div id="productImagesGlb" class="product_img_big contentBox">
	    <div id="productImage">
	      <?php /** Le block principal de l'image du produit.
			L'id Css de l'image principale du produit ce doit d'être "image_master".
			Sans quoi les plugins et javascript  peuvent ne pas fonctionner */ ?>
	      <?php if ( ($replace=$page->prop_ctrl('products_image', $product_info['products_image'])) !=false) echo $replace($product_info, "lightbox" , $page->_conf_value('HEADING_IMAGE_WIDTH'), $page->_conf_value('HEADING_IMAGE_HEIGHT'));
		    else { ?>
		    <script type="text/javascript"><!--
		      document.write('<?php echo '<p><a href="' . tep_href_link(FILENAME_POPUP_IMAGE, 'pID=' . $product_info['products_id']) . '" onclick="popupWindow(this.href); return false" >' . tep_image(DIR_WS_IMAGES . $product_info['products_image'], addslashes($product_info['products_name']), $page->_conf_value('HEADING_IMAGE_WIDTH'), $page->_conf_value('HEADING_IMAGE_HEIGHT'), ' id="image_master" ') . '</a></p>'; ?>');
		    //--></script>
		    <noscript>
		      <?php echo '<p><a href="' . tep_href_link(DIR_WS_IMAGES . $product_info['products_image']) . '">' . tep_image(DIR_WS_IMAGES . $product_info['products_image'], $product_info['products_name'], $page->_conf_value('HEADING_IMAGE_WIDTH'), $page->_conf_value('HEADING_IMAGE_HEIGHT'), ' id="image_master" ') . '</a><br /><a href="' . tep_href_link(DIR_WS_IMAGES . $product_info['products_image']) . '">' . TEXT_CLICK_TO_ENLARGE . '</a></p>'; ?>
		    </noscript>
		<?php } ?>
	    </div>
	    <?php /** Liste des images dans la pile des images du produits (toutes les images) */ ?>
	    <div id="productImagelistMini" class="contentBox">
	      <ul>
	      <?php if(is_array($page->product->pile_img)) foreach($page->product->pile_img as $img) : ?>
		<li>
		<?php /*if ( ($replace=$page->prop_ctrl('products_image', $img)) !=false) echo $replace($product_info,"lightbox-journey",$page->_conf_value('STACK_IMAGE_WIDTH'), $page->_conf_value('STACK_IMAGE_HEIGHT') );
		      else {*/ ?>
			<?php echo '<a class="fancy" rel="lightbox-journey" href="' .  tep_image(DIR_WS_IMAGES . $img, $product_info['products_name'], $page->_conf_value('POPUP_IMAGE_WIDTH'), $page->_conf_value('POPUP_IMAGE_HEIGHT'), "", true) . '" onmouseover="change_image_master(\'' .  tep_image(DIR_WS_IMAGES . $img, $product_info['products_name'],  $page->_conf_value('HEADING_IMAGE_WIDTH'),$page->_conf_value('HEADING_IMAGE_HEIGHT') ,"", true) . '\',\'' .  tep_image(DIR_WS_IMAGES . $img, $product_info['products_name'],$page->_conf_value('POPUP_IMAGE_WIDTH'), $page->_conf_value('POPUP_IMAGE_HEIGHT'), "", true) . '\')">' . tep_image(DIR_WS_IMAGES . $img, $product_info['products_name'], $page->_conf_value('STACK_IMAGE_WIDTH'), $page->_conf_value('STACK_IMAGE_HEIGHT')) . '</a>'; ?>
		  <?php /*}*/ ?>
		</li>
	      <?php endforeach; ?>
	      </ul>
	    </div>
	  </div>
	<?php } ?>

	<div class="details_big_box contentBox">
	  <h3 class="product_title_big "><?php echo $product_info['products_name']; ?></h3>

	  <?php /** Ne pas modifier l'id du block suivant, celle ci est utilisé pour mettre a jour le prix en js */ ?>
	  <p id="price_master" class="prod_price_big"><?php echo print_products_price_rv($product_info); ?></p>

	  <div class="details_sec">
	    <?php /** Url vers un site externe , detail chez le fabricant ou vers un blog  */ ?>
	    <?php  if (tep_not_null($product_info['products_url'])) : ?>
	      <p id="productUrl"><?php echo sprintf(TEXT_MORE_INFORMATION, tep_href_link(FILENAME_REDIRECT, 'action=url&amp;goto=' . urlencode($product_info['products_url']), 'NONSSL', true, false)); ?></p>
	    <?php endif; ?>

	    <?php /** Date de disponiblité si presente, ou date d'ajout au catalogue */ ?>
	    <?php if ($product_info['products_date_available'] > date('Y-m-d H:i:s')): ?>
	      <p id="productDateAvalaible" class="date"><?php echo sprintf(TEXT_DATE_AVAILABLE, tep_date_long($product_info['products_date_available'])); ?></p>
	    <?php else : ?>
	      <p id="productDateAdded" class="date"><?php echo sprintf(TEXT_DATE_ADDED, tep_date_long($product_info['products_date_added'])); ?></p>
	    <?php endif; ?>
	  </div>

	  <?php if (_test_bool($product_info['action']['buy'])): ?>
	    <div class="action">
	      <?php /** Conserver l'id du formulaire et de ces elements. Le js et les control php peuevent y avoir recours  */ ?>
	      <?php echo tep_draw_form('cart_quantity', tep_href_link(FILENAME_PRODUCT_INFO, tep_get_all_get_params(array('action')) . 'action=add_product')); ?>

		<?php /** Aca Attribute Products */ if(isset($module['attributeManager'])) echo $module['attributeManager']->display_view_master($product_info['products_id']);?>

		<p class="formQt"><?php echo TEXT_PREFIX_QTY.tep_draw_input_field('products_quantity', 'products_quantity', '1', 'size="2"'); ?></p>
		<p class="formBt">
		  <input class="submitBt addtocart" type="submit" value="<?php echo IMAGE_BUTTON_IN_CART; ?>"  />
		</p>
		<p><?php echo tep_draw_hidden_field('products_id', $product_info['products_id']); ?></p>
	      </form>
	    </div>
	  <?php endif ; ?>

	</div>
      <div class="bottom_prod_box_big"></div>
    </div>
  </div>
<?php } ?>
</div>