<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package oscss-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  12/12/10, 09:15
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
	  Ayatus <www http://www.ayatus.org>
  @encode UTF-8
*/


class configuration extends core {


  /**
    Installation des fichier de configurations
  */
  private function install_base_conf(){

    $http_url = parse_url($_POST['HTTP_WWW_ADDRESS']);
    $http_server = $http_url['scheme'] . '://' . $http_url['host'];
    $http_catalog = $http_url['path'];
    if (isset($http_url['port']) && !empty($http_url['port'])) $http_server .= ':' . $http_url['port'];
    if (substr($http_catalog, -1) != '/')  $http_catalog .= '/';

    $https_server = '';
    $https_catalog = '';
    if (isset($_POST['HTTPS_WWW_ADDRESS']) && !empty($_POST['HTTPS_WWW_ADDRESS'])) {
      $https_url = parse_url($_POST['HTTPS_WWW_ADDRESS']);
      $https_server = $https_url['scheme'] . '://' . $https_url['host'];
      $https_catalog = $https_url['path'];

      if (isset($https_url['port']) && !empty($https_url['port']))  $https_server .= ':' . $https_url['port'];
      if (substr($https_catalog, -1) != '/')  $https_catalog .= '/';
    }

    $enable_ssl = (isset($_POST['ENABLE_SSL']) && ($_POST['ENABLE_SSL'] == 'true') ? 'true' : 'false');
    $http_cookie_domain = $_POST['HTTP_COOKIE_DOMAIN'];
    $https_cookie_domain = (isset($_POST['HTTPS_COOKIE_DOMAIN']) ? $_POST['HTTPS_COOKIE_DOMAIN'] : '');
    $http_cookie_path = $_POST['HTTP_COOKIE_PATH'];
    $https_cookie_path = (isset($_POST['HTTPS_COOKIE_PATH']) ? $_POST['HTTPS_COOKIE_PATH'] : '');

    $http_work_directory = $_POST['HTTP_WORK_DIRECTORY'];
    if (substr($http_work_directory, -1) != '/')  $http_work_directory .= '/';

    $Key=sha1(mt_rand(10000,99999).time());

    $file_contents = '<?php' . "\n" .
      '/**'. "\n" .
      '  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce   '. "\n" .
      '  @package oscss-2 <www http://www.oscss.org>'. "\n" .
      '  @version 2.1.0'. "\n" .
      '  @date  '.date("Y-m-d").''. "\n" .
      '  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>'. "\n" .
      '  @encode UTF-8'. "\n" .
      '*/'. "\n" .
      '' . "\n" .

      '  /**' . "\n" .
      '   * \brief as active / inactive cache and error return' . "\n" .
      '   * @var boolean default:false' . "\n" .
      '   */' . "\n" .
      '  define(\'OSCSS_DEBUG\', true);' . "\n" .
      '  /**' . "\n" .
      '   * \brief as active view query in error requet sql' . "\n" .
      '   * @var boolean  default:false' . "\n" .
      '   */' . "\n" .
      '  define(\'OSCSS_SHOW_QUERIES\', true);' . "\n" .
      '  /**' . "\n" .
      '   * \brief as active / incative garbage collector error' . "\n" .
      '   * @var boolean  default: true' . "\n" .
      '   */' . "\n" .
      '  define(\'OSCSS_GARBAGE_ERROR\', true);' . "\n" .
      '' . "\n" .
      '// Define the webserver and path parameters' . "\n" .
      '// * DIR_FS_* = Filesystem directories (local/physical)' . "\n" .
      '// * DIR_WS_* = Webserver directories (virtual/URL)' . "\n" .
      '  define(\'HTTP_SERVER\', \'' . $http_server . '\'); // eg, http://localhost - should not be empty for productive servers' . "\n" .
      '  define(\'HTTPS_SERVER\', \'' . $https_server . '\'); // eg, https://localhost - should not be empty for productive servers' . "\n" .
      '  define(\'ENABLE_SSL\', ' . $enable_ssl . '); // secure webserver for checkout procedure?' . "\n" .
      '  define(\'HTTP_COOKIE_DOMAIN\', \'' . (($http_cookie_domain !='localhost')? $http_cookie_domain: '') . '\');' . "\n" .
      '  define(\'HTTPS_COOKIE_DOMAIN\', \'' . (($https_cookie_domain !='localhost')? $https_cookie_domain: '')  . '\');' . "\n" .
      '  define(\'HTTP_COOKIE_PATH\', \'' . $http_cookie_path . '\');' . "\n" .
      '  define(\'HTTPS_COOKIE_PATH\', \'' . $https_cookie_path . '\');' . "\n" .
      '  define(\'DIR_WS_HTTP_CATALOG\', \'' . $http_catalog . '\');' . "\n" .
      '  define(\'DIR_WS_HTTPS_CATALOG\', \'' . $https_catalog . '\');' . "\n" .
      '  define(\'DIR_CLASSES\', \'classes/\');' . "\n" .
      '  define(\'DIR_FUNCTIONS\', \'functions/\');' . "\n" .
      '  define(\'DIR_FONTS\', \'fonts/\');' . "\n" .
      '  define(\'DIR_WS_IMAGES\', \'images/\');' . "\n" .
      '  define(\'DIR_WS_ICONS\', DIR_WS_IMAGES . \'icons/\');' . "\n" .
      '  define(\'DIR_WS_INCLUDES\', \'includes/\');' . "\n" .
      '  define(\'DIR_WS_BOXES\', DIR_WS_INCLUDES . \'boxes/\');' . "\n" .
      '  define(\'DIR_WS_FUNCTIONS\', DIR_WS_INCLUDES . DIR_FUNCTIONS);' . "\n" .
      '  define(\'DIR_WS_CLASSES\', DIR_WS_INCLUDES . DIR_CLASSES);' . "\n" .
      '  define(\'DIR_WS_MODULES\', DIR_WS_INCLUDES . \'modules/\');' . "\n" .
      '  define(\'DIR_WS_LANGUAGES\', DIR_WS_INCLUDES . \'languages/\');' . "\n" .
      '  define(\'DIR_WS_TRIGGERS\', DIR_WS_INCLUDES . \'triggers/\');' . "\n" .
      '' . "\n" .
      '  define(\'DIR_WS_DOWNLOAD_PUBLIC\', \'pub/\');' . "\n" .
      '  define(\'DIR_FS_CATALOG\', \'' . $this->fs_document_root . '\');' . "\n" .
      '  define(\'DIR_FS_CATALOG_IMAGES\', DIR_FS_CATALOG . \'images/\');' . "\n" .
      '  define(\'DIR_FS_CATALOG_MODULES\', DIR_FS_CATALOG . \'includes/modules/\');' . "\n" .
      '  define(\'DIR_FS_CATALOG_LANGUAGES\', DIR_FS_CATALOG . \'includes/languages/\');' . "\n" .
      '  define(\'DIR_FS_CATALOG_TEMPLATE\', DIR_FS_CATALOG . \'templates/\');' . "\n" .
      '  define(\'DIR_FS_WORK\', \'' . $http_work_directory . '\');' . "\n" .
      '  define(\'DIR_FS_DOWNLOAD\', DIR_FS_CATALOG . \'download/\');' . "\n" .
      '  define(\'DIR_FS_DOWNLOAD_PUBLIC\', DIR_FS_CATALOG . \'pub/\');' . "\n" .
      '  define(\'DIR_FS_SESSIONS\', DIR_FS_CATALOG . \'sessions/\');' . "\n" .

      '' . "\n" .
      '// Template System files' . "\n" .
      '  define(\'DIR_FS_TEMPLATES\', DIR_FS_CATALOG . \'templates/\');' . "\n" .
      '  define(\'DIR_WS_TEMPLATES\', \'templates/\');' . "\n" .
      '' . "\n" .
      '// Common' . "\n" .
      '  define(\'DIR_WS_COMMON\', \'common/\');' . "\n" .
      '  define(\'DIR_WS_COMMON_FUNCTIONS\', DIR_WS_COMMON . DIR_FUNCTIONS);' . "\n" .
      '  define(\'DIR_WS_COMMON_FONTS\', DIR_WS_COMMON . DIR_FONTS);' . "\n" .
      '  define(\'DIR_WS_COMMON_CLASSES\', DIR_WS_COMMON . DIR_CLASSES);' . "\n" .
      '  define(\'DIR_WS_COMMON_IMAGES\', DIR_WS_TEMPLATES . \'layout/\');' . "\n" .
      '' . "\n" .
      '// define our database connection' . "\n" .
      '  define(\'DB_CONNECTOR\', \'mysql\');' . "\n" .
      '  define(\'DB_PORT\', \'3306\');' . "\n" .
      '  define(\'DB_CHARSET\', \'utf8\');' . "\n" .
      '  define(\'DB_SERVER\', \'' . $_POST['DB_SERVER'] . '\'); // eg, localhost - should not be empty for productive servers' . "\n" .
      '  define(\'DB_SERVER_USERNAME\', \'' . $_POST['DB_SERVER_USERNAME'] . '\');' . "\n" .
      '  define(\'DB_SERVER_PASSWORD\', \'' . $_POST['DB_SERVER_PASSWORD']. '\');' . "\n" .
      '  define(\'DB_DATABASE\', \'' . $_POST['DB_DATABASE']. '\');' . "\n" .
      '  define(\'DB_TABLE_PREFIX\', \'' . $_POST['DB_TABLE_PREFIX']. '\');' . "\n" .
      '  define(\'USE_PCONNECT\', \'' . ((isset($_POST['USE_PCONNECT']) && $_POST['USE_PCONNECT'] == 'on') ? 'true' : 'false') . '\'); // use persistent connections?' . "\n" .
      '  define(\'STORE_SESSIONS\', \'' . ((isset($_POST['STORE_SESSIONS']) && $_POST['STORE_SESSIONS'] == 'files') ? '' : 'mysql') . '\'); // leave empty \'\' for default handler or set to \'mysql\'' . "\n" .
      '' . "\n" .
      '  /**' . "\n" .
      '    @var Security key' . "\n" .
      '    @brief use by offline mode' . "\n" .
      '  */' . "\n" .
      '  $SecuKey=\''.$Key.'\';' . "\n" .
      '?>';

    $fp = fopen($this->fs_document_root . 'includes/configure.php', 'w');
    fputs($fp, $file_contents);
    fclose($fp);

    $file_contents =
      '<?php' . "\n" .
      '/**'. "\n" .
      '  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce   '. "\n" .
      '  @package oscss-2 <www http://www.oscss.org>'. "\n" .
      '  @version 2.1.0'. "\n" .
      '  @date  '.date("Y-m-d").''. "\n" .
      '  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>'. "\n" .
      '  @encode UTF-8'. "\n" .
      '*/'. "\n" .
      '' . "\n" .
      '  /**' . "\n" .
      '   * \brief as active / inactive cache and error return' . "\n" .
      '   * @var boolean default:false' . "\n" .
      '   */' . "\n" .
      '  define(\'OSCSS_DEBUG\', true);' . "\n" .
      '  /**' . "\n" .
      '   * \brief as active view query in error requet sql' . "\n" .
      '   * @var boolean default:false' . "\n" .
      '   */' . "\n" .
      '  define(\'OSCSS_SHOW_QUERIES\', true);' . "\n" .
      '  /**' . "\n" .
      '   * \brief as active / incative garbage collector error' . "\n" .
      '   * @var boolean default:true' . "\n" .
      '   */' . "\n" .
      '  define(\'OSCSS_GARBAGE_ERROR\', true);' . "\n" .
      '' . "\n" .
      '// Define the webserver and path parameters' . "\n" .
      '// * DIR_FS_* = Filesystem directories (local/physical)' . "\n" .
      '// * DIR_WS_* = Webserver directories (virtual/URL)' . "\n" .
      '  define(\'HTTP_SERVER\', \'' . $http_server . '\'); // eg, http://localhost - should not be empty for productive servers' . "\n" .
      '  define(\'HTTPS_SERVER\', \'' . $https_server . '\'); // eg, https://localhost - should not be empty for productive servers' . "\n" .
      '  define(\'HTTP_CATALOG_SERVER\', \'' . $http_server . '\');' . "\n" .
      '  define(\'HTTPS_CATALOG_SERVER\', \'' . $https_server . '\');' . "\n" .
      '  define(\'ENABLE_SSL\', ' . $enable_ssl . ');' . "\n" .
      '  define(\'ENABLE_SSL_CATALOG\', \'' . $enable_ssl . '\'); // secure webserver for catalog module' . "\n" .
      '  define(\'DIR_FS_DOCUMENT_ROOT\', \'' . $this->fs_document_root . '\'); // where the pages are located on the server' . "\n" .
      '  define(\'DIR_WS_ADMIN\', \'' . $http_catalog .$this->ws_admin_rand. '/\'); // absolute path required' . "\n" .
      '  define(\'DIR_FS_ADMIN\', \'' . $this->fs_document_root.$this->ws_admin_rand . '/\'); // absolute pate required' . "\n" .
      '  define(\'DIR_WS_CATALOG\', \'' . $http_catalog . '\'); // absolute path required' . "\n" .
      '  define(\'DIR_WS_HTTP_CATALOG\',DIR_WS_CATALOG);// compatibilité SEO' . "\n" .
      '  define(\'DIR_WS_HTTPS_CATALOG\', \'' . $https_catalog . '\');' . "\n" .
      '  define(\'DIR_FS_CATALOG\', \'' . $this->fs_document_root . '\'); // absolute path required' . "\n" .
      '  define(\'DIR_CLASSES\', \'classes/\');' . "\n" .
      '  define(\'DIR_FUNCTIONS\', \'functions/\');' . "\n" .
      '  define(\'DIR_FONTS\', \'fonts/\');' . "\n" .
      '  define(\'DIR_WS_IMAGES\', \'images/\');' . "\n" .
      '  define(\'DIR_WS_ICONS\', DIR_WS_IMAGES . \'icons/\');' . "\n" .
      '  define(\'DIR_WS_CATALOG_IMAGES\', DIR_WS_CATALOG . \'images/\');' . "\n" .
      '  define(\'DIR_WS_INCLUDES\', \'includes/\');' . "\n" .
      '  define(\'DIR_WS_BOXES\', DIR_WS_INCLUDES . \'boxes/\');' . "\n" .
      '  define(\'DIR_WS_DOWNLOAD\',  \'download/\');' . "\n" .
      '  define(\'DIR_WS_FUNCTIONS\', DIR_WS_INCLUDES . DIR_FUNCTIONS);' . "\n" .
      '  define(\'DIR_WS_CLASSES\', DIR_WS_INCLUDES . DIR_CLASSES);' . "\n" .
      '  define(\'DIR_WS_MODULES\', DIR_WS_INCLUDES . \'modules/\');' . "\n" .
      '  define(\'DIR_WS_LIB\', DIR_WS_INCLUDES . \'lib/\');' . "\n" .
      '  define(\'DIR_WS_PLUGINS\', DIR_WS_INCLUDES . \'plugins/\');' . "\n" .
      '  define(\'DIR_WS_FONTS\', DIR_WS_INCLUDES . DIR_FONTS);' . "\n" .
      '  define(\'DIR_WS_JS\', DIR_WS_INCLUDES . \'javascript/\');' . "\n" .
      '  define(\'DIR_WS_WIDGET\', DIR_WS_INCLUDES . \'widget/\');' . "\n" .
      '  define(\'DIR_WS_LANGUAGES\', DIR_WS_INCLUDES . \'languages/\');' . "\n" .
      '  define(\'DIR_WS_CATALOG_LANGUAGES\', DIR_WS_CATALOG . \'includes/languages/\');' . "\n" .
      '  define(\'DIR_FS_CATALOG_LANGUAGES\', DIR_FS_CATALOG . \'includes/languages/\');' . "\n" .
      '  define(\'DIR_FS_CATALOG_IMAGES\', DIR_FS_CATALOG . \'images/\');' . "\n" .
      '  define(\'DIR_FS_CATALOG_MODULES\', DIR_FS_CATALOG . \'includes/modules/\');' . "\n" .
      '  define(\'DIR_FS_BACKUP\', DIR_FS_ADMIN . \'backups/\');' . "\n" .
      '  define(\'DIR_FS_WORK\', \'' . $http_work_directory . '\');' . "\n" .
      '  define(\'DIR_FS_SESSIONS\', DIR_FS_ADMIN . \'sessions/\');' . "\n" .
      '  define(\'DIR_FS_CIP\', DIR_FS_ADMIN . \'contributions/\');' . "\n" .
      '' . "\n" .
      '// Template System files' . "\n" .
      '  define(\'DIR_FS_TEMPLATES\', DIR_FS_CATALOG . \'templates/\');' . "\n" .
      '  define(\'DIR_WS_TEMPLATES\', DIR_WS_CATALOG . \'templates/\');' . "\n" .
      '  define(\'DIR_WS_CATALOG_DOWNLOAD\', DIR_WS_CATALOG . \'download/\');' . "\n" .
      '' . "\n" .
      '// Common' . "\n" .
      '  define(\'DIR_WS_COMMON\', \'common/\');' . "\n" .
      '  define(\'DIR_WS_COMMON_FUNCTIONS\', DIR_WS_COMMON . DIR_FUNCTIONS);' . "\n" .
      '  define(\'DIR_WS_COMMON_FONTS\', DIR_WS_COMMON . DIR_FONTS);' . "\n" .
      '  define(\'DIR_WS_COMMON_CLASSES\', DIR_WS_COMMON . DIR_CLASSES);' . "\n" .
      '  define(\'DIR_WS_COMMON_IMAGES\', DIR_WS_TEMPLATES . \'layout/\');' . "\n" .
      '' . "\n" .
      '// define our database connection' . "\n" .
      '  define(\'DB_CONNECTOR\', \'mysql\');' . "\n" .
      '  define(\'DB_PORT\', \'3306\');' . "\n" .
      '  define(\'DB_CHARSET\', \'utf8\');' . "\n" .
      '  define(\'DB_SERVER\', \'' . $_POST['DB_SERVER'] . '\'); // eg, localhost - should not be empty for productive servers' . "\n" .
      '  define(\'DB_SERVER_USERNAME\', \'' . $_POST['DB_SERVER_USERNAME'] . '\');' . "\n" .
      '  define(\'DB_SERVER_PASSWORD\', \'' . $_POST['DB_SERVER_PASSWORD']. '\');' . "\n" .
      '  define(\'DB_DATABASE\', \'' . $_POST['DB_DATABASE']. '\');' . "\n" .
      '  define(\'DB_TABLE_PREFIX\', \'' . $_POST['DB_TABLE_PREFIX']. '\');' . "\n" .
      '  define(\'USE_PCONNECT\', \'' . ((isset($_POST['USE_PCONNECT']) && $_POST['USE_PCONNECT'] == 'true') ? 'true' : 'false') . '\'); // use persisstent connections?' . "\n" .
      '  define(\'STORE_SESSIONS\', \'mysql\'); // leave empty \'\' for default handler or set to \'mysql\'' . "\n" .


      ''."\n".
      '  /**' . "\n" .
      '   * @brief method login active, separate by ;. the method is call in sort ' . "\n" .
      '   * @example $conf[\'login\']=\'oscss;openid\';' . "\n" .
      '   * @var $conf->login string ' . "\n" .
      '   */' . "\n" .
      '  $conf[\'login\']=\'oscss;\';' . "\n" .
      '' . "\n" .
      '  /**' . "\n" .
      '    @var Security key' . "\n" .
      '    @brief use by offline mode' . "\n" .
      '  */' . "\n" .
      '  $SecuKey=\''.$Key.'\';' . "\n" .
      '?>';


    $fp = fopen($this->fs_document_root .$this->ws_admin_rand.'/includes/configure.php', 'w');
    fputs($fp, $file_contents);
    fclose($fp);



    $file_contents =
      '' . "\n" .
      '#  @licence GPL 2005-'.date('Y').'  The osCSS developers - osCSS Open Source E-commerce   '. "\n" .
      '#  @package oscss-2 <www http://www.oscss.org>'. "\n" .
      '#  @version 2.1.0'. "\n" .
      '#  @date  '.date("Y-m-d").''. "\n" .
      '#  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>'. "\n" .
      '#  @encode UTF-8'. "\n" .
      '# Default OsCss exclusions' . "\n" .
      'User-agent: *' . "\n" .
      'Allow: /' . "\n" .
      ' Disallow: /admin*/' . "\n" .
      ' Disallow: /common/' . "\n" .
      ' Disallow: /download/' . "\n" .
      ' Disallow: /ext/' . "\n" .
      ' Disallow: /images/' . "\n" .
      ' Disallow: /includes/' . "\n" .
      ' Disallow: /install/' . "\n" .
      ' Disallow: /oscss_data/' . "\n" .
      ' Disallow: /sessions/' . "\n" .
      ' Disallow: /templates/' . "\n" .
      ' Disallow: /pub/' . "\n" .
      '' . "\n" .
      '# For sitemaps.xml autodiscovery.' . "\n" .
      ' Sitemap:http://www.monsite.com/sitemapindex.xml' . "\n" .
      '' . "\n";
    $fp = fopen($this->fs_document_root . 'robots.txt', 'w');
    fputs($fp, $file_contents);
    fclose($fp);
  }


  /**
    Installation htaccess rewriting | fichier equivalent
  */
  private function install_rewrite(){

    if(!isset($_POST['install']['rewrite']) || (isset($_POST['install']['rewrite']) &&  $_POST['install']['rewrite'] !='on' ) ) {
      tep_zip_extractto('no_rewrite.zip', '../');
      if(file_exists($this->fs_document_root.'admin'))rename($this->fs_document_root.'admin',$this->fs_document_root.$this->ws_admin_rand);
    }
    elseif((isset($_POST['install']['rewrite']) &&  $_POST['install']['rewrite'] =='on' ) ) {
      /* Ecriture du htaccess admin */
      $file_contents =
    '# $Id: .htaccess,v 2.0 '.date("y.m.d").' oscim  Exp $' . "\n" .
    '# <Directory "/usr/local/apache/htdocs">' . "\n" .
    '#   AllowOverride Options' . "\n" .
    '# </Directory>' . "\n" .
    '# The following makes adjustments to the SSL protocol for Internet' . "\n" .
    '# Explorer browsers' . "\n" .
    '# <IfModule mod_setenvif.c>' . "\n" .
    '#   <IfDefine SSL>' . "\n" .
    '#     SetEnvIf User-Agent ".*MSIE.*" \ ' . "\n" .
    '#              nokeepalive ssl-unclean-shutdown \ ' . "\n" .
    '#              downgrade-1.0 force-response-1.0' . "\n" .
    '#   </IfDefine>' . "\n" .
    '# </IfModule>' . "\n" .
    '# Fix certain PHP values' . "\n" .
    '	AddDefaultCharset UTF-8' . "\n" .
    '# FIX' . "\n" .
    '<IfModule mod_php5.c>' . "\n" .
    '  php_flag register_long_arrays Off' . "\n" .
    '  php_value register_globals off' . "\n" .
    '</IfModule>' . "\n" .

    '<IfModule mod_rewrite.c>' . "\n" .
    '	RewriteEngine on' . "\n" .
    '	RewriteBase '.$this->ws_document_root.$this->ws_admin_rand.'/' . "\n" .
    '' . "\n" .
    '# comment this line , if you not execute cron' . "\n" .
    '	RewriteRule (.*cronfile\.ph.*)$  $1 [L]' . "\n" .
    '' . "\n" .
    '	RewriteCond %{QUERY_STRING} (\<|%3C).*script.*(\>|%3E) [NC,OR]' . "\n" .
    '	RewriteCond %{QUERY_STRING} GLOBALS(=|\[|\%[0-9A-Z]{0,2}) [OR]' . "\n" .
    '	RewriteCond %{QUERY_STRING} _REQUEST(=|\[|\%[0-9A-Z]{0,2})' . "\n" .
    '	RewriteRule ^(.*)$ index.php [F,L]' . "\n" .

    '	RewriteRule  ^$  index.php?page_admin=index [L]' . "\n" .
    '	RewriteRule  ^rss.php  rss.php?%{QUERY_STRING} [L]' . "\n" .
    '' . "\n" .
    '	RewriteRule ^attributeManager/attributeManager/(.*)$  attributeManager/$1 [L]' . "\n" .
    '	RewriteRule ^(attributeManager/.*)$  $1 [L]' . "\n" .
    '	RewriteRule (.*plugins/.*)$  $1 [L]' . "\n" .
    '	RewriteRule (.*editeur/.*)$  $1 [L]' . "\n" .
    '	RewriteRule (.*template/.*)$  $1 [L]' . "\n" .
    '	RewriteRule (.*images/.*)$  $1 [L]' . "\n" .
    '	RewriteRule (.*includes/.*)$  $1 [L]' . "\n" .
    '	RewriteRule (.*\.css)$   $1[L]' . "\n" .

    '	RewriteRule (.*logoff\.ph.*)$  $1 [L]' . "\n" .
    '	RewriteRule (.*login\.ph.*)$  $1 [L]' . "\n" .
    '	RewriteRule (.*password_forgotten\.ph.*)$  $1 [L]' . "\n" .
    '	RewriteRule (.*popup_image\.ph.*)$  $1 [L]' . "\n" .
    '	RewriteRule (.*login\.ph.*)$  $1 [L]' . "\n" .
    '	RewriteRule ([0-9A-Za-z_&=-]*)(.php)?(.*)$  index.php?page_admin=$1&%{QUERY_STRING} [L]' . "\n" .
    '</IfModule>' . "\n";

      $fp = fopen($this->fs_document_root .$this->ws_admin_rand.'/.htaccess', 'w');
      fputs($fp, $file_contents);
      fclose($fp);


      /* Ecriture du htaccess  */
      $file_contents =
    '# $Id: .htaccess,v 2.0 '.date("y.m.d").'  oscim  Exp $' . "\n" .
    '# <Directory "/usr/local/apache/htdocs">' . "\n" .
    '#   AllowOverride Options' . "\n" .
    '# </Directory>' . "\n" .
    '# The following makes adjustments to the SSL protocol for Internet' . "\n" .
    '# Explorer browsers' . "\n" .
    '# <IfModule mod_setenvif.c>' . "\n" .
    '#   <IfDefine SSL>' . "\n" .
    '#     SetEnvIf User-Agent ".*MSIE.*" \ ' . "\n" .
    '#              nokeepalive ssl-unclean-shutdown \ ' . "\n" .
    '#              downgrade-1.0 force-response-1.0' . "\n" .
    '#   </IfDefine>' . "\n" .
    '# </IfModule>' . "\n" .
    '# Fix certain PHP values' . "\n" .

    '## element pur hebergement mutulaiser, a commenter si inutile' . "\n" .
    'SetEnv REGISTER_GLOBALS 0' . "\n" .
    'SetEnv MAGIC_QUOTES 1' . "\n" .
    'SetEnv PHP_VER 5' . "\n" .
    '' . "\n" .
    '# force default charset' . "\n" .
    '	AddDefaultCharset UTF-8' . "\n" .
    '# FIX' . "\n" .
    '<IfModule mod_php5.c>' . "\n" .
    '  php_flag register_long_arrays Off' . "\n" .
    '  php_value register_globals off' . "\n" .
    '</IfModule>' . "\n" .
    '' . "\n" .
    '<IfModule mod_rewrite.c>' . "\n" .
    '' . "\n" .
    '# 404 error ' . "\n" .
    '	ErrorDocument 404 /404.php' . "\n" .
    '' . "\n" .
    '	RewriteEngine on' . "\n" .
    '	RewriteBase '.$this->ws_document_root.'' . "\n" .
    '' . "\n" .
    '	RewriteCond %{QUERY_STRING} (\<|%3C).*script.*(\>|%3E) [NC,OR]' . "\n" .
    '	RewriteCond %{QUERY_STRING} GLOBALS(=|\[|\%[0-9A-Z]{0,2}) [OR]' . "\n" .
    '	RewriteCond %{QUERY_STRING} _REQUEST(=|\[|\%[0-9A-Z]{0,2})' . "\n" .
    '	RewriteRule ^(.*)$ index.php [F,L]' . "\n" .
    '' . "\n" .
    '# rule for 404 page ' . "\n" .
    '	RewriteRule ^404.php$ content.php?_ID=404.php&%{QUERY_STRING}' . "\n" .
    '' . "\n" .
    '##newsletter trace opened email ' . "\n" .
    '	RewriteRule n-([0-9]+)-([0-9]+).jpg newsletters.php?mode=opened&newsID=$1&cID=$2 [L,QSA]' . "\n" .
    '' . "\n" .
    '# DEB Sans rewrite, placer des fichier du même nom a la racine' . "\n" .
    '# DEB Retrocompatibiliter' . "\n" .
    '	RewriteRule ^conditions.php$ content.php?_ID=conditions.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^contact.php$ content.php?_ID=contact.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^cookie_usage.php$ content.php?_ID=cookie_usage.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^info_shopping_cart.php$ content.php?_ID=info_shopping_cart.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^tell_a_friend.php$ content.php?_ID=tell_a_friend.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^featured_products.php$ content.php?_ID=featured_products.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^template.php$ content.php?_ID=template.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^privacy.php$ content.php?_ID=privacy.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^listing_best_sellers.php$ content.php?_ID=listing_best_sellers.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^listing_products_new.php$ content.php?_ID=listing_products_new.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^listing_small_price.php$ content.php?_ID=listing_small_price.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^listing_specials.php$ content.php?_ID=listing_specials.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^search_help.php$ content.php?_ID=search_help.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^ssl_check.php$ content.php?_ID=ssl_check.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^shopping_cart.php(.{0,})$ content.php?_ID=shopping_cart.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^shipping.php(.{0,})$ content.php?_ID=shipping.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^sitemap.php$ content.php?_ID=sitemap.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^remove_cart.php$ content.php?_ID=remove_cart.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^product_reviews.php$ content.php?_ID=listing_reviews.php&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^product_info.php$ index.php?products_id=$2&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^home.php?(.*)$ index.php?content=$1&%{QUERY_STRING}' . "\n" .

    '	RewriteRule ^account_([a-z_]*).php$ account.php?action=$1&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^address_([a-z_]*).php$ account.php?aca_mod=address_book&aca_type=account&aca_action=display_view&%{QUERY_STRING}' . "\n" .
    '' . "\n" .
    '# FIN Sans rewrite, placer des fichier du même nom a la racine' . "\n" .
    '# Prise en charge des appels vers les vidéo' . "\n" .
    '#	 RewriteRule ^playlist:([0-9]*)::type:([a-z]*)::pID:([0-9]*)::ext:.flv$  counter.php?action_type=$2&action_class=portfolio&method=counter_media&ppID=$1&products_id=$3 [L]' . "\n" .
    '#	 RewriteRule ^playlist:([0-9]*)::type:([a-z]*)::pID:([0-9]*)::ext:.mp3  counter.php?action_type=$2&action_class=portfolio&method=counter_media&ppID=$1&products_id=$3 [L]' . "\n" .
    '' . "\n" .
    '' . "\n" .
    '# MODE SEO Rewrite'. "\n" .
    '	RewriteRule ^(.*)-p-(.*).html$ index.php?products_id=$2&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^(.*)-c-(.*).html$ index.php?cPath=$2&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^(.*)-b-(.*).html$ content.php?content=$2&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^(.*)-m-(.*).html$ index.php?manufacturers_id=$2&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^(.*)-pi-(.*).html$ popup_image.php?pID=$2&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^(.*)-t-(.*).html$ content.php?content=$2&%{QUERY_STRING}' . "\n" .
    '#	RewriteRule ^(.*)-pr-(.*).html$ product_reviews.php?products_id=$2&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^(.*)-pr-(.*).html$ content.php?_ID=listing_reviews.php&products_id=$2&%{QUERY_STRING}' . "\n" .
    '#	RewriteRule ^(.*)-pri-(.*).html$ product_reviews_info.php?products_id=$2&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^(.*)-i-(.*).html$ information.php?info_id=$2&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^(.*)-d-(.*).html$ $2.php?divers=$2&%{QUERY_STRING}' . "\n" .
    '	RewriteRule ^(.*)-l-(.*).html$ $2.php?lID=$2&%{QUERY_STRING} [L]' . "\n" .
    '	RewriteRule ^(.*)-u-(.*).html$ index.php?customers_id=$2&%{QUERY_STRING} [L]' . "\n" .
    '' . "\n" .
    '# MODE SEO Rewrite-mode2 '. "\n" .
    '	RewriteRule ^p/([0-9]*)/(.*).html$ index.php?products_id=$1&%{QUERY_STRING}  [L]' . "\n" .
    '	RewriteRule ^c/(.*)/(.*).html$ index.php?cPath=$1&%{QUERY_STRING}  [L]' . "\n" .
    '	RewriteRule ^b/(.*)/(.*).html$ content.php?content=$1&%{QUERY_STRING}  [L]' . "\n" .
    '	RewriteRule ^m/(.*)/(.*).html$ index.php?manufacturers_id=$1&%{QUERY_STRING}  [L]' . "\n" .
    '	RewriteRule ^pi/(.*)/(.*).html$ popup_image.php?pID=$1&%{QUERY_STRING} [L]' . "\n" .
    '	RewriteRule ^t/(.*)/(.*).html$ content.php?content=$1%{QUERY_STRING} [L]' . "\n" .
    '	RewriteRule ^pr/(.*)/(.*).html$ content.php?_ID=listing_reviews.php&products_id=$1&%{QUERY_STRING} [L]' . "\n" .
    '	RewriteRule ^i/(.*)/(.*).html$ information.php?info_id=$1&%{QUERY_STRING} [L]' . "\n" .
    '	RewriteRule ^d/(.*)/(.*).html$ $1.php?divers=$1.php&%{QUERY_STRING} [L]' . "\n" .
    '	RewriteRule ^l/(.*)/(.*).html$ $1.php?lID=$1&%{QUERY_STRING} [L]' . "\n" .
    '	RewriteRule ^u/(.*)/(.*).html$ index.php?customers_id=$1&%{QUERY_STRING} [L]' . "\n" .
    '</IfModule>' . "\n";

      $fp = fopen($this->fs_document_root . '.htaccess', 'w');
      fputs($fp, $file_contents);
      fclose($fp);

    }
    else return false;

  }

  /**
    Installation  fichier suplementaires
  */
  private function install_extents(){

    $file='includes/tables_files_modules.php';
    $file_contents='<?php' . "\n" .
		    '/**' . "\n" .
		    ' @licence GPL 2005-'.date('Y').'  The osCSS developers - osCSS Open Source E-commerce' . "\n" .
		    ' @package oscss-2 <www http://www.oscss.org>' . "\n" .
		    ' @date  '.date("Y/m/d").'' . "\n" .
		    ' @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>' . "\n" .
		    ' @encode UTF-8' . "\n" .
		    ' Placer ici Vos definition de table et filename pour les elements modulaire, extensions et plugins.' . "\n" .
		    'ex:' . "\n" .
		    '  define(\'TABLE_EPF\',  DB_TABLE_PREFIX .\'products_virtual\');' . "\n" .
		    '*/' . "\n" .
		    '?>';
    $fp = fopen($this->fs_document_root .$this->ws_admin_rand.'/'.$file, 'w');
    fputs($fp, $file_contents);
    fclose($fp);

    $fp = fopen($this->fs_document_root .'/'.$file, 'w');
    fputs($fp, $file_contents);
    fclose($fp);
  }

  /**
    Config site_monitor
  */
  public function install_sitemonitor(){
    //! config site_monitor
    $file_contents =
      '<?php' . "\n" .
	'/************** THE OPTIONS AND SETTINGS ****************/' . "\n" .
	'$always_email = 1; //set to 1 to always email the results' . "\n" .
	'$verbose = 1; //set to 1 to see the results displayed on the page (for when running manually)' . "\n" .
	'$logfile = 1; //set to 1 to see to track results in a log file' . "\n" .
	'$logfile_size = 100000; //set the maximum size of the logfile' . "\n" .
	'$reference_reset = 0; //delete the reference file this many days apart' . "\n" .
	'$quarantine = 0; //set to 1 to move new files found to the quarantine directory' . "\n" .
	'$to = \''.$_POST['EMAIL_ADMIN'].'\'; //where email is sent to' . "\n" .
	'$from = \'From: webmestre'.$this->cookie_domain .'\'; //where email is sent from' . "\n" .
	'$start_dir = \''.$this->fs_document_root .'\'; //your shops root' . "\n" .
	'$admin_dir = \''.$this->fs_document_root .$this->ws_admin_rand.'\'; //your shops admin' . "\n" .
	'$admin_username = \'username\'; //your admin username' . "\n" .
	'$admin_password = \'password\'; //your admin password' . "\n" .
	'$excludeList = array("b2.0.9k/osCSS-2/admin177/quarantine", "admin/quarantine", "cgi-bin","admin"); //don\'t check these directories - change to your liking - must be set prior to first run' . "\n" .
      ' ?>' ;

    $fp = fopen($this->fs_document_root .$this->ws_admin_rand.'/includes/sitemonitor_configure.php', 'w');
    fputs($fp, $file_contents);
    fclose($fp);
  }
  /**
    @package oscss-2 <www http://www.oscss.org>
    @author oscim - OscssTeam
    @version 2.0
    @note Appel de function. ou de class
  */
  private function tep_call_function($function, $parameter, $object = '') {
    $this->get_db_conf();
    osc_db_connect($this->db['DB_SERVER'], $this->db['DB_SERVER_USERNAME'], $this->db['DB_SERVER_PASSWORD']);
    osc_db_select_db($this->db['DB_DATABASE']);
    if (is_string($object) && $object == '') return call_user_func($function, $parameter);
    else return call_user_func(array($object, $function), $parameter);
  }

  private function recup_db_conf_plus(){
    $this->get_db_conf();
    osc_db_connect($this->db['DB_SERVER'], $this->db['DB_SERVER_USERNAME'], $this->db['DB_SERVER_PASSWORD']);
    osc_db_select_db($this->db['DB_DATABASE']);
    $configuration_query = osc_db_query("select * from ".TABLE_CONFIGURATION." where configuration_key in ('STORE_COUNTRY','STORE_OWNER','SHIPPING_ORIGIN_COUNTRY','SHIPPING_ORIGIN_ZIP') order by sort_order");

      $list_edit=array();
      while ($configuration = tep_db_fetch_array($configuration_query)) {
	if (!empty($configuration['use_function'])) {
	  $use_function = $configuration['use_function'];
	  if (preg_match('/->/', $use_function)) {
	    $class_method = explode('->', $use_function);
	    if (!is_object(${$class_method[0]})) {
	      include($this->fs_document_root.$this->ws_admin_rand.'/includes/classes/'. $class_method[0] . '.php');
	      ${$class_method[0]} = new $class_method[0]();
	    }
	    $cfgValue = $this->tep_call_function($class_method[1], $configuration['configuration_value'], ${$class_method[0]});
	  } else {
	    $cfgValue = $this->tep_call_function($use_function, $configuration['configuration_value']);
	  }
	} else {
	  $cfgValue = $configuration['configuration_value'];
	}
      if ($configuration['set_function']) eval($s[]='$value_field = ' . $configuration['set_function'] . '"' . htmlspecialchars($configuration['configuration_value']) . '","'.$configuration['configuration_key'].'");');
      else $value_field = osc_draw_input_field('configuration['.$configuration['configuration_key'].']', '',$configuration['configuration_value']);
      $configuration['cfgValue']=$cfgValue;
      $configuration['value_field']=$value_field;

      $list_edit[]=$configuration;
    }
    return $list_edit;
  }

  /**
    Callback
  */
  public function exe_prev(){
    $this->get_fs_document_root();
    $this->get_server_conf();
    $this->get_db_conf();
    define('DB_TABLE_PREFIX', $this->db['DB_TABLE_PREFIX']);
    define('DIR_WS_MODULES', $this->fs_document_root.$this->ws_admin_rand.'/includes/modules/');
    include($this->fs_document_root.$this->ws_admin_rand.'/includes/database_tables.php');
    osc_db_connect($this->db['DB_SERVER'], $this->db['DB_SERVER_USERNAME'], $this->db['DB_SERVER_PASSWORD']);
    osc_db_select_db($this->db['DB_DATABASE']);

    $this->install_sitemonitor();


    /**
      Config base
    */
    osc_db_query($sql="update ".$this->db['DB_TABLE_PREFIX']."admin set admin_email_address='".$_POST['EMAIL_ADMIN']."' where  admin_id='1'" );
    osc_db_query($sql="update ".$this->db['DB_TABLE_PREFIX']."configuration set configuration_value='".$_POST['STORE_NAME']."' where  configuration_key='STORE_OWNER_EMAIL_ADDRESS'" );
    osc_db_query($sql="update ".$this->db['DB_TABLE_PREFIX']."configuration set configuration_value='".$_POST['STORE_NAME']."' where  configuration_key='EMAIL_FROM'" );
    osc_db_query($sql="update ".$this->db['DB_TABLE_PREFIX']."configuration set configuration_value='".$_POST['STORE_NAME']."' where  configuration_key='STORE_NAME'" );


    /**
      Config avancé
    */
    if(is_array($_POST['configuration'] ))
    foreach($_POST['configuration'] as $key=>$cfg){
	$configuration_value = tep_db_prepare_input($_POST['configuration'][$key]);
	tep_db_query($sql="update " . TABLE_CONFIGURATION . " set configuration_value = '" . tep_db_input($configuration_value) . "', last_modified = now() where configuration_key = '" . $key. "'");
      }

    /**
      Langue supplementaire
      execution dans etape suivante
    */


    /**
      Email admin
    */
    $headers = 'From: webmaster@'. $this->cookie_domain. "\r\n" .
    'Reply-To: webmaster@'.$this->cookie_domain . "\r\n" .
    'X-Mailer: PHP/' . phpversion();

    $message =core::l10n("Votre nouvelle boutique osCSS est maintenant installé. ")."\n"
	      .core::l10n("Vos accès à votre espace privé de gestion sont:")."\n"
              .$_POST['HTTP_WWW_ADDRESS'].$this->ws_admin_rand."/ \n"
              .core::l10n(" Votre mot de passe ")." admin \n";

    if(!@mail($_POST['EMAIL_ADMIN'],core::l10n("Votre nouveau osCSS-2"),$message, $headers )) $this->PileMessage('alert', core::l10n("L'Email n'a pas été envoyé !")  , array(explode("\n",$message))) ;
    else $this->PileMessage('succes', core::l10n("L'Email a été envoyé à ".$_POST['EMAIL_ADMIN'] )  , array(explode("\n",$message))) ;
  }

  /**
    Form d'etape
  */
  function draw_form(){
    $this->writeMessage();
    echo '<form id="install" action="?etape='.$this->get_current_etape(1).'" method="post">'."\n";
    $this->repet_post();


    echo '<h3>'.core::l10n("Obligatoire").'</h3>'."\n";

    echo '<p class="smallDesc">'."\n"
	.'<label>'.core::l10n('Adresse email administrateur:').'</label>'."\n"
	.osc_draw_input_field('EMAIL_ADMIN')
	.core::draw_help('EmailAdminSD', core::l10n("L'adresse Email de l'administrateur")/*, core::l10n("L'adresse en ligne du magasin, comme par exemple <em>http://www.my-server.com/catalog/</em>")*/)."\n"
	.'</p>'."\n";


    echo '<h3>'.core::l10n("Langue(s) supplementaire(s)").'</h3>'."\n";

    echo '<ul>';
    foreach(core::browse_rep('data/language/') as $langue){
      echo '<li>'
	    .'<label><img src="data/language/'.$langue['file'].'/public/'.$langue['file'].'/images/icon.gif" /> '.core::l10n("Ajouter la langue ".$langue['file']).'</label>'."\n"
	    .osc_draw_checkbox_field('lang['.$langue['file'].']').core::l10n(" Coté boutique");
      if(file_exists('data/language/'.$langue['file'].'/admin/'.$langue['file']))echo osc_draw_checkbox_field('lang_admin['.$langue['file'].']').core::l10n(" Espace Privé admin");
      echo ' </li>';
    }
    echo '</ul><br />';

    echo '<h3>'.core::l10n("Optionnel, vous pouvez le régler plus tard").'</h3>'."\n";

    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n('Nom de la boutique:').'</label>'."\n"
        .osc_draw_input_field('STORE_NAME', '','osCSS-2 demo shop')."\n"
        .core::draw_help('StoreName', core::l10n("Le nom du site, nom utilisé pour les Emails, les contact... ")/*, core::l10n("Le nom de la boutique")*/)."\n"
        .'</p>'."\n";

    foreach($this->recup_db_conf_plus() as $configuration) {
      echo '<p class="smallDesc">'."\n"
	  .'<label>'.core::l10n($configuration['configuration_title']).'</label>'."\n"
	  .$configuration['value_field']
	  .core::draw_help($configuration['configuration_key'], core::l10n($configuration['configuration_description']))."\n"
	  .'</p>'."\n";
    }

    echo $this->draw_button(true);
    echo '</form>'."\n";
  }

  /**
    Js control
  */
  private static function jscontrol(){
    ?>
    <script type="text/javascript"><!--
    $().ready(function() {
      // Validation de formulaire avec jquery.validate
      $("#install").validate({
	rules: {
	  EMAIL_ADMIN: {
	    required: true,
	    email: true,
	  },
	  errorElement: "span",
	  errorPlacement: function(error, element) {
	    error.appendTo( element.parent());
	  },
	  onkeyup: true
	},
      });
    });
    //--></script>
    <?php
  }


  function draw(){

    //! recup conf
    $this->get_fs_document_root();
    $this->get_server_conf();
    $this->get_db_conf();
    if(file_exists($this->fs_document_root.'admin')) rename($this->fs_document_root.'admin',$this->fs_document_root.$this->ws_admin_rand);

    define('TABLE_CONFIGURATION', $this->db['DB_TABLE_PREFIX'].'configuration');
    define('TABLE_COUNTRIES', $this->db['DB_TABLE_PREFIX'].'countries');

    //! dependance
    require($this->fs_document_root.$this->ws_admin_rand.'/includes/functions/lib.configuration.php');



    //! ecriture des fichier de conf
    $this->install_base_conf();
    $this->install_rewrite();
    $this->install_extents();

    //! draw form etape
    $this->draw_form();

    $this->jscontrol();
  }
}

?>