<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package oscss-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  09/11/10, 09:10
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @author Ayatus <www http://www.ayatus.org>
  @encode UTF-8
*/


class installdb extends core {



  /**
    Installation du systeme de base, creation table + insertion conf
  */
  private function  install_base_db(){
      $this->get_fs_document_root();
      $this->get_db_conf();

      osc_db_connect($this->db['DB_SERVER'], $this->db['DB_SERVER_USERNAME'], $this->db['DB_SERVER_PASSWORD']);
      osc_db_select_db($this->db['DB_DATABASE']);
      $db_error = false;
      $sql_file = $this->fs_document_root . 'install/oscss.sql';

      osc_set_time_limit(0);

      osc_db_install($this->db['DB_DATABASE'], $sql_file, $this->db['DB_TABLE_PREFIX']);
      if ( ($db_error == false) ) {
	$sql_file = $this->fs_document_root . 'install/oscss_config.sql';
	osc_db_install($this->db['DB_DATABASE'], $sql_file, $this->db['DB_TABLE_PREFIX']);
      }

      if ($db_error != false) $this->PileMessage('error', core::l10n("Un problème à eu lieu durant la phase d'installation de la base de données" )  ) ;
      else $this->PileMessage('succes', core::l10n("L'installation de la base de données est ok" )  ) ;
  }

  private function  upgrade_base_db($file){
      $this->get_fs_document_root();
      $this->get_db_conf();

      osc_db_connect($this->db['DB_SERVER'], $this->db['DB_SERVER_USERNAME'], $this->db['DB_SERVER_PASSWORD']);
      osc_db_select_db($this->db['DB_DATABASE']);
      $db_error = false;
      $sql_file = $this->fs_document_root . 'install/includes/upgrade/'.$file.'.sql';

//       osc_set_time_limit(0);
//
      osc_db_upgrade($this->db['DB_DATABASE'], $sql_file, $this->db['DB_TABLE_PREFIX']);
//
//       if ($db_error != false) $this->PileMessage('error', core::l10n("Un problème à eu lieu durant la phase d'installation de la base de données" )  ) ;
//       else $this->PileMessage('succes', core::l10n("L'installation de la base de données est ok" )  ) ;
  }

  /**
    Callback
  */
  function exe_prev(){
    // conf
    $this->get_server_conf();
    $this->get_db_conf();
    osc_db_connect($this->db['DB_SERVER'], $this->db['DB_SERVER_USERNAME'], $this->db['DB_SERVER_PASSWORD']);
    osc_db_select_db($this->db['DB_DATABASE']);
    /* Mise a jour db et config diverse */
    osc_db_query($sql="update ".$this->db['DB_TABLE_PREFIX']."configuration set configuration_value='".$this->fs_document_root.$this->ws_admin_rand."/sessions/page_parse_time.log' where  configuration_key='STORE_PAGE_PARSE_TIME_LOG'" );
    osc_db_query($sql="update ".$this->db['DB_TABLE_PREFIX']."configuration set configuration_value='".substr(DC_LOADER_LANG,0,2)."' where  configuration_key='DEFAULT_LANGUAGE'" );
    osc_db_query($sql="update ".$this->db['DB_TABLE_PREFIX']."configuration set configuration_value='".$this->www_location."images/oscss_logo.png' where  configuration_key='STORE_LOGO'" );
    osc_db_query($sql="update ".$this->db['DB_TABLE_PREFIX']."configuration set configuration_value='".$this->www_location."images/oscss_logo.jpg' where  configuration_key='STORE_LOGO_PRINT'" );
    osc_db_query($sql="update ".$this->db['DB_TABLE_PREFIX']."configuration set configuration_value='".$this->www_location."images/noscreenshot.png' where  configuration_key='IMAGE_NONEXISTENT'" );

    $this->PileMessage('succes', core::l10n("La configuration est terminée" )  ) ;
  }

  /**
    Formulaire etape
  */
  function draw_form(){
      $this->writeMessage();

     if(isset($_POST['upgrade']) )
      echo '<hr />';

      foreach(parent::browse_rep('includes/upgrade') as $version){
	if(!isset($_POST['up_upgrade'][$version['name']])) {
	  echo '<form id="install" action="?etape='.$this->get_current_etape().'&amp;upgrade=true" method="post">'."\n";
	    $this->repet_post();
	    echo 	"<p>" .core::l10n("Mettre a niveau la base de donnée, de la version" ).
		  ' '. substr($version['name'],0,strpos($version['name'],'-')).
		  ' '.core::l10n("a" ).' '.substr($version['name'],strpos($version['name'],'-')+1).
		  osc_draw_hidden_field('upgrade', '', $version['name']) .
		  ' <input type="submit"  class="submitBt" name="up_bouton_'.$version['name'].'" value="'.core::l10n("Mettre a jour" ).'" />';
	  echo "</p>\n".'</form>'."\n";
	}
      }

    echo '<hr />';
      echo '<form id="install" action="?etape='.$this->get_current_etape().'&amp;upgrade=true" method="post">'."\n";
	$this->repet_post();
	echo 	"<p>" .core::l10n("Nouvelle installation. Supprime les données de la base si elles esistent " ).
	      ' '.osc_draw_hidden_field('upgrade', '','install') .
	      ' <input type="submit"  class="submitBt" name="up_bouton_'.$version['name'].'" value="'.core::l10n("Installer" ).'" />';
      echo "</p>\n".'</form>'."\n";
  echo '<hr />';

      echo '<form id="install" action="?etape='.$this->get_current_etape(1).'" method="post">'."\n";
      $this->repet_post();
      if(isset($_POST['upgrade'])) echo osc_draw_hidden_field('up_upgrade['.$_POST['upgrade'].']', '', $version['name']);
      echo $this->draw_button();
      echo '</form>'."\n";
  }

  /**

  */
  function draw(){
    // conf
    $this->get_server_conf();
    // exe install db oscss
    if(!isset($_POST['db_exists']) || !(bool)$_POST['db_exists']) $this->install_base_db();

    // upgrade
    if(isset($_POST['upgrade']) && tep_not_null($_POST['upgrade']) ){
      if($_POST['upgrade'] =='install') $this->install_base_db();
      else $this->upgrade_base_db($_POST['upgrade']);
    }

    // content
    $this->draw_form();
  }
}

?>