<?php
/**
  @licence GPL 2005-2011  The osCSS developers - osCSS Open Source E-commerce
  @portion code Copyright (c) 2002 osCommerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  24/03/11, 09:41
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
  @class modes

  Etape preparation, renseigne elment db, pass, serveur, etc..
  Si mise a jour, passe etape configuration direct
*/


class modes
  extends core {




  /**
    Formulaire complet , prenant en compte les étapes et options
  */
  private function draw_form(){
    global $install;

    if($this->err):
      $this->PileMessage('alert', core::l10n("Test de connexion à la base de données échoué. Corriger cette alerte pour continuer l'installation") );
      $this->writeMessage();
      echo '<form id="install" action="?etape='.$this->get_current_etape().'" method="post">'."\n";
      echo "<p>" . osc_draw_hidden_field('DB_TEST_CONNECTION', '', 'true') . "</p>\n";
      $this->repet_post();

    elseif(isset($_POST['go_test']) && !$this->err):
      $this->PileMessage('succes',core::l10n("Test db correct"));

      if($this->db_exists) $this->PileMessage('succes',core::l10n("database existe, force mode upgrade"));

      $this->writeMessage();


      echo '<form id="install" action="?etape='.$this->get_current_etape(1).'" method="post">'."\n";
      $this->repet_post();

      /** Test si db oscss deja existante, si c'est le cas, force mode upgrade db */
      if($this->db_exists)echo "<p>" . osc_draw_hidden_field('db_exists', '', 'true') . "</p>\n";


      echo '<h2>'.core::l10n("Serveur").'</h2>'."\n";
      echo '<h3>'.core::l10n("Important").'</h3>'."\n";
      echo '<p class="smallDesc">'."\n"
	  .'<label>'.core::l10n('Adresse WWW :').'</label>'."\n"
	  .osc_draw_input_field('HTTP_WWW_ADDRESS', '', $this->www_location)."\n"
	  .core::draw_help('httpWWW', core::l10n("L'adresse en ligne du magasin, comme par exemple <em>http://www.my-server.com/catalog/</em>")/*, core::l10n("L'adresse WEB complète du magasin en ligne")*/)."\n"
	  .'</p>'."\n";

      echo '<p class="smallDesc">'."\n"
	  .'<label>'.core::l10n('Répertoire racine de votre serveur :').'</label>'."\n"
	  .osc_draw_input_field('DIR_FS_DOCUMENT_ROOT', '', $this->fs_document_root)."\n"
	  .core::draw_help('httpRoot', core::l10n('Répertoire racine de votre serveur où sont stockées vos pages, habituellement : <em>/home/myname/public_html/osCSS-2/</em>')/*, core::l10n('Répertoire racine de votre serveur')*/)."\n"
	  .'</p>'."\n";

      echo '<p class="smallDesc">'."\n"
	  .'<label>'.core::l10n('Le chemin du backoffice:').'</label>'."\n"
	  .osc_draw_input_field('WS_STORE_ADMIN', '',$this->ws_admin_rand)."\n"
	  .(($_POST['install']['modes'] =='update') ? core::l10n('le chemin de la partie privé doit être le chemin actuel vers votre backoffice, sans quoi la mise a jour provoquera une erreur') : '')
	  .core::draw_help('wsStoreADmin', core::l10n("dans lequel sera placé votre accès privé")/*, core::l10n("Le repertoire du backoffice")*/)."\n"
	  .'</p>'."\n";

      echo '<h3>'.core::l10n("Optionnel, à vérifier").'</h3>'."\n";

      echo '<p class="smallDesc">'."\n"
	  .'<label>'.core::l10n('Domaine HTTP Cookie :').'</label>'."\n"
	  .osc_draw_input_field('HTTP_COOKIE_DOMAIN', '', $this->cookie_domain)."\n"
	  .core::draw_help('httpCookieD', core::l10n('Le domaine pour stocker les cookies, par exemple : <em>.my-server.com</em>')/*, core::l10n('Le domaine pour stocker les cookies')*/)."\n"
	  .'</p>'."\n";

      echo '<p class="smallDesc">'."\n"
	  .'<label>'.core::l10n('Chemin HTTP Cookie :').'</label>'."\n"
	  .osc_draw_input_field('HTTP_COOKIE_PATH', '', $this->cookie_path)."\n"
	  .core::draw_help('httpCookieP', core::l10n('Le chemin pour stocker les cookies, par exemple : <em>/catalog/</em>')/*, core::l10n('Le chemin pour stocker les cookies')*/)."\n"
  // 		.'<div id="httpCookiePSD">'..'</div>'."\n"
	  .'</p>'."\n";

      echo '<p class="smallDesc">'."\n"
	  .'<label>'.core::l10n('Répertoire de travail:').'</label>'."\n"
	  .osc_draw_input_field('HTTP_WORK_DIRECTORY', '', $this->fs_document_root . 'oscss_data')."\n"
	  .core::draw_help('httpWork', core::l10n("Ce chemin peut être en dehors du répertoire HTML public, il est même recommandé d'utiliser un répertoire qui ne soit pas accessible par le web. Pour des raisons de sécurité n'utilisez pas le répertoire /tmp/ .")/*, core::l10n('Le chemin du repertoire ou osCSS stockeras ses informations (cache, sessions)')*/)."\n"
	  .'</p>'."\n";

      echo '<p class="smallDesc">'."\n"
	  .'<label>'.core::l10n('Activer les connections persistantes :').'</label>'."\n"
	  .osc_draw_checkbox_field('USE_PCONNECT', '', 'off', ((isset($_POST['USE_PCONNECT']) &&  $_POST['USE_PCONNECT']=='true')?true :false))."\n"
	  .core::draw_help('dbConn', core::l10n("Permettez les connections persistantes à la base de données."))."\n"
	  .'</p>'."\n";

      echo '<p class="smallDesc">'."\n"
	  .'<label>'.core::l10n('Stockage de session publique :').'</label>'."\n"
	  .osc_draw_radio_field('STORE_SESSIONS', 'storeFile', 'files', ( (!isset($_POST['STORE_SESSIONS'])|| $_POST['STORE_SESSIONS'] == 'files')? true : false)).core::l10n('Fichiers'). osc_draw_radio_field('STORE_SESSIONS', 'storeDB', 'mysql',  ( (isset($_POST['STORE_SESSIONS'])&& $_POST['STORE_SESSIONS'] == 'mysql')? true : false)).core::l10n('Base de données')."\n"
	  .core::draw_help('sessStore', core::l10n("Stockez les données de session d'utilisateur public comme fichiers sur le serveur, ou dans la base de données.<br />Note : Pour plus de sécurité, le stockage des sessions sur la base de données est recommandé pour les serveurs partagés.")/*, core::l10n('Utiliser le rewriting (doit être installé)')*/)."\n"
	  .'</p>'."\n";

	if(isset($_POST['ENABLE_SSL']) &&  $_POST['ENABLE_SSL']=='on') $this->connexion_ssl();
	echo $this->draw_button();
	echo '</form>'."\n";

      return;

    else:

      echo '<form id="install" action="?etape='.$this->get_current_etape().'" method="post">'."\n";
      $this->repet_post();
      echo "<p>" . osc_draw_hidden_field('DB_TEST_CONNECTION', '', 'true') . "</p>\n";

    endif;


      echo '<h2>'.core::l10n("Type d'installation").'</h2>'."\n";

    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n("Mode d'installation :").'</label>'."\n"
        .osc_draw_radio_field('install[modes]', 'modeInstall', 'install', ( (!isset($_POST['install']['modes']) || (isset($_POST['install']['modes'])&& $_POST['install']['modes'] == 'install'))? true : false) ).core::l10n("Install").' '
        .osc_draw_radio_field('install[modes]', 'modeUpdate', 'update', ( (isset($_POST['install']['modes'])&& $_POST['install']['modes'] == 'update')? true : false)).core::l10n("Update valable pour les version 2.xx uniquement").' '
        .core::draw_help('modesConfig', core::l10n("Cette option vous permet de ré-écrire vos fichier de configuration (après déplacement), ou d'installer complètement votre boutique (effacement de la db).")/*, core::l10n("installer votre boutique, où juste mettre à jour les fichiers de configuration")*/)."\n"
          .'</p>'."\n";

    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n('Rewriting :').'</label>'."\n"
        .osc_draw_checkbox_field('install[rewrite]', '', 'on', true)."\n"
        .core::draw_help('rewriteConfig', core::l10n("Cette option permet d'exploiter les rewriting , donc le SEO. Il est nécessaire que votre serveur le supporte.")/*, core::l10n('Utiliser le rewriting (doit être installé)')*/)."\n"
        .'</p>'."\n";


      echo '<h2>'.core::l10n("Base de donnée").'</h2>'."\n";


    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n('Serveur de Base de données :').'</label>'."\n"
        .osc_draw_input_field('DB_SERVER', '',( isset($_POST['DB_SERVER'])? $_POST['DB_SERVER'] : 'localhost'))."\n"
        .core::draw_help('dbHost', core::l10n("Le serveur de base de données peut être sous forme de chemin, tel que db1.myserver.com, ou en tant qu'adresse IP comme 192.168.0.1")/*, core::l10n('Chemin ou adresse IP du serveur de base de données')*/)."\n"
        .'</p>'."\n";

    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n("Nom d'utilisateur :").'</label>'."\n"
        .osc_draw_input_field('DB_SERVER_USERNAME', '',( isset($_POST['DB_SERVER_USERNAME'])? $_POST['DB_SERVER_USERNAME'] : '') )."\n"
        .core::draw_help('dbUser', core::l10n("Le nom d'utilisateur est utilisé pour se connecter à la base de données. Un exemple de nom d'utilisateur : mysql_10.<br />Note: Les permissions Create et Drop <strong>sont requises</strong> à ce moment de la procédure d'installation.")/*, core::l10n("Nom d'utilisateur")*/)."\n"
        .'</p>'."\n";

    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n('Mot de passe :').'</label>'."\n"
        .osc_draw_password_field('DB_SERVER_PASSWORD', '',( isset($_POST['DB_SERVER_PASSWORD'])? $_POST['DB_SERVER_PASSWORD'] : ''))."\n"
        .core::draw_help('dbPass', core::l10n("Le mot de passe est employé avec le nom d'utilisateur, ce qui forme le compte utilisateur de votre base de données.")/*, core::l10n('Mot de passe de la base de données')*/)."\n"
        .'</p>'."\n";

    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n('Nom de la base de données :').'</label>'."\n"
        .osc_draw_input_field('DB_DATABASE', '',( isset($_POST['DB_DATABASE'])? $_POST['DB_DATABASE'] : 'osCSS'))."\n"
        .core::draw_help('dbName', core::l10n('La base de données contient les données du catalogue. Un exemple de nom de base de données : oscss.')/*, core::l10n('Nom de la base de données')*/)."\n"
        .'</p>'."\n";

    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n('Préfixe des tables :').'</label>'."\n"
        .osc_draw_input_field('DB_TABLE_PREFIX', '',( isset($_POST['DB_TABLE_PREFIX'])? $_POST['DB_TABLE_PREFIX'] : 'osc_'))."\n"
        .core::draw_help('dbNamePrefix', core::l10n('Le prefix à utiliser pour les tables crées sur la base de données. Un exemple de préfixe de table : "osc_" ce qui créera une table nommée osc_products.')/*, core::l10n('Préfix des tables de la base de données')*/)."\n"
        .'</p>'."\n";


      echo '<h2>'.core::l10n("Serveur").'</h2>'."\n";
    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n('Activer les connections SSL:').'</label>'."\n"
        .osc_draw_checkbox_field('ENABLE_SSL', '', ( (isset($_POST['ENABLE_SSL'])&& $_POST['ENABLE_SSL'] == 'true')? true : false) )."\n"
        .core::draw_help('httpSSL', core::l10n('Activer les connections sécurisé SSL (HTTPS) (exige un certificat installé sur le serveur web).')/*, core::l10n('Activer les connections SSL:')*/)."\n"
        .'</p>'."\n";

	echo "<p>".osc_draw_hidden_field('go_test', '', true)."</p>\n";
    echo $this->draw_button();
    echo '</form>'."\n";

  }


  /**
    Supplement formulaire pour connexion securisée
  */
  private function connexion_ssl(){

      echo '<h2>'.core::l10n("Connexion sécurisée").'</h2>'."\n";

    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n('Adresse WWW sécurisée :').'</label>'."\n"
        .osc_draw_input_field('HTTPS_WWW_ADDRESS', '', $this->https_www_address)."\n"
        .core::draw_help('httpsWWW', core::l10n("L'adresse WEB sécurisé du magasin en ligne, par exemple <em>https://ssl.my-hosting-company.com/my_name/catalog/</em>"), core::l10n("L'adresse WEB sécurisé du magasin en ligne"))."\n"
        .'</p>'."\n";

    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n('Domaine Cookie Sécurisé :').'</label>'."\n"
        .osc_draw_input_field('HTTPS_COOKIE_DOMAIN', '', $this->cookie_domain)."\n"
        .core::draw_help('httpsCookieD', core::l10n('Le domaine sécurisé pour stocker les cookies, par exemple <em>ssl.my-hosting-company.com</em>'), core::l10n('Le domaine sécurisé pour stocker les cookies'))."\n"
        .'</p>'."\n";

    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n('Chemin Cookie Sécurisé :').'</label>'."\n"
        .osc_draw_input_field('HTTPS_COOKIE_PATH', '', $this->cookie_path)
        .core::draw_help('httpsCookieP', core::l10n('Le chemin sécurisé pour stocker les cookies, par exemple <em>/my_name/catalog/</em>'), core::l10n('Le chemin sécurisé pour stocker les cookies'))."\n"
        .'</p>'."\n";

  }





  /**
    Js control
  */
  private static function jscontrol(){
    ?>
    <script type="text/javascript"><!--
    $().ready(function() {
      // Validation de formulaire avec jquery.validate
      $("#install").validate({
	rules: {
	  DB_SERVER: "required",
	  DB_SERVER_USERNAME: "required",
// 	  DB_SERVER_PASSWORD: "required",
	  DB_DATABASE: "required",
	  errorElement: "span",
	  errorPlacement: function(error, element) {
	    error.appendTo( element.parent());
	  },
	  onkeyup: true
	},
      });
    });
    //--></script>
    <?php
  }

  /**
    Callback
  */
  function exe_prev(){
  }

  function draw(){

    global $db_error;


    $this->err=false;
    $db_error=true;

    if (isset($_POST['DB_SERVER']) && !empty($_POST['DB_SERVER']) && isset($_POST['DB_TEST_CONNECTION']) && ($_POST['DB_TEST_CONNECTION'] == 'true')) {
      $db = array();
      $db['DB_SERVER'] = trim(stripslashes($_POST['DB_SERVER']));
      $db['DB_SERVER_USERNAME'] = trim(stripslashes($_POST['DB_SERVER_USERNAME']));
      $db['DB_SERVER_PASSWORD'] = trim(stripslashes($_POST['DB_SERVER_PASSWORD']));
      $db['DB_DATABASE'] = trim(stripslashes($_POST['DB_DATABASE']));
      $db['DB_TABLE_PREFIX'] = trim(stripslashes($_POST['DB_TABLE_PREFIX']));



      if ( osc_db_connect($db['DB_SERVER'], $db['DB_SERVER_USERNAME'], $db['DB_SERVER_PASSWORD']) != false) {
	if(!osc_db_select_db($db['DB_DATABASE']))
	  $db_error=(osc_db_test_create_db_permission($db['DB_DATABASE']) ==true)? false : true;
      }
      else $db_error=false;

      /** Test si db oscss deja existante, si c'est le cas, force mode upgrade db */
      if ($db_error == false) {
	$final=array();
	$res=osc_db_query('SHOW TABLES FROM '.$db['DB_DATABASE']);
	if(tep_db_num_rows($res)>0){
	  while($table=tep_db_fetch_array($res))
	    $final[]=$table['Tables_in_'.$db['DB_DATABASE']];
	}

	$this->db_exists=(in_array($db['DB_TABLE_PREFIX'].'customers',$final))? true : false;

      }

      if($db_error == false) $this->err=false;
      else $this->err=true;
      $this->get_server_conf();
    }



    $this->draw_form();
    $this->jscontrol();
  }
}

?>