<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package oscss-2 <www http://www.oscss.org>
  @version 2.1.0
  @date  12/12/10, 09:15
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @author Ayatus <www http://www.ayatus.org>
  @encode UTF-8

  Structure de répertoire associé au exemple et template/

  Les répertoires d'exemple, dans /data/sample
    Les sous-répertoires (photo[chaussure)

  Les répertoires de template /sample/templates
    Les sous-répertoires d'exemple (photo[chaussure)
      Les différents templates,  /sample/templates/photo/template1 | /sample/templates/photo/template2
*/

define('I_WS_DATA', 'data/');

class template_sample extends core {


  /**
    Function exécutée par la class Suivante
  */
  public function exe_prev(){
    $this->get_fs_document_root();
    $this->get_server_conf();
    $this->get_db_conf();
    define('DB_TABLE_PREFIX', $this->db['DB_TABLE_PREFIX']);
    define('DIR_WS_MODULES', $this->fs_document_root.$this->ws_admin_rand.'/includes/modules/');
    include($this->fs_document_root.$this->ws_admin_rand.'/includes/database_tables.php');
    osc_db_connect($this->db['DB_SERVER'], $this->db['DB_SERVER_USERNAME'], $this->db['DB_SERVER_PASSWORD']);
    osc_db_select_db($this->db['DB_DATABASE']);
    $db_error = false;
    // recup array( 0=>sample(rep), 1=>template(rep))
    if(isset($_POST['TEMPLATE_SAMPLE'])) $get=explode('___',$_POST['TEMPLATE_SAMPLE']);
    else return false;

    // defintion identique shop
    define('DIR_FS_CATALOG',$this->fs_document_root);
    define('DIR_WS_IMAGES',$this->fs_document_root.'images/');
    define('DIR_WS_TEMPLATE',$this->fs_document_root.'templates/');
    define('TEMPLATE_NAME',trim($get[1]));

    // copy recusrive template
    core::recurse_copy( $this->fs_document_root . 'install/'.I_WS_DATA.'templates/'.$get[0].'/'.$get[1].'/', $this->fs_document_root .'templates/'.$get[1].'/');

    // insertion des data sample
    if ( ($db_error == false) && isset($_POST['DB_INSERT_SAMPLE_DATA']) && ($_POST['DB_INSERT_SAMPLE_DATA'] == 'on') ) {
      osc_set_time_limit(0);
      // extraction sql sample
      $sql_file = $this->fs_document_root . 'install/'.I_WS_DATA.'sample/'.$get[0].'/oscss_sample_data.sql';
      $sql_file_lg = $this->fs_document_root . 'install/'.I_WS_DATA.'sample/'.$get[0].'/language/'.DC_LOADER_LANG.'/oscss_sample_data.txt';
      osc_db_install($this->db['DB_DATABASE'], $sql_file, $this->db['DB_TABLE_PREFIX'],$sql_file_lg);
      // add img sample
      tep_zip_extractto( $this->fs_document_root . 'install/'.I_WS_DATA.'sample/'.$get[0].'/sample_images.zip', '../images/');
    }

    // add configuration shop tempale
    osc_db_query($sql="update ".$this->db['DB_TABLE_PREFIX']."configuration set configuration_value='".trim($get[1])."' where  configuration_key='TEMPLATE_NAME' LIMIT 1; " );


    /**
      Langue supplementaire
    */

    include($this->fs_document_root.$this->ws_admin_rand.'/includes/modules/configuration/cfg_31.php');
    if(isset($_POST['lang']) && is_array($_POST['lang']))
      foreach($_POST['lang'] as $key=>$cfg){
	core::recurse_copy( $this->fs_document_root . 'install/'.I_WS_DATA.'language/'.$key.'/public/', $this->fs_document_root .'includes/languages/');
	if(isset($_POST['lang_admin'][$key]) && $_POST['lang_admin'][$key]=='on')
	  core::recurse_copy( $this->fs_document_root . 'install/'.I_WS_DATA.'language/'.$key.'/admin/', $this->fs_document_root.$this->ws_admin_rand .'/includes/languages/');
	//db
	osc_db_query($sql="insert into ".$this->db['DB_TABLE_PREFIX']."languages (name,code,image,directory,sort_order) VALUES ('".core::l10n($key)."','".$key."','icon.gif','".$key."','2') " );
	$insert_id=tep_db_insert_id();

	cfg_31::repliqu_db_lang('1',$insert_id);
      }



    // depend exe file configuration
    include($this->fs_document_root.$this->ws_admin_rand.'/includes/functions/lib.configuration.php');
    // exec fichier conf du template
    $file_cfg=DIR_WS_TEMPLATE.TEMPLATE_NAME.'cfg/configuration.php';
    if(file_exists($file_cfg)) require($file_cfg);

    $this->PileMessage('succes', core::l10n("L'installation et la configuration du template sont terminés" )  ) ;
  }

  /**
    Affichage page central
  */
  function draw_form(){
    $this->writeMessage();
    echo '<form id="install" action="?etape='.$this->get_current_etape(1).'" method="post">'."\n";
    // report POST
    $this->repet_post();
    echo '<h2>'.core::l10n("Installer des exemples").'</h2>'."\n";

  if(!isset($_POST['db_exists']) ||( isset($_POST['db_exists']) && !$_POST['db_exists']) )
    echo '<p class="smallDesc">'."\n"
        .'<label>'.core::l10n('Installer les exemples :').'</label>'."\n"
        .osc_draw_checkbox_field('DB_INSERT_SAMPLE_DATA', '', 'on', true)."\n"
        .core::draw_help('db_insert_sample_data', core::l10n("Si vous désactivez cette option, seul le template sera installé"), core::l10n('Installer template et exemples'))."\n"
        .'</p>'."\n";

    echo '<div id="ChooseSample"><ul>'."\n";
    foreach(core::browse_rep(I_WS_DATA.'sample/') as $sample){
      if( ($res=core::browse_rep(I_WS_DATA.'templates/'.$sample['file'].'/')) && count($res)>0 ){
	echo '<li><h3 class="text">'.core::l10n('Sample '.$sample['file']).'</h3>'."\n";
	echo '<ul class="ChooseTemplate">'."\n";

	foreach($res as $k=>$element){
	  $template_infos = simplexml_load_file(I_WS_DATA.'templates/'.$sample['file'].'/'.$element['file'].'/desc.xml');
	  echo '<li>'."\n".'<dl>'
	      .'<dt class="img"><a href="'.I_WS_DATA.'templates/'.$sample['file'].'/'.$element['file'].'/'.$template_infos->thumb.'" rel="zoombox[template]"><img src="'.I_WS_DATA.'templates/'.$sample['file'].'/'.$element['file'].'/'.$template_infos->thumb.'" width="100" alt="'.$template_infos->name.'" /></a></dt>'."\n"
	      .'<dd class="text">'.osc_draw_radio_field('TEMPLATE_SAMPLE', $element['file'], $sample['file'].'___'.$element['file'], /*$sample['count']==1 && $element['count']==1 ? true : false*/true).core::l10n('Template '.$template_infos->name).'</dd>'."\n"
	      .'</dl>'."\n".'</li>'."\n";
	}

	echo '</ul>'."\n";
	echo '</li>'."\n";
      }
    }
    echo '</ul></div>'."\n";

    echo $this->draw_button();
    echo '</form>'."\n";
  }

  function draw(){

    $this->get_fs_document_root();
    $this->get_server_conf();

    $this->draw_form();
  }
}

?>