<?php
/**
  @licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
  @package osCSS-2 <www http://www.oscss.org>
  @version 2.0.9
  @date  27/05/10, 14:32
  @author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
  @encode UTF-8
*/
  function osc_in_array($value, $array) {
    if (!$array) $array = array();

    if (function_exists('in_array')) {
      if (is_array($value)) {
        for ($i=0; $i<sizeof($value); $i++) {
          if (in_array($value[$i], $array)) return true;
        }
        return false;
      } else {
        return in_array($value, $array);
      }
    } else {
      reset($array);
      while (list(,$key_value) = each($array)) {
        if (is_array($value)) {
          for ($i=0; $i<sizeof($value); $i++) {
            if ($key_value == $value[$i]) return true;
          }
          return false;
        } else {
          if ($key_value == $value) return true;
        }
      }
    }

    return false;
  }

////
// Sets timeout for the current script.
// Cant be used in safe mode.
  function osc_set_time_limit($limit) {
    if (!get_cfg_var('safe_mode')) {
      @set_time_limit($limit);
    }
  }


/**
* @package oscss-2
* @author oscim - OscssTeam
* @version 1.2
  Extraction des zip pour install
*/
function tep_zip_extractto($archive, $destination) {
  if(function_exists("zip_open")) {
    require_once('includes/functions/unzip.php');
    unzip($archive, $destination);
  } else {
    require_once('includes/functions/pclzip.lib.php');
    $archive = new PclZip($archive);
    if ($archive->extract(PCLZIP_OPT_PATH, $destination,
      PCLZIP_OPT_REMOVE_PATH, 'tmp') == 0) {
        die("Error : ".$archive->errorInfo(true));
      }
      return TRUE;
  }
}

/**
  @package oscss-2 <www http://www.oscss.org>
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
*/
function tep_conv_lg($lg){
$les_lg['french']='fr';
$les_lg['english']='en';

return $les_lg[$lg];
}



/**
  Configuration anvancé boutique , repliquation de function
*/

/**
  @package oscss
  @author  OscssTeam
*/
function tep_get_country_name($country_id) {
  $country_query = tep_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$country_id . "'");
  if (!tep_db_num_rows($country_query))  return $country_id;
  else {
      $country = tep_db_fetch_array($country_query);
      return $country['countries_name'];
  }
}

/**
  @package oscss
  @author  OscssTeam
*/
function tep_not_null($value) {
  if (is_array($value)) {
    if (sizeof($value) > 0)  return true;
    else  return false;
  } else {
    if ( (is_string($value) || is_int($value)) && ($value != '') && ($value != 'NULL') && (strlen(trim($value)) > 0))  return true;
    else  return false;
  }
}

/**
  Output a form pull down menu
*/
function tep_draw_pull_down_menu($name, $values, $default = '', $parameters = '', $required = false) {
  if (!preg_match('/id=/i',$parameters)) $field = '<select id="' . str_replace(array('[',']'),array(''),tep_output_string($name)) . '" name="' . tep_output_string($name) . '" ';
  else $field = '<select  name="' . tep_output_string($name) . '" ';

  if (tep_not_null($parameters)) $field .= ' ' . $parameters;
  $field .= '>';
  if (empty($default) && isset($GLOBALS[$name])) $default = stripslashes((string)$GLOBALS[$name]);

  for ($i=0, $n=sizeof($values); $i<$n; $i++) {
    $field .= '<option value="' . tep_output_string($values[$i]['id']) . '"';
    if ($default == $values[$i]['id'])  $field .= ' selected="selected"';
    $field .= '>' . tep_output_string($values[$i]['text'], array('"' => '&quot;', '\'' => '&#039;', '<' => '&lt;', '>' => '&gt;')) . '</option>';
  }
  $field .= '</select>';

  if ($required == true) $field .= TEXT_FIELD_REQUIRED;

  return $field;
}

/**
  @author OscssTeam
*/
function tep_output_string($string, $translate = false, $protected = false) {
  if ($protected == true) return htmlspecialchars($string);
  else {
    if ($translate == false) return tep_parse_input_field_data($string, array('"' => '&quot;'));
    else return tep_parse_input_field_data($string, $translate);
  }
}

/**
  Returns an array with countries
  @package oscss
  @author  OscssTeam
  @table  countries
  @param string $default
  @param array $exclude liste exclusion
*/
function tep_get_countries($default = '', $exclude=array()) {
  $countries_array = array();
  if ($default) {
    $countries_array[] = array('id' => '', 'text' => $default);
  }
  $countries_query = tep_db_query("select countries_id, countries_name from " . TABLE_COUNTRIES . " order by countries_name");
  while ($countries = tep_db_fetch_array($countries_query)) {
    if(!in_array($countries['countries_id'],$exclude)) $countries_array[] = array('id' => $countries['countries_id'], 'text' => $countries['countries_name']);
  }

  return $countries_array;
}

/**
  @author OscssTeam
    Parse the data used in the html tags to ensure the tags will not break
*/
function tep_parse_input_field_data($data, $parse) {
  return strtr(trim($data), $parse);
}

/**
  Convetion de langue Generation 2
  @package oscss-2
  @author oscim <mail oscim@oscss.org> <www http://www.oscim.fr>
  @param
    @a string la chaine
    @a string class d'appel
    @a boolena (print_r())
*/
function __($str,$ext='',$mode=false) {
  global $lang;
  if(!empty($ext)) $lang[$ext][$str]=$str;
  if($mode)print_r($lang);
  return isset($lang[$str]) ? $lang[$str] : $str;
}

?>