####################################-
#|                  osCSS Open Source E-commerce                         |
####################################-
#| Copyright (c) 2005-2010 The osCSS developers                          |
#|                                                                       |
#| http://www.oscss.org                                                  |
#| http://www.oscim.net                                                  |
#| Portions Copyright (c) 2003 osCommerce                                |
####################################-
#| This source file is subject to version 2.0 of the GPL license,        |
#| available at the following url:                                       |
#| http://www.oscss.org/license/2_0.txt.                                 |
####################################-

# NOTE: * Please make any modifications to this file by hand!
#       * DO NOT use a mysqldump created file for new changes!
#       * Please take note of the table structure, and use this
#         structure as a standard for future modifications!
#       * Any tables you add here should be added in admin/backup.php
#         and in catalog/install/includes/functions/database.php
#       * Comments should be like these, full line comments.
#         (don't use inline comments)






CREATE TABLE IF NOT EXISTS osc_holding_orders (
  orders_id int(11) NOT NULL auto_increment,
  customers_id int(11) NOT NULL default '0',
  customers_name varchar(64) NOT NULL default '',
  customers_company varchar(32) default NULL,
  customers_street_address varchar(64) NOT NULL default '',
  customers_suburb varchar(32) default NULL,
  customers_city varchar(32) NOT NULL default '',
  customers_postcode varchar(10) NOT NULL default '',
  customers_state varchar(32) default NULL,
  customers_country varchar(32) NOT NULL default '',
  customers_telephone varchar(32) NOT NULL default '',
  customers_email_address varchar(96) NOT NULL default '',
  customers_address_format_id int(5) NOT NULL default '0',
  delivery_name varchar(64) NOT NULL default '',
  delivery_company varchar(32) default NULL,
  delivery_street_address varchar(64) NOT NULL default '',
  delivery_suburb varchar(32) default NULL,
  delivery_city varchar(32) NOT NULL default '',
  delivery_postcode varchar(10) NOT NULL default '',
  delivery_state varchar(32) default NULL,
  delivery_country varchar(32) NOT NULL default '',
  delivery_address_format_id int(5) NOT NULL default '0',
  billing_name varchar(64) NOT NULL default '',
  billing_company varchar(32) default NULL,
  billing_street_address varchar(64) NOT NULL default '',
  billing_suburb varchar(32) default NULL,
  billing_city varchar(32) NOT NULL default '',
  billing_postcode varchar(10) NOT NULL default '',
  billing_state varchar(32) default NULL,
  billing_country varchar(32) NOT NULL default '',
  billing_address_format_id int(5) NOT NULL default '0',
  payment_method varchar(32) NOT NULL default '',
  cc_type varchar(20) default NULL,
  cc_owner varchar(64) default NULL,
  cc_number varchar(32) default NULL,
  cc_expires varchar(4) default NULL,
  last_modified datetime default NULL,
  date_purchased datetime default NULL,
  orders_status int(5) NOT NULL default '1',
  orders_date_finished datetime default NULL,
  currency char(3) default NULL,
  currency_value decimal(14,6) default NULL,
  ip_address varchar(50) NOT NULL default '',
  PRIMARY KEY  (orders_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1  ;


CREATE TABLE IF NOT EXISTS osc_holding_orders_products (
  orders_products_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  products_id int(11) NOT NULL default '0',
  products_model varchar(12) default NULL,
  products_name varchar(64) NOT NULL default '',
  products_price decimal(15,4) NOT NULL default '0.0000',
  final_price decimal(15,4) NOT NULL default '0.0000',
  products_tax decimal(7,4) NOT NULL default '0.0000',
  products_quantity int(2) NOT NULL default '0',
  products_returned tinyint(2) unsigned default '0',
  products_exchanged tinyint(2) NOT NULL default '0',
  products_exchanged_id int(11) NOT NULL default '0',
  PRIMARY KEY  (orders_products_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ;


CREATE TABLE IF NOT EXISTS osc_holding_orders_products_attributes (
  orders_products_attributes_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  orders_products_id int(11) NOT NULL default '0',
  products_options varchar(32) NOT NULL default '',
  products_options_values varchar(32) NOT NULL default '',
  options_values_price decimal(15,4) NOT NULL default '0.0000',
  price_prefix char(1) NOT NULL default '',
  PRIMARY KEY  (orders_products_attributes_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;



CREATE TABLE IF NOT EXISTS osc_holding_orders_products_download (
  orders_products_download_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  orders_products_id int(11) NOT NULL default '0',
  orders_products_filename varchar(255) NOT NULL default '',
  download_maxdays int(2) NOT NULL default '0',
  download_count int(2) NOT NULL default '0',
  PRIMARY KEY  (orders_products_download_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



CREATE TABLE IF NOT EXISTS osc_holding_orders_status_history (
  orders_status_history_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  orders_status_id int(5) NOT NULL default '0',
  date_added datetime NOT NULL default '1000-01-01 00:00:00',
  customer_notified int(1) default '0',
  comments text,
  PRIMARY KEY  (orders_status_history_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1  ;


CREATE TABLE IF NOT EXISTS osc_holding_orders_total (
  orders_total_id int(10) unsigned NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  text varchar(255) NOT NULL default '',
  value decimal(15,4) NOT NULL default '0.0000',
  class varchar(32) NOT NULL default '',
  sort_order int(11) NOT NULL default '0',
  PRIMARY KEY  (orders_total_id),
  KEY idx_orders_total_orders_id (orders_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;


ALTER TABLE osc_address_book MODIFY COLUMN entry_gender char(1) NOT NULL;
ALTER TABLE osc_address_book MODIFY COLUMN entry_firstname varchar(32) NOT NULL;
ALTER TABLE osc_address_book MODIFY COLUMN entry_lastname varchar(32) NOT NULL;
ALTER TABLE osc_address_book MODIFY COLUMN entry_street_address varchar(64) NOT NULL;
ALTER TABLE osc_address_book MODIFY COLUMN entry_postcode varchar(10) NOT NULL;
ALTER TABLE osc_address_book MODIFY COLUMN entry_city varchar(32) NOT NULL;


ALTER TABLE osc_admin MODIFY COLUMN admin_firstname varchar(32) NOT NULL;
ALTER TABLE osc_admin MODIFY COLUMN admin_email_address varchar(96) NOT NULL;
ALTER TABLE osc_admin MODIFY COLUMN admin_password varchar(40) NOT NULL;

ALTER TABLE osc_admin_files MODIFY COLUMN admin_files_name varchar(64) NOT NULL;

ALTER TABLE osc_banners MODIFY COLUMN banners_title varchar(64) NOT NULL;
ALTER TABLE osc_banners MODIFY COLUMN banners_url varchar(255) NOT NULL;
ALTER TABLE osc_banners MODIFY COLUMN banners_image varchar(64) NOT NULL;
ALTER TABLE osc_banners MODIFY COLUMN banners_group varchar(10) NOT NULL;


ALTER TABLE osc_categories_description MODIFY COLUMN categories_name varchar(32) NOT NULL;


ALTER TABLE osc_configuration MODIFY COLUMN configuration_title varchar(64) NOT NULL;
ALTER TABLE osc_configuration MODIFY COLUMN configuration_key varchar(64) NOT NULL;
ALTER TABLE osc_configuration MODIFY COLUMN configuration_value varchar(255) NOT NULL;
ALTER TABLE osc_configuration MODIFY COLUMN configuration_description varchar(255) NOT NULL;


ALTER TABLE osc_configuration_group MODIFY COLUMN configuration_group_title varchar(64) NOT NULL;
ALTER TABLE osc_configuration_group MODIFY COLUMN configuration_group_description varchar(255) NOT NULL;

CREATE TABLE IF NOT EXISTS osc_content (
  content_id int(10) unsigned NOT NULL auto_increment,
  content_name varchar(50) NOT NULL,
  date_added datetime default NULL,
  last_modified datetime default NULL,
  content_status tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (content_id),
  KEY content_name (content_name)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1  ;



CREATE TABLE IF NOT EXISTS osc_content_description (
  content_id int(10) unsigned NOT NULL default '0',
  content_title varchar(128) NOT NULL,
  content_text text NOT NULL,
  language_id int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


ALTER TABLE osc_countries MODIFY COLUMN countries_name varchar(64) NOT NULL;
ALTER TABLE osc_countries MODIFY COLUMN countries_localname varchar(64) NOT NULL;
ALTER TABLE osc_countries MODIFY COLUMN countries_iso_code_2 char(2) NOT NULL;
ALTER TABLE osc_countries MODIFY COLUMN countries_iso_code_3 char(3) NOT NULL;

CREATE TABLE IF NOT EXISTS osc_coupons (
  coupon_id int(11) NOT NULL auto_increment,
  coupon_type char(1) NOT NULL default 'F',
  coupon_code varchar(32) NOT NULL default '',
  coupon_amount decimal(8,4) NOT NULL default '0.0000',
  coupon_minimum_order decimal(8,4) NOT NULL default '0.0000',
  coupon_start_date datetime NOT NULL default '1000-01-01 00:00:00',
  coupon_expire_date datetime NOT NULL default '1000-01-01 00:00:00',
  uses_per_coupon int(5) NOT NULL default '1',
  uses_per_user int(5) NOT NULL default '0',
  restrict_to_products varchar(255) default NULL,
  restrict_to_categories varchar(255) default NULL,
  restrict_to_customers text,
  coupon_active char(1) NOT NULL default 'Y',
  date_created datetime NOT NULL default '1000-01-01 00:00:00',
  date_modified datetime NOT NULL default '1000-01-01 00:00:00',
  PRIMARY KEY  (coupon_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;



CREATE TABLE IF NOT EXISTS osc_coupons_description (
  coupon_id int(11) NOT NULL default '0',
  language_id int(11) NOT NULL default '0',
  coupon_name varchar(32) NOT NULL default '',
  coupon_description text,
  KEY coupon_id (coupon_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS osc_coupon_email_track (
  unique_id int(11) NOT NULL auto_increment,
  coupon_id int(11) NOT NULL default '0',
  customer_id_sent int(11) NOT NULL default '0',
  sent_firstname varchar(32) default NULL,
  sent_lastname varchar(32) default NULL,
  emailed_to varchar(32) default NULL,
  date_sent datetime NOT NULL default '1000-01-01 00:00:00',
  PRIMARY KEY  (unique_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1  ;



CREATE TABLE IF NOT EXISTS osc_coupon_gv_customer (
  customer_id int(5) NOT NULL default '0',
  amount decimal(8,4) NOT NULL default '0.0000',
  PRIMARY KEY  (customer_id),
  KEY customer_id (customer_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS osc_coupon_gv_queue (
  unique_id int(5) NOT NULL auto_increment,
  customer_id int(5) NOT NULL default '0',
  order_id int(5) NOT NULL default '0',
  amount decimal(8,4) NOT NULL default '0.0000',
  date_created datetime NOT NULL default '1000-01-01 00:00:00',
  ipaddr varchar(32) NOT NULL default '',
  release_flag char(1) NOT NULL default 'N',
  PRIMARY KEY  (unique_id),
  KEY uid (unique_id,customer_id,order_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1  ;



CREATE TABLE IF NOT EXISTS osc_coupon_redeem_track (
  unique_id int(11) NOT NULL auto_increment,
  coupon_id int(11) NOT NULL default '0',
  customer_id int(11) NOT NULL default '0',
  redeem_date datetime NOT NULL default '1000-01-01 00:00:00',
  redeem_ip varchar(32) NOT NULL default '',
  order_id int(11) NOT NULL default '0',
  PRIMARY KEY  (unique_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1  ;


ALTER TABLE osc_currencies MODIFY COLUMN title varchar(32) NOT NULL;
ALTER TABLE osc_currencies MODIFY COLUMN code char(3) NOT NULL;

ALTER TABLE osc_customers MODIFY COLUMN customers_gender char(1) NOT NULL;
ALTER TABLE osc_customers MODIFY COLUMN customers_firstname varchar(32) NOT NULL;
ALTER TABLE osc_customers MODIFY COLUMN customers_lastname varchar(32) NOT NULL;
ALTER TABLE osc_customers MODIFY COLUMN customers_email_address varchar(96) NOT NULL;
ALTER TABLE osc_customers MODIFY COLUMN customers_telephone varchar(32) NOT NULL;
ALTER TABLE osc_customers MODIFY COLUMN customers_password varchar(40) NOT NULL;
ALTER TABLE osc_customers ADD COLUMN customers_shopping_points decimal(15,2) NOT NULL default '0.00';
ALTER TABLE osc_customers ADD COLUMN customers_points_expires date default NULL;

CREATE TABLE IF NOT EXISTS osc_customers_points_pending (
  unique_id int(11) NOT NULL auto_increment,
  customer_id int(11) NOT NULL default '0',
  orders_id int(11) NOT NULL default '0',
  points_pending decimal(15,2) NOT NULL default '0.00',
  points_comment varchar(200) default NULL,
  date_added datetime NOT NULL default '1000-01-01 00:00:00',
  points_status int(1) NOT NULL default '1',
  points_type varchar(2) NOT NULL default 'SP',
  PRIMARY KEY  (unique_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1  ;


ALTER TABLE osc_geo_zones MODIFY COLUMN geo_zone_name varchar(32) NOT NULL;
ALTER TABLE osc_geo_zones MODIFY COLUMN geo_zone_description varchar(255) NOT NULL;



ALTER TABLE osc_holding_orders MODIFY COLUMN customers_name varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_street_address varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_city varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_postcode varchar(10) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_country varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_telephone varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_email_address varchar(96) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN delivery_name varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN delivery_street_address varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN delivery_city varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN delivery_postcode varchar(10) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN delivery_country varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN billing_name varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN billing_street_address varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN billing_city varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN billing_postcode varchar(10) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN billing_country varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN payment_method varchar(32) NOT NULL;





ALTER TABLE osc_holding_orders_products MODIFY COLUMN products_name varchar(64) NOT NULL;


ALTER TABLE osc_holding_orders_products_attributes MODIFY COLUMN products_options varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders_products_attributes MODIFY COLUMN products_options_values varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders_products_attributes MODIFY COLUMN price_prefix char(1) NOT NULL;

ALTER TABLE osc_holding_orders_products_download MODIFY COLUMN orders_products_filename varchar(255) NOT NULL;



ALTER TABLE osc_holding_orders_total MODIFY COLUMN title varchar(255) NOT NULL;
ALTER TABLE osc_holding_orders_total MODIFY COLUMN text varchar(255) NOT NULL;
ALTER TABLE osc_holding_orders_total MODIFY COLUMN class varchar(32) NOT NULL;

ALTER TABLE osc_languages MODIFY COLUMN name varchar(32) NOT NULL;
ALTER TABLE osc_languages MODIFY COLUMN code char(2) NOT NULL;

ALTER TABLE osc_manufacturers MODIFY COLUMN manufacturers_name varchar(32) NOT NULL;


ALTER TABLE osc_manufacturers_info MODIFY COLUMN manufacturers_url varchar(255) NOT NULL;

ALTER TABLE osc_navigation_links MODIFY COLUMN nav_css_id varchar(50) NOT NULL;
ALTER TABLE osc_navigation_links MODIFY COLUMN nav_file varchar(50) NOT NULL;

ALTER TABLE osc_navigation_links_description MODIFY COLUMN nav_name varchar(50) NOT NULL;

ALTER TABLE osc_newsletters MODIFY COLUMN title varchar(255) NOT NULL;
ALTER TABLE osc_newsletters MODIFY COLUMN module varchar(255) NOT NULL;



ALTER TABLE osc_orders MODIFY COLUMN  customers_name varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN customers_street_address varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN customers_postcode varchar(10) NOT NULL default '';
ALTER TABLE osc_orders MODIFY COLUMN  customers_city varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN customers_postcode varchar(10) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN  customers_country varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN customers_telephone varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN customers_email_address varchar(96) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN  delivery_name varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN delivery_street_address varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN delivery_city varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN delivery_postcode varchar(10) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN delivery_country varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN  billing_name varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN  billing_street_address varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN billing_city varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN billing_postcode varchar(10) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN  billing_country varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN payment_method varchar(32) NOT NULL;
ALTER TABLE osc_orders ADD COLUMN ip_address varchar(15) NOT NULL;


ALTER TABLE osc_orders_products MODIFY COLUMN products_name varchar(64) NOT NULL;


ALTER TABLE osc_orders_products_attributes MODIFY COLUMN products_options varchar(32) NOT NULL;
ALTER TABLE osc_orders_products_attributes MODIFY COLUMN products_options_values varchar(32) NOT NULL;
ALTER TABLE osc_orders_products_attributes MODIFY COLUMN price_prefix char(1) NOT NULL;



ALTER TABLE osc_orders_status MODIFY COLUMN orders_status_name varchar(32) NOT NULL;
ALTER TABLE osc_orders_status ADD COLUMN orders_status_color varchar(8) NOT NULL;

ALTER TABLE osc_orders_total MODIFY COLUMN title varchar(255) NOT NULL;
ALTER TABLE osc_orders_total MODIFY COLUMN text varchar(255) NOT NULL;
ALTER TABLE osc_orders_total MODIFY COLUMN class varchar(32) NOT NULL;


CREATE TABLE IF NOT EXISTS osc_products_extra_images (
  products_extra_images_id int(11) NOT NULL auto_increment,
  products_id int(11) default NULL,
  products_extra_image varchar(64) default NULL,
  KEY products_extra_images_id (products_extra_images_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12 ;


ALTER TABLE osc_products_options MODIFY COLUMN products_options_name varchar(32) NOT NULL;

ALTER TABLE osc_products_options_values MODIFY COLUMN products_options_values_name varchar(64) NOT NULL;

ALTER TABLE osc_reviews MODIFY COLUMN customers_name varchar(64) NOT NULL;

CREATE TABLE IF NOT EXISTS osc_seo_cache (
  cache_id varchar(32) NOT NULL,
  cache_language_id tinyint(1) NOT NULL default '0',
  cache_name varchar(255) NOT NULL,
  cache_data mediumtext NOT NULL,
  cache_global tinyint(1) NOT NULL default '1',
  cache_gzip tinyint(1) NOT NULL default '1',
  cache_method varchar(20) NOT NULL default 'RETURN',
  cache_date datetime NOT NULL default '1000-01-01 00:00:00',
  cache_expires datetime NOT NULL default '1000-01-01 00:00:00',
  PRIMARY KEY  (cache_id,cache_language_id),
  KEY cache_id (cache_id),
  KEY cache_language_id (cache_language_id),
  KEY cache_global (cache_global)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

ALTER TABLE osc_sessions MODIFY COLUMN sesskey varchar(32) NOT NULL;

ALTER TABLE osc_tax_class MODIFY COLUMN tax_class_title varchar(32) NOT NULL;
ALTER TABLE osc_tax_class MODIFY COLUMN tax_class_description varchar(255) NOT NULL;

ALTER TABLE osc_tax_rates MODIFY COLUMN tax_description varchar(255) NOT NULL;


ALTER TABLE osc_whos_online MODIFY COLUMN full_name varchar(64) NOT NULL;
ALTER TABLE osc_whos_online MODIFY COLUMN session_id varchar(128) NOT NULL;
ALTER TABLE osc_whos_online MODIFY COLUMN ip_address varchar(15) NOT NULL;
ALTER TABLE osc_whos_online MODIFY COLUMN time_entry varchar(14) NOT NULL;
ALTER TABLE osc_whos_online MODIFY COLUMN time_last_click varchar(14) NOT NULL;
ALTER TABLE osc_whos_online MODIFY COLUMN last_page_url varchar(255) NOT NULL;

ALTER TABLE osc_zones MODIFY COLUMN zone_code varchar(32) NOT NULL;
ALTER TABLE osc_zones MODIFY COLUMN zone_name varchar(32) NOT NULL;







