#+###################################-+
#|                  osCSS Open Source E-commerce                         |
#+###################################-+
#| Copyright (c) 2005-2010 The osCSS developers                          |
#|                                                                       |
#| http://www.oscss.org                                                  |
#| http://www.oscim.net                                                  |
#| Portions Copyright (c) 2003 osCommerce                                |
#+###################################-+
#| This source file is subject to version 2.0 of the GPL license,        |
#| available at the following url:                                       |
#| http://www.oscss.org/license/2_0.txt.                                 |
#+###################################-+

# NOTE: * Please make any modifications to this file by hand!
#       * DO NOT use a mysqldump created file for new changes!
#       * Please take note of the table structure, and use this
#         structure as a standard for future modifications!
#       * Any tables you add here should be added in admin/backup.php
#         and in catalog/install/includes/functions/database.php
#       * Comments should be like these, full line comments.
#         (don't use inline comments)


RENAME TABLE  osc_am_attributes_to_templates TO osc_products_am_attributes_to_templates;

RENAME TABLE  osc_am_templates TO osc_products_am_templates;

ALTER TABLE osc_address_book CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_address_format CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_admin ADD COLUMN url_openid varchar(150) null;

ALTER TABLE osc_admin CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_admin_files CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_admin_groups CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_categories ADD COLUMN categories_status tinyint(1) NOT NULL default '0';
ALTER TABLE osc_categories ADD COLUMN categories_hidden tinyint(1) NOT NULL default '0';

ALTER TABLE osc_categories CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_categories_description ADD COLUMN categories_description longtext;
ALTER TABLE osc_categories_description ADD COLUMN categories_head_keywords_tag longtext;

ALTER TABLE osc_categories_description CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

drop table if exists osc_categories_extra;
CREATE TABLE IF NOT EXISTS osc_categories_extra (
  categories_id int(11) NOT NULL,
  cat_key varchar(150) NOT NULL,
  cat_value varchar(250) NOT NULL,
  UNIQUE KEY categories_id (categories_id,cat_key)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

create table osc_cip (
  cip_id int(11) NOT NULL auto_increment,
  cip_folder_name varchar(255) NOT NULL,
  cip_installed int(1) NOT NULL default '0',
  cip_ident varchar(255) NOT NULL,
  cip_version varchar(255) NOT NULL,
  PRIMARY KEY  (cip_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

create table osc_cip_depend (
  cip_ident varchar(255) NOT NULL,
  cip_ident_req varchar(255) NOT NULL,
  cip_req_type int(2) NOT NULL,
  PRIMARY KEY  (cip_ident(100),cip_ident_req(100),cip_req_type)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE osc_configuration ADD COLUMN configuration_type tinyint (1) default '2' not null;

ALTER TABLE osc_configuration CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_configuration_group ADD COLUMN  configuration_group_parentid tinyint(1) NOT NULL;
ALTER TABLE osc_configuration_group ADD COLUMN  configuration_group_group_id varchar(64) NOT NULL;
ALTER TABLE osc_configuration_group ADD COLUMN  configuration_group_key varchar(64) not null;


if not exists (select * from osc_configuration where configuration_key = 'CFG_CLASS_VIRTUAL_TYPE_1' )
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function,configuration_type) values ('CFG_CLASS_VIRTUAL_TYPE_1_S', 'CFG_CLASS_VIRTUAL_TYPE_1', '', 'CFG_CLASS_VIRTUAL_TYPE_L', '0', '0', NOW(), NOW(),NULL, 'tep_cfg_text_auto(', 1);

if not exists (select * from osc_configuration where configuration_key = 'CFG_CLASS_VIRTUAL_TYPE_2' )
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function,configuration_type) values ('CFG_CLASS_VIRTUAL_TYPE_2_S', 'CFG_CLASS_VIRTUAL_TYPE_2', '', 'CFG_CLASS_VIRTUAL_TYPE_L', '0', '0', NOW(), NOW(),NULL, 'tep_cfg_text_auto(', 1);

if not exists (select * from osc_configuration where configuration_key = 'CFG_CLASS_VIRTUAL_TYPE_3' )
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function,configuration_type) values ('CFG_CLASS_VIRTUAL_TYPE_3_S', 'CFG_CLASS_VIRTUAL_TYPE_3', '', 'CFG_CLASS_VIRTUAL_TYPE_L', '0', '0', NOW(), NOW(),NULL, 'tep_cfg_text_auto(', 1);

if not exists (select * from osc_configuration where configuration_key = 'CFG_CLASS_VIRTUAL_TYPE_4' )
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function,configuration_type) values ('CFG_CLASS_VIRTUAL_TYPE_4_S', 'CFG_CLASS_VIRTUAL_TYPE_4', '', 'CFG_CLASS_VIRTUAL_TYPE_L', '0', '0', NOW(), NOW(),NULL, 'tep_cfg_text_auto(', 1);

if not exists (select * from osc_configuration where configuration_key = 'TYPE_VIRTUAL_PRODUCTS' )
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function,configuration_type) values ('TYPE_VIRTUAL_PRODUCTS_S', 'TYPE_VIRTUAL_PRODUCTS', '', 'TYPE_VIRTUAL_PRODUCTS_L', '0', '0', NOW(), NOW(),NULL, NULL, 2);

if not exists (select * from osc_configuration where configuration_key = 'STOCK_MARK_PRODUCT_NO_STOCK' )
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, configuration_type) values ('STOCK_MARK_PRODUCT_NO_STOCK_S', 'STOCK_MARK_PRODUCT_NO_STOCK', '*cmd*', 'STOCK_MARK_PRODUCT_NO_STOCK_L', '9', '4', NOW(), NOW(), 3);

insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('CUSTOMER_FORCE_UCWORDS_S', 'CUSTOMER_FORCE_UCWORDS', '6', 'CUSTOMER_FORCE_UCWORDS_L', '28', '20', NULL, NOW(), 'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),','3');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('CUSTOMER_FORCE_STRTOUPPER_S', 'CUSTOMER_FORCE_STRTOUPPER', '10', 'CUSTOMER_FORCE_STRTOUPPER_L', '28', '21', NULL, NOW(), 'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),','3');

insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('CUSTOMER_CITY_FORCE_STRTOUPPER_S', 'CUSTOMER_CITY_FORCE_STRTOUPPER', '10', 'CUSTOMER_CITY_FORCE_STRTOUPPER_L', '28', '21', NULL, NOW(), 'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),','3');


ALTER TABLE osc_configuration_group CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_content ADD COLUMN content_hidden tinyint(1) default '0' not null;
ALTER TABLE osc_content ADD COLUMN sort_order varchar(2) default '0' not null;

ALTER TABLE osc_content CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_content_description CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

CREATE TABLE osc_content_to_categories (
content_id INT( 10 ) NOT NULL ,
categories_id INT( 11 ) NOT NULL ,
PRIMARY KEY ( content_id , categories_id )
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE osc_countries CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_coupons CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_coupons_description CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_coupon_email_track CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_coupon_gv_customer CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_coupon_gv_queue CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_coupon_redeem_track CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_currencies CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_customers ADD COLUMN customers_group_id smallint(5) unsigned NOT NULL default '0' AFTER customers_newsletter;
ALTER TABLE osc_customers ADD COLUMN customers_group_ra enum('0','1') NOT NULL AFTER customers_group_id;
ALTER TABLE osc_customers ADD COLUMN customers_payment_allowed varchar(255) NOT NULL default '' AFTER customers_group_ra;
ALTER TABLE osc_customers ADD COLUMN customers_shipment_allowed varchar(255) NOT NULL default '' AFTER customers_payment_allowed;
ALTER TABLE osc_customers ADD COLUMN customers_order_total_allowed varchar(255) NOT NULL default '' AFTER customers_shipment_allowed;
ALTER TABLE osc_customers ADD COLUMN customers_specific_taxes_exempt varchar(255) NOT NULL default '' AFTER customers_order_total_allowed;
ALTER TABLE osc_customers ADD COLUMN customers_discount decimal(5,2) default '0.00' AFTER customers_specific_taxes_exempt;
ALTER TABLE osc_customers ADD COLUMN customers_shopping_points decimal(15,2) NOT NULL default '0.00';
ALTER TABLE osc_customers ADD COLUMN customers_status int(1) NOT NULL DEFAULT '1';


ALTER TABLE osc_customers CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

CREATE TABLE osc_customers_groups (
 customers_group_id smallint UNSIGNED NOT NULL,
 customers_group_name varchar(32) NOT NULL default '',
 customers_group_show_tax enum('1','0') NOT NULL,
 customers_group_tax_exempt enum('0','1') NOT NULL,
 group_payment_allowed varchar(255) NOT NULL default '',
 group_shipment_allowed varchar(255) NOT NULL default '',
 group_order_total_allowed varchar(255) NOT NULL default '',
 group_specific_taxes_exempt varchar(255) NOT NULL default '',
 group_discount decimal(5,2) default '0.00',
 PRIMARY KEY (customers_group_id)
 ) ENGINE=MyISAM DEFAULT CHARSET=utf8;


ALTER TABLE osc_customers_basket CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_customers_basket_attributes ADD COLUMN products_options_value_text text null;

ALTER TABLE osc_customers_basket_attributes CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;


CREATE TABLE osc_customers_to_extra_fields (
  customers_id int(11) NOT NULL default '0',
  fields_id int(11) NOT NULL default '0',
  value text
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE osc_customers_info ADD COLUMN global_product_notifications int(1) default NULL;

ALTER TABLE osc_customers_info CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
 ALTER TABLE osc_customers CHANGE customers_shopping_points INT( 10 ) NOT NULL DEFAULT '0';
ALTER TABLE osc_customers_points_pending CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

CREATE TABLE osc_discount_coupons (
  coupons_id varchar(32) NOT NULL default '',
  coupons_description varchar(64) NOT NULL default '',
  coupons_discount_amount decimal(15,6) default NULL,
  coupons_discount_type varchar(35) default NULL,
  coupons_date_start datetime default NULL,
  coupons_date_end datetime default NULL,
  coupons_max_use int(3) NOT NULL default '0',
  coupons_min_order decimal(15,6) NOT NULL default '0.0000',
  coupons_min_order_type varchar(50) default NULL,
  coupons_number_available int(3) NOT NULL default '0',
  PRIMARY KEY  (coupons_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE osc_discount_coupons_to_categories (
  coupons_id varchar(32) default NULL,
  categories_id int(11) default NULL,
  in_out varchar(1) NOT NULL default 'E',
  UNIQUE KEY coupons_id (coupons_id,categories_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE osc_discount_coupons_to_customers (
  coupons_id varchar(32) default NULL,
  customers_id int(11) default NULL,
  in_out varchar(1) NOT NULL default 'O' COMMENT 'I pour in, O pour out',
  UNIQUE KEY coupons_id (coupons_id,customers_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE osc_discount_coupons_to_manufacturers (
  coupons_id varchar(32) default NULL,
  manufacturers_id int(11) default NULL,
  in_out varchar(1) NOT NULL default 'E',
  UNIQUE KEY coupons_id (coupons_id,manufacturers_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE osc_discount_coupons_to_orders (
  discount_coupons_to_orders_id int(11) NOT NULL auto_increment,
  coupons_id varchar(32) default NULL,
  orders_id int(11) default '0',
  PRIMARY KEY  (discount_coupons_to_orders_id),
  KEY coupons_id (coupons_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

CREATE TABLE osc_discount_coupons_to_products (
  coupons_id varchar(32) default NULL,
  products_id int(11) default NULL,
  in_out varchar(1) NOT NULL default 'E',
  UNIQUE KEY coupons_id (coupons_id,products_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE osc_discount_coupons_to_zones (
  discount_coupons_to_zones_id int(11) NOT NULL auto_increment,
  coupons_id varchar(32) default NULL,
  geo_zone_id int(11) default NULL,
  in_out varchar(1) NOT NULL default 'E',
  PRIMARY KEY  (discount_coupons_to_zones_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;


CREATE TABLE osc_extra_field_labels (
  epf_id int(11) NOT NULL,
  languages_id int(11) NOT NULL,
  epf_label varchar(64) default NULL,
  epf_active_for_language tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (epf_id,languages_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE osc_extra_field_values (
  value_id int(10) unsigned NOT NULL auto_increment,
  epf_id int(11) NOT NULL,
  languages_id int(11) NOT NULL,
  parent_id int(10) unsigned NOT NULL default '0',
  sort_order int(11) NOT NULL default '0',
  epf_value varchar(64) default NULL,
  PRIMARY KEY  (value_id),
  KEY IDX_EPF (epf_id,languages_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;


CREATE TABLE osc_extra_fields (
  fields_id int(11) NOT NULL auto_increment,
  fields_input_type int(11) NOT NULL default '0',
  fields_input_value text NOT NULL,
  fields_status tinyint(2) NOT NULL default '0',
  fields_required_status tinyint(2) NOT NULL default '0',
  fields_size int(5) NOT NULL default '0',
  fields_required_email tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (fields_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;


CREATE TABLE osc_extra_fields_info (
  fields_id int(11) NOT NULL default '0',
  languages_id int(11) NOT NULL default '0',
  fields_name varchar(32) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


drop table if exists osc_full_tag;
CREATE TABLE osc_full_tag (
  tag_id int(11) NOT NULL auto_increment,
  page_type tinytext NOT NULL,
  page_id varchar(30) default NULL,
  PRIMARY KEY  (tag_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8  ;

drop table if exists osc_full_tag_description;
CREATE TABLE osc_full_tag_description (
  tag_id int(11) NOT NULL default '0',
  language_id int(3) NOT NULL default '1',
  head_title_tag varchar(80) default NULL,
  head_desc_tag longtext,
  head_keywords_tag longtext,
  PRIMARY KEY  (tag_id, language_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO osc_full_tag (tag_id, page_type, page_id) VALUES (1, 'generic', 'generic');
INSERT INTO osc_full_tag_description (tag_id, language_id, head_title_tag, head_desc_tag, head_keywords_tag) VALUES (1, 1, 'HEAD_TITLE_TAG_ALL', 'HEAD_DESC_TAG_ALL', 'HEAD_KEY_TAG_ALL');


#deplacement des element de catgeorie tag
Insert into osc_full_tag (page_id)
Select c.categories_id  from osc_categories c;

Update osc_full_tag set page_type='cat' where page_type='';

Insert into osc_full_tag_description (tag_id,language_id,head_title_tag,head_desc_tag,head_keywords_tag)
Select distinct ft.tag_id,cd.language_id,c.category_head_title_tag,c.category_head_desc_tag,c.category_head_keywords_tag  from osc_categories c, osc_categories_description cd, osc_full_tag ft Where c.categories_id=cd.categories_id and c.categories_id=ft.page_id and page_type='cat';

ALTER TABLE osc_categories DROP category_head_title_tag;
ALTER TABLE osc_categories DROP category_head_desc_tag;
ALTER TABLE osc_categories DROP category_head_keywords_tag;



## deplacement des element de table produits
Insert into osc_full_tag (page_id)
Select products_id  from osc_products_description p;

Update osc_full_tag set page_type='product' where page_type='';

Insert into osc_full_tag_description (tag_id,language_id,head_title_tag,head_desc_tag,head_keywords_tag)
Select distinct ft.tag_id,pd.language_id,products_head_title_tag,products_head_desc_tag,products_head_keywords_tag  from osc_products p, osc_products_description pd, osc_full_tag ft Where p.products_id=pd.products_id and  p.products_id=ft.page_id and page_type='product';

ALTER TABLE osc_products_description DROP products_head_title_tag;
ALTER TABLE osc_products_description DROP products_head_desc_tag;
ALTER TABLE osc_products_description DROP products_head_keywords_tag  	;


ALTER TABLE osc_geo_zones CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_holding_orders ADD COLUMN orders_prefix varchar(32) null AFTER orders_id;
ALTER TABLE osc_holding_orders ADD COLUMN total_weight varchar(5) null ;

ALTER TABLE osc_holding_orders CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_holding_orders_products CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_holding_orders_products_attributes CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_holding_orders_products_download CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_holding_orders_status_history CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_holding_orders_total CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_newsletters_modeles ADD COLUMN modele_id int(1) NOT NULL default '0';

drop table if exists osc_newsletters_sent;
CREATE TABLE osc_newsletters_sent (
  customers_id int(11) NOT NULL default '0',
  module_type varchar(64) NOT NULL,
  newsletters_id int(11) NOT NULL,
  date_sent datetime NOT NULL,
  KEY id_index (customers_id,newsletters_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


ALTER TABLE osc_languages ADD COLUMN core int(1) not null default 2;
ALTER TABLE osc_languages MODIFY COLUMN code varchar(6) NOT NULL;

ALTER TABLE osc_languages CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

update osc_languages set code='fr_FR', directory='fr_FR' WHERE directory='french';
update osc_languages set code='en_EN', directory='en_EN' WHERE directory='english';
update osc_languages set code='de_DE', directory='de_DE' WHERE directory='german';
update osc_languages set code='es_ES', directory='es_ES' WHERE directory='espanol';



ALTER TABLE osc_manufacturers   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_manufacturers_info CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_navigation_links ADD COLUMN parent_id int(3) NOT NULL default '0';

ALTER TABLE osc_navigation_links   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_navigation_links_description CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_newsletters ADD COLUMN nbr_send int(11) NOT NULL default '0';
ALTER TABLE osc_newsletters ADD COLUMN newsletters_language int(11) NOT NULL default '1';

ALTER TABLE osc_newsletters   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

CREATE TABLE osc_newsletters_sent (
  customers_id int(11) NOT NULL default '0',
  module_type varchar(64) NOT NULL,
  newsletters_id int(11) NOT NULL,
  date_sent datetime NOT NULL,
  KEY id_index (customers_id,newsletters_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE osc_orders ADD COLUMN orders_prefix varchar(32) null AFTER orders_id;
ALTER TABLE osc_orders ADD COLUMN total_weight varchar(5) null ;
ALTER TABLE osc_orders ADD COLUMN facture_id int(11) null ;
ALTER TABLE osc_orders ADD holding_origin_id INT( 11 ) NOT NULL ;

ALTER TABLE osc_orders   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_orders_products ADD COLUMN  products_stock_attributes varchar(255) default NULL;
ALTER TABLE osc_orders_products ADD COLUMN  products_returned tinyint(2) default '0' null;
ALTER TABLE osc_orders_products ADD COLUMN  products_exchanged tinyint(2) default '0' not null ;
ALTER TABLE osc_orders_products ADD COLUMN  products_exchanged_id int(11) default '0' not null;

ALTER TABLE osc_orders_products   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;



create table IF NOT EXISTS osc_orders_products_download (
  orders_products_download_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  orders_products_id int(11) default '0' not null ,
  orders_products_filename varchar(255) not null ,
  download_maxdays int(2) default '0' not null ,
  download_count int(2) default '0' not null ,
  PRIMARY KEY (orders_products_download_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


ALTER TABLE osc_orders_products_attributes   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_orders_products_download   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_orders_status   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_orders_status_history   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_orders_total   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;


ALTER TABLE osc_products   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_products ADD  track_stock INT( 1 ) NOT NULL DEFAULT 1 AFTER manufacturers_id;

CREATE TABLE osc_products_groups (
  customers_group_id smallint UNSIGNED NOT NULL default '0',
  customers_group_price decimal(15,6) NOT NULL default '0.0000',
  products_id int(11) NOT NULL default '0',
  PRIMARY KEY  (customers_group_id, products_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE osc_products_attributes ADD COLUMN products_options_values_url varchar(128)  null ;
ALTER TABLE osc_products_attributes ADD COLUMN options_values_weight decimal(15,6) default '0.0000' not null;

ALTER TABLE osc_products_attributes   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_products_attributes   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_products_attributes_download   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

CREATE TABLE osc_products_attributes_groups (
  products_attributes_id int(11) NOT NULL default '0',
  customers_group_id smallint(5) NOT NULL default '0',
  options_values_price decimal(15,6) NOT NULL default '0.0000',
  price_prefix char(1) NOT NULL default '',
  products_id int(11) NOT NULL default '0',
  PRIMARY KEY  (customers_group_id,products_attributes_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE osc_products_description ADD COLUMN products_chapo varchar(250) default NULL AFTER products_description ;
ALTER TABLE osc_products_description   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_products_extra_images   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_products_notifications   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_products_options ADD COLUMN products_options_track_stock tinyint(1) default '0' not null AFTER products_options_name;
ALTER TABLE osc_products_options ADD COLUMN products_options_images_enabled int(1) unsigned default '0' not null ;
ALTER TABLE osc_products_options ADD COLUMN products_options_type int( 5 ) default '1' NOT NULL;
ALTER TABLE osc_products_options ADD COLUMN products_options_length smallint( 2 ) DEFAULT '32' NOT NULL  ;
ALTER TABLE osc_products_options ADD COLUMN products_options_comment varchar( 32 );
ALTER TABLE osc_products_options ADD COLUMN products_options_condition int(1) DEFAULT '1' NOT NULL;

ALTER TABLE osc_products_options   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;


ALTER TABLE osc_products_options_values ADD COLUMN products_options_values_thumbnail varchar(128)  null;

ALTER TABLE osc_products_options_values   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_products_options_values_to_products_options   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_products_to_categories   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

CREATE TABLE osc_products_extra_fields (
  epf_id int unsigned NOT NULL auto_increment,
  epf_order int NOT NULL default 0,
  epf_status tinyint(1) NOT NULL default 1,
  epf_uses_value_list tinyint(1) not null default 0,
  epf_advanced_search tinyint(1) not null default 1,
  epf_show_in_listing tinyint(1) not null default 0,
  epf_size tinyint unsigned not null default 64,
  epf_use_as_meta_keyword tinyint(1) not null default 0,
  epf_use_to_restrict_listings tinyint(1) not null default 0,
  epf_show_parent_chain tinyint(1) not null default 0,
  epf_key varchar(40) default NULL COMMENT 'key de config pour plus de souplesse',
  epf_admin int(1) NOT NULL default '1' COMMENT 'dispo uniquement admin',
  epf_special_mod varchar(30) default NULL COMMENT 'flag module proprietaire',
  PRIMARY KEY (epf_id),
  KEY IDX_ORDER (epf_order)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE osc_products_extra_fields_labels (
  epf_id int unsigned NOT NULL,
  languages_id int NOT NULL,
  epf_label varchar(64),
  epf_active_for_language tinyint(1) not null default 1,
  epf_label_help varchar(160) default NULL COMMENT 'aide contextuelle',
  PRIMARY KEY (epf_id, languages_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


create table osc_products_extra_fields_values (
  value_id int unsigned not null auto_increment,
  epf_id int unsigned not null,
  languages_id int not null,
  parent_id int unsigned not null default 0,
  sort_order int not null default 0,
  epf_value varchar(64),
  primary key (value_id),
  key IDX_EPF (epf_id, languages_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE osc_products_to_products_extra_fields (
  products_id int(11) NOT NULL default '0',
  products_extra_fields_id int(11) NOT NULL default '0',
  products_extra_fields_value text,
  PRIMARY KEY  (products_id,products_extra_fields_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

create table osc_products_to_vendors (
  products_id int(11) default '0' not null ,
  vendors_id int(11) default '0' not null ,
  PRIMARY KEY (products_id, vendors_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE osc_products_virtual (
  productsID int(10) NOT NULL,
  typeID tinyint(3) NOT NULL,
  PRIMARY KEY  (productsID)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

create table osc_products_stock (
  products_stock_id int(11) not null auto_increment,
  products_id int(11) default '0' not null ,
  products_stock_attributes varchar(255) not null,
  products_stock_quantity int(11) default '0' not null ,
  PRIMARY KEY (products_stock_id),
  UNIQUE idx_products_stock_attributes (products_id,products_stock_attributes)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



ALTER TABLE osc_reviews   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_reviews_description   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

CREATE TABLE osc_refund_payments (
  refund_payment_id int(11) NOT NULL auto_increment,
  returns_id int(11) NOT NULL default '0',
  refund_payment_name varchar(64) NOT NULL default 'No Refund Made',
  refund_payment_value decimal(15,6) NOT NULL default '0.0000',
  refund_payment_date datetime NOT NULL default '1000-01-01 00:00:00',
  refund_payment_reference varchar(50) default NULL,
  refund_payment_deductions decimal(15,6) NOT NULL default '0.0000',
  customer_method varchar(50) NOT NULL default '',
  PRIMARY KEY  (refund_payment_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE osc_return_text (
  return_text_id tinyint(3) unsigned NOT NULL default '0',
  language_id int(3) unsigned NOT NULL default '1',
  return_text_one text,
  PRIMARY KEY  (return_text_id,language_id),
  KEY status_id (return_text_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


create table osc_returned_products (
  returns_id int(11) NOT NULL auto_increment,
  customers_id int(11) NOT NULL default '0',
  rma_value varchar(15) NOT NULL default '0',
  order_id int(11) NOT NULL default '0',
  customers_name varchar(64) NOT NULL default '',
  customers_acct varchar(32) default NULL,
  customers_company varchar(32) default NULL,
  customers_street_address varchar(64) NOT NULL default '',
  customers_suburb varchar(32) default NULL,
  customers_city varchar(32) NOT NULL default '',
  customers_postcode varchar(10) NOT NULL default '',
  customers_state varchar(32) default NULL,
  customers_country varchar(32) NOT NULL default '',
  customers_telephone varchar(32) NOT NULL default '',
  customers_fax varchar(32) NOT NULL default '',
  customers_email_address varchar(96) NOT NULL default '',
  customers_address_format_id int(5) NOT NULL default '0',
  delivery_name varchar(64) NOT NULL default '',
  delivery_company varchar(32) default NULL,
  delivery_street_address varchar(64) NOT NULL default '',
  delivery_suburb varchar(32) default NULL,
  delivery_city varchar(32) NOT NULL default '',
  delivery_postcode varchar(10) NOT NULL default '',
  delivery_state varchar(32) default NULL,
  delivery_country varchar(32) NOT NULL default '',
  delivery_address_format_id int(5) NOT NULL default '0',
  billing_name varchar(64) NOT NULL default '',
  billing_acct varchar(32) default NULL,
  billing_company varchar(32) default NULL,
  billing_street_address varchar(64) NOT NULL default '',
  billing_suburb varchar(32) default NULL,
  billing_city varchar(32) NOT NULL default '',
  billing_postcode varchar(10) NOT NULL default '',
  billing_state varchar(32) default NULL,
  billing_country varchar(32) NOT NULL default '',
  billing_address_format_id int(5) NOT NULL default '0',
  payment_method varchar(64) NOT NULL default '',
  cc_type varchar(20) default NULL,
  cc_owner varchar(64) default NULL,
  cc_number varchar(32) default NULL,
  cc_expires varchar(4) default NULL,
  cvvnumber char(3) default NULL,
  last_modified datetime default NULL,
  date_purchased datetime default NULL,
  returns_status int(5) NOT NULL default '1',
  returns_date_finished datetime NOT NULL default '1000-01-01 00:00:00',
  comments text,
  currency char(3) default NULL,
  currency_value decimal(14,6) default NULL,
  account_name varchar(32) NOT NULL default '',
  account_number varchar(20) default NULL,
  po_number varchar(12) default NULL,
  date_finished datetime NOT NULL default '1000-01-01 00:00:00',
  returns_reason tinyint(5) unsigned default '0',
  contact_user_name varchar(64) NOT NULL default '',
  PRIMARY KEY  (returns_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE osc_returns_products_data (
  returns_products_id int(11) NOT NULL auto_increment,
  returns_id int(11) NOT NULL default '0',
  order_id int(11) NOT NULL default '0',
  products_id int(11) NOT NULL default '0',
  products_model varchar(12) default NULL,
  products_name varchar(120) NOT NULL default '',
  products_price decimal(15,6) NOT NULL default '0.0000',
  products_discount_made decimal(15,6) default NULL,
  final_price decimal(15,6) NOT NULL default '0.0000',
  products_tax decimal(15,6) NOT NULL default '0.0000',
  products_quantity int(2) NOT NULL default '0',
  products_serial_number varchar(128) default NULL,
  products_returned tinyint(2) unsigned default '0',
  products_exchanged tinyint(2) unsigned default '0',
  PRIMARY KEY  (returns_products_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE osc_returns_total (
  returns_total_id int(10) unsigned NOT NULL auto_increment,
  returns_id int(11) NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  text varchar(255) NOT NULL default '',
  value decimal(15,6) NOT NULL default '0.0000',
  class varchar(32) NOT NULL default '',
  sort_order int(11) NOT NULL default '0',
  PRIMARY KEY  (returns_total_id),
  KEY idx_returns_total_returns_id (returns_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS osc_returns_status_history (
  returns_status_history_id int(11) unsigned NOT NULL auto_increment,
  returns_id int(11) unsigned NOT NULL default '0',
  returns_status int(5) unsigned NOT NULL default '0',
  date_added datetime default NULL,
  customer_notified int(1) unsigned default '0',
  comments text,
  PRIMARY KEY  (returns_status_history_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Return products''s status change history';


ALTER TABLE osc_sessions   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;


create table osc_scart (
  scartid int(11) NOT NULL auto_increment,
  customers_id int(11) NOT NULL default '0',
  dateadded varchar(8) NOT NULL default '',
  datemodified varchar(8) NOT NULL default '',
  PRIMARY KEY  (scartid)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

drop table if exists osc_seo_cache;
create table osc_seo_cache (
  cache_id char(32) not null ,
  cache_language_id int(3) default '1' not null ,
  cache_name varchar(255) not null ,
  cache_data mediumtext not null ,
  cache_global tinyint(1) default '1' not null ,
  cache_gzip tinyint(1) default '1' not null ,
  cache_method varchar(6) default 'RETURN' not null ,
  cache_date datetime default '1000-01-01 00:00:00'  null ,
  cache_expires datetime default '1000-01-01 00:00:00'  null ,
  PRIMARY KEY (cache_id, cache_language_id),
  KEY cache_id (cache_id),
  KEY cache_language_id (cache_language_id),
  KEY cache_global (cache_global)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE osc_status (
  status_id int(11) NOT NULL default '0',
  status_type varchar(30) NOT NULL default 'orders',
  language_id int(3) NOT NULL default '1',
  status_name varchar(32) NOT NULL,
  status_color varchar(8) NOT NULL,
  PRIMARY KEY  (status_id,status_type,language_id),
  KEY idx_status_name (status_name)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


## deplacement des status de commande
Insert into osc_status (status_id, language_id, status_name,status_color )
Select orders_status_id, language_id, orders_status_name,orders_status_color   from osc_orders_status;

Update osc_status set status_type='orders' where status_type='';

drop table if exists osc_orders_status;



ALTER TABLE osc_specials ADD COLUMN customers_group_id int(11)  default '0' not null;
ALTER TABLE osc_specials   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

CREATE TABLE osc_vendors (
  vendors_id int(11) NOT NULL auto_increment,
  vendors_name varchar(32) NOT NULL,
  vendors_image varchar(64),
  vendors_phone1 VARCHAR(20) DEFAULT NULL,
  vendors_phone2 VARCHAR(20) DEFAULT NULL,
  vendors_fax VARCHAR(20) DEFAULT NULL,
  vendors_email VARCHAR(20) DEFAULT NULL,
  vendors_url VARCHAR(60) DEFAULT NULL,
  vendors_comments VARCHAR(255) DEFAULT NULL,
  date_added datetime NULL,
  last_modified datetime NULL,
  PRIMARY KEY (vendors_id),
  KEY IDX_vendors_NAME (vendors_name)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


ALTER TABLE osc_tax_class   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_tax_rates   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_whos_online   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;
ALTER TABLE osc_zones   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;


ALTER TABLE osc_geo_zones ADD COLUMN geo_zone_type TINYINT(11)default '1'  not null ;

ALTER TABLE osc_zones_to_geo_zones   CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;

ALTER TABLE osc_address_book ADD COLUMN  entry_company_tax_id varchar(32) default NULL AFTER entry_company;


drop view if exists view_products;
CREATE VIEW view_products AS
select p.products_model, m.manufacturers_name,p.products_quantity,p.products_image, p.products_weight,p.products_id, p.manufacturers_id, p.products_price, p.products_tax_class_id, IF(s.status, s.specials_new_products_price, NULL) as specials_new_products_price, IF(s.status, s.specials_new_products_price, p.products_price) as final_price, p.products_date_added, p.products_date_available from  osc_products p left join osc_manufacturers m on p.manufacturers_id = m.manufacturers_id left join osc_specials s on p.products_id = s.products_id, osc_products_to_categories p2c, osc_categories c where c.categories_id=p2c.categories_id and c.categories_status='1' and p.products_status = '1' and p.products_id = p2c.products_id;


drop view if exists view_orders_status;
CREATE VIEW view_orders_status AS
  SELECT status_id as orders_status_id, language_id , status_name as orders_status_name, status_color as orders_status_color FROM osc_status WHERE status_type = 'orders';


drop view if exists view_returns_status;
CREATE VIEW view_returns_status AS
  SELECT status_id as returns_status_id, language_id , status_name as returns_status_name, status_color as returns_status_color FROM osc_status WHERE status_type = 'returns';


drop view if exists view_return_reasons_status;
CREATE VIEW view_return_reasons_status AS
  SELECT status_id as return_reasons_status_id, language_id , status_name as return_reasons_status_name, status_color as return_reasons_status_color FROM osc_status WHERE status_type = 'return_reasons';



drop view if exists view_refund_method;
CREATE VIEW view_refund_method AS
  SELECT status_id as refund_method_id, language_id , status_name as rrefund_method_name, status_color as refund_method_color FROM osc_status WHERE status_type = 'refund_method';


drop view if exists view_products_virtual_types;
CREATE VIEW view_products_virtual_types AS
  SELECT status_id , language_id , status_name as type, status_color as products_virtual_types_color FROM osc_status WHERE status_type = 'products_virtual_types';


COMMIT;





# Data update insert
drop table if exists osc_admin_files;

CREATE TABLE osc_admin_files (
  admin_files_id int(11) NOT NULL auto_increment,
  admin_files_name varchar(128) NOT NULL COMMENT 'fichier, avec get',
  admin_files_is_boxes tinyint(1) NOT NULL default '0' COMMENT '1 si est une boite',
  admin_files_to_boxes tinyint(1) NOT NULL default '0' COMMENT 'precise le num de la  boite parent',
  admin_groups_id set('1','2','3','4','5') NOT NULL default '1',
  PRIMARY KEY  (admin_files_id),
  UNIQUE KEY admin_files_name (admin_files_name,admin_files_is_boxes,admin_files_to_boxes)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (1, 'configuration.php', 1, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (2, 'catalog.php', 1, 0, '1,2');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (3, 'customers.php', 1, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (4, 'modules.php', 1, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (6, 'tools.php', 1, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (5, 'parameters.php', 1, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (7, 'administrator.php', 1, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (8, 'cms.php', 1, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (9, 'hidden.php', 1, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (10, 'commercial.php', 1, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (11, 'return_product.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (12, 'returns_invoice.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (13, 'returns_packingslip.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (14, 'attributeManager.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (15, 'products_cross.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (16, 'graphs_stats.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (17, 'ajax.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (18, 'qtprodoctor.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (19, 'sitemonitor.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (20, 'coupons_exclusions.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (21, 'stock.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (22, 'sitemaps.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (23, 'aca_portfolio.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (24, 'sales_stats.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (25, 'aca.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (26, 'mail.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (27, 'rss.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (28, 'tinybrowser.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (29, 'package.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (30, 'admin_members.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (31, 'config_110.php', 0, 8, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (32, 'configuration.php?gparentID=110&gID=25', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (33, 'configuration.php?gparentID=110&gID=31', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (34, 'configuration.php?gparentID=110&gID=1', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (35, 'configuration.php?gparentID=110&gID=2', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (36, 'configuration.php?gparentID=110&gID=28', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (37, 'configuration.php?gparentID=110&gID=30', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (38, 'return.php', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (39, 'configuration.php?gparentID=110&gID=30&type=returns', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (40, 'configuration.php?gparentID=110&gID=30&type=return_reasons', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (41, 'configuration.php?gparentID=110&gID=30&type=refund_method', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (42, 'configuration.php?gparentID=110&gID=35', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (43, 'config_127.php', 0, 8, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (44, 'configuration.php?gparentID=127&gID=7', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (45, 'configuration.php?gparentID=127&gID=9', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (46, 'configuration.php?gparentID=127&gID=11', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (47, 'configuration.php?gparentID=127&gID=13', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (48, 'config_126.php', 0, 8, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (49, 'configuration.php?gparentID=126&gID=22', 0, 6, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (50, 'configuration.php?gparentID=126&gID=20', 0, 6, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (51, 'configuration.php?gparentID=126&gID=17', 0, 6, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (52, 'config_120.php', 0, 8, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (53, 'configuration.php?gparentID=120&gID=6', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (54, 'configuration.php?gparentID=120&gID=24', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (55, 'configuration.php?gparentID=120&gID=10', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (56, 'configuration.php?gparentID=120&gID=12', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (57, 'configuration.php?gparentID=120&gID=16', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (58, 'configuration.php?gparentID=120&gID=33', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (59, 'configuration.php?gparentID=120&gID=15', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (60, 'configuration.php?gparentID=120&gID=14', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (61, 'configuration.php?gparentID=120&gID=34', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (62, 'config_100.php', 0, 8, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (63, 'configuration.php?gparentID=100&gID=29', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (64, 'configuration.php?gparentID=100&gID=27', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (65, 'configuration.php?gparentID=100&gID=21', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (66, 'configuration.php?gparentID=100&gID=19', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (67, 'configuration.php?gparentID=100&gID=8', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (68, 'configuration.php?gparentID=100&gID=4', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (69, 'taxes_in_zone.php', 0, 8, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (70, 'countries.php', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (71, 'geo_zones.php', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (72, 'tax_classes.php', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (73, 'adminUsers.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (74, 'adminGroup.php', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (75, 'admin_members.php?gID=groups', 0, 1, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (76, 'modules.php?manager=process', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (77, 'plugins.php', 0, 0, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (78, 'stats.php', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (79, 'stats.php?module=stats_customers', 0, 6, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (80, 'stats.php?module=stats_low_stock_attrib', 0, 6, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (81, 'stats.php?module=stats_newsletter', 0, 6, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (82, 'stats.php?module=stats_products_purchased', 0, 6, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (83, 'stats.php?module=stats_products_viewed', 0, 6, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (84, 'stats.php?module=whos_online', 0, 6, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (85, 'ggsitemap.php', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (86, 'header_tags.php', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (87, 'batch_print.php', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (88, 'system.php', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (89, 'backup.php', 0, 5, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (90, 'configuration.php?gID=37', 0, 5, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (91, 'configuration.php?gID=36', 0, 5, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (92, 'currencies.php', 0, 5, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (93, 'newsletters.php', 0, 4, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (94, 'orders.php', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (95, 'held_orders.php', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (96, 'recover_cart_sales.php', 0, 7, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (97, 'products.php', 0, 5, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (98, 'products.php?cPath=&action=new', 0, 5, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (99, 'products.php?expected=true', 0, 5, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (100, 'attributes.php', 0, 5, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (101, 'categories.php', 0, 5, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (102, 'cms_content.php', 0, 5, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (103, 'navigation_links.php', 0, 5, '1');
INSERT INTO osc_admin_files (admin_files_id, admin_files_name, admin_files_is_boxes, admin_files_to_boxes, admin_groups_id) VALUES (104, 'editeur/tiny_mce/plugins/tinybrowser/tinybrowser.php?type=image', 0, 5, '1');


if not exists (select * from osc_admin_groups where admin_groups_name = 'OSC_ADMIN_GROUPS_ADMIN' )
insert into osc_admin_groups (admin_groups_id, admin_groups_name) values ('1', 'OSC_ADMIN_GROUPS_ADMIN');
if not exists (select * from osc_admin_groups where admin_groups_name = 'OSC_ADMIN_GROUPS_BUYER' )
insert into osc_admin_groups (admin_groups_id, admin_groups_name) values ('2', 'OSC_ADMIN_GROUPS_BUYER');

insert into osc_cip values (1, 'Contrib_Installer_2.2', 1, 'CONTRIB_INSTALLER', '2.2');
insert into osc_cip values (2, 'ADDRESS_BOOK_stable', 1, 'ADDRESS_BOOK_stable', '1.0');
insert into osc_cip values (3, 'DESC_BASE_stable', 1, 'DESC_BASE_stable', '1.0');
insert into osc_cip values (4, 'HEADER_TAGS_stable', 1, 'HEADER_TAGS_stable', '1.0');
insert into osc_cip values (5, 'ACCOUNT_EXTRA_stable', 1, 'ACCOUNT_EXTRA_stable', '1.0');
insert into osc_cip values (6, 'SPECIAL_stable', 1, 'SPECIAL_stable', '1.0');
insert into osc_cip values (7, 'SVNUPDATE_unstable', 1, 'SVNUPDATE_unstable', '1.0');
insert into osc_cip values (8, 'SPU_stable', 1, 'SPU_stable', '1.0');
insert into osc_cip values (9, 'ITEM_stable', 1, 'ITEM_stable', '1.0');
insert into osc_cip values (10, 'FLAT_stable', 1, 'FLAT_stable', '1.0');
insert into osc_cip values (11, 'MZMT_stable', 1, 'MZMT_stable', '1.0');
insert into osc_cip values (13, 'MONEYORDER_stable', 1, 'MONEYORDER_stable', '1.0');
insert into osc_cip values (14, 'OT_TAX_stable', 1, 'OT_TAX_stable', '1.0');
insert into osc_cip values (15, 'OT_SUBTOTAL_stable', 1, 'OT_SUBTOTAL_stable', '1.0');
insert into osc_cip values (16, 'OT_TOTAL_stable', 1, 'OT_TOTAL_stable', '1.0');
insert into osc_cip values (17, 'OT_SHIPPING_stable', 1, 'OT_SHIPPING_stable', '1.0');
insert into osc_cip values (18, 'SVNUPDATE_stable', 1, 'SVNUPDATE_stable', '1.0');
insert into osc_cip values (19, 'COD_stable', 1, 'COD_stable', '1.0');




insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('Order completed', 'DEFAULT_ORDERS_STATUS_COMPLETED', '3', 'definir le status final d\'une commande livre', '0', '0', NULL, NOW(), NULL, NULL,2);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('Order annulate', 'DEFAULT_ORDERS_STATUS_ANNULATE', '4', 'definir le status d\'une commande annule', '0', '0', NULL, NOW(), NULL, NULL,2);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function) values ('WHOS_ONLINE_ACTIVE_S', 'WHOS_ONLINE_FLAG', 'false', 'WHOS_ONLINE_ACTIVE_L', '0', '0', NOW(), NOW(),NULL, 'tep_cfg_Non_Edit(\';\',');

## 1 store
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, configuration_type) values ('ORDERS_NUMBER_PREFIX_S', 'ORDERS_NUMBER_PREFIX', 'ym-5', 'ORDERS_NUMBER_PREFIX_L', '1', '0', NULL, NOW(), '2');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('STORE_LOGO_S', 'STORE_LOGO', 'oscss_logo.png', 'STORE_LOGO_L', '1', '9', NOW(), NOW(), NULL, 'tep_cfg_choose_img(');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('STORE_LOGO_PRINT_S', 'STORE_LOGO_PRINT', 'oscss_logo.png', 'STORE_LOGO_PRINT_L', '1', '10', NOW(), NOW(), NULL, 'tep_cfg_choose_img(');
update  osc_configuration  set_function='tep_cfg_textarea(' where values configuration_key= 'STORE_NAME_ADDRESS';
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('STORE_LEGAL_INFO_S', 'STORE_LEGAL_INFO', 'legale info \n ', 'STORE_LEGAL_INFO_L', '1', '18', NULL, NOW(), NULL, 'tep_cfg_textarea(');


insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added,set_function) values ('STORE_OFFLINE_S', 'STORE_OFFLINE', 'false', 'STORE_OFFLINE_L', '1', '30', NULL, NOW(),'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added) values ('STORE_OFFLINE_TXT_S', 'STORE_OFFLINE_TXT', '', 'STORE_OFFLINE_TXT_L', '1', '31', NULL, NOW());

insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added) values ('UNIT_WEIGHT_NAME_S', 'UNIT_WEIGHT_NAME', 'Kg', 'UNIT_WEIGHT_NAME_L', '2', '20', NULL, NOW());

## 3 max value

## 4 images
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('POPUP_IMAGE_WIDTH_S', 'POPUP_IMAGE_WIDTH', '600', 'POPUP_IMAGE_WIDTH_L', '4', '7', NULL, NOW(), NULL, NULL);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('POPUP_IMAGE_HEIGHT_S', 'POPUP_IMAGE_HEIGHT', '600', 'POPUP_IMAGE_HEIGHT_L', '4', '8', NULL, NOW(), NULL, NULL);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('STACK_IMAGE_WIDTH_S', 'STACK_IMAGE_WIDTH', '50', 'STACK_IMAGE_WIDTH_L', '4', '9', NULL, NOW(), NULL, NULL);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('STACK_IMAGE_HEIGHT_S', 'STACK_IMAGE_HEIGHT', '50', 'STACK_IMAGE_HEIGHT_L', '4', '10', NULL, NOW(), NULL, NULL);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('JPEG_QUALITY_S', 'JPEG_QUALITY', '95', 'JPEG_QUALITY_L', '4', '11', NULL, NOW(), NULL, 'tep_cfg_pull_down_num_list(80,100,1,');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('IMAGE_NONEXISTENT_S', 'IMAGE_NONEXISTENT', 'oscss_logo.png', 'IMAGE_NONEXISTENT_L', '4', '13', NOW(), NOW(), NULL, 'tep_cfg_choose_img(');

## 6 module option

insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('DEFAULT_RETURN_REASON_S', 'DEFAULT_RETURN_REASON', '2', 'DEFAULT_RETURN_REASON_L', '6', '3', '2003-02-27 06:44:29', '1000-01-01 00:00:00', NULL, NULL);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('DEFAULT_RETURN_STATUS_ID_S', 'DEFAULT_RETURN_STATUS_ID', '1', 'DEFAULT_RETURN_STATUS_ID_L', '6', '4', '2003-02-28 07:10:04', '1000-01-01 00:00:00', NULL, NULL);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('DEFAULT_REFUND_METHOD_S', 'DEFAULT_REFUND_METHOD', '1', 'DEFAULT_REFUND_METHOD_L', '6', '5', '2003-03-01 16:46:12', '1000-01-01 00:00:00', NULL, NULL);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ( 'MODULE_GENERIC_INSTALLED_S', 'MODULE_GENERIC_INSTALLED', '', 'MODULE_GENERIC_INSTALLED_L', '6', '6', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('MODULE_GENERIC_INSTALLED_BO_S', 'MODULE_GENERIC_INSTALLED_BO', '', 'MODULE_GENERIC_INSTALLED_BO_L', '6', '7', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('MODULE_ACAPRO_INSTALLED_S', 'MODULE_ACAPRO_INSTALLED', 'desc_base.php;', 'MODULE_ACAPRO_INSTALLED_L', '6', '8', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('MODULE_ACAPRO_INSTALLED_BO_S', 'MODULE_ACAPRO_INSTALLED_BO', 'desc_base.php;', 'MODULE_ACAPRO_INSTALLED_BO_L', '6', '9', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('MODULE_CONTENT_INSTALLED_S', 'MODULE_CONTENT_INSTALLED', '', 'MODULE_CONTENT_INSTALLED_L', '6', '10', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('MODULE_CONTENT_INSTALLED_BO_S', 'MODULE_CONTENT_INSTALLED_BO', '', 'MODULE_CONTENT_INSTALLED_BO_L', '6', '11', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('MODULE_ACACAT_INSTALLED_S', 'MODULE_ACACAT_INSTALLED', '', 'MODULE_ACACAT_INSTALLED_L', '6', '12', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ( 'MODULE_ACACAT_INSTALLED_BO_S', 'MODULE_ACACAT_INSTALLED_BO', '', 'MODULE_ACACAT_INSTALLED_BO_L', '6', '13', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',',1);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('MODULE_ACCOUNT_INSTALLED_S', 'MODULE_ACCOUNT_INSTALLED', '', 'MODULE_ACCOUNT_INSTALLED_L', '6', '14', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('MODULE_ACCOUNT_INSTALLED_BO_S', 'MODULE_ACCOUNT_INSTALLED_BO', '', 'MODULE_ACCOUNT_INSTALLED_BO_L', '6', '15', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ( 'MODULE_LISTING_INSTALLED_S', 'MODULE_LISTING_INSTALLED', '', 'MODULE_LISTING_INSTALLED_L', '6', '16', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('MODULE_LISTING_INSTALLED_BO_S', 'MODULE_LISTING_INSTALLED_BO', '', 'MODULE_LISTING_INSTALLED_BO_L', '6', '17', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('MODULE_HOME_INSTALLED_S', 'MODULE_HOME_INSTALLED', '', 'MODULE_HOME_INSTALLED_L', '6', '18', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('MODULE_HOME_INSTALLED_BO_S', 'MODULE_HOME_INSTALLED_BO', '', 'MODULE_HOME_INSTALLED_BO_L', '6', '19', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('MODULE_CHECKOUT_PROCESS_INSTALLED_S', 'MODULE_CHECKOUT_PROCESS_INSTALLED', '', 'MODULE_CHECKOUT_PROCESS_INSTALLED_L', '6', '20', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('MODULE_CHECKOUT_PROCESS_INSTALLED_BO_S', 'MODULE_CHECKOUT_PROCESS_INSTALLED_BO', '', 'MODULE_CHECKOUT_PROCESS_INSTALLED_BO_L', '6', '21', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',', '1');

update osc_configuration  SET set_function='tep_cfg_Non_Edit(\';\',' where configuration_key= 'MODULE_SHIPPING_INSTALLED';
update osc_configuration  SET set_function='tep_cfg_Non_Edit(\';\',' where configuration_key= 'MODULE_PAYMENT_INSTALLED';
update osc_configuration  SET set_function='tep_cfg_Non_Edit(\';\',' where configuration_key= 'MODULE_ORDER_TOTAL_INSTALLED';

insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('PLUGIN_GENERIC_INSTALLED_S', 'PLUGIN_GENERIC_INSTALLED', '', 'PLUGIN_GENERIC_INSTALLED_L', '6', '25', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('PLUGIN_PRODUCT_INSTALLED_S', 'PLUGIN_PRODUCT_INSTALLED', '', 'PLUGIN_PRODUCT_INSTALLED_L', '6', '26', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('PLUGIN_ACCOUNT_INSTALLED_S', 'PLUGIN_ACCOUNT_INSTALLED', '', 'PLUGIN_ACCOUNT_INSTALLED_L', '6', '27', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('PLUGIN_LISTING_INSTALLED_S', 'PLUGIN_LISTING_INSTALLED', '', 'PLUGIN_LISTING_INSTALLED_L', '6', '28', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('PLUGIN_HOME_INSTALLED_S', 'PLUGIN_HOME_INSTALLED', '', 'PLUGIN_HOME_INSTALLED_L', '6', '29', NULL, NOW(), NULL, 'tep_cfg_Non_Edit(\';\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, configuration_type) values ('Ordre de description', 'MODULE_ACAPRO_DESC_BASE_SORT_ORDER', '1', 'Ordre de tri pour l\'affichage', '6', '13', NULL, NOW(), '2');


## 9 stock
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('DEFAULT_RESTOCK_VALUE_S', 'DEFAULT_RESTOCK_VALUE', '12.5', 'DEFAULT_RESTOCK_VALUE_L', '9', '0', NOW(), NOW(), NULL, NULL);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified,date_added, use_function, set_function) values ('PRODINFO_ATTRIBUTE_PLUGIN_S', 'PRODINFO_ATTRIBUTE_PLUGIN', 'base', 'PRODINFO_ATTRIBUTE_PLUGIN_L', '9', '6', NULL,NOW(), NULL, 'tep_cfg_pull_down_class_files(\'pad_\',');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified,date_added, use_function, set_function) values ('PRODINFO_ATTRIBUTE_SHOW_OUT_OF_STOCK_S', 'PRODINFO_ATTRIBUTE_SHOW_OUT_OF_STOCK', 'True', 'PRODINFO_ATTRIBUTE_SHOW_OUT_OF_STOCK_L', '9', '7', NULL,NOW(), 'tep_value_for_humain', 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified,date_added, use_function, set_function) values ('PRODINFO_ATTRIBUTE_MARK_OUT_OF_STOCK_S', 'PRODINFO_ATTRIBUTE_MARK_OUT_OF_STOCK', 'Right', 'PRODINFO_ATTRIBUTE_MARK_OUT_OF_STOCK_L', '9', '8', NULL,NOW(), NULL, 'tep_cfg_select_option(array(\'None\', \'Right\', \'Left\'),');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified,date_added, use_function, set_function) values ('PRODINFO_ATTRIBUTE_OUT_OF_STOCK_MSGLINE_S', 'PRODINFO_ATTRIBUTE_OUT_OF_STOCK_MSGLINE', 'True', 'PRODINFO_ATTRIBUTE_OUT_OF_STOCK_MSGLINE_L', '9', '9', NULL,NOW(), 'tep_value_for_humain', 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified,date_added, use_function, set_function) values ('PRODINFO_ATTRIBUTE_ACTUAL_PRICE_PULL_DOWN_S', 'PRODINFO_ATTRIBUTE_ACTUAL_PRICE_PULL_DOWN', 'False', 'PRODINFO_ATTRIBUTE_ACTUAL_PRICE_PULL_DOWN_L', '9', '10',NULL,NOW(), 'tep_value_for_humain', 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified,date_added, use_function, set_function) values ('PRODINFO_ATTRIBUTE_DISPLAY_STOCK_LIST_S', 'PRODINFO_ATTRIBUTE_DISPLAY_STOCK_LIST', 'True', 'PRODINFO_ATTRIBUTE_DISPLAY_STOCK_LIST_L', '9', '11', NULL,NOW(), 'tep_value_for_humain', 'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified,date_added, use_function, set_function) values ('PRODINFO_ATTRIBUTE_NO_ADD_OUT_OF_STOCK_S', 'PRODINFO_ATTRIBUTE_NO_ADD_OUT_OF_STOCK', 'True', 'PRODINFO_ATTRIBUTE_NO_ADD_OUT_OF_STOCK_L', '9', '0', NULL,NOW(), 'tep_value_for_humain', 'tep_cfg_select_option(array(\'True\', \'False\'),');


## 10 log
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('STORE_PAGE_PARSE_STOCK_ERROR_S', 'STORE_PAGE_PARSE_STOCK_ERROR', 'true', 'STORE_PAGE_PARSE_STOCK_ERROR_L', '10', '6', NOW(), NOW(), 'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('STORE_PAGE_PARSE_EMAIL_OWNER_S', 'STORE_PAGE_PARSE_EMAIL_OWNER', 'false', 'STORE_PAGE_PARSE_EMAIL_OWNER_L', '10', '6', NOW(), NOW(), 'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),');



## 15 sessions
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('SESSION_LIFE_ADMIN_S', 'SESSION_LIFE_ADMIN', '25', 'SESSION_LIFE_ADMIN_L.', '15', '1', NOW(), NOW(), NULL, 'tep_cfg_pull_down_num_list(15,60,5,',1);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('SESSION_LIFE_PUBLIC_S', 'SESSION_LIFE_PUBLIC', '25', 'SESSION_LIFE_PUBLIC_L', '15', '2', NOW(), NOW(), NULL, 'tep_cfg_pull_down_num_list(15,60,5,',3);

## 16 seo
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('SEO url', 'SEO_ENABLED', 'true', 'active service SEO', '16', '0', NULL, NOW(), NULL, 'tep_cfg_select_option(array(\'true\', \'false\'),');
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Add cPath to product URLs?', 'SEO_ADD_CPATH_TO_PRODUCT_URLS', 'true', 'This setting will append the cPath to the end of product URLs (i.e. - some-product-p-1.html?cPath=xx).', 16, 1,  NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''),', 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Add category parent to begining of URLs?', 'SEO_ADD_CAT_PARENT', 'true', 'This setting will add the category parent name to the beginning of the category URLs (i.e. - parent-category-c-1.html).', 16, 2,  NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''),', 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Filter Short Words', 'SEO_URLS_FILTER_SHORT_WORDS', '3', 'This setting will filter words less than or equal to the value from the URL.', 16, 3,  NOW(), NOW(), NULL, NULL, 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Output W3C valid URLs (parameter string)?', 'SEO_URLS_USE_W3C_VALID', 'true', 'This setting will output W3C valid URLs.', 16, 4,  NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''),', 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Enable SEO cache to save queries?', 'USE_SEO_CACHE_GLOBAL', 'true', 'This is a global setting and will turn off caching completely.', 16, 5,  NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''),', 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ('Enable product cache?', 'USE_SEO_CACHE_PRODUCTS', 'true', 'This will turn off caching for the products.', 16, 6,  NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''),', 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Enable categories cache?', 'USE_SEO_CACHE_CATEGORIES', 'true', 'This will turn off caching for the categories.', 16, 7,  NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''),', 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Enable topics cache?', 'USE_SEO_CACHE_TOPICS', 'true', 'This will turn off caching for the article topics.', 16, 8,  NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''),', 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Enable link directory cache?', 'USE_SEO_CACHE_LINKS', 'true', 'This will turn off caching for the link category pages.', 16, 9,  NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''),', 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Choose URL Rewrite Type', 'SEO_REWRITE_TYPE', 'Rewrite', 'Choose which SEO URL format to use.', 16, 10,  NOW(), NOW(), NULL, 'tep_cfg_select_option_bis(array(''no-rewrite''=>''Pas de rewriting, le htaccess n est pas necessaire'',''Rewrite''=>'' URL: titre-p-12.html'',''Rewrite-mode2''=>'' URL: p/12/titre.html''),', 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Enter special character conversions', 'SEO_CHAR_CONVERT_SET', 'Ã©=>e,Ã¨=>e,Ã =>a,Ã¹=>u,Ã«=>e,Ã¯=>i,Ãª=>e,Ã´=>o,Ã¶=>o,Ã»=>u,Ã¢=>a,Ã±=>n,Ã¤=>ae,Ã=>Ae,Ã¼=>ue,Ã=>Ue,Ã¶=>oe,Ã=>Oe,Ã=>ss', 'This setting will convert characters.<br /><br />The format <strong>MUST</strong> be in the form: <strong>char=>conv,char2=>conv2</strong>', 16, 11,  NOW(), NOW(), NULL, NULL, 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Remove all non-alphanumeric characters?', 'SEO_REMOVE_ALL_SPEC_CHARS', 'true', 'This will remove all non-letters and non-numbers.  This should be handy to remove all special characters with 1 setting.', 16, 12, '2010-06-14 14:15:38', '2010-06-14 14:15:38', NULL, 'tep_cfg_select_option(array(''true'', ''false''),', 2);
if not exists (select * from osc_configuration where configuration_key = 'SEO_ENABLED' )
INSERT INTO osc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) VALUES ( 'Reset SEO URLs Cache', 'SEO_URLS_CACHE_RESET', 'false', 'This will reset the cache data for SEO', 16, 13,  NOW(), NOW(), 'tep_reset_cache_data_seo_urls', 'tep_cfg_select_option(array(''reset'', ''false''),', 2);



## 17 General Backoffice
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('BO_FILEBROSWER_SERVER_USE_S', 'BO_FILEBROSWER_SERVER_USE', 'tinybrowser', 'BO_FILEBROSWER_SERVER_USE_L', '17', '0', NOW(), NOW(), NULL, NULL, '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('BO_WISIWYG_SELECTED_S', 'BO_WISIWYG_SELECTED', 'tiny_mce', 'BO_WISIWYG_SELECTED_L', '17', '0', NOW(), NOW(), NULL, NULL, '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function,configuration_type ) values ('CHECKUP_WARN_S', 'CHECKUP_WARN', 'true', 'CHECKUP_WARN_L', '17', '6', NOW(), NOW(),'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),','1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function,configuration_type) values ('WARN_INSTALL_EXISTENCE_S', 'WARN_INSTALL_EXISTENCE', 'true', 'WARN_INSTALL_EXISTENCE_L', '17', '7', NOW(), NOW(),'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),','1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function,configuration_type) values ('WARN_CONFIG_WRITEABLE_S', 'WARN_CONFIG_WRITEABLE', 'true', 'WARN_CONFIG_WRITEABLE_L', '17', '8', NOW(), NOW(),'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),','1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function,configuration_type) values ('WARN_SESSION_DIRECTORY_NOT_WRITEABLE_S', 'WARN_SESSION_DIRECTORY_NOT_WRITEABLE', 'true', 'WARN_SESSION_DIRECTORY_NOT_WRITEABLE_L', '17', '9', NOW(), NOW(),'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),','1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function,configuration_type) values ('WARN_DOWNLOAD_DIRECTORY_NOT_READABLE_S', 'WARN_DOWNLOAD_DIRECTORY_NOT_READABLE', 'true', 'WARN_DOWNLOAD_DIRECTORY_NOT_READABLE_L', '17', '10', NOW(), NOW(),'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),','1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function,configuration_type) values ('WARN_SESSION_AUTO_START_S', 'WARN_SESSION_AUTO_START', 'true', 'WARN_SESSION_AUTO_START_L', '17', '11', NOW(), NOW(),'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),','1');




## 21 boxes
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function) values ('OSCSS__B_RECENTLY_VIEWED_S', 'OSCSS__B_RECENTLY_VIEWED', 'true', 'OSCSS__B_RECENTLY_VIEWED_L', '21', '12', NOW(), NOW(),'tep_value_for_humain', 'tep_cfg_select_option(array(\'true\', \'false\'),');


## 22 cart recover
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_BASE_DAYS_S', 'RCS_BASE_DAYS', '30', 'RCS_BASE_DAYS_L', '22', '0', NULL, NOW(), '', '', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_SKIP_DAYS_S', 'RCS_SKIP_DAYS', '5', 'RCS_SKIP_DAYS_L', '22', '1', NULL, NOW(), '', '', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_REPORT_DAYS_S', 'RCS_REPORT_DAYS', '90', 'RCS_REPORT_DAYS_L', '22', '2', NULL, NOW(), '', '', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_INCLUDE_TAX_IN_PRICES_S', 'RCS_INCLUDE_TAX_IN_PRICES', 'false', 'RCS_INCLUDE_TAX_IN_PRICES_L', '22', '3', NULL, NOW(), '', "tep_cfg_select_option(array('true', 'false'),", '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_USE_FIXED_TAX_IN_PRICES_S', 'RCS_USE_FIXED_TAX_IN_PRICES', 'false', 'RCS_USE_FIXED_TAX_IN_PRICES_L', '22', '4', NULL, NOW(), '', "tep_cfg_select_option(array('true', 'false'),", '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type)  values ('RCS_FIXED_TAX_RATE_S', 'RCS_FIXED_TAX_RATE', '.10', 'RCS_FIXED_TAX_RATE_L', '22', '5', NULL, NOW(), '', '', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_EMAIL_TTL_S', 'RCS_EMAIL_TTL', '90', 'RCS_EMAIL_TTL_L', '22', '6', NULL, NOW(), '', '', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_EMAIL_FRIENDLY_S', 'RCS_EMAIL_FRIENDLY', 'true', 'RCS_EMAIL_FRIENDLY_L', '22', '7', NULL, NOW(), '', "tep_cfg_select_option(array('true', 'false'),", '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_EMAIL_COPIES_TO_S', 'RCS_EMAIL_COPIES_TO', '', 'RCS_EMAIL_COPIES_TO_L', '22', '8', NULL, NOW(), '', '', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_SHOW_ATTRIBUTES_S', 'RCS_SHOW_ATTRIBUTES', 'false', 'RCS_SHOW_ATTRIBUTES_L', '22', '9', NULL, NOW(), '', "tep_cfg_select_option(array('true', 'false'),", '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_CHECK_SESSIONS_S', 'RCS_CHECK_SESSIONS', 'false', 'RCS_CHECK_SESSIONS_L', '22', '10', NULL, NOW(), '', "tep_cfg_select_option(array('true', 'false'),", '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type)  values ('RCS_CURCUST_COLOR_S', 'RCS_CURCUST_COLOR', '0000ff', 'RCS_CURCUST_COLOR_L', '22', '11', NULL, NOW(), '', '', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_UNCONTACTED_COLOR_S', 'RCS_UNCONTACTED_COLOR', '9fff9f', 'RCS_UNCONTACTED_COLOR_L', '22', '12', NULL, NOW(), '', '', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type)  values ('RCS_CONTACTED_COLOR_S', 'RCS_CONTACTED_COLOR', 'ff9f9f', 'RCS_CONTACTED_COLOR_L', '22', '13', NULL, NOW(), '', '', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_MATCHED_ORDER_COLOR_S', 'RCS_MATCHED_ORDER_COLOR', '9fffff', 'RCS_MATCHED_ORDER_COLOR_L', '22', '14', NULL, NOW(), '', '', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_SKIP_MATCHED_CARTS_S', 'RCS_SKIP_MATCHED_CARTS', 'true', 'RCS_SKIP_MATCHED_CARTS_L', '22', '15', NULL, NOW(), '', "tep_cfg_select_option(array('true', 'false'),", '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_AUTO_CHECK_S', 'RCS_AUTO_CHECK', 'true', 'RCS_AUTO_CHECK_L', '22', '16', NULL, NOW(), '', "tep_cfg_select_option(array('true', 'false'),", '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_CARTS_MATCH_ALL_DATES_S', 'RCS_CARTS_MATCH_ALL_DATES', 'true', 'RCS_CARTS_MATCH_ALL_DATES_L', '22', '17', NULL, NOW(), '', "tep_cfg_select_option(array('true', 'false'),", '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_PENDING_SALE_STATUS_S', 'RCS_PENDING_SALE_STATUS', 'a:1:{i:0;s:1:"0";}', 'RCS_PENDING_SALE_STATUS_L', '22', '18', NULL, NOW(), 'tep_get_multiple_order_status_names', 'tep_cfg_pull_down_multiple_order_statuses(', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_REPORT_EVEN_STYLE_S', 'RCS_REPORT_EVEN_STYLE', 'dataTableRow', "RCS_REPORT_EVEN_STYLE_L", '22', '19', NULL, NOW(), '', '', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('RCS_REPORT_ODD_STYLE_S', 'RCS_REPORT_ODD_STYLE', '', 'RCS_REPORT_ODD_STYLE_L', '22', '20', NULL, NOW(), '', '', '1');

## 24 cip
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('ALLOW_FILES_BACKUP_S', 'ALLOW_FILES_BACKUP', 'false', 'ALLOW_FILES_BACKUP_L', '24', '2', NOW(), NOW(),'','tep_cfg_select_option(array(\'true\', \'false\'),', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('ALLOW_SQL_BACKUP_S', 'ALLOW_SQL_BACKUP', 'false', 'ALLOW_SQL_BACKUP_L', '24', '3', NOW(), NOW(), '','tep_cfg_select_option(array(\'true\', \'false\'),', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('ALLOW_FILES_RESTORE_S', 'ALLOW_FILES_RESTORE', 'false', 'ALLOW_FILES_RESTORE_L', '24', '4', NOW(), NOW(),'','tep_cfg_select_option(array(\'true\', \'false\'),', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('ALLOW_SQL_RESTORE_S', 'ALLOW_SQL_RESTORE', 'false', 'ALLOW_SQL_RESTORE_L', '24', '5', NOW(), NOW(), '','tep_cfg_select_option(array(\'true\', \'false\'),', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('ALLOW_OVERWRITE_MODIFIED_S', 'ALLOW_OVERWRITE_MODIFIED', 'true', 'ALLOW_OVERWRITE_MODIFIED_L', '24', '6', NOW(), NOW(), '','tep_cfg_select_option(array(\'true\', \'false\'),', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('ALWAYS_DISPLAY_REMOVE_BUTTON_S', 'ALWAYS_DISPLAY_REMOVE_BUTTON', 'false', 'ALWAYS_DISPLAY_REMOVE_BUTTON_L', '24', '7', NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''), ','1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('ALWAYS_DISPLAY_INSTALL_BUTTON_S', 'ALWAYS_DISPLAY_INSTALL_BUTTON', 'false', 'ALWAYS_DISPLAY_INSTALL_BUTTON_L', '24', '8', NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''), ', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('SHOW_SIZE_COLUMN_S', 'SHOW_SIZE_COLUMN', 'true', 'SHOW_SIZE_COLUMN_L', '24', '9', NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''), ', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('SHOW_PACK_BUTTONS_S', 'SHOW_PACK_BUTTONS', 'true', 'SHOW_PACK_BUTTONS_L', '24', '10', NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''), ', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('USE_LOG_SYSTEM_S', 'USE_LOG_SYSTEM', 'false', 'USE_LOG_SYSTEM_L', '24', '11', NOW(), NOW(), NULL, 'tep_cfg_select_option(array(''true'', ''false''), ', '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('MAX_UPLOADED_FILESIZE_S', 'MAX_UPLOADED_FILESIZE', '524288', 'MAX_UPLOADED_FILESIZE_L', '24', '12', NOW(), NOW(), NULL, NULL, '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('TEXT_LINK_FORUM_S', 'TEXT_LINK_FORUM', 'http://forums.oscommerce.com/index.php?showtopic=', 'TEXT_LINK_FORUM_L', '24', '13', NOW(), NOW(), NULL, NULL, '1');
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function , set_function, configuration_type) values ('TEXT_LINK_CONTR_S', 'TEXT_LINK_CONTR', 'http://www.oscommerce.com/community/contributions,', 'TEXT_LINK_CONTR_L', '24', '14', NOW(), NOW(), NULL, NULL, '1');

## 25 new products
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('MAX_DATEADDED_FOR_NEWX_PRODUCT_S', 'MAX_DATEADDED_FOR_NEWX_PRODUCT', '2', 'MAX_DATEADDED_FOR_NEWX_PRODUCT_L', '25', '0', NULL, '1000-01-01 00:00:00', NULL, NULL);

## 26 products option


## 27 general appearance

insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified,date_added, use_function, set_function) values ('NOT_RECUP_CASSE_IN_TXT_CATEGORIES_S', 'NOT_RECUP_CASSE_IN_TXT_CATEGORIES', 'false', 'NOT_RECUP_CASSE_IN_TXT_CATEGORIES_L', '27', '1', NULL, NOW(), 'tep_value_for_humain', 'tep_cfg_select_option(array(\'True\', \'False\'),');



drop table if exists osc_configuration_group;
CREATE TABLE osc_configuration_group (
  configuration_group_id int(11) NOT NULL auto_increment,
  configuration_group_title varchar(64) NOT NULL,
  configuration_group_description varchar(1) NULL,
  sort_order int(5) default NULL,
  visible int(1) default '1',
  configuration_group_parentid tinyint(1) NOT NULL,
  configuration_group_group_id varchar(64) NOT NULL,
  configuration_group_key varchar(64) not null ,
  PRIMARY KEY  (configuration_group_id)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


insert into osc_configuration_group values (19, 'PAGE_PRODUCT_DETAIL', NULL, 0, 1, 100, '1', 'CG_PAGE_PRODUCT_DETAIL');
insert into osc_configuration_group values (2,  'VALUE_MINI', NULL, 0, 1, 110, '1', 'CG_VALUE_MINI');
## insert into osc_configuration_group values (3,  'VALUE_MAXI', NULL, 0, 1, 110, '1', 'CG_VALUE_MAXI');
insert into osc_configuration_group values (4,  'IMAGES', NULL, 0, 1, 100, '1', 'CG_IMAGES');
insert into osc_configuration_group values (7,  'EXPEDITION_EMBALLAGE', NULL, 0, 1, 127, '1', 'CG_EXPEDITION_EMBALLAGE');
insert into osc_configuration_group values (8,  'LIST_PRODUTCS', NULL, 0, 1, 100, '1', 'CG_LIST_PRODUTCS');
insert into osc_configuration_group values (9,  'STOCK', NULL, 0, 1, 127, '1', 'CG_STOCK');
insert into osc_configuration_group values (10, 'LOGGING', NULL, 0, 1, 120, '1', 'CG_LOGGING');
insert into osc_configuration_group values (11, 'OPTION_CATALOG', NULL, 0, 1, 127, '1', 'CG_OPTION_CATALOG');
insert into osc_configuration_group values (12, 'OPTION_MAIL', NULL, 0, 1, 120, '1', 'CG_OPTION_MAIL');
insert into osc_configuration_group values (13, 'DOWNLOADS', NULL, 0, 1, 127, '1', 'CG_DOWNLOADS');
insert into osc_configuration_group values (14, 'COMPRESSION', NULL, 0, 1, 120, '1', 'CG_COMPRESSION');
insert into osc_configuration_group values (15, 'SESSION', NULL, 0, 1, 120, '1', 'CG_SESSION');
insert into osc_configuration_group values (17, 'QUICK_UPDATE', NULL, 0, 1, 126, '1', 'CG_QUICK_UPDATE');
insert into osc_configuration_group values (16, 'SEO_URL', NULL, 0, 1, 120, '1', 'CG_SEO_URL');
insert into osc_configuration_group values (1, 	'MY_BOUTIQUE', NULL, 0, 1, 110, '1', 'CG_MY_BOUTIQUE');
insert into osc_configuration_group values (100,'APPARENCE', NULL, 0, 1, 0, '1', 'CG_APPARENCE');
insert into osc_configuration_group values (110,'CONFIGURATION', NULL, 0, 1, 0, '1', 'CG_CONFIGURATION');
insert into osc_configuration_group values (120,'CONFIG_AVANCE', NULL, 0, 1, 0, '1', 'CG_CONFIG_AVANCE');
insert into osc_configuration_group values (126,'ESPACE_ADMIN', NULL, 0, 1, 0, '1', 'CG_ESPACE_ADMIN');
insert into osc_configuration_group values (127,'CONFIG_COMM', NULL, 0, 1, 0, '1', 'CG_CONFIG_COMM');
insert into osc_configuration_group values (6, 	'OPTION_MODULES', NULL, 0, 1, 120, '1', 'CG_OPTION_MODULES');
insert into osc_configuration_group values (20, 'PRODUCT_ATTENTE', NULL, 0, 1, 126, '1', 'CG_PRODUCT_ATTENTE');
insert into osc_configuration_group values (21, 'OPEN_BOX', NULL, 0, 1, 100, '1', 'CG_OPEN_BOX');
insert into osc_configuration_group values (22, 'RECOVER_CART_SALES', NULL,  0, 1, 126, '1', 'CG_RECOVER_CART_SALES');
insert into osc_configuration_group values (24 , 'CG_CIP_MANAGER', NULL, 0 , 1, 120, '1', 'CG_CIP_MANAGER');
insert into osc_configuration_group values (25 , 'NEW_PRODUCTS', NULL, 0 , 1, 110, '1', 'CG_NEW_PRODUCTS');
## insert into osc_configuration_group values (26,  'ATTRIBUTE_PRODUCT', NULL,0 , 1, 120, '1', 'CG_ATTRIBUTE_PRODUCT');
insert into osc_configuration_group values (27 , 'APPARENCE_GENERAL', NULL, 0 , 1, 100, '1', 'CG_APPARENCE_GENERAL');
insert into osc_configuration_group values (28 , 'MEMBRES_DETAIL', NULL, 0 , 1, 110, '1', 'CG_MEMBRES_DETAIL');
insert into osc_configuration_group values (29 , 'BOX_CONFIGURATION_TEMPLATE', NULL, 0 , 1, 100, '1', 'BOX_LOCALIZATION_ORDERS_STATUS');
insert into osc_configuration_group values (30 , 'BOX_LOCALIZATION_ORDERS_STATUS', NULL, 0 , 1, 110, '1', 'BOX_CONFIGURATION_TEMPLATE');
insert into osc_configuration_group values (31 , 'BOX_LOCALIZATION_LANGUAGES', NULL, 0 , 1, 110, '1', 'BOX_LOCALIZATION_LANGUAGES');
insert into osc_configuration_group values (33 , 'BOX_CONFIGURATION_EXTRA_FIELDS', NULL, 0 , 1, 120, '1', 'BOX_CONFIGURATION_EXTRA_FIELDS');
insert into osc_configuration_group values (34 , 'BOX_CONFIGURATION_PRODUCTS_EXTRA_FIELDS', NULL, 0 , 1, 120, '1', 'BOX_CONFIGURATION_PRODUCTS_EXTRA_FIELDS');



insert into osc_discount_coupons (coupons_id, coupons_description, coupons_discount_amount, coupons_discount_type, coupons_date_start, coupons_date_end, coupons_max_use, coupons_min_order, coupons_min_order_type, coupons_number_available) values ('testing001','testing',2,'percent',NULL,NULL,2,1,'price',1);
insert into osc_discount_coupons_to_categories (coupons_id, categories_id) values ('testing001',22);
insert into osc_discount_coupons_to_customers (coupons_id, customers_id) values ('testing001',4);



INSERT INTO osc_status VALUES (1, 'returns', 1, 'OSC_RETURNS_STATUS_PENDING','#FF1A00');
INSERT INTO osc_status VALUES (2, 'returns',1, 'OSC_RETURNS_STATUS_AWAITING_RETURN', '#3393D9');
INSERT INTO osc_status VALUES (3, 'returns',1, 'OSC_RETURNS_STATUS_CANCELLED', '#66FF00');
INSERT INTO osc_status VALUES (4, 'returns',1, 'OSC_RETURNS_STATUS_COMPLETE', '#666');

INSERT INTO osc_status VALUES (1, 'return_reasons', 1, 'OSC_RETURN_REASONS_FAULTY','#FF1A00');
INSERT INTO osc_status VALUES (2, 'return_reasons',1, 'OSC_RETURN_REASONS_DAMAGED', '#3393D9');
INSERT INTO osc_status VALUES (3, 'return_reasons',1, 'OSC_RETURN_REASONS_INCORRECT_ITEM', '#66FF00');
INSERT INTO osc_status VALUES (4, 'return_reasons',1, 'OSC_RETURN_REASONS_WARRANTY', '#666');

INSERT INTO osc_status VALUES (1, 'refund_method', 1, 'OSC_REFUND_METHOD_PAYPAL','');
INSERT INTO osc_status VALUES (2, 'refund_method', 1, 'OSC_REFUND_METHOD_NOCHEX','');
INSERT INTO osc_status VALUES (3, 'refund_method', 1, 'OSC_REFUND_METHOD_EXCHANGE','');
INSERT INTO osc_status VALUES (4, 'refund_method', 1, 'OSC_REFUND_METHOD_GIFT_VOUCHERS','');

insert into osc_status values (1, 'products_virtual_types', 1, 'OSC_PRODUCTS_VIRTUAL_TYPES_PHYSICAL','');
insert into osc_status values (2, 'products_virtual_types',1, 'OSC_PRODUCTS_VIRTUAL_TYPES_SUBSCRIPTION','');
insert into osc_status values (3, 'products_virtual_types',1, 'OSC_PRODUCTS_VIRTUAL_TYPES_SERVICE','');
insert into osc_status values (4, 'products_virtual_types',1, 'OSC_PRODUCTS_VIRTUAL_TYPES_SOFTWARE','');

INSERT INTO osc_status VALUES (1, 'attribute_optiontype', 1, 'Select','');
INSERT INTO osc_status VALUES (2, 'attribute_optiontype', 1, 'Text','');
INSERT INTO osc_status VALUES (3, 'attribute_optiontype', 1, 'Radio','');
INSERT INTO osc_status VALUES (4, 'attribute_optiontype', 1, 'Checkbox','');


insert into osc_return_text values (0, 1, 'testing only');
insert into osc_return_text values (1, 1, 'Thank you for submitting your return request. Please be sure to make a note of the above RMA number, as you will need it to track the progress of your return. We will be in touch soon with further instructions regarding your return request.<br /><br />');


INSERT INTO osc_customers_groups (customers_group_id, customers_group_name, customers_group_show_tax, customers_group_tax_exempt, group_payment_allowed, group_shipment_allowed, group_order_total_allowed, group_specific_taxes_exempt, group_discount) VALUES
(0, 'particuliers', '1', '0', '', '', '', '', 0.00);

UPDATE osc_configuration SET configuration_value='' WHERE configuration_key='MODULE_SHIPPING_INSTALLED';
UPDATE osc_configuration SET configuration_value='' WHERE configuration_key='MODULE_PAYMENT_INSTALLED';
UPDATE osc_configuration SET configuration_value='' WHERE configuration_key='MODULE_ORDER_TOTAL_INSTALLED';

ALTER TABLE osc_holding_orders_products ADD COLUMN products_stock_attributes varchar(255) default NULL;

UPDATE osc_categories SET categories_status = '1', categories_hidden = '1';