####################################-
#|                  osCSS Open Source E-commerce                         |
####################################-
#| Copyright (c) 2005-2010 The osCSS developers                          |
#|                                                                       |
#| http://www.oscss.org                                                  |
#| http://www.oscim.net                                                  |
#| Portions Copyright (c) 2003 osCommerce                                |
####################################-
#| This source file is subject to version 2.0 of the GPL license,        |
#| available at the following url:                                       |
#| http://www.oscss.org/license/2_0.txt.                                 |
####################################-

# NOTE: * Please make any modifications to this file by hand!
#       * DO NOT use a mysqldump created file for new changes!
#       * Please take note of the table structure, and use this
#         structure as a standard for future modifications!
#       * Any tables you add here should be added in admin/backup.php
#         and in catalog/install/includes/functions/database.php
#       * Comments should be like these, full line comments.
#         (don't use inline comments)


DROP TABLE IF EXISTS osc_admin;
CREATE TABLE osc_admin (
  admin_id int(11) not null auto_increment,
  admin_groups_id int(11) ,
  admin_firstname varchar(32) not null ,
  admin_lastname varchar(32) ,
  admin_email_address varchar(96) not null ,
  admin_password varchar(40) not null ,
  admin_created datetime ,
  admin_modified datetime default '1000-01-01 00:00:00' not null ,
  admin_logdate datetime ,
  admin_lognum int(11) default '0' not null ,
  url_openid varchar(150) null,
  PRIMARY KEY (admin_id),
  UNIQUE admin_email_address (admin_email_address)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

drop table if exists osc_admin_files;
CREATE TABLE osc_admin_files (
  admin_files_id int(11) NOT NULL auto_increment,
  admin_files_name varchar(128) NOT NULL COMMENT 'fichier, avec get',
  admin_files_is_boxes tinyint(1) NOT NULL default '0' COMMENT '1 si est une boite',
  admin_files_to_boxes tinyint(1) NOT NULL default '0' COMMENT 'precise le num de la  boite parent',
  admin_groups_id set('1','2','3','4','5') NOT NULL default '1',
  PRIMARY KEY  (admin_files_id),
  UNIQUE KEY admin_files_name (admin_files_name,admin_files_is_boxes,admin_files_to_boxes)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


drop table if exists osc_admin_groups;
create table osc_admin_groups (
  admin_groups_id int(11) not null auto_increment,
  admin_groups_name varchar(64) ,
  PRIMARY KEY (admin_groups_id),
  UNIQUE admin_groups_name (admin_groups_name)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS osc_navigation_links (
  nav_link_id int(11) NOT NULL auto_increment,
  nav_sort_order int(11) NOT NULL default '1',
  nav_css_id varchar(50) NOT NULL default '',
  nav_file varchar(50) NOT NULL default '',
  nav_link_type int(1) NOT NULL default '0',
  customers_status int(1) NOT NULL default '1',
  nav_link_status int(1) NOT NULL default '1',
  PRIMARY KEY  (nav_link_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1  ;


CREATE TABLE IF NOT EXISTS osc_navigation_links_description (
  nav_link_id int(11) NOT NULL default '0',
  language_id int(11) NOT NULL default '0',
  nav_name varchar(50) NOT NULL default '',
  PRIMARY KEY  (nav_link_id,language_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS osc_admin_files (
  admin_files_id int(11) NOT NULL auto_increment,
  admin_files_name varchar(64) NOT NULL default '',
  admin_files_is_boxes tinyint(5) NOT NULL default '0',
  admin_files_to_boxes int(11) NOT NULL default '0',
  admin_groups_id set('1','2') NOT NULL default '1',
  PRIMARY KEY  (admin_files_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ;


CREATE TABLE IF NOT EXISTS osc_admin_groups (
  admin_groups_id int(11) NOT NULL auto_increment,
  admin_groups_name varchar(64) default NULL,
  PRIMARY KEY  (admin_groups_id),
  UNIQUE KEY admin_groups_name (admin_groups_name)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ;


CREATE TABLE IF NOT EXISTS osc_am_attributes_to_templates (
  template_id int(5) unsigned NOT NULL,
  options_id int(5) unsigned NOT NULL,
  option_values_id int(5) unsigned NOT NULL,
  KEY template_id (template_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

;
CREATE TABLE IF NOT EXISTS osc_am_templates (
  template_id int(5) unsigned NOT NULL auto_increment,
  template_name varchar(255) NOT NULL,
  PRIMARY KEY  (template_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1  ;

CREATE TABLE IF NOT EXISTS osc_admin (
  admin_id int(11) NOT NULL auto_increment,
  admin_groups_id int(11) default NULL,
  admin_firstname varchar(32) NOT NULL default '',
  admin_lastname varchar(32) default NULL,
  admin_email_address varchar(96) NOT NULL default '',
  admin_password varchar(40) NOT NULL default '',
  admin_created datetime default NULL,
  admin_modified datetime NOT NULL default '1000-01-01 00:00:00',
  admin_logdate datetime default NULL,
  admin_lognum int(11) NOT NULL default '0',
  PRIMARY KEY  (admin_id),
  UNIQUE KEY admin_email_address (admin_email_address)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ;

CREATE TABLE IF NOT EXISTS osc_holding_orders (
  orders_id int(11) NOT NULL auto_increment,
  customers_id int(11) NOT NULL default '0',
  customers_name varchar(64) NOT NULL default '',
  customers_company varchar(32) default NULL,
  customers_street_address varchar(64) NOT NULL default '',
  customers_suburb varchar(32) default NULL,
  customers_city varchar(32) NOT NULL default '',
  customers_postcode varchar(10) NOT NULL default '',
  customers_state varchar(32) default NULL,
  customers_country varchar(32) NOT NULL default '',
  customers_telephone varchar(32) NOT NULL default '',
  customers_email_address varchar(96) NOT NULL default '',
  customers_address_format_id int(5) NOT NULL default '0',
  delivery_name varchar(64) NOT NULL default '',
  delivery_company varchar(32) default NULL,
  delivery_street_address varchar(64) NOT NULL default '',
  delivery_suburb varchar(32) default NULL,
  delivery_city varchar(32) NOT NULL default '',
  delivery_postcode varchar(10) NOT NULL default '',
  delivery_state varchar(32) default NULL,
  delivery_country varchar(32) NOT NULL default '',
  delivery_address_format_id int(5) NOT NULL default '0',
  billing_name varchar(64) NOT NULL default '',
  billing_company varchar(32) default NULL,
  billing_street_address varchar(64) NOT NULL default '',
  billing_suburb varchar(32) default NULL,
  billing_city varchar(32) NOT NULL default '',
  billing_postcode varchar(10) NOT NULL default '',
  billing_state varchar(32) default NULL,
  billing_country varchar(32) NOT NULL default '',
  billing_address_format_id int(5) NOT NULL default '0',
  payment_method varchar(32) NOT NULL default '',
  cc_type varchar(20) default NULL,
  cc_owner varchar(64) default NULL,
  cc_number varchar(32) default NULL,
  cc_expires varchar(4) default NULL,
  last_modified datetime default NULL,
  date_purchased datetime default NULL,
  orders_status int(5) NOT NULL default '1',
  orders_date_finished datetime default NULL,
  currency char(3) default NULL,
  currency_value decimal(14,6) default NULL,
  ip_address varchar(50) NOT NULL default '',
  PRIMARY KEY  (orders_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1  ;


CREATE TABLE IF NOT EXISTS osc_holding_orders_products (
  orders_products_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  products_id int(11) NOT NULL default '0',
  products_model varchar(12) default NULL,
  products_name varchar(64) NOT NULL default '',
  products_price decimal(15,4) NOT NULL default '0.0000',
  final_price decimal(15,4) NOT NULL default '0.0000',
  products_tax decimal(7,4) NOT NULL default '0.0000',
  products_quantity int(2) NOT NULL default '0',
  products_returned tinyint(2) unsigned default '0',
  products_exchanged tinyint(2) NOT NULL default '0',
  products_exchanged_id int(11) NOT NULL default '0',
  PRIMARY KEY  (orders_products_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 ;


CREATE TABLE IF NOT EXISTS osc_holding_orders_products_attributes (
  orders_products_attributes_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  orders_products_id int(11) NOT NULL default '0',
  products_options varchar(32) NOT NULL default '',
  products_options_values varchar(32) NOT NULL default '',
  options_values_price decimal(15,4) NOT NULL default '0.0000',
  price_prefix char(1) NOT NULL default '',
  PRIMARY KEY  (orders_products_attributes_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;



CREATE TABLE IF NOT EXISTS osc_holding_orders_products_download (
  orders_products_download_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  orders_products_id int(11) NOT NULL default '0',
  orders_products_filename varchar(255) NOT NULL default '',
  download_maxdays int(2) NOT NULL default '0',
  download_count int(2) NOT NULL default '0',
  PRIMARY KEY  (orders_products_download_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



CREATE TABLE IF NOT EXISTS osc_holding_orders_status_history (
  orders_status_history_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  orders_status_id int(5) NOT NULL default '0',
  date_added datetime NOT NULL default '1000-01-01 00:00:00',
  customer_notified int(1) default '0',
  comments text,
  PRIMARY KEY  (orders_status_history_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1  ;


CREATE TABLE IF NOT EXISTS osc_holding_orders_total (
  orders_total_id int(10) unsigned NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  text varchar(255) NOT NULL default '',
  value decimal(15,4) NOT NULL default '0.0000',
  class varchar(32) NOT NULL default '',
  sort_order int(11) NOT NULL default '0',
  PRIMARY KEY  (orders_total_id),
  KEY idx_orders_total_orders_id (orders_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;


ALTER TABLE osc_address_book MODIFY COLUMN entry_gender char(1) NOT NULL;
ALTER TABLE osc_address_book MODIFY COLUMN entry_firstname varchar(32) NOT NULL;
ALTER TABLE osc_address_book MODIFY COLUMN entry_lastname varchar(32) NOT NULL;
ALTER TABLE osc_address_book MODIFY COLUMN entry_street_address varchar(64) NOT NULL;
ALTER TABLE osc_address_book MODIFY COLUMN entry_postcode varchar(10) NOT NULL;
ALTER TABLE osc_address_book MODIFY COLUMN entry_city varchar(32) NOT NULL;


ALTER TABLE osc_admin MODIFY COLUMN admin_firstname varchar(32) NOT NULL;
ALTER TABLE osc_admin MODIFY COLUMN admin_email_address varchar(96) NOT NULL;
ALTER TABLE osc_admin MODIFY COLUMN admin_password varchar(40) NOT NULL;

ALTER TABLE osc_admin_files MODIFY COLUMN admin_files_name varchar(64) NOT NULL;

-- IF EXISTS( SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'osc_banners' AND  COLUMN_NAME = 'banners_title')
ALTER TABLE osc_banners MODIFY COLUMN banners_title varchar(64) NOT NULL;

-- IF EXISTS( SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'osc_banners' AND  COLUMN_NAME = 'banners_url')
ALTER TABLE osc_banners MODIFY COLUMN banners_url varchar(255) NOT NULL;

-- IF EXISTS( SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'osc_banners' AND  COLUMN_NAME = 'banners_image')
ALTER TABLE osc_banners MODIFY COLUMN banners_image varchar(64) NOT NULL;

-- IF EXISTS( SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'osc_banners' AND  COLUMN_NAME = 'banners_group')
ALTER TABLE osc_banners MODIFY COLUMN banners_group varchar(10) NOT NULL;


ALTER TABLE osc_categories_description MODIFY COLUMN categories_name varchar(32) NOT NULL;


ALTER TABLE osc_configuration MODIFY COLUMN configuration_title varchar(64) NOT NULL;
ALTER TABLE osc_configuration MODIFY COLUMN configuration_key varchar(64) NOT NULL;
ALTER TABLE osc_configuration MODIFY COLUMN configuration_value varchar(255) NOT NULL;
ALTER TABLE osc_configuration MODIFY COLUMN configuration_description varchar(255) NOT NULL;


ALTER TABLE osc_configuration_group MODIFY COLUMN configuration_group_title varchar(64) NOT NULL;
ALTER TABLE osc_configuration_group MODIFY COLUMN configuration_group_description varchar(255) NOT NULL;

CREATE TABLE IF NOT EXISTS osc_content (
  content_id int(10) unsigned NOT NULL auto_increment,
  content_name varchar(50) NOT NULL,
  date_added datetime default NULL,
  last_modified datetime default NULL,
  content_status tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (content_id),
  KEY content_name (content_name)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1  ;



CREATE TABLE IF NOT EXISTS osc_content_description (
  content_id int(10) unsigned NOT NULL default '0',
  content_title varchar(128) NOT NULL,
  content_text text NOT NULL,
  language_id int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


ALTER TABLE osc_countries MODIFY COLUMN countries_name varchar(64) NOT NULL;
ALTER TABLE osc_countries ADD COLUMN countries_localname varchar(64) NOT NULL;
ALTER TABLE osc_countries MODIFY COLUMN countries_iso_code_2 char(2) NOT NULL;
ALTER TABLE osc_countries MODIFY COLUMN countries_iso_code_3 char(3) NOT NULL;

CREATE TABLE IF NOT EXISTS osc_coupons (
  coupon_id int(11) NOT NULL auto_increment,
  coupon_type char(1) NOT NULL default 'F',
  coupon_code varchar(32) NOT NULL default '',
  coupon_amount decimal(8,4) NOT NULL default '0.0000',
  coupon_minimum_order decimal(8,4) NOT NULL default '0.0000',
  coupon_start_date datetime NOT NULL default '1000-01-01 00:00:00',
  coupon_expire_date datetime NOT NULL default '1000-01-01 00:00:00',
  uses_per_coupon int(5) NOT NULL default '1',
  uses_per_user int(5) NOT NULL default '0',
  restrict_to_products varchar(255) default NULL,
  restrict_to_categories varchar(255) default NULL,
  restrict_to_customers text,
  coupon_active char(1) NOT NULL default 'Y',
  date_created datetime NOT NULL default '1000-01-01 00:00:00',
  date_modified datetime NOT NULL default '1000-01-01 00:00:00',
  PRIMARY KEY  (coupon_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ;



CREATE TABLE IF NOT EXISTS osc_coupons_description (
  coupon_id int(11) NOT NULL default '0',
  language_id int(11) NOT NULL default '0',
  coupon_name varchar(32) NOT NULL default '',
  coupon_description text,
  KEY coupon_id (coupon_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS osc_coupon_email_track (
  unique_id int(11) NOT NULL auto_increment,
  coupon_id int(11) NOT NULL default '0',
  customer_id_sent int(11) NOT NULL default '0',
  sent_firstname varchar(32) default NULL,
  sent_lastname varchar(32) default NULL,
  emailed_to varchar(32) default NULL,
  date_sent datetime NOT NULL default '1000-01-01 00:00:00',
  PRIMARY KEY  (unique_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1  ;



CREATE TABLE IF NOT EXISTS osc_coupon_gv_customer (
  customer_id int(5) NOT NULL default '0',
  amount decimal(8,4) NOT NULL default '0.0000',
  PRIMARY KEY  (customer_id),
  KEY customer_id (customer_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS osc_coupon_gv_queue (
  unique_id int(5) NOT NULL auto_increment,
  customer_id int(5) NOT NULL default '0',
  order_id int(5) NOT NULL default '0',
  amount decimal(8,4) NOT NULL default '0.0000',
  date_created datetime NOT NULL default '1000-01-01 00:00:00',
  ipaddr varchar(32) NOT NULL default '',
  release_flag char(1) NOT NULL default 'N',
  PRIMARY KEY  (unique_id),
  KEY uid (unique_id,customer_id,order_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1  ;



CREATE TABLE IF NOT EXISTS osc_coupon_redeem_track (
  unique_id int(11) NOT NULL auto_increment,
  coupon_id int(11) NOT NULL default '0',
  customer_id int(11) NOT NULL default '0',
  redeem_date datetime NOT NULL default '1000-01-01 00:00:00',
  redeem_ip varchar(32) NOT NULL default '',
  order_id int(11) NOT NULL default '0',
  PRIMARY KEY  (unique_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1  ;


ALTER TABLE osc_currencies MODIFY COLUMN title varchar(32) NOT NULL;
ALTER TABLE osc_currencies MODIFY COLUMN code char(3) NOT NULL;

ALTER TABLE osc_customers MODIFY COLUMN customers_gender char(1) NOT NULL;
ALTER TABLE osc_customers MODIFY COLUMN customers_firstname varchar(32) NOT NULL;
ALTER TABLE osc_customers MODIFY COLUMN customers_lastname varchar(32) NOT NULL;
ALTER TABLE osc_customers MODIFY COLUMN customers_email_address varchar(96) NOT NULL;
ALTER TABLE osc_customers MODIFY COLUMN customers_telephone varchar(32) NOT NULL;
ALTER TABLE osc_customers MODIFY COLUMN customers_password varchar(40) NOT NULL;

ALTER TABLE osc_customers ADD COLUMN customers_group_id smallint(5) unsigned NOT NULL default '0' AFTER customers_newsletter;
ALTER TABLE osc_customers ADD COLUMN customers_group_ra enum('0','1') NOT NULL AFTER customers_group_id;
ALTER TABLE osc_customers ADD COLUMN customers_payment_allowed varchar(255) NOT NULL default '' AFTER customers_group_ra;
ALTER TABLE osc_customers ADD COLUMN customers_shipment_allowed varchar(255) NOT NULL default '' AFTER customers_payment_allowed;
ALTER TABLE osc_customers ADD COLUMN customers_order_total_allowed varchar(255) NOT NULL default '' AFTER customers_shipment_allowed;
ALTER TABLE osc_customers ADD COLUMN customers_specific_taxes_exempt varchar(255) NOT NULL default '' AFTER customers_order_total_allowed;
ALTER TABLE osc_customers ADD COLUMN customers_discount decimal(5,2) default '0.00' AFTER customers_specific_taxes_exempt;
ALTER TABLE osc_customers ADD COLUMN customers_shopping_points decimal(15,2) NOT NULL default '0.00';
ALTER TABLE osc_customers ADD COLUMN customers_points_expires date default NULL;

CREATE TABLE IF NOT EXISTS osc_customers_points_pending (
  unique_id int(11) NOT NULL auto_increment,
  customer_id int(11) NOT NULL default '0',
  orders_id int(11) NOT NULL default '0',
  points_pending decimal(15,2) NOT NULL default '0.00',
  points_comment varchar(200) default NULL,
  date_added datetime NOT NULL default '1000-01-01 00:00:00',
  points_status int(1) NOT NULL default '1',
  points_type varchar(2) NOT NULL default 'SP',
  PRIMARY KEY  (unique_id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1  ;


ALTER TABLE osc_geo_zones MODIFY COLUMN geo_zone_name varchar(32) NOT NULL;
ALTER TABLE osc_geo_zones MODIFY COLUMN geo_zone_description varchar(255) NOT NULL;



ALTER TABLE osc_holding_orders MODIFY COLUMN customers_name varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_street_address varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_city varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_postcode varchar(10) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_country varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_telephone varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN customers_email_address varchar(96) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN delivery_name varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN delivery_street_address varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN delivery_city varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN delivery_postcode varchar(10) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN delivery_country varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN billing_name varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN billing_street_address varchar(64) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN billing_city varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN billing_postcode varchar(10) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN billing_country varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders MODIFY COLUMN payment_method varchar(32) NOT NULL;





ALTER TABLE osc_holding_orders_products MODIFY COLUMN products_name varchar(64) NOT NULL;


ALTER TABLE osc_holding_orders_products_attributes MODIFY COLUMN products_options varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders_products_attributes MODIFY COLUMN products_options_values varchar(32) NOT NULL;
ALTER TABLE osc_holding_orders_products_attributes MODIFY COLUMN price_prefix char(1) NOT NULL;

ALTER TABLE osc_holding_orders_products_download MODIFY COLUMN orders_products_filename varchar(255) NOT NULL;



ALTER TABLE osc_holding_orders_total MODIFY COLUMN title varchar(255) NOT NULL;
ALTER TABLE osc_holding_orders_total MODIFY COLUMN text varchar(255) NOT NULL;
ALTER TABLE osc_holding_orders_total MODIFY COLUMN class varchar(32) NOT NULL;

ALTER TABLE osc_languages MODIFY COLUMN name varchar(32) NOT NULL;
ALTER TABLE osc_languages MODIFY COLUMN code char(2) NOT NULL;

ALTER TABLE osc_manufacturers MODIFY COLUMN manufacturers_name varchar(32) NOT NULL;


ALTER TABLE osc_manufacturers_info MODIFY COLUMN manufacturers_url varchar(255) NOT NULL;

ALTER TABLE osc_navigation_links MODIFY COLUMN nav_css_id varchar(50) NOT NULL;
ALTER TABLE osc_navigation_links MODIFY COLUMN nav_file varchar(50) NOT NULL;

ALTER TABLE osc_navigation_links_description MODIFY COLUMN nav_name varchar(50) NOT NULL;

ALTER TABLE osc_newsletters MODIFY COLUMN title varchar(255) NOT NULL;
ALTER TABLE osc_newsletters MODIFY COLUMN module varchar(255) NOT NULL;




ALTER TABLE osc_orders MODIFY COLUMN  customers_name varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN customers_street_address varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN customers_postcode varchar(10) NOT NULL default '';
ALTER TABLE osc_orders MODIFY COLUMN  customers_city varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN customers_postcode varchar(10) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN  customers_country varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN customers_telephone varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN customers_email_address varchar(96) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN  delivery_name varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN delivery_street_address varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN delivery_city varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN delivery_postcode varchar(10) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN delivery_country varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN  billing_name varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN  billing_street_address varchar(64) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN billing_city varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN billing_postcode varchar(10) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN  billing_country varchar(32) NOT NULL;
ALTER TABLE osc_orders MODIFY COLUMN payment_method varchar(32) NOT NULL;


ALTER TABLE osc_orders ADD COLUMN ip_address varchar(15) NOT NULL;


ALTER TABLE osc_orders_products MODIFY COLUMN products_name varchar(64) NOT NULL;


ALTER TABLE osc_orders_products_attributes MODIFY COLUMN products_options varchar(32) NOT NULL;
ALTER TABLE osc_orders_products_attributes MODIFY COLUMN products_options_values varchar(32) NOT NULL;
ALTER TABLE osc_orders_products_attributes MODIFY COLUMN price_prefix char(1) NOT NULL;



ALTER TABLE osc_orders_status MODIFY COLUMN orders_status_name varchar(32) NOT NULL;
ALTER TABLE osc_orders_status ADD COLUMN orders_status_color varchar(8) NOT NULL;

ALTER TABLE osc_orders_total MODIFY COLUMN title varchar(255) NOT NULL;
ALTER TABLE osc_orders_total MODIFY COLUMN text varchar(255) NOT NULL;
ALTER TABLE osc_orders_total MODIFY COLUMN class varchar(32) NOT NULL;


CREATE TABLE IF NOT EXISTS osc_products_extra_images (
  products_extra_images_id int(11) NOT NULL auto_increment,
  products_id int(11) default NULL,
  products_extra_image varchar(64) default NULL,
  KEY products_extra_images_id (products_extra_images_id)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=12 ;


ALTER TABLE osc_products_options MODIFY COLUMN products_options_name varchar(32) NOT NULL;

ALTER TABLE osc_products_options_values MODIFY COLUMN products_options_values_name varchar(64) NOT NULL;

ALTER TABLE osc_reviews MODIFY COLUMN customers_name varchar(64) NOT NULL;

CREATE TABLE IF NOT EXISTS osc_seo_cache (
  cache_id varchar(32) NOT NULL,
  cache_language_id tinyint(1) NOT NULL default '0',
  cache_name varchar(255) NOT NULL,
  cache_data mediumtext NOT NULL,
  cache_global tinyint(1) NOT NULL default '1',
  cache_gzip tinyint(1) NOT NULL default '1',
  cache_method varchar(20) NOT NULL default 'RETURN',
  cache_date datetime NOT NULL default '1000-01-01 00:00:00',
  cache_expires datetime NOT NULL default '1000-01-01 00:00:00',
  PRIMARY KEY  (cache_id,cache_language_id),
  KEY cache_id (cache_id),
  KEY cache_language_id (cache_language_id),
  KEY cache_global (cache_global)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

ALTER TABLE osc_sessions MODIFY COLUMN sesskey varchar(32) NOT NULL;

ALTER TABLE osc_tax_class MODIFY COLUMN tax_class_title varchar(32) NOT NULL;
ALTER TABLE osc_tax_class MODIFY COLUMN tax_class_description varchar(255) NOT NULL;

ALTER TABLE osc_tax_rates MODIFY COLUMN tax_description varchar(255) NOT NULL;


ALTER TABLE osc_whos_online MODIFY COLUMN full_name varchar(64) NOT NULL;
ALTER TABLE osc_whos_online MODIFY COLUMN session_id varchar(128) NOT NULL;
ALTER TABLE osc_whos_online MODIFY COLUMN ip_address varchar(15) NOT NULL;
ALTER TABLE osc_whos_online MODIFY COLUMN time_entry varchar(14) NOT NULL;
ALTER TABLE osc_whos_online MODIFY COLUMN time_last_click varchar(14) NOT NULL;
ALTER TABLE osc_whos_online MODIFY COLUMN last_page_url varchar(255) NOT NULL;

ALTER TABLE osc_zones MODIFY COLUMN zone_code varchar(32) NOT NULL;
ALTER TABLE osc_zones MODIFY COLUMN zone_name varchar(32) NOT NULL;



UPDATE osc_configuration SET configuration_value='' WHERE configuration_key='MODULE_SHIPPING_INSTALLED';
UPDATE osc_configuration SET configuration_value='' WHERE configuration_key='MODULE_PAYMENT_INSTALLED';
UPDATE osc_configuration SET configuration_value='' WHERE configuration_key='MODULE_ORDER_TOTAL_INSTALLED';

insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('TEMPLATE_NAME_S', 'TEMPLATE_NAME', 'genericLight', 'TEMPLATE_NAME_L', '0', '0', NOW(), NOW(), NULL, NULL);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('Order completed', 'DEFAULT_ORDERS_STATUS_COMPLETED', '3', 'definir le status final d\'une commande livre', '0', '0', NULL, NOW(), NULL, NULL,2);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function, configuration_type) values ('Order annulate', 'DEFAULT_ORDERS_STATUS_ANNULATE', '4', 'definir le status d\'une commande annule', '0', '0', NULL, NOW(), NULL, NULL,2);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('DEFAULT_CURRENCY_S', 'DEFAULT_CURRENCY', 'EUR', 'DEFAULT_CURRENCY_L', '0', '0', NULL, NOW(), NULL, NULL);
insert into osc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values ('DEFAULT_LANGUAGE_S', 'DEFAULT_LANGUAGE', 'fr', 'DEFAULT_LANGUAGE_L', '0', '1', NULL, NOW(), NULL, NULL);



insert into osc_admin (admin_id, admin_groups_id, admin_firstname, admin_lastname, admin_email_address, admin_password, admin_created, admin_modified, admin_logdate, admin_lognum) values ('1', '1', 'AdminFirstname', 'AdminLastname', 'admin@localhost', '351683ea4e19efe34874b501fdbf9792:9b', NOW(), '1000-01-01 00:00:00', NOW(), '0');
insert into osc_admin_groups (admin_groups_id, admin_groups_name) values ('1', 'OSC_ADMIN_GROUPS_ADMIN');
insert into osc_admin_groups (admin_groups_id, admin_groups_name) values ('2', 'OSC_ADMIN_GROUPS_BUYER');


ALTER TABLE osc_categories ADD sortchids_products VARCHAR( 50 ) NOT NULL;
ALTER TABLE osc_categories ADD sortchids_content VARCHAR( 50 ) NOT NULL;