#+###################################-+
#|                  osCSS Open Source E-commerce                         |
#+###################################-+
#| Copyright (c) 2005-2011 The osCSS developers                          |
#|                                                                       |
#| http://www.oscss.org                                                  |
#| http://www.oscim.net                                                  |
#| Portions Copyright (c) 2003 osCommerce                                |
#+###################################-+
#| This source file is subject to version 2.0 of the GPL license,        |
#| available at the following url:                                       |
#| http://www.oscss.org/license/2_0.txt.                                 |
#+###################################-+

# NOTE: * Please make any modifications to this file by hand!
#       * DO NOT use a mysqldump created file for new changes!
#       * Please take note of the table structure, and use this
#         structure as a standard for future modifications!
#       * Any tables you add here should be added in admin/backup.php
#         and in catalog/install/includes/functions/database.php
#       * Comments should be like these, full line comments.
#         (don't use inline comments)

SET storage_engine=MyISAM;

drop table if exists osc_address_book;
CREATE TABLE osc_address_book (
  address_book_id int(11) NOT NULL auto_increment,
  customers_id int(11) NOT NULL default '0',
  entry_gender char(1) NOT NULL,
  entry_company varchar(32) default NULL,
  entry_company_tax_id varchar(32) default NULL,
  entry_firstname varchar(32) NOT NULL,
  entry_lastname varchar(32) NOT NULL,
  entry_street_address varchar(64) NOT NULL,
  entry_suburb varchar(32) default NULL,
  entry_postcode varchar(10) NOT NULL,
  entry_city varchar(32) NOT NULL,
  entry_state varchar(32) default NULL,
  entry_country_id int(11) NOT NULL default '0',
  entry_zone_id int(11) NOT NULL default '0',
  PRIMARY KEY  (address_book_id),
  KEY idx_address_book_customers_id (customers_id)
) DEFAULT CHARSET=utf8 ;

drop table if exists osc_address_format;
CREATE TABLE osc_address_format (
  address_format_id int(11) NOT NULL auto_increment,
  address_format varchar(128) NOT NULL default '',
  address_summary varchar(48) NOT NULL default '',
  PRIMARY KEY  (address_format_id)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS osc_admin;
CREATE TABLE osc_admin (
  admin_id int(11) not null auto_increment,
  admin_groups_id int(11) ,
  admin_firstname varchar(32) not null ,
  admin_lastname varchar(32) ,
  admin_email_address varchar(96) not null ,
  admin_password varchar(40) not null ,
  admin_created datetime ,
  admin_modified datetime default '1000-01-01 00:00:00' not null ,
  admin_logdate datetime ,
  admin_lognum int(11) default '0' not null ,
  url_openid varchar(150) null,
  PRIMARY KEY (admin_id),
  UNIQUE admin_email_address (admin_email_address)
) DEFAULT CHARSET=utf8;

drop table if exists osc_admin_files;
CREATE TABLE osc_admin_files (
  admin_files_id int(11) NOT NULL auto_increment,
  admin_files_name varchar(128) NOT NULL COMMENT 'fichier, avec get',
  admin_files_is_boxes tinyint(1) NOT NULL default '0' COMMENT '1 si est une boîte',
  admin_files_to_boxes tinyint(1) NOT NULL default '0' COMMENT 'precise le num de la boîte parent',
  admin_groups_id set('1','2','3','4','5') NOT NULL default '1',
  PRIMARY KEY  (admin_files_id),
  UNIQUE KEY admin_files_name (admin_files_name,admin_files_is_boxes,admin_files_to_boxes)
) DEFAULT CHARSET=utf8;


drop table if exists osc_admin_groups;
create table osc_admin_groups (
  admin_groups_id int(11) not null auto_increment,
  admin_groups_name varchar(64) ,
  PRIMARY KEY (admin_groups_id),
  UNIQUE admin_groups_name (admin_groups_name)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS osc_admin_notification (
  notif_id int(11) NOT NULL auto_increment,
  notif_type varchar(10) NOT NULL COMMENT 'user/group',
  user_id int(11) NOT NULL,
  notif_key varchar(100) NOT NULL,
  notif_data varchar(250) NOT NULL,
  notif_text text NOT NULL,
  notif_date datetime default '1000-01-01 00:00:00'  NOT NULL,
  PRIMARY KEY  (notif_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_categories;
create table osc_categories (
  categories_id int(11) not null auto_increment,
  categories_image varchar(64) ,
  parent_id int(11) default '0' not null ,
  sort_order int(3) ,
  date_added datetime default '1000-01-01 00:00:00'  null ,
  last_modified datetime default '1000-01-01 00:00:00'  null ,
  categories_status tinyint(1) NOT NULL default '0',
  categories_hidden tinyint(1) NOT NULL default '0',
  sortchids_products varchar( 150 ),
  sortchids_content varchar( 150 ),
  PRIMARY KEY (categories_id),
  KEY idx_categories_parent_id (parent_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_categories_description;
create table osc_categories_description (
  categories_id int(11) default '0' not null ,
  language_id int(3) default '1' not null ,
  categories_name varchar(64) not null ,
  categories_description longtext ,
  categories_head_keywords_tag longtext ,
  PRIMARY KEY (categories_id, language_id),
  KEY idx_categories_name (categories_name)
) DEFAULT CHARSET=utf8;

drop table if exists osc_categories_extra;
CREATE TABLE IF NOT EXISTS osc_categories_extra (
  categories_id int(11) NOT NULL,
  cat_key varchar(150) NOT NULL,
  cat_value varchar(250) NOT NULL,
  UNIQUE KEY categories_id (categories_id,cat_key)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

drop table if exists osc_cip;
create table osc_cip (
  cip_id int(11) NOT NULL auto_increment,
  cip_folder_name varchar(255) NOT NULL,
  cip_installed int(1) NOT NULL default '0',
  cip_ident varchar(255) NOT NULL,
  cip_version varchar(255) NOT NULL,
  PRIMARY KEY  (cip_id)
) DEFAULT CHARSET=utf8 ;

drop table if exists osc_cip_depend;
create table osc_cip_depend (
  cip_ident varchar(255) NOT NULL,
  cip_ident_req varchar(255) NOT NULL,
  cip_req_type int(2) NOT NULL,
  PRIMARY KEY  (cip_ident(100),cip_ident_req(100),cip_req_type)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS osc_checknotif (
  chknotif_id int(11) NOT NULL auto_increment,
  chknotif_key varchar(100) NOT NULL,
  chknotif_uniq int(1) NOT NULL COMMENT 'user=0/grp=1',
  chknotif_user int(11) NOT NULL COMMENT 'if chknotif_uniq this = grp_id',
  chknotif_status int(1) NOT NULL,
  chknotif_method varchar(15) NOT NULL default 'email',
  PRIMARY KEY  (chknotif_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_configuration;
create table osc_configuration (
  configuration_id int(11) not null auto_increment,
  configuration_title varchar(64) not null ,
  configuration_key varchar(64) not null ,
  configuration_value varchar(255) not null ,
  configuration_description varchar(255) not null ,
  configuration_group_id int(11) default '0' not null ,
  sort_order int(5) ,
  last_modified datetime default '1000-01-01 00:00:00' null ,
  date_added datetime default '1000-01-01 00:00:00' not null ,
  use_function varchar(255) ,
  set_function varchar(255) ,
  configuration_type tinyint (1) default '2' not null,
  PRIMARY KEY (configuration_id) ,
  UNIQUE configuration_key (configuration_key)
) DEFAULT CHARSET=utf8;

drop table if exists osc_configuration_group;
CREATE TABLE osc_configuration_group (
  configuration_group_id int(11) NOT NULL auto_increment,
  configuration_group_title varchar(64) NOT NULL,
  configuration_group_description varchar(1) NULL,
  sort_order int(5) default NULL,
  visible int(1) default '1',
  configuration_group_parentid tinyint(1) NOT NULL,
  configuration_group_group_id varchar(64) NOT NULL,
  configuration_group_key varchar(64) not null ,
  PRIMARY KEY  (configuration_group_id)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS osc_configuration_text (
  cfgtxt_id tinyint(3) unsigned NOT NULL DEFAULT '0',
  cfgtxt_key varchar(100) NOT NULL,
  language_id int(3) unsigned NOT NULL DEFAULT '1',
  cfgtxt_title text NOT NULL,
  cfgtxt_text text,
  PRIMARY KEY (cfgtxt_id,cfgtxt_key,language_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_content;
create table osc_content (
  content_id int(10) unsigned not null auto_increment,
  content_name varchar(50) not null ,
  date_added datetime default '1000-01-01 00:00:00' null ,
  last_modified datetime default '1000-01-01 00:00:00' null ,
  content_status tinyint(1) default '0' not null ,
  content_hidden tinyint(1) default '0' not null ,
  sort_order varchar(2) default '0' not null ,
  PRIMARY KEY (content_id),
  KEY content_name (content_name)
) DEFAULT CHARSET=utf8;

drop table if exists osc_content_to_categories;
CREATE TABLE osc_content_to_categories (
content_id INT( 10 ) NOT NULL ,
categories_id INT( 11 ) NOT NULL ,
PRIMARY KEY ( content_id , categories_id )
) DEFAULT CHARSET=utf8;

drop table if exists osc_content_description;
create table osc_content_description (
  content_id int(10) unsigned default '0' not null ,
  content_title varchar(128) not null ,
  content_text text not null ,
  language_id int(3) default '1' not null
) DEFAULT CHARSET=utf8;


drop table if exists osc_countries;
create table osc_countries (
  countries_id int(11) not null auto_increment,
  countries_name varchar(64) not null ,
  countries_localname varchar(64) not null ,
  countries_iso_code_2 char(2) not null ,
  countries_iso_code_3 char(3) not null ,
  address_format_id int(11) default '0' not null ,
  country_visible int(1) default '1' not null ,
  PRIMARY KEY (countries_id),
  KEY IDX_COUNTRIES_NAME (countries_name)
) DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS osc_cronjob (
  id tinyint(5) NOT NULL AUTO_INCREMENT,
  scriptpath varchar(150) NOT NULL,
  name varchar(100) NOT NULL,
  time_interval varchar(5) NOT NULL,
  fire_time datetime NOT NULL,
  time_last_fired datetime null,
  run_only_once tinyint(1) NOT NULL,
  status tinyint(1) NOT NULL,
  extra text,
  PRIMARY KEY (id)
)  DEFAULT CHARSET=utf8  ;


drop table if exists osc_currencies;
create table osc_currencies (
  currencies_id int(11) not null auto_increment,
  title varchar(32) not null ,
  code char(3) not null ,
  symbol_left varchar(12) ,
  symbol_right varchar(12) ,
  decimal_point char(1) ,
  thousands_point char(1) ,
  decimal_places char(1) ,
  value float(13,8) ,
  last_updated datetime ,
  PRIMARY KEY (currencies_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_customers;
CREATE TABLE osc_customers (
  customers_id int(11) NOT NULL auto_increment,
  customers_gender char(1) NOT NULL,
  customers_firstname varchar(32) NOT NULL,
  customers_lastname varchar(32) NOT NULL,
  customers_dob date NOT NULL default '1000-01-01',
  customers_email_address varchar(96) NOT NULL,
  customers_default_address_id int(11) default NULL,
  customers_telephone varchar(32) NOT NULL,
  customers_fax varchar(32) default NULL,
  customers_password varchar(40) NOT NULL,
  customers_newsletter char(1) default NULL,
  customers_group_id smallint(5) unsigned NOT NULL default '0',
  customers_group_ra enum('0','1') NOT NULL,
  customers_payment_allowed varchar(255) NOT NULL default '',
  customers_shipment_allowed varchar(255) NOT NULL default '',
  customers_order_total_allowed varchar(255) NOT NULL default '',
  customers_specific_taxes_exempt varchar(255) NOT NULL default '',
  customers_discount decimal(5,2) default '0.00',
  customers_shopping_points int(10) NOT NULL default '0',
  customers_language int(10) NOT NULL DEFAULT '1',
  customers_status int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY  (customers_id)
) DEFAULT CHARSET=utf8 ;

DROP TABLE IF EXISTS osc_customers_groups;
CREATE TABLE osc_customers_groups (
 customers_group_id smallint UNSIGNED NOT NULL,
 customers_group_name varchar(32) NOT NULL default '',
 customers_group_show_tax enum('1','0') NOT NULL,
 customers_group_tax_exempt enum('0','1') NOT NULL,
 group_payment_allowed varchar(255) NOT NULL default '',
 group_shipment_allowed varchar(255) NOT NULL default '',
 group_order_total_allowed varchar(255) NOT NULL default '',
 group_specific_taxes_exempt varchar(255) NOT NULL default '',
 group_discount decimal(5,2) default '0.00',
 PRIMARY KEY (customers_group_id)
 ) DEFAULT CHARSET=utf8;

drop table if exists osc_customers_basket;
create table osc_customers_basket (
  customers_basket_id int(11) not null auto_increment,
  customers_id int(11) default '0' not null ,
  products_id tinytext not null ,
  customers_basket_quantity int(2) default '0' not null ,
  final_price decimal(15,6) ,
  customers_basket_date_added varchar(8) ,
  PRIMARY KEY (customers_basket_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_customers_basket_attributes;
create table osc_customers_basket_attributes (
  customers_basket_attributes_id int(11) not null auto_increment,
  customers_id int(11) default '0' not null ,
  products_id tinytext not null ,
  products_options_id int(11) default '0' not null ,
  products_options_value_id int(11) default '0' not null ,
  products_options_value_text text null,
  PRIMARY KEY (customers_basket_attributes_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_customers_to_extra_fields;
CREATE TABLE osc_customers_to_extra_fields (
  customers_id int(11) NOT NULL default '0',
  fields_id int(11) NOT NULL default '0',
  value text,
  PRIMARY KEY (customers_id,fields_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_customers_info;
CREATE TABLE osc_customers_info (
  customers_info_id int(11) NOT NULL default '0',
  customers_info_date_of_last_logon datetime default NULL,
  customers_info_number_of_logons int(5) default NULL,
  customers_info_date_account_created datetime default NULL,
  customers_info_date_account_last_modified datetime default NULL,
  global_product_notifications int(1) default NULL,
  PRIMARY KEY  (customers_info_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_extra_field_labels;
CREATE TABLE osc_extra_field_labels (
  epf_id int(11) NOT NULL,
  languages_id int(11) NOT NULL,
  epf_label varchar(64) default NULL,
  epf_active_for_language tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (epf_id,languages_id)
) DEFAULT CHARSET=utf8;


drop table if exists osc_extra_field_values;
CREATE TABLE osc_extra_field_values (
  value_id int(10) unsigned NOT NULL auto_increment,
  epf_id int(11) NOT NULL,
  languages_id int(11) NOT NULL,
  parent_id int(10) unsigned NOT NULL default '0',
  sort_order int(11) NOT NULL default '0',
  epf_value varchar(64) default NULL,
  PRIMARY KEY  (value_id),
  KEY IDX_EPF (epf_id,languages_id)
) DEFAULT CHARSET=utf8 ;

drop table if exists osc_extra_fields;
CREATE TABLE osc_extra_fields (
  fields_id int(11) NOT NULL auto_increment,
  fields_input_type int(11) NOT NULL default '0',
  fields_input_value text NOT NULL,
  fields_status tinyint(2) NOT NULL default '0',
  fields_required_status tinyint(2) NOT NULL default '0',
  fields_size int(5) NOT NULL default '0',
  fields_required_email tinyint(2) NOT NULL default '0',
  fields_key varchar(100) NOT NULL COMMENT 'key de config pour plus de souplesse',
  fields_admin int(1) NOT NULL COMMENT 'perament(0) dispo uniquement admin (1) permanent hidden(2)',
  fields_special_mod varchar(100) NOT NULL COMMENT 'flag module proprietaire',
  fields_group_class varchar(100) NOT NULL,
  PRIMARY KEY  (fields_id)
) DEFAULT CHARSET=utf8 ;

drop table if exists osc_extra_fields_info;
CREATE TABLE osc_extra_fields_info (
  fields_id int(11) NOT NULL default '0',
  languages_id int(11) NOT NULL default '0',
  fields_name varchar(32) NOT NULL default '',
  PRIMARY KEY (fields_id,languages_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_full_tag;
CREATE TABLE osc_full_tag (
  tag_id int(11) NOT NULL auto_increment,
  page_type tinytext NOT NULL,
  page_id varchar(30) default NULL,
  PRIMARY KEY  (tag_id)
) DEFAULT CHARSET=utf8  ;

drop table if exists osc_full_tag_description;
CREATE TABLE osc_full_tag_description (
  tag_id int(11) NOT NULL default '0',
  language_id int(3) NOT NULL default '1',
  head_title_tag varchar(80) default NULL,
  head_desc_tag longtext,
  head_keywords_tag longtext,
  PRIMARY KEY  (tag_id, language_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_geo_zones;
create table osc_geo_zones (
  geo_zone_id int(11) not null auto_increment,
  geo_zone_type TINYINT(11) not null default '1',
  geo_zone_name varchar(32) not null ,
  geo_zone_description varchar(255) not null ,
  last_modified datetime ,
  date_added datetime default '1000-01-01 00:00:00' not null ,
  PRIMARY KEY (geo_zone_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_holding_orders;
CREATE TABLE osc_holding_orders (
  orders_id int(11) NOT NULL auto_increment,
  orders_prefix varchar(32) default NULL,
  customers_id int(11) NOT NULL default '0',
  customers_name varchar(64) NOT NULL,
  customers_company varchar(32) default NULL,
  customers_street_address varchar(64) NOT NULL,
  customers_suburb varchar(32) default NULL,
  customers_city varchar(32) NOT NULL,
  customers_postcode varchar(10) NOT NULL,
  customers_state varchar(32) default NULL,
  customers_country varchar(32) NOT NULL,
  customers_telephone varchar(32) NOT NULL,
  customers_email_address varchar(96) NOT NULL,
  customers_address_format_id int(5) NOT NULL default '0',
  delivery_name varchar(64) NOT NULL,
  delivery_company varchar(32) default NULL,
  delivery_street_address varchar(64) NOT NULL,
  delivery_suburb varchar(32) default NULL,
  delivery_city varchar(32) NOT NULL,
  delivery_postcode varchar(10) NOT NULL,
  delivery_state varchar(32) default NULL,
  delivery_country varchar(32) NOT NULL,
  delivery_address_format_id int(5) NOT NULL default '0',
  billing_name varchar(64) NOT NULL,
  billing_company varchar(32) default NULL,
  billing_street_address varchar(64) NOT NULL,
  billing_suburb varchar(32) default NULL,
  billing_city varchar(32) NOT NULL,
  billing_postcode varchar(10) NOT NULL,
  billing_state varchar(32) default NULL,
  billing_country varchar(32) NOT NULL,
  billing_address_format_id int(5) NOT NULL default '0',
  payment_method varchar(32) NOT NULL,
  cc_type varchar(20) default NULL,
  cc_owner varchar(64) default NULL,
  cc_number varchar(32) default NULL,
  cc_expires varchar(4) default NULL,
  last_modified datetime default NULL,
  date_purchased datetime default NULL,
  orders_status int(5) NOT NULL default '1',
  orders_date_finished datetime default NULL,
  currency char(3) default NULL,
  currency_value decimal(14,6) default NULL,
  ip_address varchar(50) NOT NULL,
  total_weight varchar(5) default NULL,
  PRIMARY KEY  (orders_id)
) DEFAULT CHARSET=utf8  ;

drop table if exists osc_holding_orders_products;
create table osc_holding_orders_products (
  orders_products_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  products_id int(11) default '0' not null ,
  products_model varchar(12) ,
  products_name varchar(64) not null ,
  products_price decimal(15,4) default '0.0000' not null ,
  final_price decimal(15,4) default '0.0000' not null ,
  products_tax decimal(7,4) default '0.0000' not null ,
  products_quantity int(2) default '0' not null ,
  products_stock_attributes varchar(255) default NULL,
  products_returned tinyint(2) unsigned default '0' ,
  products_exchanged tinyint(2) default '0' not null ,
  products_exchanged_id int(11) default '0' not null ,
  PRIMARY KEY (orders_products_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_holding_orders_products_attributes;
create table osc_holding_orders_products_attributes (
  orders_products_attributes_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  orders_products_id int(11) default '0' not null ,
  products_options varchar(32) not null ,
  products_options_values varchar(32) not null ,
  options_values_price decimal(15,4) default '0.0000' not null ,
  price_prefix char(1) not null ,
  PRIMARY KEY (orders_products_attributes_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_holding_orders_products_download;
create table osc_holding_orders_products_download (
  orders_products_download_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  orders_products_id int(11) default '0' not null ,
  orders_products_filename varchar(255) not null ,
  download_maxdays int(2) default '0' not null ,
  download_count int(2) default '0' not null ,
  PRIMARY KEY (orders_products_download_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_holding_orders_status_history;
create table osc_holding_orders_status_history (
  orders_status_history_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  orders_status_id int(5) default '0' not null ,
  date_added datetime default '1000-01-01 00:00:00' not null ,
  customer_notified int(1) default '0' ,
  comments text ,
  PRIMARY KEY (orders_status_history_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_holding_orders_total;
create table osc_holding_orders_total (
  orders_total_id int(10) unsigned not null auto_increment,
  orders_id int(11) default '0' not null ,
  title varchar(255) not null ,
  text varchar(255) not null ,
  value decimal(15,4) default '0.0000' not null ,
  class varchar(32) not null ,
  sort_order int(11) default '0' not null ,
  PRIMARY KEY (orders_total_id),
  KEY idx_orders_total_orders_id (orders_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_languages;
create table osc_languages (
  languages_id int(11) not null auto_increment,
  name varchar(32) not null ,
  code char(2) not null ,
  image varchar(64) ,
  directory varchar(32) ,
  sort_order int(3) ,
  core int(1) not null default 2,
  PRIMARY KEY (languages_id),
  KEY IDX_LANGUAGES_NAME (name)
) DEFAULT CHARSET=utf8;

drop table if exists osc_manufacturers;
create table osc_manufacturers (
  manufacturers_id int(11) not null auto_increment,
  manufacturers_name varchar(32) not null ,
  manufacturers_image varchar(64) ,
  date_added datetime ,
  last_modified datetime ,
  PRIMARY KEY (manufacturers_id),
  KEY IDX_MANUFACTURERS_NAME (manufacturers_name)
) DEFAULT CHARSET=utf8;

drop table if exists osc_manufacturers_info;
create table osc_manufacturers_info (
  manufacturers_id int(11) default '0' not null ,
  languages_id int(11) default '0' not null ,
  manufacturers_url varchar(255) not null ,
  url_clicked int(5) default '0' not null ,
  date_last_click datetime ,
  PRIMARY KEY (manufacturers_id, languages_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_navigation_links;
create table osc_navigation_links (
  nav_link_id int(11) NOT NULL auto_increment,
  nav_sort_order int(11) NOT NULL default '1',
  nav_css_id varchar(50) NOT NULL,
  nav_file varchar(200) NOT NULL,
  nav_link_type int(1) NOT NULL default '0',
  customers_status int(1) NOT NULL default '1',
  nav_link_status int(1) NOT NULL default '1',
  parent_id int(3) NOT NULL default '0',
  PRIMARY KEY  (nav_link_id)
) DEFAULT CHARSET=utf8;


drop table if exists osc_navigation_links_description;
create table osc_navigation_links_description (
  nav_link_id int(11) default '0' not null ,
  language_id int(3) default '1' not null ,
  nav_name varchar(50) not null ,
  PRIMARY KEY (nav_link_id, language_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_newsletters;
CREATE TABLE osc_newsletters (
  newsletters_id int(11) NOT NULL auto_increment,
  title varchar(255) NOT NULL,
  content text NOT NULL,
  module varchar(255) NOT NULL,
  date_added datetime NOT NULL default '1000-01-01 00:00:00',
  date_sent datetime default '1000-01-01 00:00:00',
  status int(1) default NULL,
  locked int(1) default '0',
  nbr_send int(11) NOT NULL default '0',
  newsletters_language int(11) NOT NULL default '1',
  modele_id int(1) NOT NULL default '0',
  PRIMARY KEY  (newsletters_id)
) DEFAULT CHARSET=utf8 ;

drop table if exists osc_newsletters_modeles;
CREATE TABLE IF NOT EXISTS osc_newsletters_modeles (
  nmodele_id int(11) NOT NULL AUTO_INCREMENT,
  languages_id int(11) NOT NULL,
  status int(1) NOT NULL,
  date_added datetime NOT NULL,
  last_update datetime NOT NULL,
  title varchar(150) NOT NULL,
  nmodele_content text NOT NULL,
  PRIMARY KEY (nmodele_id)
)  DEFAULT CHARSET=utf8  ;

drop table if exists osc_newsletters_sent;
CREATE TABLE osc_newsletters_sent (
  customers_id int(11) NOT NULL default '0',
  module_type varchar(64) NOT NULL,
  newsletters_id int(11) NOT NULL,
  date_sent datetime NOT NULL,
  date_opened datetime NOT NULL,
  date_click datetime NOT NULL,
  view_online int(1) NOT NULL,
  KEY id_index (customers_id,newsletters_id)
) DEFAULT CHARSET=utf8;


drop table if exists osc_orders;
create table osc_orders (
  orders_id int(11) not null auto_increment,
  orders_prefix varchar(32) null ,
  customers_id int(11) default '0' not null ,
  customers_name varchar(64) not null ,
  customers_company varchar(32) ,
  customers_street_address varchar(64) not null ,
  customers_suburb varchar(32) ,
  customers_city varchar(32) not null ,
  customers_postcode varchar(10) not null ,
  customers_state varchar(32) ,
  customers_country varchar(32) not null ,
  customers_telephone varchar(32) not null ,
  customers_email_address varchar(96) not null ,
  customers_address_format_id int(5) default '0' not null ,
  delivery_name varchar(64) not null ,
  delivery_company varchar(32) ,
  delivery_street_address varchar(64) not null ,
  delivery_suburb varchar(32) ,
  delivery_city varchar(32) not null ,
  delivery_postcode varchar(10) not null ,
  delivery_state varchar(32) ,
  delivery_country varchar(32) not null ,
  delivery_address_format_id int(5) default '0' not null ,
  billing_name varchar(64) not null ,
  billing_company varchar(32) ,
  billing_street_address varchar(64) not null ,
  billing_suburb varchar(32) ,
  billing_city varchar(32) not null ,
  billing_postcode varchar(10) not null ,
  billing_state varchar(32) ,
  billing_country varchar(32) not null ,
  billing_address_format_id int(5) default '0' not null ,
  payment_method varchar(32) not null ,
  cc_type varchar(20) ,
  cc_owner varchar(64) ,
  cc_number varchar(32) ,
  cc_expires varchar(4) ,
  last_modified datetime ,
  date_purchased datetime ,
  orders_status int(5) default '0' not null ,
  orders_date_finished datetime default NULL ,
  currency char(3) ,
  currency_value decimal(14,6) ,
  ip_address varchar(15) not null ,
  total_weight varchar(5) not null default '0' ,
  facture_id int(11) null ,
  holding_origin_id INT( 11 ) NULL ,
  class_payment VARCHAR( 30 ) NULL ,
  class_shipping VARCHAR( 30 ) NULL ,
  PRIMARY KEY (orders_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_orders_products;
create table osc_orders_products (
  orders_products_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  products_id int(11) default '0' not null ,
  products_model varchar(12) ,
  products_name varchar(64) not null ,
  products_price decimal(15,4) default '0.0000' not null ,
  final_price decimal(15,4) default '0.0000' not null ,
  products_tax decimal(7,4) default '0.0000' not null ,
  products_quantity int(2) default '0' not null ,
  products_stock_attributes varchar(255) default NULL,
  products_returned tinyint(2) default '0' null ,
  products_exchanged tinyint(2) default '0' not null ,
  products_exchanged_id int(11) default '0' not null ,
  PRIMARY KEY (orders_products_id)
) DEFAULT CHARSET=utf8;


drop table if exists osc_orders_products_attributes;
create table osc_orders_products_attributes (
  orders_products_attributes_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  orders_products_id int(11) default '0' not null ,
  products_options varchar(32) not null ,
  products_options_values varchar(32) not null ,
  options_values_price decimal(15,4) default '0.0000' not null ,
  price_prefix char(1) not null ,
  PRIMARY KEY (orders_products_attributes_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_orders_products_download;
create table osc_orders_products_download (
  orders_products_download_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  orders_products_id int(11) default '0' not null ,
  orders_products_filename varchar(255) not null ,
  download_maxdays int(2) default '0' not null ,
  download_count int(2) default '0' not null ,
  PRIMARY KEY (orders_products_download_id)
) DEFAULT CHARSET=utf8;



drop table if exists osc_orders_status_history;
create table osc_orders_status_history (
  orders_status_history_id int(11) not null auto_increment,
  orders_id int(11) default '0' not null ,
  orders_status_id int(5) default '0' not null ,
  date_added datetime default '1000-01-01 00:00:00' not null ,
  customer_notified int(1) default '0' ,
  comments text ,
  PRIMARY KEY (orders_status_history_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_orders_total;
create table osc_orders_total (
  orders_total_id int(10) unsigned not null auto_increment,
  orders_id int(11) default '0' not null ,
  title varchar(255) not null ,
  text varchar(255) not null ,
  value decimal(15,4) default '0.0000' not null ,
  class varchar(32) not null ,
  sort_order int(11) default '0' not null ,
  PRIMARY KEY (orders_total_id),
  KEY idx_orders_total_orders_id (orders_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products;
create table osc_products (
  products_id int(11) not null auto_increment,
  products_quantity int(4) default '0' not null ,
  products_model varchar(12) null,
  products_image varchar(128) null,
  products_price decimal(15,6) default '0.000000' not null ,
  products_date_added datetime default '1000-01-01 00:00:00' not null ,
  products_last_modified datetime default '1000-01-01 00:00:00'  null ,
  products_date_available datetime default '1000-01-01 00:00:00'  null ,
  products_weight decimal(5,2) default '0.00' not null ,
  products_status tinyint(1) default '0' not null ,
  products_tax_class_id int(11) default '0' not null ,
  manufacturers_id int(11) null,
  track_stock int(1) default '1'  null,
  products_ordered int(11) default '0' not null ,
  PRIMARY KEY (products_id),
  KEY idx_products_date_added (products_date_added)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS osc_products_groups;
CREATE TABLE osc_products_groups (
  customers_group_id smallint UNSIGNED NOT NULL default '0',
  customers_group_price decimal(15,6) NOT NULL default '0.0000',
  products_id int(11) NOT NULL default '0',
  PRIMARY KEY  (customers_group_id, products_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products_am_attributes_to_templates;
create table osc_products_am_attributes_to_templates (
  template_id int(5) unsigned not null ,
  options_id int(5) unsigned not null ,
  option_values_id int(5) unsigned not null ,
  price_prefix char(1) NOT NULL,
  options_values_price decimal(15,6) NOT NULL,
  products_options_sort_order int(10) unsigned NOT NULL default '0',
  KEY template_id (template_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products_am_templates;
create table osc_products_am_templates (
  template_id int(5) unsigned not null auto_increment,
  template_name varchar(255) not null ,
  PRIMARY KEY (template_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products_attributes;
create table osc_products_attributes (
  products_attributes_id int(11) not null auto_increment,
  products_id int(11) default '0' not null ,
  options_id int(11) default '0' not null ,
  options_values_id int(11) default '0' not null ,
  options_values_price decimal(15,6) default '0.0000' not null ,
  price_prefix char(1) default '+' not null ,
  products_options_sort_order int(5) default '0' not null ,
  products_options_values_url varchar(128)  null ,
  options_values_weight decimal(15,6) default '0.0000' not null ,
  PRIMARY KEY (products_attributes_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products_attributes_download;
create table osc_products_attributes_download (
  products_attributes_id int(11) default '0' not null ,
  products_attributes_filename varchar(255) not null ,
  products_attributes_maxdays int(2) default '0' ,
  products_attributes_maxcount int(2) default '0' ,
  PRIMARY KEY (products_attributes_id)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS osc_products_attributes_groups;
CREATE TABLE osc_products_attributes_groups (
  products_attributes_id int(11) NOT NULL default '0',
  customers_group_id smallint(5) NOT NULL default '0',
  options_values_price decimal(15,6) NOT NULL default '0.0000',
  price_prefix char(1) NOT NULL default '',
  products_id int(11) NOT NULL default '0',
  PRIMARY KEY  (customers_group_id,products_attributes_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products_description;
create table osc_products_description (
  products_id int(11) not null auto_increment,
  language_id int(3) default '1' not null ,
  products_name varchar(64) not null ,
  products_description text ,
  products_chapo varchar(250) default NULL,
  products_url varchar(255)  default NULL,
  products_viewed int(5) default '0' ,
  products_head_title_tag varchar(80) ,
  products_head_desc_tag longtext ,
  products_head_keywords_tag longtext ,
  PRIMARY KEY (products_id, language_id),
  KEY products_name (products_name)
) DEFAULT CHARSET=utf8;


drop table if exists osc_products_options;
create table osc_products_options (
  products_options_id int(11) default '0' not null ,
  language_id int(3) default '1' not null ,
  products_options_name varchar(32) not null ,
  products_options_track_stock tinyint(1) default '0' not null,
  products_options_sort_order int(10) unsigned default '0' not null ,
  products_options_images_enabled int(1) unsigned default '0' not null ,
  products_options_type int( 5 ) default '1' NOT NULL,
  products_options_length smallint( 2 ) DEFAULT '32' NOT NULL  ,
  products_options_comment varchar( 32 ) ,
  products_options_condition int(1) DEFAULT '1' NOT NULL ,
  PRIMARY KEY (products_options_id, language_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products_options_values;
create table osc_products_options_values (
  products_options_values_id int(11) default '0' not null ,
  language_id int(3) default '1' not null ,
  products_options_values_name varchar(64) not null ,
  products_options_values_thumbnail varchar(128)  null ,
  PRIMARY KEY (products_options_values_id, language_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products_options_values_to_products_options;
create table osc_products_options_values_to_products_options (
  products_options_values_to_products_options_id int(11) not null auto_increment,
  products_options_id int(11) default '0' not null ,
  products_options_values_id int(11) default '0' not null ,
  PRIMARY KEY (products_options_values_to_products_options_id)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS osc_products_extra_fields;
CREATE TABLE osc_products_extra_fields (
  epf_id int unsigned NOT NULL auto_increment,
  epf_order int NOT NULL default 0,
  epf_status tinyint(1) NOT NULL default 1,
  epf_uses_value_list tinyint(1) not null default 0,
  epf_advanced_search tinyint(1) not null default 1,
  epf_show_in_listing tinyint(1) not null default 0,
  epf_size tinyint unsigned not null default 64,
  epf_use_as_meta_keyword tinyint(1) not null default 0,
  epf_use_to_restrict_listings tinyint(1) not null default 0,
  epf_show_parent_chain tinyint(1) not null default 0,
  epf_key varchar(40) default NULL COMMENT 'key de config pour plus de souplesse',
  epf_admin int(1) NOT NULL default '1' COMMENT 'dispo uniquement admin',
  epf_special_mod varchar(30) default NULL COMMENT 'flag module proprietaire',
  PRIMARY KEY (epf_id),
  KEY IDX_ORDER (epf_order)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS osc_products_extra_fields_labels;
CREATE TABLE osc_products_extra_fields_labels (
  epf_id int unsigned NOT NULL,
  languages_id int NOT NULL,
  epf_label varchar(64),
  epf_active_for_language tinyint(1) not null default 1,
  epf_label_help varchar(160) default NULL COMMENT 'aide contextuelle',
  PRIMARY KEY (epf_id, languages_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products_extra_fields_values;
create table osc_products_extra_fields_values (
  value_id int unsigned not null auto_increment,
  epf_id int unsigned not null,
  languages_id int not null,
  parent_id int unsigned not null default 0,
  sort_order int not null default 0,
  epf_value varchar(64),
  primary key (value_id),
  key IDX_EPF (epf_id, languages_id)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS osc_products_to_products_extra_fields;
CREATE TABLE osc_products_to_products_extra_fields (
  products_id int(11) NOT NULL default '0',
  products_extra_fields_id int(11) NOT NULL default '0',
  products_extra_fields_value text,
  PRIMARY KEY  (products_id,products_extra_fields_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products_to_categories;
create table osc_products_to_categories (
  products_id int(11) default '0' not null ,
  categories_id int(11) default '0' not null ,
  PRIMARY KEY (products_id, categories_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products_to_vendors;
create table osc_products_to_vendors (
  products_id int(11) default '0' not null ,
  vendors_id int(11) default '0' not null ,
  PRIMARY KEY (products_id, vendors_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_products_virtual;
CREATE TABLE osc_products_virtual (
  productsID int(10) NOT NULL,
  typeID tinyint(3) NOT NULL,
  PRIMARY KEY  (productsID)
) DEFAULT CHARSET=utf8;


drop table if exists osc_products_stock;
create table osc_products_stock (
  products_stock_id int(11) not null auto_increment,
  products_id int(11) default '0' not null ,
  products_stock_attributes varchar(255) not null,
  products_stock_quantity int(11) default '0' not null ,
  PRIMARY KEY (products_stock_id),
  UNIQUE idx_products_stock_attributes (products_id,products_stock_attributes)
) DEFAULT CHARSET=utf8;



drop table if exists osc_scart;
create table osc_scart (
  scartid int(11) NOT NULL auto_increment,
  customers_id int(11) NOT NULL default '0',
  dateadded varchar(8) NOT NULL default '',
  datemodified varchar(8) NOT NULL default '',
  PRIMARY KEY  (scartid)
) DEFAULT CHARSET=utf8;

drop table if exists osc_seo_cache;
create table osc_seo_cache (
  cache_id char(32) not null ,
  cache_language_id int(3) default '1' not null ,
  cache_name varchar(255) not null ,
  cache_data mediumtext not null ,
  cache_global tinyint(1) default '1' not null ,
  cache_gzip tinyint(1) default '1' not null ,
  cache_method varchar(6) default 'RETURN' not null ,
  cache_date datetime default '1000-01-01 00:00:00'  null ,
  cache_expires datetime default '1000-01-01 00:00:00'  null ,
  PRIMARY KEY (cache_id, cache_language_id),
  KEY cache_id (cache_id),
  KEY cache_language_id (cache_language_id),
  KEY cache_global (cache_global)
) DEFAULT CHARSET=utf8;

drop table if exists osc_sessions;
create table osc_sessions (
  sesskey char(32) not null ,
  expiry int(10) unsigned default '0' not null ,
  value text not null ,
  PRIMARY KEY (sesskey)
) DEFAULT CHARSET=utf8;


drop table if exists osc_status;
CREATE TABLE osc_status (
  status_id int(11) NOT NULL default '0',
  status_type varchar(30) NOT NULL default 'orders',
  language_id int(3) NOT NULL default '1',
  status_name varchar(32) NOT NULL,
  status_color varchar(8) NOT NULL,
  PRIMARY KEY  (status_id,status_type,language_id),
  KEY idx_status_name (status_name)
) DEFAULT CHARSET=utf8;

drop table if exists osc_specials;
create table osc_specials (
  specials_id int(11) not null auto_increment,
  products_id int(11) default '0' not null ,
  specials_new_products_price decimal(15,6) default '0.0000' not null ,
  specials_date_added datetime default '1000-01-01 00:00:00'  null ,
  specials_last_modified datetime default '1000-01-01 00:00:00'  null ,
  expires_date datetime default '1000-01-01 00:00:00'  null ,
  date_status_change datetime default '1000-01-01 00:00:00'  null ,
  status int(1) default '1' not null ,
  specials_begin_date datetime ,
  customers_group_id int(11)  default '0' not null,
  PRIMARY KEY (specials_id)
) DEFAULT CHARSET=utf8;


drop table if exists osc_tax_class;
create table osc_tax_class (
  tax_class_id int(11) not null auto_increment,
  tax_class_title varchar(32) not null ,
  tax_class_description varchar(255) not null ,
  last_modified datetime default '1000-01-01 00:00:00'  null ,
  date_added datetime default '1000-01-01 00:00:00' not null ,
  PRIMARY KEY (tax_class_id)
) DEFAULT CHARSET=utf8;

drop table if exists osc_tax_rates;
create table osc_tax_rates (
  tax_rates_id int(11) not null auto_increment,
  tax_zone_id int(11) default '0' not null ,
  tax_class_id int(11) default '0' not null ,
  tax_priority int(5) default '1' ,
  tax_rate decimal(7,4) default '0.0000' not null ,
  tax_description varchar(255) not null ,
  last_modified datetime default '1000-01-01 00:00:00'  null ,
  date_added datetime default '1000-01-01 00:00:00' not null ,
  PRIMARY KEY (tax_rates_id)
) DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS osc_vendors;
CREATE TABLE osc_vendors (
  vendors_id int(11) NOT NULL auto_increment,
  vendors_name varchar(32) NOT NULL,
  vendors_image varchar(64),
  vendors_phone1 VARCHAR(20) DEFAULT NULL,
  vendors_phone2 VARCHAR(20) DEFAULT NULL,
  vendors_fax VARCHAR(20) DEFAULT NULL,
  vendors_email VARCHAR(20) DEFAULT NULL,
  vendors_url VARCHAR(60) DEFAULT NULL,
  vendors_comments VARCHAR(255) DEFAULT NULL,
  date_added datetime NULL,
  last_modified datetime NULL,
  PRIMARY KEY (vendors_id),
  KEY IDX_vendors_NAME (vendors_name)
) DEFAULT CHARSET=utf8;


drop table if exists osc_whos_online;
create table osc_whos_online (
  customer_id int(11) ,
  full_name varchar(64) not null ,
  session_id varchar(128) not null ,
  ip_address varchar(15) not null ,
  time_entry varchar(14) not null ,
  time_last_click varchar(14) not null ,
  last_page_url varchar(255) not null
) DEFAULT CHARSET=utf8;

drop table if exists osc_zones;
create table osc_zones (
  zone_id int(11) not null auto_increment,
  zone_country_id int(11) default '0' not null ,
  zone_code varchar(32) not null ,
  zone_name varchar(32) not null ,
  PRIMARY KEY (zone_id)
) DEFAULT CHARSET=utf8;


COMMIT;

drop table if exists osc_zones_to_geo_zones;
create table osc_zones_to_geo_zones (
  association_id int(11) not null auto_increment,
  zone_country_id int(11) default '0' not null ,
  zone_id int(11) ,
  geo_zone_id int(11) ,
  last_modified datetime default '1000-01-01 00:00:00'  null ,
  date_added datetime default '1000-01-01 00:00:00' not null ,
  PRIMARY KEY (association_id)
) DEFAULT CHARSET=utf8;


drop view if exists view_products;
CREATE VIEW view_products AS
select m.manufacturers_name,p.*,  IF(s.status, s.specials_new_products_price, NULL) as specials_new_products_price, IF(s.status, s.specials_new_products_price, p.products_price) as final_price,  IF(pv.typeID, pv.typeID, 1)  as type from  osc_products p left join osc_manufacturers m on p.manufacturers_id = m.manufacturers_id left join osc_specials s on p.products_id = s.products_id left join osc_products_virtual pv on p.products_id = pv.productsID , osc_products_to_categories p2c , osc_categories c where c.categories_id=p2c.categories_id and c.categories_status='1' and p.products_status = '1' and p.products_id = p2c.products_id;


drop view if exists view_orders_status;
CREATE VIEW view_orders_status AS
  SELECT status_id as orders_status_id, language_id , status_name as orders_status_name, status_color as orders_status_color FROM osc_status WHERE status_type = 'orders';


drop view if exists view_products_virtual_types;
CREATE VIEW view_products_virtual_types AS
  SELECT status_id , language_id , status_name as type, status_color as products_virtual_types_color FROM osc_status WHERE status_type = 'products_virtual_types';




COMMIT;
COMMIT;
COMMIT;