<?php
/**
 *\licence GPL 2005-2010  The osCSS developers - osCSS Open Source E-commerce
 *\portion code Copyright (c) 2002 osCommerce
 *\package osCSS-2 <www http://www.oscss.org>
 *\version 2.1.0
 *\date  18/10/10, 22:44
 *\author oscim <mail aurelien@oscim.fr> <www http://www.oscim.fr>
 *\encode UTF-8
 *\file
 *\brief Page de login
*/
  require('includes/application_top.php');

  $page->init(basename(__FILE__),$language);

  $error = false;
  if (tep_session_is_registered('customer_id')) tep_redirect(tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));
  if (isset($_GET['action']) && ($_GET['action'] == 'process')) {

    $email_address = tep_db_prepare_input($_POST['email_address']);
    $password = tep_db_prepare_input($_POST['password']);


    try{
      if(!isset($_POST['email_address'])) throw new Exception(TEXT_LOGIN_ERROR );
      if(!isset($_POST['password'])) throw new Exception(TEXT_LOGIN_ERROR );

    $cust=customer::getInstance();

    if (!$cust->userTestNotExist($email_address)) throw new Exception(TEXT_LOGIN_ERROR_USER_NOT_EXITS );
      $customers_id=$cust->CheckMailAndPass($password, $email_address);

      if( $customers_id ===false)  throw new Exception(TEXT_LOGIN_ERROR );

      $user=$cust->the_customer($customers_id);

      if($user['customers_status'] ==2) throw new Exception( sprintf(TEXT_LOGIN_ERROR_ACCOUNT_NOT_CONFIRMED, '<br /><a href="'.tep_href_link(FILENAME_CREATE_ACCOUNT,'action=newconfirm').'">'.TEXT_NEW_SENT_CONFIRM.'</a>') );
// 	  $page->messageStack->add('login', sprintf(TEXT_LOGIN_ERROR_ACCOUNT_NOT_CONFIRMED, '<br /><a href="'.tep_href_link(FILENAME_CREATE_ACCOUNT,'action=newconfirm').'">'.TEXT_NEW_SENT_CONFIRM.'</a>') );
      else {

	customer::initSession($user);
      }

      $navigation=navigation_history::getInstance();

      if (sizeof($navigation->snapshot) > 0) {
	$origin_href = tep_href_link($navigation->snapshot['page'], tep_array_to_string($navigation->snapshot['get'], array(tep_session_name())), $navigation->snapshot['mode']);
	$navigation->clear_snapshot();
	tep_redirect($origin_href);
      }
      else
	tep_redirect(tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));


    }
    catch(Exception $e){
      $page->messageStack->add('login', $e->getMessage() );
    }


  }


  $page->post_init();

  /**
   * \remarck
   * Control js validate forms for creat customers
  */
  $page->javascript->add_framework("ext/jquery/jquery.min.js");
  $page->javascript->add_script("ext/jquery/jquery.validate.min.js", array('sort'=>30));
  /**
   * \remarck
   * Control js check form login
  */
  $page->javascript->add_script(DIR_WS_INCLUDES . 'js/login.js.php');
  $page->javascript->add_script(DIR_WS_INCLUDES . 'js/create_account.js.php');

  require($page->path_gabarit());

  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>