<?php
/**
 * Exports Order Shipping Information From Zen Cart in CSV format
 *
 * @package Export Shipping and Order Information
 * @copyright Copyright 2007, Eric Leuenberger http://www.zencartoptimization.com
 * @copyright Portions Copyright 2003-2006 Zen Cart Development Team
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: shipping_export.php, v 1.2.2 07.13.2007 09:17 Eric Leuenberger econcepts@zencartoptimization.com$
 * @CompanyName:joy’t lead
 * @CompanyUrl:http://www.zencart-ec.com/
 * @RewriteTheSecond:ebergDing
 */
 require('includes/application_top.php');

 require(DIR_WS_CLASSES . 'currencies.php');
 $currencies = new currencies();
 
 include(DIR_WS_CLASSES . 'order.php');
 
 if( isset($_POST['download_csv']) ) {
    Header('Content-type: application/csv;');
    Header("Content-disposition: attachment; filename=\"Orders".date('mdy-Hi').".csv\"");

	//iconv('utf-8','gb2312',$row[$key]);
// if date_range is set then gather form vars for SQL processing
if ($_POST['start_date'] != '') {
	  $start_date = $_POST['start_date'] . ' 00:00';
}
if ($_POST['end_date'] != '') {
	  $end_date = $_POST['end_date'] . ' 23:59';
}
//**************************************************************

if ($_POST['filelayout'] == 2) { // 1 Product Per row RADIO

$order_info = "SELECT o.orders_id, customers_email_address, delivery_name, delivery_street_address, delivery_suburb, delivery_city, delivery_postcode, delivery_state, delivery_country, shipping_method, customers_telephone, order_total, products_model, products_name, products_price, final_price, products_quantity, date_purchased, ot.value, orders_products_id, order_tax, o.orders_status, o.payment_method 
FROM (". TABLE_ORDERS ." o LEFT JOIN ". TABLE_ORDERS_PRODUCTS ." op ON o.orders_id = op.orders_id), ". TABLE_ORDERS_TOTAL ." ot
WHERE o.orders_id = ot.orders_id
AND ot.class = 'ot_shipping'";
if ($_POST['dload_include'] != 1) {
$order_info = $order_info . " AND downloaded_ship='no'";
}
if ($_POST['status_target'] == 2) {
	  $order_info = $order_info . " AND o.orders_status = '" . $_POST['order_status'] . "'";
}
if ($_POST['start_date'] != '' && $_POST['end_date'] != '') {
$order_info = $order_info . " AND date_purchased BETWEEN '". $start_date ."' AND '". $end_date ."'";
//$order_info = $order_info . " AND date_purchased >= '". $start_date ."' AND date_purchased <= '". $end_date ."'";
}
$order_info = $order_info . " ORDER BY orders_id ASC";
//echo $order_info;

} else { // Default 1 Order Per row (filelayout1=1)

$order_info = "SELECT o.orders_id, customers_email_address, delivery_name, delivery_street_address, delivery_suburb, delivery_city, delivery_postcode, delivery_state, delivery_country, shipping_method, customers_telephone, order_total, date_purchased, ot.value, comments, order_tax, o.orders_status, o.payment_method 
FROM ". TABLE_ORDERS ." o, " . TABLE_ORDERS_STATUS_HISTORY . " os, " . TABLE_ORDERS_TOTAL . " ot 
WHERE o.orders_id = ot.orders_id 
AND ot.class = 'ot_shipping' 
AND o.orders_id = os.orders_id";
if ($_POST['dload_include'] != 1) {
$order_info = $order_info . " AND downloaded_ship='no'";
}
if ($_POST['status_target'] == 2) {
$order_info = $order_info . " AND o.orders_status = '" . $_POST['order_status'] . "'";
}
if ($_POST['start_date'] != '' && $_POST['end_date'] != '') {
$order_info = $order_info . " AND date_purchased BETWEEN '". $start_date ."' AND '". $end_date ."'";
//$order_info = $order_info . " AND date_purchased >= '". $start_date ."' AND date_purchased <= '". $end_date ."'";
}
$order_info = $order_info . " GROUP BY orders_id ASC";
//echo $order_info;

$max_num_products = "SELECT COUNT( * ) AS max_num_of_products
FROM (". TABLE_ORDERS ." o LEFT JOIN ". TABLE_ORDERS_PRODUCTS ." op ON o.orders_id = op.orders_id), ". TABLE_ORDERS_TOTAL ." ot
WHERE o.orders_id = ot.orders_id
AND ot.class = 'ot_shipping'";
if ($_POST['dload_include'] != 1) {
$max_num_products = $max_num_products . " AND downloaded_ship='no'";
}
if ($_POST['status_target'] == 2) {
$max_num_products = $max_num_products . " AND o.orders_status = '" . $_POST['order_status'] . "'";
}
if ($_POST['start_date'] != '' && $_POST['end_date'] != '') {
$max_num_products = $max_num_products . " AND date_purchased BETWEEN '". $start_date ."' AND '". $end_date ."'";
//$max_num_products = $max_num_products . " AND date_purchased >= '". $start_date ."' AND date_purchased <= '". $end_date ."'";
}
$max_num_products = $max_num_products . " GROUP BY o.orders_id ASC
ORDER BY max_num_of_products DESC
LIMIT 1";
  $max_num_products_result = $db->Execute($max_num_products);
  $max_products = $max_num_products_result->fields['max_num_of_products'];

} // End File layout sql

$order_details = $db->Execute($order_info);

     $str_header = 	"Order ID,Customer Email";
if ($_POST['split_name'] == 1) { //If name split is desired then split it.
	 $str_header = $str_header . ",First Name,Last Name";
} else {
	 $str_header = $str_header . ",Delivery Name";
}
	$str_header = $str_header . ",Payment Method,Delivery Country,Delivery State,Delivery City,Delivery Street,Delivery Post Code";
		if ($_POST['shipmethod'] == 1) { $str_header = $str_header . ",Shipping Method"; };
		if ($_POST['shiptotal'] == 1) { $str_header = $str_header . ",Shipping Total"; };
		if ($_POST['customers_telephone'] == 1) { $str_header = $str_header . ",Customers Telephone"; };
		if ($_POST['order_total'] == 1) { $str_header = $str_header . ",Order Total"; };
		if ($_POST['date_purchased'] == 1) { $str_header = $str_header . ",Order Date"; };
		if ($_POST['order_comments'] == 1) { $str_header = $str_header . ",Order Notes"; };
if ($_POST['product_details'] == 1) { // add to header row
	if ($_POST['filelayout'] == 2) { // 1 Product Per row RADIO
			$str_header = $str_header . ",Product Qty,Products Price,Product Name,Product Model,Product Attributes";
	} else { // File layout is 1 OPR
	/**************the following exports 1 OPR attribs****************/
	  $oID = zen_db_prepare_input($order_details->fields['orders_id']);
	  $oIDME = $order_details->fields['orders_id'];
	  $order = new order($oID);
		for ($i = 0, $n = $max_products; $i < $n; $i++) {
			$str_header = $str_header . ",Product " . $i . " Qty";
			$str_header = $str_header . ",Product " . $i . " Price";
			$str_header = $str_header . ",Product " . $i . " Name";
			$str_header = $str_header . ",Product " . $i . " Model";
			$str_header = $str_header . ",Product " . $i . " Attributes";
	    }
	/*****************************************************************/
	} // End if to determine which header to use
} // end Row header if product details selected

		if ($_POST['order_tax'] == 1) { $str_header = $str_header . ",Order Tax"; };
		if ($_POST['order_subtotal'] == 1) { $str_header = $str_header . ",Order Subtotal"; };
		if ($_POST['order_discount'] == 1) { $str_header = $str_header . ",Order Discount"; };
		if ($_POST['payment_method'] == 1) { $str_header = $str_header . ",Payment Method"; };
		if ($_POST['orders_status'] == 1) { $str_header = $str_header . ",Order Status"; };

	   $str_header = $str_header . "\n";
	   echo $str_header;

while( !$order_details->EOF ) {

       $str_export = "\"" . $order_details->fields['orders_id'] . "\",\"". $order_details->fields['customers_email_address'] . "\"";
		if ($_POST['split_name'] == 1) { 
			$fullname = iconv('utf-8','gb2312',$order_details->fields['delivery_name']);
			  list($first, $middle, $last) = split(' ', $fullname);
			  if ( !$last ) {
			    $last = $middle;
			    unset($middle);
			 }
			$str_export = $str_export . ",\"". $first . "\",\"". $last . "\""; 
		} else {
			$str_export = $str_export . ",\"". $order_details->fields['delivery_name'] . "\""; 
		};

			$str_export = $str_export . ",\"". $order_details->fields['payment_method'] . "\",\"". $order_details->fields['delivery_country'] . "\"" .
			",\"". $order_details->fields['delivery_state'] . "\",\"". $order_details->fields['delivery_city'] . "\"" .
			",\"". $order_details->fields['delivery_street_address'] ."\",\"". $order_details->fields['delivery_postcode'] . "\"" .
			"";
		//,\"". $order_details->fields['delivery_suburb'] . "\"
		
		if ($_POST['shipmethod'] == 1) { $str_export = $str_export . ",\"".  $order_details->fields['shipping_method'] . "\""; };
		if ($_POST['shiptotal'] == 1) { $str_export = $str_export . ",\"". $order_details->fields['value'] . "\""; };
		if ($_POST['customers_telephone'] == 1) { $str_export = $str_export . ",\"". $order_details->fields['customers_telephone'] . "\""; };
		if ($_POST['order_total'] == 1) { $str_export = $str_export .",\"". $order_details->fields['order_total'] . "\""; };
		if ($_POST['date_purchased'] == 1) { $str_export = $str_export .",\"". $order_details->fields['date_purchased'] . "\""; };
		if ($_POST['order_comments'] == 1) { 
			 if ($_POST['filelayout'] == 2) { // 1 Product Per row RADIO
				$orders_comments_query="SELECT *  FROM " . TABLE_ORDERS_STATUS_HISTORY . " WHERE orders_id = " . $order_details->fields['orders_id'] . " GROUP BY orders_id ORDER BY orders_status_history_id ASC";
				$orders_comments = $db->Execute($orders_comments_query);
					$str_safequotes = str_replace('"',"'",$orders_comments->fields['comments']); // replace quotes with single quotes if present
					//$str_safequotes = $str_safequotes . str_replace(","," ",$str_safequotes); // replace commas with blank space if present
					$str_export = $str_export . ",\"". str_replace("\r\n", " ", $str_safequotes) . "\""; // Remove any line breaks in first comment and print to export string
			 } else {
					$str_safequotes = str_replace('"',"'",$order_details->fields['comments']); // replace quotes with single quotes if present
					//$str_safequotes = $str_safequotes . str_replace(","," ",$str_safequotes); // replace commas with blank space if present
					$str_export = $str_export . ",\"". str_replace("\r\n", " ", $str_safequotes) . "\""; // Remove any line breaks in first comment and print to export string
			 }
		}
if ($_POST['product_details'] == 1) { // Order details should be added to the export string.

if ($_POST['filelayout'] == 2) { // 1 PPR RADIO

$str_export = $str_export . ",\"" . $order_details->fields['products_quantity'] . "\"";
$str_export = $str_export . ",\"" . $order_details->fields['final_price'] . "\"";
$str_export = $str_export . ",\"" . $order_details->fields['products_name'] . "\"";
$str_export = $str_export . ",\"" . $order_details->fields['products_model'] . "\",";

$product_attributes_rows="SELECT Count(*) as num_rows
FROM " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . "
WHERE orders_id = " . $order_details->fields['orders_id'] . "
AND orders_products_id = " . $order_details->fields['orders_products_id'] . "";
$attributes_query_rows = $db->Execute($product_attributes_rows);
$num_rows = $attributes_query_rows->fields['num_rows'];

	If ( $num_rows > 0) {
	$product_attributes_query="SELECT *
	FROM " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . "
	WHERE orders_id = " . $order_details->fields['orders_id'] . "
	AND orders_products_id = " . $order_details->fields['orders_products_id'] . "";
	$attributes_query_results = $db->Execute($product_attributes_query);
	$str_export = $str_export . "\"";
		for ($i = 0, $n = $num_rows; $i < $n; $i++) {
		$str_export = $str_export . $attributes_query_results->fields['products_options'] . ': ' . nl2br($attributes_query_results->fields['products_options_values']) . " | ";
		$attributes_query_results->MoveNext();
		}
	$str_export = $str_export . "\"";
}

} else { // 1 OPR default

/**************the following exports 1 OPR w/ attributes) ****************/
  $oID = zen_db_prepare_input($order_details->fields['orders_id']);
  $oIDME = $order_details->fields['orders_id'];
  $order = new order($oID);
    for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
$str_export = $str_export . ",\"" . $order->products[$i]['qty'] . "\"";
$str_export = $str_export . ",\"" . $order->products[$i]['final_price'] . "\"";
$str_export = $str_export . ",\"" . $order->products[$i]['name'] . "\"";
$str_export = $str_export . ",\"" . $order->products[$i]['model'] . "\",";
      if (isset($order->products[$i]['attributes']) && (($k = sizeof($order->products[$i]['attributes'])) > 0)) {
$str_export = $str_export . "\"";
        for ($j = 0; $j < $k; $j++) {
$str_export = $str_export . $order->products[$i]['attributes'][$j]['option'] . ': ' . nl2br($order->products[$i]['attributes'][$j]['value']) . " | ";
        }
$str_export = $str_export . "\"";
      }
    }
/*************************************************************************/
} // End if for determining type of export

} // End if to determine if the order details should be added to the export string.

if ($_POST['order_tax'] == 1) { $str_export = $str_export .",\"". $order_details->fields['order_tax'] . "\""; };
		
if ($_POST['order_subtotal'] == 1) {
		
	$orders_subtotal_query = "SELECT o.orders_id, customers_email_address, delivery_name, delivery_street_address, delivery_suburb, delivery_city, delivery_postcode, delivery_state, delivery_country, shipping_method, customers_telephone, order_total, products_model, products_name, products_price, final_price, products_quantity, date_purchased, ot.value, orders_products_id, order_tax
	FROM (". TABLE_ORDERS ." o LEFT JOIN ". TABLE_ORDERS_PRODUCTS ." op ON o.orders_id = op.orders_id), ". TABLE_ORDERS_TOTAL ." ot
	WHERE o.orders_id = ot.orders_id
	AND ot.class = 'ot_subtotal'
	AND ot.orders_id = " . $order_details->fields['orders_id'] . "";
if ($_POST['dload_include'] != 1) {
$orders_subtotal_query = $orders_subtotal_query . " AND downloaded_ship='no'";
}
if ($_POST['status_target'] == 2) {
$orders_subtotal_query = $orders_subtotal_query . " AND o.orders_status = '" . $_POST['order_status'] . "'";
}
if ($_POST['start_date'] != '' && $_POST['end_date'] != '') {
$orders_subtotal_query = $orders_subtotal_query . " AND date_purchased BETWEEN '". $start_date ."' AND '". $end_date ."'";
//$orders_subtotal_query = $orders_subtotal_query . " AND date_purchased >= '". $start_date ."' AND date_purchased <= '". $end_date ."'";
}
	$orders_subtotal_query = $orders_subtotal_query . " ORDER BY orders_id ASC";

	$orders_subtotal = $db->Execute($orders_subtotal_query);

$recordcount = mysql_query($orders_subtotal_query);
$num_rows = mysql_num_rows($recordcount); 
	//if( !isset($orders_subtotal->fields['o.orders_id']) ) {
	//if (mysql_num_rows($result) > 0) { // if records were found
	//$num_rows = mysql_num_rows($orders_subtotal_query);
	if ( $num_rows > 0) {
		 $str_export = $str_export .",\"". $orders_subtotal->fields['value'] . "\""; //add discount amt to export string
	} else { // add a BLANK field to the export file for "consistancy"
		$str_export = $str_export .",\"\""; // add blank space for filler
	} // end if
		 
		 
}

if ($_POST['order_discount'] == 1) { // if order discount was selected, then run the query to pull the data for adding it to the export string.
// Run a query to pull the Order Discount total if present
	$orders_discount_query = "SELECT o.orders_id, ot.value
	FROM (". TABLE_ORDERS ." o LEFT JOIN ". TABLE_ORDERS_PRODUCTS ." op ON o.orders_id = op.orders_id), ". TABLE_ORDERS_TOTAL ." ot
	WHERE o.orders_id = ot.orders_id
	AND ot.class = 'ot_coupon'
	AND ot.orders_id = " . $order_details->fields['orders_id'] . "";
if ($_POST['dload_include'] != 1) {
$orders_discount_query = $orders_discount_query . " AND downloaded_ship='no'";
}
if ($_POST['status_target'] == 2) {
$orders_discount_query = $orders_discount_query . " AND o.orders_status = '" . $_POST['order_status'] . "'";
}
if ($_POST['start_date'] != '' && $_POST['end_date'] != '') {
$orders_discount_query = $orders_discount_query . " AND date_purchased BETWEEN '". $start_date ."' AND '". $end_date ."'";
//$orders_discount_query = $orders_discount_query . " AND date_purchased >= '". $start_date ."' AND date_purchased <= '". $end_date ."'";
}
	$orders_discount_query = $orders_discount_query . " ORDER BY orders_id ASC";
	
	$orders_discount = $db->Execute($orders_discount_query);

$recordcount = mysql_query($orders_discount_query);
$num_rows = mysql_num_rows($recordcount); 
	if (mysql_num_rows($recordcount) > 0) { // if records were found
		$str_export = $str_export .",\"". $orders_discount->fields['value'] . "\""; //add discount amt to export string
	} else { // add a BLANK field to the export file for "consistancy"
		$str_export = $str_export .",\"\""; // add blank space for filler
	} // end if
} // End if for determining if order discount was selected to export.

//*********Add Payment Method if selected***************/
if ($_POST['payment_method'] == 1) { $str_export = $str_export .",\"". $order_details->fields['payment_method'] . "\""; };
//******************************************************/

if ($_POST['orders_status'] == 1) { // if order status was selected, then run the query to pull the data for adding it to the export string.
// Run a query to pull the Order Status if present
	$orders_status_query = "SELECT orders_status_name 
	FROM (". TABLE_ORDERS_STATUS .")
	WHERE orders_status_id=" . $order_details->fields['orders_status'] . "";
	$orders_status = $db->Execute($orders_status_query);

$recordcount = mysql_query($orders_status_query);
$num_rows = mysql_num_rows($recordcount); 
	if (mysql_num_rows($recordcount) > 0) { // if records were found
	//if ( $num_rows > 0) {
//$num_rows = mysql_num_rows($orders_discount);
	//if ( $num_rows > 0) {
		$str_export = $str_export .",\"". $orders_status->fields['orders_status_name'] . "\""; //add discount amt to export string
	} else { // add a BLANK field to the export file for "consistancy"
		$str_export = $str_export .",\"\""; // add blank space for filler
	} // end if
} // End if for determining if order discount was selected to export.

	   $str_export = $str_export . "\n";
                
	   if(zen_db_prepare_input($_SESSION['language'])!="English")
	   {
	    echo  iconv('utf-8','gb2312', $str_export);
	   }else
	   {
	 		echo $str_export;
	   }
	   
	$order_details->MoveNext();
	
} // End Outer While statement to loop through all non downloaded orders.
	if ($_POST['export_test'] != 1) { //Not testing so update
     $db->execute('UPDATE '. TABLE_ORDERS .' SET downloaded_ship="yes" WHERE downloaded_ship="no"');
	}
   exit;
 }

// build arrays for dropdowns in search menu
    $status_array = array();
    $status_table = array();
    $orders_status = $db->Execute("select orders_status_id, orders_status_name from " . TABLE_ORDERS_STATUS . "
                                   where language_id = '" . (int)$_SESSION['languages_id'] . "'
                                   order by orders_status_id asc");
    while (!$orders_status->EOF) {
      $status_array[] = array('id' => $orders_status->fields['orders_status_id'],
                              'text' => $orders_status->fields['orders_status_name'] . ' [' . $orders_status->fields['orders_status_id'] . ']');
      $status_table[ $orders_status->fields['orders_status_id'] ] = $orders_status->fields['orders_status_name'];
      $orders_status->MoveNext();
    }

 
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
<script language="javascript" src="includes/menu.js"></script>
<script language="javascript" src="includes/general.js"></script>
<link rel="stylesheet" type="text/css" href="includes/javascript/spiffyCal/spiffyCal_v2_1.css">
<script language="javascript" src="includes/javascript/spiffyCal/spiffyCal_v2_1.js"></script>
<script type="text/javascript">
  <!--
  function init()
  {
    cssjsmenu('navbar');
    if (document.getElementById)
    {
      var kill = document.getElementById('hoverJS');
      kill.disabled = true;
    }
  }
  // -->
</script>
<style>
#zentips { color: #000000; }
#zentips H2 {font-size: 14; font-family: Verdana; margin-bottom: 5px; color:#6696B1; border-bottom: 1px solid #93C5E0;}
#zentips p { margin-top: 0px; margin-bottom: 0px; }
</style>
</head>
<body onLoad="init()">
<div id="spiffycalendar" class="text"></div>
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<script language="javascript">
var StartDate = new ctlSpiffyCalendarBox("StartDate", "download_csv", "start_date", "btnDate1","",scBTNMODE_CALBTN);
var EndDate = new ctlSpiffyCalendarBox("EndDate", "download_csv", "end_date", "btnDate2","",scBTNMODE_CALBTN);
</script>



<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
  	 <td width="100%" valign="top">
			<table border="0" width="100%" cellspacing="0" cellpadding="2">
     
	 
	  
	  
	  
	  

	  
	  
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="2">
          <tr>
		  
            <td valign="top">
			
			<table border="0" width="100%">
			
			
			
			
			
			<tr>
			<td valign="top">
				<div class="reportflcnt">
				<div class="reportBox" style="width:100%;">
					<table border="0" width="100%" cellspacing="0" cellpadding="0">
						 <tr class="dataTableHeadingRow">
							 <td class="dataTableHeadingContent" align="center" style="width:10%;" valign="top"><?php echo TEXT_ORDERS_ID_EBERG ?></td>
							 <td class="dataTableHeadingContent" align="center" style="width:10%;" valign="top"><?php echo TEXT_ORDERS_EMAIL_EBERG ?></td>
							 <td class="dataTableHeadingContent" align="center" valign="top"><?php echo TEXT_ORDERS_CUSTOMERNAME_EBERG ?></td>
							 <td class="dataTableHeadingContent" align="center" valign="top"><?php echo TEXT_ORDERS_COMPANY_EBERG ?></td>
							 <td class="dataTableHeadingContent" align="center" valign="top"><?php echo TEXT_ORDERS_Country ?></td>
							 <td class="dataTableHeadingContent" align="center" valign="top"><?php echo TEXT_ORDERS_DELIVERYSUBURB ?></td>
							 <td class="dataTableHeadingContent" align="center" valign="top"><?php echo TEXT_ORDERS_DELIVERYCITY ?></td>
							 <td class="dataTableHeadingContent" align="center" valign="top"><?php echo TEXT_ORDERS_DELIVERYTREET_EBERG ?></td>
							 <td class="dataTableHeadingContent" align="center" valign="top"><?php echo TEXT_ORDERS_POSTCODE ?></td>
							 <td class="dataTableHeadingContent" align="center" valign="top">&nbsp;</td>
						 </tr>
<?php
$query = "SELECT o.orders_id, customers_email_address, delivery_name, delivery_company, delivery_street_address, delivery_suburb, delivery_city, delivery_postcode, delivery_state, delivery_country, shipping_method, customers_telephone, order_total, date_purchased
                            FROM ". TABLE_ORDERS ." o
                            WHERE downloaded_ship='no'
                            ORDER BY orders_id ASC";
							
 $query = strtolower($query);

 $order_pages = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS_REPORTS, $query, $rows);
 $order = $db->execute($query);

 while( !$order->EOF ) {
   list( $order_id, $cust_email, $delivery_name, $delivery_company, $delivery_street, $delivery_suburb, $delivery_city, $delivery_postcode, $delivery_state, $delivery_country, $shipping_method, $customers_telephone, $order_total, $product_model, $product_name, $product_price, $product_qty, $date_purchased, $comments ) = array_values($order->fields);
?>
              <!--<tr class="dataTableRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="window.open('<?php echo zen_href_link(FILENAME_ORDERS, 'page=1&oID=' . $order_id . '&action=edit', 'NONSSL'); ?>')">-->
               
			   		 <tr class="dataTableRow" onMouseOver="rowOverEffect(this)" onMouseOut="rowOutEffect(this)"  style="text-align:center;">
  						<td class="dataTableContent" align="center"><?php echo $order_id; ?>&nbsp;&nbsp;</td>
                		<td class="dataTableContent"><?php echo $cust_email; ?></td>
						<td class="dataTableContent"><?php echo $delivery_name; ?></td>
						<td class="dataTableContent"></td>
						<td class="dataTableContent"><?php echo $delivery_country; ?></td>
						<td class="dataTableContent"><?php echo $delivery_state; ?></td>
						<td class="dataTableContent"><?php echo $delivery_city; ?></td>			
						<td class="dataTableContent"><?php echo $delivery_street; ?></td>
						<td class="dataTableContent"><?php echo $delivery_postcode; ?></td>
						<td class="dataTableContent"><a href="<?php echo zen_href_link(FILENAME_ORDERS, 'page=1&oID=' . $order_id . '&action=edit', 'NONSSL'); ?>"><img src="images/icons/preview.gif" border="0" ALT="Preview Order Details"></a></td>
             	 	</tr>
			  		
					<tr>
			  			<td style="height:2px; width:100%; background-color:#ACC9D9; padding-left:3px; padding-right:3px;" colspan="11"></td>
			 		</tr>
			 
<?php

    $order->MoveNext();
  	
	}
	  if(isset($order_id) ) {
  ?>
  
  
				   <tr>
						<td class="smallText" valign="top" align="left" colspan="5"><?php echo $order_pages->display_count($rows, MAX_DISPLAY_SEARCH_RESULTS_REPORTS, $_GET['page'], Displaying_EBERG.'<b>%d</b> '.TO_EBERG.' <b>%d</b> ('.OF_EBERG.' <b>%d</b> '.Orders_EBERG.')'); ?></td>
						<td class="smallText" align="right" colspan="5"><?php echo $order_pages->display_links($rows, MAX_DISPLAY_SEARCH_RESULTS_REPORTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page']); ?></td>
			  		</tr>
  
  
 <?php 
	}
  if( !isset($order_id) ) {
  ?>
              <tr class="dataTableRow">
                <td class="dataTableContent" align="center" colspan="30"><b>No new orders were found!</b></td>
              </tr>
  <?php } ?>
<?php
  $SUBMIT_BUTTON = "<input style=\"font-weight: bold\" name=\"download_csv\" type=\"submit\" value=\"".Export_to_Excel_Spreadsheet."\" />" ;
?>
						  </div>
		  			</div>
				</table>
           	 </td>
          </tr>
        </table>
		
			
			
			
			
			</td>
			
		
					 

			
            <td width="25%" valign="top">
			
<table cellspacing="0" cellpadding="0" border="0" width="100%" class="rbgleft">
  <tbody><tr>
    <td class="rbgleft_t"></td>
    <td>
			
			<table border="0" width="100%" cellspacing="0" cellpadding="0">
			  <tr class="infoBoxHeading">
			  	
			    <td class="infoBoxHeading"><b><?php echo HEADING_ADDITIONAL_FIELDS_TITLE; ?></b></td>
                <td class="rbgright"></td>
			  </tr>
			</table>
			<table border="0" width="100%" cellspacing="0" cellpadding="2">
			  <tr>
			    <td class="infoBoxContent"><?php echo TEXT_RUNIN_TEST; ?><br></td>
			  </tr>
			  <tr>
			    <td class="infoBoxContent">
				<form name="download_csv" method="post">
			                <?php echo zen_draw_checkbox_field('export_test', '1', $export_test_checked);?>&nbsp;<?php echo TEXT_RUNIN_TEST_FIELD; ?><br />
			                <?php echo zen_draw_checkbox_field('split_name', '1', $export_split_checked);?>&nbsp;<?php echo TEXT_SPLIT_NAME_FIELD; ?><br />
            				<!--Order Status: <?php echo zen_draw_pull_down_menu('date_status', $status_array, $_POST['date_status'], 'id="date_status"'); ?>-->
<hr />
<table border="0" cellspacing="0" cellpadding="2">
          <tr>
            <td><strong><?php echo Order_Status_Options; ?></strong></td>
          </tr>
          <tr>
            <td>
              <input type="radio" name="status_target" value="1" checked><?php echo Any_Order_Status; ?><br />
              <input type="radio" name="status_target" value="2"><?php echo Assigned_Order_Status; ?> 
            </td>
          </tr>
          <tr>
            <td><?php echo zen_draw_pull_down_menu('order_status', $status_array, $_POST['order_status'], 'id="order_status"'); ?></td>
          </tr>
        </table>
							<hr>
          <table border="0" cellspacing="0" cellpadding="2" width="100%" id="tbl_date_custom">
            <tr>
              <td colspan="2"><strong><?php echo HEADING_PREVIOUS_EXPORTS_TITLE; ?></strong><br>
			  <?php echo TEXT_PREVIOUS_EXPORTS; ?>
			  <br></td>
            </tr>
            <tr>
              <td><?php echo zen_draw_checkbox_field('dload_include', '1', $dload_include_checked);?>&nbsp;<?php echo TEXT_PREVIOUS_EXPORTS_FIELD; ?><br /><br /></td>
            </tr>
			</table>
							<hr>
							<?php echo TEXT_FILE_LAYOUT; ?><br />
							 <?php echo zen_draw_radio_field('filelayout', '1')?>&nbsp;<?php echo TEXT_FILE_LAYOUT_OPR_FIELD; ?><br />
							 <?php echo zen_draw_radio_field('filelayout', '2')?>&nbsp;<?php echo TEXT_FILE_LAYOUT_PPR_FIELD; ?><br />
							<hr>
							<?php echo TEXT_ADDITIONAL_FIELDS; ?><br />
			                <?php echo zen_draw_checkbox_field('shipmethod', '1', $shipping_method_checked);?>&nbsp;<?php echo TEXT_SHIPPING_METHOD_FIELD; ?><br />
			                <?php echo zen_draw_checkbox_field('shiptotal', '1', $shipping_total_checked);?>&nbsp;<?php echo TEXT_SHIPPING_TOTAL_FIELD; ?><br />
			                <?php echo zen_draw_checkbox_field('customers_telephone', '1', $phone_number_checked);?>&nbsp;<?php echo TEXT_PHONE_NUMBER_FIELD; ?><br />
			                <?php echo zen_draw_checkbox_field('order_total', '1', $order_total_checked);?>&nbsp;<?php echo TEXT_ORDER_TOTAL_FIELD; ?><br />
			                <?php echo zen_draw_checkbox_field('date_purchased', '1', $date_purchased_checked);?>&nbsp;<?php echo TEXT_ORDER_DATE_FIELD; ?><br />
			                <?php echo zen_draw_checkbox_field('order_comments', '1', $order_comments_checked);?>&nbsp;<?php echo TEXT_ORDER_COMMENTS_FIELD; ?><br />
							<hr>
			                <?php echo zen_draw_checkbox_field('product_details', '1', $prod_details_checked);?>&nbsp;<?php echo TEXT_PRODUCT_DETAILS_FIELD; ?> <span style="color: #ff0000"><strong>*</strong></span><br />

				<hr />
			                <?php echo zen_draw_checkbox_field('order_tax', '1', $order_tax_checked);?>&nbsp;<?php echo TEXT_TAX_AMOUNT_FIELD; ?><br />
			                <?php echo zen_draw_checkbox_field('order_subtotal', '1', $order_subtotal_checked);?>&nbsp;<?php echo TEXT_SUBTOTAL_FIELD; ?><br />
			                <?php echo zen_draw_checkbox_field('order_discount', '1', $order_discount_checked);?>&nbsp;<?php echo TEXT_DISCOUNT_FIELD; ?><br />
			                <?php echo zen_draw_checkbox_field('payment_method', '1', $order_pmethod_checked);?>&nbsp;<?php echo TEXT_PAYMENT_METHOD_FIELD; ?><br />
			                <?php echo zen_draw_checkbox_field('order_status', '1', $order_status_checked);?>&nbsp;<?php echo TEXT_ORDER_STATUS_FIELD; ?><br />
							<hr />
          <table border="0" cellspacing="0" cellpadding="2" width="100%" id="tbl_date_custom">
            <tr>
              <!--<td class="smallText" colspan="2">--><td colspan="2"><strong><?php echo HEADING_CUSTOM_DATE_TITLE; ?></strong><br>
			  <?php echo TEXT_CUSTOM_DATE; ?>
			  <br></td>
            </tr>
			
          <tr>
            <td class="main"><?php echo TEXT_SPIFFY_START_DATE_FIELD; ?>&nbsp;</td>

            <td class="main"><script language="javascript">StartDate.writeControl(); StartDate.dateFormat="yyyy-MM-dd";</script></td>
          </tr>
          <tr>
            <td class="main"><?php echo TEXT_SPIFFY_END_DATE_FIELD; ?>&nbsp;</td>
            <td class="main"><script language="javascript">EndDate.writeControl(); EndDate.dateFormat="yyyy-MM-dd";</script></td>
          </tr>
          </table>

				
				</td>
			
			  </tr>
			 
			  <tr>
			    <td align="center" class="infoBoxContent"><br>
				<?php echo $SUBMIT_BUTTON; ?>
				</form>
				</td>
			  </tr>
			  <tr>
			    <td class="infoBoxContent"></td>
			  </tr>
			  
			</table>

			
			
				
				</td>
			 
				</tr>
				<tr>
                 <td class="rbgleft_b"></td>
                <td class="rbgright_b"></td>
  				</tr>
			</table>
			
			</td>
			
			
          	
		  
		  </tr>
          <tr>
		  
            <td colspan="3">
			<table border="0" width="100%" cellspacing="0" cellpadding="2">
                
              </tr>
            </td>
            <td colspan="3">&nbsp;</td>
          </tr>
        </table></td>
      </tr>
    </table>
	
</table>
	</td>
  </tr>
</table>
	
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>