<?php
/**
 * @package languageDefines
 * @copyright Copyright 2003-2010 Joy Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.joy-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: paypal.php 15555 2010-02-22 06:12:26Z drbyte $
 */

  define('MODULE_PAYMENT_PAYPAL_TEXT_ADMIN_TITLE', 'PayPal Website Payments Standard - IPN');
  define('MODULE_PAYMENT_PAYPAL_TEXT_CATALOG_TITLE', 'PayPal');
  if (IS_ADMIN_FLAG === true) {
    define('MODULE_PAYMENT_PAYPAL_TEXT_DESCRIPTION', '<strong>PayPal Website Payments Standard (IPN)</strong> (Basic PayPal service)<br /><a href="https://www.paypal.com/c2/mrb/pal=GR5QUVVL9AFGN&MRB=R-4DM17246PS436904F" target="_blank">Manage your PayPal account.</a><br /><br /><font color="green">Configuration Instructions:</font><br />1. <a href="https://www.paypal.com/c2/mrb/pal=GR5QUVVL9AFGN&MRB=R-4DM17246PS436904F" target="_blank">Sign up for your PayPal account - click here.</a><br />2. In your PayPal account, under "Profile",<ul><li>set your <strong>Instant Payment Notification Preferences</strong> URL to:<br />'.str_replace('index.php?main_page=index','ipn_main_handler.php',zen_catalog_href_link(FILENAME_DEFAULT, '', 'SSL')) . '<br />(If another valid URL is already entered, you may leave it alone.)<br /><span class="alert">Be sure that the Checkbox to enable IPN is checked!</span><br /><br /></li><li>in <strong>Website Payments Preferences</strong> set your <strong>Automatic Return URL</strong> to:<br />'.zen_catalog_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL',false).'</li>' . (defined('MODULE_PAYMENT_PAYPALSTD_STATUS') ? '' : '<li>... and click "install" above to enable PayPal Standard support... and "edit" to tell Joy Cart your PayPal settings.</li>') . '</ul><font color="green"><hr /><strong>Requirements:</strong></font><br /><hr />*<strong>PayPal Account</strong> (<a href="https://www.paypal.com/c2/mrb/pal=GR5QUVVL9AFGN&MRB=R-4DM17246PS436904F" target="_blank">click to signup</a>)<br />*<strong>*<strong>Port 80</strong> is used for bidirectional communication with the gateway, so must be open on your host\'s router/firewall<br />*<strong>Settings</strong> must be configured as described above.' );
  } else {
    define('MODULE_PAYMENT_PAYPAL_TEXT_DESCRIPTION', '<strong>PayPal</strong>');
  }
  // to show the PayPal logo as the payment option name, use this:  https://www.paypal.com/en_US/i/logo/PayPal_mark_37x23.gif
  // to show CC icons with PayPal, use this instead:  https://www.paypal.com/en_US/i/bnr/horizontal_solution_PPeCheck.gif
  define('MODULE_PAYMENT_PAYPAL_MARK_BUTTON_IMG', 'https://www.paypal.com/en_US/i/logo/PayPal_mark_37x23.gif');
  define('MODULE_PAYMENT_PAYPAL_MARK_BUTTON_ALT', 'Checkout with PayPal');
  define('MODULE_PAYMENT_PAYPAL_ACCEPTANCE_MARK_TEXT', 'Save time. Check out securely. <br />Pay without sharing your financial information.');

  define('MODULE_PAYMENT_PAYPAL_TEXT_CATALOG_LOGO', '<img src="' . MODULE_PAYMENT_PAYPAL_MARK_BUTTON_IMG . '" alt="' . MODULE_PAYMENT_PAYPAL_MARK_BUTTON_ALT . '" title="' . MODULE_PAYMENT_PAYPAL_MARK_BUTTON_ALT . '" /> &nbsp;' .
                                                    '<span class="smallText">' . MODULE_PAYMENT_PAYPAL_ACCEPTANCE_MARK_TEXT . '</span>');

  define('MODULE_PAYMENT_PAYPAL_ENTRY_FIRST_NAME', 'First Name:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_LAST_NAME', 'Last Name:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_BUSINESS_NAME', 'Business Name:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_ADDRESS_NAME', 'Address Name:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_ADDRESS_STREET', 'Address Street:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_ADDRESS_CITY', 'Address City:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_ADDRESS_STATE', 'Address State:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_ADDRESS_ZIP', 'Address Zip:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_ADDRESS_COUNTRY', 'Address Country:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_EMAIL_ADDRESS', 'Payer Email:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_EBAY_ID', 'Ebay ID:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_PAYER_ID', 'Payer ID:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_PAYER_STATUS', 'Payer Status:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_ADDRESS_STATUS', 'Address Status:');

  define('MODULE_PAYMENT_PAYPAL_ENTRY_PAYMENT_TYPE', 'Payment Type:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_PAYMENT_STATUS', 'Payment Status:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_PENDING_REASON', 'Pending Reason:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_INVOICE', 'Invoice:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_PAYMENT_DATE', 'Payment Date:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_CURRENCY', 'Currency:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_GROSS_AMOUNT', 'Gross Amount:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_PAYMENT_FEE', 'Payment Fee:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_EXCHANGE_RATE', 'Exchange Rate:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_CART_ITEMS', 'Cart items:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_TXN_TYPE', 'Trans. Type:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_TXN_ID', 'Trans. ID:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_PARENT_TXN_ID', 'Parent Trans. ID:');
  define('MODULE_PAYMENT_PAYPAL_ENTRY_COMMENTS', 'System Comments: ');


  define('MODULE_PAYMENT_PAYPAL_PURCHASE_DESCRIPTION_TITLE', STORE_NAME . ' Purchase');
  define('MODULE_PAYMENT_PAYPAL_PURCHASE_DESCRIPTION_ITEMNUM', 'Store Receipt');
  define('MODULES_PAYMENT_PAYPALSTD_LINEITEM_TEXT_ONETIME_CHARGES_PREFIX', 'One-Time Charges related to ');
  define('MODULES_PAYMENT_PAYPALSTD_LINEITEM_TEXT_SURCHARGES_SHORT', 'Surcharges');
  define('MODULES_PAYMENT_PAYPALSTD_LINEITEM_TEXT_SURCHARGES_LONG', 'Handling charges and other applicable fees');
  define('MODULES_PAYMENT_PAYPALSTD_LINEITEM_TEXT_DISCOUNTS_SHORT', 'Discounts');
  define('MODULES_PAYMENT_PAYPALSTD_LINEITEM_TEXT_DISCOUNTS_LONG', 'Credits applied, including discount coupons, gift certificates, etc');
  
  
  define('LANGUAGES_MODULE_PAYMENT_PAYPAL_STATUS_TITLE', 'Enable PayPal Module');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_STATUS_DESCRIPTION', 'Do you want to accept PayPal payments?');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_BUSINESS_ID_TITLE', 'Business ID');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_BUSINESS_ID_DESCRIPTION', 'Primary email address for your PayPal account.
NOTE: This must match EXACTLY the primary email address on your PayPal account settings. It IS case-sensitive, so please check your PayPal profile preferences at paypal.com and be sure to enter the EXACT same primary email address here.');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_CURRENCY_TITLE', 'Transaction Currency');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_CURRENCY_DESCRIPTION', 'Which currency should the order be sent to PayPal as?
NOTE: if an unsupported currency is sent to PayPal, it will be auto-converted to USD.');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_ZONE_TITLE', 'Payment Zone');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_ZONE_DESCRIPTION', 'If a zone is selected, only enable this payment method for that zone.');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_PROCESSING_STATUS_ID_TITLE', 'Set Pending Notification Status');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_PROCESSING_STATUS_ID_DESCRIPTION', 'Set the status of orders made with this payment module that are not yet completed to this value
(\'Pending\' recommended)');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_ORDER_STATUS_ID_TITLE', 'Set Order Status');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_ORDER_STATUS_ID_DESCRIPTION', 'Set the status of orders made with this payment module that have completed payment to this value
(\'Processing\' recommended)');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_REFUND_ORDER_STATUS_ID_TITLE', 'Set Refund Order Status');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_REFUND_ORDER_STATUS_ID_DESCRIPTION', 'Set the status of orders that have been refunded made with this payment module to this value
(\'Pending\' recommended)');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_SORT_ORDER_TITLE', 'Sort order of display.');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_SORT_ORDER_DESCRIPTION', 'Sort order of display. Lowest is displayed first.');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_ADDRESS_OVERRIDE_TITLE', 'Address Override');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_ADDRESS_OVERRIDE_DESCRIPTION', 'If set to 1, the customer shipping address selected in Zen Cart will override the customer PayPal-stored address book. The customer will see their address from Zen Cart, but will NOT be able to edit it at PayPal.
(An invalid address will be treated by PayPal as not-supplied, or override=0)
0=No Override
1=ZC address overrides PayPal address choices');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_ADDRESS_REQUIRED_TITLE', 'Shipping Address Requirements?');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_ADDRESS_REQUIRED_DESCRIPTION', 'The buyers shipping address. If set to 0 your customer will be prompted to include a shipping address. If set to 1 your customer will not be asked for a shipping address. If set to 2 your customer will be required to provide a shipping address.
0=Prompt
1=Not Asked
2=Required

NOTE: If you allow your customers to enter their own shipping address, then MAKE SURE you PERSONALLY manually verify the PayPal confirmation details to verify the proper address when filling orders. When using Website Payments Standard (IPN), Zen Cart does not know if they choose an alternate shipping address at PayPal vs the one entered when placing an order.');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_DETAILED_CART_TITLE', 'Detailed Line Items in Cart');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_DETAILED_CART_DESCRIPTION', 'Do you want to give line-item details to PayPal? If set to True, line-item details will be shared with PayPal if no discounts apply and if tax and shipping are simple. Otherwise an Aggregate cart summary will be sent.');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_PAGE_STYLE_TITLE', 'Page Style');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_PAGE_STYLE_DESCRIPTION', 'Sets the Custom Payment Page Style for payment pages. The value of page_style is the same as the Page Style Name you chose when adding or editing the page style. You can add and edit Custom Payment Page Styles from the Profile subtab of the My Account tab on the PayPal site. If you would like to always reference your Primary style, set this to "primary." If you would like to reference the default PayPal page style, set this to "paypal".');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_HANDLER_TITLE', 'Mode for PayPal web services

Default:
www.paypal.com/cgi-bin/webscr
or
www.paypal.com/us/cgi-bin/webscr
or for the UK,
www.paypal.com/uk/cgi-bin/webscr');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_HANDLER_DESCRIPTION', 'Choose the URL for PayPal live processing');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_PDTTOKEN_TITLE', 'PDT Token (Payment Data Transfer)');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_PDTTOKEN_DESCRIPTION', 'Enter your PDT Token value here in order to activate transactions immediately after processing (if they pass validation).');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_IPN_DEBUG_TITLE', 'Debug Mode');
define('LANGUAGES_MODULE_PAYMENT_PAYPAL_IPN_DEBUG_DESCRIPTION', 'Enable debug logging?
NOTE: This can REALLY clutter your email inbox!
Logging goes to the /includes/modules/payment/paypal/logs folder
Email goes to the store-owner address.
Email option NOT recommended.
Leave OFF for normal operation.'); 
