<?php
/**
 * Testimonials Manager
 *
 * @package Template System
 * @copyright 2007 Clyde Jones
  * @copyright Portions Copyright 2003-2007 Zen Cart Development Team
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: Testimonials_Manager.php v1.5.0 1-9-2009 Clyde Jones $
 */
?>

<div class="centerColumn" id="testimonialDefault">
<?php echo HEADING_ADD_TITLE; ?>
<?php echo zen_draw_form('new_testimonial', zen_href_link(FILENAME_TESTIMONIALS_ADD, 'action=send', 'SSL')); ?>

<?php if (TESTIMONIAL_STORE_NAME_ADDRESS == 'true') { ?>
<address><?php echo nl2br(STORE_NAME_ADDRESS); ?></address>
<?php } ?>

<?php
  if (isset($_GET['action']) && ($_GET['action'] == 'success')) {
?>

<br class="clearBoth" />
<div class="mainContent success"><?php echo TESTIMONIAL_SUCCESS; ?></div>

<?php
  } else {
?>

<?php if (DEFINE_TESTIMONIAL_STATUS >= '1' and DEFINE_TESTIMONIAL_STATUS <= '2') { ?>
<div id="pageThreeMainContent">
<?php
require($define_page);
?>
</div>
<?php } ?>

<fieldset>
<legend><?php echo TABLE_HEADING_TESTIMONIALS; ?></legend>     
<?php if ($messageStack->size('new_testimonial') > 0) echo $messageStack->output('new_testimonial'); ?>
<div class="alert back"><?php echo zen_image($template->get_template_dir(RETURN_REQUIRED_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_REQUIRED_IMAGE, RETURN_REQUIRED_IMAGE_ALT, RETURN_REQUIRED_IMAGE_WIDTH, RETURN_REQUIRED_IMAGE_HEIGHT) . RETURN_REQUIRED_INFORMATION . zen_image($template->get_template_dir(RETURN_OPTIONAL_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_OPTIONAL_IMAGE, RETURN_OPTIONAL_IMAGE_ALT, RETURN_OPTIONAL_IMAGE_WIDTH, RETURN_OPTIONAL_IMAGE_HEIGHT) . RETURN_OPTIONAL_INFORMATION; ?></div>
<br class="clearBoth" />
<fieldset>
<legend><?php echo TESTIMONIAL_CONTACT; ?></legend>
<ol>
<li>
<label class="inputLabel" for="testimonials_name"><?php echo (($error == true && $entry_name_error == true) ? TEXT_TESTIMONIALS_NAME . zen_image($template->get_template_dir(RETURN_WARNING_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_WARNING_IMAGE, RETURN_WARNING_IMAGE_ALT, RETURN_WARNING_IMAGE_WIDTH, RETURN_WARNING_IMAGE_HEIGHT) : TEXT_TESTIMONIALS_NAME . zen_image($template->get_template_dir(RETURN_REQUIRED_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_REQUIRED_IMAGE, RETURN_REQUIRED_IMAGE_ALT, RETURN_REQUIRED_IMAGE_WIDTH, RETURN_REQUIRED_IMAGE_HEIGHT)); ?></label>
<?php echo (($error == true && $entry_name_error == true) ? zen_draw_input_field('testimonials_name', $testimonials_name, 'size="25" id="testimonials_name"') . ERROR_TESTIMONIALS_NAME_REQUIRED : zen_draw_input_field('testimonials_name', $testimonials_name, 'size="25" id="testimonials_name"')); ?>
</li>
<li>
<label class="inputLabel" for="testimonials_mail"><?php echo (($error == true && $entry_email_error == true) ? TEXT_TESTIMONIALS_MAIL . zen_image($template->get_template_dir(RETURN_WARNING_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_WARNING_IMAGE, RETURN_WARNING_IMAGE_ALT, RETURN_WARNING_IMAGE_WIDTH, RETURN_WARNING_IMAGE_HEIGHT) : TEXT_TESTIMONIALS_MAIL . zen_image($template->get_template_dir(RETURN_REQUIRED_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_REQUIRED_IMAGE, RETURN_REQUIRED_IMAGE_ALT, RETURN_REQUIRED_IMAGE_WIDTH, RETURN_REQUIRED_IMAGE_HEIGHT)); ?></label>
<?php echo (($error == true && $entry_email_error == true) ? zen_draw_input_field('testimonials_mail', $testimonials_mail, 'size="25" id="testimonials_mail"') . ERROR_TESTIMONIALS_EMAIL_REQUIRED : zen_draw_input_field('testimonials_mail', $testimonials_mail, 'size="25" id="testimonials_mail"')); ?>
</li>
<?php
  if (TESTIMONIALS_COMPANY == 'true') {
?>
<li>
<label class="inputLabel" for="testimonials_company"><?php echo TEXT_TESTIMONIALS_COMPANY . zen_image($template->get_template_dir(RETURN_OPTIONAL_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_OPTIONAL_IMAGE, RETURN_OPTIONAL_IMAGE_ALT, RETURN_OPTIONAL_IMAGE_WIDTH, RETURN_OPTIONAL_IMAGE_HEIGHT); ?></label>

<?php echo zen_draw_input_field('testimonials_company', $testimonials_company, 'size="25" id="testimonials_company"'); ?>
</li>
<?php
  }
?>
<?php
  if (TESTIMONIALS_CITY == 'true') {
?>
<li>
<label class="inputLabel" for="testimonials_city"><?php echo TEXT_TESTIMONIALS_CITY . zen_image($template->get_template_dir(RETURN_OPTIONAL_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_OPTIONAL_IMAGE, RETURN_OPTIONAL_IMAGE_ALT, RETURN_OPTIONAL_IMAGE_WIDTH, RETURN_OPTIONAL_IMAGE_HEIGHT); ?></label>

<?php echo zen_draw_input_field('testimonials_city', $testimonials_city, 'size="25" id="testimonials_city"'); ?>
</li>
<?php
  }
?>
<?php
  if (TESTIMONIALS_COUNTRY == 'true') {
?>
<li>
<label class="inputLabel" for="testimonials_country"><?php echo TEXT_TESTIMONIALS_COUNTRY . zen_image($template->get_template_dir(RETURN_OPTIONAL_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_OPTIONAL_IMAGE, RETURN_OPTIONAL_IMAGE_ALT, RETURN_OPTIONAL_IMAGE_WIDTH, RETURN_OPTIONAL_IMAGE_HEIGHT); ?></label>

<?php echo zen_draw_input_field('testimonials_country', $testimonials_country, 'size="25" id="testimonials_country"'); ?>
</li>
</ol>
<?php
  }
?>
</fieldset>
<fieldset>
<legend><?php echo TEXT_TESTIMONIALS_HTML_TEXT ; ?></legend>
<ol>
<li>
<label class="inputLabel" for="testimonials_title"><?php echo (($error == true && $entry_title_error == true) ? TEXT_TESTIMONIALS_TITLE . zen_image($template->get_template_dir(RETURN_WARNING_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_WARNING_IMAGE, RETURN_WARNING_IMAGE_ALT, RETURN_WARNING_IMAGE_WIDTH, RETURN_WARNING_IMAGE_HEIGHT) : TEXT_TESTIMONIALS_TITLE . zen_image($template->get_template_dir(RETURN_REQUIRED_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_REQUIRED_IMAGE, RETURN_REQUIRED_IMAGE_ALT, RETURN_REQUIRED_IMAGE_WIDTH, RETURN_REQUIRED_IMAGE_HEIGHT)); ?></label>
<?php echo (($error == true && $entry_title_error == true) ? zen_draw_input_field('testimonials_title', '', 'size="25" id="testimonials_title"') . ERROR_TESTIMONIALS_TITLE_REQUIRED : zen_draw_input_field('testimonials_title', '', 'size="25" id="testimonials_title"')); ?>
</li>
<?php echo TEXT_TESTIMONIALS_DESCRIPTION_INFO ; ?>
<?php if ($error == true && $entry_description_error == true) { ?>
<li>
<label class="inputLabel" for="testimonials_html_text"><?php echo TEXT_TESTIMONIALS_DESCRIPTION . zen_image($template->get_template_dir(RETURN_WARNING_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_WARNING_IMAGE, RETURN_WARNING_IMAGE_ALT, RETURN_WARNING_IMAGE_WIDTH, RETURN_WARNING_IMAGE_HEIGHT); ?></label>
<?php echo zen_draw_textarea_field('testimonials_html_text', '30', '7', '', 'id="testimonials_html_text"') . ERROR_TESTIMONIALS_DESCRIPTION_REQUIRED; ?>
</li>
<?php } else {  ?>
<?php if ($error == true && $entry_description_big_error == true) { ?>
<li>
<label class="inputLabel" for="testimonials_html_text"><?php echo TEXT_TESTIMONIALS_DESCRIPTION . zen_image($template->get_template_dir(RETURN_WARNING_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_WARNING_IMAGE, RETURN_WARNING_IMAGE_ALT, RETURN_WARNING_IMAGE_WIDTH, RETURN_WARNING_IMAGE_HEIGHT); ?></label>
<?php echo zen_draw_textarea_field('testimonials_html_text', '30', '7', '', 'id="testimonials_html_text"') . ERROR_TESTIMONIALS_TEXT_MAX_LENGTH; ?>
</li>
<?php } else {  ?>
<li>
<label class="inputLabel" for="testimonials_html_text"><?php echo TEXT_TESTIMONIALS_DESCRIPTION . zen_image($template->get_template_dir(RETURN_REQUIRED_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . RETURN_REQUIRED_IMAGE, RETURN_REQUIRED_IMAGE_ALT, RETURN_REQUIRED_IMAGE_WIDTH, RETURN_REQUIRED_IMAGE_HEIGHT); ?></label>
<?php echo zen_draw_textarea_field('testimonials_html_text', '30', '7', '', 'id="testimonials_html_text"'); ?>
</li>
<?php } 
}
?>
</ol>
</fieldset>
<br class="clearBoth" />
<div class="buttonRow forward"><?php echo zen_image_submit(BUTTON_IMAGE_SUBMIT_TESTIMONIALS, BUTTON_TESTIMONIALS_SUBMIT_ALT); ?></div>
</fieldset>
<?php
  }
?>

</form>
<div class="buttonRow back"><?php echo zen_back_link() . zen_image_button(BUTTON_IMAGE_BACK, BUTTON_BACK_ALT) .'</a>'; ?></div>
<br class="clearBoth" />
</div>
