#
# * Main joycart SQL Load for MySQL databases
# * @package Installer
# * @access private
# * @copyright Copyright 2003-2010 joycart Development Team
# * @copyright Portions Copyright 2003 osCommerce
# * @license http://www.joycart-ec.com/license/2_0.txt GNU Public License V2.0
# * @version $Id: mysql_joycart.sql 17019 2010-07-27 07:29:06Z drbyte $
#

############ IMPORTANT INSTRUCTIONS ###############
#
# * joycart 通过 zc_install/index.php 程序来执行安装
# * 本SQL脚步仅用于从 zc_install 下执行
# * * 不 * 建议通过其它工具执行
# * 例如: 不要用 phpMyAdmin 或其它 SQL 脚本工具
# * zc_install 程序会检测到可能的问题/错误
# * 并基于选择的安装模式，自动处理表前缀
#
#####################################################


# --------------------------------------------------------
#
# Table structure for table upgrade_exceptions
# (Placed at top so any exceptions during installation can be trapped as well)
#

DROP TABLE IF EXISTS upgrade_exceptions;
CREATE TABLE upgrade_exceptions (
  upgrade_exception_id smallint(5) NOT NULL auto_increment,
  sql_file varchar(50) default NULL,
  reason varchar(200) default NULL,
  errordate datetime default '0001-01-01 00:00:00',
  sqlstatement text,
  PRIMARY KEY  (upgrade_exception_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
#
# Table structure for table address_book
#

DROP TABLE IF EXISTS address_book;
CREATE TABLE address_book (
  address_book_id int(11) NOT NULL auto_increment,
  customers_id int(11) NOT NULL default '0',
  entry_gender char(1) NOT NULL default '',
  entry_company varchar(64) default NULL,
  entry_firstname varchar(32) NOT NULL default '',
  entry_lastname varchar(32) NOT NULL default '',
  entry_street_address varchar(64) NOT NULL default '',
  entry_suburb varchar(32) default NULL,
  entry_postcode varchar(10) NOT NULL default '',
  entry_city varchar(32) NOT NULL default '',
  entry_state varchar(32) default NULL,
  entry_country_id int(11) NOT NULL default '0',
  entry_zone_id int(11) NOT NULL default '0',
  PRIMARY KEY  (address_book_id),
  KEY idx_address_book_customers_id_zen (customers_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'address_format'
#

DROP TABLE IF EXISTS address_format;
CREATE TABLE address_format (
  address_format_id int(11) NOT NULL auto_increment,
  address_format varchar(128) NOT NULL default '',
  address_summary varchar(48) NOT NULL default '',
  PRIMARY KEY  (address_format_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'admin'
#

DROP TABLE IF EXISTS admin;
CREATE TABLE admin (
  admin_id int(11) NOT NULL auto_increment,
  admin_name varchar(32) NOT NULL default '',
  admin_email varchar(96) NOT NULL default '',
  admin_pass varchar(40) NOT NULL default '',
  admin_level tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (admin_id),
  KEY idx_admin_name_zen (admin_name),
  KEY idx_admin_email_zen (admin_email)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'admin_activity_log'
#

DROP TABLE IF EXISTS admin_activity_log;
CREATE TABLE admin_activity_log (
  log_id int(15) NOT NULL auto_increment,
  access_date datetime NOT NULL default '0001-01-01 00:00:00',
  admin_id int(11) NOT NULL default '0',
  page_accessed varchar(80) NOT NULL default '',
  page_parameters text,
  ip_address varchar(15) NOT NULL default '',
  PRIMARY KEY  (log_id),
  KEY idx_page_accessed_zen (page_accessed),
  KEY idx_access_date_zen (access_date),
  KEY idx_ip_zen (ip_address)
) CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------

#
# Table structure for table 'authorizenet'
#
DROP TABLE IF EXISTS authorizenet;
CREATE TABLE authorizenet (
  id int(11) unsigned NOT NULL auto_increment,
  customer_id int(11) NOT NULL default '0',
  order_id int(11) NOT NULL default '0',
  response_code int(1) NOT NULL default '0',
  response_text varchar(255) NOT NULL default '',
  authorization_type varchar(50) NOT NULL default '',
  transaction_id bigint default NULL,
  sent longtext NOT NULL,
  received longtext NOT NULL,
  time varchar(50) NOT NULL default '',
  session_id varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'banners'
#

DROP TABLE IF EXISTS banners;
CREATE TABLE banners (
  banners_id int(11) NOT NULL auto_increment,
  banners_title varchar(64) NOT NULL default '',
  banners_url varchar(255) NOT NULL default '',
  banners_image varchar(64) NOT NULL default '',
  banners_group varchar(15) NOT NULL default '',
  banners_html_text text,
  expires_impressions int(7) default '0',
  expires_date datetime default NULL,
  date_scheduled datetime default NULL,
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  date_status_change datetime default NULL,
  status int(1) NOT NULL default '1',
  banners_open_new_windows int(1) NOT NULL default '1',
  banners_on_ssl int(1) NOT NULL default '1',
  banners_sort_order int(11) NOT NULL default '0',
  PRIMARY KEY  (banners_id),
  KEY idx_status_group_zen (status,banners_group),
  KEY idx_expires_date_zen (expires_date),
  KEY idx_date_scheduled_zen (date_scheduled)
) CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------

#
# Table structure for table 'banners_history'
#

DROP TABLE IF EXISTS banners_history;
CREATE TABLE banners_history (
  banners_history_id int(11) NOT NULL auto_increment,
  banners_id int(11) NOT NULL default '0',
  banners_shown int(5) NOT NULL default '0',
  banners_clicked int(5) NOT NULL default '0',
  banners_history_date datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY  (banners_history_id),
  KEY idx_banners_id_zen (banners_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'categories'
#

DROP TABLE IF EXISTS categories;
CREATE TABLE categories (
  categories_id int(11) NOT NULL auto_increment,
  categories_image varchar(64) default NULL,
  parent_id int(11) NOT NULL default '0',
  sort_order int(3) default NULL,
  date_added datetime default NULL,
  last_modified datetime default NULL,
  categories_status tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (categories_id),
  KEY idx_parent_id_cat_id_zen (parent_id,categories_id),
  KEY idx_status_zen (categories_status),
  KEY idx_sort_order_zen (sort_order)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'categories_description'
#

DROP TABLE IF EXISTS categories_description;
CREATE TABLE categories_description (
  categories_id int(11) NOT NULL default '0',
  language_id int(11) NOT NULL default '1',
  categories_name varchar(32) NOT NULL default '',
  categories_description text NOT NULL,
  PRIMARY KEY  (categories_id,language_id),
  KEY idx_categories_name_zen (categories_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'configuration'
#

DROP TABLE IF EXISTS configuration;
CREATE TABLE configuration (
  configuration_id int(11) NOT NULL auto_increment,
  configuration_title text NOT NULL,
  configuration_key varchar(255) NOT NULL default '',
  configuration_value text NOT NULL,
  configuration_description text NOT NULL,
  configuration_group_id int(11) NOT NULL default '0',
  sort_order int(5) default NULL,
  last_modified datetime default NULL,
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  use_function text default NULL,
  set_function text default NULL,
  PRIMARY KEY  (configuration_id),
  UNIQUE KEY unq_config_key_zen (configuration_key),
  KEY idx_key_value_zen (configuration_key,configuration_value(10)),
  KEY idx_cfg_grp_id_zen (configuration_group_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'configuration_group'
#

DROP TABLE IF EXISTS configuration_group;
CREATE TABLE configuration_group (
  configuration_group_id int(11) NOT NULL auto_increment,
  configuration_group_title varchar(64) NOT NULL default '',
  configuration_group_description varchar(255) NOT NULL default '',
  sort_order int(5) default NULL,
  visible int(1) default '1',
  PRIMARY KEY  (configuration_group_id),
  KEY idx_visible_zen (visible)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'counter'
#

DROP TABLE IF EXISTS counter;
CREATE TABLE counter (
  startdate char(8) default NULL,
  counter int(12) default NULL
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'counter_history'
#

DROP TABLE IF EXISTS counter_history;
CREATE TABLE counter_history (
  startdate char(8) default NULL,
  counter int(12) default NULL,
  session_counter int(12) default NULL,
  PRIMARY KEY  (startdate)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'countries'
#

DROP TABLE IF EXISTS countries;
CREATE TABLE countries (
  countries_id int(11) NOT NULL auto_increment,
  countries_name varchar(64) NOT NULL default '',
  countries_iso_code_2 char(2) NOT NULL default '',
  countries_iso_code_3 char(3) NOT NULL default '',
  address_format_id int(11) NOT NULL default '0',
  PRIMARY KEY  (countries_id),
  KEY idx_countries_name_zen (countries_name),
  KEY idx_address_format_id_zen (address_format_id),
  KEY idx_iso_2_zen (countries_iso_code_2),
  KEY idx_iso_3_zen (countries_iso_code_3)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'coupon_email_track'
#

DROP TABLE IF EXISTS coupon_email_track;
CREATE TABLE coupon_email_track (
  unique_id int(11) NOT NULL auto_increment,
  coupon_id int(11) NOT NULL default '0',
  customer_id_sent int(11) NOT NULL default '0',
  sent_firstname varchar(32) default NULL,
  sent_lastname varchar(32) default NULL,
  emailed_to varchar(32) default NULL,
  date_sent datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY  (unique_id),
  KEY idx_coupon_id_zen (coupon_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'coupon_gv_customer'
#

DROP TABLE IF EXISTS coupon_gv_customer;
CREATE TABLE coupon_gv_customer (
  customer_id int(5) NOT NULL default '0',
  amount decimal(15,4) NOT NULL default '0.0000',
  PRIMARY KEY  (customer_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'coupon_gv_queue'
#

DROP TABLE IF EXISTS coupon_gv_queue;
CREATE TABLE coupon_gv_queue (
  unique_id int(5) NOT NULL auto_increment,
  customer_id int(5) NOT NULL default '0',
  order_id int(5) NOT NULL default '0',
  amount decimal(15,4) NOT NULL default '0.0000',
  date_created datetime NOT NULL default '0001-01-01 00:00:00',
  ipaddr varchar(32) NOT NULL default '',
  release_flag char(1) NOT NULL default 'N',
  PRIMARY KEY  (unique_id),
  KEY idx_cust_id_order_id_zen (customer_id,order_id),
  KEY idx_release_flag_zen (release_flag)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'coupon_redeem_track'
#

DROP TABLE IF EXISTS coupon_redeem_track;
CREATE TABLE coupon_redeem_track (
  unique_id int(11) NOT NULL auto_increment,
  coupon_id int(11) NOT NULL default '0',
  customer_id int(11) NOT NULL default '0',
  redeem_date datetime NOT NULL default '0001-01-01 00:00:00',
  redeem_ip varchar(32) NOT NULL default '',
  order_id int(11) NOT NULL default '0',
  PRIMARY KEY  (unique_id),
  KEY idx_coupon_id_zen (coupon_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'coupon_restrict'
#

DROP TABLE IF EXISTS coupon_restrict;
CREATE TABLE coupon_restrict (
  restrict_id int(11) NOT NULL auto_increment,
  coupon_id int(11) NOT NULL default '0',
  product_id int(11) NOT NULL default '0',
  category_id int(11) NOT NULL default '0',
  coupon_restrict char(1) NOT NULL default 'N',
  PRIMARY KEY  (restrict_id),
  KEY idx_coup_id_prod_id_zen (coupon_id,product_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'coupons'
#

DROP TABLE IF EXISTS coupons;
CREATE TABLE coupons (
  coupon_id int(11) NOT NULL auto_increment,
  coupon_type char(1) NOT NULL default 'F',
  coupon_code varchar(32) NOT NULL default '',
  coupon_amount decimal(15,4) NOT NULL default '0.0000',
  coupon_minimum_order decimal(15,4) NOT NULL default '0.0000',
  coupon_start_date datetime NOT NULL default '0001-01-01 00:00:00',
  coupon_expire_date datetime NOT NULL default '0001-01-01 00:00:00',
  uses_per_coupon int(5) NOT NULL default '1',
  uses_per_user int(5) NOT NULL default '0',
  restrict_to_products varchar(255) default NULL,
  restrict_to_categories varchar(255) default NULL,
  restrict_to_customers text,
  coupon_active char(1) NOT NULL default 'Y',
  date_created datetime NOT NULL default '0001-01-01 00:00:00',
  date_modified datetime NOT NULL default '0001-01-01 00:00:00',
  coupon_zone_restriction int(11) NOT NULL default '0',
  PRIMARY KEY (coupon_id),
  KEY idx_active_type_zen (coupon_active,coupon_type),
  KEY idx_coupon_code_zen (coupon_code),
  KEY idx_coupon_type_zen (coupon_type)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'coupons_description'
#

DROP TABLE IF EXISTS coupons_description;
CREATE TABLE coupons_description (
  coupon_id int(11) NOT NULL default '0',
  language_id int(11) NOT NULL default '0',
  coupon_name varchar(32) NOT NULL default '',
  coupon_description text,
  PRIMARY KEY (coupon_id,language_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'currencies'
#

DROP TABLE IF EXISTS currencies;
CREATE TABLE currencies (
  currencies_id int(11) NOT NULL auto_increment,
  title varchar(32) NOT NULL default '',
  code char(3) NOT NULL default '',
  symbol_left varchar(24) default NULL,
  symbol_right varchar(24) default NULL,
  decimal_point char(1) default NULL,
  thousands_point char(1) default NULL,
  decimal_places char(1) default NULL,
  value float(13,8) default NULL,
  last_updated datetime default NULL,
  PRIMARY KEY  (currencies_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'customers'
#

DROP TABLE IF EXISTS customers;
CREATE TABLE customers (
  customers_id int(11) NOT NULL auto_increment,
  customers_gender char(1) NOT NULL default '',
  customers_firstname varchar(32) NOT NULL default '',
  customers_lastname varchar(32) NOT NULL default '',
  customers_dob datetime NOT NULL default '0001-01-01 00:00:00',
  customers_email_address varchar(96) NOT NULL default '',
  customers_nick varchar(96) NOT NULL default '',
  customers_default_address_id int(11) NOT NULL default '0',
  customers_telephone varchar(32) NOT NULL default '',
  customers_fax varchar(32) default NULL,
  customers_password varchar(40) NOT NULL default '',
  customers_newsletter char(1) default NULL,
  customers_group_pricing int(11) NOT NULL default '0',
  customers_email_format varchar(4) NOT NULL default 'TEXT',
  customers_authorization int(1) NOT NULL default '0',
  customers_referral varchar(32) NOT NULL default '',
  customers_paypal_payerid VARCHAR(20) NOT NULL default '',
  customers_paypal_ec TINYINT(1) UNSIGNED DEFAULT 0 NOT NULL,
  PRIMARY KEY  (customers_id),
  KEY idx_email_address_zen (customers_email_address),
  KEY idx_referral_zen (customers_referral(10)),
  KEY idx_grp_pricing_zen (customers_group_pricing),
  KEY idx_nick_zen (customers_nick),
  KEY idx_newsletter_zen (customers_newsletter)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'customers_basket'
#

DROP TABLE IF EXISTS customers_basket;
CREATE TABLE customers_basket (
  customers_basket_id int(11) NOT NULL auto_increment,
  customers_id int(11) NOT NULL default '0',
  products_id tinytext NOT NULL,
  customers_basket_quantity float NOT NULL default '0',
  final_price decimal(15,4) NOT NULL default '0.0000',
  customers_basket_date_added varchar(8) default NULL,
  PRIMARY KEY  (customers_basket_id),
  KEY idx_customers_id_zen (customers_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'customers_basket_attributes'
#

DROP TABLE IF EXISTS customers_basket_attributes;
CREATE TABLE customers_basket_attributes (
  customers_basket_attributes_id int(11) NOT NULL auto_increment,
  customers_id int(11) NOT NULL default '0',
  products_id tinytext NOT NULL,
  products_options_id varchar(64) NOT NULL default '0',
  products_options_value_id int(11) NOT NULL default '0',
  products_options_value_text BLOB NULL,
  products_options_sort_order text NOT NULL,
  PRIMARY KEY  (customers_basket_attributes_id),
  KEY idx_cust_id_prod_id_zen (customers_id,products_id(36))
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'customers_info'
#

DROP TABLE IF EXISTS customers_info;
CREATE TABLE customers_info (
  customers_info_id int(11) NOT NULL default '0',
  customers_info_date_of_last_logon datetime default NULL,
  customers_info_number_of_logons int(5) default NULL,
  customers_info_date_account_created datetime default NULL,
  customers_info_date_account_last_modified datetime default NULL,
  global_product_notifications int(1) default '0',
  PRIMARY KEY  (customers_info_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table db_cache
#
DROP TABLE IF EXISTS db_cache;
CREATE TABLE db_cache (
  cache_entry_name varchar(64) NOT NULL default '',
  cache_data mediumblob,
  cache_entry_created int(15) default NULL,
  PRIMARY KEY  (cache_entry_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;



# --------------------------------------------------------

#
# Table structure for table 'email_archive'
#

DROP TABLE IF EXISTS email_archive;
CREATE TABLE email_archive (
  archive_id int(11) NOT NULL auto_increment,
  email_to_name varchar(96) NOT NULL default '',
  email_to_address varchar(96) NOT NULL default '',
  email_from_name varchar(96) NOT NULL default '',
  email_from_address varchar(96) NOT NULL default '',
  email_subject varchar(255) NOT NULL default '',
  email_html text NOT NULL,
  email_text text NOT NULL,
  date_sent datetime NOT NULL default '0001-01-01 00:00:00',
  module varchar(64) NOT NULL default '',
  PRIMARY KEY  (archive_id),
  KEY idx_email_to_address_zen (email_to_address),
  KEY idx_module_zen (module)
) CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------

#
# Table structure for table 'ezpages'
#

DROP TABLE IF EXISTS ezpages;
CREATE TABLE ezpages (
  pages_id int(11) NOT NULL auto_increment,
  languages_id int(11) NOT NULL default '1',
  pages_title varchar(64) NOT NULL default '',
  alt_url varchar(255) NOT NULL default '',
  alt_url_external varchar(255) NOT NULL default '',
  pages_html_text mediumtext,
  status_header int(1) NOT NULL default '1',
  status_sidebox int(1) NOT NULL default '1',
  status_footer int(1) NOT NULL default '1',
  status_toc int(1) NOT NULL default '1',
  header_sort_order int(3) NOT NULL default '0',
  sidebox_sort_order int(3) NOT NULL default '0',
  footer_sort_order int(3) NOT NULL default '0',
  toc_sort_order int(3) NOT NULL default '0',
  page_open_new_window int(1) NOT NULL default '0',
  page_is_ssl int(1) NOT NULL default '0',
  toc_chapter int(11) NOT NULL default '0',
  PRIMARY KEY  (pages_id),
  KEY idx_lang_id_zen (languages_id),
  KEY idx_ezp_status_header_zen (status_header),
  KEY idx_ezp_status_sidebox_zen (status_sidebox),
  KEY idx_ezp_status_footer_zen (status_footer),
  KEY idx_ezp_status_toc_zen (status_toc)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table ezpages_content
#

DROP TABLE IF EXISTS ezpages_content;
CREATE TABLE ezpages_content (
  pc_id int(11) NOT NULL auto_increment,
  pages_id int(11) NOT NULL default '0',
  languages_id int(11) NOT NULL default '1',
  pages_title varchar(64) NOT NULL default '',
  pages_html_text text,
  PRIMARY KEY  (pc_id),
  KEY idx_ezpages_content (pages_id,languages_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

#
# Table structure for table 'featured'
#

DROP TABLE IF EXISTS featured;
CREATE TABLE featured (
  featured_id int(11) NOT NULL auto_increment,
  products_id int(11) NOT NULL default '0',
  featured_date_added datetime default NULL,
  featured_last_modified datetime default NULL,
  expires_date date NOT NULL default '0001-01-01',
  date_status_change datetime default NULL,
  status int(1) NOT NULL default '1',
  featured_date_available date NOT NULL default '0001-01-01',
  PRIMARY KEY  (featured_id),
  KEY idx_status_zen (status),
  KEY idx_products_id_zen (products_id),
  KEY idx_date_avail_zen (featured_date_available),
  KEY idx_expires_date_zen (expires_date)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'files_uploaded'
#

DROP TABLE IF EXISTS files_uploaded;
CREATE TABLE files_uploaded (
  files_uploaded_id int(11) NOT NULL auto_increment,
  sesskey varchar(32) default NULL,
  customers_id int(11) default NULL,
  files_uploaded_name varchar(64) NOT NULL default '',
  PRIMARY KEY  (files_uploaded_id),
  KEY idx_customers_id_zen (customers_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT='Must always have either a sesskey or customers_id';

# --------------------------------------------------------

#
# Table structure for table 'geo_zones'
#

DROP TABLE IF EXISTS geo_zones;
CREATE TABLE geo_zones (
  geo_zone_id int(11) NOT NULL auto_increment,
  geo_zone_name varchar(32) NOT NULL default '',
  geo_zone_description varchar(255) NOT NULL default '',
  last_modified datetime default NULL,
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY  (geo_zone_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'get_terms_to_filter'
#
DROP TABLE IF EXISTS get_terms_to_filter;
CREATE TABLE get_terms_to_filter (
  get_term_name varchar(255) NOT NULL default '',
  get_term_table varchar(64) NOT NULL,
  get_term_name_field varchar(64) NOT NULL,
  PRIMARY KEY  (get_term_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'group_pricing'
#

DROP TABLE IF EXISTS group_pricing;
CREATE TABLE group_pricing (
  group_id int(11) NOT NULL auto_increment,
  group_name varchar(32) NOT NULL default '',
  group_percentage decimal(5,2) NOT NULL default '0.00',
  last_modified datetime default NULL,
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY  (group_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'languages'
#

DROP TABLE IF EXISTS languages;
CREATE TABLE languages (
  languages_id int(11) NOT NULL auto_increment,
  name varchar(32) NOT NULL default '',
  code char(2) NOT NULL default '',
  image varchar(64) default NULL,
  directory varchar(32) default NULL,
  sort_order int(3) default NULL,
  PRIMARY KEY  (languages_id),
  KEY idx_languages_name_zen (name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'layout_boxes'
#

DROP TABLE IF EXISTS layout_boxes;
CREATE TABLE layout_boxes (
  layout_id int(11) NOT NULL auto_increment,
  layout_template varchar(64) NOT NULL default '',
  layout_box_name varchar(64) NOT NULL default '',
  layout_box_status tinyint(1) NOT NULL default '0',
  layout_box_location tinyint(1) NOT NULL default '0',
  layout_box_sort_order int(11) NOT NULL default '0',
  layout_box_sort_order_single int(11) NOT NULL default '0',
  layout_box_status_single tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (layout_id),
  KEY idx_name_template_zen (layout_template,layout_box_name),
  KEY idx_layout_box_status_zen (layout_box_status),
  KEY idx_layout_box_sort_order_zen (layout_box_sort_order)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'manufacturers'
#

DROP TABLE IF EXISTS manufacturers;
CREATE TABLE manufacturers (
  manufacturers_id int(11) NOT NULL auto_increment,
  manufacturers_name varchar(32) NOT NULL default '',
  manufacturers_image varchar(64) default NULL,
  date_added datetime default NULL,
  last_modified datetime default NULL,
  PRIMARY KEY  (manufacturers_id),
  KEY idx_mfg_name_zen (manufacturers_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'manufacturers_info'
#

DROP TABLE IF EXISTS manufacturers_info;
CREATE TABLE manufacturers_info (
  manufacturers_id int(11) NOT NULL default '0',
  languages_id int(11) NOT NULL default '0',
  manufacturers_url varchar(255) NOT NULL default '',
  url_clicked int(5) NOT NULL default '0',
  date_last_click datetime default NULL,
  PRIMARY KEY  (manufacturers_id,languages_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'media_clips'
#

DROP TABLE IF EXISTS media_clips;
CREATE TABLE media_clips (
  clip_id int(11) NOT NULL auto_increment,
  media_id int(11) NOT NULL default '0',
  clip_type smallint(6) NOT NULL default '0',
  clip_filename text NOT NULL,
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  last_modified datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY  (clip_id),
  KEY idx_media_id_zen (media_id),
  KEY idx_clip_type_zen (clip_type)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'media_manager'
#

DROP TABLE IF EXISTS media_manager;
CREATE TABLE media_manager (
  media_id int(11) NOT NULL auto_increment,
  media_name varchar(255) NOT NULL default '',
  last_modified datetime NOT NULL default '0001-01-01 00:00:00',
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY  (media_id),
  KEY idx_media_name_zen (media_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'media_to_products'
#

DROP TABLE IF EXISTS media_to_products;
CREATE TABLE media_to_products (
  media_id int(11) NOT NULL default '0',
  product_id int(11) NOT NULL default '0',
  KEY idx_media_product_zen (media_id,product_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'media_types'
#

DROP TABLE IF EXISTS media_types;
CREATE TABLE media_types (
  type_id int(11) NOT NULL auto_increment,
  type_name varchar(64) NOT NULL default '',
  type_ext varchar(8) NOT NULL default '',
  PRIMARY KEY  (type_id),
  KEY idx_type_name_zen (type_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

INSERT INTO media_types (type_name, type_ext) VALUES ('MP3','.mp3');

# -------------------------------------------------------

#
# Table structure for table 'meta_tags_categories_description'
#

DROP TABLE IF EXISTS meta_tags_categories_description;
CREATE TABLE meta_tags_categories_description (
  categories_id int(11) NOT NULL,
  language_id int(11) NOT NULL default '1',
  metatags_title varchar(255) NOT NULL default '',
  metatags_keywords text,
  metatags_description text,
  PRIMARY KEY  (categories_id,language_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'meta_tags_products_description'
#

DROP TABLE IF EXISTS meta_tags_products_description;
CREATE TABLE meta_tags_products_description (
  products_id int(11) NOT NULL,
  language_id int(11) NOT NULL default '1',
  metatags_title varchar(255) NOT NULL default '',
  metatags_keywords text,
  metatags_description text,
  PRIMARY KEY  (products_id,language_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'music_genre'
#

DROP TABLE IF EXISTS music_genre;
CREATE TABLE music_genre (
  music_genre_id int(11) NOT NULL auto_increment,
  music_genre_name varchar(32) NOT NULL default '',
  date_added datetime default NULL,
  last_modified datetime default NULL,
  PRIMARY KEY  (music_genre_id),
  KEY idx_music_genre_name_zen (music_genre_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'newsletters'
#

DROP TABLE IF EXISTS newsletters;
CREATE TABLE newsletters (
  newsletters_id int(11) NOT NULL auto_increment,
  title varchar(255) NOT NULL default '',
  content text NOT NULL,
  content_html text NOT NULL,
  module varchar(255) NOT NULL default '',
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  date_sent datetime default NULL,
  status int(1) default NULL,
  locked int(1) default '0',
  PRIMARY KEY  (newsletters_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'orders'
#

DROP TABLE IF EXISTS orders;
CREATE TABLE IF NOT EXISTS orders (
  orders_id int(11) NOT NULL AUTO_INCREMENT,
  customers_id int(11) NOT NULL DEFAULT '0',
  customers_name varchar(64) NOT NULL DEFAULT '',
  customers_company varchar(64) DEFAULT NULL,
  customers_street_address varchar(64) NOT NULL DEFAULT '',
  customers_suburb varchar(32) DEFAULT NULL,
  customers_city varchar(32) NOT NULL DEFAULT '',
  customers_postcode varchar(10) NOT NULL DEFAULT '',
  customers_state varchar(32) DEFAULT NULL,
  customers_country varchar(32) NOT NULL DEFAULT '',
  customers_telephone varchar(32) NOT NULL DEFAULT '',
  customers_email_address varchar(96) NOT NULL DEFAULT '',
  customers_address_format_id int(5) NOT NULL DEFAULT '0',
  delivery_name varchar(64) NOT NULL DEFAULT '',
  delivery_company varchar(64) DEFAULT NULL,
  delivery_street_address varchar(64) NOT NULL DEFAULT '',
  delivery_suburb varchar(32) DEFAULT NULL,
  delivery_city varchar(32) NOT NULL DEFAULT '',
  delivery_postcode varchar(10) NOT NULL DEFAULT '',
  delivery_state varchar(32) DEFAULT NULL,
  delivery_country varchar(32) NOT NULL DEFAULT '',
  delivery_address_format_id int(5) NOT NULL DEFAULT '0',
  billing_name varchar(64) NOT NULL DEFAULT '',
  billing_company varchar(64) DEFAULT NULL,
  billing_street_address varchar(64) NOT NULL DEFAULT '',
  billing_suburb varchar(32) DEFAULT NULL,
  billing_city varchar(32) NOT NULL DEFAULT '',
  billing_postcode varchar(10) NOT NULL DEFAULT '',
  billing_state varchar(32) DEFAULT NULL,
  billing_country varchar(32) NOT NULL DEFAULT '',
  billing_address_format_id int(5) NOT NULL DEFAULT '0',
  payment_method varchar(128) NOT NULL DEFAULT '',
  payment_module_code varchar(32) NOT NULL DEFAULT '',
  shipping_method varchar(128) NOT NULL DEFAULT '',
  shipping_module_code varchar(32) NOT NULL DEFAULT '',
  coupon_code varchar(32) NOT NULL DEFAULT '',
  cc_type varchar(20) DEFAULT NULL,
  cc_owner varchar(64) DEFAULT NULL,
  cc_number varchar(32) DEFAULT NULL,
  cc_expires varchar(4) DEFAULT NULL,
  cc_cvv blob,
  last_modified datetime DEFAULT NULL,
  date_purchased datetime DEFAULT NULL,
  orders_status int(5) NOT NULL DEFAULT '0',
  orders_date_finished datetime DEFAULT NULL,
  currency char(3) DEFAULT NULL,
  currency_value decimal(14,6) DEFAULT NULL,
  order_total decimal(14,2) DEFAULT NULL,
  order_tax decimal(14,2) DEFAULT NULL,
  paypal_ipn_id int(11) NOT NULL DEFAULT '0',
  ip_address varchar(96) NOT NULL DEFAULT '',
  downloaded_ship enum('yes','no') NOT NULL DEFAULT 'no',
  lp_avs varchar(25) NOT NULL DEFAULT '',
  lp_trans_num varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (orders_id),
  KEY idx_status_orders_cust_zen (orders_status,orders_id,customers_id),
  KEY idx_date_purchased_zen (date_purchased),
  KEY idx_cust_id_orders_id_zen (customers_id,orders_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;


# --------------------------------------------------------

#
# Table structure for table 'orders_products'
#

DROP TABLE IF EXISTS orders_products;
CREATE TABLE orders_products (
  orders_products_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  products_id int(11) NOT NULL default '0',
  products_model varchar(32) default NULL,
  products_name varchar(64) NOT NULL default '',
  products_price decimal(15,4) NOT NULL default '0.0000',
  final_price decimal(15,4) NOT NULL default '0.0000',
  products_tax decimal(7,4) NOT NULL default '0.0000',
  products_quantity float NOT NULL default '0',
  onetime_charges decimal(15,4) NOT NULL default '0.0000',
  products_priced_by_attribute tinyint(1) NOT NULL default '0',
  product_is_free tinyint(1) NOT NULL default '0',
  products_discount_type tinyint(1) NOT NULL default '0',
  products_discount_type_from tinyint(1) NOT NULL default '0',
  products_prid tinytext NOT NULL,
  PRIMARY KEY  (orders_products_id),
  KEY idx_orders_id_prod_id_zen (orders_id,products_id),
  KEY idx_prod_id_orders_id_zen (products_id,orders_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'orders_products_attributes'
#

DROP TABLE IF EXISTS orders_products_attributes;
CREATE TABLE orders_products_attributes (
  orders_products_attributes_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  orders_products_id int(11) NOT NULL default '0',
  products_options varchar(32) NOT NULL default '',
  products_options_values text NOT NULL,
  options_values_price decimal(15,4) NOT NULL default '0.0000',
  price_prefix char(1) NOT NULL default '',
  product_attribute_is_free tinyint(1) NOT NULL default '0',
  products_attributes_weight float NOT NULL default '0',
  products_attributes_weight_prefix char(1) NOT NULL default '',
  attributes_discounted tinyint(1) NOT NULL default '1',
  attributes_price_base_included tinyint(1) NOT NULL default '1',
  attributes_price_onetime decimal(15,4) NOT NULL default '0.0000',
  attributes_price_factor decimal(15,4) NOT NULL default '0.0000',
  attributes_price_factor_offset decimal(15,4) NOT NULL default '0.0000',
  attributes_price_factor_onetime decimal(15,4) NOT NULL default '0.0000',
  attributes_price_factor_onetime_offset decimal(15,4) NOT NULL default '0.0000',
  attributes_qty_prices text,
  attributes_qty_prices_onetime text,
  attributes_price_words decimal(15,4) NOT NULL default '0.0000',
  attributes_price_words_free int(4) NOT NULL default '0',
  attributes_price_letters decimal(15,4) NOT NULL default '0.0000',
  attributes_price_letters_free int(4) NOT NULL default '0',
  products_options_id int(11) NOT NULL default '0',
  products_options_values_id int(11) NOT NULL default '0',
  products_prid tinytext NOT NULL,
  PRIMARY KEY  (orders_products_attributes_id),
  KEY idx_orders_id_prod_id_zen (orders_id,orders_products_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'orders_products_download'
#

DROP TABLE IF EXISTS orders_products_download;
CREATE TABLE orders_products_download (
  orders_products_download_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  orders_products_id int(11) NOT NULL default '0',
  orders_products_filename varchar(255) NOT NULL default '',
  download_maxdays int(2) NOT NULL default '0',
  download_count int(2) NOT NULL default '0',
  products_prid tinytext NOT NULL,
  PRIMARY KEY  (orders_products_download_id),
  KEY idx_orders_id_zen (orders_id),
  KEY idx_orders_products_id_zen (orders_products_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'orders_status'
#

DROP TABLE IF EXISTS orders_status;
CREATE TABLE orders_status (
  orders_status_id int(11) NOT NULL default '0',
  language_id int(11) NOT NULL default '1',
  orders_status_name varchar(32) NOT NULL default '',
  PRIMARY KEY  (orders_status_id,language_id),
  KEY idx_orders_status_name_zen (orders_status_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'orders_status_history'
#

DROP TABLE IF EXISTS orders_status_history;
CREATE TABLE orders_status_history (
  orders_status_history_id int(11) NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  orders_status_id int(5) NOT NULL default '0',
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  customer_notified int(1) default '0',
  comments text,
  PRIMARY KEY  (orders_status_history_id),
  KEY idx_orders_id_status_id_zen (orders_id,orders_status_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'orders_total'
#

DROP TABLE IF EXISTS orders_total;
CREATE TABLE orders_total (
  orders_total_id int(10) unsigned NOT NULL auto_increment,
  orders_id int(11) NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  text varchar(255) NOT NULL default '',
  value decimal(15,4) NOT NULL default '0.0000',
  class varchar(32) NOT NULL default '',
  sort_order int(11) NOT NULL default '0',
  PRIMARY KEY  (orders_total_id),
  KEY idx_ot_orders_id_zen (orders_id),
  KEY idx_ot_class_zen (class)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'paypal'
#

DROP TABLE IF EXISTS paypal;
CREATE TABLE paypal (
  paypal_ipn_id int(11) unsigned NOT NULL auto_increment,
  order_id int(11) unsigned NOT NULL default '0',
  txn_type varchar(40) NOT NULL default '',
  module_name varchar(40) NOT NULL default '',
  module_mode varchar(40) NOT NULL default '',
  reason_code varchar(40) default NULL,
  payment_type varchar(40) NOT NULL default '',
  payment_status varchar(32) NOT NULL default '',
  pending_reason varchar(32) default NULL,
  invoice varchar(128) default NULL,
  mc_currency char(3) NOT NULL default '',
  first_name varchar(32) NOT NULL default '',
  last_name varchar(32) NOT NULL default '',
  payer_business_name varchar(128) default NULL,
  address_name varchar(64) default NULL,
  address_street varchar(254) default NULL,
  address_city varchar(120) default NULL,
  address_state varchar(120) default NULL,
  address_zip varchar(10) default NULL,
  address_country varchar(64) default NULL,
  address_status varchar(11) default NULL,
  payer_email varchar(128) NOT NULL default '',
  payer_id varchar(32) NOT NULL default '',
  payer_status varchar(10) NOT NULL default '',
  payment_date datetime NOT NULL default '0001-01-01 00:00:00',
  business varchar(128) NOT NULL default '',
  receiver_email varchar(128) NOT NULL default '',
  receiver_id varchar(32) NOT NULL default '',
  txn_id varchar(20) NOT NULL default '',
  parent_txn_id varchar(20) default NULL,
  num_cart_items tinyint(4) unsigned NOT NULL default '1',
  mc_gross decimal(7,2) NOT NULL default '0.00',
  mc_fee decimal(7,2) NOT NULL default '0.00',
  payment_gross decimal(7,2) default NULL,
  payment_fee decimal(7,2) default NULL,
  settle_amount decimal(7,2) default NULL,
  settle_currency char(3) default NULL,
  exchange_rate decimal(4,2) default NULL,
  notify_version varchar(6) NOT NULL default '',
  verify_sign varchar(128) NOT NULL default '',
  last_modified datetime NOT NULL default '0001-01-01 00:00:00',
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  memo text,
  PRIMARY KEY (paypal_ipn_id,txn_id),
  KEY idx_order_id_zen (order_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'paypal_payment_status'
#

DROP TABLE IF EXISTS paypal_payment_status;
CREATE TABLE paypal_payment_status (
  payment_status_id int(11) NOT NULL auto_increment,
  payment_status_name varchar(64) NOT NULL default '',
  PRIMARY KEY (payment_status_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

#
# Dumping data for table 'paypal_payment_status'
#

INSERT INTO paypal_payment_status VALUES (1, 'Completed');
INSERT INTO paypal_payment_status VALUES (2, 'Pending');
INSERT INTO paypal_payment_status VALUES (3, 'Failed');
INSERT INTO paypal_payment_status VALUES (4, 'Denied');
INSERT INTO paypal_payment_status VALUES (5, 'Refunded');
INSERT INTO paypal_payment_status VALUES (6, 'Canceled_Reversal');
INSERT INTO paypal_payment_status VALUES (7, 'Reversed');

# --------------------------------------------------------

#
# Table structure for table 'paypal_payment_status_history'
#

DROP TABLE IF EXISTS paypal_payment_status_history;
CREATE TABLE paypal_payment_status_history (
  payment_status_history_id int(11) NOT NULL auto_increment,
  paypal_ipn_id int(11) NOT NULL default '0',
  txn_id varchar(64) NOT NULL default '',
  parent_txn_id varchar(64) NOT NULL default '',
  payment_status varchar(17) NOT NULL default '',
  pending_reason varchar(14) default NULL,
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY (payment_status_history_id),
  KEY idx_paypal_ipn_id_zen (paypal_ipn_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'paypal_session'
#

DROP TABLE IF EXISTS paypal_session;
CREATE TABLE paypal_session (
  unique_id int(11) NOT NULL auto_increment,
  session_id text NOT NULL,
  saved_session mediumblob NOT NULL,
  expiry int(17) NOT NULL default '0',
  PRIMARY KEY  (unique_id),
  KEY idx_session_id_zen (session_id(36))
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'paypal_testing'
#

DROP TABLE IF EXISTS paypal_testing;
CREATE TABLE paypal_testing (
  paypal_ipn_id int(11) unsigned NOT NULL auto_increment,
  order_id int(11) unsigned NOT NULL default '0',
  custom varchar(255) NOT NULL default '',
  txn_type varchar(40) NOT NULL default '',
  module_name varchar(40) NOT NULL default '',
  module_mode varchar(40) NOT NULL default '',
  reason_code varchar(40) default NULL,
  payment_type varchar(40) NOT NULL default '',
  payment_status varchar(32) NOT NULL default '',
  pending_reason varchar(32) default NULL,
  invoice varchar(128) default NULL,
  mc_currency char(3) NOT NULL default '',
  first_name varchar(32) NOT NULL default '',
  last_name varchar(32) NOT NULL default '',
  payer_business_name varchar(128) default NULL,
  address_name varchar(64) default NULL,
  address_street varchar(254) default NULL,
  address_city varchar(120) default NULL,
  address_state varchar(120) default NULL,
  address_zip varchar(10) default NULL,
  address_country varchar(64) default NULL,
  address_status varchar(11) default NULL,
  payer_email varchar(128) NOT NULL default '',
  payer_id varchar(32) NOT NULL default '',
  payer_status varchar(10) NOT NULL default '',
  payment_date datetime NOT NULL default '0001-01-01 00:00:00',
  business varchar(128) NOT NULL default '',
  receiver_email varchar(128) NOT NULL default '',
  receiver_id varchar(32) NOT NULL default '',
  txn_id varchar(20) NOT NULL default '',
  parent_txn_id varchar(20) default NULL,
  num_cart_items tinyint(4) unsigned NOT NULL default '1',
  mc_gross decimal(7,2) NOT NULL default '0.00',
  mc_fee decimal(7,2) NOT NULL default '0.00',
  payment_gross decimal(7,2) default NULL,
  payment_fee decimal(7,2) default NULL,
  settle_amount decimal(7,2) default NULL,
  settle_currency char(3) default NULL,
  exchange_rate decimal(4,2) default NULL,
  notify_version decimal(2,1) NOT NULL default '0.0',
  verify_sign varchar(128) NOT NULL default '',
  last_modified datetime NOT NULL default '0001-01-01 00:00:00',
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  memo text,
  PRIMARY KEY  (paypal_ipn_id,txn_id),
  KEY idx_order_id_zen (order_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'product_music_extra'
#

DROP TABLE IF EXISTS product_music_extra;
CREATE TABLE product_music_extra (
  products_id int(11) NOT NULL default '0',
  artists_id int(11) NOT NULL default '0',
  record_company_id int(11) NOT NULL default '0',
  music_genre_id int(11) NOT NULL default '0',
  PRIMARY KEY  (products_id),
  KEY idx_music_genre_id_zen (music_genre_id),
  KEY idx_artists_id_zen (artists_id),
  KEY idx_record_company_id_zen (record_company_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------

#
# Table structure for table 'product_type_layout'
#
DROP TABLE IF EXISTS product_type_layout;
CREATE TABLE product_type_layout (
  configuration_id int(11) NOT NULL auto_increment,
  configuration_title text NOT NULL,
  configuration_key varchar(255) NOT NULL default '',
  configuration_value text NOT NULL,
  configuration_description text NOT NULL,
  product_type_id int(11) NOT NULL default '0',
  sort_order int(5) default NULL,
  last_modified datetime default NULL,
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  use_function text default NULL,
  set_function text default NULL,
  PRIMARY KEY  (configuration_id),
  UNIQUE KEY unq_config_key_zen (configuration_key),
  KEY idx_key_value_zen (configuration_key,configuration_value(10)),
  KEY idx_type_id_sort_order_zen (product_type_id,sort_order)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'product_types'
#

DROP TABLE IF EXISTS product_types;
CREATE TABLE product_types (
  type_id int(11) NOT NULL auto_increment,
  type_name varchar(255) NOT NULL default '',
  type_handler varchar(255) NOT NULL default '',
  type_master_type int(11) NOT NULL default '1',
  allow_add_to_cart char(1) NOT NULL default 'Y',
  default_image varchar(255) NOT NULL default '',
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  last_modified datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY  (type_id),
  KEY idx_type_master_type_zen (type_master_type)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'product_types_to_category'
#

DROP TABLE IF EXISTS product_types_to_category;
CREATE TABLE product_types_to_category (
  product_type_id int(11) NOT NULL default '0',
  category_id int(11) NOT NULL default '0',
  KEY idx_category_id_zen (category_id),
  KEY idx_product_type_id_zen (product_type_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------

#
# Table structure for table 'products'
#

DROP TABLE IF EXISTS products;
CREATE TABLE products (
  products_id int(11) NOT NULL auto_increment,
  products_type int(11) NOT NULL default '1',
  products_quantity float NOT NULL default '0',
  products_model varchar(32) default NULL,
  products_image varchar(64) default NULL,
  products_price decimal(15,4) NOT NULL default '0.0000',
  products_virtual tinyint(1) NOT NULL default '0',
  products_date_added datetime NOT NULL default '0001-01-01 00:00:00',
  products_last_modified datetime default NULL,
  products_date_available datetime default NULL,
  products_weight float NOT NULL default '0',
  products_status tinyint(1) NOT NULL default '0',
  products_tax_class_id int(11) NOT NULL default '0',
  manufacturers_id int(11) default NULL,
  products_ordered float NOT NULL default '0',
  products_quantity_order_min float NOT NULL default '1',
  products_quantity_order_units float NOT NULL default '1',
  products_priced_by_attribute tinyint(1) NOT NULL default '0',
  product_is_free tinyint(1) NOT NULL default '0',
  product_is_call tinyint(1) NOT NULL default '0',
  products_quantity_mixed tinyint(1) NOT NULL default '0',
  product_is_always_free_shipping tinyint(1) NOT NULL default '0',
  products_qty_box_status tinyint(1) NOT NULL default '1',
  products_quantity_order_max float NOT NULL default '0',
  products_sort_order int(11) NOT NULL default '0',
  products_discount_type tinyint(1) NOT NULL default '0',
  products_discount_type_from tinyint(1) NOT NULL default '0',
  products_price_sorter decimal(15,4) NOT NULL default '0.0000',
  master_categories_id int(11) NOT NULL default '0',
  products_mixed_discount_quantity tinyint(1) NOT NULL default '1',
  metatags_title_status tinyint(1) NOT NULL default '0',
  metatags_products_name_status tinyint(1) NOT NULL default '0',
  metatags_model_status tinyint(1) NOT NULL default '0',
  metatags_price_status tinyint(1) NOT NULL default '0',
  metatags_title_tagline_status tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (products_id),
  KEY idx_products_date_added_zen (products_date_added),
  KEY idx_products_status_zen (products_status),
  KEY idx_products_date_available_zen (products_date_available),
  KEY idx_products_ordered_zen (products_ordered),
  KEY idx_products_model_zen (products_model),
  KEY idx_products_price_sorter_zen (products_price_sorter),
  KEY idx_master_categories_id_zen (master_categories_id),
  KEY idx_products_sort_order_zen (products_sort_order),
  KEY idx_manufacturers_id_zen (manufacturers_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;
# --------------------------------------------------------

#
# Table structure for table 'products_attributes'
#

DROP TABLE IF EXISTS products_attributes;
CREATE TABLE products_attributes (
  products_attributes_id int(11) NOT NULL auto_increment,
  products_id int(11) NOT NULL default '0',
  options_id int(11) NOT NULL default '0',
  options_values_id int(11) NOT NULL default '0',
  options_values_price decimal(15,4) NOT NULL default '0.0000',
  price_prefix char(1) NOT NULL default '',
  products_options_sort_order int(11) NOT NULL default '0',
  product_attribute_is_free tinyint(1) NOT NULL default '0',
  products_attributes_weight float NOT NULL default '0',
  products_attributes_weight_prefix char(1) NOT NULL default '',
  attributes_display_only tinyint(1) NOT NULL default '0',
  attributes_default tinyint(1) NOT NULL default '0',
  attributes_discounted tinyint(1) NOT NULL default '1',
  attributes_image varchar(64) default NULL,
  attributes_price_base_included tinyint(1) NOT NULL default '1',
  attributes_price_onetime decimal(15,4) NOT NULL default '0.0000',
  attributes_price_factor decimal(15,4) NOT NULL default '0.0000',
  attributes_price_factor_offset decimal(15,4) NOT NULL default '0.0000',
  attributes_price_factor_onetime decimal(15,4) NOT NULL default '0.0000',
  attributes_price_factor_onetime_offset decimal(15,4) NOT NULL default '0.0000',
  attributes_qty_prices text,
  attributes_qty_prices_onetime text,
  attributes_price_words decimal(15,4) NOT NULL default '0.0000',
  attributes_price_words_free int(4) NOT NULL default '0',
  attributes_price_letters decimal(15,4) NOT NULL default '0.0000',
  attributes_price_letters_free int(4) NOT NULL default '0',
  attributes_required tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (products_attributes_id),
  KEY idx_id_options_id_values_zen (products_id,options_id,options_values_id),
  KEY idx_opt_sort_order_zen (products_options_sort_order)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'products_attributes_download'
#

DROP TABLE IF EXISTS products_attributes_download;
CREATE TABLE products_attributes_download (
  products_attributes_id int(11) NOT NULL default '0',
  products_attributes_filename varchar(255) NOT NULL default '',
  products_attributes_maxdays int(2) default '0',
  products_attributes_maxcount int(2) default '0',
  PRIMARY KEY  (products_attributes_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'products_description'
#

DROP TABLE IF EXISTS products_description;
CREATE TABLE products_description (
  products_id int(11) NOT NULL auto_increment,
  language_id int(11) NOT NULL default '1',
  products_name varchar(64) NOT NULL default '',
  products_description text,
  products_url varchar(255) default NULL,
  products_viewed int(5) default '0',
  PRIMARY KEY  (products_id,language_id),
  KEY idx_products_name_zen (products_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'products_discount_quantity'
#
DROP TABLE IF EXISTS products_discount_quantity;
CREATE TABLE products_discount_quantity (
  discount_id int(4) NOT NULL default '0',
  products_id int(11) NOT NULL default '0',
  discount_qty float NOT NULL default '0',
  discount_price decimal(15,4) NOT NULL default '0.0000',
  KEY idx_id_qty_zen (products_id,discount_qty)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'products_notifications'
#

DROP TABLE IF EXISTS products_notifications;
CREATE TABLE products_notifications (
  products_id int(11) NOT NULL default '0',
  customers_id int(11) NOT NULL default '0',
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY  (products_id,customers_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'products_options'
#

DROP TABLE IF EXISTS products_options;
CREATE TABLE products_options (
  products_options_id int(11) NOT NULL default '0',
  language_id int(11) NOT NULL default '1',
  products_options_name varchar(32) NOT NULL default '',
  products_options_sort_order int(11) NOT NULL default '0',
  products_options_type int(5) NOT NULL default '0',
  products_options_length smallint(2) NOT NULL default '32',
  products_options_comment varchar(64) default NULL,
  products_options_size smallint(2) NOT NULL default '32',
  products_options_images_per_row int(2) default '5',
  products_options_images_style int(1) default '0',
  products_options_rows smallint(2) NOT NULL default '1',
  PRIMARY KEY  (products_options_id,language_id),
  KEY idx_lang_id_zen (language_id),
  KEY idx_products_options_sort_order_zen (products_options_sort_order),
  KEY idx_products_options_name_zen (products_options_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'products_options_types'
#

DROP TABLE IF EXISTS products_options_types;
CREATE TABLE products_options_types (
  products_options_types_id int(11) NOT NULL default '0',
  language_id int(11) NOT NULL default '1',
  products_options_types_name varchar(32) default NULL,
  PRIMARY KEY  (products_options_types_id,language_id),    
  KEY idx_orders_status_name_zen (products_options_types_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT='Track products_options_types';

# --------------------------------------------------------

#
# Table structure for table 'products_options_values'
#

DROP TABLE IF EXISTS products_options_values;
CREATE TABLE products_options_values (
  products_options_values_id int(11) NOT NULL default '0',
  language_id int(11) NOT NULL default '1',
  products_options_values_name varchar(64) NOT NULL default '',
  products_options_values_sort_order int(11) NOT NULL default '0',
  PRIMARY KEY (products_options_values_id,language_id),
  KEY idx_products_options_values_name_zen (products_options_values_name),
  KEY idx_products_options_values_sort_order_zen (products_options_values_sort_order)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'products_options_values_to_products_options'
#

DROP TABLE IF EXISTS products_options_values_to_products_options;
CREATE TABLE products_options_values_to_products_options (
  products_options_values_to_products_options_id int(11) NOT NULL auto_increment,
  products_options_id int(11) NOT NULL default '0',
  products_options_values_id int(11) NOT NULL default '0',
  PRIMARY KEY  (products_options_values_to_products_options_id),
  KEY idx_products_options_id_zen (products_options_id),
  KEY idx_products_options_values_id_zen (products_options_values_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'products_to_categories'
#

DROP TABLE IF EXISTS products_to_categories;
CREATE TABLE products_to_categories (
  products_id int(11) NOT NULL default '0',
  categories_id int(11) NOT NULL default '0',
  PRIMARY KEY  (products_id,categories_id),
  KEY idx_cat_prod_id_zen (categories_id,products_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'project_version'
#

DROP TABLE IF EXISTS project_version;
CREATE TABLE project_version (
  project_version_id tinyint(3) NOT NULL auto_increment,
  project_version_key varchar(40) NOT NULL default '',
  project_version_major varchar(20) NOT NULL default '',
  project_version_minor varchar(20) NOT NULL default '',
  project_version_patch1 varchar(20) NOT NULL default '',
  project_version_patch2 varchar(20) NOT NULL default '',
  project_version_patch1_source varchar(20) NOT NULL default '',
  project_version_patch2_source varchar(20) NOT NULL default '',
  project_version_comment varchar(250) NOT NULL default '',
  project_version_date_applied datetime NOT NULL default '0001-01-01 01:01:01',
  PRIMARY KEY  (project_version_id),
  UNIQUE KEY idx_project_version_key_zen (project_version_key)
) CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT='Database Version Tracking';


# --------------------------------------------------------

#
# Table structure for table 'project_version_history'
#
DROP TABLE IF EXISTS project_version_history;
CREATE TABLE project_version_history (
  project_version_id tinyint(3) NOT NULL auto_increment,
  project_version_key varchar(40) NOT NULL default '',
  project_version_major varchar(20) NOT NULL default '',
  project_version_minor varchar(20) NOT NULL default '',
  project_version_patch varchar(20) NOT NULL default '',
  project_version_comment varchar(250) NOT NULL default '',
  project_version_date_applied datetime NOT NULL default '0001-01-01 01:01:01',
  PRIMARY KEY  (project_version_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT='Database Version Tracking History';

# --------------------------------------------------------

#
# Table structure for table 'query_builder'
# This table is used by audiences.php for building data-extraction queries
#
DROP TABLE IF EXISTS query_builder;
CREATE TABLE query_builder (
  query_id int(11) NOT NULL auto_increment,
  query_category varchar(40) NOT NULL default '',
  query_name varchar(80) NOT NULL default '',
  query_description TEXT NOT NULL,
  query_string TEXT NOT NULL,
  query_keys_list TEXT NOT NULL,
  PRIMARY KEY  (query_id),
  UNIQUE KEY query_name (query_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT='Stores queries for re-use in Admin email and report modules';

# --------------------------------------------------------

#
# Table structure for table 'record_artists'
#

DROP TABLE IF EXISTS record_artists;
CREATE TABLE record_artists (
  artists_id int(11) NOT NULL auto_increment,
  artists_name varchar(32) NOT NULL default '',
  artists_image varchar(64) default NULL,
  date_added datetime default NULL,
  last_modified datetime default NULL,
  PRIMARY KEY  (artists_id),
  KEY idx_rec_artists_name_zen (artists_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'record_artists_info'
#

DROP TABLE IF EXISTS record_artists_info;
CREATE TABLE record_artists_info (
  artists_id int(11) NOT NULL default '0',
  languages_id int(11) NOT NULL default '0',
  artists_url varchar(255) NOT NULL default '',
  url_clicked int(5) NOT NULL default '0',
  date_last_click datetime default NULL,
  PRIMARY KEY  (artists_id,languages_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'record_company'
#

DROP TABLE IF EXISTS record_company;
CREATE TABLE record_company (
  record_company_id int(11) NOT NULL auto_increment,
  record_company_name varchar(32) NOT NULL default '',
  record_company_image varchar(64) default NULL,
  date_added datetime default NULL,
  last_modified datetime default NULL,
  PRIMARY KEY  (record_company_id),
  KEY idx_rec_company_name_zen (record_company_name)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'record_company_info'
#

DROP TABLE IF EXISTS record_company_info;
CREATE TABLE record_company_info (
  record_company_id int(11) NOT NULL default '0',
  languages_id int(11) NOT NULL default '0',
  record_company_url varchar(255) NOT NULL default '',
  url_clicked int(5) NOT NULL default '0',
  date_last_click datetime default NULL,
  PRIMARY KEY  (record_company_id,languages_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'reviews'
#

DROP TABLE IF EXISTS reviews;
CREATE TABLE reviews (
  reviews_id int(11) NOT NULL auto_increment,
  products_id int(11) NOT NULL default '0',
  customers_id int(11) default NULL,
  customers_name varchar(64) NOT NULL default '',
  reviews_rating int(1) default NULL,
  date_added datetime default NULL,
  last_modified datetime default NULL,
  reviews_read int(5) NOT NULL default '0',
  status int(1) NOT NULL default '1',
  PRIMARY KEY  (reviews_id),
  KEY idx_products_id_zen (products_id),
  KEY idx_customers_id_zen (customers_id),
  KEY idx_status_zen (status),
  KEY idx_date_added_zen (date_added)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'reviews_description'
#

DROP TABLE IF EXISTS reviews_description;
CREATE TABLE reviews_description (
  reviews_id int(11) NOT NULL default '0',
  languages_id int(11) NOT NULL default '0',
  reviews_text text NOT NULL,
  PRIMARY KEY  (reviews_id,languages_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'salemaker_sales'
#

DROP TABLE IF EXISTS salemaker_sales;
CREATE TABLE salemaker_sales (
  sale_id int(11) NOT NULL auto_increment,
  sale_status tinyint(4) NOT NULL default '0',
  sale_name varchar(30) NOT NULL default '',
  sale_deduction_value decimal(15,4) NOT NULL default '0.0000',
  sale_deduction_type tinyint(4) NOT NULL default '0',
  sale_pricerange_from decimal(15,4) NOT NULL default '0.0000',
  sale_pricerange_to decimal(15,4) NOT NULL default '0.0000',
  sale_specials_condition tinyint(4) NOT NULL default '0',
  sale_categories_selected text,
  sale_categories_all text,
  sale_date_start date NOT NULL default '0001-01-01',
  sale_date_end date NOT NULL default '0001-01-01',
  sale_date_added date NOT NULL default '0001-01-01',
  sale_date_last_modified date NOT NULL default '0001-01-01',
  sale_date_status_change date NOT NULL default '0001-01-01',
  PRIMARY KEY  (sale_id),
  KEY idx_sale_status_zen (sale_status),
  KEY idx_sale_date_start_zen (sale_date_start),
  KEY idx_sale_date_end_zen (sale_date_end)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'sessions'
#

DROP TABLE IF EXISTS sessions;
CREATE TABLE sessions (
  sesskey varchar(32) NOT NULL default '',
  expiry int(11) unsigned NOT NULL default '0',
  value mediumblob NOT NULL,
  PRIMARY KEY  (sesskey)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'specials'
#

DROP TABLE IF EXISTS specials;
CREATE TABLE specials (
  specials_id int(11) NOT NULL auto_increment,
  products_id int(11) NOT NULL default '0',
  specials_new_products_price decimal(15,4) NOT NULL default '0.0000',
  specials_date_added datetime default NULL,
  specials_last_modified datetime default NULL,
  expires_date date NOT NULL default '0001-01-01',
  date_status_change datetime default NULL,
  status int(1) NOT NULL default '1',
  specials_date_available date NOT NULL default '0001-01-01',
  PRIMARY KEY  (specials_id),
  KEY idx_status_zen (status),
  KEY idx_products_id_zen (products_id),
  KEY idx_date_avail_zen (specials_date_available),
  KEY idx_expires_date_zen (expires_date)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'tax_class'
#

DROP TABLE IF EXISTS tax_class;
CREATE TABLE tax_class (
  tax_class_id int(11) NOT NULL auto_increment,
  tax_class_title varchar(32) NOT NULL default '',
  tax_class_description varchar(255) NOT NULL default '',
  last_modified datetime default NULL,
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY  (tax_class_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'tax_rates'
#

DROP TABLE IF EXISTS tax_rates;
CREATE TABLE tax_rates (
  tax_rates_id int(11) NOT NULL auto_increment,
  tax_zone_id int(11) NOT NULL default '0',
  tax_class_id int(11) NOT NULL default '0',
  tax_priority int(5) default '1',
  tax_rate decimal(7,4) NOT NULL default '0.0000',
  tax_description varchar(255) NOT NULL default '',
  last_modified datetime default NULL,
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY  (tax_rates_id),
  KEY idx_tax_zone_id_zen (tax_zone_id),
  KEY idx_tax_class_id_zen (tax_class_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'template_select'
#

DROP TABLE IF EXISTS template_select;
CREATE TABLE template_select (
  template_id int(11) NOT NULL auto_increment,
  template_dir varchar(64) NOT NULL default '',
  template_language varchar(64) NOT NULL default '0',
  PRIMARY KEY  (template_id),
  KEY idx_tpl_lang_zen (template_language)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------


#
# Table structure for table 'whos_online'
#

DROP TABLE IF EXISTS whos_online;
CREATE TABLE whos_online (
  customer_id int(11) default NULL,
  full_name varchar(64) NOT NULL default '',
  session_id varchar(128) NOT NULL default '',
  ip_address varchar(15) NOT NULL default '',
  time_entry varchar(14) NOT NULL default '',
  time_last_click varchar(14) NOT NULL default '',
  last_page_url varchar(255) NOT NULL default '',
  host_address text NOT NULL,
  user_agent varchar(255) NOT NULL default '',
  KEY idx_ip_address_zen (ip_address),
  KEY idx_session_id_zen (session_id),
  KEY idx_customer_id_zen (customer_id),
  KEY idx_time_entry_zen (time_entry),
  KEY idx_time_last_click_zen (time_last_click),
  KEY idx_last_page_url_zen (last_page_url)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'zones'
#

DROP TABLE IF EXISTS zones;
CREATE TABLE zones (
  zone_id int(11) NOT NULL auto_increment,
  zone_country_id int(11) NOT NULL default '0',
  zone_code varchar(32) NOT NULL default '',
  zone_name varchar(32) NOT NULL default '',
  PRIMARY KEY  (zone_id),
  KEY idx_zone_country_id_zen (zone_country_id),
  KEY idx_zone_code_zen (zone_code)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------

#
# Table structure for table 'zones_to_geo_zones'
#

DROP TABLE IF EXISTS zones_to_geo_zones;
CREATE TABLE zones_to_geo_zones (
  association_id int(11) NOT NULL auto_increment,
  zone_country_id int(11) NOT NULL default '0',
  zone_id int(11) default NULL,
  geo_zone_id int(11) default NULL,
  last_modified datetime default NULL,
  date_added datetime NOT NULL default '0001-01-01 00:00:00',
  PRIMARY KEY  (association_id),
  KEY idx_zones_zen (geo_zone_id,zone_country_id,zone_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;


#
# Database table for customers_wishlist
#

DROP TABLE IF EXISTS customers_wishlist;
CREATE TABLE customers_wishlist (
  products_id int(13) NOT NULL default '0',
  customers_id int(13) NOT NULL default '0',
  products_model varchar(13) default NULL,
  products_name varchar(64) NOT NULL default '',
  products_price decimal(8,2) NOT NULL default '0.00',
  final_price decimal(8,2) NOT NULL default '0.00',
  products_quantity int(2) NOT NULL default '0',
  wishlist_name varchar(64) default NULL
) CHARACTER SET utf8 COLLATE utf8_general_ci;

#
# Database table for products_weight
#


DROP TABLE IF EXISTS products_weight;
CREATE TABLE products_weight (
  weight_id smallint(5) NOT NULL auto_increment,
  value FLOAT( 13, 8 )  NULL DEFAULT NULL,
  PRIMARY KEY  (weight_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;


#
# Database table for products_weight_information
#

DROP TABLE IF EXISTS products_weight_information;
CREATE TABLE products_weight_information (
  weight_information_id smallint(5) NOT NULL auto_increment,
  language_id INT( 11 )  NOT NULL DEFAULT '1',
  weight_id INT( 11 )  NOT NULL DEFAULT '1',
  weight_name VARCHAR( 64 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY  (weight_information_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

#
# Database table for products_valuation
#

DROP TABLE IF EXISTS products_valuation;
CREATE TABLE products_valuation (
  valuation_id smallint(5) NOT NULL auto_increment,
  keyword VARCHAR( 64 )  CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY  (valuation_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;

#
# Database table for products_valuation_information
#

DROP TABLE IF EXISTS products_valuation_information;
CREATE TABLE products_valuation_information (
  valuation_information_id smallint(5) NOT NULL auto_increment,
  valuation_id INT( 11 )  NOT NULL DEFAULT '1',
  language_id INT( 11 )  NOT NULL DEFAULT '1',
  valuation_name VARCHAR( 64 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY  (valuation_information_id)
) CHARACTER SET utf8 COLLATE utf8_general_ci;


DROP TABLE IF EXISTS product_types_information;
CREATE TABLE IF NOT EXISTS product_types_information (
  types_information_id smallint(5) NOT NULL AUTO_INCREMENT,
  language_id int(11) NOT NULL DEFAULT '1',
  type_id int(11) NOT NULL DEFAULT '1',
  type_name varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (types_information_id)
)CHARACTER SET utf8 COLLATE utf8_general_ci;
 
 DROP TABLE IF EXISTS testimonials_manager;
 CREATE TABLE IF NOT EXISTS testimonials_manager (
  `testimonials_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '0',
  `testimonials_title` varchar(64) NOT NULL DEFAULT '',
  `testimonials_url` varchar(255) DEFAULT NULL,
  `testimonials_name` text NOT NULL,
  `testimonials_image` varchar(254) NOT NULL DEFAULT '',
  `testimonials_html_text` text,
  `testimonials_mail` text NOT NULL,
  `testimonials_company` varchar(255) DEFAULT NULL,
  `testimonials_city` varchar(255) DEFAULT NULL,
  `testimonials_country` varchar(255) DEFAULT NULL,
  `testimonials_show_email` char(1) DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`testimonials_id`)
)  CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE IF NOT EXISTS `subscribers` (
  `subscriber_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) DEFAULT NULL,
  `email_address` varchar(96) NOT NULL DEFAULT '',
  `email_format` varchar(4) NOT NULL DEFAULT 'TEXT',
  `confirmed` varchar(8) DEFAULT NULL,
  `subscribed_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`subscriber_id`),
  UNIQUE KEY `email_address` (`email_address`)
)  CHARACTER SET utf8 COLLATE utf8_general_ci;

INSERT INTO  testimonials_manager  VALUES (1, 1, 'Great', '', 'Clyde Designs', '', 'This is just a test submission to show you how it looks, great, eh?', 'clyde@mysticmountainnaturals.com', NULL, NULL, NULL, 0, 1, now(), NULL);

# data
INSERT INTO template_select VALUES (1, 'classic', '0');

# 1 - Default, 2 - USA, 3 - Spain, 4 - Singapore, 5 - Germany, 6 - UK/GB, 7 - China
INSERT INTO address_format VALUES (1, '$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country','$city / $country');
INSERT INTO address_format VALUES (2, '$firstname $lastname$cr$streets$cr$city, $state    $postcode$cr$country','$city, $state / $country');
INSERT INTO address_format VALUES (3, '$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country','$state / $country');
INSERT INTO address_format VALUES (4, '$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country', '$postcode / $country');
INSERT INTO address_format VALUES (5, '$firstname $lastname$cr$streets$cr$postcode $city$cr$country','$city / $country');
INSERT INTO address_format VALUES (6, '$firstname $lastname$cr$streets$cr$city$cr$state$cr$postcode$cr$country','$postcode / $country');
INSERT INTO address_format VALUES (7, '$postcode$cr$country $state $city$cr$streets$cr$company$cr$firstname $lastname','$city / $country');

INSERT INTO admin VALUES (1, 'Admin', 'admin@localhost', '351683ea4e19efe34874b501fdbf9792:9b', 1);

INSERT INTO banners (banners_id, banners_title, banners_url, banners_image, banners_group, banners_html_text, expires_impressions, expires_date, date_scheduled, date_added, date_status_change, status, banners_open_new_windows, banners_on_ssl, banners_sort_order) VALUES
(3, 'Joy Cart the art of e-commerce', 'http://www.zencart-ec.com', 'banners/125x125_zen_logo.gif', 'SideBox-Banners', '', 0, NULL, NULL, '2004-01-11 20:59:12', NULL, 1, 1, 1, 0),
(4, '还考虑什么? 现在就装一个吧!', 'http://www.zencart-ec.com', 'banners/think_anim.gif', 'Wide-Banners', '', 0, NULL, NULL, '2004-01-12 20:53:18', NULL, 1, 1, 1, 0),
(5, 'Joy Cart the art of e-commerce', 'http://www.zencart-ec.com', 'banners/bw_zen_88wide.gif', 'BannersAll', '', 0, NULL, NULL, '2005-05-13 10:54:38', NULL, 1, 1, 1, 10),
(6, '立即注册PayPal并开始接受信用卡付款!', 'https://www.paypal.com/c2/mrb/pal=GR5QUVVL9AFGN&MRB=R-4DM17246PS436904F', 'banners/cardsvcs_468x60.gif', 'Wide-Banners', '', 0, NULL, NULL, '2006-03-13 11:02:43', NULL, 1, 1, 1, 0),
(8, 'eStart Your Web Store with Joy Cart', 'http://www.zencart-ec.com/', 'banners/tall-book.gif', 'SideBox-Banner2', '', 0, NULL, NULL, '2007-02-10 00:00:00', '2010-09-03 11:50:24', 1, 1, 1, 1),
(9, '幻灯片广告2', 'http://www.zencart-ec.com/', 'banners/flash_banner2.jpg', 'slidebanner', '', 0, NULL, NULL, '2005-12-10 00:00:00', '2010-09-07 17:29:55', 1, 1, 1, 15),
(10, 'text', '####', '', 'indexr', '<table width="100%" height="250" border="0" cellpadding="0" cellspacing="0">\r\n  <tr>\r\n    <td align="right" valign="top"><img src="images/banners/r_banner.jpg"></td>\r\n  </tr>\r\n  <tr>\r\n    <td align="right" valign="bottom"><img src="images/banners/r_banner1.jpg"></td>\r\n  </tr>\r\n</table>', 0, NULL, NULL, '2010-09-03 15:19:25', NULL, 1, 1, 1, 0),
(11, '幻灯片广告1', 'http://www.zencart-ec.com/', 'banners/flash_banner1.jpg', 'slidebanner', '', 0, NULL, NULL, '2010-09-08 10:53:56', NULL, 1, 0, 1, 0);




#---------------------------------------
#
#
#



 alter table products add weight_id int  NULL DEFAULT '0' ;
 

  
#---------------------------------------
#在商品中增加数量ID
#
#

 alter table products add valuation_id int  NULL DEFAULT '0' ;
 

 
#---------------------------------------
#增加商品重量配置
#
#
 
 
INSERT INTO products_weight (weight_id, value) VALUES
(1, 1000.00000000);
INSERT INTO products_weight (weight_id, value) VALUES
(2, 1.00000000);
INSERT INTO products_weight (weight_id, value) VALUES
(3, 453.59237671);


INSERT INTO products_weight_information (weight_information_id, language_id, weight_id, weight_name) VALUES
(5, 1, 1, 'KG');
INSERT INTO products_weight_information (weight_information_id, language_id, weight_id, weight_name) VALUES
(6, 2, 1, '千克');
INSERT INTO products_weight_information (weight_information_id, language_id, weight_id, weight_name) VALUES
(7, 1, 2, 'g');
INSERT INTO products_weight_information (weight_information_id, language_id, weight_id, weight_name) VALUES
(8, 2, 2, '克');
INSERT INTO products_weight_information (weight_information_id, language_id, weight_id, weight_name) VALUES
(9, 2, 3, '磅');
INSERT INTO products_weight_information (weight_information_id, language_id, weight_id, weight_name) VALUES
(10, 1, 3, 'Pound');
 
#---------------------------------------
#增加商品数量配置
#
#
INSERT INTO products_valuation (valuation_id, keyword) VALUES
(1, 'BOX');
INSERT INTO products_valuation (valuation_id, keyword) VALUES
(2, 'PIECES');
INSERT INTO products_valuation (valuation_id, keyword) VALUES
(3, 'A');

INSERT INTO products_valuation_information (valuation_information_id, valuation_id, language_id, valuation_name) VALUES
(1, 1, 1, 'Box');
INSERT INTO products_valuation_information (valuation_information_id, valuation_id, language_id, valuation_name) VALUES
(2, 1, 2, '箱');
INSERT INTO products_valuation_information (valuation_information_id, valuation_id, language_id, valuation_name) VALUES
(3, 2, 1, 'Pieces');
INSERT INTO products_valuation_information (valuation_information_id, valuation_id, language_id, valuation_name) VALUES
(4, 2, 2, '件');
INSERT INTO products_valuation_information (valuation_information_id, valuation_id, language_id, valuation_name) VALUES
(5, 3, 2, '个');
INSERT INTO products_valuation_information (valuation_information_id, valuation_id, language_id, valuation_name) VALUES
(6, 3, 1, 'A');

#---------------------------------------
#
#
# 



  INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_NAME_TITLE' ,'STORE_NAME' ,'Joy Cart 基础版' ,'LANGUAGES_STORE_NAME_DESCRIPTION' ,1 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_OWNER_TITLE' ,'STORE_OWNER' ,'Joy Cart 基础版' ,'LANGUAGES_STORE_OWNER_DESCRIPTION' ,1 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_COUNTRY_TITLE' ,'STORE_COUNTRY' ,'44' ,'LANGUAGES_STORE_COUNTRY_DESCRIPTION' ,1 ,6 ,now() ,'zen_get_country_name','zen_cfg_pull_down_country_list(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_ZONE_TITLE' ,'STORE_ZONE' ,'67' ,'LANGUAGES_STORE_ZONE_DESCRIPTION' ,1 ,7 ,now() ,'zen_cfg_get_zone_name','zen_cfg_pull_down_zone_list(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EXPECTED_PRODUCTS_SORT_TITLE' ,'EXPECTED_PRODUCTS_SORT' ,'desc' ,'LANGUAGES_EXPECTED_PRODUCTS_SORT_DESCRIPTION' ,1 ,8 ,now() ,'','zen_cfg_select_option(array(\'asc\', \'desc\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EXPECTED_PRODUCTS_FIELD_TITLE' ,'EXPECTED_PRODUCTS_FIELD' ,'date_expected' ,'LANGUAGES_EXPECTED_PRODUCTS_FIELD_DESCRIPTION' ,1 ,9 ,now() ,'','zen_cfg_select_option(array(\'products_name\', \'date_expected\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_USE_DEFAULT_LANGUAGE_CURRENCY_TITLE' ,'USE_DEFAULT_LANGUAGE_CURRENCY' ,'true' ,'LANGUAGES_USE_DEFAULT_LANGUAGE_CURRENCY_DESCRIPTION' ,1 ,10 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_LANGUAGE_DEFAULT_SELECTOR_TITLE' ,'LANGUAGE_DEFAULT_SELECTOR' ,'Default' ,'LANGUAGES_LANGUAGE_DEFAULT_SELECTOR_DESCRIPTION' ,1 ,11 ,now() ,'','zen_cfg_select_option(array(\'Default\', \'Browser\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEARCH_ENGINE_FRIENDLY_URLS_TITLE' ,'SEARCH_ENGINE_FRIENDLY_URLS' ,'false' ,'LANGUAGES_SEARCH_ENGINE_FRIENDLY_URLS_DESCRIPTION' ,6 ,12 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_CART_TITLE' ,'DISPLAY_CART' ,'true' ,'LANGUAGES_DISPLAY_CART_DESCRIPTION' ,1 ,14 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ADVANCED_SEARCH_DEFAULT_OPERATOR_TITLE' ,'ADVANCED_SEARCH_DEFAULT_OPERATOR' ,'and' ,'LANGUAGES_ADVANCED_SEARCH_DEFAULT_OPERATOR_DESCRIPTION' ,1 ,17 ,now() ,'','zen_cfg_select_option(array(\'and\', \'or\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_NAME_ADDRESS_TITLE' ,'STORE_NAME_ADDRESS' ,'Store Name Address Country Phone' ,'LANGUAGES_STORE_NAME_ADDRESS_DESCRIPTION' ,1 ,18 ,now() ,'','zen_cfg_textarea(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_COUNTS_TITLE' ,'SHOW_COUNTS' ,'true' ,'LANGUAGES_SHOW_COUNTS_DESCRIPTION' ,1 ,19 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TAX_DECIMAL_PLACES_TITLE' ,'TAX_DECIMAL_PLACES' ,'0' ,'LANGUAGES_TAX_DECIMAL_PLACES_DESCRIPTION' ,1 ,20 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_PRICE_WITH_TAX_TITLE' ,'DISPLAY_PRICE_WITH_TAX' ,'false' ,'LANGUAGES_DISPLAY_PRICE_WITH_TAX_DESCRIPTION' ,1 ,21 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_PRICE_WITH_TAX_ADMIN_TITLE' ,'DISPLAY_PRICE_WITH_TAX_ADMIN' ,'false' ,'LANGUAGES_DISPLAY_PRICE_WITH_TAX_ADMIN_DESCRIPTION' ,1 ,21 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_PRODUCT_TAX_BASIS_TITLE' ,'STORE_PRODUCT_TAX_BASIS' ,'Shipping' ,'LANGUAGES_STORE_PRODUCT_TAX_BASIS_DESCRIPTION' ,1 ,21 ,now() ,'','zen_cfg_select_option(array(\'Shipping\', \'Billing\', \'Store\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_SHIPPING_TAX_BASIS_TITLE' ,'STORE_SHIPPING_TAX_BASIS' ,'Shipping' ,'LANGUAGES_STORE_SHIPPING_TAX_BASIS_DESCRIPTION' ,1 ,21 ,now() ,'','zen_cfg_select_option(array(\'Shipping\', \'Billing\', \'Store\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_TAX_DISPLAY_STATUS_TITLE' ,'STORE_TAX_DISPLAY_STATUS' ,'0' ,'LANGUAGES_STORE_TAX_DISPLAY_STATUS_DESCRIPTION' ,1 ,21 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SPLIT_TAX_CHECKOUT_TITLE' ,'SHOW_SPLIT_TAX_CHECKOUT' ,'false' ,'LANGUAGES_SHOW_SPLIT_TAX_CHECKOUT_DESCRIPTION' ,1 ,22 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SESSION_TIMEOUT_ADMIN_TITLE' ,'SESSION_TIMEOUT_ADMIN' ,'3600' ,'LANGUAGES_SESSION_TIMEOUT_ADMIN_DESCRIPTION' ,1 ,40 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_GLOBAL_SET_TIME_LIMIT_TITLE' ,'GLOBAL_SET_TIME_LIMIT' ,'60' ,'LANGUAGES_GLOBAL_SET_TIME_LIMIT_DESCRIPTION' ,1 ,42 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_VERSION_UPDATE_IN_HEADER_TITLE' ,'SHOW_VERSION_UPDATE_IN_HEADER' ,'false' ,'LANGUAGES_SHOW_VERSION_UPDATE_IN_HEADER_DESCRIPTION' ,1 ,44 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_STATUS_TITLE' ,'STORE_STATUS' ,'0' ,'LANGUAGES_STORE_STATUS_DESCRIPTION' ,1 ,25 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_SERVER_UPTIME_TITLE' ,'DISPLAY_SERVER_UPTIME' ,'true' ,'LANGUAGES_DISPLAY_SERVER_UPTIME_DESCRIPTION' ,1 ,46 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MISSING_PAGE_CHECK_TITLE' ,'MISSING_PAGE_CHECK' ,'Page Not Found' ,'LANGUAGES_MISSING_PAGE_CHECK_DESCRIPTION' ,1 ,48 ,now() ,'','zen_cfg_select_option(array(\'On\', \'Off\', \'Page Not Found\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CURL_PROXY_REQUIRED_TITLE' ,'CURL_PROXY_REQUIRED' ,'False' ,'LANGUAGES_CURL_PROXY_REQUIRED_DESCRIPTION' ,1 ,50 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CURL_PROXY_SERVER_DETAILS_TITLE' ,'CURL_PROXY_SERVER_DETAILS' ,'' ,'LANGUAGES_CURL_PROXY_SERVER_DETAILS_DESCRIPTION' ,1 ,51 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_HTML_EDITOR_PREFERENCE_TITLE' ,'HTML_EDITOR_PREFERENCE' ,'FCKEDITOR' ,'LANGUAGES_HTML_EDITOR_PREFERENCE_DESCRIPTION' ,1 ,110 ,now() ,'','zen_cfg_pull_down_htmleditors(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PHPBB_LINKS_ENABLED_TITLE' ,'PHPBB_LINKS_ENABLED' ,'' ,'LANGUAGES_PHPBB_LINKS_ENABLED_DESCRIPTION' ,1 ,120 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_COUNTS_ADMIN_TITLE' ,'SHOW_COUNTS_ADMIN' ,'true' ,'LANGUAGES_SHOW_COUNTS_ADMIN_DESCRIPTION' ,1 ,19 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CURRENCY_UPLIFT_RATIO_TITLE' ,'CURRENCY_UPLIFT_RATIO' ,'1.05' ,'LANGUAGES_CURRENCY_UPLIFT_RATIO_DESCRIPTION' ,1 ,55 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_FIRST_NAME_MIN_LENGTH_TITLE' ,'ENTRY_FIRST_NAME_MIN_LENGTH' ,'2' ,'LANGUAGES_ENTRY_FIRST_NAME_MIN_LENGTH_DESCRIPTION' ,2 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_LAST_NAME_MIN_LENGTH_TITLE' ,'ENTRY_LAST_NAME_MIN_LENGTH' ,'1' ,'LANGUAGES_ENTRY_LAST_NAME_MIN_LENGTH_DESCRIPTION' ,2 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_DOB_MIN_LENGTH_TITLE' ,'ENTRY_DOB_MIN_LENGTH' ,'10' ,'LANGUAGES_ENTRY_DOB_MIN_LENGTH_DESCRIPTION' ,2 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_EMAIL_ADDRESS_MIN_LENGTH_TITLE' ,'ENTRY_EMAIL_ADDRESS_MIN_LENGTH' ,'6' ,'LANGUAGES_ENTRY_EMAIL_ADDRESS_MIN_LENGTH_DESCRIPTION' ,2 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_STREET_ADDRESS_MIN_LENGTH_TITLE' ,'ENTRY_STREET_ADDRESS_MIN_LENGTH' ,'4' ,'LANGUAGES_ENTRY_STREET_ADDRESS_MIN_LENGTH_DESCRIPTION' ,2 ,5 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_COMPANY_MIN_LENGTH_TITLE' ,'ENTRY_COMPANY_MIN_LENGTH' ,'0' ,'LANGUAGES_ENTRY_COMPANY_MIN_LENGTH_DESCRIPTION' ,2 ,6 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_POSTCODE_MIN_LENGTH_TITLE' ,'ENTRY_POSTCODE_MIN_LENGTH' ,'4' ,'LANGUAGES_ENTRY_POSTCODE_MIN_LENGTH_DESCRIPTION' ,2 ,7 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_CITY_MIN_LENGTH_TITLE' ,'ENTRY_CITY_MIN_LENGTH' ,'2' ,'LANGUAGES_ENTRY_CITY_MIN_LENGTH_DESCRIPTION' ,2 ,8 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_STATE_MIN_LENGTH_TITLE' ,'ENTRY_STATE_MIN_LENGTH' ,'2' ,'LANGUAGES_ENTRY_STATE_MIN_LENGTH_DESCRIPTION' ,2 ,9 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_TELEPHONE_MIN_LENGTH_TITLE' ,'ENTRY_TELEPHONE_MIN_LENGTH' ,'6' ,'LANGUAGES_ENTRY_TELEPHONE_MIN_LENGTH_DESCRIPTION' ,2 ,10 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_PASSWORD_MIN_LENGTH_TITLE' ,'ENTRY_PASSWORD_MIN_LENGTH' ,'6' ,'LANGUAGES_ENTRY_PASSWORD_MIN_LENGTH_DESCRIPTION' ,2 ,11 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_OWNER_MIN_LENGTH_TITLE' ,'CC_OWNER_MIN_LENGTH' ,'2' ,'LANGUAGES_CC_OWNER_MIN_LENGTH_DESCRIPTION' ,2 ,12 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_NUMBER_MIN_LENGTH_TITLE' ,'CC_NUMBER_MIN_LENGTH' ,'10' ,'LANGUAGES_CC_NUMBER_MIN_LENGTH_DESCRIPTION' ,2 ,13 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_CVV_MIN_LENGTH_TITLE' ,'CC_CVV_MIN_LENGTH' ,'3' ,'LANGUAGES_CC_CVV_MIN_LENGTH_DESCRIPTION' ,2 ,13 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_REVIEW_TEXT_MIN_LENGTH_TITLE' ,'REVIEW_TEXT_MIN_LENGTH' ,'1' ,'LANGUAGES_REVIEW_TEXT_MIN_LENGTH_DESCRIPTION' ,2 ,14 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MIN_DISPLAY_BESTSELLERS_TITLE' ,'MIN_DISPLAY_BESTSELLERS' ,'1' ,'LANGUAGES_MIN_DISPLAY_BESTSELLERS_DESCRIPTION' ,2 ,15 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MIN_DISPLAY_ALSO_PURCHASED_TITLE' ,'MIN_DISPLAY_ALSO_PURCHASED' ,'1' ,'LANGUAGES_MIN_DISPLAY_ALSO_PURCHASED_DESCRIPTION' ,2 ,16 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_NICK_MIN_LENGTH_TITLE' ,'ENTRY_NICK_MIN_LENGTH' ,'1' ,'LANGUAGES_ENTRY_NICK_MIN_LENGTH_DESCRIPTION' ,2 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_ADDRESS_BOOK_ENTRIES_TITLE' ,'MAX_ADDRESS_BOOK_ENTRIES' ,'5' ,'LANGUAGES_MAX_ADDRESS_BOOK_ENTRIES_DESCRIPTION' ,3 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_TITLE' ,'MAX_DISPLAY_SEARCH_RESULTS' ,'20' ,'LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_DESCRIPTION' ,3 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_PAGE_LINKS_TITLE' ,'MAX_DISPLAY_PAGE_LINKS' ,'5' ,'LANGUAGES_MAX_DISPLAY_PAGE_LINKS_DESCRIPTION' ,3 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_NEW_PRODUCTS_TITLE' ,'MAX_DISPLAY_NEW_PRODUCTS' ,'8' ,'LANGUAGES_MAX_DISPLAY_NEW_PRODUCTS_DESCRIPTION' ,3 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_FEATURED_TITLE' ,'MAX_DISPLAY_SEARCH_RESULTS_FEATURED' ,'8' ,'LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_FEATURED_DESCRIPTION' ,3 ,5 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SPECIAL_PRODUCTS_INDEX_TITLE' ,'MAX_DISPLAY_SPECIAL_PRODUCTS_INDEX' ,'8' ,'LANGUAGES_MAX_DISPLAY_SPECIAL_PRODUCTS_INDEX_DESCRIPTION' ,3 ,6 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_UPCOMING_PRODUCTS_TITLE' ,'MAX_DISPLAY_UPCOMING_PRODUCTS' ,'10' ,'LANGUAGES_MAX_DISPLAY_UPCOMING_PRODUCTS_DESCRIPTION' ,3 ,7 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SPECIAL_PRODUCTS_TITLE' ,'MAX_DISPLAY_SPECIAL_PRODUCTS' ,'18' ,'LANGUAGES_MAX_DISPLAY_SPECIAL_PRODUCTS_DESCRIPTION' ,3 ,8 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_PRODUCTS_NEW_TITLE' ,'MAX_DISPLAY_PRODUCTS_NEW' ,'18' ,'LANGUAGES_MAX_DISPLAY_PRODUCTS_NEW_DESCRIPTION' ,3 ,9 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_PRODUCTS_FEATURED_PRODUCTS_TITLE' ,'MAX_DISPLAY_PRODUCTS_FEATURED_PRODUCTS' ,'10' ,'LANGUAGES_MAX_DISPLAY_PRODUCTS_FEATURED_PRODUCTS_DESCRIPTION' ,3 ,29 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_PRODUCTS_ALL_TITLE' ,'MAX_DISPLAY_PRODUCTS_ALL' ,'10' ,'LANGUAGES_MAX_DISPLAY_PRODUCTS_ALL_DESCRIPTION' ,3 ,11 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_PRODUCTS_LISTING_TITLE' ,'MAX_DISPLAY_PRODUCTS_LISTING' ,'6' ,'LANGUAGES_MAX_DISPLAY_PRODUCTS_LISTING_DESCRIPTION' ,3 ,12 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_BESTSELLERS_TITLE' ,'MAX_DISPLAY_BESTSELLERS' ,'10' ,'LANGUAGES_MAX_DISPLAY_BESTSELLERS_DESCRIPTION' ,3 ,13 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_ALSO_PURCHASED_TITLE' ,'MAX_DISPLAY_ALSO_PURCHASED' ,'6' ,'LANGUAGES_MAX_DISPLAY_ALSO_PURCHASED_DESCRIPTION' ,3 ,14 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_RANDOM_SELECT_FEATURED_PRODUCTS_TITLE' ,'MAX_RANDOM_SELECT_FEATURED_PRODUCTS' ,'1' ,'LANGUAGES_MAX_RANDOM_SELECT_FEATURED_PRODUCTS_DESCRIPTION' ,3 ,15 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_RANDOM_SELECT_NEW_TITLE' ,'MAX_RANDOM_SELECT_NEW' ,'2' ,'LANGUAGES_MAX_RANDOM_SELECT_NEW_DESCRIPTION' ,3 ,16 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_RANDOM_SELECT_SPECIALS_TITLE' ,'MAX_RANDOM_SELECT_SPECIALS' ,'2' ,'LANGUAGES_MAX_RANDOM_SELECT_SPECIALS_DESCRIPTION' ,3 ,17 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_RANDOM_SELECT_REVIEWS_TITLE' ,'MAX_RANDOM_SELECT_REVIEWS' ,'1' ,'LANGUAGES_MAX_RANDOM_SELECT_REVIEWS_DESCRIPTION' ,3 ,18 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_NEW_REVIEWS_TITLE' ,'MAX_DISPLAY_NEW_REVIEWS' ,'6' ,'LANGUAGES_MAX_DISPLAY_NEW_REVIEWS_DESCRIPTION' ,3 ,19 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_MANUFACTURERS_LIST_TITLE' ,'MAX_MANUFACTURERS_LIST' ,'3' ,'LANGUAGES_MAX_MANUFACTURERS_LIST_DESCRIPTION' ,3 ,20 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_MANUFACTURERS_STATUS_TITLE' ,'PRODUCTS_MANUFACTURERS_STATUS' ,'1' ,'LANGUAGES_PRODUCTS_MANUFACTURERS_STATUS_DESCRIPTION' ,3 ,21 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_MUSIC_GENRES_LIST_TITLE' ,'MAX_MUSIC_GENRES_LIST' ,'3' ,'LANGUAGES_MAX_MUSIC_GENRES_LIST_DESCRIPTION' ,3 ,22 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_RECORD_COMPANY_LIST_TITLE' ,'MAX_RECORD_COMPANY_LIST' ,'3' ,'LANGUAGES_MAX_RECORD_COMPANY_LIST_DESCRIPTION' ,3 ,23 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_RECORD_COMPANY_NAME_LEN_TITLE' ,'MAX_DISPLAY_RECORD_COMPANY_NAME_LEN' ,'15' ,'LANGUAGES_MAX_DISPLAY_RECORD_COMPANY_NAME_LEN_DESCRIPTION' ,3 ,24 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_MUSIC_GENRES_NAME_LEN_TITLE' ,'MAX_DISPLAY_MUSIC_GENRES_NAME_LEN' ,'15' ,'LANGUAGES_MAX_DISPLAY_MUSIC_GENRES_NAME_LEN_DESCRIPTION' ,3 ,25 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_MANUFACTURER_NAME_LEN_TITLE' ,'MAX_DISPLAY_MANUFACTURER_NAME_LEN' ,'15' ,'LANGUAGES_MAX_DISPLAY_MANUFACTURER_NAME_LEN_DESCRIPTION' ,3 ,26 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_CATEGORIES_PER_ROW_TITLE' ,'MAX_DISPLAY_CATEGORIES_PER_ROW' ,'3' ,'LANGUAGES_MAX_DISPLAY_CATEGORIES_PER_ROW_DESCRIPTION' ,3 ,27 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX_TITLE' ,'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX' ,'6' ,'LANGUAGES_MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX_DESCRIPTION' ,3 ,28 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_ORDER_HISTORY_TITLE' ,'MAX_DISPLAY_ORDER_HISTORY' ,'10' ,'LANGUAGES_MAX_DISPLAY_ORDER_HISTORY_DESCRIPTION' ,3 ,29 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_CUSTOMER_TITLE' ,'MAX_DISPLAY_SEARCH_RESULTS_CUSTOMER' ,'20' ,'LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_CUSTOMER_DESCRIPTION' ,3 ,30 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_ORDERS_TITLE' ,'MAX_DISPLAY_SEARCH_RESULTS_ORDERS' ,'20' ,'LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_ORDERS_DESCRIPTION' ,3 ,31 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_REPORTS_TITLE' ,'MAX_DISPLAY_SEARCH_RESULTS_REPORTS' ,'20' ,'LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_REPORTS_DESCRIPTION' ,3 ,32 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_RESULTS_CATEGORIES_TITLE' ,'MAX_DISPLAY_RESULTS_CATEGORIES' ,'10' ,'LANGUAGES_MAX_DISPLAY_RESULTS_CATEGORIES_DESCRIPTION' ,3 ,33 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_ROW_LISTS_OPTIONS_TITLE' ,'MAX_ROW_LISTS_OPTIONS' ,'10' ,'LANGUAGES_MAX_ROW_LISTS_OPTIONS_DESCRIPTION' ,3 ,34 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_ROW_LISTS_ATTRIBUTES_CONTROLLER_TITLE' ,'MAX_ROW_LISTS_ATTRIBUTES_CONTROLLER' ,'30' ,'LANGUAGES_MAX_ROW_LISTS_ATTRIBUTES_CONTROLLER_DESCRIPTION' ,3 ,35 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_DOWNLOADS_MANAGER_TITLE' ,'MAX_DISPLAY_SEARCH_RESULTS_DOWNLOADS_MANAGER' ,'30' ,'LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_DOWNLOADS_MANAGER_DESCRIPTION' ,3 ,36 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_FEATURED_ADMIN_TITLE' ,'MAX_DISPLAY_SEARCH_RESULTS_FEATURED_ADMIN' ,'10' ,'LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_FEATURED_ADMIN_DESCRIPTION' ,3 ,37 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_NEW_PRODUCTS_LIMIT_TITLE' ,'SHOW_NEW_PRODUCTS_LIMIT' ,'0' ,'LANGUAGES_SHOW_NEW_PRODUCTS_LIMIT_DESCRIPTION' ,3 ,40 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'7\', \'14\', \'30\', \'60\', \'90\', \'120\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_LANGUAGE_FLAGS_COLUMNS_TITLE' ,'MAX_LANGUAGE_FLAGS_COLUMNS' ,'3' ,'LANGUAGES_MAX_LANGUAGE_FLAGS_COLUMNS_DESCRIPTION' ,3 ,50 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_FILE_UPLOAD_SIZE_TITLE' ,'MAX_FILE_UPLOAD_SIZE' ,'2048000' ,'LANGUAGES_MAX_FILE_UPLOAD_SIZE_DESCRIPTION' ,3 ,60 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_UPLOAD_FILENAME_EXTENSIONS_TITLE' ,'UPLOAD_FILENAME_EXTENSIONS' ,'jpg,jpeg,gif,png,eps,cdr,ai,pdf,tif,tiff,bmp,zip' ,'LANGUAGES_UPLOAD_FILENAME_EXTENSIONS_DESCRIPTION' ,3 ,61 ,now() ,'','zen_cfg_textarea(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_RESULTS_ORDERS_DETAILS_LISTING_TITLE' ,'MAX_DISPLAY_RESULTS_ORDERS_DETAILS_LISTING' ,'0' ,'LANGUAGES_MAX_DISPLAY_RESULTS_ORDERS_DETAILS_LISTING_DESCRIPTION' ,3 ,65 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_PAYPAL_IPN_TITLE' ,'MAX_DISPLAY_SEARCH_RESULTS_PAYPAL_IPN' ,'20' ,'LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_PAYPAL_IPN_DESCRIPTION' ,3 ,66 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_PRODUCTS_TO_CATEGORIES_COLUMNS_TITLE' ,'MAX_DISPLAY_PRODUCTS_TO_CATEGORIES_COLUMNS' ,'3' ,'LANGUAGES_MAX_DISPLAY_PRODUCTS_TO_CATEGORIES_COLUMNS_DESCRIPTION' ,3 ,70 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_EZPAGE_TITLE' ,'MAX_DISPLAY_SEARCH_RESULTS_EZPAGE' ,'20' ,'LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_EZPAGE_DESCRIPTION' ,3 ,71 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SMALL_IMAGE_WIDTH_TITLE' ,'SMALL_IMAGE_WIDTH' ,'150' ,'LANGUAGES_SMALL_IMAGE_WIDTH_DESCRIPTION' ,4 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SMALL_IMAGE_HEIGHT_TITLE' ,'SMALL_IMAGE_HEIGHT' ,'150' ,'LANGUAGES_SMALL_IMAGE_HEIGHT_DESCRIPTION' ,4 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_HEADING_IMAGE_WIDTH_TITLE' ,'HEADING_IMAGE_WIDTH' ,'57' ,'LANGUAGES_HEADING_IMAGE_WIDTH_DESCRIPTION' ,4 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_HEADING_IMAGE_HEIGHT_TITLE' ,'HEADING_IMAGE_HEIGHT' ,'2' ,'LANGUAGES_HEADING_IMAGE_HEIGHT_DESCRIPTION' ,4 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SUBCATEGORY_IMAGE_WIDTH_TITLE' ,'SUBCATEGORY_IMAGE_WIDTH' ,'100' ,'LANGUAGES_SUBCATEGORY_IMAGE_WIDTH_DESCRIPTION' ,4 ,5 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SUBCATEGORY_IMAGE_HEIGHT_TITLE' ,'SUBCATEGORY_IMAGE_HEIGHT' ,'57' ,'LANGUAGES_SUBCATEGORY_IMAGE_HEIGHT_DESCRIPTION' ,4 ,6 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CONFIG_CALCULATE_IMAGE_SIZE_TITLE' ,'CONFIG_CALCULATE_IMAGE_SIZE' ,'true' ,'LANGUAGES_CONFIG_CALCULATE_IMAGE_SIZE_DESCRIPTION' ,4 ,7 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_REQUIRED_TITLE' ,'IMAGE_REQUIRED' ,'true' ,'LANGUAGES_IMAGE_REQUIRED_DESCRIPTION' ,4 ,8 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_SHOPPING_CART_STATUS_TITLE' ,'IMAGE_SHOPPING_CART_STATUS' ,'1' ,'LANGUAGES_IMAGE_SHOPPING_CART_STATUS_DESCRIPTION' ,4 ,9 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_SHOPPING_CART_WIDTH_TITLE' ,'IMAGE_SHOPPING_CART_WIDTH' ,'50' ,'LANGUAGES_IMAGE_SHOPPING_CART_WIDTH_DESCRIPTION' ,4 ,10 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_SHOPPING_CART_HEIGHT_TITLE' ,'IMAGE_SHOPPING_CART_HEIGHT' ,'40' ,'LANGUAGES_IMAGE_SHOPPING_CART_HEIGHT_DESCRIPTION' ,4 ,11 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORY_ICON_IMAGE_WIDTH_TITLE' ,'CATEGORY_ICON_IMAGE_WIDTH' ,'57' ,'LANGUAGES_CATEGORY_ICON_IMAGE_WIDTH_DESCRIPTION' ,4 ,13 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORY_ICON_IMAGE_HEIGHT_TITLE' ,'CATEGORY_ICON_IMAGE_HEIGHT' ,'40' ,'LANGUAGES_CATEGORY_ICON_IMAGE_HEIGHT_DESCRIPTION' ,4 ,14 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SUBCATEGORY_IMAGE_TOP_WIDTH_TITLE' ,'SUBCATEGORY_IMAGE_TOP_WIDTH' ,'150' ,'LANGUAGES_SUBCATEGORY_IMAGE_TOP_WIDTH_DESCRIPTION' ,4 ,15 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SUBCATEGORY_IMAGE_TOP_HEIGHT_TITLE' ,'SUBCATEGORY_IMAGE_TOP_HEIGHT' ,'85' ,'LANGUAGES_SUBCATEGORY_IMAGE_TOP_HEIGHT_DESCRIPTION' ,4 ,16 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MEDIUM_IMAGE_WIDTH_TITLE' ,'MEDIUM_IMAGE_WIDTH' ,'300' ,'LANGUAGES_MEDIUM_IMAGE_WIDTH_DESCRIPTION' ,4 ,20 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MEDIUM_IMAGE_HEIGHT_TITLE' ,'MEDIUM_IMAGE_HEIGHT' ,'300' ,'LANGUAGES_MEDIUM_IMAGE_HEIGHT_DESCRIPTION' ,4 ,21 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_SUFFIX_MEDIUM_TITLE' ,'IMAGE_SUFFIX_MEDIUM' ,'_MED' ,'LANGUAGES_IMAGE_SUFFIX_MEDIUM_DESCRIPTION' ,4 ,22 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_SUFFIX_LARGE_TITLE' ,'IMAGE_SUFFIX_LARGE' ,'_LRG' ,'LANGUAGES_IMAGE_SUFFIX_LARGE_DESCRIPTION' ,4 ,23 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGES_AUTO_ADDED_TITLE' ,'IMAGES_AUTO_ADDED' ,'3' ,'LANGUAGES_IMAGES_AUTO_ADDED_DESCRIPTION' ,4 ,30 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_PRODUCT_LISTING_WIDTH_TITLE' ,'IMAGE_PRODUCT_LISTING_WIDTH' ,'150' ,'LANGUAGES_IMAGE_PRODUCT_LISTING_WIDTH_DESCRIPTION' ,4 ,40 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_PRODUCT_LISTING_HEIGHT_TITLE' ,'IMAGE_PRODUCT_LISTING_HEIGHT' ,'150' ,'LANGUAGES_IMAGE_PRODUCT_LISTING_HEIGHT_DESCRIPTION' ,4 ,41 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_PRODUCT_NEW_LISTING_WIDTH_TITLE' ,'IMAGE_PRODUCT_NEW_LISTING_WIDTH' ,'150' ,'LANGUAGES_IMAGE_PRODUCT_NEW_LISTING_WIDTH_DESCRIPTION' ,4 ,42 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_PRODUCT_NEW_LISTING_HEIGHT_TITLE' ,'IMAGE_PRODUCT_NEW_LISTING_HEIGHT' ,'150' ,'LANGUAGES_IMAGE_PRODUCT_NEW_LISTING_HEIGHT_DESCRIPTION' ,4 ,43 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_PRODUCT_NEW_WIDTH_TITLE' ,'IMAGE_PRODUCT_NEW_WIDTH' ,'150' ,'LANGUAGES_IMAGE_PRODUCT_NEW_WIDTH_DESCRIPTION' ,4 ,44 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_PRODUCT_NEW_HEIGHT_TITLE' ,'IMAGE_PRODUCT_NEW_HEIGHT' ,'150' ,'LANGUAGES_IMAGE_PRODUCT_NEW_HEIGHT_DESCRIPTION' ,4 ,45 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_FEATURED_PRODUCTS_LISTING_WIDTH_TITLE' ,'IMAGE_FEATURED_PRODUCTS_LISTING_WIDTH' ,'150' ,'LANGUAGES_IMAGE_FEATURED_PRODUCTS_LISTING_WIDTH_DESCRIPTION' ,4 ,46 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_FEATURED_PRODUCTS_LISTING_HEIGHT_TITLE' ,'IMAGE_FEATURED_PRODUCTS_LISTING_HEIGHT' ,'150' ,'LANGUAGES_IMAGE_FEATURED_PRODUCTS_LISTING_HEIGHT_DESCRIPTION' ,4 ,47 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_PRODUCT_ALL_LISTING_WIDTH_TITLE' ,'IMAGE_PRODUCT_ALL_LISTING_WIDTH' ,'150' ,'LANGUAGES_IMAGE_PRODUCT_ALL_LISTING_WIDTH_DESCRIPTION' ,4 ,48 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_PRODUCT_ALL_LISTING_HEIGHT_TITLE' ,'IMAGE_PRODUCT_ALL_LISTING_HEIGHT' ,'150' ,'LANGUAGES_IMAGE_PRODUCT_ALL_LISTING_HEIGHT_DESCRIPTION' ,4 ,49 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_IMAGE_NO_IMAGE_STATUS_TITLE' ,'PRODUCTS_IMAGE_NO_IMAGE_STATUS' ,'1' ,'LANGUAGES_PRODUCTS_IMAGE_NO_IMAGE_STATUS_DESCRIPTION' ,4 ,60 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_IMAGE_NO_IMAGE_TITLE' ,'PRODUCTS_IMAGE_NO_IMAGE' ,'no_picture.gif' ,'LANGUAGES_PRODUCTS_IMAGE_NO_IMAGE_DESCRIPTION' ,4 ,61 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PROPORTIONAL_IMAGES_STATUS_TITLE' ,'PROPORTIONAL_IMAGES_STATUS' ,'1' ,'LANGUAGES_PROPORTIONAL_IMAGES_STATUS_DESCRIPTION' ,4 ,75 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ACCOUNT_GENDER_TITLE' ,'ACCOUNT_GENDER' ,'true' ,'LANGUAGES_ACCOUNT_GENDER_DESCRIPTION' ,5 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ACCOUNT_DOB_TITLE' ,'ACCOUNT_DOB' ,'true' ,'LANGUAGES_ACCOUNT_DOB_DESCRIPTION' ,5 ,2 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ACCOUNT_COMPANY_TITLE' ,'ACCOUNT_COMPANY' ,'false' ,'LANGUAGES_ACCOUNT_COMPANY_DESCRIPTION' ,5 ,3 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ACCOUNT_SUBURB_TITLE' ,'ACCOUNT_SUBURB' ,'true' ,'LANGUAGES_ACCOUNT_SUBURB_DESCRIPTION' ,5 ,4 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ACCOUNT_STATE_TITLE' ,'ACCOUNT_STATE' ,'true' ,'LANGUAGES_ACCOUNT_STATE_DESCRIPTION' ,5 ,5 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ACCOUNT_STATE_DRAW_INITIAL_DROPDOWN_TITLE' ,'ACCOUNT_STATE_DRAW_INITIAL_DROPDOWN' ,'false' ,'LANGUAGES_ACCOUNT_STATE_DRAW_INITIAL_DROPDOWN_DESCRIPTION' ,5 ,5 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_CREATE_ACCOUNT_DEFAULT_COUNTRY_TITLE' ,'SHOW_CREATE_ACCOUNT_DEFAULT_COUNTRY' ,'223' ,'LANGUAGES_SHOW_CREATE_ACCOUNT_DEFAULT_COUNTRY_DESCRIPTION' ,5 ,6 ,now() ,'zen_get_country_name','zen_cfg_pull_down_country_list_none(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ACCOUNT_FAX_NUMBER_TITLE' ,'ACCOUNT_FAX_NUMBER' ,'true' ,'LANGUAGES_ACCOUNT_FAX_NUMBER_DESCRIPTION' ,5 ,10 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ACCOUNT_NEWSLETTER_STATUS_TITLE' ,'ACCOUNT_NEWSLETTER_STATUS' ,'1' ,'LANGUAGES_ACCOUNT_NEWSLETTER_STATUS_DESCRIPTION' ,5 ,45 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ACCOUNT_EMAIL_PREFERENCE_TITLE' ,'ACCOUNT_EMAIL_PREFERENCE' ,'0' ,'LANGUAGES_ACCOUNT_EMAIL_PREFERENCE_DESCRIPTION' ,5 ,46 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CUSTOMERS_PRODUCTS_NOTIFICATION_STATUS_TITLE' ,'CUSTOMERS_PRODUCTS_NOTIFICATION_STATUS' ,'1' ,'LANGUAGES_CUSTOMERS_PRODUCTS_NOTIFICATION_STATUS_DESCRIPTION' ,5 ,50 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CUSTOMERS_APPROVAL_TITLE' ,'CUSTOMERS_APPROVAL' ,'0' ,'LANGUAGES_CUSTOMERS_APPROVAL_DESCRIPTION' ,5 ,55 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CUSTOMERS_APPROVAL_AUTHORIZATION_TITLE' ,'CUSTOMERS_APPROVAL_AUTHORIZATION' ,'0' ,'LANGUAGES_CUSTOMERS_APPROVAL_AUTHORIZATION_DESCRIPTION' ,5 ,65 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CUSTOMERS_AUTHORIZATION_FILENAME_TITLE' ,'CUSTOMERS_AUTHORIZATION_FILENAME' ,'customers_authorization' ,'LANGUAGES_CUSTOMERS_AUTHORIZATION_FILENAME_DESCRIPTION' ,5 ,66 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CUSTOMERS_AUTHORIZATION_HEADER_OFF_TITLE' ,'CUSTOMERS_AUTHORIZATION_HEADER_OFF' ,'false' ,'LANGUAGES_CUSTOMERS_AUTHORIZATION_HEADER_OFF_DESCRIPTION' ,5 ,67 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CUSTOMERS_AUTHORIZATION_COLUMN_LEFT_OFF_TITLE' ,'CUSTOMERS_AUTHORIZATION_COLUMN_LEFT_OFF' ,'false' ,'LANGUAGES_CUSTOMERS_AUTHORIZATION_COLUMN_LEFT_OFF_DESCRIPTION' ,5 ,68 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CUSTOMERS_AUTHORIZATION_COLUMN_RIGHT_OFF_TITLE' ,'CUSTOMERS_AUTHORIZATION_COLUMN_RIGHT_OFF' ,'false' ,'LANGUAGES_CUSTOMERS_AUTHORIZATION_COLUMN_RIGHT_OFF_DESCRIPTION' ,5 ,69 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CUSTOMERS_AUTHORIZATION_FOOTER_OFF_TITLE' ,'CUSTOMERS_AUTHORIZATION_FOOTER_OFF' ,'false' ,'LANGUAGES_CUSTOMERS_AUTHORIZATION_FOOTER_OFF_DESCRIPTION' ,5 ,70 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CUSTOMERS_AUTHORIZATION_PRICES_OFF_TITLE' ,'CUSTOMERS_AUTHORIZATION_PRICES_OFF' ,'false' ,'LANGUAGES_CUSTOMERS_AUTHORIZATION_PRICES_OFF_DESCRIPTION' ,5 ,71 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CUSTOMERS_REFERRAL_STATUS_TITLE' ,'CUSTOMERS_REFERRAL_STATUS' ,'0' ,'LANGUAGES_CUSTOMERS_REFERRAL_STATUS_DESCRIPTION' ,5 ,80 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_INSTALLED_TITLE' ,'MODULE_PAYMENT_INSTALLED' ,'cod.php;freecharger.php;moneyorder.php;paypal.php' ,'LANGUAGES_MODULE_PAYMENT_INSTALLED_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_INSTALLED_TITLE' ,'MODULE_ORDER_TOTAL_INSTALLED' ,'ot_subtotal.php;ot_shipping.php;ot_coupon.php;ot_group_pricing.php;ot_tax.php;ot_loworderfee.php;ot_gv.php;ot_cod_fee.php;ot_total.php' ,'LANGUAGES_MODULE_ORDER_TOTAL_INSTALLED_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_INSTALLED_TITLE' ,'MODULE_SHIPPING_INSTALLED' ,'flat.php;freeoptions.php;freeshipper.php;item.php;perweightunit.php;storepickup.php;table.php;ups.php;usps.php;zones.php' ,'LANGUAGES_MODULE_SHIPPING_INSTALLED_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_CURRENCY_TITLE' ,'DEFAULT_CURRENCY' ,'CNY' ,'LANGUAGES_DEFAULT_CURRENCY_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_LANGUAGE_TITLE' ,'DEFAULT_LANGUAGE' ,'cn' ,'LANGUAGES_DEFAULT_LANGUAGE_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_ORDERS_STATUS_ID_TITLE' ,'DEFAULT_ORDERS_STATUS_ID' ,'1' ,'LANGUAGES_DEFAULT_ORDERS_STATUS_ID_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ADMIN_CONFIGURATION_KEY_ON_TITLE' ,'ADMIN_CONFIGURATION_KEY_ON' ,'0' ,'LANGUAGES_ADMIN_CONFIGURATION_KEY_ON_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHIPPING_ORIGIN_COUNTRY_TITLE' ,'SHIPPING_ORIGIN_COUNTRY' ,'44' ,'LANGUAGES_SHIPPING_ORIGIN_COUNTRY_DESCRIPTION' ,7 ,1 ,now() ,'zen_get_country_name','zen_cfg_pull_down_country_list(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHIPPING_ORIGIN_ZIP_TITLE' ,'SHIPPING_ORIGIN_ZIP' ,'NONE' ,'LANGUAGES_SHIPPING_ORIGIN_ZIP_DESCRIPTION' ,7 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHIPPING_MAX_WEIGHT_TITLE' ,'SHIPPING_MAX_WEIGHT' ,'50' ,'LANGUAGES_SHIPPING_MAX_WEIGHT_DESCRIPTION' ,7 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHIPPING_BOX_WEIGHT_TITLE' ,'SHIPPING_BOX_WEIGHT' ,'0:3' ,'LANGUAGES_SHIPPING_BOX_WEIGHT_DESCRIPTION' ,7 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHIPPING_BOX_PADDING_TITLE' ,'SHIPPING_BOX_PADDING' ,'10:0' ,'LANGUAGES_SHIPPING_BOX_PADDING_DESCRIPTION' ,7 ,5 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHIPPING_BOX_WEIGHT_DISPLAY_TITLE' ,'SHIPPING_BOX_WEIGHT_DISPLAY' ,'3' ,'LANGUAGES_SHIPPING_BOX_WEIGHT_DISPLAY_DESCRIPTION' ,7 ,15 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SHIPPING_ESTIMATOR_BUTTON_TITLE' ,'SHOW_SHIPPING_ESTIMATOR_BUTTON' ,'1' ,'LANGUAGES_SHOW_SHIPPING_ESTIMATOR_BUTTON_DESCRIPTION' ,7 ,20 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ORDER_COMMENTS_INVOICE_TITLE' ,'ORDER_COMMENTS_INVOICE' ,'1' ,'LANGUAGES_ORDER_COMMENTS_INVOICE_DESCRIPTION' ,7 ,25 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ORDER_COMMENTS_PACKING_SLIP_TITLE' ,'ORDER_COMMENTS_PACKING_SLIP' ,'1' ,'LANGUAGES_ORDER_COMMENTS_PACKING_SLIP_DESCRIPTION' ,7 ,26 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ORDER_WEIGHT_ZERO_STATUS_TITLE' ,'ORDER_WEIGHT_ZERO_STATUS' ,'0' ,'LANGUAGES_ORDER_WEIGHT_ZERO_STATUS_DESCRIPTION' ,7 ,15 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_IMAGE_TITLE' ,'PRODUCT_LIST_IMAGE' ,'1' ,'LANGUAGES_PRODUCT_LIST_IMAGE_DESCRIPTION' ,8 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_MANUFACTURER_TITLE' ,'PRODUCT_LIST_MANUFACTURER' ,'3' ,'LANGUAGES_PRODUCT_LIST_MANUFACTURER_DESCRIPTION' ,8 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_MODEL_TITLE' ,'PRODUCT_LIST_MODEL' ,'4' ,'LANGUAGES_PRODUCT_LIST_MODEL_DESCRIPTION' ,8 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_NAME_TITLE' ,'PRODUCT_LIST_NAME' ,'2' ,'LANGUAGES_PRODUCT_LIST_NAME_DESCRIPTION' ,8 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_PRICE_TITLE' ,'PRODUCT_LIST_PRICE' ,'3' ,'LANGUAGES_PRODUCT_LIST_PRICE_DESCRIPTION' ,8 ,5 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_QUANTITY_TITLE' ,'PRODUCT_LIST_QUANTITY' ,'0' ,'LANGUAGES_PRODUCT_LIST_QUANTITY_DESCRIPTION' ,8 ,6 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_WEIGHT_TITLE' ,'PRODUCT_LIST_WEIGHT' ,'0' ,'LANGUAGES_PRODUCT_LIST_WEIGHT_DESCRIPTION' ,8 ,7 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_LIST_PRICE_WIDTH_TITLE' ,'PRODUCTS_LIST_PRICE_WIDTH' ,'125' ,'LANGUAGES_PRODUCTS_LIST_PRICE_WIDTH_DESCRIPTION' ,8 ,8 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_FILTER_TITLE' ,'PRODUCT_LIST_FILTER' ,'1' ,'LANGUAGES_PRODUCT_LIST_FILTER_DESCRIPTION' ,8 ,9 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PREV_NEXT_BAR_LOCATION_TITLE' ,'PREV_NEXT_BAR_LOCATION' ,'3' ,'LANGUAGES_PREV_NEXT_BAR_LOCATION_DESCRIPTION' ,8 ,10 ,now() ,'','zen_cfg_select_option(array(\'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LISTING_DEFAULT_SORT_ORDER_TITLE' ,'PRODUCT_LISTING_DEFAULT_SORT_ORDER' ,'' ,'LANGUAGES_PRODUCT_LISTING_DEFAULT_SORT_ORDER_DESCRIPTION' ,8 ,15 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_PRICE_BUY_NOW_TITLE' ,'PRODUCT_LIST_PRICE_BUY_NOW' ,'2' ,'LANGUAGES_PRODUCT_LIST_PRICE_BUY_NOW_DESCRIPTION' ,8 ,20 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LISTING_MULTIPLE_ADD_TO_CART_TITLE' ,'PRODUCT_LISTING_MULTIPLE_ADD_TO_CART' ,'3' ,'LANGUAGES_PRODUCT_LISTING_MULTIPLE_ADD_TO_CART_DESCRIPTION' ,8 ,25 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_DESCRIPTION_TITLE' ,'PRODUCT_LIST_DESCRIPTION' ,'150' ,'LANGUAGES_PRODUCT_LIST_DESCRIPTION_DESCRIPTION' ,8 ,30 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_SORT_ORDER_ASCENDING_TITLE' ,'PRODUCT_LIST_SORT_ORDER_ASCENDING' ,'+' ,'LANGUAGES_PRODUCT_LIST_SORT_ORDER_ASCENDING_DESCRIPTION' ,8 ,40 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_SORT_ORDER_DESCENDING_TITLE' ,'PRODUCT_LIST_SORT_ORDER_DESCENDING' ,'-' ,'LANGUAGES_PRODUCT_LIST_SORT_ORDER_DESCENDING_DESCRIPTION' ,8 ,41 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_ALPHA_SORTER_TITLE' ,'PRODUCT_LIST_ALPHA_SORTER' ,'true' ,'LANGUAGES_PRODUCT_LIST_ALPHA_SORTER_DESCRIPTION' ,8 ,50 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_CATEGORIES_IMAGE_STATUS_TITLE' ,'PRODUCT_LIST_CATEGORIES_IMAGE_STATUS' ,'true' ,'LANGUAGES_PRODUCT_LIST_CATEGORIES_IMAGE_STATUS_DESCRIPTION' ,8 ,52 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_CATEGORIES_IMAGE_STATUS_TOP_TITLE' ,'PRODUCT_LIST_CATEGORIES_IMAGE_STATUS_TOP' ,'true' ,'LANGUAGES_PRODUCT_LIST_CATEGORIES_IMAGE_STATUS_TOP_DESCRIPTION' ,8 ,53 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_LIST_CATEGORY_ROW_STATUS_TITLE' ,'PRODUCT_LIST_CATEGORY_ROW_STATUS' ,'1' ,'LANGUAGES_PRODUCT_LIST_CATEGORY_ROW_STATUS_DESCRIPTION' ,8 ,60 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STOCK_CHECK_TITLE' ,'STOCK_CHECK' ,'true' ,'LANGUAGES_STOCK_CHECK_DESCRIPTION' ,9 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STOCK_LIMITED_TITLE' ,'STOCK_LIMITED' ,'true' ,'LANGUAGES_STOCK_LIMITED_DESCRIPTION' ,9 ,2 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STOCK_ALLOW_CHECKOUT_TITLE' ,'STOCK_ALLOW_CHECKOUT' ,'true' ,'LANGUAGES_STOCK_ALLOW_CHECKOUT_DESCRIPTION' ,9 ,3 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STOCK_MARK_PRODUCT_OUT_OF_STOCK_TITLE' ,'STOCK_MARK_PRODUCT_OUT_OF_STOCK' ,'***' ,'LANGUAGES_STOCK_MARK_PRODUCT_OUT_OF_STOCK_DESCRIPTION' ,9 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STOCK_REORDER_LEVEL_TITLE' ,'STOCK_REORDER_LEVEL' ,'5' ,'LANGUAGES_STOCK_REORDER_LEVEL_DESCRIPTION' ,9 ,5 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCTS_SOLD_OUT_TITLE' ,'SHOW_PRODUCTS_SOLD_OUT' ,'0' ,'LANGUAGES_SHOW_PRODUCTS_SOLD_OUT_DESCRIPTION' ,9 ,10 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCTS_SOLD_OUT_IMAGE_TITLE' ,'SHOW_PRODUCTS_SOLD_OUT_IMAGE' ,'1' ,'LANGUAGES_SHOW_PRODUCTS_SOLD_OUT_IMAGE_DESCRIPTION' ,9 ,11 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUANTITY_DECIMALS_TITLE' ,'QUANTITY_DECIMALS' ,'0' ,'LANGUAGES_QUANTITY_DECIMALS_DESCRIPTION' ,9 ,15 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SHOPPING_CART_DELETE_TITLE' ,'SHOW_SHOPPING_CART_DELETE' ,'3' ,'LANGUAGES_SHOW_SHOPPING_CART_DELETE_DESCRIPTION' ,9 ,20 ,now() ,'','zen_cfg_select_option(array(\'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SHOPPING_CART_UPDATE_TITLE' ,'SHOW_SHOPPING_CART_UPDATE' ,'3' ,'LANGUAGES_SHOW_SHOPPING_CART_UPDATE_DESCRIPTION' ,9 ,22 ,now() ,'','zen_cfg_select_option(array(\'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SHOPPING_CART_EMPTY_NEW_PRODUCTS_TITLE' ,'SHOW_SHOPPING_CART_EMPTY_NEW_PRODUCTS' ,'1' ,'LANGUAGES_SHOW_SHOPPING_CART_EMPTY_NEW_PRODUCTS_DESCRIPTION' ,9 ,30 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SHOPPING_CART_EMPTY_FEATURED_PRODUCTS_TITLE' ,'SHOW_SHOPPING_CART_EMPTY_FEATURED_PRODUCTS' ,'2' ,'LANGUAGES_SHOW_SHOPPING_CART_EMPTY_FEATURED_PRODUCTS_DESCRIPTION' ,9 ,31 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SHOPPING_CART_EMPTY_SPECIALS_PRODUCTS_TITLE' ,'SHOW_SHOPPING_CART_EMPTY_SPECIALS_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_SHOPPING_CART_EMPTY_SPECIALS_PRODUCTS_DESCRIPTION' ,9 ,32 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SHOPPING_CART_EMPTY_UPCOMING_TITLE' ,'SHOW_SHOPPING_CART_EMPTY_UPCOMING' ,'4' ,'LANGUAGES_SHOW_SHOPPING_CART_EMPTY_UPCOMING_DESCRIPTION' ,9 ,33 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SHOPPING_CART_COMBINED_TITLE' ,'SHOW_SHOPPING_CART_COMBINED' ,'1' ,'LANGUAGES_SHOW_SHOPPING_CART_COMBINED_DESCRIPTION' ,9 ,35 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_PAGE_PARSE_TIME_TITLE' ,'STORE_PAGE_PARSE_TIME' ,'false' ,'LANGUAGES_STORE_PAGE_PARSE_TIME_DESCRIPTION' ,10 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_PAGE_PARSE_TIME_LOG_TITLE' ,'STORE_PAGE_PARSE_TIME_LOG' ,'E:/TEST/joycart/joycartjc/cache/page_parse_time.log' ,'LANGUAGES_STORE_PAGE_PARSE_TIME_LOG_DESCRIPTION' ,10 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_PARSE_DATE_TIME_FORMAT_TITLE' ,'STORE_PARSE_DATE_TIME_FORMAT' ,'%d/%m/%Y %H:%M:%S' ,'LANGUAGES_STORE_PARSE_DATE_TIME_FORMAT_DESCRIPTION' ,10 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_PAGE_PARSE_TIME_TITLE' ,'DISPLAY_PAGE_PARSE_TIME' ,'false' ,'LANGUAGES_DISPLAY_PAGE_PARSE_TIME_DESCRIPTION' ,10 ,4 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_DB_TRANSACTIONS_TITLE' ,'STORE_DB_TRANSACTIONS' ,'false' ,'LANGUAGES_STORE_DB_TRANSACTIONS_DESCRIPTION' ,10 ,5 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EMAIL_TRANSPORT_TITLE' ,'EMAIL_TRANSPORT' ,'PHP' ,'LANGUAGES_EMAIL_TRANSPORT_DESCRIPTION' ,12 ,1 ,now() ,'','zen_cfg_select_option(array(\'PHP\', \'sendmail\', \'sendmail-f\', \'smtp\', \'smtpauth\', \'Qmail\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EMAIL_SMTPAUTH_MAILBOX_TITLE' ,'EMAIL_SMTPAUTH_MAILBOX' ,'' ,'LANGUAGES_EMAIL_SMTPAUTH_MAILBOX_DESCRIPTION' ,12 ,101 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EMAIL_SMTPAUTH_PASSWORD_TITLE' ,'EMAIL_SMTPAUTH_PASSWORD' ,'' ,'LANGUAGES_EMAIL_SMTPAUTH_PASSWORD_DESCRIPTION' ,12 ,101 ,now() ,'zen_cfg_password_display','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EMAIL_SMTPAUTH_MAIL_SERVER_TITLE' ,'EMAIL_SMTPAUTH_MAIL_SERVER' ,'' ,'LANGUAGES_EMAIL_SMTPAUTH_MAIL_SERVER_DESCRIPTION' ,12 ,101 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EMAIL_SMTPAUTH_MAIL_SERVER_PORT_TITLE' ,'EMAIL_SMTPAUTH_MAIL_SERVER_PORT' ,'25' ,'LANGUAGES_EMAIL_SMTPAUTH_MAIL_SERVER_PORT_DESCRIPTION' ,12 ,101 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CURRENCIES_TRANSLATIONS_TITLE' ,'CURRENCIES_TRANSLATIONS' ,'' ,'LANGUAGES_CURRENCIES_TRANSLATIONS_DESCRIPTION' ,12 ,120 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EMAIL_LINEFEED_TITLE' ,'EMAIL_LINEFEED' ,'LF' ,'LANGUAGES_EMAIL_LINEFEED_DESCRIPTION' ,12 ,2 ,now() ,'','zen_cfg_select_option(array(\'LF\', \'CRLF\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EMAIL_USE_HTML_TITLE' ,'EMAIL_USE_HTML' ,'true' ,'LANGUAGES_EMAIL_USE_HTML_DESCRIPTION' ,12 ,3 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_EMAIL_ADDRESS_CHECK_TITLE' ,'ENTRY_EMAIL_ADDRESS_CHECK' ,'false' ,'LANGUAGES_ENTRY_EMAIL_ADDRESS_CHECK_DESCRIPTION' ,6 ,6 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EMAILS_TITLE' ,'SEND_EMAILS' ,'true' ,'LANGUAGES_SEND_EMAILS_DESCRIPTION' ,12 ,5 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EMAIL_ARCHIVE_TITLE' ,'EMAIL_ARCHIVE' ,'false' ,'LANGUAGES_EMAIL_ARCHIVE_DESCRIPTION' ,12 ,6 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EMAIL_FRIENDLY_ERRORS_TITLE' ,'EMAIL_FRIENDLY_ERRORS' ,'false' ,'LANGUAGES_EMAIL_FRIENDLY_ERRORS_DESCRIPTION' ,12 ,7 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_STORE_OWNER_EMAIL_ADDRESS_TITLE' ,'STORE_OWNER_EMAIL_ADDRESS' ,'support@joytl.net' ,'LANGUAGES_STORE_OWNER_EMAIL_ADDRESS_DESCRIPTION' ,12 ,10 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EMAIL_FROM_TITLE' ,'EMAIL_FROM' ,'support@joytl.net' ,'LANGUAGES_EMAIL_FROM_DESCRIPTION' ,12 ,11 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EMAIL_SEND_MUST_BE_STORE_TITLE' ,'EMAIL_SEND_MUST_BE_STORE' ,'Yes' ,'LANGUAGES_EMAIL_SEND_MUST_BE_STORE_DESCRIPTION' ,12 ,11 ,now() ,'','zen_cfg_select_option(array(\'No\', \'Yes\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ADMIN_EXTRA_EMAIL_FORMAT_TITLE' ,'ADMIN_EXTRA_EMAIL_FORMAT' ,'TEXT' ,'LANGUAGES_ADMIN_EXTRA_EMAIL_FORMAT_DESCRIPTION' ,12 ,12 ,now() ,'','zen_cfg_select_option(array(\'TEXT\', \'HTML\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_ORDER_EMAILS_TO_TITLE' ,'SEND_EXTRA_ORDER_EMAILS_TO' ,'support@joytl.net' ,'LANGUAGES_SEND_EXTRA_ORDER_EMAILS_TO_DESCRIPTION' ,12 ,12 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_CREATE_ACCOUNT_EMAILS_TO_STATUS_TITLE' ,'SEND_EXTRA_CREATE_ACCOUNT_EMAILS_TO_STATUS' ,'0' ,'LANGUAGES_SEND_EXTRA_CREATE_ACCOUNT_EMAILS_TO_STATUS_DESCRIPTION' ,12 ,13 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_CREATE_ACCOUNT_EMAILS_TO_TITLE' ,'SEND_EXTRA_CREATE_ACCOUNT_EMAILS_TO' ,'support@joytl.net' ,'LANGUAGES_SEND_EXTRA_CREATE_ACCOUNT_EMAILS_TO_DESCRIPTION' ,12 ,14 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_TELL_A_FRIEND_EMAILS_TO_STATUS_TITLE' ,'SEND_EXTRA_TELL_A_FRIEND_EMAILS_TO_STATUS' ,'0' ,'LANGUAGES_SEND_EXTRA_TELL_A_FRIEND_EMAILS_TO_STATUS_DESCRIPTION' ,12 ,15 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_TELL_A_FRIEND_EMAILS_TO_TITLE' ,'SEND_EXTRA_TELL_A_FRIEND_EMAILS_TO' ,'support@joytl.net' ,'LANGUAGES_SEND_EXTRA_TELL_A_FRIEND_EMAILS_TO_DESCRIPTION' ,12 ,16 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_GV_CUSTOMER_EMAILS_TO_STATUS_TITLE' ,'SEND_EXTRA_GV_CUSTOMER_EMAILS_TO_STATUS' ,'0' ,'LANGUAGES_SEND_EXTRA_GV_CUSTOMER_EMAILS_TO_STATUS_DESCRIPTION' ,12 ,17 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_GV_CUSTOMER_EMAILS_TO_TITLE' ,'SEND_EXTRA_GV_CUSTOMER_EMAILS_TO' ,'support@joytl.net' ,'LANGUAGES_SEND_EXTRA_GV_CUSTOMER_EMAILS_TO_DESCRIPTION' ,12 ,18 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_GV_ADMIN_EMAILS_TO_STATUS_TITLE' ,'SEND_EXTRA_GV_ADMIN_EMAILS_TO_STATUS' ,'0' ,'LANGUAGES_SEND_EXTRA_GV_ADMIN_EMAILS_TO_STATUS_DESCRIPTION' ,12 ,19 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_GV_ADMIN_EMAILS_TO_TITLE' ,'SEND_EXTRA_GV_ADMIN_EMAILS_TO' ,'support@joytl.net' ,'LANGUAGES_SEND_EXTRA_GV_ADMIN_EMAILS_TO_DESCRIPTION' ,12 ,20 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_DISCOUNT_COUPON_ADMIN_EMAILS_TO_STATUS_TITLE' ,'SEND_EXTRA_DISCOUNT_COUPON_ADMIN_EMAILS_TO_STATUS' ,'0' ,'LANGUAGES_SEND_EXTRA_DISCOUNT_COUPON_ADMIN_EMAILS_TO_STATUS_DESCRIPTION' ,12 ,21 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_DISCOUNT_COUPON_ADMIN_EMAILS_TO_TITLE' ,'SEND_EXTRA_DISCOUNT_COUPON_ADMIN_EMAILS_TO' ,'support@joytl.net' ,'LANGUAGES_SEND_EXTRA_DISCOUNT_COUPON_ADMIN_EMAILS_TO_DESCRIPTION' ,12 ,22 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_ORDERS_STATUS_ADMIN_EMAILS_TO_STATUS_TITLE' ,'SEND_EXTRA_ORDERS_STATUS_ADMIN_EMAILS_TO_STATUS' ,'0' ,'LANGUAGES_SEND_EXTRA_ORDERS_STATUS_ADMIN_EMAILS_TO_STATUS_DESCRIPTION' ,12 ,23 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_ORDERS_STATUS_ADMIN_EMAILS_TO_TITLE' ,'SEND_EXTRA_ORDERS_STATUS_ADMIN_EMAILS_TO' ,'support@joytl.net' ,'LANGUAGES_SEND_EXTRA_ORDERS_STATUS_ADMIN_EMAILS_TO_DESCRIPTION' ,12 ,24 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_REVIEW_NOTIFICATION_EMAILS_TO_STATUS_TITLE' ,'SEND_EXTRA_REVIEW_NOTIFICATION_EMAILS_TO_STATUS' ,'0' ,'LANGUAGES_SEND_EXTRA_REVIEW_NOTIFICATION_EMAILS_TO_STATUS_DESCRIPTION' ,12 ,25 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_REVIEW_NOTIFICATION_EMAILS_TO_TITLE' ,'SEND_EXTRA_REVIEW_NOTIFICATION_EMAILS_TO' ,'support@joytl.net' ,'LANGUAGES_SEND_EXTRA_REVIEW_NOTIFICATION_EMAILS_TO_DESCRIPTION' ,12 ,26 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CONTACT_US_LIST_TITLE' ,'CONTACT_US_LIST' ,'' ,'LANGUAGES_CONTACT_US_LIST_DESCRIPTION' ,12 ,40 ,now() ,'','zen_cfg_textarea(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ALLOW_GUEST_TO_TELL_A_FRIEND_TITLE' ,'ALLOW_GUEST_TO_TELL_A_FRIEND' ,'false' ,'LANGUAGES_ALLOW_GUEST_TO_TELL_A_FRIEND_DESCRIPTION' ,12 ,50 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CONTACT_US_STORE_NAME_ADDRESS_TITLE' ,'CONTACT_US_STORE_NAME_ADDRESS' ,'1' ,'LANGUAGES_CONTACT_US_STORE_NAME_ADDRESS_DESCRIPTION' ,12 ,50 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_LOWSTOCK_EMAIL_TITLE' ,'SEND_LOWSTOCK_EMAIL' ,'0' ,'LANGUAGES_SEND_LOWSTOCK_EMAIL_DESCRIPTION' ,12 ,60 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SEND_EXTRA_LOW_STOCK_EMAILS_TO_TITLE' ,'SEND_EXTRA_LOW_STOCK_EMAILS_TO' ,'support@joytl.net' ,'LANGUAGES_SEND_EXTRA_LOW_STOCK_EMAILS_TO_DESCRIPTION' ,12 ,61 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_NEWSLETTER_UNSUBSCRIBE_LINK_TITLE' ,'SHOW_NEWSLETTER_UNSUBSCRIBE_LINK' ,'true' ,'LANGUAGES_SHOW_NEWSLETTER_UNSUBSCRIBE_LINK_DESCRIPTION' ,12 ,70 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_AUDIENCE_SELECT_DISPLAY_COUNTS_TITLE' ,'AUDIENCE_SELECT_DISPLAY_COUNTS' ,'true' ,'LANGUAGES_AUDIENCE_SELECT_DISPLAY_COUNTS_DESCRIPTION' ,12 ,90 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWNLOAD_ENABLED_TITLE' ,'DOWNLOAD_ENABLED' ,'true' ,'LANGUAGES_DOWNLOAD_ENABLED_DESCRIPTION' ,13 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWNLOAD_BY_REDIRECT_TITLE' ,'DOWNLOAD_BY_REDIRECT' ,'true' ,'LANGUAGES_DOWNLOAD_BY_REDIRECT_DESCRIPTION' ,13 ,2 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWNLOAD_IN_CHUNKS_TITLE' ,'DOWNLOAD_IN_CHUNKS' ,'false' ,'LANGUAGES_DOWNLOAD_IN_CHUNKS_DESCRIPTION' ,13 ,2 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWNLOAD_MAX_DAYS_TITLE' ,'DOWNLOAD_MAX_DAYS' ,'7' ,'LANGUAGES_DOWNLOAD_MAX_DAYS_DESCRIPTION' ,13 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWNLOAD_MAX_COUNT_TITLE' ,'DOWNLOAD_MAX_COUNT' ,'5' ,'LANGUAGES_DOWNLOAD_MAX_COUNT_DESCRIPTION' ,13 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWNLOADS_ORDERS_STATUS_UPDATED_VALUE_TITLE' ,'DOWNLOADS_ORDERS_STATUS_UPDATED_VALUE' ,'4' ,'LANGUAGES_DOWNLOADS_ORDERS_STATUS_UPDATED_VALUE_DESCRIPTION' ,13 ,10 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWNLOADS_CONTROLLER_ORDERS_STATUS_TITLE' ,'DOWNLOADS_CONTROLLER_ORDERS_STATUS' ,'2' ,'LANGUAGES_DOWNLOADS_CONTROLLER_ORDERS_STATUS_DESCRIPTION' ,13 ,12 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWNLOADS_CONTROLLER_ORDERS_STATUS_END_TITLE' ,'DOWNLOADS_CONTROLLER_ORDERS_STATUS_END' ,'4' ,'LANGUAGES_DOWNLOADS_CONTROLLER_ORDERS_STATUS_END_DESCRIPTION' ,13 ,13 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ATTRIBUTES_ENABLED_PRICE_FACTOR_TITLE' ,'ATTRIBUTES_ENABLED_PRICE_FACTOR' ,'true' ,'LANGUAGES_ATTRIBUTES_ENABLED_PRICE_FACTOR_DESCRIPTION' ,13 ,25 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ATTRIBUTES_ENABLED_QTY_PRICES_TITLE' ,'ATTRIBUTES_ENABLED_QTY_PRICES' ,'true' ,'LANGUAGES_ATTRIBUTES_ENABLED_QTY_PRICES_DESCRIPTION' ,13 ,26 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ATTRIBUTES_ENABLED_IMAGES_TITLE' ,'ATTRIBUTES_ENABLED_IMAGES' ,'true' ,'LANGUAGES_ATTRIBUTES_ENABLED_IMAGES_DESCRIPTION' ,13 ,28 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ATTRIBUTES_ENABLED_TEXT_PRICES_TITLE' ,'ATTRIBUTES_ENABLED_TEXT_PRICES' ,'true' ,'LANGUAGES_ATTRIBUTES_ENABLED_TEXT_PRICES_DESCRIPTION' ,13 ,35 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TEXT_SPACES_FREE_TITLE' ,'TEXT_SPACES_FREE' ,'1' ,'LANGUAGES_TEXT_SPACES_FREE_DESCRIPTION' ,13 ,36 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_OPTIONS_TYPE_READONLY_IGNORED_TITLE' ,'PRODUCTS_OPTIONS_TYPE_READONLY_IGNORED' ,'1' ,'LANGUAGES_PRODUCTS_OPTIONS_TYPE_READONLY_IGNORED_DESCRIPTION' ,13 ,37 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_GZIP_LEVEL_TITLE' ,'GZIP_LEVEL' ,'0' ,'LANGUAGES_GZIP_LEVEL_DESCRIPTION' ,14 ,1 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SESSION_WRITE_DIRECTORY_TITLE' ,'SESSION_WRITE_DIRECTORY' ,'E:/TEST/joycart/joycartjc/cache' ,'LANGUAGES_SESSION_WRITE_DIRECTORY_DESCRIPTION' ,15 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SESSION_USE_FQDN_TITLE' ,'SESSION_USE_FQDN' ,'True' ,'LANGUAGES_SESSION_USE_FQDN_DESCRIPTION' ,15 ,2 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SESSION_FORCE_COOKIE_USE_TITLE' ,'SESSION_FORCE_COOKIE_USE' ,'False' ,'LANGUAGES_SESSION_FORCE_COOKIE_USE_DESCRIPTION' ,15 ,2 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SESSION_CHECK_SSL_SESSION_ID_TITLE' ,'SESSION_CHECK_SSL_SESSION_ID' ,'False' ,'LANGUAGES_SESSION_CHECK_SSL_SESSION_ID_DESCRIPTION' ,15 ,3 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SESSION_CHECK_USER_AGENT_TITLE' ,'SESSION_CHECK_USER_AGENT' ,'False' ,'LANGUAGES_SESSION_CHECK_USER_AGENT_DESCRIPTION' ,15 ,4 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SESSION_CHECK_IP_ADDRESS_TITLE' ,'SESSION_CHECK_IP_ADDRESS' ,'False' ,'LANGUAGES_SESSION_CHECK_IP_ADDRESS_DESCRIPTION' ,15 ,5 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SESSION_BLOCK_SPIDERS_TITLE' ,'SESSION_BLOCK_SPIDERS' ,'True' ,'LANGUAGES_SESSION_BLOCK_SPIDERS_DESCRIPTION' ,15 ,6 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SESSION_RECREATE_TITLE' ,'SESSION_RECREATE' ,'True' ,'LANGUAGES_SESSION_RECREATE_DESCRIPTION' ,15 ,7 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SESSION_IP_TO_HOST_ADDRESS_TITLE' ,'SESSION_IP_TO_HOST_ADDRESS' ,'false' ,'LANGUAGES_SESSION_IP_TO_HOST_ADDRESS_DESCRIPTION' ,15 ,10 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SECURITY_CODE_LENGTH_TITLE' ,'SECURITY_CODE_LENGTH' ,'10' ,'LANGUAGES_SECURITY_CODE_LENGTH_DESCRIPTION' ,16 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_ZERO_BALANCE_ORDERS_STATUS_ID_TITLE' ,'DEFAULT_ZERO_BALANCE_ORDERS_STATUS_ID' ,'2' ,'LANGUAGES_DEFAULT_ZERO_BALANCE_ORDERS_STATUS_ID_DESCRIPTION' ,16 ,0 ,now() ,'zen_get_order_status_name','zen_cfg_pull_down_order_statuses(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_NEW_SIGNUP_DISCOUNT_COUPON_TITLE' ,'NEW_SIGNUP_DISCOUNT_COUPON' ,'' ,'LANGUAGES_NEW_SIGNUP_DISCOUNT_COUPON_DESCRIPTION' ,16 ,75 ,now() ,'','zen_cfg_select_coupon_id(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_NEW_SIGNUP_GIFT_VOUCHER_AMOUNT_TITLE' ,'NEW_SIGNUP_GIFT_VOUCHER_AMOUNT' ,'' ,'LANGUAGES_NEW_SIGNUP_GIFT_VOUCHER_AMOUNT_DESCRIPTION' ,16 ,76 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_DISCOUNT_COUPONS_TITLE' ,'MAX_DISPLAY_SEARCH_RESULTS_DISCOUNT_COUPONS' ,'20' ,'LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_DISCOUNT_COUPONS_DESCRIPTION' ,16 ,81 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_DISCOUNT_COUPONS_REPORTS_TITLE' ,'MAX_DISPLAY_SEARCH_RESULTS_DISCOUNT_COUPONS_REPORTS' ,'20' ,'LANGUAGES_MAX_DISPLAY_SEARCH_RESULTS_DISCOUNT_COUPONS_REPORTS_DESCRIPTION' ,16 ,81 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_ENABLED_VISA_TITLE' ,'CC_ENABLED_VISA' ,'1' ,'LANGUAGES_CC_ENABLED_VISA_DESCRIPTION' ,17 ,1 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_ENABLED_MC_TITLE' ,'CC_ENABLED_MC' ,'1' ,'LANGUAGES_CC_ENABLED_MC_DESCRIPTION' ,17 ,2 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_ENABLED_AMEX_TITLE' ,'CC_ENABLED_AMEX' ,'0' ,'LANGUAGES_CC_ENABLED_AMEX_DESCRIPTION' ,17 ,3 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_ENABLED_DINERS_CLUB_TITLE' ,'CC_ENABLED_DINERS_CLUB' ,'0' ,'LANGUAGES_CC_ENABLED_DINERS_CLUB_DESCRIPTION' ,17 ,4 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_ENABLED_DISCOVER_TITLE' ,'CC_ENABLED_DISCOVER' ,'0' ,'LANGUAGES_CC_ENABLED_DISCOVER_DESCRIPTION' ,17 ,5 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_ENABLED_JCB_TITLE' ,'CC_ENABLED_JCB' ,'0' ,'LANGUAGES_CC_ENABLED_JCB_DESCRIPTION' ,17 ,6 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_ENABLED_AUSTRALIAN_BANKCARD_TITLE' ,'CC_ENABLED_AUSTRALIAN_BANKCARD' ,'0' ,'LANGUAGES_CC_ENABLED_AUSTRALIAN_BANKCARD_DESCRIPTION' ,17 ,7 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_ENABLED_SOLO_TITLE' ,'CC_ENABLED_SOLO' ,'0' ,'LANGUAGES_CC_ENABLED_SOLO_DESCRIPTION' ,17 ,8 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_ENABLED_SWITCH_TITLE' ,'CC_ENABLED_SWITCH' ,'0' ,'LANGUAGES_CC_ENABLED_SWITCH_DESCRIPTION' ,17 ,9 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CC_ENABLED_MAESTRO_TITLE' ,'CC_ENABLED_MAESTRO' ,'0' ,'LANGUAGES_CC_ENABLED_MAESTRO_DESCRIPTION' ,17 ,10 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_ACCEPTED_CREDIT_CARDS_TITLE' ,'SHOW_ACCEPTED_CREDIT_CARDS' ,'0' ,'LANGUAGES_SHOW_ACCEPTED_CREDIT_CARDS_DESCRIPTION' ,17 ,50 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_TOTAL_STATUS_TITLE' ,'MODULE_ORDER_TOTAL_TOTAL_STATUS' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_TOTAL_STATUS_DESCRIPTION' ,6 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER_TITLE' ,'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER' ,'999' ,'LANGUAGES_MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER_DESCRIPTION' ,6 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ADMIN_DEMO_TITLE' ,'ADMIN_DEMO' ,'0' ,'LANGUAGES_ADMIN_DEMO_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_OPTIONS_TYPE_TEXT_TITLE' ,'PRODUCTS_OPTIONS_TYPE_TEXT' ,'1' ,'LANGUAGES_PRODUCTS_OPTIONS_TYPE_TEXT_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_OPTIONS_TYPE_RADIO_TITLE' ,'PRODUCTS_OPTIONS_TYPE_RADIO' ,'2' ,'LANGUAGES_PRODUCTS_OPTIONS_TYPE_RADIO_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_OPTIONS_TYPE_CHECKBOX_TITLE' ,'PRODUCTS_OPTIONS_TYPE_CHECKBOX' ,'3' ,'LANGUAGES_PRODUCTS_OPTIONS_TYPE_CHECKBOX_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_OPTIONS_TYPE_FILE_TITLE' ,'PRODUCTS_OPTIONS_TYPE_FILE' ,'4' ,'LANGUAGES_PRODUCTS_OPTIONS_TYPE_FILE_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_OPTIONS_VALUES_TEXT_ID_TITLE' ,'PRODUCTS_OPTIONS_VALUES_TEXT_ID' ,'0' ,'LANGUAGES_PRODUCTS_OPTIONS_VALUES_TEXT_ID_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_OPTIONS_TYPE_READONLY_TITLE' ,'PRODUCTS_OPTIONS_TYPE_READONLY' ,'5' ,'LANGUAGES_PRODUCTS_OPTIONS_TYPE_READONLY_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_OPTIONS_SORT_ORDER_TITLE' ,'PRODUCTS_OPTIONS_SORT_ORDER' ,'0' ,'LANGUAGES_PRODUCTS_OPTIONS_SORT_ORDER_DESCRIPTION' ,18 ,35 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_OPTIONS_SORT_BY_PRICE_TITLE' ,'PRODUCTS_OPTIONS_SORT_BY_PRICE' ,'1' ,'LANGUAGES_PRODUCTS_OPTIONS_SORT_BY_PRICE_DESCRIPTION' ,18 ,36 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_IMAGES_ATTRIBUTES_NAMES_TITLE' ,'PRODUCT_IMAGES_ATTRIBUTES_NAMES' ,'1' ,'LANGUAGES_PRODUCT_IMAGES_ATTRIBUTES_NAMES_DESCRIPTION' ,18 ,41 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SALE_DISCOUNT_STATUS_TITLE' ,'SHOW_SALE_DISCOUNT_STATUS' ,'1' ,'LANGUAGES_SHOW_SALE_DISCOUNT_STATUS_DESCRIPTION' ,18 ,45 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SALE_DISCOUNT_TITLE' ,'SHOW_SALE_DISCOUNT' ,'1' ,'LANGUAGES_SHOW_SALE_DISCOUNT_DESCRIPTION' ,18 ,46 ,now() ,'','zen_cfg_select_option(array(\'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SALE_DISCOUNT_DECIMALS_TITLE' ,'SHOW_SALE_DISCOUNT_DECIMALS' ,'0' ,'LANGUAGES_SHOW_SALE_DISCOUNT_DECIMALS_DESCRIPTION' ,18 ,47 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_OTHER_IMAGE_PRICE_IS_FREE_ON_TITLE' ,'OTHER_IMAGE_PRICE_IS_FREE_ON' ,'1' ,'LANGUAGES_OTHER_IMAGE_PRICE_IS_FREE_ON_DESCRIPTION' ,18 ,50 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_PRICE_IS_CALL_IMAGE_ON_TITLE' ,'PRODUCTS_PRICE_IS_CALL_IMAGE_ON' ,'1' ,'LANGUAGES_PRODUCTS_PRICE_IS_CALL_IMAGE_ON_DESCRIPTION' ,18 ,51 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCTS_QTY_BOX_STATUS_TITLE' ,'PRODUCTS_QTY_BOX_STATUS' ,'1' ,'LANGUAGES_PRODUCTS_QTY_BOX_STATUS_DESCRIPTION' ,18 ,55 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_REVIEWS_APPROVAL_TITLE' ,'REVIEWS_APPROVAL' ,'1' ,'LANGUAGES_REVIEWS_APPROVAL_DESCRIPTION' ,18 ,62 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_META_TAG_INCLUDE_MODEL_TITLE' ,'META_TAG_INCLUDE_MODEL' ,'1' ,'LANGUAGES_META_TAG_INCLUDE_MODEL_DESCRIPTION' ,18 ,69 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_META_TAG_INCLUDE_PRICE_TITLE' ,'META_TAG_INCLUDE_PRICE' ,'1' ,'LANGUAGES_META_TAG_INCLUDE_PRICE_DESCRIPTION' ,18 ,70 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_META_TAG_DESCRIPTION_LENGTH_TITLE' ,'MAX_META_TAG_DESCRIPTION_LENGTH' ,'50' ,'LANGUAGES_MAX_META_TAG_DESCRIPTION_LENGTH_DESCRIPTION' ,18 ,71 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_COLUMNS_ALSO_PURCHASED_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_COLUMNS_ALSO_PURCHASED_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCT_INFO_COLUMNS_ALSO_PURCHASED_PRODUCTS_DESCRIPTION' ,18 ,72 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\', \'5\', \'6\', \'7\', \'8\', \'9\', \'10\', \'11\', \'12\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_INFO_PREVIOUS_NEXT_TITLE' ,'PRODUCT_INFO_PREVIOUS_NEXT' ,'1' ,'LANGUAGES_PRODUCT_INFO_PREVIOUS_NEXT_DESCRIPTION' ,18 ,21 ,now() ,'','zen_cfg_select_drop_down(array(array(\'id\'=>\'0\', \'text\'=>\'否\'), array(\'id\'=>\'1\', \'text\'=>\'页面顶部\'), array(\'id\'=>\'2\', \'text\'=>\'页面底部\'), array(\'id\'=>\'3\', \'text\'=>\'同时\')),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_INFO_PREVIOUS_NEXT_SORT_TITLE' ,'PRODUCT_INFO_PREVIOUS_NEXT_SORT' ,'1' ,'LANGUAGES_PRODUCT_INFO_PREVIOUS_NEXT_SORT_DESCRIPTION' ,18 ,22 ,now() ,'','zen_cfg_select_drop_down(array(array(\'id\'=>\'0\', \'text\'=>\'商品编号\'), array(\'id\'=>\'1\', \'text\'=>\'商品名称\'), array(\'id\'=>\'2\', \'text\'=>\'商品型号\'), array(\'id\'=>\'3\', \'text\'=>\'价格 - 名称\'), array(\'id\'=>\'4\', \'text\'=>\'价格 - 型号\'), array(\'id\'=>\'5\', \'text\'=>\'名称 - 型号\'), array(\'id\'=>\'6\', \'text\'=>\'商品排序\')),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PREVIOUS_NEXT_STATUS_TITLE' ,'SHOW_PREVIOUS_NEXT_STATUS' ,'0' ,'LANGUAGES_SHOW_PREVIOUS_NEXT_STATUS_DESCRIPTION' ,18 ,20 ,now() ,'','zen_cfg_select_drop_down(array(array(\'id\'=>\'0\', \'text\'=>\'否\'), array(\'id\'=>\'1\', \'text\'=>\'是\')),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PREVIOUS_NEXT_IMAGES_TITLE' ,'SHOW_PREVIOUS_NEXT_IMAGES' ,'2' ,'LANGUAGES_SHOW_PREVIOUS_NEXT_IMAGES_DESCRIPTION' ,18 ,21 ,now() ,'','zen_cfg_select_drop_down(array(array(\'id\'=>\'0\', \'text\'=>\'仅显示按钮\'), array(\'id\'=>\'1\', \'text\'=>\'按钮和商品图像\'), array(\'id\'=>\'2\', \'text\'=>\'仅显示商品图像\')),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PREVIOUS_NEXT_IMAGE_WIDTH_TITLE' ,'PREVIOUS_NEXT_IMAGE_WIDTH' ,'50' ,'LANGUAGES_PREVIOUS_NEXT_IMAGE_WIDTH_DESCRIPTION' ,18 ,22 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PREVIOUS_NEXT_IMAGE_HEIGHT_TITLE' ,'PREVIOUS_NEXT_IMAGE_HEIGHT' ,'40' ,'LANGUAGES_PREVIOUS_NEXT_IMAGE_HEIGHT_DESCRIPTION' ,18 ,23 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_INFO_CATEGORIES_TITLE' ,'PRODUCT_INFO_CATEGORIES' ,'1' ,'LANGUAGES_PRODUCT_INFO_CATEGORIES_DESCRIPTION' ,18 ,20 ,now() ,'','zen_cfg_select_drop_down(array(array(\'id\'=>\'0\', \'text\'=>\'否\'), array(\'id\'=>\'1\', \'text\'=>\'左对齐\'), array(\'id\'=>\'2\', \'text\'=>\'中间对齐\'), array(\'id\'=>\'3\', \'text\'=>\'右对齐\')),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_INFO_CATEGORIES_IMAGE_STATUS_TITLE' ,'PRODUCT_INFO_CATEGORIES_IMAGE_STATUS' ,'2' ,'LANGUAGES_PRODUCT_INFO_CATEGORIES_IMAGE_STATUS_DESCRIPTION' ,18 ,20 ,now() ,'','zen_cfg_select_drop_down(array(array(\'id\'=>\'0\', \'text\'=>\'分类和图像\'), array(\'id\'=>\'1\', \'text\'=>\'仅分类\'), array(\'id\'=>\'2\', \'text\'=>\'非空时分类和图像\')),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_BOX_WIDTH_LEFT_TITLE' ,'BOX_WIDTH_LEFT' ,'180px' ,'LANGUAGES_BOX_WIDTH_LEFT_DESCRIPTION' ,19 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_BOX_WIDTH_RIGHT_TITLE' ,'BOX_WIDTH_RIGHT' ,'180px' ,'LANGUAGES_BOX_WIDTH_RIGHT_DESCRIPTION' ,19 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_BREAD_CRUMBS_SEPARATOR_TITLE' ,'BREAD_CRUMBS_SEPARATOR' ,' >> ' ,'LANGUAGES_BREAD_CRUMBS_SEPARATOR_DESCRIPTION' ,19 ,3 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_BREADCRUMB_STATUS_TITLE' ,'DEFINE_BREADCRUMB_STATUS' ,'2' ,'LANGUAGES_DEFINE_BREADCRUMB_STATUS_DESCRIPTION' ,19 ,4 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_BEST_SELLERS_FILLER_TITLE' ,'BEST_SELLERS_FILLER' ,' ' ,'LANGUAGES_BEST_SELLERS_FILLER_DESCRIPTION' ,19 ,5 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_BEST_SELLERS_TRUNCATE_TITLE' ,'BEST_SELLERS_TRUNCATE' ,'35' ,'LANGUAGES_BEST_SELLERS_TRUNCATE_DESCRIPTION' ,19 ,6 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_BEST_SELLERS_TRUNCATE_MORE_TITLE' ,'BEST_SELLERS_TRUNCATE_MORE' ,'true' ,'LANGUAGES_BEST_SELLERS_TRUNCATE_MORE_DESCRIPTION' ,19 ,7 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SHOPPING_CART_BOX_STATUS_TITLE' ,'SHOW_SHOPPING_CART_BOX_STATUS' ,'1' ,'LANGUAGES_SHOW_SHOPPING_CART_BOX_STATUS_DESCRIPTION' ,19 ,8 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_CATEGORIES_BOX_SPECIALS_TITLE' ,'SHOW_CATEGORIES_BOX_SPECIALS' ,'true' ,'LANGUAGES_SHOW_CATEGORIES_BOX_SPECIALS_DESCRIPTION' ,19 ,9 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_CATEGORIES_BOX_PRODUCTS_NEW_TITLE' ,'SHOW_CATEGORIES_BOX_PRODUCTS_NEW' ,'true' ,'LANGUAGES_SHOW_CATEGORIES_BOX_PRODUCTS_NEW_DESCRIPTION' ,19 ,10 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_CATEGORIES_BOX_FEATURED_PRODUCTS_TITLE' ,'SHOW_CATEGORIES_BOX_FEATURED_PRODUCTS' ,'true' ,'LANGUAGES_SHOW_CATEGORIES_BOX_FEATURED_PRODUCTS_DESCRIPTION' ,19 ,11 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_CATEGORIES_BOX_PRODUCTS_ALL_TITLE' ,'SHOW_CATEGORIES_BOX_PRODUCTS_ALL' ,'true' ,'LANGUAGES_SHOW_CATEGORIES_BOX_PRODUCTS_ALL_DESCRIPTION' ,19 ,12 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_COLUMN_LEFT_STATUS_TITLE' ,'COLUMN_LEFT_STATUS' ,'1' ,'LANGUAGES_COLUMN_LEFT_STATUS_DESCRIPTION' ,19 ,15 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_COLUMN_RIGHT_STATUS_TITLE' ,'COLUMN_RIGHT_STATUS' ,'1' ,'LANGUAGES_COLUMN_RIGHT_STATUS_DESCRIPTION' ,19 ,16 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_COLUMN_WIDTH_LEFT_TITLE' ,'COLUMN_WIDTH_LEFT' ,'180px' ,'LANGUAGES_COLUMN_WIDTH_LEFT_DESCRIPTION' ,19 ,20 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_COLUMN_WIDTH_RIGHT_TITLE' ,'COLUMN_WIDTH_RIGHT' ,'180px' ,'LANGUAGES_COLUMN_WIDTH_RIGHT_DESCRIPTION' ,19 ,21 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_CATEGORIES_SEPARATOR_LINK_TITLE' ,'SHOW_CATEGORIES_SEPARATOR_LINK' ,'1' ,'LANGUAGES_SHOW_CATEGORIES_SEPARATOR_LINK_DESCRIPTION' ,19 ,24 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORIES_SEPARATOR_TITLE' ,'CATEGORIES_SEPARATOR' ,'' ,'LANGUAGES_CATEGORIES_SEPARATOR_DESCRIPTION' ,19 ,25 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORIES_SEPARATOR_SUBS_TITLE' ,'CATEGORIES_SEPARATOR_SUBS' ,'' ,'LANGUAGES_CATEGORIES_SEPARATOR_SUBS_DESCRIPTION' ,19 ,26 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORIES_COUNT_PREFIX_TITLE' ,'CATEGORIES_COUNT_PREFIX' ,' (' ,'LANGUAGES_CATEGORIES_COUNT_PREFIX_DESCRIPTION' ,19 ,27 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORIES_COUNT_SUFFIX_TITLE' ,'CATEGORIES_COUNT_SUFFIX' ,')' ,'LANGUAGES_CATEGORIES_COUNT_SUFFIX_DESCRIPTION' ,19 ,28 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORIES_SUBCATEGORIES_INDENT_TITLE' ,'CATEGORIES_SUBCATEGORIES_INDENT' ,' ' ,'LANGUAGES_CATEGORIES_SUBCATEGORIES_INDENT_DESCRIPTION' ,19 ,29 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORIES_COUNT_ZERO_TITLE' ,'CATEGORIES_COUNT_ZERO' ,'0' ,'LANGUAGES_CATEGORIES_COUNT_ZERO_DESCRIPTION' ,19 ,30 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORIES_SPLIT_DISPLAY_TITLE' ,'CATEGORIES_SPLIT_DISPLAY' ,'True' ,'LANGUAGES_CATEGORIES_SPLIT_DISPLAY_DESCRIPTION' ,19 ,31 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_TOTALS_IN_CART_TITLE' ,'SHOW_TOTALS_IN_CART' ,'1' ,'LANGUAGES_SHOW_TOTALS_IN_CART_DESCRIPTION' ,19 ,31 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_CUSTOMER_GREETING_TITLE' ,'SHOW_CUSTOMER_GREETING' ,'1' ,'LANGUAGES_SHOW_CUSTOMER_GREETING_DESCRIPTION' ,19 ,40 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_CATEGORIES_ALWAYS_TITLE' ,'SHOW_CATEGORIES_ALWAYS' ,'0' ,'LANGUAGES_SHOW_CATEGORIES_ALWAYS_DESCRIPTION' ,19 ,45 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORIES_START_MAIN_TITLE' ,'CATEGORIES_START_MAIN' ,'0' ,'LANGUAGES_CATEGORIES_START_MAIN_DESCRIPTION' ,19 ,46 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_CATEGORIES_SUBCATEGORIES_ALWAYS_TITLE' ,'SHOW_CATEGORIES_SUBCATEGORIES_ALWAYS' ,'1' ,'LANGUAGES_SHOW_CATEGORIES_SUBCATEGORIES_ALWAYS_DESCRIPTION' ,19 ,47 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_GROUP_SET1_TITLE' ,'SHOW_BANNERS_GROUP_SET1' ,'' ,'LANGUAGES_SHOW_BANNERS_GROUP_SET1_DESCRIPTION' ,19 ,55 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_GROUP_SET2_TITLE' ,'SHOW_BANNERS_GROUP_SET2' ,'indexr' ,'LANGUAGES_SHOW_BANNERS_GROUP_SET2_DESCRIPTION' ,19 ,56 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_GROUP_SET3_TITLE' ,'SHOW_BANNERS_GROUP_SET3' ,'' ,'LANGUAGES_SHOW_BANNERS_GROUP_SET3_DESCRIPTION' ,19 ,57 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_GROUP_SET4_TITLE' ,'SHOW_BANNERS_GROUP_SET4' ,'' ,'LANGUAGES_SHOW_BANNERS_GROUP_SET4_DESCRIPTION' ,19 ,65 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_GROUP_SET5_TITLE' ,'SHOW_BANNERS_GROUP_SET5' ,'' ,'LANGUAGES_SHOW_BANNERS_GROUP_SET5_DESCRIPTION' ,19 ,66 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_GROUP_SET6_TITLE' ,'SHOW_BANNERS_GROUP_SET6' ,'Wide-Banners' ,'LANGUAGES_SHOW_BANNERS_GROUP_SET6_DESCRIPTION' ,19 ,67 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_GROUP_SET7_TITLE' ,'SHOW_BANNERS_GROUP_SET7' ,'SideBox-Banners' ,'LANGUAGES_SHOW_BANNERS_GROUP_SET7_DESCRIPTION' ,19 ,70 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_GROUP_SET8_TITLE' ,'SHOW_BANNERS_GROUP_SET8' ,'SideBox-Banner2' ,'LANGUAGES_SHOW_BANNERS_GROUP_SET8_DESCRIPTION' ,19 ,71 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_GROUP_SET_ALL_TITLE' ,'SHOW_BANNERS_GROUP_SET_ALL' ,'BannersAll' ,'LANGUAGES_SHOW_BANNERS_GROUP_SET_ALL_DESCRIPTION' ,19 ,72 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_FOOTER_IP_TITLE' ,'SHOW_FOOTER_IP' ,'1' ,'LANGUAGES_SHOW_FOOTER_IP_DESCRIPTION' ,19 ,80 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISCOUNT_QTY_ADD_TITLE' ,'DISCOUNT_QTY_ADD' ,'5' ,'LANGUAGES_DISCOUNT_QTY_ADD_DESCRIPTION' ,19 ,90 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISCOUNT_QUANTITY_PRICES_COLUMN_TITLE' ,'DISCOUNT_QUANTITY_PRICES_COLUMN' ,'5' ,'LANGUAGES_DISCOUNT_QUANTITY_PRICES_COLUMN_DESCRIPTION' ,19 ,95 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORIES_PRODUCTS_SORT_ORDER_TITLE' ,'CATEGORIES_PRODUCTS_SORT_ORDER' ,'0' ,'LANGUAGES_CATEGORIES_PRODUCTS_SORT_ORDER_DESCRIPTION' ,19 ,100 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\', \'5\', \'6\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_OPTION_NAMES_VALUES_GLOBAL_STATUS_TITLE' ,'OPTION_NAMES_VALUES_GLOBAL_STATUS' ,'1' ,'LANGUAGES_OPTION_NAMES_VALUES_GLOBAL_STATUS_DESCRIPTION' ,19 ,110 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_CATEGORIES_TABS_STATUS_TITLE' ,'CATEGORIES_TABS_STATUS' ,'0' ,'LANGUAGES_CATEGORIES_TABS_STATUS_DESCRIPTION' ,19 ,112 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_ACCOUNT_LINKS_ON_SITE_MAP_TITLE' ,'SHOW_ACCOUNT_LINKS_ON_SITE_MAP' ,'No' ,'LANGUAGES_SHOW_ACCOUNT_LINKS_ON_SITE_MAP_DESCRIPTION' ,19 ,115 ,now() ,'','zen_cfg_select_option(array(\'Yes\', \'No\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SKIP_SINGLE_PRODUCT_CATEGORIES_TITLE' ,'SKIP_SINGLE_PRODUCT_CATEGORIES' ,'True' ,'LANGUAGES_SKIP_SINGLE_PRODUCT_CATEGORIES_DESCRIPTION' ,19 ,120 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_USE_SPLIT_LOGIN_MODE_TITLE' ,'USE_SPLIT_LOGIN_MODE' ,'False' ,'LANGUAGES_USE_SPLIT_LOGIN_MODE_DESCRIPTION' ,19 ,121 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IMAGE_USE_CSS_BUTTONS_TITLE' ,'IMAGE_USE_CSS_BUTTONS' ,'No' ,'LANGUAGES_IMAGE_USE_CSS_BUTTONS_DESCRIPTION' ,19 ,147 ,now() ,'','zen_cfg_select_option(array(\'No\', \'Yes\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWN_FOR_MAINTENANCE_TITLE' ,'DOWN_FOR_MAINTENANCE' ,'false' ,'LANGUAGES_DOWN_FOR_MAINTENANCE_DESCRIPTION' ,20 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWN_FOR_MAINTENANCE_FILENAME_TITLE' ,'DOWN_FOR_MAINTENANCE_FILENAME' ,'down_for_maintenance' ,'LANGUAGES_DOWN_FOR_MAINTENANCE_FILENAME_DESCRIPTION' ,20 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWN_FOR_MAINTENANCE_HEADER_OFF_TITLE' ,'DOWN_FOR_MAINTENANCE_HEADER_OFF' ,'false' ,'LANGUAGES_DOWN_FOR_MAINTENANCE_HEADER_OFF_DESCRIPTION' ,20 ,3 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWN_FOR_MAINTENANCE_COLUMN_LEFT_OFF_TITLE' ,'DOWN_FOR_MAINTENANCE_COLUMN_LEFT_OFF' ,'false' ,'LANGUAGES_DOWN_FOR_MAINTENANCE_COLUMN_LEFT_OFF_DESCRIPTION' ,20 ,4 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWN_FOR_MAINTENANCE_COLUMN_RIGHT_OFF_TITLE' ,'DOWN_FOR_MAINTENANCE_COLUMN_RIGHT_OFF' ,'false' ,'LANGUAGES_DOWN_FOR_MAINTENANCE_COLUMN_RIGHT_OFF_DESCRIPTION' ,20 ,5 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWN_FOR_MAINTENANCE_FOOTER_OFF_TITLE' ,'DOWN_FOR_MAINTENANCE_FOOTER_OFF' ,'false' ,'LANGUAGES_DOWN_FOR_MAINTENANCE_FOOTER_OFF_DESCRIPTION' ,20 ,6 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DOWN_FOR_MAINTENANCE_PRICES_OFF_TITLE' ,'DOWN_FOR_MAINTENANCE_PRICES_OFF' ,'false' ,'LANGUAGES_DOWN_FOR_MAINTENANCE_PRICES_OFF_DESCRIPTION' ,20 ,7 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EXCLUDE_ADMIN_IP_FOR_MAINTENANCE_TITLE' ,'EXCLUDE_ADMIN_IP_FOR_MAINTENANCE' ,'您的IP地址(管理员),192.168.1.17' ,'LANGUAGES_EXCLUDE_ADMIN_IP_FOR_MAINTENANCE_DESCRIPTION' ,20 ,8 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_WARN_BEFORE_DOWN_FOR_MAINTENANCE_TITLE' ,'WARN_BEFORE_DOWN_FOR_MAINTENANCE' ,'false' ,'LANGUAGES_WARN_BEFORE_DOWN_FOR_MAINTENANCE_DESCRIPTION' ,20 ,9 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PERIOD_BEFORE_DOWN_FOR_MAINTENANCE_TITLE' ,'PERIOD_BEFORE_DOWN_FOR_MAINTENANCE' ,'2003/05/15 2-3 PM' ,'LANGUAGES_PERIOD_BEFORE_DOWN_FOR_MAINTENANCE_DESCRIPTION' ,20 ,10 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_MAINTENANCE_TIME_TITLE' ,'DISPLAY_MAINTENANCE_TIME' ,'false' ,'LANGUAGES_DISPLAY_MAINTENANCE_TIME_DESCRIPTION' ,20 ,11 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_MAINTENANCE_PERIOD_TITLE' ,'DISPLAY_MAINTENANCE_PERIOD' ,'false' ,'LANGUAGES_DISPLAY_MAINTENANCE_PERIOD_DESCRIPTION' ,20 ,12 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TEXT_MAINTENANCE_PERIOD_TIME_TITLE' ,'TEXT_MAINTENANCE_PERIOD_TIME' ,'2h00' ,'LANGUAGES_TEXT_MAINTENANCE_PERIOD_TIME_DESCRIPTION' ,20 ,13 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_CONDITIONS_ON_CHECKOUT_TITLE' ,'DISPLAY_CONDITIONS_ON_CHECKOUT' ,'true' ,'LANGUAGES_DISPLAY_CONDITIONS_ON_CHECKOUT_DESCRIPTION' ,11 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_PRIVACY_CONDITIONS_TITLE' ,'DISPLAY_PRIVACY_CONDITIONS' ,'true' ,'LANGUAGES_DISPLAY_PRIVACY_CONDITIONS_DESCRIPTION' ,11 ,2 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LIST_IMAGE_TITLE' ,'PRODUCT_NEW_LIST_IMAGE' ,'1102' ,'LANGUAGES_PRODUCT_NEW_LIST_IMAGE_DESCRIPTION' ,21 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LIST_QUANTITY_TITLE' ,'PRODUCT_NEW_LIST_QUANTITY' ,'1202' ,'LANGUAGES_PRODUCT_NEW_LIST_QUANTITY_DESCRIPTION' ,21 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_BUY_NOW_TITLE' ,'PRODUCT_NEW_BUY_NOW' ,'1300' ,'LANGUAGES_PRODUCT_NEW_BUY_NOW_DESCRIPTION' ,21 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LIST_NAME_TITLE' ,'PRODUCT_NEW_LIST_NAME' ,'2101' ,'LANGUAGES_PRODUCT_NEW_LIST_NAME_DESCRIPTION' ,21 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LIST_MODEL_TITLE' ,'PRODUCT_NEW_LIST_MODEL' ,'2201' ,'LANGUAGES_PRODUCT_NEW_LIST_MODEL_DESCRIPTION' ,21 ,5 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LIST_MANUFACTURER_TITLE' ,'PRODUCT_NEW_LIST_MANUFACTURER' ,'2302' ,'LANGUAGES_PRODUCT_NEW_LIST_MANUFACTURER_DESCRIPTION' ,21 ,6 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LIST_PRICE_TITLE' ,'PRODUCT_NEW_LIST_PRICE' ,'2402' ,'LANGUAGES_PRODUCT_NEW_LIST_PRICE_DESCRIPTION' ,21 ,7 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LIST_WEIGHT_TITLE' ,'PRODUCT_NEW_LIST_WEIGHT' ,'2502' ,'LANGUAGES_PRODUCT_NEW_LIST_WEIGHT_DESCRIPTION' ,21 ,8 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LIST_DATE_ADDED_TITLE' ,'PRODUCT_NEW_LIST_DATE_ADDED' ,'2601' ,'LANGUAGES_PRODUCT_NEW_LIST_DATE_ADDED_DESCRIPTION' ,21 ,9 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LIST_DESCRIPTION_TITLE' ,'PRODUCT_NEW_LIST_DESCRIPTION' ,'150' ,'LANGUAGES_PRODUCT_NEW_LIST_DESCRIPTION_DESCRIPTION' ,21 ,10 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LIST_SORT_DEFAULT_TITLE' ,'PRODUCT_NEW_LIST_SORT_DEFAULT' ,'6' ,'LANGUAGES_PRODUCT_NEW_LIST_SORT_DEFAULT_DESCRIPTION' ,21 ,11 ,now() ,'','zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\', \'5\', \'6\', \'7\', \'8\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LIST_GROUP_ID_TITLE' ,'PRODUCT_NEW_LIST_GROUP_ID' ,'21' ,'LANGUAGES_PRODUCT_NEW_LIST_GROUP_ID_DESCRIPTION' ,21 ,12 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_NEW_LISTING_MULTIPLE_ADD_TO_CART_TITLE' ,'PRODUCT_NEW_LISTING_MULTIPLE_ADD_TO_CART' ,'0' ,'LANGUAGES_PRODUCT_NEW_LISTING_MULTIPLE_ADD_TO_CART_DESCRIPTION' ,21 ,25 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_NEW_PRODUCTS_UPCOMING_MASKED_TITLE' ,'SHOW_NEW_PRODUCTS_UPCOMING_MASKED' ,'0' ,'LANGUAGES_SHOW_NEW_PRODUCTS_UPCOMING_MASKED_DESCRIPTION' ,21 ,30 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LIST_IMAGE_TITLE' ,'PRODUCT_FEATURED_LIST_IMAGE' ,'1102' ,'LANGUAGES_PRODUCT_FEATURED_LIST_IMAGE_DESCRIPTION' ,22 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LIST_QUANTITY_TITLE' ,'PRODUCT_FEATURED_LIST_QUANTITY' ,'1202' ,'LANGUAGES_PRODUCT_FEATURED_LIST_QUANTITY_DESCRIPTION' ,22 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_BUY_NOW_TITLE' ,'PRODUCT_FEATURED_BUY_NOW' ,'1300' ,'LANGUAGES_PRODUCT_FEATURED_BUY_NOW_DESCRIPTION' ,22 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LIST_NAME_TITLE' ,'PRODUCT_FEATURED_LIST_NAME' ,'2101' ,'LANGUAGES_PRODUCT_FEATURED_LIST_NAME_DESCRIPTION' ,22 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LIST_MODEL_TITLE' ,'PRODUCT_FEATURED_LIST_MODEL' ,'2201' ,'LANGUAGES_PRODUCT_FEATURED_LIST_MODEL_DESCRIPTION' ,22 ,5 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LIST_MANUFACTURER_TITLE' ,'PRODUCT_FEATURED_LIST_MANUFACTURER' ,'2302' ,'LANGUAGES_PRODUCT_FEATURED_LIST_MANUFACTURER_DESCRIPTION' ,22 ,6 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LIST_PRICE_TITLE' ,'PRODUCT_FEATURED_LIST_PRICE' ,'2402' ,'LANGUAGES_PRODUCT_FEATURED_LIST_PRICE_DESCRIPTION' ,22 ,7 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LIST_WEIGHT_TITLE' ,'PRODUCT_FEATURED_LIST_WEIGHT' ,'2502' ,'LANGUAGES_PRODUCT_FEATURED_LIST_WEIGHT_DESCRIPTION' ,22 ,8 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LIST_DATE_ADDED_TITLE' ,'PRODUCT_FEATURED_LIST_DATE_ADDED' ,'2601' ,'LANGUAGES_PRODUCT_FEATURED_LIST_DATE_ADDED_DESCRIPTION' ,22 ,9 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LIST_DESCRIPTION_TITLE' ,'PRODUCT_FEATURED_LIST_DESCRIPTION' ,'150' ,'LANGUAGES_PRODUCT_FEATURED_LIST_DESCRIPTION_DESCRIPTION' ,22 ,10 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LIST_SORT_DEFAULT_TITLE' ,'PRODUCT_FEATURED_LIST_SORT_DEFAULT' ,'1' ,'LANGUAGES_PRODUCT_FEATURED_LIST_SORT_DEFAULT_DESCRIPTION' ,22 ,11 ,now() ,'','zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\', \'5\', \'6\', \'7\', \'8\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LIST_GROUP_ID_TITLE' ,'PRODUCT_FEATURED_LIST_GROUP_ID' ,'22' ,'LANGUAGES_PRODUCT_FEATURED_LIST_GROUP_ID_DESCRIPTION' ,22 ,12 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_FEATURED_LISTING_MULTIPLE_ADD_TO_CART_TITLE' ,'PRODUCT_FEATURED_LISTING_MULTIPLE_ADD_TO_CART' ,'0' ,'LANGUAGES_PRODUCT_FEATURED_LISTING_MULTIPLE_ADD_TO_CART_DESCRIPTION' ,22 ,25 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LIST_IMAGE_TITLE' ,'PRODUCT_ALL_LIST_IMAGE' ,'1102' ,'LANGUAGES_PRODUCT_ALL_LIST_IMAGE_DESCRIPTION' ,23 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LIST_QUANTITY_TITLE' ,'PRODUCT_ALL_LIST_QUANTITY' ,'1202' ,'LANGUAGES_PRODUCT_ALL_LIST_QUANTITY_DESCRIPTION' ,23 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_BUY_NOW_TITLE' ,'PRODUCT_ALL_BUY_NOW' ,'1300' ,'LANGUAGES_PRODUCT_ALL_BUY_NOW_DESCRIPTION' ,23 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LIST_NAME_TITLE' ,'PRODUCT_ALL_LIST_NAME' ,'2101' ,'LANGUAGES_PRODUCT_ALL_LIST_NAME_DESCRIPTION' ,23 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LIST_MODEL_TITLE' ,'PRODUCT_ALL_LIST_MODEL' ,'2201' ,'LANGUAGES_PRODUCT_ALL_LIST_MODEL_DESCRIPTION' ,23 ,5 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LIST_MANUFACTURER_TITLE' ,'PRODUCT_ALL_LIST_MANUFACTURER' ,'2302' ,'LANGUAGES_PRODUCT_ALL_LIST_MANUFACTURER_DESCRIPTION' ,23 ,6 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LIST_PRICE_TITLE' ,'PRODUCT_ALL_LIST_PRICE' ,'2402' ,'LANGUAGES_PRODUCT_ALL_LIST_PRICE_DESCRIPTION' ,23 ,7 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LIST_WEIGHT_TITLE' ,'PRODUCT_ALL_LIST_WEIGHT' ,'2502' ,'LANGUAGES_PRODUCT_ALL_LIST_WEIGHT_DESCRIPTION' ,23 ,8 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LIST_DATE_ADDED_TITLE' ,'PRODUCT_ALL_LIST_DATE_ADDED' ,'2601' ,'LANGUAGES_PRODUCT_ALL_LIST_DATE_ADDED_DESCRIPTION' ,23 ,9 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LIST_DESCRIPTION_TITLE' ,'PRODUCT_ALL_LIST_DESCRIPTION' ,'150' ,'LANGUAGES_PRODUCT_ALL_LIST_DESCRIPTION_DESCRIPTION' ,23 ,10 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LIST_SORT_DEFAULT_TITLE' ,'PRODUCT_ALL_LIST_SORT_DEFAULT' ,'1' ,'LANGUAGES_PRODUCT_ALL_LIST_SORT_DEFAULT_DESCRIPTION' ,23 ,11 ,now() ,'','zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\', \'5\', \'6\', \'7\', \'8\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LIST_GROUP_ID_TITLE' ,'PRODUCT_ALL_LIST_GROUP_ID' ,'23' ,'LANGUAGES_PRODUCT_ALL_LIST_GROUP_ID_DESCRIPTION' ,23 ,12 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_PRODUCT_ALL_LISTING_MULTIPLE_ADD_TO_CART_TITLE' ,'PRODUCT_ALL_LISTING_MULTIPLE_ADD_TO_CART' ,'0' ,'LANGUAGES_PRODUCT_ALL_LISTING_MULTIPLE_ADD_TO_CART_DESCRIPTION' ,23 ,25 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_MAIN_NEW_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_MAIN_NEW_PRODUCTS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_MAIN_NEW_PRODUCTS_DESCRIPTION' ,24 ,65 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_MAIN_FEATURED_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_MAIN_FEATURED_PRODUCTS' ,'2' ,'LANGUAGES_SHOW_PRODUCT_INFO_MAIN_FEATURED_PRODUCTS_DESCRIPTION' ,24 ,66 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_MAIN_SPECIALS_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_MAIN_SPECIALS_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCT_INFO_MAIN_SPECIALS_PRODUCTS_DESCRIPTION' ,24 ,67 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_MAIN_UPCOMING_TITLE' ,'SHOW_PRODUCT_INFO_MAIN_UPCOMING' ,'4' ,'LANGUAGES_SHOW_PRODUCT_INFO_MAIN_UPCOMING_DESCRIPTION' ,24 ,68 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_CATEGORY_NEW_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_CATEGORY_NEW_PRODUCTS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_CATEGORY_NEW_PRODUCTS_DESCRIPTION' ,24 ,70 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_CATEGORY_FEATURED_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_CATEGORY_FEATURED_PRODUCTS' ,'2' ,'LANGUAGES_SHOW_PRODUCT_INFO_CATEGORY_FEATURED_PRODUCTS_DESCRIPTION' ,24 ,71 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_CATEGORY_SPECIALS_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_CATEGORY_SPECIALS_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCT_INFO_CATEGORY_SPECIALS_PRODUCTS_DESCRIPTION' ,24 ,72 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_CATEGORY_UPCOMING_TITLE' ,'SHOW_PRODUCT_INFO_CATEGORY_UPCOMING' ,'4' ,'LANGUAGES_SHOW_PRODUCT_INFO_CATEGORY_UPCOMING_DESCRIPTION' ,24 ,73 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_MISSING_NEW_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_MISSING_NEW_PRODUCTS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_MISSING_NEW_PRODUCTS_DESCRIPTION' ,24 ,75 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_MISSING_FEATURED_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_MISSING_FEATURED_PRODUCTS' ,'2' ,'LANGUAGES_SHOW_PRODUCT_INFO_MISSING_FEATURED_PRODUCTS_DESCRIPTION' ,24 ,76 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_MISSING_SPECIALS_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_MISSING_SPECIALS_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCT_INFO_MISSING_SPECIALS_PRODUCTS_DESCRIPTION' ,24 ,77 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_MISSING_UPCOMING_TITLE' ,'SHOW_PRODUCT_INFO_MISSING_UPCOMING' ,'4' ,'LANGUAGES_SHOW_PRODUCT_INFO_MISSING_UPCOMING_DESCRIPTION' ,24 ,78 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_LISTING_BELOW_NEW_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_LISTING_BELOW_NEW_PRODUCTS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_LISTING_BELOW_NEW_PRODUCTS_DESCRIPTION' ,24 ,85 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_LISTING_BELOW_FEATURED_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_LISTING_BELOW_FEATURED_PRODUCTS' ,'2' ,'LANGUAGES_SHOW_PRODUCT_INFO_LISTING_BELOW_FEATURED_PRODUCTS_DESCRIPTION' ,24 ,86 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_LISTING_BELOW_SPECIALS_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_LISTING_BELOW_SPECIALS_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCT_INFO_LISTING_BELOW_SPECIALS_PRODUCTS_DESCRIPTION' ,24 ,87 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_LISTING_BELOW_UPCOMING_TITLE' ,'SHOW_PRODUCT_INFO_LISTING_BELOW_UPCOMING' ,'4' ,'LANGUAGES_SHOW_PRODUCT_INFO_LISTING_BELOW_UPCOMING_DESCRIPTION' ,24 ,88 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_COLUMNS_NEW_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_COLUMNS_NEW_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCT_INFO_COLUMNS_NEW_PRODUCTS_DESCRIPTION' ,24 ,95 ,now() ,'','zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\', \'5\', \'6\', \'7\', \'8\', \'9\', \'10\', \'11\', \'12\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_COLUMNS_FEATURED_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_COLUMNS_FEATURED_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCT_INFO_COLUMNS_FEATURED_PRODUCTS_DESCRIPTION' ,24 ,96 ,now() ,'','zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\', \'5\', \'6\', \'7\', \'8\', \'9\', \'10\', \'11\', \'12\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_COLUMNS_SPECIALS_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_COLUMNS_SPECIALS_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCT_INFO_COLUMNS_SPECIALS_PRODUCTS_DESCRIPTION' ,24 ,97 ,now() ,'','zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\', \'5\', \'6\', \'7\', \'8\', \'9\', \'10\', \'11\', \'12\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_ALL_PRODUCTS_TITLE' ,'SHOW_PRODUCT_INFO_ALL_PRODUCTS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_ALL_PRODUCTS_DESCRIPTION' ,24 ,100 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_MAIN_PAGE_STATUS_TITLE' ,'DEFINE_MAIN_PAGE_STATUS' ,'1' ,'LANGUAGES_DEFINE_MAIN_PAGE_STATUS_DESCRIPTION' ,25 ,60 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_CONTACT_US_STATUS_TITLE' ,'DEFINE_CONTACT_US_STATUS' ,'1' ,'LANGUAGES_DEFINE_CONTACT_US_STATUS_DESCRIPTION' ,25 ,61 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_PRIVACY_STATUS_TITLE' ,'DEFINE_PRIVACY_STATUS' ,'1' ,'LANGUAGES_DEFINE_PRIVACY_STATUS_DESCRIPTION' ,25 ,62 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_SHIPPINGINFO_STATUS_TITLE' ,'DEFINE_SHIPPINGINFO_STATUS' ,'1' ,'LANGUAGES_DEFINE_SHIPPINGINFO_STATUS_DESCRIPTION' ,25 ,63 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_CONDITIONS_STATUS_TITLE' ,'DEFINE_CONDITIONS_STATUS' ,'1' ,'LANGUAGES_DEFINE_CONDITIONS_STATUS_DESCRIPTION' ,25 ,64 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_CHECKOUT_SUCCESS_STATUS_TITLE' ,'DEFINE_CHECKOUT_SUCCESS_STATUS' ,'1' ,'LANGUAGES_DEFINE_CHECKOUT_SUCCESS_STATUS_DESCRIPTION' ,25 ,65 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_DISCOUNT_COUPON_STATUS_TITLE' ,'DEFINE_DISCOUNT_COUPON_STATUS' ,'1' ,'LANGUAGES_DEFINE_DISCOUNT_COUPON_STATUS_DESCRIPTION' ,25 ,66 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_SITE_MAP_STATUS_TITLE' ,'DEFINE_SITE_MAP_STATUS' ,'1' ,'LANGUAGES_DEFINE_SITE_MAP_STATUS_DESCRIPTION' ,25 ,67 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_PAGE_NOT_FOUND_STATUS_TITLE' ,'DEFINE_PAGE_NOT_FOUND_STATUS' ,'1' ,'LANGUAGES_DEFINE_PAGE_NOT_FOUND_STATUS_DESCRIPTION' ,25 ,67 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_PAGE_2_STATUS_TITLE' ,'DEFINE_PAGE_2_STATUS' ,'1' ,'LANGUAGES_DEFINE_PAGE_2_STATUS_DESCRIPTION' ,25 ,82 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_PAGE_3_STATUS_TITLE' ,'DEFINE_PAGE_3_STATUS' ,'1' ,'LANGUAGES_DEFINE_PAGE_3_STATUS_DESCRIPTION' ,25 ,83 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_PAGE_4_STATUS_TITLE' ,'DEFINE_PAGE_4_STATUS' ,'1' ,'LANGUAGES_DEFINE_PAGE_4_STATUS_DESCRIPTION' ,25 ,84 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EZPAGES_STATUS_HEADER_TITLE' ,'EZPAGES_STATUS_HEADER' ,'1' ,'LANGUAGES_EZPAGES_STATUS_HEADER_DESCRIPTION' ,30 ,10 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EZPAGES_STATUS_FOOTER_TITLE' ,'EZPAGES_STATUS_FOOTER' ,'1' ,'LANGUAGES_EZPAGES_STATUS_FOOTER_DESCRIPTION' ,30 ,11 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EZPAGES_STATUS_SIDEBOX_TITLE' ,'EZPAGES_STATUS_SIDEBOX' ,'1' ,'LANGUAGES_EZPAGES_STATUS_SIDEBOX_DESCRIPTION' ,30 ,12 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EZPAGES_SEPARATOR_HEADER_TITLE' ,'EZPAGES_SEPARATOR_HEADER' ,'' ,'LANGUAGES_EZPAGES_SEPARATOR_HEADER_DESCRIPTION' ,30 ,20 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EZPAGES_SEPARATOR_FOOTER_TITLE' ,'EZPAGES_SEPARATOR_FOOTER' ,'::' ,'LANGUAGES_EZPAGES_SEPARATOR_FOOTER_DESCRIPTION' ,30 ,21 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EZPAGES_SHOW_PREV_NEXT_BUTTONS_TITLE' ,'EZPAGES_SHOW_PREV_NEXT_BUTTONS' ,'2' ,'LANGUAGES_EZPAGES_SHOW_PREV_NEXT_BUTTONS_DESCRIPTION' ,30 ,30 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EZPAGES_SHOW_TABLE_CONTENTS_TITLE' ,'EZPAGES_SHOW_TABLE_CONTENTS' ,'1' ,'LANGUAGES_EZPAGES_SHOW_TABLE_CONTENTS_DESCRIPTION' ,30 ,35 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EZPAGES_DISABLE_HEADER_DISPLAY_LIST_TITLE' ,'EZPAGES_DISABLE_HEADER_DISPLAY_LIST' ,'' ,'LANGUAGES_EZPAGES_DISABLE_HEADER_DISPLAY_LIST_DESCRIPTION' ,30 ,40 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EZPAGES_DISABLE_FOOTER_DISPLAY_LIST_TITLE' ,'EZPAGES_DISABLE_FOOTER_DISPLAY_LIST' ,'' ,'LANGUAGES_EZPAGES_DISABLE_FOOTER_DISPLAY_LIST_DESCRIPTION' ,30 ,41 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EZPAGES_DISABLE_LEFTCOLUMN_DISPLAY_LIST_TITLE' ,'EZPAGES_DISABLE_LEFTCOLUMN_DISPLAY_LIST' ,'' ,'LANGUAGES_EZPAGES_DISABLE_LEFTCOLUMN_DISPLAY_LIST_DESCRIPTION' ,30 ,42 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EZPAGES_DISABLE_RIGHTCOLUMN_DISPLAY_LIST_TITLE' ,'EZPAGES_DISABLE_RIGHTCOLUMN_DISPLAY_LIST' ,'' ,'LANGUAGES_EZPAGES_DISABLE_RIGHTCOLUMN_DISPLAY_LIST_DESCRIPTION' ,30 ,43 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EASYPOPULATE_CONFIG_TEMP_DIR_TITLE' ,'EASYPOPULATE_CONFIG_TEMP_DIR' ,'temp/' ,'LANGUAGES_EASYPOPULATE_CONFIG_TEMP_DIR_DESCRIPTION' ,31 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EASYPOPULATE_CONFIG_FILE_DATE_FORMAT_TITLE' ,'EASYPOPULATE_CONFIG_FILE_DATE_FORMAT' ,'y-m-d' ,'LANGUAGES_EASYPOPULATE_CONFIG_FILE_DATE_FORMAT_DESCRIPTION' ,31 ,1 ,now() ,'','zen_cfg_select_option(array("m-d-y", "d-m-y", "y-m-d"),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EASYPOPULATE_CONFIG_DEFAULT_RAW_TIME_TITLE' ,'EASYPOPULATE_CONFIG_DEFAULT_RAW_TIME' ,'09:00:00' ,'LANGUAGES_EASYPOPULATE_CONFIG_DEFAULT_RAW_TIME_DESCRIPTION' ,31 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EASYPOPULATE_CONFIG_SPLIT_MAX_TITLE' ,'EASYPOPULATE_CONFIG_SPLIT_MAX' ,'300' ,'LANGUAGES_EASYPOPULATE_CONFIG_SPLIT_MAX_DESCRIPTION' ,31 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EASYPOPULATE_CONFIG_MAX_CATEGORY_LEVELS_TITLE' ,'EASYPOPULATE_CONFIG_MAX_CATEGORY_LEVELS' ,'7' ,'LANGUAGES_EASYPOPULATE_CONFIG_MAX_CATEGORY_LEVELS_DESCRIPTION' ,31 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EASYPOPULATE_CONFIG_PRICE_INC_TAX_TITLE' ,'EASYPOPULATE_CONFIG_PRICE_INC_TAX' ,'false' ,'LANGUAGES_EASYPOPULATE_CONFIG_PRICE_INC_TAX_DESCRIPTION' ,31 ,5 ,now() ,'','zen_cfg_select_option(array("true", "false"),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EASYPOPULATE_CONFIG_ZERO_QTY_INACTIVE_TITLE' ,'EASYPOPULATE_CONFIG_ZERO_QTY_INACTIVE' ,'false' ,'LANGUAGES_EASYPOPULATE_CONFIG_ZERO_QTY_INACTIVE_DESCRIPTION' ,31 ,6 ,now() ,'','zen_cfg_select_option(array("true", "false"),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EASYPOPULATE_CONFIG_SMART_TAGS_TITLE' ,'EASYPOPULATE_CONFIG_SMART_TAGS' ,'true' ,'LANGUAGES_EASYPOPULATE_CONFIG_SMART_TAGS_DESCRIPTION' ,31 ,7 ,now() ,'','zen_cfg_select_option(array("true", "false"),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EASYPOPULATE_CONFIG_ADV_SMART_TAGS_TITLE' ,'EASYPOPULATE_CONFIG_ADV_SMART_TAGS' ,'false' ,'LANGUAGES_EASYPOPULATE_CONFIG_ADV_SMART_TAGS_DESCRIPTION' ,31 ,8 ,now() ,'','zen_cfg_select_option(array("true", "false"),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_EASYPOPULATE_CONFIG_DEBUG_LOGGING_TITLE' ,'EASYPOPULATE_CONFIG_DEBUG_LOGGING' ,'true' ,'LANGUAGES_EASYPOPULATE_CONFIG_DEBUG_LOGGING_DESCRIPTION' ,31 ,9 ,now() ,'','zen_cfg_select_option(array("true", "false"),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES__TITLE' ,'' ,'' ,'LANGUAGES__DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_WEIGHT_TITLE' ,'DEFAULT_WEIGHT' ,'1' ,'LANGUAGES_DEFAULT_WEIGHT_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_VALUATION_TITLE' ,'DEFAULT_VALUATION' ,'1' ,'LANGUAGES_DEFAULT_VALUATION_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_PHOTO_EFFECTS_TITLE' ,'SHOW_BANNERS_PHOTO_EFFECTS' ,'slidebanner' ,'LANGUAGES_SHOW_BANNERS_PHOTO_EFFECTS_DESCRIPTION' ,19 ,81 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_PHOTO_EFFECTS_TEMPLATES_TITLE' ,'SHOW_BANNERS_PHOTO_EFFECTS_TEMPLATES' ,'jsxh' ,'LANGUAGES_SHOW_BANNERS_PHOTO_EFFECTS_TEMPLATES_DESCRIPTION' ,19 ,81 ,now() ,'','zen_photoeffects_select_option(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_STATUS_TITLE' ,'MODULE_ORDER_TOTAL_COD_STATUS' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_STATUS_DESCRIPTION' ,6 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_SORT_ORDER_TITLE' ,'MODULE_ORDER_TOTAL_COD_SORT_ORDER' ,'950' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_SORT_ORDER_DESCRIPTION' ,6 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_FLAT_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_FLAT' ,'AT:3.00,DE:3.58,00:9.99' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_FLAT_DESCRIPTION' ,6 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_FREE_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_FREE' ,'US:3.00' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_FREE_DESCRIPTION' ,6 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_FREESHIPPER_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_FREESHIPPER' ,'CA:4.50,US:3.00,00:9.99' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_FREESHIPPER_DESCRIPTION' ,6 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_FREEOPTIONS_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_FREEOPTIONS' ,'CA:4.50,US:3.00,00:9.99' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_FREEOPTIONS_DESCRIPTION' ,6 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_PERWEIGHTUNIT_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_PERWEIGHTUNIT' ,'CA:4.50,US:3.00,00:9.99' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_PERWEIGHTUNIT_DESCRIPTION' ,6 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_ITEM_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_ITEM' ,'AT:3.00,DE:3.58,00:9.99' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_ITEM_DESCRIPTION' ,6 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_TABLE_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_TABLE' ,'AT:3.00,DE:3.58,00:9.99' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_TABLE_DESCRIPTION' ,6 ,5 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_UPS_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_UPS' ,'CA:4.50,US:3.00,00:9.99' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_UPS_DESCRIPTION' ,6 ,6 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_USPS_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_USPS' ,'CA:4.50,US:3.00,00:9.99' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_USPS_DESCRIPTION' ,6 ,7 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_ZONES_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_ZONES' ,'CA:4.50,US:3.00,00:9.99' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_ZONES_DESCRIPTION' ,6 ,8 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_AP_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_AP' ,'AT:3.63,00:9.99' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_AP_DESCRIPTION' ,6 ,9 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_DP_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_DP' ,'DE:3.58,00:9.99' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_DP_DESCRIPTION' ,6 ,10 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_SERVICEPAKKE_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_SERVICEPAKKE' ,'NO:69' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_SERVICEPAKKE_DESCRIPTION' ,6 ,11 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_FEDEX_TITLE' ,'MODULE_ORDER_TOTAL_COD_FEE_FEDEX' ,'US:3.00' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_FEE_FEDEX_DESCRIPTION' ,6 ,12 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COD_TAX_CLASS_TITLE' ,'MODULE_ORDER_TOTAL_COD_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_ORDER_TOTAL_COD_TAX_CLASS_DESCRIPTION' ,6 ,25 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COUPON_STATUS_TITLE' ,'MODULE_ORDER_TOTAL_COUPON_STATUS' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_COUPON_STATUS_DESCRIPTION' ,6 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COUPON_SORT_ORDER_TITLE' ,'MODULE_ORDER_TOTAL_COUPON_SORT_ORDER' ,'280' ,'LANGUAGES_MODULE_ORDER_TOTAL_COUPON_SORT_ORDER_DESCRIPTION' ,6 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING_TITLE' ,'MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING_DESCRIPTION' ,6 ,5 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COUPON_INC_TAX_TITLE' ,'MODULE_ORDER_TOTAL_COUPON_INC_TAX' ,'false' ,'LANGUAGES_MODULE_ORDER_TOTAL_COUPON_INC_TAX_DESCRIPTION' ,6 ,6 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COUPON_CALC_TAX_TITLE' ,'MODULE_ORDER_TOTAL_COUPON_CALC_TAX' ,'Standard' ,'LANGUAGES_MODULE_ORDER_TOTAL_COUPON_CALC_TAX_DESCRIPTION' ,6 ,7 ,now() ,'','zen_cfg_select_option(array(\'None\', \'Standard\', \'Credit Note\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_COUPON_TAX_CLASS_TITLE' ,'MODULE_ORDER_TOTAL_COUPON_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_ORDER_TOTAL_COUPON_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_STATUS_TITLE' ,'MODULE_ORDER_TOTAL_GROUP_PRICING_STATUS' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_STATUS_DESCRIPTION' ,6 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_SORT_ORDER_TITLE' ,'MODULE_ORDER_TOTAL_GROUP_PRICING_SORT_ORDER' ,'290' ,'LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_SORT_ORDER_DESCRIPTION' ,6 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_INC_SHIPPING_TITLE' ,'MODULE_ORDER_TOTAL_GROUP_PRICING_INC_SHIPPING' ,'false' ,'LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_INC_SHIPPING_DESCRIPTION' ,6 ,5 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_INC_TAX_TITLE' ,'MODULE_ORDER_TOTAL_GROUP_PRICING_INC_TAX' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_INC_TAX_DESCRIPTION' ,6 ,6 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_CALC_TAX_TITLE' ,'MODULE_ORDER_TOTAL_GROUP_PRICING_CALC_TAX' ,'Standard' ,'LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_CALC_TAX_DESCRIPTION' ,6 ,7 ,now() ,'','zen_cfg_select_option(array(\'None\', \'Standard\', \'Credit Note\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_TAX_CLASS_TITLE' ,'MODULE_ORDER_TOTAL_GROUP_PRICING_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_ORDER_TOTAL_GROUP_PRICING_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GV_STATUS_TITLE' ,'MODULE_ORDER_TOTAL_GV_STATUS' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_GV_STATUS_DESCRIPTION' ,6 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GV_SORT_ORDER_TITLE' ,'MODULE_ORDER_TOTAL_GV_SORT_ORDER' ,'840' ,'LANGUAGES_MODULE_ORDER_TOTAL_GV_SORT_ORDER_DESCRIPTION' ,6 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GV_QUEUE_TITLE' ,'MODULE_ORDER_TOTAL_GV_QUEUE' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_GV_QUEUE_DESCRIPTION' ,6 ,3 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GV_INC_SHIPPING_TITLE' ,'MODULE_ORDER_TOTAL_GV_INC_SHIPPING' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_GV_INC_SHIPPING_DESCRIPTION' ,6 ,5 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GV_INC_TAX_TITLE' ,'MODULE_ORDER_TOTAL_GV_INC_TAX' ,'false' ,'LANGUAGES_MODULE_ORDER_TOTAL_GV_INC_TAX_DESCRIPTION' ,6 ,6 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GV_CALC_TAX_TITLE' ,'MODULE_ORDER_TOTAL_GV_CALC_TAX' ,'None' ,'LANGUAGES_MODULE_ORDER_TOTAL_GV_CALC_TAX_DESCRIPTION' ,6 ,7 ,now() ,'','zen_cfg_select_option(array(\'None\', \'Standard\', \'Credit Note\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GV_TAX_CLASS_TITLE' ,'MODULE_ORDER_TOTAL_GV_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_ORDER_TOTAL_GV_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GV_CREDIT_TAX_TITLE' ,'MODULE_ORDER_TOTAL_GV_CREDIT_TAX' ,'false' ,'LANGUAGES_MODULE_ORDER_TOTAL_GV_CREDIT_TAX_DESCRIPTION' ,6 ,8 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_GV_ORDER_STATUS_ID_TITLE' ,'MODULE_ORDER_TOTAL_GV_ORDER_STATUS_ID' ,'0' ,'LANGUAGES_MODULE_ORDER_TOTAL_GV_ORDER_STATUS_ID_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_order_status_name','zen_cfg_pull_down_order_statuses(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS_TITLE' ,'MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS_DESCRIPTION' ,6 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER_TITLE' ,'MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER' ,'400' ,'LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER_DESCRIPTION' ,6 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_LOW_ORDER_FEE_TITLE' ,'MODULE_ORDER_TOTAL_LOWORDERFEE_LOW_ORDER_FEE' ,'false' ,'LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_LOW_ORDER_FEE_DESCRIPTION' ,6 ,3 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER_TITLE' ,'MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER' ,'50' ,'LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER_DESCRIPTION' ,6 ,4 ,now() ,'currencies->format','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_FEE_TITLE' ,'MODULE_ORDER_TOTAL_LOWORDERFEE_FEE' ,'5' ,'LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_FEE_DESCRIPTION' ,6 ,5 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_DESTINATION_TITLE' ,'MODULE_ORDER_TOTAL_LOWORDERFEE_DESTINATION' ,'both' ,'LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_DESTINATION_DESCRIPTION' ,6 ,6 ,now() ,'','zen_cfg_select_option(array(\'national\', \'international\', \'both\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS_TITLE' ,'MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS_DESCRIPTION' ,6 ,7 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_VIRTUAL_TITLE' ,'MODULE_ORDER_TOTAL_LOWORDERFEE_VIRTUAL' ,'false' ,'LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_VIRTUAL_DESCRIPTION' ,6 ,8 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_GV_TITLE' ,'MODULE_ORDER_TOTAL_LOWORDERFEE_GV' ,'false' ,'LANGUAGES_MODULE_ORDER_TOTAL_LOWORDERFEE_GV_DESCRIPTION' ,6 ,9 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_SHIPPING_STATUS_TITLE' ,'MODULE_ORDER_TOTAL_SHIPPING_STATUS' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_SHIPPING_STATUS_DESCRIPTION' ,6 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER_TITLE' ,'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER' ,'200' ,'LANGUAGES_MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER_DESCRIPTION' ,6 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_TITLE' ,'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING' ,'false' ,'LANGUAGES_MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_DESCRIPTION' ,6 ,3 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER_TITLE' ,'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER' ,'50' ,'LANGUAGES_MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER_DESCRIPTION' ,6 ,4 ,now() ,'currencies->format','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_SHIPPING_DESTINATION_TITLE' ,'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION' ,'national' ,'LANGUAGES_MODULE_ORDER_TOTAL_SHIPPING_DESTINATION_DESCRIPTION' ,6 ,5 ,now() ,'','zen_cfg_select_option(array(\'national\', \'international\', \'both\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_SUBTOTAL_STATUS_TITLE' ,'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_SUBTOTAL_STATUS_DESCRIPTION' ,6 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER_TITLE' ,'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER' ,'100' ,'LANGUAGES_MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER_DESCRIPTION' ,6 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_TAX_STATUS_TITLE' ,'MODULE_ORDER_TOTAL_TAX_STATUS' ,'true' ,'LANGUAGES_MODULE_ORDER_TOTAL_TAX_STATUS_DESCRIPTION' ,6 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_ORDER_TOTAL_TAX_SORT_ORDER_TITLE' ,'MODULE_ORDER_TOTAL_TAX_SORT_ORDER' ,'300' ,'LANGUAGES_MODULE_ORDER_TOTAL_TAX_SORT_ORDER_DESCRIPTION' ,6 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_LISTING_COLUMNS_PRODUCTS_TITLE' ,'SHOW_PRODUCT_LISTING_COLUMNS_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCT_LISTING_COLUMNS_PRODUCTS_DESCRIPTION' ,3 ,12 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCTS_ALL_LISTING_COLUMNS_PRODUCTS_TITLE' ,'SHOW_PRODUCTS_ALL_LISTING_COLUMNS_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCTS_ALL_LISTING_COLUMNS_PRODUCTS_DESCRIPTION' ,3 ,11 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCTS_NEW_COLUMNS_PRODUCTS_TITLE' ,'SHOW_PRODUCTS_NEW_COLUMNS_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCTS_NEW_COLUMNS_PRODUCTS_DESCRIPTION' ,3 ,9 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_SPECIAL_PRODUCTS_COLUMNS_PRODUCTS_TITLE' ,'SHOW_SPECIAL_PRODUCTS_COLUMNS_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_SPECIAL_PRODUCTS_COLUMNS_PRODUCTS_DESCRIPTION' ,3 ,8 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCTS_FEATURED_COLUMNS_PRODUCTS_TITLE' ,'SHOW_PRODUCTS_FEATURED_COLUMNS_PRODUCTS' ,'3' ,'LANGUAGES_SHOW_PRODUCTS_FEATURED_COLUMNS_PRODUCTS_DESCRIPTION' ,3 ,29 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_BANNERS_PHOTO_EFFECTS_TIME_TITLE' ,'SHOW_BANNERS_PHOTO_EFFECTS_TIME' ,'4' ,'LANGUAGES_SHOW_BANNERS_PHOTO_EFFECTS_TIME_DESCRIPTION' ,19 ,81 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_NEWSONLY_SUBSCRIPTION_ENABLED_TITLE' ,'NEWSONLY_SUBSCRIPTION_ENABLED' ,'true' ,'LANGUAGES_NEWSONLY_SUBSCRIPTION_ENABLED_DESCRIPTION' ,1 ,200 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_NEWSONLY_SUBSCRIPTION_HEADER_TITLE' ,'NEWSONLY_SUBSCRIPTION_HEADER' ,'true' ,'LANGUAGES_NEWSONLY_SUBSCRIPTION_HEADER_DESCRIPTION' ,19 ,200 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_NEWSONLY_SUBSCRIPTION_CC_STATUS_TITLE' ,'NEWSONLY_SUBSCRIPTION_CC_STATUS' ,'0' ,'LANGUAGES_NEWSONLY_SUBSCRIPTION_CC_STATUS_DESCRIPTION' ,12 ,200 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_NEWSONLY_SUBSCRIPTION_CC_TITLE' ,'NEWSONLY_SUBSCRIPTION_CC' ,'' ,'LANGUAGES_NEWSONLY_SUBSCRIPTION_CC_DESCRIPTION' ,12 ,201 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_NEWSONLY_SUBSCRIPTION_TEST_GROUP_TITLE' ,'NEWSONLY_SUBSCRIPTION_TEST_GROUP' ,'' ,'LANGUAGES_NEWSONLY_SUBSCRIPTION_TEST_GROUP_DESCRIPTION' ,12 ,202 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_DISPLAY_ID_TITLE' ,'QUICKUPDATES_DISPLAY_ID' ,'true' ,'LANGUAGES_QUICKUPDATES_DISPLAY_ID_DESCRIPTION' ,32 ,1 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_DISPLAY_TRUMBNAIL_TITLE' ,'QUICKUPDATES_DISPLAY_TRUMBNAIL' ,'true' ,'LANGUAGES_QUICKUPDATES_DISPLAY_TRUMBNAIL_DESCRIPTION' ,32 ,2 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_MODIFY_MODEL_TITLE' ,'QUICKUPDATES_MODIFY_MODEL' ,'true' ,'LANGUAGES_QUICKUPDATES_MODIFY_MODEL_DESCRIPTION' ,32 ,3 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_MODIFY_NAME_TITLE' ,'QUICKUPDATES_MODIFY_NAME' ,'true' ,'LANGUAGES_QUICKUPDATES_MODIFY_NAME_DESCRIPTION' ,32 ,4 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_MODIFY_DESCRIPTION_TITLE' ,'QUICKUPDATES_MODIFY_DESCRIPTION' ,'true' ,'LANGUAGES_QUICKUPDATES_MODIFY_DESCRIPTION_DESCRIPTION' ,32 ,5 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_MODIFY_STATUS_TITLE' ,'QUICKUPDATES_MODIFY_STATUS' ,'true' ,'LANGUAGES_QUICKUPDATES_MODIFY_STATUS_DESCRIPTION' ,32 ,6 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_MODIFY_WEIGHT_TITLE' ,'QUICKUPDATES_MODIFY_WEIGHT' ,'true' ,'LANGUAGES_QUICKUPDATES_MODIFY_WEIGHT_DESCRIPTION' ,32 ,7 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_MODIFY_QUANTITY_TITLE' ,'QUICKUPDATES_MODIFY_QUANTITY' ,'true' ,'LANGUAGES_QUICKUPDATES_MODIFY_QUANTITY_DESCRIPTION' ,32 ,8 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_MODIFY_MANUFACTURER_TITLE' ,'QUICKUPDATES_MODIFY_MANUFACTURER' ,'false' ,'LANGUAGES_QUICKUPDATES_MODIFY_MANUFACTURER_DESCRIPTION' ,32 ,9 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_MODIFY_TAX_TITLE' ,'QUICKUPDATES_MODIFY_TAX' ,'false' ,'LANGUAGES_QUICKUPDATES_MODIFY_TAX_DESCRIPTION' ,32 ,10 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_MODIFY_CATEGORY_TITLE' ,'QUICKUPDATES_MODIFY_CATEGORY' ,'true' ,'LANGUAGES_QUICKUPDATES_MODIFY_CATEGORY_DESCRIPTION' ,32 ,11 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_DISPLAY_TVA_OVER_TITLE' ,'QUICKUPDATES_DISPLAY_TVA_OVER' ,'true' ,'LANGUAGES_QUICKUPDATES_DISPLAY_TVA_OVER_DESCRIPTION' ,32 ,20 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_DISPLAY_PREVIEW_TITLE' ,'QUICKUPDATES_DISPLAY_PREVIEW' ,'false' ,'LANGUAGES_QUICKUPDATES_DISPLAY_PREVIEW_DESCRIPTION' ,32 ,30 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_DISPLAY_EDIT_TITLE' ,'QUICKUPDATES_DISPLAY_EDIT' ,'true' ,'LANGUAGES_QUICKUPDATES_DISPLAY_EDIT_DESCRIPTION' ,32 ,31 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_ACTIVATE_COMMERCIAL_MARGIN_TITLE' ,'QUICKUPDATES_ACTIVATE_COMMERCIAL_MARGIN' ,'true' ,'LANGUAGES_QUICKUPDATES_ACTIVATE_COMMERCIAL_MARGIN_DESCRIPTION' ,32 ,40 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_MODIFY_SORT_ORDER_TITLE' ,'QUICKUPDATES_MODIFY_SORT_ORDER' ,'true' ,'LANGUAGES_QUICKUPDATES_MODIFY_SORT_ORDER_DESCRIPTION' ,32 ,11 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_QUICKUPDATES_MODIFY_DESCRIPTION_POPUP_TITLE' ,'QUICKUPDATES_MODIFY_DESCRIPTION_POPUP' ,'true' ,'LANGUAGES_QUICKUPDATES_MODIFY_DESCRIPTION_POPUP_DESCRIPTION' ,32 ,11 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_NEWSONLY_SUBSCRIPTION_VERSION_TITLE' ,'NEWSONLY_SUBSCRIPTION_VERSION' ,'205' ,'LANGUAGES_NEWSONLY_SUBSCRIPTION_VERSION_DESCRIPTION' ,0 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_TESTIMONIALS_MANAGER_TITLES_TITLE' ,'MAX_DISPLAY_TESTIMONIALS_MANAGER_TITLES' ,'5' ,'LANGUAGES_MAX_DISPLAY_TESTIMONIALS_MANAGER_TITLES_DESCRIPTION' ,33 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_TESTIMONIALS_TITLE_MIN_LENGTH_TITLE' ,'ENTRY_TESTIMONIALS_TITLE_MIN_LENGTH' ,'2' ,'LANGUAGES_ENTRY_TESTIMONIALS_TITLE_MIN_LENGTH_DESCRIPTION' ,33 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_TESTIMONIALS_TEXT_MIN_LENGTH_TITLE' ,'ENTRY_TESTIMONIALS_TEXT_MIN_LENGTH' ,'10' ,'LANGUAGES_ENTRY_TESTIMONIALS_TEXT_MIN_LENGTH_DESCRIPTION' ,33 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_TESTIMONIALS_TEXT_MAX_LENGTH_TITLE' ,'ENTRY_TESTIMONIALS_TEXT_MAX_LENGTH' ,'1000' ,'LANGUAGES_ENTRY_TESTIMONIALS_TEXT_MAX_LENGTH_DESCRIPTION' ,33 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ENTRY_TESTIMONIALS_CONTACT_NAME_MIN_LENGTH_TITLE' ,'ENTRY_TESTIMONIALS_CONTACT_NAME_MIN_LENGTH' ,'2' ,'LANGUAGES_ENTRY_TESTIMONIALS_CONTACT_NAME_MIN_LENGTH_DESCRIPTION' ,33 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_TESTIMONIALS_MANAGER_TRUNCATED_TEXT_TITLE' ,'DISPLAY_TESTIMONIALS_MANAGER_TRUNCATED_TEXT' ,'true' ,'LANGUAGES_DISPLAY_TESTIMONIALS_MANAGER_TRUNCATED_TEXT_DESCRIPTION' ,33 ,5 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TESTIMONIALS_MANAGER_DESCRIPTION_LENGTH_TITLE' ,'TESTIMONIALS_MANAGER_DESCRIPTION_LENGTH' ,'150' ,'LANGUAGES_TESTIMONIALS_MANAGER_DESCRIPTION_LENGTH_DESCRIPTION' ,33 ,6 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MAX_DISPLAY_TESTIMONIALS_MANAGER_ALL_TESTIMONIALS_TITLE' ,'MAX_DISPLAY_TESTIMONIALS_MANAGER_ALL_TESTIMONIALS' ,'5' ,'LANGUAGES_MAX_DISPLAY_TESTIMONIALS_MANAGER_ALL_TESTIMONIALS_DESCRIPTION' ,33 ,7 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_TESTIMONIALS_DATE_PUBLISHED_TITLE' ,'DISPLAY_TESTIMONIALS_DATE_PUBLISHED' ,'true' ,'LANGUAGES_DISPLAY_TESTIMONIALS_DATE_PUBLISHED_DESCRIPTION' ,33 ,8 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_ALL_TESTIMONIALS_TESTIMONIALS_MANAGER_LINK_TITLE' ,'DISPLAY_ALL_TESTIMONIALS_TESTIMONIALS_MANAGER_LINK' ,'true' ,'LANGUAGES_DISPLAY_ALL_TESTIMONIALS_TESTIMONIALS_MANAGER_LINK_DESCRIPTION' ,33 ,9 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DISPLAY_ADD_TESTIMONIAL_LINK_TITLE' ,'DISPLAY_ADD_TESTIMONIAL_LINK' ,'true' ,'LANGUAGES_DISPLAY_ADD_TESTIMONIAL_LINK_DESCRIPTION' ,33 ,10 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TESTIMONIAL_IMAGE_WIDTH_TITLE' ,'TESTIMONIAL_IMAGE_WIDTH' ,'80' ,'LANGUAGES_TESTIMONIAL_IMAGE_WIDTH_DESCRIPTION' ,33 ,11 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TESTIMONIAL_IMAGE_HEIGHT_TITLE' ,'TESTIMONIAL_IMAGE_HEIGHT' ,'80' ,'LANGUAGES_TESTIMONIAL_IMAGE_HEIGHT_DESCRIPTION' ,33 ,12 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TESTIMONIAL_IMAGE_DIRECTORY_TITLE' ,'TESTIMONIAL_IMAGE_DIRECTORY' ,'testimonials/' ,'LANGUAGES_TESTIMONIAL_IMAGE_DIRECTORY_DESCRIPTION' ,33 ,13 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TESTIMONIALS_COMPANY_TITLE' ,'TESTIMONIALS_COMPANY' ,'true' ,'LANGUAGES_TESTIMONIALS_COMPANY_DESCRIPTION' ,33 ,14 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TESTIMONIALS_CITY_TITLE' ,'TESTIMONIALS_CITY' ,'true' ,'LANGUAGES_TESTIMONIALS_CITY_DESCRIPTION' ,33 ,15 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TESTIMONIALS_COUNTRY_TITLE' ,'TESTIMONIALS_COUNTRY' ,'true' ,'LANGUAGES_TESTIMONIALS_COUNTRY_DESCRIPTION' ,33 ,16 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_REGISTERED_TESTIMONIAL_TITLE' ,'REGISTERED_TESTIMONIAL' ,'true' ,'LANGUAGES_REGISTERED_TESTIMONIAL_DESCRIPTION' ,33 ,17 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TESTIMONIALS_DISPLAY_ALL_LANGUAGES_TITLE' ,'TESTIMONIALS_DISPLAY_ALL_LANGUAGES' ,'true' ,'LANGUAGES_TESTIMONIALS_DISPLAY_ALL_LANGUAGES_DESCRIPTION' ,33 ,18 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_TESTIMONIAL_STORE_NAME_ADDRESS_TITLE' ,'TESTIMONIAL_STORE_NAME_ADDRESS' ,'true' ,'LANGUAGES_TESTIMONIAL_STORE_NAME_ADDRESS_DESCRIPTION' ,33 ,19 ,now() ,'','zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFINE_TESTIMONIAL_STATUS_TITLE' ,'DEFINE_TESTIMONIAL_STATUS' ,'1' ,'LANGUAGES_DEFINE_TESTIMONIAL_STATUS_DESCRIPTION' ,25 ,999 ,now() ,'','zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FLAT_STATUS_TITLE' ,'MODULE_SHIPPING_FLAT_STATUS' ,'True' ,'LANGUAGES_MODULE_SHIPPING_FLAT_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FLAT_COST_TITLE' ,'MODULE_SHIPPING_FLAT_COST' ,'5.00' ,'LANGUAGES_MODULE_SHIPPING_FLAT_COST_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FLAT_TAX_CLASS_TITLE' ,'MODULE_SHIPPING_FLAT_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_SHIPPING_FLAT_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FLAT_TAX_BASIS_TITLE' ,'MODULE_SHIPPING_FLAT_TAX_BASIS' ,'Shipping' ,'LANGUAGES_MODULE_SHIPPING_FLAT_TAX_BASIS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Shipping\', \'Billing\', \'Store\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FLAT_ZONE_TITLE' ,'MODULE_SHIPPING_FLAT_ZONE' ,'0' ,'LANGUAGES_MODULE_SHIPPING_FLAT_ZONE_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FLAT_SORT_ORDER_TITLE' ,'MODULE_SHIPPING_FLAT_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_SHIPPING_FLAT_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ITEM_STATUS_TITLE' ,'MODULE_SHIPPING_ITEM_STATUS' ,'True' ,'LANGUAGES_MODULE_SHIPPING_ITEM_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ITEM_COST_TITLE' ,'MODULE_SHIPPING_ITEM_COST' ,'2.50' ,'LANGUAGES_MODULE_SHIPPING_ITEM_COST_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ITEM_HANDLING_TITLE' ,'MODULE_SHIPPING_ITEM_HANDLING' ,'0' ,'LANGUAGES_MODULE_SHIPPING_ITEM_HANDLING_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ITEM_TAX_CLASS_TITLE' ,'MODULE_SHIPPING_ITEM_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_SHIPPING_ITEM_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ITEM_TAX_BASIS_TITLE' ,'MODULE_SHIPPING_ITEM_TAX_BASIS' ,'Shipping' ,'LANGUAGES_MODULE_SHIPPING_ITEM_TAX_BASIS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Shipping\', \'Billing\', \'Store\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ITEM_ZONE_TITLE' ,'MODULE_SHIPPING_ITEM_ZONE' ,'0' ,'LANGUAGES_MODULE_SHIPPING_ITEM_ZONE_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ITEM_SORT_ORDER_TITLE' ,'MODULE_SHIPPING_ITEM_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_SHIPPING_ITEM_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_STATUS_TITLE' ,'MODULE_SHIPPING_PERWEIGHTUNIT_STATUS' ,'True' ,'LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_COST_TITLE' ,'MODULE_SHIPPING_PERWEIGHTUNIT_COST' ,'1' ,'LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_COST_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_HANDLING_TITLE' ,'MODULE_SHIPPING_PERWEIGHTUNIT_HANDLING' ,'0' ,'LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_HANDLING_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_HANDLING_METHOD_TITLE' ,'MODULE_SHIPPING_PERWEIGHTUNIT_HANDLING_METHOD' ,'Order' ,'LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_HANDLING_METHOD_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Order\', \'Box\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_TAX_CLASS_TITLE' ,'MODULE_SHIPPING_PERWEIGHTUNIT_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_TAX_BASIS_TITLE' ,'MODULE_SHIPPING_PERWEIGHTUNIT_TAX_BASIS' ,'Shipping' ,'LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_TAX_BASIS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Shipping\', \'Billing\', \'Store\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_ZONE_TITLE' ,'MODULE_SHIPPING_PERWEIGHTUNIT_ZONE' ,'0' ,'LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_ZONE_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_SORT_ORDER_TITLE' ,'MODULE_SHIPPING_PERWEIGHTUNIT_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_SHIPPING_PERWEIGHTUNIT_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_STOREPICKUP_STATUS_TITLE' ,'MODULE_SHIPPING_STOREPICKUP_STATUS' ,'True' ,'LANGUAGES_MODULE_SHIPPING_STOREPICKUP_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_STOREPICKUP_COST_TITLE' ,'MODULE_SHIPPING_STOREPICKUP_COST' ,'0.00' ,'LANGUAGES_MODULE_SHIPPING_STOREPICKUP_COST_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_STOREPICKUP_TAX_CLASS_TITLE' ,'MODULE_SHIPPING_STOREPICKUP_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_SHIPPING_STOREPICKUP_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_STOREPICKUP_TAX_BASIS_TITLE' ,'MODULE_SHIPPING_STOREPICKUP_TAX_BASIS' ,'Shipping' ,'LANGUAGES_MODULE_SHIPPING_STOREPICKUP_TAX_BASIS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Shipping\', \'Billing\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_STOREPICKUP_ZONE_TITLE' ,'MODULE_SHIPPING_STOREPICKUP_ZONE' ,'0' ,'LANGUAGES_MODULE_SHIPPING_STOREPICKUP_ZONE_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_STOREPICKUP_SORT_ORDER_TITLE' ,'MODULE_SHIPPING_STOREPICKUP_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_SHIPPING_STOREPICKUP_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_TABLE_STATUS_TITLE' ,'MODULE_SHIPPING_TABLE_STATUS' ,'True' ,'LANGUAGES_MODULE_SHIPPING_TABLE_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_TABLE_COST_TITLE' ,'MODULE_SHIPPING_TABLE_COST' ,'25:8.50,50:5.50,10000:0.00' ,'LANGUAGES_MODULE_SHIPPING_TABLE_COST_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_textarea(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_TABLE_MODE_TITLE' ,'MODULE_SHIPPING_TABLE_MODE' ,'weight' ,'LANGUAGES_MODULE_SHIPPING_TABLE_MODE_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'weight\', \'price\', \'item\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_TABLE_HANDLING_TITLE' ,'MODULE_SHIPPING_TABLE_HANDLING' ,'0' ,'LANGUAGES_MODULE_SHIPPING_TABLE_HANDLING_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_TABLE_HANDLING_METHOD_TITLE' ,'MODULE_SHIPPING_TABLE_HANDLING_METHOD' ,'Order' ,'LANGUAGES_MODULE_SHIPPING_TABLE_HANDLING_METHOD_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Order\', \'Box\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_TABLE_TAX_CLASS_TITLE' ,'MODULE_SHIPPING_TABLE_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_SHIPPING_TABLE_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_TABLE_TAX_BASIS_TITLE' ,'MODULE_SHIPPING_TABLE_TAX_BASIS' ,'Shipping' ,'LANGUAGES_MODULE_SHIPPING_TABLE_TAX_BASIS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Shipping\', \'Billing\', \'Store\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_TABLE_ZONE_TITLE' ,'MODULE_SHIPPING_TABLE_ZONE' ,'0' ,'LANGUAGES_MODULE_SHIPPING_TABLE_ZONE_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_TABLE_SORT_ORDER_TITLE' ,'MODULE_SHIPPING_TABLE_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_SHIPPING_TABLE_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_UPS_STATUS_TITLE' ,'MODULE_SHIPPING_UPS_STATUS' ,'True' ,'LANGUAGES_MODULE_SHIPPING_UPS_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_UPS_PICKUP_TITLE' ,'MODULE_SHIPPING_UPS_PICKUP' ,'CC' ,'LANGUAGES_MODULE_SHIPPING_UPS_PICKUP_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_UPS_PACKAGE_TITLE' ,'MODULE_SHIPPING_UPS_PACKAGE' ,'CP' ,'LANGUAGES_MODULE_SHIPPING_UPS_PACKAGE_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_UPS_RES_TITLE' ,'MODULE_SHIPPING_UPS_RES' ,'RES' ,'LANGUAGES_MODULE_SHIPPING_UPS_RES_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_UPS_HANDLING_TITLE' ,'MODULE_SHIPPING_UPS_HANDLING' ,'0' ,'LANGUAGES_MODULE_SHIPPING_UPS_HANDLING_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_UPS_HANDLING_METHOD_TITLE' ,'MODULE_SHIPPING_UPS_HANDLING_METHOD' ,'Box' ,'LANGUAGES_MODULE_SHIPPING_UPS_HANDLING_METHOD_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Order\', \'Box\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_UPS_TAX_CLASS_TITLE' ,'MODULE_SHIPPING_UPS_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_SHIPPING_UPS_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_UPS_TAX_BASIS_TITLE' ,'MODULE_SHIPPING_UPS_TAX_BASIS' ,'Shipping' ,'LANGUAGES_MODULE_SHIPPING_UPS_TAX_BASIS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Shipping\', \'Billing\', \'Store\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_UPS_ZONE_TITLE' ,'MODULE_SHIPPING_UPS_ZONE' ,'0' ,'LANGUAGES_MODULE_SHIPPING_UPS_ZONE_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_UPS_SORT_ORDER_TITLE' ,'MODULE_SHIPPING_UPS_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_SHIPPING_UPS_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_UPS_TYPES_TITLE' ,'MODULE_SHIPPING_UPS_TYPES' ,'1DM, 1DML, 1DA, 1DAL, 1DAPI, 1DP, 1DPL, 2DM, 2DML, 2DA, 2DAL, 3DS, GND, STD, XPR, XPRL, XDM, XDML, XPD, WXS' ,'LANGUAGES_MODULE_SHIPPING_UPS_TYPES_DESCRIPTION' ,6 ,13 ,now() ,'','zen_cfg_select_multioption(array(\'1DM\',\'1DML\', \'1DA\', \'1DAL\', \'1DAPI\', \'1DP\', \'1DPL\', \'2DM\', \'2DML\', \'2DA\', \'2DAL\', \'3DS\',\'GND\', \'STD\', \'XPR\', \'XPRL\', \'XDM\', \'XDML\', \'XPD\', \'WXS\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_STATUS_TITLE' ,'MODULE_SHIPPING_USPS_STATUS' ,'True' ,'LANGUAGES_MODULE_SHIPPING_USPS_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_USERID_TITLE' ,'MODULE_SHIPPING_USPS_USERID' ,'NONE' ,'LANGUAGES_MODULE_SHIPPING_USPS_USERID_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_SERVER_TITLE' ,'MODULE_SHIPPING_USPS_SERVER' ,'production' ,'LANGUAGES_MODULE_SHIPPING_USPS_SERVER_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'test\', \'production\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_MACHINABLE_TITLE' ,'MODULE_SHIPPING_USPS_MACHINABLE' ,'False' ,'LANGUAGES_MODULE_SHIPPING_USPS_MACHINABLE_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_HANDLING_TITLE' ,'MODULE_SHIPPING_USPS_HANDLING' ,'0' ,'LANGUAGES_MODULE_SHIPPING_USPS_HANDLING_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_HANDLING_METHOD_TITLE' ,'MODULE_SHIPPING_USPS_HANDLING_METHOD' ,'Box' ,'LANGUAGES_MODULE_SHIPPING_USPS_HANDLING_METHOD_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Order\', \'Box\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_TAX_CLASS_TITLE' ,'MODULE_SHIPPING_USPS_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_SHIPPING_USPS_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_TAX_BASIS_TITLE' ,'MODULE_SHIPPING_USPS_TAX_BASIS' ,'Shipping' ,'LANGUAGES_MODULE_SHIPPING_USPS_TAX_BASIS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Shipping\', \'Billing\', \'Store\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_ZONE_TITLE' ,'MODULE_SHIPPING_USPS_ZONE' ,'0' ,'LANGUAGES_MODULE_SHIPPING_USPS_ZONE_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_SORT_ORDER_TITLE' ,'MODULE_SHIPPING_USPS_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_SHIPPING_USPS_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_TYPES_TITLE' ,'MODULE_SHIPPING_USPS_TYPES' ,'EXPRESS, PRIORITY, FIRST CLASS, PARCEL, MEDIA, BPM, LIBRARY' ,'LANGUAGES_MODULE_SHIPPING_USPS_TYPES_DESCRIPTION' ,6 ,14 ,now() ,'','zen_cfg_select_multioption(array(\'EXPRESS\', \'PRIORITY\', \'FIRST CLASS\', \'PARCEL\', \'MEDIA\', \'BPM\', \'LIBRARY\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_TYPES_INTL_TITLE' ,'MODULE_SHIPPING_USPS_TYPES_INTL' ,'Global Express, Global Express Non-Doc Rect, Global Express Non-Doc Non-Rect, Global Express Envelopes, Express Mail Int, Express Mail Int Flat Rate Env, Priority Mail International, Priority Mail Int Flat Rate Env, Priority Mail Int Flat Rate Small Box, Priority Mail Int Flat Rate Med Box, Priority Mail Int Flat Rate Lrg Box, First Class Mail Int Lrg Env, First Class Mail Int Package, First Class Mail Int Letter' ,'LANGUAGES_MODULE_SHIPPING_USPS_TYPES_INTL_DESCRIPTION' ,6 ,15 ,now() ,'','zen_cfg_select_multioption(array(\'Global Express\', \'Global Express Non-Doc Rect\', \'Global Express Non-Doc Non-Rect\', \'Global Express Envelopes\', \'Express Mail Int\', \'Express Mail Int Flat Rate Env\', \'Priority Mail International\', \'Priority Mail Int Flat Rate Env\', \'Priority Mail Int Flat Rate Small Box\', \'Priority Mail Int Flat Rate Med Box\', \'Priority Mail Int Flat Rate Lrg Box\', \'First Class Mail Int Lrg Env\', \'First Class Mail Int Package\', \'First Class Mail Int Letter\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_OPTIONS_TITLE' ,'MODULE_SHIPPING_USPS_OPTIONS' ,'Display weight, Display transit time' ,'LANGUAGES_MODULE_SHIPPING_USPS_OPTIONS_DESCRIPTION' ,6 ,16 ,now() ,'','zen_cfg_select_multioption(array(\'Display weight\', \'Display transit time\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_USPS_DEBUG_MODE_TITLE' ,'MODULE_SHIPPING_USPS_DEBUG_MODE' ,'Off' ,'LANGUAGES_MODULE_SHIPPING_USPS_DEBUG_MODE_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Off\', \'Email\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IH_RESIZE_TITLE' ,'IH_RESIZE' ,'yes' ,'LANGUAGES_IH_RESIZE_DESCRIPTION' ,4 ,100 ,now() ,'','zen_cfg_select_option(array(\'yes\', \'no\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SMALL_IMAGE_FILETYPE_TITLE' ,'SMALL_IMAGE_FILETYPE' ,'no_change' ,'LANGUAGES_SMALL_IMAGE_FILETYPE_DESCRIPTION' ,4 ,101 ,now() ,'','zen_cfg_select_option(array(\'gif\', \'jpg\', \'png\', \'no_change\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SMALL_IMAGE_BACKGROUND_TITLE' ,'SMALL_IMAGE_BACKGROUND' ,'255:255:255' ,'LANGUAGES_SMALL_IMAGE_BACKGROUND_DESCRIPTION' ,4 ,102 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_WATERMARK_SMALL_IMAGES_TITLE' ,'WATERMARK_SMALL_IMAGES' ,'no' ,'LANGUAGES_WATERMARK_SMALL_IMAGES_DESCRIPTION' ,4 ,103 ,now() ,'','zen_cfg_select_option(array(\'no\', \'yes\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ZOOM_SMALL_IMAGES_TITLE' ,'ZOOM_SMALL_IMAGES' ,'yes' ,'LANGUAGES_ZOOM_SMALL_IMAGES_DESCRIPTION' ,4 ,104 ,now() ,'','zen_cfg_select_option(array(\'no\', \'yes\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SMALL_IMAGE_HOTZONE_TITLE' ,'SMALL_IMAGE_HOTZONE' ,'no' ,'LANGUAGES_SMALL_IMAGE_HOTZONE_DESCRIPTION' ,4 ,105 ,now() ,'','zen_cfg_select_option(array(\'no\', \'yes\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SMALL_IMAGE_QUALITY_TITLE' ,'SMALL_IMAGE_QUALITY' ,'85' ,'LANGUAGES_SMALL_IMAGE_QUALITY_DESCRIPTION' ,4 ,106 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MEDIUM_IMAGE_FILETYPE_TITLE' ,'MEDIUM_IMAGE_FILETYPE' ,'no_change' ,'LANGUAGES_MEDIUM_IMAGE_FILETYPE_DESCRIPTION' ,4 ,107 ,now() ,'','zen_cfg_select_option(array(\'gif\', \'jpg\', \'png\', \'no_change\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MEDIUM_IMAGE_BACKGROUND_TITLE' ,'MEDIUM_IMAGE_BACKGROUND' ,'255:255:255' ,'LANGUAGES_MEDIUM_IMAGE_BACKGROUND_DESCRIPTION' ,4 ,108 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_WATERMARK_MEDIUM_IMAGES_TITLE' ,'WATERMARK_MEDIUM_IMAGES' ,'no' ,'LANGUAGES_WATERMARK_MEDIUM_IMAGES_DESCRIPTION' ,4 ,109 ,now() ,'','zen_cfg_select_option(array(\'no\', \'yes\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ZOOM_MEDIUM_IMAGES_TITLE' ,'ZOOM_MEDIUM_IMAGES' ,'no' ,'LANGUAGES_ZOOM_MEDIUM_IMAGES_DESCRIPTION' ,4 ,110 ,now() ,'','zen_cfg_select_option(array(\'no\', \'yes\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MEDIUM_IMAGE_HOTZONE_TITLE' ,'MEDIUM_IMAGE_HOTZONE' ,'no' ,'LANGUAGES_MEDIUM_IMAGE_HOTZONE_DESCRIPTION' ,4 ,111 ,now() ,'','zen_cfg_select_option(array(\'no\', \'yes\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MEDIUM_IMAGE_QUALITY_TITLE' ,'MEDIUM_IMAGE_QUALITY' ,'85' ,'LANGUAGES_MEDIUM_IMAGE_QUALITY_DESCRIPTION' ,4 ,112 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_LARGE_IMAGE_FILETYPE_TITLE' ,'LARGE_IMAGE_FILETYPE' ,'no_change' ,'LANGUAGES_LARGE_IMAGE_FILETYPE_DESCRIPTION' ,4 ,113 ,now() ,'','zen_cfg_select_option(array(\'gif\', \'jpg\', \'png\', \'no_change\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_LARGE_IMAGE_BACKGROUND_TITLE' ,'LARGE_IMAGE_BACKGROUND' ,'255:255:255' ,'LANGUAGES_LARGE_IMAGE_BACKGROUND_DESCRIPTION' ,4 ,114 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_WATERMARK_LARGE_IMAGES_TITLE' ,'WATERMARK_LARGE_IMAGES' ,'no' ,'LANGUAGES_WATERMARK_LARGE_IMAGES_DESCRIPTION' ,4 ,115 ,now() ,'','zen_cfg_select_option(array(\'no\', \'yes\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_LARGE_IMAGE_QUALITY_TITLE' ,'LARGE_IMAGE_QUALITY' ,'85' ,'LANGUAGES_LARGE_IMAGE_QUALITY_DESCRIPTION' ,4 ,116 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_LARGE_IMAGE_MAX_WIDTH_TITLE' ,'LARGE_IMAGE_MAX_WIDTH' ,'750' ,'LANGUAGES_LARGE_IMAGE_MAX_WIDTH_DESCRIPTION' ,4 ,117 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_LARGE_IMAGE_MAX_HEIGHT_TITLE' ,'LARGE_IMAGE_MAX_HEIGHT' ,'550' ,'LANGUAGES_LARGE_IMAGE_MAX_HEIGHT_DESCRIPTION' ,4 ,118 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_WATERMARK_GRAVITY_TITLE' ,'WATERMARK_GRAVITY' ,'Center' ,'LANGUAGES_WATERMARK_GRAVITY_DESCRIPTION' ,4 ,119 ,now() ,'','zen_cfg_select_drop_down(array(array(\'id\'=>\'NorthWest\', \'text\'=>\'NorthWest\'), array(\'id\'=>\'North\', \'text\'=>\'North\'), array(\'id\'=>\'NorthEast\', \'text\'=>\'NorthEast\'), array(\'id\'=>\'West\', \'text\'=>\'West\'), array(\'id\'=>\'Center\', \'text\'=>\'Center\'), array(\'id\'=>\'East\', \'text\'=>\'East\'), array(\'id\'=>\'SouthWest\', \'text\'=>\'SouthWest\'), array(\'id\'=>\'South\', \'text\'=>\'South\'), array(\'id\'=>\'SouthEast\', \'text\'=>\'SouthEast\')),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_ZOOM_GRAVITY_TITLE' ,'ZOOM_GRAVITY' ,'SouthEast' ,'LANGUAGES_ZOOM_GRAVITY_DESCRIPTION' ,4 ,120 ,now() ,'','zen_cfg_select_drop_down(array(array(\'id\'=>\'NorthWest\', \'text\'=>\'NorthWest\'), array(\'id\'=>\'North\', \'text\'=>\'North\'), array(\'id\'=>\'NorthEast\', \'text\'=>\'NorthEast\'), array(\'id\'=>\'West\', \'text\'=>\'West\'), array(\'id\'=>\'Center\', \'text\'=>\'Center\'), array(\'id\'=>\'East\', \'text\'=>\'East\'), array(\'id\'=>\'SouthWest\', \'text\'=>\'SouthWest\'), array(\'id\'=>\'South\', \'text\'=>\'South\'), array(\'id\'=>\'SouthEast\', \'text\'=>\'SouthEast\')),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_IH_VERSION_TITLE' ,'IH_VERSION' ,'2.0' ,'LANGUAGES_IH_VERSION_DESCRIPTION' ,0 ,100 ,now() ,'','zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREESHIPPER_STATUS_TITLE' ,'MODULE_SHIPPING_FREESHIPPER_STATUS' ,'True' ,'LANGUAGES_MODULE_SHIPPING_FREESHIPPER_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREESHIPPER_COST_TITLE' ,'MODULE_SHIPPING_FREESHIPPER_COST' ,'0.00' ,'LANGUAGES_MODULE_SHIPPING_FREESHIPPER_COST_DESCRIPTION' ,6 ,6 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREESHIPPER_HANDLING_TITLE' ,'MODULE_SHIPPING_FREESHIPPER_HANDLING' ,'0' ,'LANGUAGES_MODULE_SHIPPING_FREESHIPPER_HANDLING_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREESHIPPER_TAX_CLASS_TITLE' ,'MODULE_SHIPPING_FREESHIPPER_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_SHIPPING_FREESHIPPER_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREESHIPPER_ZONE_TITLE' ,'MODULE_SHIPPING_FREESHIPPER_ZONE' ,'0' ,'LANGUAGES_MODULE_SHIPPING_FREESHIPPER_ZONE_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREESHIPPER_SORT_ORDER_TITLE' ,'MODULE_SHIPPING_FREESHIPPER_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_SHIPPING_FREESHIPPER_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_STATUS_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_STATUS' ,'True' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_COST_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_COST' ,'0.00' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_COST_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_HANDLING_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_HANDLING' ,'0' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_HANDLING_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_TOTAL_MIN_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_TOTAL_MIN' ,'0.00' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_TOTAL_MIN_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_TOTAL_MAX_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_TOTAL_MAX' ,'' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_TOTAL_MAX_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_WEIGHT_MIN_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_WEIGHT_MIN' ,'' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_WEIGHT_MIN_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_WEIGHT_MAX_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_WEIGHT_MAX' ,'' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_WEIGHT_MAX_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_ITEMS_MIN_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_ITEMS_MIN' ,'' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_ITEMS_MIN_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_ITEMS_MAX_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_ITEMS_MAX' ,'' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_ITEMS_MAX_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_TAX_CLASS_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_TAX_BASIS_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_TAX_BASIS' ,'Shipping' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_TAX_BASIS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Shipping\', \'Billing\', \'Store\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_ZONE_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_ZONE' ,'0' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_ZONE_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_SORT_ORDER_TITLE' ,'MODULE_SHIPPING_FREEOPTIONS_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_SHIPPING_FREEOPTIONS_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_STATUS_TITLE' ,'MODULE_SHIPPING_ZONES_STATUS' ,'True' ,'LANGUAGES_MODULE_SHIPPING_ZONES_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_METHOD_TITLE' ,'MODULE_SHIPPING_ZONES_METHOD' ,'Weight' ,'LANGUAGES_MODULE_SHIPPING_ZONES_METHOD_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Weight\', \'Price\', \'Item\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_TAX_CLASS_TITLE' ,'MODULE_SHIPPING_ZONES_TAX_CLASS' ,'0' ,'LANGUAGES_MODULE_SHIPPING_ZONES_TAX_CLASS_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_tax_class_title','zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_TAX_BASIS_TITLE' ,'MODULE_SHIPPING_ZONES_TAX_BASIS' ,'Shipping' ,'LANGUAGES_MODULE_SHIPPING_ZONES_TAX_BASIS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Shipping\', \'Billing\', \'Store\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_SORT_ORDER_TITLE' ,'MODULE_SHIPPING_ZONES_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_SHIPPING_ZONES_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_SKIPPED_TITLE' ,'MODULE_SHIPPING_ZONES_SKIPPED' ,'' ,'LANGUAGES_MODULE_SHIPPING_ZONES_SKIPPED_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_textarea(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_COUNTRIES_1_TITLE' ,'MODULE_SHIPPING_ZONES_COUNTRIES_1' ,'US,CA' ,'LANGUAGES_MODULE_SHIPPING_ZONES_COUNTRIES_1_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_textarea(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_COST_1_TITLE' ,'MODULE_SHIPPING_ZONES_COST_1' ,'3:8.50,7:10.50,99:20.00' ,'LANGUAGES_MODULE_SHIPPING_ZONES_COST_1_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_textarea(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_1_TITLE' ,'MODULE_SHIPPING_ZONES_HANDLING_1' ,'0' ,'LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_1_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_METHOD_1_TITLE' ,'MODULE_SHIPPING_ZONES_HANDLING_METHOD_1' ,'Order' ,'LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_METHOD_1_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Order\', \'Box\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_COUNTRIES_2_TITLE' ,'MODULE_SHIPPING_ZONES_COUNTRIES_2' ,'' ,'LANGUAGES_MODULE_SHIPPING_ZONES_COUNTRIES_2_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_textarea(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_COST_2_TITLE' ,'MODULE_SHIPPING_ZONES_COST_2' ,'3:8.50,7:10.50,99:20.00' ,'LANGUAGES_MODULE_SHIPPING_ZONES_COST_2_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_textarea(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_2_TITLE' ,'MODULE_SHIPPING_ZONES_HANDLING_2' ,'0' ,'LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_2_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_METHOD_2_TITLE' ,'MODULE_SHIPPING_ZONES_HANDLING_METHOD_2' ,'Order' ,'LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_METHOD_2_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Order\', \'Box\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_COUNTRIES_3_TITLE' ,'MODULE_SHIPPING_ZONES_COUNTRIES_3' ,'' ,'LANGUAGES_MODULE_SHIPPING_ZONES_COUNTRIES_3_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_textarea(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_COST_3_TITLE' ,'MODULE_SHIPPING_ZONES_COST_3' ,'3:8.50,7:10.50,99:20.00' ,'LANGUAGES_MODULE_SHIPPING_ZONES_COST_3_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_textarea(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_3_TITLE' ,'MODULE_SHIPPING_ZONES_HANDLING_3' ,'0' ,'LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_3_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_METHOD_3_TITLE' ,'MODULE_SHIPPING_ZONES_HANDLING_METHOD_3' ,'Order' ,'LANGUAGES_MODULE_SHIPPING_ZONES_HANDLING_METHOD_3_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'Order\', \'Box\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_COD_STATUS_TITLE' ,'MODULE_PAYMENT_COD_STATUS' ,'True' ,'LANGUAGES_MODULE_PAYMENT_COD_STATUS_DESCRIPTION' ,6 ,1 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_COD_ZONE_TITLE' ,'MODULE_PAYMENT_COD_ZONE' ,'0' ,'LANGUAGES_MODULE_PAYMENT_COD_ZONE_DESCRIPTION' ,6 ,2 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_COD_SORT_ORDER_TITLE' ,'MODULE_PAYMENT_COD_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_PAYMENT_COD_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_COD_ORDER_STATUS_ID_TITLE' ,'MODULE_PAYMENT_COD_ORDER_STATUS_ID' ,'0' ,'LANGUAGES_MODULE_PAYMENT_COD_ORDER_STATUS_ID_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_order_status_name','zen_cfg_pull_down_order_statuses(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_FREECHARGER_STATUS_TITLE' ,'MODULE_PAYMENT_FREECHARGER_STATUS' ,'True' ,'LANGUAGES_MODULE_PAYMENT_FREECHARGER_STATUS_DESCRIPTION' ,6 ,1 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_FREECHARGER_SORT_ORDER_TITLE' ,'MODULE_PAYMENT_FREECHARGER_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_PAYMENT_FREECHARGER_SORT_ORDER_DESCRIPTION' ,6 ,0 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_FREECHARGER_ZONE_TITLE' ,'MODULE_PAYMENT_FREECHARGER_ZONE' ,'0' ,'LANGUAGES_MODULE_PAYMENT_FREECHARGER_ZONE_DESCRIPTION' ,6 ,2 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_FREECHARGER_ORDER_STATUS_ID_TITLE' ,'MODULE_PAYMENT_FREECHARGER_ORDER_STATUS_ID' ,'0' ,'LANGUAGES_MODULE_PAYMENT_FREECHARGER_ORDER_STATUS_ID_DESCRIPTION' ,6 ,0 ,now() ,'zen_get_order_status_name','zen_cfg_pull_down_order_statuses(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_STATUS_TITLE' ,'MODULE_PAYMENT_PAYPAL_STATUS' ,'True' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_BUSINESS_ID_TITLE' ,'MODULE_PAYMENT_PAYPAL_BUSINESS_ID' ,'iweb@joytl.net' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_BUSINESS_ID_DESCRIPTION' ,6 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_CURRENCY_TITLE' ,'MODULE_PAYMENT_PAYPAL_CURRENCY' ,'Selected Currency' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_CURRENCY_DESCRIPTION' ,6 ,3 ,now() ,'','zen_cfg_select_option(array(\'Selected Currency\', \'Only USD\', \'Only AUD\', \'Only CAD\', \'Only EUR\', \'Only GBP\', \'Only CHF\', \'Only CZK\', \'Only DKK\', \'Only HKD\', \'Only HUF\', \'Only JPY\', \'Only NOK\', \'Only NZD\', \'Only PLN\', \'Only SEK\', \'Only SGD\', \'Only THB\', \'Only MXN\', \'Only ILS\', \'Only PHP\', \'Only TWD\', \'Only BRL\', \'Only MYR\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_ZONE_TITLE' ,'MODULE_PAYMENT_PAYPAL_ZONE' ,'0' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_ZONE_DESCRIPTION' ,6 ,4 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_PROCESSING_STATUS_ID_TITLE' ,'MODULE_PAYMENT_PAYPAL_PROCESSING_STATUS_ID' ,'1' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_PROCESSING_STATUS_ID_DESCRIPTION' ,6 ,5 ,now() ,'zen_get_order_status_name','zen_cfg_pull_down_order_statuses(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_ORDER_STATUS_ID_TITLE' ,'MODULE_PAYMENT_PAYPAL_ORDER_STATUS_ID' ,'2' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_ORDER_STATUS_ID_DESCRIPTION' ,6 ,6 ,now() ,'zen_get_order_status_name','zen_cfg_pull_down_order_statuses(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_REFUND_ORDER_STATUS_ID_TITLE' ,'MODULE_PAYMENT_PAYPAL_REFUND_ORDER_STATUS_ID' ,'1' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_REFUND_ORDER_STATUS_ID_DESCRIPTION' ,6 ,7 ,now() ,'zen_get_order_status_name','zen_cfg_pull_down_order_statuses(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_SORT_ORDER_TITLE' ,'MODULE_PAYMENT_PAYPAL_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_SORT_ORDER_DESCRIPTION' ,6 ,8 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_ADDRESS_OVERRIDE_TITLE' ,'MODULE_PAYMENT_PAYPAL_ADDRESS_OVERRIDE' ,'1' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_ADDRESS_OVERRIDE_DESCRIPTION' ,6 ,18 ,now() ,'','zen_cfg_select_option(array(\'0\',\'1\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_ADDRESS_REQUIRED_TITLE' ,'MODULE_PAYMENT_PAYPAL_ADDRESS_REQUIRED' ,'2' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_ADDRESS_REQUIRED_DESCRIPTION' ,6 ,20 ,now() ,'','zen_cfg_select_option(array(\'0\',\'1\',\'2\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_DETAILED_CART_TITLE' ,'MODULE_PAYMENT_PAYPAL_DETAILED_CART' ,'No' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_DETAILED_CART_DESCRIPTION' ,6 ,22 ,now() ,'','zen_cfg_select_option(array(\'No\',\'Yes\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_PAGE_STYLE_TITLE' ,'MODULE_PAYMENT_PAYPAL_PAGE_STYLE' ,'Primary' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_PAGE_STYLE_DESCRIPTION' ,6 ,25 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_HANDLER_TITLE' ,'MODULE_PAYMENT_PAYPAL_HANDLER' ,'www.paypal.com/cgi-bin/webscr' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_HANDLER_DESCRIPTION' ,6 ,73 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_PDTTOKEN_TITLE' ,'MODULE_PAYMENT_PAYPAL_PDTTOKEN' ,'' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_PDTTOKEN_DESCRIPTION' ,6 ,25 ,now() ,'zen_cfg_password_display','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_IPN_DEBUG_TITLE' ,'MODULE_PAYMENT_PAYPAL_IPN_DEBUG' ,'Off' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_IPN_DEBUG_DESCRIPTION' ,6 ,71 ,now() ,'','zen_cfg_select_option(array(\'Off\',\'Log File\',\'Log and Email\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_PAYPAL_DEBUG_EMAIL_ADDRESS_TITLE' ,'MODULE_PAYMENT_PAYPAL_DEBUG_EMAIL_ADDRESS' ,'iweb@joytl.net' ,'LANGUAGES_MODULE_PAYMENT_PAYPAL_DEBUG_EMAIL_ADDRESS_DESCRIPTION' ,6 ,72 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_MONEYORDER_STATUS_TITLE' ,'MODULE_PAYMENT_MONEYORDER_STATUS' ,'True' ,'LANGUAGES_MODULE_PAYMENT_MONEYORDER_STATUS_DESCRIPTION' ,6 ,0 ,now() ,'','zen_cfg_select_option(array(\'True\', \'False\'), ');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_MONEYORDER_PAYTO_TITLE' ,'MODULE_PAYMENT_MONEYORDER_PAYTO' ,'Joy Cart 基础版' ,'LANGUAGES_MODULE_PAYMENT_MONEYORDER_PAYTO_DESCRIPTION' ,6 ,1 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_MONEYORDER_BANK_TITLE' ,'MODULE_PAYMENT_MONEYORDER_BANK' ,'中国银行北京市分行' ,'LANGUAGES_MODULE_PAYMENT_MONEYORDER_BANK_DESCRIPTION' ,6 ,2 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_MONEYORDER_ACCOUNT_TITLE' ,'MODULE_PAYMENT_MONEYORDER_ACCOUNT' ,'xxxx-xxxx-xxxx-xxxxxxx' ,'LANGUAGES_MODULE_PAYMENT_MONEYORDER_ACCOUNT_DESCRIPTION' ,6 ,3 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_MONEYORDER_SORT_ORDER_TITLE' ,'MODULE_PAYMENT_MONEYORDER_SORT_ORDER' ,'0' ,'LANGUAGES_MODULE_PAYMENT_MONEYORDER_SORT_ORDER_DESCRIPTION' ,6 ,4 ,now() ,'','');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_MONEYORDER_ZONE_TITLE' ,'MODULE_PAYMENT_MONEYORDER_ZONE' ,'0' ,'LANGUAGES_MODULE_PAYMENT_MONEYORDER_ZONE_DESCRIPTION' ,6 ,5 ,now() ,'zen_get_zone_class_title','zen_cfg_pull_down_zone_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_MODULE_PAYMENT_MONEYORDER_ORDER_STATUS_ID_TITLE' ,'MODULE_PAYMENT_MONEYORDER_ORDER_STATUS_ID' ,'0' ,'LANGUAGES_MODULE_PAYMENT_MONEYORDER_ORDER_STATUS_ID_DESCRIPTION' ,6 ,6 ,now() ,'zen_get_order_status_name','zen_cfg_pull_down_order_statuses(');



INSERT INTO configuration_group (configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible) VALUES
(1, 'LANGUAGES_GROUP_1_TITLE', 'LANGUAGES_GROUP_1_DESCRIPTION', 1, 2),
(2, 'LANGUAGES_GROUP_2_TITLE', 'LANGUAGES_GROUP_2_DESCRIPTION', 2, 1),
(3, 'LANGUAGES_GROUP_3_TITLE', 'LANGUAGES_GROUP_3_DESCRIPTION', 3, 1),
(4, 'LANGUAGES_GROUP_4_TITLE', 'LANGUAGES_GROUP_4_DESCRIPTION', 4, 1),
(5, 'LANGUAGES_GROUP_5_TITLE', 'LANGUAGES_GROUP_5_DESCRIPTION', 5, 2),
(6, 'LANGUAGES_GROUP_6_TITLE', 'LANGUAGES_GROUP_6_DESCRIPTION', 6, 0),
(7, 'LANGUAGES_GROUP_7_TITLE', 'LANGUAGES_GROUP_7_DESCRIPTION', 7, 2),
(8, 'LANGUAGES_GROUP_8_TITLE', 'LANGUAGES_GROUP_8_DESCRIPTION', 8, 1),
(9, 'LANGUAGES_GROUP_9_TITLE', 'LANGUAGES_GROUP_9_DESCRIPTION', 9, 2),
(10, 'LANGUAGES_GROUP_10_TITLE', 'LANGUAGES_GROUP_10_DESCRIPTION', 10, 0),
(11, 'LANGUAGES_GROUP_11_TITLE', 'LANGUAGES_GROUP_11_DESCRIPTION', 16, 2),
(12, 'LANGUAGES_GROUP_12_TITLE', 'LANGUAGES_GROUP_12_DESCRIPTION', 12, 2),
(13, 'LANGUAGES_GROUP_13_TITLE', 'LANGUAGES_GROUP_13_DESCRIPTION', 13, 2),
(14, 'LANGUAGES_GROUP_14_TITLE', 'LANGUAGES_GROUP_14_DESCRIPTION', 14, 0),
(15, 'LANGUAGES_GROUP_15_TITLE', 'LANGUAGES_GROUP_15_DESCRIPTION', 15, 0),
(16, 'LANGUAGES_GROUP_16_TITLE', 'LANGUAGES_GROUP_16_DESCRIPTION', 16, 2),
(17, 'LANGUAGES_GROUP_17_TITLE', 'LANGUAGES_GROUP_17_DESCRIPTION', 17, 2),
(18, 'LANGUAGES_GROUP_18_TITLE', 'LANGUAGES_GROUP_18_DESCRIPTION', 18, 1),
(19, 'LANGUAGES_GROUP_19_TITLE', 'LANGUAGES_GROUP_19_DESCRIPTION', 19, 1),
(20, 'LANGUAGES_GROUP_20_TITLE', 'LANGUAGES_GROUP_20_DESCRIPTION', 20, 2),
(21, 'LANGUAGES_GROUP_21_TITLE', 'LANGUAGES_GROUP_21_DESCRIPTION', 21, 1),
(22, 'LANGUAGES_GROUP_22_TITLE', 'LANGUAGES_GROUP_22_DESCRIPTION', 22, 1),
(23, 'LANGUAGES_GROUP_23_TITLE', 'LANGUAGES_GROUP_23_DESCRIPTION', 23, 1),
(24, 'LANGUAGES_GROUP_24_TITLE', 'LANGUAGES_GROUP_24_DESCRIPTION', 24, 1),
(25, 'LANGUAGES_GROUP_25_TITLE', 'LANGUAGES_GROUP_25_DESCRIPTION', 25, 1),
(30, 'LANGUAGES_GROUP_30_TITLE', 'LANGUAGES_GROUP_30_DESCRIPTION', 30, 1),
(31, 'LANGUAGES_GROUP_31_TITLE', 'LANGUAGES_GROUP_31_DESCRIPTION', 31, 1),
(32, 'LANGUAGES_QUICK_UPDATE_TITLE', 'LANGUAGES_QUICK_UPDATE_DESCRIPTION', 32, 1),
(33, 'LANGUAGES_TESTIMONIALS_MANAGER_GROUP_TITLE', 'LANGUAGES_TESTIMONIALS_MANAGER_GROUP_DESCRIPTION', 33, 1);

 
INSERT INTO countries VALUES (240,'Aaland Islands','AX','ALA','1');
INSERT INTO countries VALUES (1,'Afghanistan','AF','AFG','1');
INSERT INTO countries VALUES (2,'Albania','AL','ALB','1');
INSERT INTO countries VALUES (3,'Algeria','DZ','DZA','1');
INSERT INTO countries VALUES (4,'American Samoa','AS','ASM','1');
INSERT INTO countries VALUES (5,'Andorra','AD','AND','1');
INSERT INTO countries VALUES (6,'Angola','AO','AGO','1');
INSERT INTO countries VALUES (7,'Anguilla','AI','AIA','1');
INSERT INTO countries VALUES (8,'Antarctica','AQ','ATA','1');
INSERT INTO countries VALUES (9,'Antigua and Barbuda','AG','ATG','1');
INSERT INTO countries VALUES (10,'Argentina','AR','ARG','1');
INSERT INTO countries VALUES (11,'Armenia','AM','ARM','1');
INSERT INTO countries VALUES (12,'Aruba','AW','ABW','1');
INSERT INTO countries VALUES (13,'Australia','AU','AUS','1');
INSERT INTO countries VALUES (14,'Austria','AT','AUT','5');
INSERT INTO countries VALUES (15,'Azerbaijan','AZ','AZE','1');
INSERT INTO countries VALUES (16,'Bahamas','BS','BHS','1');
INSERT INTO countries VALUES (17,'Bahrain','BH','BHR','1');
INSERT INTO countries VALUES (18,'Bangladesh','BD','BGD','1');
INSERT INTO countries VALUES (19,'Barbados','BB','BRB','1');
INSERT INTO countries VALUES (20,'Belarus','BY','BLR','1');
INSERT INTO countries VALUES (21,'Belgium','BE','BEL','1');
INSERT INTO countries VALUES (22,'Belize','BZ','BLZ','1');
INSERT INTO countries VALUES (23,'Benin','BJ','BEN','1');
INSERT INTO countries VALUES (24,'Bermuda','BM','BMU','1');
INSERT INTO countries VALUES (25,'Bhutan','BT','BTN','1');
INSERT INTO countries VALUES (26,'Bolivia','BO','BOL','1');
INSERT INTO countries VALUES (27,'Bosnia and Herzegowina','BA','BIH','1');
INSERT INTO countries VALUES (28,'Botswana','BW','BWA','1');
INSERT INTO countries VALUES (29,'Bouvet Island','BV','BVT','1');
INSERT INTO countries VALUES (30,'Brazil','BR','BRA','1');
INSERT INTO countries VALUES (31,'British Indian Ocean Territory','IO','IOT','1');
INSERT INTO countries VALUES (32,'Brunei Darussalam','BN','BRN','1');
INSERT INTO countries VALUES (33,'Bulgaria','BG','BGR','1');
INSERT INTO countries VALUES (34,'Burkina Faso','BF','BFA','1');
INSERT INTO countries VALUES (35,'Burundi','BI','BDI','1');
INSERT INTO countries VALUES (36,'Cambodia','KH','KHM','1');
INSERT INTO countries VALUES (37,'Cameroon','CM','CMR','1');
INSERT INTO countries VALUES (38,'Canada','CA','CAN','2');
INSERT INTO countries VALUES (39,'Cape Verde','CV','CPV','1');
INSERT INTO countries VALUES (40,'Cayman Islands','KY','CYM','1');
INSERT INTO countries VALUES (41,'Central African Republic','CF','CAF','1');
INSERT INTO countries VALUES (42,'Chad','TD','TCD','1');
INSERT INTO countries VALUES (43,'Chile','CL','CHL','1');
INSERT INTO countries VALUES (44,'中国','CN','CHN','1');
INSERT INTO countries VALUES (45,'Christmas Island','CX','CXR','1');
INSERT INTO countries VALUES (46,'Cocos (Keeling) Islands','CC','CCK','1');
INSERT INTO countries VALUES (47,'Colombia','CO','COL','1');
INSERT INTO countries VALUES (48,'Comoros','KM','COM','1');
INSERT INTO countries VALUES (49,'Congo','CG','COG','1');
INSERT INTO countries VALUES (50,'Cook Islands','CK','COK','1');
INSERT INTO countries VALUES (51,'Costa Rica','CR','CRI','1');
INSERT INTO countries VALUES (52,'Cote D\'Ivoire','CI','CIV','1');
INSERT INTO countries VALUES (53,'Croatia','HR','HRV','1');
INSERT INTO countries VALUES (54,'Cuba','CU','CUB','1');
INSERT INTO countries VALUES (55,'Cyprus','CY','CYP','1');
INSERT INTO countries VALUES (56,'Czech Republic','CZ','CZE','1');
INSERT INTO countries VALUES (57,'Denmark','DK','DNK','1');
INSERT INTO countries VALUES (58,'Djibouti','DJ','DJI','1');
INSERT INTO countries VALUES (59,'Dominica','DM','DMA','1');
INSERT INTO countries VALUES (60,'Dominican Republic','DO','DOM','1');
INSERT INTO countries VALUES (61,'Timor-Leste','TL','TLS','1');
INSERT INTO countries VALUES (62,'Ecuador','EC','ECU','1');
INSERT INTO countries VALUES (63,'Egypt','EG','EGY','1');
INSERT INTO countries VALUES (64,'El Salvador','SV','SLV','1');
INSERT INTO countries VALUES (65,'Equatorial Guinea','GQ','GNQ','1');
INSERT INTO countries VALUES (66,'Eritrea','ER','ERI','1');
INSERT INTO countries VALUES (67,'Estonia','EE','EST','1');
INSERT INTO countries VALUES (68,'Ethiopia','ET','ETH','1');
INSERT INTO countries VALUES (69,'Falkland Islands (Malvinas)','FK','FLK','1');
INSERT INTO countries VALUES (70,'Faroe Islands','FO','FRO','1');
INSERT INTO countries VALUES (71,'Fiji','FJ','FJI','1');
INSERT INTO countries VALUES (72,'Finland','FI','FIN','1');
INSERT INTO countries VALUES (73,'France','FR','FRA','1');
INSERT INTO countries VALUES (75,'French Guiana','GF','GUF','1');
INSERT INTO countries VALUES (76,'French Polynesia','PF','PYF','1');
INSERT INTO countries VALUES (77,'French Southern Territories','TF','ATF','1');
INSERT INTO countries VALUES (78,'Gabon','GA','GAB','1');
INSERT INTO countries VALUES (79,'Gambia','GM','GMB','1');
INSERT INTO countries VALUES (80,'Georgia','GE','GEO','1');
INSERT INTO countries VALUES (81,'Germany','DE','DEU','5');
INSERT INTO countries VALUES (82,'Ghana','GH','GHA','1');
INSERT INTO countries VALUES (83,'Gibraltar','GI','GIB','1');
INSERT INTO countries VALUES (84,'Greece','GR','GRC','1');
INSERT INTO countries VALUES (85,'Greenland','GL','GRL','1');
INSERT INTO countries VALUES (86,'Grenada','GD','GRD','1');
INSERT INTO countries VALUES (87,'Guadeloupe','GP','GLP','1');
INSERT INTO countries VALUES (88,'Guam','GU','GUM','1');
INSERT INTO countries VALUES (89,'Guatemala','GT','GTM','1');
INSERT INTO countries VALUES (90,'Guinea','GN','GIN','1');
INSERT INTO countries VALUES (91,'Guinea-bissau','GW','GNB','1');
INSERT INTO countries VALUES (92,'Guyana','GY','GUY','1');
INSERT INTO countries VALUES (93,'Haiti','HT','HTI','1');
INSERT INTO countries VALUES (94,'Heard and Mc Donald Islands','HM','HMD','1');
INSERT INTO countries VALUES (95,'Honduras','HN','HND','1');
INSERT INTO countries VALUES (96,'Hong Kong','HK','HKG','1');
INSERT INTO countries VALUES (97,'Hungary','HU','HUN','1');
INSERT INTO countries VALUES (98,'Iceland','IS','ISL','1');
INSERT INTO countries VALUES (99,'India','IN','IND','1');
INSERT INTO countries VALUES (100,'Indonesia','ID','IDN','1');
INSERT INTO countries VALUES (101,'Iran (Islamic Republic of)','IR','IRN','1');
INSERT INTO countries VALUES (102,'Iraq','IQ','IRQ','1');
INSERT INTO countries VALUES (103,'Ireland','IE','IRL','1');
INSERT INTO countries VALUES (104,'Israel','IL','ISR','1');
INSERT INTO countries VALUES (105,'Italy','IT','ITA','1');
INSERT INTO countries VALUES (106,'Jamaica','JM','JAM','1');
INSERT INTO countries VALUES (107,'Japan','JP','JPN','1');
INSERT INTO countries VALUES (108,'Jordan','JO','JOR','1');
INSERT INTO countries VALUES (109,'Kazakhstan','KZ','KAZ','1');
INSERT INTO countries VALUES (110,'Kenya','KE','KEN','1');
INSERT INTO countries VALUES (111,'Kiribati','KI','KIR','1');
INSERT INTO countries VALUES (112,'Korea, Democratic People\'s Republic of','KP','PRK','1');
INSERT INTO countries VALUES (113,'Korea, Republic of','KR','KOR','1');
INSERT INTO countries VALUES (114,'Kuwait','KW','KWT','1');
INSERT INTO countries VALUES (115,'Kyrgyzstan','KG','KGZ','1');
INSERT INTO countries VALUES (116,'Lao People\'s Democratic Republic','LA','LAO','1');
INSERT INTO countries VALUES (117,'Latvia','LV','LVA','1');
INSERT INTO countries VALUES (118,'Lebanon','LB','LBN','1');
INSERT INTO countries VALUES (119,'Lesotho','LS','LSO','1');
INSERT INTO countries VALUES (120,'Liberia','LR','LBR','1');
INSERT INTO countries VALUES (121,'Libyan Arab Jamahiriya','LY','LBY','1');
INSERT INTO countries VALUES (122,'Liechtenstein','LI','LIE','1');
INSERT INTO countries VALUES (123,'Lithuania','LT','LTU','1');
INSERT INTO countries VALUES (124,'Luxembourg','LU','LUX','1');
INSERT INTO countries VALUES (125,'Macao','MO','MAC','1');
INSERT INTO countries VALUES (126,'Macedonia, The Former Yugoslav Republic of','MK','MKD','1');
INSERT INTO countries VALUES (127,'Madagascar','MG','MDG','1');
INSERT INTO countries VALUES (128,'Malawi','MW','MWI','1');
INSERT INTO countries VALUES (129,'Malaysia','MY','MYS','1');
INSERT INTO countries VALUES (130,'Maldives','MV','MDV','1');
INSERT INTO countries VALUES (131,'Mali','ML','MLI','1');
INSERT INTO countries VALUES (132,'Malta','MT','MLT','1');
INSERT INTO countries VALUES (133,'Marshall Islands','MH','MHL','1');
INSERT INTO countries VALUES (134,'Martinique','MQ','MTQ','1');
INSERT INTO countries VALUES (135,'Mauritania','MR','MRT','1');
INSERT INTO countries VALUES (136,'Mauritius','MU','MUS','1');
INSERT INTO countries VALUES (137,'Mayotte','YT','MYT','1');
INSERT INTO countries VALUES (138,'Mexico','MX','MEX','1');
INSERT INTO countries VALUES (139,'Micronesia, Federated States of','FM','FSM','1');
INSERT INTO countries VALUES (140,'Moldova','MD','MDA','1');
INSERT INTO countries VALUES (141,'Monaco','MC','MCO','1');
INSERT INTO countries VALUES (142,'Mongolia','MN','MNG','1');
INSERT INTO countries VALUES (143,'Montserrat','MS','MSR','1');
INSERT INTO countries VALUES (144,'Morocco','MA','MAR','1');
INSERT INTO countries VALUES (145,'Mozambique','MZ','MOZ','1');
INSERT INTO countries VALUES (146,'Myanmar','MM','MMR','1');
INSERT INTO countries VALUES (147,'Namibia','NA','NAM','1');
INSERT INTO countries VALUES (148,'Nauru','NR','NRU','1');
INSERT INTO countries VALUES (149,'Nepal','NP','NPL','1');
INSERT INTO countries VALUES (150,'Netherlands','NL','NLD','1');
INSERT INTO countries VALUES (151,'Netherlands Antilles','AN','ANT','1');
INSERT INTO countries VALUES (152,'New Caledonia','NC','NCL','1');
INSERT INTO countries VALUES (153,'New Zealand','NZ','NZL','1');
INSERT INTO countries VALUES (154,'Nicaragua','NI','NIC','1');
INSERT INTO countries VALUES (155,'Niger','NE','NER','1');
INSERT INTO countries VALUES (156,'Nigeria','NG','NGA','1');
INSERT INTO countries VALUES (157,'Niue','NU','NIU','1');
INSERT INTO countries VALUES (158,'Norfolk Island','NF','NFK','1');
INSERT INTO countries VALUES (159,'Northern Mariana Islands','MP','MNP','1');
INSERT INTO countries VALUES (160,'Norway','NO','NOR','1');
INSERT INTO countries VALUES (161,'Oman','OM','OMN','1');
INSERT INTO countries VALUES (162,'Pakistan','PK','PAK','1');
INSERT INTO countries VALUES (163,'Palau','PW','PLW','1');
INSERT INTO countries VALUES (164,'Panama','PA','PAN','1');
INSERT INTO countries VALUES (165,'Papua New Guinea','PG','PNG','1');
INSERT INTO countries VALUES (166,'Paraguay','PY','PRY','1');
INSERT INTO countries VALUES (167,'Peru','PE','PER','1');
INSERT INTO countries VALUES (168,'Philippines','PH','PHL','1');
INSERT INTO countries VALUES (169,'Pitcairn','PN','PCN','1');
INSERT INTO countries VALUES (170,'Poland','PL','POL','1');
INSERT INTO countries VALUES (171,'Portugal','PT','PRT','1');
INSERT INTO countries VALUES (172,'Puerto Rico','PR','PRI','1');
INSERT INTO countries VALUES (173,'Qatar','QA','QAT','1');
INSERT INTO countries VALUES (174,'Reunion','RE','REU','1');
INSERT INTO countries VALUES (175,'Romania','RO','ROU','1');
INSERT INTO countries VALUES (176,'Russian Federation','RU','RUS','1');
INSERT INTO countries VALUES (177,'Rwanda','RW','RWA','1');
INSERT INTO countries VALUES (178,'Saint Kitts and Nevis','KN','KNA','1');
INSERT INTO countries VALUES (179,'Saint Lucia','LC','LCA','1');
INSERT INTO countries VALUES (180,'Saint Vincent and the Grenadines','VC','VCT','1');
INSERT INTO countries VALUES (181,'Samoa','WS','WSM','1');
INSERT INTO countries VALUES (182,'San Marino','SM','SMR','1');
INSERT INTO countries VALUES (183,'Sao Tome and Principe','ST','STP','1');
INSERT INTO countries VALUES (184,'Saudi Arabia','SA','SAU','1');
INSERT INTO countries VALUES (185,'Senegal','SN','SEN','1');
INSERT INTO countries VALUES (186,'Seychelles','SC','SYC','1');
INSERT INTO countries VALUES (187,'Sierra Leone','SL','SLE','1');
INSERT INTO countries VALUES (188,'Singapore','SG','SGP', '4');
INSERT INTO countries VALUES (189,'Slovakia (Slovak Republic)','SK','SVK','1');
INSERT INTO countries VALUES (190,'Slovenia','SI','SVN','1');
INSERT INTO countries VALUES (191,'Solomon Islands','SB','SLB','1');
INSERT INTO countries VALUES (192,'Somalia','SO','SOM','1');
INSERT INTO countries VALUES (193,'South Africa','ZA','ZAF','1');
INSERT INTO countries VALUES (194,'South Georgia and the South Sandwich Islands','GS','SGS','1');
INSERT INTO countries VALUES (195,'Spain','ES','ESP','3');
INSERT INTO countries VALUES (196,'Sri Lanka','LK','LKA','1');
INSERT INTO countries VALUES (197,'St. Helena','SH','SHN','1');
INSERT INTO countries VALUES (198,'St. Pierre and Miquelon','PM','SPM','1');
INSERT INTO countries VALUES (199,'Sudan','SD','SDN','1');
INSERT INTO countries VALUES (200,'Suriname','SR','SUR','1');
INSERT INTO countries VALUES (201,'Svalbard and Jan Mayen Islands','SJ','SJM','1');
INSERT INTO countries VALUES (202,'Swaziland','SZ','SWZ','1');
INSERT INTO countries VALUES (203,'Sweden','SE','SWE','1');
INSERT INTO countries VALUES (204,'Switzerland','CH','CHE','1');
INSERT INTO countries VALUES (205,'Syrian Arab Republic','SY','SYR','1');
INSERT INTO countries VALUES (206,'Taiwan','TW','TWN','1');
INSERT INTO countries VALUES (207,'Tajikistan','TJ','TJK','1');
INSERT INTO countries VALUES (208,'Tanzania, United Republic of','TZ','TZA','1');
INSERT INTO countries VALUES (209,'Thailand','TH','THA','1');
INSERT INTO countries VALUES (210,'Togo','TG','TGO','1');
INSERT INTO countries VALUES (211,'Tokelau','TK','TKL','1');
INSERT INTO countries VALUES (212,'Tonga','TO','TON','1');
INSERT INTO countries VALUES (213,'Trinidad and Tobago','TT','TTO','1');
INSERT INTO countries VALUES (214,'Tunisia','TN','TUN','1');
INSERT INTO countries VALUES (215,'Turkey','TR','TUR','1');
INSERT INTO countries VALUES (216,'Turkmenistan','TM','TKM','1');
INSERT INTO countries VALUES (217,'Turks and Caicos Islands','TC','TCA','1');
INSERT INTO countries VALUES (218,'Tuvalu','TV','TUV','1');
INSERT INTO countries VALUES (219,'Uganda','UG','UGA','1');
INSERT INTO countries VALUES (220,'Ukraine','UA','UKR','1');
INSERT INTO countries VALUES (221,'United Arab Emirates','AE','ARE','1');
INSERT INTO countries VALUES (222,'United Kingdom','GB','GBR','6');
INSERT INTO countries VALUES (223,'United States','US','USA', '2');
INSERT INTO countries VALUES (224,'United States Minor Outlying Islands','UM','UMI','1');
INSERT INTO countries VALUES (225,'Uruguay','UY','URY','1');
INSERT INTO countries VALUES (226,'Uzbekistan','UZ','UZB','1');
INSERT INTO countries VALUES (227,'Vanuatu','VU','VUT','1');
INSERT INTO countries VALUES (228,'Vatican City State (Holy See)','VA','VAT','1');
INSERT INTO countries VALUES (229,'Venezuela','VE','VEN','1');
INSERT INTO countries VALUES (230,'Viet Nam','VN','VNM','1');
INSERT INTO countries VALUES (231,'Virgin Islands (British)','VG','VGB','1');
INSERT INTO countries VALUES (232,'Virgin Islands (U.S.)','VI','VIR','1');
INSERT INTO countries VALUES (233,'Wallis and Futuna Islands','WF','WLF','1');
INSERT INTO countries VALUES (234,'Western Sahara','EH','ESH','1');
INSERT INTO countries VALUES (235,'Yemen','YE','YEM','1');
INSERT INTO countries VALUES (236,'Serbia','RS','SRB','1');
INSERT INTO countries VALUES (238,'Zambia','ZM','ZMB','1');
INSERT INTO countries VALUES (239,'Zimbabwe','ZW','ZWE','1');

INSERT INTO currencies VALUES (1,'US Dollar','USD','$','','.',',','2','0.14205870', now());
INSERT INTO currencies VALUES (2,'人民币','CNY','','元','.','','2','1.00000000', now());
INSERT INTO currencies VALUES (3,'Euro','EUR','&euro;','','.',',','2','0.09692550', now());
INSERT INTO currencies VALUES (4,'GB Pound','GBP','&pound;','','.',',','2','0.06997200', now());
INSERT INTO currencies VALUES (5,'Canadian Dollar','CAD','$','','.',',','2','0.14287770', now());
INSERT INTO currencies VALUES (6,'Australian Dollar','AUD','$','','.',',','2','0.16222499', now());

INSERT INTO languages VALUES (1,'English','en','icon.gif','english',20);
INSERT INTO languages VALUES (2,'简体中文','zh','icon.gif','schinese',10);

 INSERT INTO layout_boxes (layout_id, layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES
(1, 'default_template_settings', 'banner_box_all.php', 1, 1, 5, 0, 0),
(2, 'default_template_settings', 'banner_box.php', 1, 0, 300, 1, 127),
(3, 'default_template_settings', 'banner_box2.php', 1, 1, 15, 1, 15),
(4, 'default_template_settings', 'best_sellers.php', 1, 1, 30, 70, 1),
(5, 'default_template_settings', 'categories.php', 1, 0, 10, 10, 1),
(6, 'default_template_settings', 'currencies.php', 1, 1, 80, 60, 1),
(7, 'default_template_settings', 'document_categories.php', 1, 0, 0, 0, 0),
(8, 'default_template_settings', 'ezpages.php', 1, 1, -1, 2, 1),
(9, 'default_template_settings', 'featured.php', 1, 0, 45, 0, 0),
(10, 'default_template_settings', 'information.php', 1, 0, 50, 40, 1),
(11, 'default_template_settings', 'languages.php', 1, 1, 70, 50, 1),
(12, 'default_template_settings', 'manufacturers.php', 1, 0, 30, 20, 1),
(13, 'default_template_settings', 'manufacturer_info.php', 1, 1, 35, 95, 1),
(14, 'default_template_settings', 'more_information.php', 1, 0, 200, 200, 1),
(15, 'default_template_settings', 'music_genres.php', 1, 1, 0, 0, 0),
(16, 'default_template_settings', 'order_history.php', 1, 1, 0, 0, 0),
(17, 'default_template_settings', 'product_notifications.php', 1, 1, 55, 85, 1),
(18, 'default_template_settings', 'record_companies.php', 1, 1, 0, 0, 0),
(19, 'default_template_settings', 'reviews.php', 1, 0, 40, 0, 0),
(20, 'default_template_settings', 'search.php', 1, 1, 10, 0, 0),
(21, 'default_template_settings', 'search_header.php', 0, 0, 0, 0, 1),
(22, 'default_template_settings', 'shopping_cart.php', 1, 1, 20, 30, 1),
(23, 'default_template_settings', 'specials.php', 1, 1, 45, 0, 0),
(24, 'default_template_settings', 'tell_a_friend.php', 1, 1, 65, 0, 0),
(25, 'default_template_settings', 'whats_new.php', 1, 0, 20, 0, 0),
(26, 'default_template_settings', 'whos_online.php', 1, 1, 200, 200, 1),
(77, 'classic', 'banner_box.php', 1, 1, 300, 1, 1),
(78, 'classic', 'banner_box2.php', 1, 1, 15, 1, 15),
(79, 'classic', 'banner_box_all.php', 0, 1, 5, 0, 0),
(80, 'classic', 'best_sellers.php', 1, 1, -1, 70, 1),
(81, 'classic', 'categories.php', 1, 0, 10, 10, 1),
(82, 'classic', 'currencies.php', 0, 1, 80, 60, 1),
(83, 'classic', 'document_categories.php', 0, 0, 0, 0, 0),
(84, 'classic', 'ezpages.php', 1, 1, 200, 2, 1),
(85, 'classic', 'featured.php', 1, 0, 45, 0, 0),
(86, 'classic', 'information.php', 1, 0, 300, 40, 1),
(87, 'classic', 'languages.php', 0, 1, 70, 50, 1),
(88, 'classic', 'manufacturer_info.php', 1, 1, 35, 95, 1),
(89, 'classic', 'manufacturers.php', 1, 0, 30, 20, 1),
(90, 'classic', 'more_information.php', 1, 1, 400, 200, 1),
(91, 'classic', 'music_genres.php', 1, 1, 0, 0, 0),
(92, 'classic', 'order_history.php', 1, 1, 0, 0, 0),
(93, 'classic', 'product_notifications.php', 1, 1, 55, 85, 1),
(94, 'classic', 'record_companies.php', 1, 1, 0, 0, 0),
(95, 'classic', 'reviews.php', 1, 0, 40, 0, 0),
(96, 'classic', 'search.php', 0, 1, 10, 0, 0),
(97, 'classic', 'search_header.php', 0, 0, 0, 0, 1),
(98, 'classic', 'shopping_cart.php', 1, 1, -2, 30, 1),
(99, 'classic', 'specials.php', 1, 1, 45, 0, 0),
(100, 'classic', 'tell_a_friend.php', 1, 1, 65, 0, 0),
(101, 'classic', 'whats_new.php', 1, 0, 20, 0, 0),
(102, 'classic', 'whos_online.php', 1, 1, 500, 200, 1);
INSERT INTO orders_status VALUES ( '1', '1', 'Pending');
INSERT INTO orders_status VALUES ( '2', '1', 'Processing');
INSERT INTO orders_status VALUES ( '3', '1', 'Delivered');
INSERT INTO orders_status VALUES ( '4', '1', 'Update');

INSERT INTO orders_status VALUES ( '1', '2', '等待中');
INSERT INTO orders_status VALUES ( '2', '2', '处理中');
INSERT INTO orders_status VALUES ( '3', '2', '已发货');
INSERT INTO orders_status VALUES ( '4', '2', '已更新');

INSERT INTO product_types VALUES (1, '商品 - 普通', 'product', '1', 'Y', '', now(), now());
INSERT INTO product_types VALUES (2, '商品 - 音乐', 'product_music', '1', 'Y', '', now(), now());
INSERT INTO product_types VALUES (3, '文档 - 普通', 'document_general', '3', 'N', '', now(), now());
INSERT INTO product_types VALUES (4, '文档 - 商品', 'document_product', '3', 'Y', '', now(), now());
INSERT INTO product_types VALUES (5, '商品 - 免运费', 'product_free_shipping', '1', 'Y', '', now(), now());

INSERT INTO product_types_information (types_information_id, language_id, type_id, type_name) VALUES
(2, 1, 1, 'Product - General');
INSERT INTO product_types_information (types_information_id, language_id, type_id, type_name) VALUES
(3, 2, 1, '商品 - 普通');
INSERT INTO product_types_information (types_information_id, language_id, type_id, type_name) VALUES
(4, 1, 2, 'Product - Music');
INSERT INTO product_types_information (types_information_id, language_id, type_id, type_name) VALUES
(5, 2, 2, '商品 - 音乐');
INSERT INTO product_types_information (types_information_id, language_id, type_id, type_name) VALUES
(6, 1, 3, 'Document - General');
INSERT INTO product_types_information (types_information_id, language_id, type_id, type_name) VALUES
(7, 2, 3, '文档 - 普通');
INSERT INTO product_types_information (types_information_id, language_id, type_id, type_name) VALUES
(8, 1, 4, 'Document - Product');
INSERT INTO product_types_information (types_information_id, language_id, type_id, type_name) VALUES
(9, 2, 4, '文档 - 商品');
INSERT INTO product_types_information (types_information_id, language_id, type_id, type_name) VALUES
(10, 1, 5, 'Product - Free Shipping');
INSERT INTO product_types_information (types_information_id, language_id, type_id, type_name) VALUES
(11, 2, 5, '商品 - 免运费');


INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (0, 2, '下拉');
INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (1, 2,'文本');
INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (2, 2, '单选');
INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (3, 2, '多选');
INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (4, 2, '文件');
INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (5, 2, '只读');

INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (0, 1,'Dropdown');
INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (1, 1,'Text');
INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (2, 1,'Radio');
INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (3, 1,'Checkbox');
INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (4, 1,'File');
INSERT INTO products_options_types (products_options_types_id, language_id, products_options_types_name) VALUES (5, 1,'Read Only');




INSERT INTO products_options_values (products_options_values_id, language_id, products_options_values_name) VALUES (0, 1, 'TEXT');
INSERT INTO products_options_values (products_options_values_id, language_id, products_options_values_name) VALUES (0, 2, '文字');

# China/北京
INSERT INTO tax_rates VALUES (1, 1, 1, 1, 3.0, '演示税率', now(), now());
INSERT INTO geo_zones (geo_zone_id,geo_zone_name,geo_zone_description,date_added) VALUES (1,'北京','北京本地税率区',now());
INSERT INTO zones_to_geo_zones (association_id,zone_country_id,zone_id,geo_zone_id,date_added) VALUES (1,44,67,1,now());
INSERT INTO tax_class (tax_class_id, tax_class_title, tax_class_description, date_added) VALUES (1, '附加购物税', '以下商品含非食物、服务等。', now());

# USA
INSERT INTO zones VALUES (1,223,'AL','Alabama');
INSERT INTO zones VALUES (2,223,'AK','Alaska');
INSERT INTO zones VALUES (3,223,'AS','American Samoa');
INSERT INTO zones VALUES (4,223,'AZ','Arizona');
INSERT INTO zones VALUES (5,223,'AR','Arkansas');
INSERT INTO zones VALUES (6,223,'AF','Armed Forces Africa');
INSERT INTO zones VALUES (7,223,'AA','Armed Forces Americas');
INSERT INTO zones VALUES (8,223,'AC','Armed Forces Canada');
INSERT INTO zones VALUES (9,223,'AE','Armed Forces Europe');
INSERT INTO zones VALUES (10,223,'AM','Armed Forces Middle East');
INSERT INTO zones VALUES (11,223,'AP','Armed Forces Pacific');
INSERT INTO zones VALUES (12,223,'CA','California');
INSERT INTO zones VALUES (13,223,'CO','Colorado');
INSERT INTO zones VALUES (14,223,'CT','Connecticut');
INSERT INTO zones VALUES (15,223,'DE','Delaware');
INSERT INTO zones VALUES (16,223,'DC','District of Columbia');
INSERT INTO zones VALUES (17,223,'FM','Federated States Of Micronesia');
INSERT INTO zones VALUES (18,223,'FL','Florida');
INSERT INTO zones VALUES (19,223,'GA','Georgia');
INSERT INTO zones VALUES (20,223,'GU','Guam');
INSERT INTO zones VALUES (21,223,'HI','Hawaii');
INSERT INTO zones VALUES (22,223,'ID','Idaho');
INSERT INTO zones VALUES (23,223,'IL','Illinois');
INSERT INTO zones VALUES (24,223,'IN','Indiana');
INSERT INTO zones VALUES (25,223,'IA','Iowa');
INSERT INTO zones VALUES (26,223,'KS','Kansas');
INSERT INTO zones VALUES (27,223,'KY','Kentucky');
INSERT INTO zones VALUES (28,223,'LA','Louisiana');
INSERT INTO zones VALUES (29,223,'ME','Maine');
INSERT INTO zones VALUES (30,223,'MH','Marshall Islands');
INSERT INTO zones VALUES (31,223,'MD','Maryland');
INSERT INTO zones VALUES (32,223,'MA','Massachusetts');
INSERT INTO zones VALUES (33,223,'MI','Michigan');
INSERT INTO zones VALUES (34,223,'MN','Minnesota');
INSERT INTO zones VALUES (35,223,'MS','Mississippi');
INSERT INTO zones VALUES (36,223,'MO','Missouri');
INSERT INTO zones VALUES (37,223,'MT','Montana');
INSERT INTO zones VALUES (38,223,'NE','Nebraska');
INSERT INTO zones VALUES (39,223,'NV','Nevada');
INSERT INTO zones VALUES (40,223,'NH','New Hampshire');
INSERT INTO zones VALUES (41,223,'NJ','New Jersey');
INSERT INTO zones VALUES (42,223,'NM','New Mexico');
INSERT INTO zones VALUES (43,223,'NY','New York');
INSERT INTO zones VALUES (44,223,'NC','North Carolina');
INSERT INTO zones VALUES (45,223,'ND','North Dakota');
INSERT INTO zones VALUES (46,223,'MP','Northern Mariana Islands');
INSERT INTO zones VALUES (47,223,'OH','Ohio');
INSERT INTO zones VALUES (48,223,'OK','Oklahoma');
INSERT INTO zones VALUES (49,223,'OR','Oregon');
INSERT INTO zones VALUES (50,163,'PW','Palau');
INSERT INTO zones VALUES (51,223,'PA','Pennsylvania');
INSERT INTO zones VALUES (52,223,'PR','Puerto Rico');
INSERT INTO zones VALUES (53,223,'RI','Rhode Island');
INSERT INTO zones VALUES (54,223,'SC','South Carolina');
INSERT INTO zones VALUES (55,223,'SD','South Dakota');
INSERT INTO zones VALUES (56,223,'TN','Tennessee');
INSERT INTO zones VALUES (57,223,'TX','Texas');
INSERT INTO zones VALUES (58,223,'UT','Utah');
INSERT INTO zones VALUES (59,223,'VT','Vermont');
INSERT INTO zones VALUES (60,223,'VI','Virgin Islands');
INSERT INTO zones VALUES (61,223,'VA','Virginia');
INSERT INTO zones VALUES (62,223,'WA','Washington');
INSERT INTO zones VALUES (63,223,'WV','West Virginia');
INSERT INTO zones VALUES (64,223,'WI','Wisconsin');
INSERT INTO zones VALUES (65,223,'WY','Wyoming');

# China
INSERT INTO zones VALUES (66,44,'安徽','安徽');
INSERT INTO zones VALUES (67,44,'北京','北京');
INSERT INTO zones VALUES (68,44,'重庆','重庆');
INSERT INTO zones VALUES (69,44,'福建','福建');
INSERT INTO zones VALUES (70,44,'甘肃','甘肃');
INSERT INTO zones VALUES (71,44,'广东','广东');
INSERT INTO zones VALUES (72,44,'广西','广西');
INSERT INTO zones VALUES (73,44,'贵州','贵州');
INSERT INTO zones VALUES (74,44,'海南','海南');
INSERT INTO zones VALUES (75,44,'河北','河北');
INSERT INTO zones VALUES (76,44,'黑龙江','黑龙江');
INSERT INTO zones VALUES (77,44,'河南','河南');
INSERT INTO zones VALUES (78,44,'香港','香港');
INSERT INTO zones VALUES (79,44,'湖北','湖北');
INSERT INTO zones VALUES (80,44,'湖南','湖南');
INSERT INTO zones VALUES (81,44,'江苏','江苏');
INSERT INTO zones VALUES (82,44,'江西','江西');
INSERT INTO zones VALUES (83,44,'吉林','吉林');
INSERT INTO zones VALUES (84,44,'辽宁','辽宁');
INSERT INTO zones VALUES (85,44,'澳门','澳门');
INSERT INTO zones VALUES (86,44,'内蒙古','内蒙古');
INSERT INTO zones VALUES (87,44,'宁夏','宁夏');
INSERT INTO zones VALUES (88,44,'青海','青海');
INSERT INTO zones VALUES (89,44,'山西','山西');
INSERT INTO zones VALUES (90,44,'陕西','陕西');
INSERT INTO zones VALUES (91,44,'山东','山东');
INSERT INTO zones VALUES (92,44,'上海','上海');
INSERT INTO zones VALUES (93,44,'四川','四川');
INSERT INTO zones VALUES (94,44,'台湾','台湾');
INSERT INTO zones VALUES (95,44,'天津','天津');
INSERT INTO zones VALUES (96,44,'新疆','新疆');
INSERT INTO zones VALUES (97,44,'西藏','西藏');
INSERT INTO zones VALUES (98,44,'云南','云南');
INSERT INTO zones VALUES (99,44,'浙江','浙江');

# Canada
INSERT INTO zones VALUES (100,38,'AB','Alberta');
INSERT INTO zones VALUES (101,38,'BC','British Columbia');
INSERT INTO zones VALUES (102,38,'MB','Manitoba');
INSERT INTO zones VALUES (103,38,'NL','Newfoundland');
INSERT INTO zones VALUES (104,38,'NB','New Brunswick');
INSERT INTO zones VALUES (105,38,'NS','Nova Scotia');
INSERT INTO zones VALUES (106,38,'NT','Northwest Territories');
INSERT INTO zones VALUES (107,38,'NU','Nunavut');
INSERT INTO zones VALUES (108,38,'ON','Ontario');
INSERT INTO zones VALUES (109,38,'PE','Prince Edward Island');
INSERT INTO zones VALUES (110,38,'QC','Quebec');
INSERT INTO zones VALUES (111,38,'SK','Saskatchewan');
INSERT INTO zones VALUES (112,38,'YT','Yukon Territory');

# Germany
INSERT INTO zones VALUES (113,81,'NDS','Niedersachsen');
INSERT INTO zones VALUES (114,81,'BAW','Baden Wrtemberg');
INSERT INTO zones VALUES (115,81,'BAY','Bayern');
INSERT INTO zones VALUES (116,81,'BER','Berlin');
INSERT INTO zones VALUES (117,81,'BRG','Brandenburg');
INSERT INTO zones VALUES (118,81,'BRE','Bremen');
INSERT INTO zones VALUES (119,81,'HAM','Hamburg');
INSERT INTO zones VALUES (120,81,'HES','Hessen');
INSERT INTO zones VALUES (121,81,'MEC','Mecklenburg-Vorpommern');
INSERT INTO zones VALUES (122,81,'NRW','Nordrhein-Westfalen');
INSERT INTO zones VALUES (123,81,'RHE','Rheinland-Pfalz');
INSERT INTO zones VALUES (124,81,'SAR','Saarland');
INSERT INTO zones VALUES (125,81,'SAS','Sachsen');
INSERT INTO zones VALUES (126,81,'SAC','Sachsen-Anhalt');
INSERT INTO zones VALUES (127,81,'SCN','Schleswig-Holstein');
INSERT INTO zones VALUES (128,81,'THE','Thringen');

# Austria
INSERT INTO zones VALUES (129,14,'WI','Wien');
INSERT INTO zones VALUES (130,14,'NO','Niedersterreich');
INSERT INTO zones VALUES (131,14,'OO','Obersterreich');
INSERT INTO zones VALUES (132,14,'SB','Salzburg');
INSERT INTO zones VALUES (133,14,'KN','Krnten');
INSERT INTO zones VALUES (134,14,'ST','Steiermark');
INSERT INTO zones VALUES (135,14,'TI','Tirol');
INSERT INTO zones VALUES (136,14,'BL','Burgenland');
INSERT INTO zones VALUES (137,14,'VB','Voralberg');

# Swizterland
INSERT INTO zones VALUES (138,204,'AG','Aargau');
INSERT INTO zones VALUES (139,204,'AI','Appenzell Innerrhoden');
INSERT INTO zones VALUES (140,204,'AR','Appenzell Ausserrhoden');
INSERT INTO zones VALUES (141,204,'BE','Bern');
INSERT INTO zones VALUES (142,204,'BL','Basel-Landschaft');
INSERT INTO zones VALUES (143,204,'BS','Basel-Stadt');
INSERT INTO zones VALUES (144,204,'FR','Freiburg');
INSERT INTO zones VALUES (145,204,'GE','Genf');
INSERT INTO zones VALUES (146,204,'GL','Glarus');
INSERT INTO zones VALUES (147,204,'JU','Graubnden');
INSERT INTO zones VALUES (148,204,'JU','Jura');
INSERT INTO zones VALUES (149,204,'LU','Luzern');
INSERT INTO zones VALUES (150,204,'NE','Neuenburg');
INSERT INTO zones VALUES (151,204,'NW','Nidwalden');
INSERT INTO zones VALUES (152,204,'OW','Obwalden');
INSERT INTO zones VALUES (153,204,'SG','St. Gallen');
INSERT INTO zones VALUES (154,204,'SH','Schaffhausen');
INSERT INTO zones VALUES (155,204,'SO','Solothurn');
INSERT INTO zones VALUES (156,204,'SZ','Schwyz');
INSERT INTO zones VALUES (157,204,'TG','Thurgau');
INSERT INTO zones VALUES (158,204,'TI','Tessin');
INSERT INTO zones VALUES (159,204,'UR','Uri');
INSERT INTO zones VALUES (160,204,'VD','Waadt');
INSERT INTO zones VALUES (161,204,'VS','Wallis');
INSERT INTO zones VALUES (162,204,'ZG','Zug');
INSERT INTO zones VALUES (163,204,'ZH','Zrich');

# Spain
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'A Corua','A Corua');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Alava','Alava');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Albacete','Albacete');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Alicante','Alicante');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Almeria','Almeria');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Asturias','Asturias');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Avila','Avila');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Badajoz','Badajoz');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Baleares','Baleares');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Barcelona','Barcelona');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Burgos','Burgos');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Caceres','Caceres');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cadiz','Cadiz');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cantabria','Cantabria');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Castellon','Castellon');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Ceuta','Ceuta');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Ciudad Real','Ciudad Real');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cordoba','Cordoba');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cuenca','Cuenca');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Girona','Girona');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Granada','Granada');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Guadalajara','Guadalajara');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Guipuzcoa','Guipuzcoa');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Huelva','Huelva');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Huesca','Huesca');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Jaen','Jaen');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'La Rioja','La Rioja');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Las Palmas','Las Palmas');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Leon','Leon');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Lleida','Lleida');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Lugo','Lugo');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Madrid','Madrid');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Malaga','Malaga');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Melilla','Melilla');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Murcia','Murcia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Navarra','Navarra');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Ourense','Ourense');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Palencia','Palencia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Pontevedra','Pontevedra');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Salamanca','Salamanca');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Santa Cruz de Tenerife','Santa Cruz de Tenerife');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Segovia','Segovia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Sevilla','Sevilla');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Soria','Soria');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Tarragona','Tarragona');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Teruel','Teruel');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Toledo','Toledo');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Valencia','Valencia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Valladolid','Valladolid');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Vizcaya','Vizcaya');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Zamora','Zamora');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Zaragoza','Zaragoza');

#australian zones
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (13, 'ACT', 'Australian Capital Territory');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (13, 'NSW', 'New South Wales');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (13, 'NT', 'Northern Territory');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (13, 'QLD', 'Queensland');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (13, 'SA', 'South Australia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (13, 'TAS', 'Tasmania');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (13, 'VIC', 'Victoria');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (13, 'WA', 'Western Australia');


 INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_MODEL_TITLE' ,'SHOW_PRODUCT_INFO_MODEL' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_MODEL_DESCRIPTION' ,1 ,1 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_WEIGHT_TITLE' ,'SHOW_PRODUCT_INFO_WEIGHT' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_WEIGHT_DESCRIPTION' ,1 ,2 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_WEIGHT_ATTRIBUTES_TITLE' ,'SHOW_PRODUCT_INFO_WEIGHT_ATTRIBUTES' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_WEIGHT_ATTRIBUTES_DESCRIPTION' ,1 ,3 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_MANUFACTURER_TITLE' ,'SHOW_PRODUCT_INFO_MANUFACTURER' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_MANUFACTURER_DESCRIPTION' ,1 ,4 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_IN_CART_QTY_TITLE' ,'SHOW_PRODUCT_INFO_IN_CART_QTY' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_IN_CART_QTY_DESCRIPTION' ,1 ,5 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_QUANTITY_TITLE' ,'SHOW_PRODUCT_INFO_QUANTITY' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_QUANTITY_DESCRIPTION' ,1 ,6 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_REVIEWS_COUNT_TITLE' ,'SHOW_PRODUCT_INFO_REVIEWS_COUNT' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_REVIEWS_COUNT_DESCRIPTION' ,1 ,7 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_REVIEWS_TITLE' ,'SHOW_PRODUCT_INFO_REVIEWS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_REVIEWS_DESCRIPTION' ,1 ,8 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_DATE_AVAILABLE_TITLE' ,'SHOW_PRODUCT_INFO_DATE_AVAILABLE' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_DATE_AVAILABLE_DESCRIPTION' ,1 ,9 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_DATE_ADDED_TITLE' ,'SHOW_PRODUCT_INFO_DATE_ADDED' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_DATE_ADDED_DESCRIPTION' ,1 ,10 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_URL_TITLE' ,'SHOW_PRODUCT_INFO_URL' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_URL_DESCRIPTION' ,1 ,11 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_STARTING_AT_TITLE' ,'SHOW_PRODUCT_INFO_STARTING_AT' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_STARTING_AT_DESCRIPTION' ,1 ,12 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_ADDITIONAL_IMAGES_TITLE' ,'SHOW_PRODUCT_INFO_ADDITIONAL_IMAGES' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_ADDITIONAL_IMAGES_DESCRIPTION' ,1 ,13 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_TELL_A_FRIEND_TITLE' ,'SHOW_PRODUCT_INFO_TELL_A_FRIEND' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_TELL_A_FRIEND_DESCRIPTION' ,1 ,15 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH_TITLE' ,'SHOW_PRODUCT_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH' ,'0' ,'LANGUAGES_SHOW_PRODUCT_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH_DESCRIPTION' ,1 ,16 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_METATAGS_TITLE_STATUS_TITLE' ,'SHOW_PRODUCT_INFO_METATAGS_TITLE_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_METATAGS_TITLE_STATUS_DESCRIPTION' ,1 ,50 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_METATAGS_PRODUCTS_NAME_STATUS_TITLE' ,'SHOW_PRODUCT_INFO_METATAGS_PRODUCTS_NAME_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_METATAGS_PRODUCTS_NAME_STATUS_DESCRIPTION' ,1 ,51 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_METATAGS_MODEL_STATUS_TITLE' ,'SHOW_PRODUCT_INFO_METATAGS_MODEL_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_METATAGS_MODEL_STATUS_DESCRIPTION' ,1 ,52 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_METATAGS_PRICE_STATUS_TITLE' ,'SHOW_PRODUCT_INFO_METATAGS_PRICE_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_METATAGS_PRICE_STATUS_DESCRIPTION' ,1 ,53 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_INFO_METATAGS_TITLE_TAGLINE_STATUS_TITLE' ,'SHOW_PRODUCT_INFO_METATAGS_TITLE_TAGLINE_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_INFO_METATAGS_TITLE_TAGLINE_STATUS_DESCRIPTION' ,1 ,54 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_TAX_CLASS_ID_TITLE' ,'DEFAULT_PRODUCT_TAX_CLASS_ID' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_TAX_CLASS_ID_DESCRIPTION' ,1 ,100 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_PRODUCTS_VIRTUAL_TITLE' ,'DEFAULT_PRODUCT_PRODUCTS_VIRTUAL' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_PRODUCTS_VIRTUAL_DESCRIPTION' ,1 ,101 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_PRODUCTS_IS_ALWAYS_FREE_SHIPPING_TITLE' ,'DEFAULT_PRODUCT_PRODUCTS_IS_ALWAYS_FREE_SHIPPING' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_PRODUCTS_IS_ALWAYS_FREE_SHIPPING_DESCRIPTION' ,1 ,102 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTES_DISPLAY_ONLY_TITLE' ,'DEFAULT_PRODUCT_ATTRIBUTES_DISPLAY_ONLY' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTES_DISPLAY_ONLY_DESCRIPTION' ,1 ,200 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTE_IS_FREE_TITLE' ,'DEFAULT_PRODUCT_ATTRIBUTE_IS_FREE' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTE_IS_FREE_DESCRIPTION' ,1 ,201 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTES_DEFAULT_TITLE' ,'DEFAULT_PRODUCT_ATTRIBUTES_DEFAULT' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTES_DEFAULT_DESCRIPTION' ,1 ,202 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTES_DISCOUNTED_TITLE' ,'DEFAULT_PRODUCT_ATTRIBUTES_DISCOUNTED' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTES_DISCOUNTED_DESCRIPTION' ,1 ,203 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTES_PRICE_BASE_INCLUDED_TITLE' ,'DEFAULT_PRODUCT_ATTRIBUTES_PRICE_BASE_INCLUDED' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTES_PRICE_BASE_INCLUDED_DESCRIPTION' ,1 ,204 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTES_REQUIRED_TITLE' ,'DEFAULT_PRODUCT_ATTRIBUTES_REQUIRED' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_ATTRIBUTES_REQUIRED_DESCRIPTION' ,1 ,205 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_PRICE_PREFIX_TITLE' ,'DEFAULT_PRODUCT_PRICE_PREFIX' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_PRICE_PREFIX_DESCRIPTION' ,1 ,206 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX_TITLE' ,'DEFAULT_PRODUCT_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX_DESCRIPTION' ,1 ,207 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_MODEL_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_MODEL' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_MODEL_DESCRIPTION' ,2 ,1 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_WEIGHT_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_WEIGHT' ,'0' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_WEIGHT_DESCRIPTION' ,2 ,2 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_WEIGHT_ATTRIBUTES_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_WEIGHT_ATTRIBUTES' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_WEIGHT_ATTRIBUTES_DESCRIPTION' ,2 ,3 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_ARTIST_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_ARTIST' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_ARTIST_DESCRIPTION' ,2 ,4 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_GENRE_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_GENRE' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_GENRE_DESCRIPTION' ,2 ,4 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_RECORD_COMPANY_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_RECORD_COMPANY' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_RECORD_COMPANY_DESCRIPTION' ,2 ,4 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_IN_CART_QTY_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_IN_CART_QTY' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_IN_CART_QTY_DESCRIPTION' ,2 ,5 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_QUANTITY_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_QUANTITY' ,'0' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_QUANTITY_DESCRIPTION' ,2 ,6 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_REVIEWS_COUNT_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_REVIEWS_COUNT' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_REVIEWS_COUNT_DESCRIPTION' ,2 ,7 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_REVIEWS_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_REVIEWS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_REVIEWS_DESCRIPTION' ,2 ,8 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_DATE_AVAILABLE_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_DATE_AVAILABLE' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_DATE_AVAILABLE_DESCRIPTION' ,2 ,9 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_DATE_ADDED_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_DATE_ADDED' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_DATE_ADDED_DESCRIPTION' ,2 ,10 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_STARTING_AT_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_STARTING_AT' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_STARTING_AT_DESCRIPTION' ,2 ,12 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_ADDITIONAL_IMAGES_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_ADDITIONAL_IMAGES' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_ADDITIONAL_IMAGES_DESCRIPTION' ,2 ,13 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_TELL_A_FRIEND_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_TELL_A_FRIEND' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_TELL_A_FRIEND_DESCRIPTION' ,2 ,15 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH' ,'0' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH_DESCRIPTION' ,2 ,16 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_METATAGS_TITLE_STATUS_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_METATAGS_TITLE_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_METATAGS_TITLE_STATUS_DESCRIPTION' ,2 ,50 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_METATAGS_PRODUCTS_NAME_STATUS_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_METATAGS_PRODUCTS_NAME_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_METATAGS_PRODUCTS_NAME_STATUS_DESCRIPTION' ,2 ,51 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_METATAGS_MODEL_STATUS_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_METATAGS_MODEL_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_METATAGS_MODEL_STATUS_DESCRIPTION' ,2 ,52 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_METATAGS_PRICE_STATUS_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_METATAGS_PRICE_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_METATAGS_PRICE_STATUS_DESCRIPTION' ,2 ,53 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_METATAGS_TITLE_TAGLINE_STATUS_TITLE' ,'SHOW_PRODUCT_MUSIC_INFO_METATAGS_TITLE_TAGLINE_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_MUSIC_INFO_METATAGS_TITLE_TAGLINE_STATUS_DESCRIPTION' ,2 ,54 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_MUSIC_TAX_CLASS_ID_TITLE' ,'DEFAULT_PRODUCT_MUSIC_TAX_CLASS_ID' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_MUSIC_TAX_CLASS_ID_DESCRIPTION' ,2 ,100 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_MUSIC_PRODUCTS_VIRTUAL_TITLE' ,'DEFAULT_PRODUCT_MUSIC_PRODUCTS_VIRTUAL' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_MUSIC_PRODUCTS_VIRTUAL_DESCRIPTION' ,2 ,101 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_MUSIC_PRODUCTS_IS_ALWAYS_FREE_SHIPPING_TITLE' ,'DEFAULT_PRODUCT_MUSIC_PRODUCTS_IS_ALWAYS_FREE_SHIPPING' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_MUSIC_PRODUCTS_IS_ALWAYS_FREE_SHIPPING_DESCRIPTION' ,2 ,102 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_DISPLAY_ONLY_TITLE' ,'DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_DISPLAY_ONLY' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_DISPLAY_ONLY_DESCRIPTION' ,2 ,200 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTE_IS_FREE_TITLE' ,'DEFAULT_PRODUCT_MUSIC_ATTRIBUTE_IS_FREE' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTE_IS_FREE_DESCRIPTION' ,2 ,201 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_DEFAULT_TITLE' ,'DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_DEFAULT' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_DEFAULT_DESCRIPTION' ,2 ,202 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_DISCOUNTED_TITLE' ,'DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_DISCOUNTED' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_DISCOUNTED_DESCRIPTION' ,2 ,203 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_PRICE_BASE_INCLUDED_TITLE' ,'DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_PRICE_BASE_INCLUDED' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_PRICE_BASE_INCLUDED_DESCRIPTION' ,2 ,204 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_REQUIRED_TITLE' ,'DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_REQUIRED' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_MUSIC_ATTRIBUTES_REQUIRED_DESCRIPTION' ,2 ,205 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_MUSIC_PRICE_PREFIX_TITLE' ,'DEFAULT_PRODUCT_MUSIC_PRICE_PREFIX' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_MUSIC_PRICE_PREFIX_DESCRIPTION' ,2 ,206 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_MUSIC_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX_TITLE' ,'DEFAULT_PRODUCT_MUSIC_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_MUSIC_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX_DESCRIPTION' ,2 ,207 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_REVIEWS_COUNT_TITLE' ,'SHOW_DOCUMENT_GENERAL_INFO_REVIEWS_COUNT' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_REVIEWS_COUNT_DESCRIPTION' ,3 ,7 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_REVIEWS_TITLE' ,'SHOW_DOCUMENT_GENERAL_INFO_REVIEWS' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_REVIEWS_DESCRIPTION' ,3 ,8 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_DATE_AVAILABLE_TITLE' ,'SHOW_DOCUMENT_GENERAL_INFO_DATE_AVAILABLE' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_DATE_AVAILABLE_DESCRIPTION' ,3 ,9 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_DATE_ADDED_TITLE' ,'SHOW_DOCUMENT_GENERAL_INFO_DATE_ADDED' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_DATE_ADDED_DESCRIPTION' ,3 ,10 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_URL_TITLE' ,'SHOW_DOCUMENT_GENERAL_INFO_URL' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_URL_DESCRIPTION' ,3 ,11 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_ADDITIONAL_IMAGES_TITLE' ,'SHOW_DOCUMENT_GENERAL_INFO_ADDITIONAL_IMAGES' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_ADDITIONAL_IMAGES_DESCRIPTION' ,3 ,13 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_TELL_A_FRIEND_TITLE' ,'SHOW_DOCUMENT_GENERAL_INFO_TELL_A_FRIEND' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_TELL_A_FRIEND_DESCRIPTION' ,3 ,15 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_METATAGS_TITLE_STATUS_TITLE' ,'SHOW_DOCUMENT_GENERAL_INFO_METATAGS_TITLE_STATUS' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_METATAGS_TITLE_STATUS_DESCRIPTION' ,3 ,50 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_METATAGS_PRODUCTS_NAME_STATUS_TITLE' ,'SHOW_DOCUMENT_GENERAL_INFO_METATAGS_PRODUCTS_NAME_STATUS' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_METATAGS_PRODUCTS_NAME_STATUS_DESCRIPTION' ,3 ,51 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_METATAGS_TITLE_TAGLINE_STATUS_TITLE' ,'SHOW_DOCUMENT_GENERAL_INFO_METATAGS_TITLE_TAGLINE_STATUS' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_GENERAL_INFO_METATAGS_TITLE_TAGLINE_STATUS_DESCRIPTION' ,3 ,54 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_DISPLAY_ONLY_TITLE' ,'DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_DISPLAY_ONLY' ,'0' ,'LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_DISPLAY_ONLY_DESCRIPTION' ,3 ,200 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTE_IS_FREE_TITLE' ,'DEFAULT_DOCUMENT_GENERAL_ATTRIBUTE_IS_FREE' ,'1' ,'LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTE_IS_FREE_DESCRIPTION' ,3 ,201 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_DEFAULT_TITLE' ,'DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_DEFAULT' ,'0' ,'LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_DEFAULT_DESCRIPTION' ,3 ,202 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_DISCOUNTED_TITLE' ,'DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_DISCOUNTED' ,'1' ,'LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_DISCOUNTED_DESCRIPTION' ,3 ,203 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_PRICE_BASE_INCLUDED_TITLE' ,'DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_PRICE_BASE_INCLUDED' ,'1' ,'LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_PRICE_BASE_INCLUDED_DESCRIPTION' ,3 ,204 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_REQUIRED_TITLE' ,'DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_REQUIRED' ,'0' ,'LANGUAGES_DEFAULT_DOCUMENT_GENERAL_ATTRIBUTES_REQUIRED_DESCRIPTION' ,3 ,205 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_GENERAL_PRICE_PREFIX_TITLE' ,'DEFAULT_DOCUMENT_GENERAL_PRICE_PREFIX' ,'1' ,'LANGUAGES_DEFAULT_DOCUMENT_GENERAL_PRICE_PREFIX_DESCRIPTION' ,3 ,206 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_GENERAL_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX_TITLE' ,'DEFAULT_DOCUMENT_GENERAL_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX' ,'1' ,'LANGUAGES_DEFAULT_DOCUMENT_GENERAL_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX_DESCRIPTION' ,3 ,207 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_MODEL_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_MODEL' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_MODEL_DESCRIPTION' ,4 ,1 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_WEIGHT_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_WEIGHT' ,'0' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_WEIGHT_DESCRIPTION' ,4 ,2 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_WEIGHT_ATTRIBUTES_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_WEIGHT_ATTRIBUTES' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_WEIGHT_ATTRIBUTES_DESCRIPTION' ,4 ,3 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_MANUFACTURER_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_MANUFACTURER' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_MANUFACTURER_DESCRIPTION' ,4 ,4 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_IN_CART_QTY_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_IN_CART_QTY' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_IN_CART_QTY_DESCRIPTION' ,4 ,5 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_QUANTITY_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_QUANTITY' ,'0' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_QUANTITY_DESCRIPTION' ,4 ,6 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_REVIEWS_COUNT_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_REVIEWS_COUNT' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_REVIEWS_COUNT_DESCRIPTION' ,4 ,7 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_REVIEWS_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_REVIEWS' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_REVIEWS_DESCRIPTION' ,4 ,8 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_DATE_AVAILABLE_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_DATE_AVAILABLE' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_DATE_AVAILABLE_DESCRIPTION' ,4 ,9 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_DATE_ADDED_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_DATE_ADDED' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_DATE_ADDED_DESCRIPTION' ,4 ,10 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_URL_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_URL' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_URL_DESCRIPTION' ,4 ,11 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_STARTING_AT_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_STARTING_AT' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_STARTING_AT_DESCRIPTION' ,4 ,12 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_ADDITIONAL_IMAGES_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_ADDITIONAL_IMAGES' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_ADDITIONAL_IMAGES_DESCRIPTION' ,4 ,13 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_TELL_A_FRIEND_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_TELL_A_FRIEND' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_TELL_A_FRIEND_DESCRIPTION' ,4 ,15 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH' ,'0' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH_DESCRIPTION' ,4 ,16 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_TITLE_STATUS_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_TITLE_STATUS' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_TITLE_STATUS_DESCRIPTION' ,4 ,50 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_PRODUCTS_NAME_STATUS_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_PRODUCTS_NAME_STATUS' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_PRODUCTS_NAME_STATUS_DESCRIPTION' ,4 ,51 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_MODEL_STATUS_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_MODEL_STATUS' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_MODEL_STATUS_DESCRIPTION' ,4 ,52 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_PRICE_STATUS_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_PRICE_STATUS' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_PRICE_STATUS_DESCRIPTION' ,4 ,53 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_TITLE_TAGLINE_STATUS_TITLE' ,'SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_TITLE_TAGLINE_STATUS' ,'1' ,'LANGUAGES_SHOW_DOCUMENT_PRODUCT_INFO_METATAGS_TITLE_TAGLINE_STATUS_DESCRIPTION' ,4 ,54 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_TAX_CLASS_ID_TITLE' ,'DEFAULT_DOCUMENT_PRODUCT_TAX_CLASS_ID' ,'0' ,'LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_TAX_CLASS_ID_DESCRIPTION' ,4 ,100 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_PRODUCTS_VIRTUAL_TITLE' ,'DEFAULT_DOCUMENT_PRODUCT_PRODUCTS_VIRTUAL' ,'0' ,'LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_PRODUCTS_VIRTUAL_DESCRIPTION' ,4 ,101 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_PRODUCTS_IS_ALWAYS_FREE_SHIPPING_TITLE' ,'DEFAULT_DOCUMENT_PRODUCT_PRODUCTS_IS_ALWAYS_FREE_SHIPPING' ,'0' ,'LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_PRODUCTS_IS_ALWAYS_FREE_SHIPPING_DESCRIPTION' ,4 ,102 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_DISPLAY_ONLY_TITLE' ,'DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_DISPLAY_ONLY' ,'0' ,'LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_DISPLAY_ONLY_DESCRIPTION' ,4 ,200 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTE_IS_FREE_TITLE' ,'DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTE_IS_FREE' ,'1' ,'LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTE_IS_FREE_DESCRIPTION' ,4 ,201 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_DEFAULT_TITLE' ,'DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_DEFAULT' ,'0' ,'LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_DEFAULT_DESCRIPTION' ,4 ,202 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_DISCOUNTED_TITLE' ,'DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_DISCOUNTED' ,'1' ,'LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_DISCOUNTED_DESCRIPTION' ,4 ,203 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_PRICE_BASE_INCLUDED_TITLE' ,'DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_PRICE_BASE_INCLUDED' ,'1' ,'LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_PRICE_BASE_INCLUDED_DESCRIPTION' ,4 ,204 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_REQUIRED_TITLE' ,'DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_REQUIRED' ,'0' ,'LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_ATTRIBUTES_REQUIRED_DESCRIPTION' ,4 ,205 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_PRICE_PREFIX_TITLE' ,'DEFAULT_DOCUMENT_PRODUCT_PRICE_PREFIX' ,'1' ,'LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_PRICE_PREFIX_DESCRIPTION' ,4 ,206 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX_TITLE' ,'DEFAULT_DOCUMENT_PRODUCT_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX' ,'1' ,'LANGUAGES_DEFAULT_DOCUMENT_PRODUCT_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX_DESCRIPTION' ,4 ,207 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_MODEL_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_MODEL' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_MODEL_DESCRIPTION' ,5 ,1 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_WEIGHT_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_WEIGHT' ,'0' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_WEIGHT_DESCRIPTION' ,5 ,2 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_WEIGHT_ATTRIBUTES_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_WEIGHT_ATTRIBUTES' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_WEIGHT_ATTRIBUTES_DESCRIPTION' ,5 ,3 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_MANUFACTURER_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_MANUFACTURER' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_MANUFACTURER_DESCRIPTION' ,5 ,4 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_IN_CART_QTY_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_IN_CART_QTY' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_IN_CART_QTY_DESCRIPTION' ,5 ,5 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_QUANTITY_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_QUANTITY' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_QUANTITY_DESCRIPTION' ,5 ,6 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_REVIEWS_COUNT_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_REVIEWS_COUNT' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_REVIEWS_COUNT_DESCRIPTION' ,5 ,7 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_REVIEWS_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_REVIEWS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_REVIEWS_DESCRIPTION' ,5 ,8 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_DATE_AVAILABLE_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_DATE_AVAILABLE' ,'0' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_DATE_AVAILABLE_DESCRIPTION' ,5 ,9 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_DATE_ADDED_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_DATE_ADDED' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_DATE_ADDED_DESCRIPTION' ,5 ,10 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_URL_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_URL' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_URL_DESCRIPTION' ,5 ,11 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_STARTING_AT_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_STARTING_AT' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_STARTING_AT_DESCRIPTION' ,5 ,12 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_ADDITIONAL_IMAGES_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_ADDITIONAL_IMAGES' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_ADDITIONAL_IMAGES_DESCRIPTION' ,5 ,13 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_TELL_A_FRIEND_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_TELL_A_FRIEND' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_TELL_A_FRIEND_DESCRIPTION' ,5 ,15 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_ALWAYS_FREE_SHIPPING_IMAGE_SWITCH_DESCRIPTION' ,5 ,16 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_TITLE_STATUS_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_TITLE_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_TITLE_STATUS_DESCRIPTION' ,5 ,50 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_PRODUCTS_NAME_STATUS_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_PRODUCTS_NAME_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_PRODUCTS_NAME_STATUS_DESCRIPTION' ,5 ,51 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_MODEL_STATUS_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_MODEL_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_MODEL_STATUS_DESCRIPTION' ,5 ,52 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_PRICE_STATUS_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_PRICE_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_PRICE_STATUS_DESCRIPTION' ,5 ,53 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_TITLE_TAGLINE_STATUS_TITLE' ,'SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_TITLE_TAGLINE_STATUS' ,'1' ,'LANGUAGES_SHOW_PRODUCT_FREE_SHIPPING_INFO_METATAGS_TITLE_TAGLINE_STATUS_DESCRIPTION' ,5 ,54 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_TAX_CLASS_ID_TITLE' ,'DEFAULT_PRODUCT_FREE_SHIPPING_TAX_CLASS_ID' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_TAX_CLASS_ID_DESCRIPTION' ,5 ,100 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_PRODUCTS_VIRTUAL_TITLE' ,'DEFAULT_PRODUCT_FREE_SHIPPING_PRODUCTS_VIRTUAL' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_PRODUCTS_VIRTUAL_DESCRIPTION' ,5 ,101 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_PRODUCTS_IS_ALWAYS_FREE_SHIPPING_TITLE' ,'DEFAULT_PRODUCT_FREE_SHIPPING_PRODUCTS_IS_ALWAYS_FREE_SHIPPING' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_PRODUCTS_IS_ALWAYS_FREE_SHIPPING_DESCRIPTION' ,5 ,102 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_DISPLAY_ONLY_TITLE' ,'DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_DISPLAY_ONLY' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_DISPLAY_ONLY_DESCRIPTION' ,5 ,201 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTE_IS_FREE_TITLE' ,'DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTE_IS_FREE' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTE_IS_FREE_DESCRIPTION' ,5 ,201 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_DEFAULT_TITLE' ,'DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_DEFAULT' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_DEFAULT_DESCRIPTION' ,5 ,202 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_DISCOUNTED_TITLE' ,'DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_DISCOUNTED' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_DISCOUNTED_DESCRIPTION' ,5 ,203 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_PRICE_BASE_INCLUDED_TITLE' ,'DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_PRICE_BASE_INCLUDED' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_PRICE_BASE_INCLUDED_DESCRIPTION' ,5 ,204 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_REQUIRED_TITLE' ,'DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_REQUIRED' ,'0' ,'LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_ATTRIBUTES_REQUIRED_DESCRIPTION' ,5 ,205 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_PRICE_PREFIX_TITLE' ,'DEFAULT_PRODUCT_FREE_SHIPPING_PRICE_PREFIX' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_PRICE_PREFIX_DESCRIPTION' ,5 ,206 ,now() ,'','');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, date_added, use_function, set_function) VALUES ('LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX_TITLE' ,'DEFAULT_PRODUCT_FREE_SHIPPING_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX' ,'1' ,'LANGUAGES_DEFAULT_PRODUCT_FREE_SHIPPING_PRODUCTS_ATTRIBUTES_WEIGHT_PREFIX_DESCRIPTION' ,5 ,207 ,now() ,'',''); 
### eof: attribute default database updates and changes


## Insert the default queries for "all customers" and "all newsletter subscribers"
INSERT INTO query_builder ( query_id , query_category , query_name , query_description , query_string , query_keys_list ) VALUES ( '1', 'email', '所有客户', '返回所有客户的姓名和电子邮件地址，用于批量发送电子邮件(例如: 电子商情、优惠券、礼券、短信等)。', 'select customers_email_address, customers_firstname, customers_lastname from TABLE_CUSTOMERS order by customers_lastname, customers_firstname, customers_email_address', '');
INSERT INTO query_builder ( query_id , query_category , query_name , query_description , query_string , query_keys_list ) VALUES ( '2', 'email,newsletters', '所有电子商情订阅者', '返回电子商情订阅者的姓名和电子邮件地址。', 'select customers_firstname, customers_lastname, customers_email_address from TABLE_CUSTOMERS where customers_newsletter = \'1\'', '');
INSERT INTO query_builder ( query_id , query_category , query_name , query_description , query_string , query_keys_list ) VALUES ( '3', 'email,newsletters', '以往客户(超过三个月) (订阅者)', '以前曾经购物，但最近三个月内没有购物的客户订阅者', 'select o.date_purchased, c.customers_email_address, c.customers_lastname, c.customers_firstname from TABLE_CUSTOMERS c, TABLE_ORDERS o WHERE c.customers_id = o.customers_id AND c.customers_newsletter = 1 GROUP BY c.customers_email_address HAVING max(o.date_purchased) <= subdate(now(),INTERVAL 3 MONTH) ORDER BY c.customers_lastname, c.customers_firstname ASC', '');
INSERT INTO query_builder ( query_id , query_category , query_name , query_description , query_string , query_keys_list ) VALUES ( '4', 'email,newsletters', '最近三个月的客户(订阅者)', '最近三个月内有购物的电子商情订阅者。', 'select c.customers_email_address, c.customers_lastname, c.customers_firstname from TABLE_CUSTOMERS c, TABLE_ORDERS o where c.customers_newsletter = \'1\' AND c.customers_id = o.customers_id and o.date_purchased > subdate(now(),INTERVAL 3 MONTH) GROUP BY c.customers_email_address order by c.customers_lastname, c.customers_firstname ASC', '');
INSERT INTO query_builder ( query_id , query_category , query_name , query_description , query_string , query_keys_list ) VALUES ( '5', 'email,newsletters', '最近三个月的客户(无论是否订阅)', '所有曾经购物的顾客，不论是否订阅电子商情。', 'select c.customers_email_address, c.customers_lastname, c.customers_firstname from TABLE_CUSTOMERS c, TABLE_ORDERS o WHERE c.customers_id = o.customers_id and o.date_purchased > subdate(now(),INTERVAL 3 MONTH) GROUP BY c.customers_email_address order by c.customers_lastname, c.customers_firstname ASC', '');
INSERT INTO query_builder ( query_id , query_category , query_name , query_description , query_string , query_keys_list ) VALUES ( '6', 'email,newsletters', '管理员', '仅当前管理员的电子邮件帐号', 'select \'ADMIN\' as customers_firstname, admin_name as customers_lastname, admin_email as customers_email_address from TABLE_ADMIN where admin_id = $SESSION:admin_id', '');
INSERT INTO query_builder ( query_id , query_category , query_name , query_description , query_string , query_keys_list ) VALUES ( '7', 'email,newsletters', '从未购物的客户', '发给已注册但从未购物的客户', 'SELECT DISTINCT c.customers_email_address as customers_email_address, c.customers_lastname as customers_lastname, c.customers_firstname as customers_firstname FROM TABLE_CUSTOMERS c LEFT JOIN  TABLE_ORDERS o ON c.customers_id=o.customers_id WHERE o.date_purchased IS NULL', '');

#
# end of Query-Builder Setup
#

#
# Dumping data for table get_terms_to_filter
#

INSERT INTO get_terms_to_filter VALUES ('manufacturers_id', 'TABLE_MANUFACTURERS', 'manufacturers_name');
INSERT INTO get_terms_to_filter VALUES ('music_genre_id', 'TABLE_MUSIC_GENRE', 'music_genre_name');
INSERT INTO get_terms_to_filter VALUES ('record_company_id', 'TABLE_RECORD_COMPANY', 'record_company_name');

#
# Dumping data for table project_version
#

INSERT INTO project_version (project_version_id, project_version_key, project_version_major, project_version_minor, project_version_patch1, project_version_patch1_source, project_version_patch2, project_version_patch2_source, project_version_comment, project_version_date_applied) VALUES (1, 'Joy Cart Database', '1', '1', '', '', '', '', 'Fresh Installation', now());
INSERT INTO project_version (project_version_id, project_version_key, project_version_major, project_version_minor, project_version_patch1, project_version_patch1_source, project_version_patch2, project_version_patch2_source, project_version_comment, project_version_date_applied) VALUES (2, 'Joy Cart', '1', '1', '', '', '', '', 'Fresh Installation', now());
INSERT INTO project_version_history (project_version_id, project_version_key, project_version_major, project_version_minor, project_version_patch, project_version_comment, project_version_date_applied) VALUES (1, 'Joy Cart', '1', '1', '', 'Fresh Installation',  now());
INSERT INTO project_version_history (project_version_id, project_version_key, project_version_major, project_version_minor, project_version_patch, project_version_comment, project_version_date_applied) VALUES (2, 'Joy Cart Database', '1', '1', '', 'Fresh Installation', now());

##### End of SQL setup for joycart.
