<?php
require(SMARTY_DIR . "Smarty.class.php");
class MySmarty extends Smarty {

	var $app_dirname;
	var $inc_path_sign;
	var $default_tpl_dirname = "";
	var $media_dir;
	var $tmp_dir;


	function MySmarty($inc_path="./",$app_dir_name="app")
	{
		global $ua_sm_compile_dir;
		$this->Smarty();
		if(!empty($inc_path)) $this->setIncPath($inc_path);
		if(!empty($app_dir_name)) $this->setAppDir($app_dir_name);
		$NowPathArray = explode($app_dir_name,str_replace("\\","/",dirname(__FILE__))) ;
		$AppDir = $NowPathArray[0].$app_dir_name;
		$TmpDir = $NowPathArray[0]."media/tmp";
		$this->setIncPath($inc_path);
		$this->plugins_dir[] = $AppDir."/plugins/";
		$this->template_dir = $inc_path."templates/";
		$this->media_dir = $inc_path."images/";
		if(empty($ua_sm_compile_dir)){
			$this->compile_dir = $TmpDir."/templates_c/";
		}else{
			$comp_d = $TmpDir."/templates_c/".$ua_sm_compile_dir;
			if(!file_exists($comp_d)) @mkdir($comp_d);
			$this->compile_dir =$comp_d;
		}
		//$this->config_dir = $AppDir."/configs/";
		$this->cache_dir = $TmpDir."/templates_cache/";
		$this->left_delimiter = "<{";
		$this->right_delimiter = "}>";
		$this->caching = false;
		$this->debugging   = false;
		//$this->force_compile = true;
		//$this->load_filter('pre','chpath');
	}

	function setAppDir($dirname)
	{
		$this->app_dirname = $dirname;
	}

	function getAppDir()
	{
		return $this->app_dirname;
	}

	function setIncPath($inc_path){
		$this->inc_path_sign = $inc_path;
	}

	function getIncPath()
	{
		return $this->inc_path_sign;
	}

	/**
	 * Enter description here...
	 *
	 * @param unknown_type $file_name
	 * @param unknown_type $content
	 * @param ǷԶѭ̬ļ $htmlcache
	 * @return booleanǣhtmlcache
	 */
	function MakeHtmlFile($file_name, $content = "", $cache_check = false, $cache_php = "index.php")
	{
		global $htmlcache;
		global $_GET, $ua_user;
		if(!uaStrCompare(md5(AUTH_KEY), $_GET['token'])){
			goto(URL."message.php?message=".urlencode(sprintf(lgg("token_error"), $file_name)));
		}
		unset($ua_user);
		if(!$fp = fopen($file_name, "w")){
			die(sprintf(lgg("file_open_error"), $file_name));
			return false;
		}
		if(!fwrite($fp, $content)){
			die(sprintf(lgg("file_wt_error"), $file_name));
			return false;
		}
		fclose($fp);
		chmod($file_name,0666);
		if ($cache_check) {
			$htmlcache->updateCacheTime($cache_php);
			if(STATIC_HTML_LEVEL>0) goto($file_name);else {
				goto($_SERVER['PHP_SELF']);
			}
		}
		return true;
	}

	function getRelativePath()
	{
		//../../index.html
		global $_GET, $theme_name;
		$paths = array();
		$currentRelativePath = $this->getIncPath();
		if (isset($_GET['action']) && ($_GET['action'])=="html") {
			if($currentRelativePath=="./") $currentRelativePath = "../";
			elseif($currentRelativePath=="../") $currentRelativePath = "../../";
			$paths['CSS_PATH'] = $paths['JS_PATH'] = $paths['INC_PATH'] = $currentRelativePath;
			$paths['tpl_img_path'] = $currentRelativePath."images/";
			$paths['member_tpl_path'] = $currentRelativePath."templates/";
			$paths['attachment_dir'] = $currentRelativePath."media/attachment/";
			$paths['attachment_url'] = URL."media/attachment/";
		}else {
			$paths['CSS_PATH'] = $paths['JS_PATH'] = $paths['INC_PATH'] = $currentRelativePath;
			$paths['tpl_img_path'] = $this->media_dir;
			$paths['member_tpl_path'] = $currentRelativePath."templates/";
			$paths['attachment_dir'] = $currentRelativePath."media/attachment/";
			$paths['attachment_url'] = URL."media/attachment/";
		}
		return $paths;
	}

	function getAbsolutePath()
	{
		global $theme_name;
		$paths = array();
		$currentRelativePath = substr(URL, 0, -1);
		$paths['CSS_PATH'] = $paths['JS_PATH'] = $paths['INC_PATH'] = $paths['media_path'] = $currentRelativePath."/";
		$paths['tpl_img_path'] = URL."images/";
		$paths['attachment_dir'] = $currentRelativePath."media/attachment/";
		$paths['attachment_url'] = URL."media/attachment/";
		return $paths;
	}
}
?>