<?php
class UaModel extends UaObject
{
	var $primaryKey = "id";
	var $id = null;
	var $catchIds = null;
	var $table;
	var $col = 0;
	var $row = 1;
	var $limit_max = 10;
	var $title;
	var $position;
	/**
	* if your site is made by div
	* you can change this like to </div><div>.
	*/
	var $term = "</tr><tr>";
	/**
	 * If your site is made by li
	 * you can change this like to </div>
	 * @var unknown_type
	 */
	var $line_term = "</tr>";

	function setPageTitle($titles = null, $positions = null, $left = "&laquo;", $right = "&raquo;")
	{
	    global $_SETTINGS;
	    if(is_array($titles)) {
	        $titles[] = $_SETTINGS['sitetitle'];
	        $title = implode($left, $titles);
	    }
		else $title = $titles;
		$this->title = $title;
	    if(is_array($positions)) {
	        $positions[] = $_SETTINGS['sitename'];
	        rsort($positions);
	        $position = implode($right, $positions);
	    }
		else $position = $positions;
		$this->position = $position;
	}

	function getTitle()
	{
		return $this->title;
	}

	function getPosition()
	{
		return $this->position;
	}


	function checkTerminal($i)
	{
	    $col = $this->col;
	    if($this->col>0){
	        if ($col==$this->limit_max) {
	        	return "";
	        }else{
	        if($i%$col==0){
	           return $this->term;
	        }else{
	            return "";
	        }
	        }
	    }elseif($this->row==1){
	        return $this->line_term;
	    }else{
	        return "";
	    }
	}

	function setLimit($row, $col, $max)
	{
	    if (!empty($max)) {
	    	$this->limit_max = $max;
	    }
	    if ($row>1) {
	    	$this->row = $row;
	    }
	    if ($col>0) {
	    	$this->col = $col;
	    }
	}

	function getLimit()
	{
	    if ($this->col==0 || $this->row==1) {
	    	$return  = " limit ".$this->limit_max;
	    }else{
	        $return = " limit ".$this->col*$this->row;
	    }
	    return $return;
	}

	function setPrimaryKey($p = null)
	{
		if (is_null($p)) {
			$p = "id";
		}
		$this->primaryKey = $p;
	}

	function getPrimaryKey()
	{
		return $this->primaryKey;
	}

	function setId($id)
	{
		$this->id = $id;
	}

	function getId()
	{
		return $this->id;
	}

	/**
	 * ɰ汾1.0delete
	 * @param Mixed $id_array ҪɾΨһID
	 * @return Boolean
	 */
	function del($id_array, $conditions = null)
	{
		global $g_db;
		$del_id = $this->primaryKey;
		$tmp_ids = null;
		if (is_array($id_array))
		{
			$tmp_ids = implode(",",$id_array);
			$cond[] = "$del_id in (".$tmp_ids.")";
			$this->catchIds = serialize($id_array);
		}
		else
		{
			$cond[] = "$del_id=".intval($id_array);
			$this->catchIds = $id_array;
		}
		if(isset($conditions)) {
			if(is_array($conditions)) $cond[] = implode(" and ", $conditions);
			else $cond[] = $conditions;
		}
		$tmp_where_cond = implode(" and ", $cond);
		$sql = "delete from ".$this->getTable()." where ".$tmp_where_cond;
		$r_deleted = $g_db->Execute($sql);
		if($r_deleted)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	/**
	 * ɰ汾update
	 * 2007-8-28 this->primaryKeyеĹ̶ idֶΣʹÿѡ
	 */
	function save($posts, $action=null, $id=null, $tbname = null, $conditions = null, $if_check_word_ban = false)
	{
		global $g_db;
		global $primary_id;
		$new_id = false;
		$keys = array_keys($posts);
		$cols = implode($keys,",");
		$tbname = (is_null($tbname))? $this->getTable():trim($tbname);
		if(!empty($primary_id)){
			$sql = "select $cols from ".$tbname." where ".$this->primaryKey."='".$primary_id."'";
		}elseif(!empty($id)){
			$sql = "select $cols from ".$tbname." where ".$this->primaryKey."='".$id."'";
		}else{
			$sql = "select $cols from ".$tbname." where ".$this->primaryKey."='-1'";
		}
		if (!is_null($conditions)) {
			$sql.= $conditions;
		}
		$rs = $g_db->Execute($sql);
		$record = array();
		foreach ($keys as $colname) {
			$record[$colname] = $posts[$colname];
			if($if_check_word_ban){
				//check mask words.
			}
		}
		if (strtolower($action) == "update" || !empty($primary_id)) {
			$insertsql = $g_db->GetUpdateSQL($rs,$record);
		}else {
		    $new_id = true;
			$insertsql = $g_db->GetInsertSQL($rs,$record);
		}
		$result = $g_db->Execute($insertsql);
		if (!$result || empty($result)) {
			return false;
		}else {
		    if($new_id){
		        $insert_key = $tbname."_id";
		        $this->$insert_key = $g_db->Insert_ID();
		    }
			return true;
		}
	}

	/**
	 * õĳ¼Ϣ
	 *
	 * @param unknown_type $id
	 */
	function read($fields = null, $id = null, $tables = null, $conditions = null)
	{
		global $g_db;
		global $joins;
		$tmp_tablename = null;
		if ($id!==null) {
			$this->id = $id;
		}
		$id = $this->id;
		if (is_array($this->id)) {
			$id = $this->id[0];
		}
		if($tables == null){
			$tmp_tablename = $this->getTable(true);
		}
		if (is_null($fields)) {
			$fields = null;
			$columns = $g_db->MetaColumnNames($this->getTable());
			foreach ($columns as $key=>$val) {
				$fields.=$key." as ".$this->name.uaProcessTableCol($val).",";
			}
			$fields = substr_replace($fields,'',-1,1);
		}
		$sql = null;

		if ($this->id !== null && $this->id !== false) {
			$field = trim($this->name).".".$this->primaryKey;
		}
		$sql = "select ".$fields." from ".$tmp_tablename." where ".$field."='".$id."'";
		if($conditions !=null){
			$sql.= " ".$conditions;
		}
		$res = $g_db->GetRow($sql);
		return $res;
	}

	/**
	 * õĳfieldֵadodbgetone
	 * 2.0field
	 * @param ֵֶ $target_val
	 * @param Ҫõֵֶֶ $get_col
	 * @param ֶ $target_col
	 * @return unknown
	 */
	function find($target_val,$get_col = "id", $target_col=null)
	{
		global $g_db;
		if(is_null($target_col)) $target_col = $this->primaryKey;
		$sql = "select ".$get_col." from ".$this->getTable(true)." where ".$target_col."='".$target_val."'";
		$res  = $g_db->GetOne($sql);
		return $res;
	}

	/**
	 * õĳһֶε
	 * 1.0find
	 * @param ֶ $name
	 * @param  $conditions
	 * @param  $order
	 * @return ֵֶ
	 */
	function field($name, $conditions = null, $order = null) {
		global $g_db;

		if ($conditions === null) {
			$conditions = array($this->name . '.' . $this->primaryKey => $this->id);
		}
		if (is_array($conditions)) {
			$tmp_conditions = implode(" and ",$conditions);
			$conditions = $tmp_conditions;
		}
		$sql = "select ".trim($name)." from ".$this->getTable(true)." where ".$conditions;
		$result  = $g_db->GetOne($sql);
		return $result;
	}

	function getFieldAliasNames()
	{
		global $g_db;
		$table_name = $this->getTable();
		$fields = null;
		$columns = $g_db->MetaColumnNames($table_name);
		foreach ($columns as $key=>$val) {
			$fields.=$this->name.".".$key." as ".$this->name.uaProcessTableCol($val).",";
		}
		$fields = substr_replace($fields,'',-1,1);
		return $fields;
	}

	/**
	 * 1.0betagetTableName();
	 *
	 * @param Ƿͬʱȡñ $alias
	 * @return ݱ
	 */
	function getTable($alias = false)
	{
		global $tb_prefix;
		$table = $tb_prefix.strtolower(get_class($this));
		if($alias) $table.= " as ".$this->name;
		return $table;
	}

	/**
	 * 1.0 getAmount
	 *
	 * @param unknown_type $conditions
	 * @param unknown_type $countfield
	 * @return unknown
	 */
	function findCount($conditions = null, $countfield = null, $tables = null, $ujoins="")
	{
		global $g_db;
		global $joins;
		$tmp_conditions = null;
		$sql = null;
		if(is_null($countfield)) $countfield = $this->primaryKey;
		if (is_null($tables)) {
			$tables = $this->getTable(true);
		}
		if (!empty($joins)) {
			foreach ($joins as $assoc => $data) {
				$tables.=",".$data['fullTableName'];
				$tmp_conditions.= "and ".$this->name.".".$data['foreignKey']."=".$assoc.".id";
			}
		}
		$sql = "select count(".$countfield.") as Amount from ".$tables." ".$ujoins;
		if (!empty($conditions)) {
			$sql.= " where ".$conditions." ".$tmp_conditions;
		}
		$return = $g_db->GetOne($sql);
		return $return;
	}

	/**
	 * е getRecords,ۺleft join,belongsto
	 *
	 * @param unknown_type $fields
	 * @param unknown_type $conditions
	 * @param unknown_type $order
	 * @param unknown_type $limit
	 * @param unknown_type $offset
	 * @param unknown_type $recursive
	 * @return unknown
	 */
	function findAll($fields, $conditions = null, $order = null, $limit = null, $offset = null, $recursive = null)
	{
		global $g_db;
		global $joins;
		$join_fields	= null;
		$orders			= null;
		$records		= null;
		$condition	 	= null;
		if (!empty($joins)) {
			foreach ($joins as $assoc => $data) {
				if(isset($data['foreignKey'])) {
					if(isset($data['PrimaryKey'])) $values[] = " left join ".$data['fullTableName']." on ".$assoc.".".$data['PrimaryKey']."=".$this->name.".".$data['foreignKey'];
					else $values[] = " left join ".$data['fullTableName']." on ".$this->name.".".$data['foreignKey']."=".$assoc.".id ";
				}else $values[] = " left join ".$data['fullTableName']." on ".$this->name.".".$data['foreignKey']."=".$assoc.".id ";
				if($data['fields']) $find_fields[] = $data['fields'];
			}
			$join_fields = implode(" ",$values);
		}

		if (is_null($fields)) {
			$find_fields[] = $this->name.".*";
		}else{
			$find_fields[] = $fields;
		}
		$fields = implode(",",$find_fields);
		$sql = "select ".$fields." from ".$this->getTable(true).$join_fields;
		if (!empty($conditions)) {
			$condition.= " where ".$conditions;
			$sql.= $condition;
		}
		if (!is_null($order)) {
			$orders.= " order by ".$order;
			$sql.= $orders;
		}
		if (!is_null($limit) && !is_null($offset)) {
			$records.= " limit $limit,$offset";
			$sql.=$records;
		}
		$return = $g_db->GetArray($sql);
		return $return;
	}

	function clicked($id, $add = true)
	{
		global $g_db;
		if($add){
			$sql = "update ".$this->getTable()." set clicked=clicked+1 where id=".$id;
		}
		return $g_db->Execute($sql);
	}

	/**
	 * ޸ļ¼״̬
	 *
	 * @param mixed Ҫ޸ĵı $id
	 * @param ޸Ϊ״̬ $status
	 * @return boolean
	 */
	 function check($id = null, $status = 0)
	{
		if(is_array($id)){
			$checkId = "id in (".implode(",",$id).")";
		}elseif(intval($id)) {
			$checkId = "id=".$id;
		}else{
			return false;
		}
		$sql = "update ".$this->getTable()." set status='".$status."' where ".$checkId;
		$return = $GLOBALS['g_db']->Execute($sql);
		if($return){
			return true;
		}else {
			return false;
		}
	}

	/**
	 * ĳֶ
	 * @param mixed ֶ
	 * @param mixed ֵ
	 * @return boolean
	 */
	function saveField($name, $value, $id = null, $conditions = null)
	{
		if(is_array($id)){
			$checkId = "id in (".implode(",",$id).")";
		}elseif(is_int($id)) {
			$checkId = "id=".$id;
		}else{
			$checkId = 1;
		}
		if(empty($conditions)) $conditions = 1;
		if($checkId){
			$sql = "update ".$this->getTable()." set $name='".$value."' where ".$checkId." and ".$conditions;
			$return = $GLOBALS['g_db']->Execute($sql);
		}
		return $return;
	}

	/**
	 * ĳidԱʾΪid
	 *
	 * @return unknown
	 */
	function getMaxId()
	{
		$sql = "select max(id) from ".$this->getTable();
		$max_id = $GLOBALS['g_db']->GetOne($sql);
		return $max_id;
	}
}
?>