--
-- ݿ: 'ualink'2008-9-27 11:23
--

-- --------------------------------------------------------

--
-- Table 'eos_accesses'
--

DROP TABLE IF EXISTS eos_accesses;
CREATE TABLE eos_accesses (
  id tinyint(2) NOT NULL auto_increment,
  name varchar(25) default NULL,
  membertype_id tinyint(2) default NULL,
  max_sell tinyint(2) default '3',
  max_buy tinyint(2) default '3',
  max_product tinyint(2) default '3',
  max_job tinyint(2) default '3',
  max_news tinyint(2) default '3',
  max_producttype tinyint(2) default '3',
  max_of_rs_eday tinyint(2) default '3',
  check_trade_update tinyint(1) default '1',
  check_company_update tinyint(1) default '1',
  check_product_update tinyint(1) default '1',
  check_job_update tinyint(1) default '1',
  check_news_update tinyint(1) default '1',
  check_keyword_update tinyint(1) default NULL,
  max_room_favor tinyint(2) default '3',
  can_organize_groupbuy tinyint(1) default NULL,
  if_googlemap tinyint(1) default '0',
  default_livetime tinyint(2) default NULL,
  after_livetime tinyint(2) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_adminers'
--

DROP TABLE IF EXISTS eos_adminers;
CREATE TABLE eos_adminers (
  id tinyint(2) NOT NULL auto_increment,
  depart_id tinyint(2) default NULL,
  user_name varchar(25) default NULL,
  user_pass varchar(50) default NULL,
  first_name varchar(25) default NULL,
  last_name varchar(25) default NULL,
  email varchar(25) default NULL,
  level tinyint(1) default NULL,
  last_login int(11) default NULL,
  last_ip varchar(25) default NULL,
  created int(11) default NULL,
  PRIMARY KEY  (id),
  UNIQUE KEY user_name (user_name)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_adminlogs'
--

DROP TABLE IF EXISTS eos_adminlogs;
CREATE TABLE eos_adminlogs (
  id int(10) NOT NULL auto_increment,
  adminer_id tinyint(2) default NULL,
  action_description tinytext,
  ip_address int(10) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_adminmodules'
--

DROP TABLE IF EXISTS eos_adminmodules;
CREATE TABLE eos_adminmodules (
  id int(5) NOT NULL auto_increment,
  parent_id int(5) default '0',
  name varchar(50) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_adminprivileges'
--

DROP TABLE IF EXISTS eos_adminprivileges;
CREATE TABLE eos_adminprivileges (
  id int(5) NOT NULL auto_increment,
  adminmodule_id int(5) default NULL,
  name varchar(25) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_adminroles'
--

DROP TABLE IF EXISTS eos_adminroles;
CREATE TABLE eos_adminroles (
  id tinyint(2) NOT NULL auto_increment,
  name varchar(25) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_adses'
--

DROP TABLE IF EXISTS eos_adses;
CREATE TABLE eos_adses (
  id int(5) NOT NULL auto_increment,
  adzone_id int(2) default NULL,
  member_id int(10) default NULL,
  title varchar(50) default NULL,
  description text,
  keywords varchar(50) default NULL,
  source_url varchar(100) default NULL,
  target_url varchar(100) default NULL,
  source_type varchar(20) default NULL,
  width smallint(6) default NULL,
  height smallint(6) default NULL,
  source_name varchar(50) default NULL,
  alt_words varchar(50) default NULL,
  start_date int(10) default NULL,
  end_date int(10) default NULL,
  priority tinyint(2) default NULL,
  status tinyint(1) default NULL,
  clicked smallint(6) default '1',
  da enum('_parent','_self','_blank') default '_blank',
  db tinyint(1) default NULL,
  dc tinyint(1) default NULL,
  de tinyint(1) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_adzones'
--

DROP TABLE IF EXISTS eos_adzones;
CREATE TABLE eos_adzones (
  id smallint(6) NOT NULL auto_increment,
  ua_zone_name varchar(15) default NULL,
  what varchar(10) default NULL,
  name varchar(100) default NULL,
  description text,
  price varchar(50) default NULL,
  file_name varchar(100) default NULL,
  width smallint(6) default NULL,
  height smallint(6) default NULL,
  wrap smallint(6) default '0',
  max_ad smallint(6) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_areas'
--

DROP TABLE IF EXISTS eos_areas;
CREATE TABLE eos_areas (
  id int(9) NOT NULL auto_increment,
  spelling varchar(15) default NULL,
  name varchar(50) default NULL,
  code_id int(9) default NULL,
  brief_name varchar(15) default NULL,
  english_name varchar(100) default NULL,
  tel_code varchar(15) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_attachments'
--

DROP TABLE IF EXISTS eos_attachments;
CREATE TABLE eos_attachments (
  id int(10) NOT NULL auto_increment,
  member_id int(10) default NULL,
  company_id int(10) default NULL,
  file_name char(100) default NULL,
  title char(50) default NULL,
  description char(100) default NULL,
  file_type char(50) default NULL,
  file_size smallint(6) default NULL,
  attachment varchar(100) default NULL,
  remote varchar(100) default NULL,
  is_image tinyint(1) default NULL,
  type_id tinyint(2) default NULL,
  status tinyint(1) default '0',
  created int(10) default NULL,
  modified int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_companies'
--

DROP TABLE IF EXISTS eos_companies;
CREATE TABLE eos_companies (
  id int(9) NOT NULL auto_increment,
  member_id int(9) default NULL,
  industry_id int(3) default NULL,
  style_id tinyint(2) default '1',
  type_id tinyint(2) default '0',
  name char(100) default NULL,
  english_name char(100) default NULL,
  keywords varchar(50) default NULL,
  boss_name varchar(25) default NULL,
  manage_type varchar(25) default NULL,
  year_annual tinyint(2) default NULL,
  property tinyint(2) default NULL,
  description text,
  configs text,
  bank_from varchar(50) default NULL,
  bank_account varchar(50) default NULL,
  main_prod varchar(100) default NULL,
  employee_amount varchar(25) default NULL,
  found_date int(11) default NULL,
  reg_fund tinyint(2) default NULL,
  reg_address varchar(200) default NULL,
  country_id char(6) default NULL,
  province_code_id char(6) default NULL,
  city_code_id char(6) default NULL,
  address varchar(200) default NULL,
  zipcode varchar(15) default NULL,
  main_brand varchar(100) default NULL,
  main_market varchar(200) default NULL,
  main_biz_place varchar(50) default NULL,
  main_customer varchar(200) default NULL,
  link_man varchar(25) default NULL,
  link_man_gender tinyint(1) default NULL,
  position int(5) default NULL,
  telcode varchar(8) default NULL,
  telzone varchar(8) default NULL,
  tel varchar(25) default NULL,
  faxcode varchar(8) default NULL,
  faxzone varchar(8) default NULL,
  fax varchar(25) default NULL,
  mobile varchar(25) default NULL,
  email varchar(100) default NULL,
  site_url varchar(100) default NULL,
  picture varchar(50) default NULL,
  status tinyint(1) default '0',
  first_letter char(2) default NULL,
  if_commend tinyint(1) default null default '0',
  clicked int(5) default '1',
  created int(10) default NULL,
  modified int(10) default NULL,
  PRIMARY KEY  (id),
  KEY member_id (member_id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_companydeparts'
--

DROP TABLE IF EXISTS eos_companydeparts;
CREATE TABLE eos_companydeparts (
  id int(10) NOT NULL auto_increment,
  member_id int(10) default NULL,
  company_id int(10) default NULL,
  name varchar(50) default NULL,
  created int(10) default NULL,
  modified int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_companyemployees'
--

DROP TABLE IF EXISTS eos_companyemployees;
CREATE TABLE eos_companyemployees (
  id int(10) NOT NULL auto_increment,
  company_id int(10) default NULL,
  login_name varchar(25) default NULL,
  true_name varchar(50) default NULL,
  position varchar(50) default NULL,
  attachment_id int(10) default NULL,
  created int(10) default NULL,
  modified int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_companylinks'
--

DROP TABLE IF EXISTS eos_companylinks;
CREATE TABLE eos_companylinks (
  id int(11) NOT NULL auto_increment,
  member_id int(11) default NULL,
  user_name varchar(25) default NULL,
  companyid1 int(9) default NULL,
  companyid2 int(9) default NULL,
  friendlogo varchar(100) default NULL,
  created int(11) default NULL,
  PRIMARY KEY  (id),
  UNIQUE KEY my_company_link (member_id,companyid1,companyid2)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_companymessages'
--

DROP TABLE IF EXISTS eos_companymessages;
CREATE TABLE eos_companymessages (
  id int(11) NOT NULL auto_increment,
  from_member_id varchar(25) default NULL,
  to_member_id int(11) default NULL,
  title varchar(25) default NULL,
  content varchar(250) default NULL,
  grade tinyint(1) default '0',
  status tinyint(1) default '0',
  created int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_companynewses'
--

DROP TABLE IF EXISTS eos_companynewses;
CREATE TABLE eos_companynewses (
  id int(11) NOT NULL auto_increment,
  member_id int(11) default NULL,
  company_id int(11) default NULL,
  title varchar(100) default NULL,
  content text,
  picture varchar(100) default NULL,
  status tinyint(1) default '0',
  clicked int(5) default '1',
  created int(11) default NULL,
  modified int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_companyoutlinks'
--

DROP TABLE IF EXISTS eos_companyoutlinks;
CREATE TABLE eos_companyoutlinks (
  id int(11) NOT NULL auto_increment,
  member_id int(11) default NULL,
  company_id int(11) default NULL,
  name varchar(25) default NULL,
  url varchar(100) default NULL,
  created int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_companystyles'
--

DROP TABLE IF EXISTS eos_companystyles;
CREATE TABLE eos_companystyles (
  id tinyint(2) NOT NULL auto_increment,
  name varchar(50) default NULL,
  preview_pic varchar(50) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_companytypes'
--

DROP TABLE IF EXISTS eos_companytypes;
CREATE TABLE eos_companytypes (
  id tinyint(2) auto_increment,
  name varchar(50) default NULL,
  avaliable tinyint(1) NOT NULL default '1' ,
  picture varchar(50) default NULL,
  ca text default NULL,
  cb tinyint(1) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_expoes'
--

DROP TABLE IF EXISTS eos_expoes;
CREATE TABLE eos_expoes (
  id int(10) NOT NULL auto_increment,
  ea varchar(100) default NULL,
  eb varchar(10) default NULL,
  country_id varchar(50) default NULL,
  province_id varchar(50) default NULL,
  city_id varchar(50) default NULL,
  ec varchar(150) default NULL,
  ed varchar(25) default NULL,
  ef varchar(25) default NULL,
  eg varchar(25) default NULL,
  eh varchar(50) default NULL,
  ei varchar(150) default NULL,
  ej varchar(100) default NULL,
  ek varchar(100) default NULL,
  el text,
  em varchar(100) default NULL,
  eo varchar(15) default NULL,
  ep varchar(25) default NULL,
  eq varchar(25) default NULL,
  email varchar(50) default NULL,
  er varchar(25) default NULL,
  es varchar(100) default NULL,
  et varchar(100) default NULL,
  eu varchar(100) default NULL,
  ev varchar(100) default NULL,
  ew text,
  ex varchar(100) default NULL,
  ey varchar(100) default NULL,
  picture varchar(50) default NULL,
  if_show_picture tinyint(1) default NULL,
  if_recommend tinyint(1) default NULL,
  type_id tinyint(2) default NULL,
  status tinyint(1) default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_expostadiums'
--

DROP TABLE IF EXISTS eos_expostadiums;
CREATE TABLE eos_expostadiums (
  id smallint(6) NOT NULL auto_increment,
  sa varchar(100) default NULL,
  country_id smallint(6) default NULL,
  province_id smallint(6) default NULL,
  city_id smallint(6) default NULL,
  sb varchar(200) default NULL,
  sc varchar(150) default NULL,
  sd varchar(150) default NULL,
  se varchar(150) default NULL,
  sf varchar(150) default NULL,
  sg text,
  sh smallint(6) default NULL,
  created int(10) default NULL,
  modified int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_expotypes'
--

DROP TABLE IF EXISTS eos_expotypes;
CREATE TABLE eos_expotypes (
  id int(5) NOT NULL auto_increment,
  name varchar(50) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_favorites'
--

DROP TABLE IF EXISTS eos_favorites;
CREATE TABLE eos_favorites (
  `id` int(10) NOT NULL auto_increment,
  `member_id` int(10) NOT NULL default '-1' COMMENT 'Ա',
  `target_id` int(10) default NULL,
  `type_id` tinyint(2) default NULL,
  `created` int(10) default NULL,
  `modified` int(10) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `member_favor` (`member_id`,`target_id`)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_forms'
--

DROP TABLE IF EXISTS eos_forms;
CREATE TABLE eos_forms (
  id smallint(6) NOT NULL auto_increment,
  field_title varchar(100) default NULL,
  field_type varchar(100) default NULL,
  field_size varchar(11) default NULL,
  field_maxlength varchar(11) default NULL,
  field_name varchar(50) default NULL,
  field_value varchar(50) default NULL,
  field_empty tinyint(1) default NULL,
  field_repeat tinyint(1) default NULL,
  field_intro varchar(100) default NULL,
  status tinyint(1) default NULL,
  priority tinyint(2) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_friendlinks'
--

DROP TABLE IF EXISTS eos_friendlinks;
CREATE TABLE eos_friendlinks (
  id int(5) NOT NULL auto_increment,
  title varchar(50) default NULL,
  logo varchar(100) default NULL,
  url varchar(50) default NULL,
  priority smallint(5) default '0',
  status tinyint(1) default '1',
  created int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_helps'
--

DROP TABLE IF EXISTS eos_helps;
CREATE TABLE eos_helps (
  id int(5) NOT NULL auto_increment,
  helptype_id int(5) default NULL,
  ha varchar(100) default NULL,
  hb text,
  hd tinyint(1) default NULL,
  hk varchar(50) default NULL,
  he int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_helptypes'
--

DROP TABLE IF EXISTS eos_helptypes;
CREATE TABLE eos_helptypes (
  id int(5) NOT NULL auto_increment,
  ha varchar(100) default NULL,
  hb varchar(100) default NULL,
  hc int(5) default NULL,
  hd tinyint(1) default '1',
  he tinyint(1) default NULL,
  hf tinyint(1) default NULL,
  hg tinyint(1) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_htmlcaches'
--

DROP TABLE IF EXISTS eos_htmlcaches;
CREATE TABLE eos_htmlcaches (
  id int(5) NOT NULL auto_increment,
  h_n varchar(50) default NULL,
  h_l int(10) default NULL,
  h_r varchar(15) default '86400',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_indreccompanies'
--

DROP TABLE IF EXISTS eos_indreccompanies;
CREATE TABLE eos_indreccompanies (
  id int(10) NOT NULL auto_increment,
  industry_id int(10) default NULL,
  member_id int(10) default NULL,
  company_id int(10) default NULL,
  user_name varchar(25) default NULL,
  priority smallint(6) default '0',
  PRIMARY KEY  (id),
  KEY industry_id (industry_id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_industries'
--

DROP TABLE IF EXISTS eos_industries;
CREATE TABLE eos_industries (
  id int(5) NOT NULL auto_increment,
  name varchar(50) default NULL,
  parentid int(5) default NULL default '0',
  buy_amount int(9) default '0',
  sell_amount int(9) default '0',
  product_amount int(9) default '0',
  company_amount int(9) default '0',
  ia tinyint(1) default '0',
  ib tinyint(1) default '0',
  level tinyint(2) default NULL,
  priority tinyint(2) default '0',
  created char(10) default 0,
  modified char(10) default 0,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_inqueries'
--

DROP TABLE IF EXISTS eos_inqueries;
CREATE TABLE eos_inqueries (
  id int(10) NOT NULL auto_increment,
  to_member_id int(10) default NULL,
  to_company_id int(10) default NULL,
  title varchar(50) default NULL,
  content tinytext,
  send_achive tinyint(1) default NULL,
  know_more varchar(50) default NULL,
  exp_quantity varchar(15) default NULL,
  exp_price varchar(15) default NULL,
  ia tinytext,
  user_ip varchar(11) default NULL,
  created int(10) NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_ipbanned'
--

DROP TABLE IF EXISTS eos_ipbanned;
CREATE TABLE eos_ipbanned (
  id smallint(6) default NULL,
  ip1 smallint(3) default NULL,
  ip2 smallint(3) default NULL,
  ip3 smallint(3) default NULL,
  ip4 smallint(3) default NULL,
  created int(10) default NULL,
  expiration int(10) default NULL
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_jobs'
--

DROP TABLE IF EXISTS eos_jobs;
CREATE TABLE eos_jobs (
  id int(10) NOT NULL auto_increment,
  member_id int(10) default NULL,
  company_id int(10) default NULL,
  name varchar(150) default NULL,
  work_station varchar(50) default NULL,
  content text,
  require_gender_id tinyint(1) default NULL,
  peoples varchar(5) default NULL,
  require_education_id tinyint(2) default NULL,
  require_age varchar(10) default NULL,
  salary_id tinyint(2) default NULL,
  worktype_id tinyint(1) default NULL,
  status tinyint(1) default '0',
  clicked int(5) default NULL,
  created int(10) default NULL,
  expire_time int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_keywords'
--

DROP TABLE IF EXISTS eos_keywords;
CREATE TABLE eos_keywords (
  id int(5) NOT NULL auto_increment,
  primary_id TEXT default NULL,
  member_id int(10) default NULL,
  title varchar(25) default NULL,
  clicked smallint(6) default '1',
  numbers smallint(6) default NULL,
  status enum('1','0') default '0',
  type enum('index','trades','companies','newses','markets','expoes','products') default 'index',
  rank tinyint(1) default '0',
  created datetime default NULL,
  PRIMARY KEY  (id),
  KEY title (title)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_keywordships'
--

DROP TABLE IF EXISTS eos_keywordships;
CREATE TABLE eos_keywordships (
  id int(10) NOT NULL auto_increment,
  ka int(10) default NULL,
  ki int(10) default NULL,
  kb int(10) default NULL,
  kc int(10) default NULL,
  kd int(10) default NULL,
  ke int(10) default NULL,
  kf tinyint(2) default '0',
  kg int(10) default NULL,
  kh int(10) default NULL,
  created int(10) default NULL,
  modified int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_leavewords'
--

DROP TABLE IF EXISTS eos_leavewords;
CREATE TABLE eos_leavewords (
  id int(10) NOT NULL auto_increment,
  primary_id int(10) default NULL,
  member_id int(10) default NULL,
  title varchar(50) default NULL,
  content tinytext,
  type_id tinyint(1) default NULL,
  ip_address varchar(25) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_marketprice'
--

DROP TABLE IF EXISTS eos_marketprice;
CREATE TABLE eos_marketprice (
  id int(10) NOT NULL auto_increment,
  product_id int(10) default NULL,
  units varchar(25) default NULL,
  max_price smallint(6) default NULL,
  min_price smallint(6) default NULL,
  av_price smallint(6) default NULL,
  content tinytext,
  created int(10) default NULL,
  modified int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_markets'
--

DROP TABLE IF EXISTS eos_markets;
CREATE TABLE eos_markets (
  id int(10) NOT NULL auto_increment,
  name varchar(200) binary NOT NULL,
  content text,
  industry_id int(5) default NULL,
  country_id int(5) default NULL,
  province_id int(5) default NULL,
  city_id int(5) default NULL,
  picture varchar(50) default NULL,
  ma tinyint(2) default NULL,
  mb tinyint(1) default NULL,
  mc tinyint(1) default NULL,
  md varchar(25) default NULL,
  status tinyint(1) default '0',
  clicked int(5) default '1',
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_maskwords'
--

DROP TABLE IF EXISTS eos_maskwords;
CREATE TABLE eos_maskwords (
  id smallint(6) NOT NULL auto_increment,
  title varchar(50) default NULL,
  replace_to varchar(50) default NULL,
  created int(10) default NULL,
  modified int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_memberlinks'
--

DROP TABLE IF EXISTS eos_memberlinks;
CREATE TABLE eos_memberlinks (
  id int(11) NOT NULL auto_increment,
  member_id int(11) default NULL,
  company_id int(11) default NULL,
  friend_company_id int(11) default NULL,
  logo varchar(25) default NULL,
  created int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_memberlogs'
--

DROP TABLE IF EXISTS eos_memberlogs;
CREATE TABLE eos_memberlogs (
  id int(11) NOT NULL auto_increment,
  member_id int(11) default NULL,
  type_id tinyint(1) default NULL,
  login_time varchar(11) default NULL,
  login_ip varchar(11) default NULL,
  description tinytext,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_members'
--

DROP TABLE IF EXISTS eos_members;
CREATE TABLE eos_members (
  id int(9) NOT NULL auto_increment,
  country_id int(5) default '0',
  province_code_id char(6) default '0',
  city_code_id char(6) default NULL,
  username varchar(25) default NULL,
  userpass varchar(50) default NULL,
  firstname varchar(25) default NULL,
  lastname varchar(25) default NULL,
  depart varchar(25) default NULL,
  position varchar(25) default '8',
  gender tinyint(1) default '0',
  tel varchar(25) default NULL,
  fax varchar(25) default NULL,
  mobile varchar(25) default NULL,
  qq varchar(12) default NULL,
  msn varchar(50) default NULL,
  icq varchar(12) default NULL,
  yahoo varchar(50) default NULL,
  address varchar(50) default NULL,
  zipcode varchar(16) default NULL,
  email varchar(100) default NULL,
  site_url varchar(100) default NULL,
  last_login varchar(11) default '0',
  today_logins int(5) default '0',
  total_logins int(10) default NULL,
  credit_level tinyint(1) default '0',
  credit_point smallint(6) default NULL,
  rank tinyint(2) default '0',
  status enum('3','2','1','0') default '0',
  user_type tinyint(1) default '1',
  user_level tinyint(2) default '1',
  question varchar(50) default NULL,
  answer varchar(50) default NULL,
  reg_ip varchar(25) default NULL,
  last_ip varchar(25) default NULL,
  created varchar(11) default NULL,
  modified varchar(11) default NULL,
  service_start_date varchar(11) default NULL,
  service_end_date varchar(11) default NULL,
  office_redirect smallint(6) default '0',
  PRIMARY KEY  (id),
  UNIQUE KEY username (username)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_membertypes'
--

DROP TABLE IF EXISTS eos_membertypes;
CREATE TABLE eos_membertypes (
  id tinyint(2) NOT NULL auto_increment,
  access_id tinyint(2) default NULL,
  name varchar(50) default NULL,
  picture varchar(50) default 'default.gif',
  if_default tinyint(1) default NULL,
  if_index tinyint(1) default '0',
  price_every_year varchar(10) default NULL,
  status tinyint(1) default NULL,
  ma text default NULL,
  mb tinyint(1) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_messages'
--

DROP TABLE IF EXISTS eos_messages;
CREATE TABLE eos_messages (
  id int(11) NOT NULL,
  trade_id int(11) default NULL,
  msg_content text,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_newses'
--

DROP TABLE IF EXISTS eos_newses;
CREATE TABLE eos_newses (
  id int(9) NOT NULL auto_increment,
  type_id int(5) default NULL,
  html_file_id varchar(50) default NULL,
  title varchar(50) default NULL,
  content text,
  source varchar(25) default NULL,
  keywords varchar(100) default NULL,
  picture varchar(50) default NULL,
  if_focus tinyint(1) default '0',
  clicked int(11) default '1',
  status tinyint(1) default '1',
  require_membertype varchar(15) default '0',
  created int(11) default NULL,
  modified int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_newstypes'
--

DROP TABLE IF EXISTS eos_newstypes;
CREATE TABLE eos_newstypes (
  id int(5) NOT NULL auto_increment,
  name varchar(25) NOT NULL,
  level_id tinyint(1) default '1',
  if_focus tinyint(1) default '0',
  status tinyint(1) default '1',
  parent_id smallint(3) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_offers'
--

DROP TABLE IF EXISTS eos_offers;
CREATE TABLE eos_offers (
  id int(10) NOT NULL auto_increment,
  trade_id int(10) default NULL,
  country_name varchar(50) default NULL,
  province_name varchar(50) default NULL,
  city_name varchar(50) default NULL,
  address varchar(100) default NULL,
  industry_name varchar(100) default NULL,
  user_name varchar(50) default NULL,
  company_name varchar(100) default NULL,
  link_man varchar(25) default NULL,
  gender tinyint(2) default NULL,
  prim_tel varchar(11) default NULL,
  prim_telnumber varchar(15) default NULL,
  prim_im varchar(11) default NULL,
  prim_imaccount varchar(25) default NULL,
  picture_remote varchar(50) default NULL,
  email varchar(50) default NULL,
  oa text,
  ob text,
  PRIMARY KEY  (id),
  UNIQUE KEY trade_id (trade_id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_orders'
--

DROP TABLE IF EXISTS eos_orders;
CREATE TABLE eos_orders (
  id int(10) NOT NULL auto_increment,
  product_id int(10) default NULL,
  member_id varchar(25) default NULL,
  company_id varchar(25) default NULL,
  year_option tinyint(2) default NULL,
  tel varchar(25) default NULL,
  email varchar(50) default NULL,
  content tinytext,
  status tinyint(1) default '0',
  oa tinyint(1) default NULL,
  ob tinyint(1) default NULL,
  oc tinyint(1) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_params'
--

DROP TABLE IF EXISTS eos_params;
CREATE TABLE eos_params (
  id smallint(6) NOT NULL auto_increment,
  paramtype_id smallint(6) default NULL,
  input_title varchar(50) default NULL,
  input_name varchar(25) default NULL,
  field_type tinyint(1) default NULL,
  input_size smallint(3) default NULL,
  input_maxlength smallint(3) default NULL,
  input_description varchar(50) default NULL,
  use_common tinyint(1) default NULL,
  priority smallint(3) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_paramtypes'
--

DROP TABLE IF EXISTS eos_paramtypes;
CREATE TABLE eos_paramtypes (
  id smallint(6) NOT NULL auto_increment,
  title varchar(25) default NULL,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_pricequotes'
--

DROP TABLE IF EXISTS eos_pricequotes;
CREATE TABLE eos_pricequotes (
  id int(10) NOT NULL auto_increment,
  trade_id int(10) default NULL,
  member_id int(10) default NULL,
  price varchar(5) default NULL,
  content tinytext,
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_products'
--

DROP TABLE IF EXISTS eos_products;
CREATE TABLE eos_products (
  id int(10) NOT NULL auto_increment,
  company_id int(10) default NULL default '0',
  member_id int(10) default NULL,
  industry_id int(5) default NULL,
  sort_id tinyint(1) default '1',
  html_file_id varchar(100) default NULL,
  province_id varchar(5) default NULL,
  city_id varchar(5) default NULL,
  name varchar(50) default NULL,
  sn varchar(20) default NULL,
  spec varchar(20) default NULL,
  produce_area varchar(50) default NULL,
  price varchar(15) default '0',
  packing_content varchar(100) default NULL,
  picture varchar(50) default NULL,
  picture_remote varchar(50) default NULL,
  content tinytext,
  producttype_id int(5) default '0',
  status tinyint(2) default '0',
  state tinyint(2) default '1',
  ifnew tinyint(2) default '0',
  ifcommend tinyint(2) default '0',
  priority tinyint(2) default '0',
  keywords varchar(50) default NULL,
  clicked int(9) default '1',
  created int(11) default NULL,
  modified int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_producttypes'
--

DROP TABLE IF EXISTS eos_producttypes;
CREATE TABLE eos_producttypes (
  id int(11) NOT NULL auto_increment,
  member_id int(11) default NULL,
  company_id int(11) default NULL,
  name varchar(25) default NULL,
  level int(2) default '0',
  created int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_ranks'
--

DROP TABLE IF EXISTS eos_ranks;
CREATE TABLE eos_ranks (
  id int(10) NOT NULL auto_increment,
  from_member_id int(10) default NULL,
  to_member_id int(10) default NULL,
  rank tinyint(2) default '1',
  created int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_roleadminers'
--

DROP TABLE IF EXISTS eos_roleadminers;
CREATE TABLE eos_roleadminers (
  id int(5) NOT NULL auto_increment,
  adminrole_id int(2) default NULL,
  adminer_id int(2) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_roleprivileges'
--

DROP TABLE IF EXISTS eos_roleprivileges;
CREATE TABLE eos_roleprivileges (
  id int(5) NOT NULL auto_increment,
  adminrole_id int(2) default NULL,
  adminprivilege_id int(2) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_services'
--

DROP TABLE IF EXISTS eos_services;
CREATE TABLE eos_services (
  id int(5) NOT NULL auto_increment,
  title varchar(25) default NULL,
  content text,
  nick_name varchar(25) default NULL,
  email varchar(25) default NULL,
  revert_content varchar(200) default NULL,
  adminer_user_name varchar(25) default NULL,
  type_id tinyint(2) default '0',
  status tinyint(2) default '0',
  user_ip varchar(11) default NULL,
  created int(11) default NULL,
  revert_date int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_sessions'
--

DROP TABLE IF EXISTS eos_sessions;
CREATE TABLE eos_sessions (
  id int(11) NOT NULL auto_increment,
  SESSKEY char(32) default NULL,
  EXPIRY int(11) default NULL,
  EXPIREREF char(64) default NULL,
  DATA text default NULL,
  PRIMARY KEY  (id),
  KEY sess2_expiry (EXPIRY),
  KEY sess2_expireref (EXPIREREF)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_settings'
--

DROP TABLE IF EXISTS eos_settings;
CREATE TABLE eos_settings (
  id int(11) NOT NULL auto_increment,
  aa varchar(50) default NULL,
  ab text,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_stats'
--

DROP TABLE IF EXISTS eos_stats;
CREATE TABLE eos_stats (
  id smallint(6) NOT NULL auto_increment,
  sa varchar(25) default NULL,
  sb varchar(50) default NULL,
  description varchar(50) default NULL,
  sc int(10) default NULL,
  sd int(10) default NULL,
  se smallint(6) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_templets'
--

DROP TABLE IF EXISTS eos_templets;
CREATE TABLE eos_templets (
  id int(5) NOT NULL auto_increment,
  title varchar(100) default NULL,
  description varchar(200) default NULL,
  picture varchar(100) default NULL,
  status tinyint(1) default '1',
  created int(11) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_terminologies'
--

DROP TABLE IF EXISTS eos_terminologies;
CREATE TABLE eos_terminologies (
  id int(10) NOT NULL,
  en_name varchar(100) default NULL,
  cn_name varchar(100) default NULL,
  pinyin varchar(100) default NULL,
  alias_name1 varchar(50) default NULL,
  alias_name2 varchar(50) default NULL,
  description tinytext,
  created int(10) default NULL,
  modified int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;

-- --------------------------------------------------------

--
-- Table 'eos_trades'
--

DROP TABLE IF EXISTS eos_trades;
CREATE TABLE eos_trades (
  id int(10) NOT NULL auto_increment,
  industry_id int(5) default '0',
  area_id int(5) default '0',
  member_id int(9) default '0',
  company_id int(5) default NULL,
  product_id int(5) default NULL,
  type_id enum('8','7','6','5','4','3','2','1') default '1',
  province_id int(5) default NULL,
  city_id int(5) default NULL,
  topic varchar(100) default NULL,
  content text,
  packing varchar(150) default NULL,
  price varchar(25) default NULL,
  quantity varchar(25) default NULL,
  offer_expire int(11) default '0',
  spec varchar(200) default NULL,
  sn varchar(25) default NULL,
  picture varchar(50) default NULL,
  keywords varchar(50) default NULL,
  status tinyint(2) default '0',
  submit_time varchar(10) default NULL,
  expire_time varchar(10) default NULL,
  expire_days int(3) default NULL,
  html_file_id varchar(50) default NULL,
  if_urgent enum('0','1') default '0',
  if_locked enum('0','1') default '0',
  require_point smallint(6) default '0',
  require_membertype smallint(6) default '0',
  require_freedate int(10) default NULL,
  ip_addr varchar(18) default NULL,
  clicked int(10) default '1',
  created int(10) default NULL,
  modified int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

--
-- Table 'eos_userpages'
--

DROP TABLE IF EXISTS eos_userpages;
CREATE TABLE eos_userpages (
  id int(5) NOT NULL auto_increment,
  ua varchar(50) default NULL,
  ub varchar(50) default NULL,
  uc text,
  ud tinyint(2) default NULL,
  uf varchar(25) default NULL,
  ug varchar(50) default NULL,
  created int(10) default NULL,
  modified int(10) default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM ;

-- --------------------------------------------------------

DROP TABLE IF EXISTS eos_visitlogs;
CREATE TABLE eos_visitlogs (
  id smallint(6) NOT NULL auto_increment,
  salt varchar(32) default NULL,
  date_line varchar(15) default NULL,
  type_name varchar(15) default NULL,
  PRIMARY KEY  (id),
  KEY salt (salt)
) TYPE=MyISAM;

INSERT INTO eos_industries (`id`, `name`, `parentid`, `buy_amount`, `sell_amount`, `product_amount`, `company_amount`, `ia`, `ib`) VALUES
(1, '֯Ƥ', 0, 0, 0, 0, 489, 1, 0),
(2, 'װ', 0, 0, 0, 0, 0, 1, 0),
(3, 'еҵƷ', 0, 0, 0, 0, 0, 1, 0),
(4, 'ƷƷ', 0, 0, 0, 0, 0, 1, 0),
(5, '', 0, 0, 0, 0, 0, 1, 0),
(6, 'õ', 0, 0, 0, 0, 0, 1, 0),
(7, 'װֽ', 0, 0, 0, 0, 0, 1, 0),
(8, 'ӵ繤', 0, 0, 0, 0, 0, 1, 0),
(9, 'ز', 0, 0, 0, 0, 0, 1, 0),
(10, 'ũҵ', 0, 0, 0, 0, 0, 1, 0),
(11, 'ұ𡢿', 0, 0, 0, 0, 0, 1, 0),
(12, 'ҽҩ', 0, 0, 0, 0, 0, 1, 0),
(13, 'ȫ', 0, 0, 0, 0, 0, 1, 0),
(14, 'Ħ', 0, 0, 0, 0, 0, 1, 0),
(15, 'ӡˢ', 0, 0, 0, 0, 0, 1, 0),
(16, 'ʳƷ', 0, 0, 0, 0, 0, 1, 0),
(17, 'ԡ', 0, 0, 0, 0, 0, 1, 0),
(18, 'ҾƷ', 0, 0, 0, 0, 0, 1, 0),
(19, '칫Ľ̼', 0, 0, 0, 0, 0, 1, 0),
(20, 'Դ', 0, 0, 0, 0, 0, 1, 0),
(21, '', 0, 0, 0, 0, 0, 1, 0),
(22, 'ͨѶƷ', 0, 0, 0, 0, 0, 1, 0),
(23, '˶', 0, 0, 0, 0, 0, 1, 0),
(24, '', 0, 0, 0, 0, 0, 1, 0),
(25, 'ͨ', 0, 0, 0, 0, 0, 1, 0),
(26, '', 0, 0, 0, 0, 0, 1, 0),
(27, 'Ʒ', 0, 0, 0, 0, 0, 1, 0),
(101, '÷֯Ʒ', 1, 1, 2, 3, 4, 1, 1),
(102, 'Ʒ', 1, 0, 0, 0, 0, 1, 1),
(103, '֯Ƥӹ', 1, 0, 0, 0, 0, 1, 0),
(104, '֯', 1, 0, 0, 0, 0, NULL, 1),
(105, '֯', 1, 0, 0, 0, 0, NULL, 1),
(106, '֯Ʒ', 1, 0, 0, 0, 0, NULL, 1),
(107, '֯ƤĿ', 1, 0, 0, 0, 0, NULL, 1),
(108, '֯豸', 1, 0, 0, 0, 0, NULL, 1),
(109, '֯켰ҵò', 1, 0, 0, 0, 0, NULL, 1),
(110, 'ϡ', 1, 0, 0, 0, 0, NULL, 1),
(111, 'ѧά', 1, 0, 0, 0, 0, NULL, 1),
(112, 'ġ֯', 1, 0, 0, 0, 0, NULL, 1),
(113, '֯Ʒ', 1, 0, 0, 0, 0, NULL, 1),
(114, 'ϵ', 1, 0, 0, 0, 0, NULL, 1),
(115, 'ëϵ', 1, 0, 0, 0, 0, NULL, 0),
(116, 'ë', 1, 0, 0, 0, 0, NULL, 0),
(117, 'ϵ', 1, 0, 0, 0, 0, NULL, 0),
(118, '', 1, 0, 0, 0, 0, NULL, 0),
(119, 'Ƥ', 1, 0, 0, 0, 0, NULL, 0),
(120, 'ƤＰƤ', 1, 0, 0, 0, 0, NULL, 0),
(121, 'Ƥӹ豸', 1, 0, 0, 0, 0, NULL, 0),
(122, 'Ƥ', 1, 0, 0, 0, 0, NULL, 0),
(123, '', 1, 0, 0, 0, 0, NULL, 0),
(124, '', 1, 0, 0, 0, 0, NULL, 0),
(125, 'ɫ֯Ⱦӡ', 1, 0, 0, 0, 0, NULL, 0),
(126, 'ɴ', 1, 0, 0, 0, 0, NULL, 0),
(127, 'ƤëƤƤԭϣ', 1, 0, 0, 0, 0, NULL, 0),
(128, '˿ϵ', 1, 0, 0, 0, 0, NULL, 0),
(129, '̺', 1, 0, 0, 0, 0, NULL, 0),
(130, 'Ȼ֯ԭ', 1, 0, 0, 0, 0, NULL, 0),
(131, 'Ƥ', 1, 0, 0, 0, 0, NULL, 0),
(132, '֯', 1, 0, 0, 0, 0, NULL, 0),
(133, 'װ÷֯Ʒ', 1, 0, 0, 0, 0, NULL, 0),
(134, 'װ', 2, 0, 0, 0, 0, 1, 0),
(135, 'ʱƷ', 2, 0, 0, 0, 0, 1, 0),
(136, '', 2, 0, 0, 0, 0, 1, 0),
(137, 'Ůװ', 2, 0, 0, 0, 0, NULL, 0),
(138, 'Ůϵ', 2, 0, 0, 0, 0, NULL, 0),
(139, '', 2, 0, 0, 0, 0, NULL, 0),
(140, 'T', 2, 0, 0, 0, 0, NULL, 0),
(141, '', 2, 0, 0, 0, 0, NULL, 0),
(142, '', 2, 0, 0, 0, 0, NULL, 0),
(143, 'ţзװ', 2, 0, 0, 0, 0, NULL, 0),
(144, 'зװ', 2, 0, 0, 0, 0, NULL, 0),
(145, 'ë', 2, 0, 0, 0, 0, NULL, 0),
(146, '', 2, 0, 0, 0, 0, NULL, 0),
(147, 'ЬЬ', 2, 0, 0, 0, 0, NULL, 0),
(148, '', 2, 0, 0, 0, 0, NULL, 0),
(149, '޷װ', 2, 0, 0, 0, 0, NULL, 0),
(150, 'ϴ豸', 2, 0, 0, 0, 0, NULL, 0),
(151, 'װЬñ', 2, 0, 0, 0, 0, NULL, 0),
(152, '֯װ', 2, 0, 0, 0, 0, NULL, 0),
(153, 'Ӥװ', 2, 0, 0, 0, 0, NULL, 0),
(154, 'п', 2, 0, 0, 0, 0, NULL, 0),
(155, 'Ьӹ豸', 2, 0, 0, 0, 0, NULL, 0),
(156, 'ɴ', 2, 0, 0, 0, 0, NULL, 0),
(157, '¡', 2, 0, 0, 0, 0, NULL, 0),
(158, 'ЬЬ', 2, 0, 0, 0, 0, NULL, 0),
(159, '', 2, 0, 0, 0, 0, NULL, 0),
(160, 'Χͷ', 2, 0, 0, 0, 0, NULL, 0),
(161, 'ͯװ', 2, 0, 0, 0, 0, NULL, 0),
(162, '֯װ', 2, 0, 0, 0, 0, NULL, 0),
(163, 'ñ', 2, 0, 0, 0, 0, NULL, 0),
(164, 'Ьñӹ', 2, 0, 0, 0, 0, NULL, 0),
(165, 'װӹ豸', 2, 0, 0, 0, 0, NULL, 0),
(166, 'Ʒ', 2, 0, 0, 0, 0, NULL, 0),
(167, 'ƷƷװ', 2, 0, 0, 0, 0, NULL, 0),
(168, '˶װ', 2, 0, 0, 0, 0, NULL, 0),
(169, '', 2, 0, 0, 0, 0, NULL, 0),
(170, 'ƤëƤװ', 2, 0, 0, 0, 0, NULL, 0),
(171, '˯¡ԡ', 2, 0, 0, 0, 0, NULL, 0),
(172, 'ë', 2, 0, 0, 0, 0, NULL, 0),
(173, 'װ', 2, 0, 0, 0, 0, NULL, 0),
(174, 'ЬñĿ', 2, 0, 0, 0, 0, NULL, 0),
(175, 'Ʒװ', 2, 0, 0, 0, 0, NULL, 0),
(176, '˿װ', 2, 0, 0, 0, 0, NULL, 0),
(177, 'װ', 2, 0, 0, 0, 0, NULL, 0),
(178, '', 2, 0, 0, 0, 0, NULL, 0),
(179, '¡', 2, 0, 0, 0, 0, NULL, 0),
(180, '', 2, 0, 0, 0, 0, NULL, 0),
(181, 'ҵרûе豸', 3, 0, 0, 0, 0, NULL, 0),
(182, '𹤾', 3, 0, 0, 0, 0, NULL, 0),
(183, 'ü豸', 3, 0, 0, 0, 0, NULL, 0),
(184, 'еӹ', 3, 0, 0, 0, 0, NULL, 0),
(185, 'ӡи豸', 3, 0, 0, 0, 0, 1, 0),
(186, 'ͨ㲿', 3, 0, 0, 0, 0, 1, 0),
(187, 'Ǳ', 3, 0, 0, 0, 0, NULL, 0),
(188, '', 3, 0, 0, 0, 0, NULL, 0),
(189, 'ĥߡĥ', 3, 0, 0, 0, 0, NULL, 0),
(190, 'ģ', 3, 0, 0, 0, 0, NULL, 0),
(191, 'Һѹе', 3, 0, 0, 0, 0, NULL, 0),
(192, '綯', 3, 0, 0, 0, 0, NULL, 0),
(193, 'ȡյ豸', 3, 0, 0, 0, 0, NULL, 0),
(194, 'ѹ豸', 3, 0, 0, 0, 0, NULL, 0),
(195, 'ŷ豸', 3, 0, 0, 0, 0, NULL, 0),
(196, '¯װ', 3, 0, 0, 0, 0, NULL, 0),
(197, '', 3, 0, 0, 0, 0, NULL, 0),
(198, 'ٻٻ', 3, 0, 0, 0, 0, NULL, 0),
(199, 'װ', 3, 0, 0, 0, 0, NULL, 0),
(200, 'еƷ', 3, 0, 0, 0, 0, NULL, 0),
(201, 'еҵƷĿ', 3, 0, 0, 0, 0, NULL, 0),
(202, 'ȼ', 3, 0, 0, 0, 0, NULL, 0),
(203, 'ҵ', 3, 0, 0, 0, 0, NULL, 0),
(204, '', 3, 0, 0, 0, 0, NULL, 0),
(205, 'ʯʯƷ', 4, 0, 0, 0, 0, NULL, 0),
(206, 'Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(207, 'Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(208, '̾', 4, 0, 0, 0, 0, NULL, 0),
(209, '̹Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(210, '', 4, 0, 0, 0, 0, 1, 0),
(211, '¹ŹƷ', 4, 0, 0, 0, 0, 1, 0),
(212, 'Ʒ', 4, 0, 0, 0, 0, 1, 0),
(213, '֯Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(214, 'Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(215, 'ŶղƷ', 4, 0, 0, 0, 0, NULL, 0),
(216, 'Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(217, '졢Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(218, 'Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(219, 'Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(220, '̨', 4, 0, 0, 0, 0, NULL, 0),
(221, 'ƷƷ', 4, 0, 0, 0, 0, NULL, 0),
(222, 'ƷƷĿ', 4, 0, 0, 0, 0, NULL, 0),
(223, 'Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(224, 'ƷƷӹ', 4, 0, 0, 0, 0, NULL, 0),
(225, '乤Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(226, 'ܹƷ', 4, 0, 0, 0, 0, NULL, 0),
(227, '辰', 4, 0, 0, 0, 0, NULL, 0),
(228, 'δ', 4, 0, 0, 0, 0, NULL, 0),
(229, '', 4, 0, 0, 0, 0, NULL, 0),
(230, 'ʯϹƷ', 4, 0, 0, 0, 0, NULL, 0),
(231, 'ʱƷ', 4, 0, 0, 0, 0, NULL, 0),
(232, '֬Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(233, 'ˮƷ', 4, 0, 0, 0, 0, NULL, 0),
(234, 'ϹƷ', 4, 0, 0, 0, 0, NULL, 0),
(235, 'մɹƷ', 4, 0, 0, 0, 0, NULL, 0),
(236, 'ȻƷ', 4, 0, 0, 0, 0, NULL, 0),
(237, '', 4, 0, 0, 0, 0, NULL, 0),
(238, '򡢻', 4, 0, 0, 0, 0, NULL, 0),
(239, 'Ѭ㼰Ѭ¯', 4, 0, 0, 0, 0, NULL, 0),
(240, 'Կ׿ۡ', 4, 0, 0, 0, 0, NULL, 0),
(241, '빳ṤƷ', 4, 0, 0, 0, 0, NULL, 0),
(242, 'ֲ֯Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(243, 'ֽƹƷ', 4, 0, 0, 0, 0, NULL, 0),
(244, 'ӱ', 4, 0, 0, 0, 0, NULL, 0),
(245, '鱦Ρ', 4, 0, 0, 0, 0, NULL, 0),
(246, 'ľƷ', 4, 0, 0, 0, 0, NULL, 0),
(247, 'װκ', 4, 0, 0, 0, 0, NULL, 0),
(248, 'ֻ', 4, 0, 0, 0, 0, NULL, 0),
(249, 'ڽ̹Ʒ', 4, 0, 0, 0, 0, NULL, 0),
(250, '޻ԭ', 5, 0, 0, 0, 0, 0, 0),
(251, 'лԭ', 5, 0, 0, 0, 0, 0, 0),
(252, 'ԭ', 5, 0, 0, 0, 0, 0, 0),
(253, 'ԭ', 5, 0, 0, 0, 0, 0, 0),
(254, '֬', 5, 0, 0, 0, 0, 1, 0),
(255, 'ҽҩԭϡм', 5, 0, 0, 0, 0, 1, 0),
(256, 'ʯͼƷ', 5, 0, 0, 0, 0, 1, 0),
(257, '', 5, 0, 0, 0, 0, 1, 0),
(258, 'ʳƷӼ', 5, 0, 0, 0, 0, 0, 0),
(259, 'Ӽ', 5, 0, 0, 0, 0, 0, 0),
(260, '߻', 5, 0, 0, 0, 0, 0, 0),
(261, 'ѧԼ', 5, 0, 0, 0, 0, 0, 0),
(262, '', 5, 0, 0, 0, 0, 0, 0),
(263, 'ī', 5, 0, 0, 0, 0, 0, 0),
(264, '', 5, 0, 0, 0, 0, 0, 0),
(265, 'ũҩ', 5, 0, 0, 0, 0, 0, 0),
(266, 'ﻯ', 5, 0, 0, 0, 0, 0, 0),
(267, 'մ', 5, 0, 0, 0, 0, 0, 0),
(268, 'ʵƷ', 5, 0, 0, 0, 0, 0, 0),
(269, '𹤲Ʒ', 5, 0, 0, 0, 0, 0, 0),
(270, 'ۺ', 5, 0, 0, 0, 0, 0, 0),
(271, 'Ʒ', 5, 0, 0, 0, 0, 0, 0),
(272, 'Ʒ', 5, 0, 0, 0, 0, 0, 0),
(273, 'ûѧƷ', 5, 0, 0, 0, 0, 0, 0),
(274, '۰֬', 5, 0, 0, 0, 0, 0, 0),
(275, 'ճ', 5, 0, 0, 0, 0, 0, 0),
(276, 'ѧά', 5, 0, 0, 0, 0, 0, 0),
(277, 'Ⱦ', 5, 0, 0, 0, 0, 0, 0),
(278, 'Ϳ', 5, 0, 0, 0, 0, 0, 0),
(279, '', 5, 0, 0, 0, 0, 0, 0),
(280, 'ϡ㾫', 5, 0, 0, 0, 0, 0, 0),
(281, '豸', 5, 0, 0, 0, 0, 0, 0),
(282, 'ӹ豸', 5, 0, 0, 0, 0, 0, 0),
(283, '', 5, 0, 0, 0, 0, 0, 0),
(284, '滯Ʒ', 5, 0, 0, 0, 0, 0, 0),
(285, 'Ʒӹ', 5, 0, 0, 0, 0, 0, 0),
(286, 'Ʒ', 5, 0, 0, 0, 0, 0, 0),
(287, 'Ŀ', 5, 0, 0, 0, 0, 0, 0),
(288, '', 5, 0, 0, 0, 0, 0, 0),
(289, '', 6, 0, 0, 0, 0, 0, 0),
(290, '䡢', 6, 0, 0, 0, 0, 0, 0),
(291, 'ˮ', 6, 0, 0, 0, 0, 0, 0),
(292, 'ȡ', 6, 0, 0, 0, 0, 1, 0),
(293, 'Ⱥȱ', 6, 0, 0, 0, 0, 1, 0),
(294, 'ˮ', 6, 0, 0, 0, 0, 1, 0),
(295, 'ʪȵ', 6, 0, 0, 0, 0, 0, 0),
(296, '', 6, 0, 0, 0, 0, 0, 0),
(297, 'õ', 6, 0, 0, 0, 0, 0, 0),
(298, '', 6, 0, 0, 0, 0, 0, 0),
(299, 'õƷ', 6, 0, 0, 0, 0, 0, 0),
(300, 'ե֭', 6, 0, 0, 0, 0, 0, 0),
(301, '̻', 6, 0, 0, 0, 0, 0, 0),
(302, 'ҵĿ', 6, 0, 0, 0, 0, 0, 0),
(303, '', 6, 0, 0, 0, 0, 0, 0),
(304, 'յ', 6, 0, 0, 0, 0, 0, 0),
(305, 'ȡů', 6, 0, 0, 0, 0, 0, 0),
(306, 'ˮ', 6, 0, 0, 0, 0, 0, 0),
(307, '紶', 6, 0, 0, 0, 0, 0, 0),
(308, 'ң', 6, 0, 0, 0, 0, 0, 0),
(309, '紵', 6, 0, 0, 0, 0, 0, 0),
(310, '', 6, 0, 0, 0, 0, 0, 0),
(311, 'Ȼ', 6, 0, 0, 0, 0, 0, 0),
(312, 'ϴ¡豸', 6, 0, 0, 0, 0, 0, 0),
(313, 'ٶ', 6, 0, 0, 0, 0, 0, 0),
(314, 'ֻҺ', 6, 0, 0, 0, 0, 0, 0),
(315, '', 6, 0, 0, 0, 0, 0, 0),
(316, 'ҵ豸', 6, 0, 0, 0, 0, 0, 0),
(317, '', 6, 0, 0, 0, 0, 0, 0),
(318, '΢¯', 6, 0, 0, 0, 0, 0, 0),
(319, 'õӹ', 6, 0, 0, 0, 0, 0, 0),
(320, 'ϴ', 6, 0, 0, 0, 0, 0, 0),
(321, '', 6, 0, 0, 0, 0, 0, 0),
(322, 'ϰװƷ', 7, 0, 0, 0, 0, 0, 0),
(323, 'ֽưװƷ', 7, 0, 0, 0, 0, 0, 0),
(324, '', 7, 0, 0, 0, 0, 0, 0),
(325, 'װֽ', 7, 0, 0, 0, 0, 0, 0),
(326, 'װƷ', 7, 0, 0, 0, 0, 0, 0),
(327, 'ֽƷ', 7, 0, 0, 0, 0, 0, 0),
(328, 'ľưװƷ', 7, 0, 0, 0, 0, 0, 0),
(329, 'Ļֽ', 7, 0, 0, 0, 0, 0, 0),
(330, 'ֽ', 7, 0, 0, 0, 0, 0, 0),
(331, 'װֽƷӹ', 7, 0, 0, 0, 0, 0, 0),
(332, 'ϲϰװƷ', 7, 0, 0, 0, 0, 1, 0),
(333, 'ֽ', 7, 0, 0, 0, 0, 1, 0),
(334, 'װֽƷ', 7, 0, 0, 0, 0, 0, 0),
(335, 'װ豸', 7, 0, 0, 0, 0, 0, 0),
(336, 'װ', 7, 0, 0, 0, 0, 0, 0),
(337, 'ǩ', 7, 0, 0, 0, 0, 0, 0),
(338, ';ֽ', 7, 0, 0, 0, 0, 0, 0),
(339, 'ֽƷӹе', 7, 0, 0, 0, 0, 0, 0),
(340, '', 7, 0, 0, 0, 0, 0, 0),
(341, 'װƷ', 7, 0, 0, 0, 0, 0, 0),
(342, 'ֽ豸', 7, 0, 0, 0, 0, 0, 0),
(343, 'ֽ', 7, 0, 0, 0, 0, 0, 0),
(344, '', 7, 0, 0, 0, 0, 0, 0),
(345, 'ֽԭ', 7, 0, 0, 0, 0, 0, 0),
(346, 'ưװƷ', 7, 0, 0, 0, 0, 0, 0),
(347, 'װƷֽƷĿ', 7, 0, 0, 0, 0, 0, 0),
(348, '', 7, 0, 0, 0, 0, 0, 0),
(349, 'Ԫ', 8, 0, 0, 0, 0, 0, 0),
(350, 'Ǳ', 8, 0, 0, 0, 1, 0, 0),
(351, 'ߵ', 8, 0, 0, 0, 0, 0, 0),
(352, '綯', 8, 0, 0, 0, 0, 0, 0),
(353, 'ҵԶװ', 8, 0, 0, 0, 0, 0, 0),
(354, '豸', 8, 0, 0, 0, 0, 0, 0),
(355, 'ӵ繤Ʒ豸', 8, 0, 0, 0, 0, 0, 0),
(356, '', 8, 0, 0, 0, 0, 0, 0),
(357, '硢豸', 8, 0, 0, 0, 0, 0, 0),
(358, 'ӵ繤Ʒӹ', 8, 0, 0, 0, 0, 1, 0),
(359, 'ӡ', 8, 0, 0, 0, 0, 1, 0),
(360, '', 8, 0, 0, 0, 0, 0, 0),
(361, 'ӹҵ', 8, 0, 0, 0, 0, 0, 0),
(362, 'Ǽ', 8, 0, 0, 0, 0, 0, 0),
(363, 'ӵ繤Ŀ', 8, 0, 0, 0, 0, 0, 0),
(364, 'ƾ', 8, 0, 0, 0, 0, 0, 0),
(365, '', 8, 0, 0, 0, 0, 0, 0),
(366, '', 8, 0, 0, 0, 0, 0, 0),
(367, 'ͷ', 8, 0, 0, 0, 0, 0, 0),
(368, '綯', 8, 0, 0, 0, 0, 0, 0),
(369, 'Բ', 8, 0, 0, 0, 0, 0, 0),
(370, 'Ե', 8, 0, 0, 0, 0, 0, 0),
(371, 'װáع', 8, 0, 0, 0, 0, 0, 0),
(372, 'صԴ', 8, 0, 0, 0, 0, 0, 0),
(373, 'ӲƷ', 8, 0, 0, 0, 0, 0, 0),
(374, 'ʾ豸', 8, 0, 0, 0, 0, 0, 0),
(375, '뵼', 8, 0, 0, 0, 0, 0, 0),
(376, '繤մɲ', 8, 0, 0, 0, 0, 0, 0),
(377, '豸', 8, 0, 0, 0, 0, 0, 0),
(378, 'ӵ繤Ʒ', 8, 0, 0, 0, 0, 0, 0),
(379, '״Ｐߵ', 8, 0, 0, 0, 0, 0, 0),
(380, '', 8, 0, 0, 0, 0, 0, 0),
(381, 'ԡʩ', 9, 0, 0, 0, 0, 0, 0),
(382, 'ܼܲ', 9, 0, 0, 0, 0, 0, 0),
(383, 'ʯʯ', 9, 0, 0, 0, 0, 0, 0),
(384, 'ľİ', 9, 0, 0, 0, 0, 0, 0),
(385, 'ҵ', 9, 0, 0, 0, 0, 0, 0),
(386, 'մɡ´ɼƷ', 9, 0, 0, 0, 0, 0, 0),
(387, 'ذ', 9, 0, 0, 0, 0, 0, 0),
(388, 'Ե', 9, 0, 0, 0, 0, 0, 0),
(389, 'Ѷ˻е', 9, 0, 0, 0, 0, 0, 0),
(390, 'Ͻ', 9, 0, 0, 0, 0, 0, 0),
(391, 'ˮ', 9, 0, 0, 0, 0, 0, 0),
(392, 'ǽϡ컨', 9, 0, 0, 0, 0, 0, 0),
(393, 'ȡ', 9, 0, 0, 0, 0, 0, 0),
(394, 'ʩ', 9, 0, 0, 0, 0, 1, 0),
(395, 'ש߼', 9, 0, 0, 0, 0, 1, 0),
(396, 'װ', 9, 0, 0, 0, 0, 0, 0),
(397, '', 9, 0, 0, 0, 0, 0, 0),
(398, 'ʯҡʯ', 9, 0, 0, 0, 0, 0, 0),
(399, 'Ʒ', 9, 0, 0, 0, 0, 0, 0),
(400, 'մɡ´ӹе', 9, 0, 0, 0, 0, 0, 0),
(401, 'ļӹ', 9, 0, 0, 0, 0, 0, 0),
(402, 'ֽ', 9, 0, 0, 0, 0, 0, 0),
(403, 'Ϳ', 9, 0, 0, 0, 0, 0, 0),
(404, 'ճ', 9, 0, 0, 0, 0, 0, 0),
(405, '豸', 9, 0, 0, 0, 0, 0, 0),
(406, 'װ', 9, 0, 0, 0, 0, 0, 0),
(407, 'Ŵ', 9, 0, 0, 0, 0, 0, 0),
(408, '', 9, 0, 0, 0, 0, 0, 0),
(409, '', 9, 0, 0, 0, 0, 0, 0),
(410, 'ͻ𡢷', 9, 0, 0, 0, 0, 0, 0),
(411, '', 9, 0, 0, 0, 0, 0, 0),
(412, 'ֽ', 9, 0, 0, 0, 0, 0, 0),
(413, '', 9, 0, 0, 0, 0, 0, 0),
(414, 'ľļӹҾе', 9, 0, 0, 0, 0, 0, 0),
(415, '̳а', 9, 0, 0, 0, 0, 0, 0),
(416, 'ˮ༰Ʒ', 9, 0, 0, 0, 0, 0, 0),
(417, 'ʩ', 9, 0, 0, 0, 0, 0, 0),
(418, 'Ŀ', 9, 0, 0, 0, 0, 0, 0),
(419, 'װνĴ', 9, 0, 0, 0, 0, 0, 0),
(420, 'δ', 9, 0, 0, 0, 0, 0, 0),
(421, 'ֲ', 10, 0, 0, 0, 0, 0, 0),
(422, 'ˮƷ', 10, 0, 0, 0, 0, 0, 0),
(423, 'ҶƷ', 10, 0, 0, 0, 0, 0, 0),
(424, 'ľ', 10, 0, 0, 0, 0, 0, 0),
(425, '԰þ', 10, 0, 0, 0, 0, 0, 0),
(426, 'ֲȡ', 10, 0, 0, 0, 0, 0, 0),
(427, 'ʳþ', 10, 0, 0, 0, 0, 1, 0),
(428, '', 10, 0, 0, 0, 0, 1, 0),
(429, 'Ӽ', 10, 0, 0, 0, 0, 0, 0),
(430, 'ƤëƤƤԭϣ', 10, 0, 0, 0, 0, 0, 0),
(431, 'ֲ', 10, 0, 0, 0, 0, 0, 0),
(432, '', 10, 0, 0, 0, 0, 0, 0),
(433, 'ҵ豸þ', 10, 0, 0, 0, 0, 0, 0),
(434, 'ֳҵ豸þ', 10, 0, 0, 0, 0, 0, 0),
(435, 'ë', 10, 0, 0, 0, 0, 0, 0),
(436, 'ľέɲ', 10, 0, 0, 0, 0, 0, 0),
(437, 'ݵ', 10, 0, 0, 0, 0, 0, 0),
(438, 'ë', 10, 0, 0, 0, 0, 0, 0),
(439, 'ϼ롢˿', 10, 0, 0, 0, 0, 0, 0),
(440, '', 10, 0, 0, 0, 0, 0, 0),
(441, 'ȡ', 10, 0, 0, 0, 0, 0, 0),
(442, '', 10, 0, 0, 0, 0, 0, 0),
(443, '߲˼Ʒ', 10, 0, 0, 0, 0, 0, 0),
(444, 'ʳ', 10, 0, 0, 0, 0, 1, 0),
(445, 'ˮƷ', 10, 0, 0, 0, 0, 0, 0),
(446, 'ũҩ', 10, 0, 0, 0, 0, 0, 0),
(447, '', 10, 0, 0, 0, 0, 0, 0),
(448, 'ũƷũûе', 10, 0, 0, 0, 0, 0, 0),
(449, 'ʡʡ', 10, 0, 0, 0, 0, 0, 0),
(450, 'ũĿ', 10, 0, 0, 0, 0, 0, 0),
(451, '', 10, 0, 0, 0, 0, 0, 0),
(452, 'ľ̿', 10, 0, 0, 0, 0, 0, 0),
(453, 'ȡɿɼƷ', 10, 0, 0, 0, 0, 0, 0),
(454, 'ͼӹе', 10, 0, 0, 0, 0, 0, 0),
(455, 'ֳ', 10, 0, 0, 0, 0, 0, 0),
(456, 'ҵ豸þ', 10, 0, 0, 0, 0, 0, 0),
(457, 'ũƷӹ', 10, 0, 0, 0, 0, 0, 0),
(458, 'ԭޡ顢ë˿ӹ豸', 10, 0, 0, 0, 0, 0, 0),
(459, '׼ӹ豸', 10, 0, 0, 0, 0, 0, 0),
(460, 'ϼӹе', 10, 0, 0, 0, 0, 0, 0),
(461, '', 10, 0, 0, 0, 0, 0, 0),
(462, 'ë', 10, 0, 0, 0, 0, 0, 0),
(463, 'ũƷ', 10, 0, 0, 0, 0, 0, 0),
(464, '̲', 10, 0, 0, 0, 0, 0, 0),
(465, 'δ', 10, 0, 0, 0, 0, 0, 0),
(466, 'Ʒ', 11, 0, 0, 0, 0, 0, 0),
(467, 'ǽ', 11, 0, 0, 0, 0, 0, 0),
(468, 'ͼ', 11, 0, 0, 0, 0, 0, 0),
(469, '', 11, 0, 0, 0, 0, 0, 0),
(470, 'ɫ', 11, 0, 0, 0, 0, 0, 0),
(471, 'Ͻ', 11, 0, 0, 0, 0, 0, 0),
(472, 'ұ豸', 11, 0, 0, 0, 0, 0, 0),
(473, 'ǽƷ', 11, 0, 0, 0, 0, 0, 0),
(474, 'ϽƷ', 11, 0, 0, 0, 0, 0, 0),
(475, 'ɫƷ', 11, 0, 0, 0, 0, 0, 0),
(476, 'ұӹ', 11, 0, 0, 0, 0, 0, 0),
(477, '˿', 11, 0, 0, 0, 0, 0, 0),
(478, 'ɫƷ', 11, 0, 0, 0, 0, 1, 0),
(479, 'ҵ豸', 11, 0, 0, 0, 0, 1, 0),
(480, 'Բ', 11, 0, 0, 0, 0, 0, 0),
(481, 'ĩұ', 11, 0, 0, 0, 0, 0, 0),
(482, 'ʯī̼زƷ', 11, 0, 0, 0, 0, 0, 0),
(483, 'ɫϽ', 11, 0, 0, 0, 0, 0, 0),
(484, 'ߡܡ豸', 11, 0, 0, 0, 0, 0, 0),
(485, 'ɫϽƷ', 11, 0, 0, 0, 0, 0, 0),
(486, 'ϡϡƷ', 11, 0, 0, 0, 0, 0, 0),
(487, 'ұĿ', 11, 0, 0, 0, 0, 0, 0),
(488, '¯ϡۼ', 11, 0, 0, 0, 0, 0, 0),
(489, 'ұ', 11, 0, 0, 0, 0, 0, 0),
(490, 'δ', 11, 0, 0, 0, 0, 0, 0),
(491, 'ҽҩԭϡм', 12, 0, 0, 0, 0, 0, 0),
(492, 'ʳҩƷ', 12, 0, 0, 0, 0, 0, 0),
(493, 'ҩ', 12, 0, 0, 0, 0, 0, 0),
(494, 'ҩ豸', 12, 0, 0, 0, 0, 0, 0),
(495, 'Ʒ', 12, 0, 0, 0, 0, 0, 0),
(496, 'ҽҩƷ', 12, 0, 0, 0, 0, 0, 0),
(497, 'ҩơ', 12, 0, 0, 0, 0, 0, 0),
(498, 'زƷ', 12, 0, 0, 0, 0, 0, 0),
(499, 'гҩ', 12, 0, 0, 0, 0, 0, 0),
(500, '', 12, 0, 0, 0, 0, 0, 0),
(501, 'ѧҩ', 12, 0, 0, 0, 0, 0, 0),
(502, 'ҽ豸', 12, 0, 0, 0, 0, 0, 0),
(503, 'ø()Ƽ', 12, 0, 0, 0, 0, 0, 0),
(504, '˱', 12, 0, 0, 0, 0, 0, 0),
(505, 'ҽò', 12, 0, 0, 0, 0, 1, 0),
(506, 'Ʒ', 12, 0, 0, 0, 0, 1, 0),
(507, '', 12, 0, 0, 0, 0, 0, 0),
(508, 'Ʒ', 12, 0, 0, 0, 0, 0, 0),
(509, 'ҽе', 12, 0, 0, 0, 0, 0, 0),
(510, 'ҽҩĿ', 12, 0, 0, 0, 0, 0, 0),
(511, 'Ʒ', 12, 0, 0, 0, 0, 0, 0),
(512, 'Ʒ', 12, 0, 0, 0, 0, 0, 0),
(513, 'ҽƷ', 12, 0, 0, 0, 0, 0, 0),
(514, 'ҩ', 12, 0, 0, 0, 0, 0, 0),
(515, 'ҩƬ', 12, 0, 0, 0, 0, 0, 0),
(516, 'ҽе豸', 12, 0, 0, 0, 0, 0, 0),
(517, 'ҽҩƷ', 12, 0, 0, 0, 0, 0, 0),
(518, 'ҩƷ', 12, 0, 0, 0, 0, 0, 0),
(519, 'ҽҩƷӹ', 12, 0, 0, 0, 0, 0, 0),
(520, 'δ', 12, 0, 0, 0, 0, 0, 0),
(521, '豸', 13, 0, 0, 0, 0, 0, 0),
(522, '', 13, 0, 0, 0, 0, 0, 0),
(523, 'ͨȫ', 13, 0, 0, 0, 0, 0, 0),
(524, '塢', 13, 0, 0, 0, 0, 0, 0),
(525, '˶', 13, 0, 0, 0, 0, 0, 0),
(526, 'չ', 13, 0, 0, 0, 0, 0, 0),
(527, 'ܿ', 13, 0, 0, 0, 0, 0, 0),
(528, 'ȫƷ', 13, 0, 0, 0, 0, 0, 0),
(529, 'Ʒ', 13, 0, 0, 0, 0, 0, 0),
(530, 'ȫƷĿ', 13, 0, 0, 0, 0, 0, 0),
(531, '', 13, 0, 0, 0, 0, 0, 0),
(532, 'ȫƷӹ', 13, 0, 0, 0, 0, 0, 0),
(533, 'ҵ', 13, 0, 0, 0, 0, 0, 0),
(534, 'װ', 13, 0, 0, 0, 0, 1, 0),
(535, 'ʩ', 13, 0, 0, 0, 0, 1, 0),
(536, '', 13, 0, 0, 0, 0, 0, 0),
(537, 'ײƷ', 13, 0, 0, 0, 0, 0, 0),
(538, 'þ', 13, 0, 0, 0, 0, 0, 0),
(539, '', 13, 0, 0, 0, 0, 0, 0),
(540, '', 13, 0, 0, 0, 0, 0, 0),
(541, 'α', 13, 0, 0, 0, 0, 0, 0),
(542, '', 13, 0, 0, 0, 0, 0, 0),
(543, '', 14, 0, 0, 0, 0, 0, 0),
(544, 'Ħг', 14, 0, 0, 0, 0, 0, 0),
(545, '', 14, 0, 0, 0, 0, 0, 0),
(546, '', 14, 0, 0, 0, 0, 0, 0),
(547, 'ĦƷ豸', 14, 0, 0, 0, 0, 0, 0),
(548, 'ĦزƷ', 14, 0, 0, 0, 0, 0, 0),
(549, 'ͨȫ', 14, 0, 0, 0, 0, 0, 0),
(550, '̥', 14, 0, 0, 0, 0, 0, 0),
(551, 'רó', 14, 0, 0, 0, 0, 0, 0),
(552, 'Ħ', 14, 0, 0, 0, 0, 0, 0),
(553, 'Ħ', 14, 0, 0, 0, 0, 1, 0),
(554, 'ͣվ豸', 14, 0, 0, 0, 0, 1, 0),
(555, 'Ħӹ', 14, 0, 0, 0, 0, 0, 0),
(556, 'δ', 14, 0, 0, 0, 0, 0, 0),
(557, 'ӡˢӡ豸', 15, 0, 0, 0, 0, 0, 0),
(558, '', 15, 0, 0, 0, 0, 0, 0),
(559, 'ӡˢӹ', 15, 0, 0, 0, 0, 0, 0),
(560, 'ӡˢ', 15, 0, 0, 0, 0, 0, 0),
(561, 'ī', 15, 0, 0, 0, 0, 1, 0),
(562, 'ɽƷ', 15, 0, 0, 0, 0, 0, 0),
(563, '', 15, 0, 0, 0, 0, 0, 0),
(564, 'ƷӶ', 15, 0, 0, 0, 0, 0, 0),
(565, '̨ؿ', 15, 0, 0, 0, 0, 0, 0),
(566, 'Ű桢ư豸', 15, 0, 0, 0, 0, 0, 0),
(567, 'α', 15, 0, 0, 0, 0, 1, 0),
(568, 'ýʹ', 15, 0, 0, 0, 0, 1, 0),
(569, 'ӡˢƷ', 15, 0, 0, 0, 0, 0, 0),
(570, 'δ', 15, 0, 0, 0, 0, 0, 0),
(571, 'ʳҩƷ', 16, 0, 0, 0, 0, 0, 0),
(572, 'ʳƷϼӹ豸', 16, 0, 0, 0, 0, 0, 0),
(573, 'ˮƷ', 16, 0, 0, 0, 0, 0, 0),
(574, 'ˮƷ', 16, 0, 0, 0, 0, 0, 0),
(575, 'ʳƷ', 16, 0, 0, 0, 0, 0, 0),
(576, '', 16, 0, 0, 0, 0, 0, 0),
(577, 'ʳƷĿ', 16, 0, 0, 0, 0, 0, 0),
(578, 'ٶʳƷ', 16, 0, 0, 0, 0, 0, 0),
(579, 'ʳƷ', 16, 0, 0, 0, 0, 0, 0),
(580, 'ȡɿɼƷ', 16, 0, 0, 0, 0, 0, 0),
(581, '˿', 16, 0, 0, 0, 0, 0, 0),
(582, 'Ʒ', 16, 0, 0, 0, 0, 0, 0),
(583, 'Ʒ', 16, 0, 0, 0, 0, 0, 0),
(584, 'Ʒ', 16, 0, 0, 0, 0, 0, 0),
(585, 'ʳƷӼ', 16, 0, 0, 0, 0, 1, 0),
(586, 'ζƷ', 16, 0, 0, 0, 0, 1, 0),
(587, 'ҶƷ', 16, 0, 0, 0, 0, 0, 0),
(588, '', 16, 0, 0, 0, 0, 0, 0),
(589, '⼰Ʒ', 16, 0, 0, 0, 0, 0, 0),
(590, 'ʳƷϴ', 16, 0, 0, 0, 0, 0, 0),
(591, 'ͷʳƷ', 16, 0, 0, 0, 0, 0, 0),
(592, 'Ʒ', 16, 0, 0, 0, 0, 0, 0),
(593, '', 16, 0, 0, 0, 0, 0, 0),
(594, 'ʳ', 16, 0, 0, 0, 0, 0, 0),
(595, '', 16, 0, 0, 0, 0, 0, 0),
(596, 'ʳƷϼӹ', 16, 0, 0, 0, 0, 0, 0),
(597, '豸', 16, 0, 0, 0, 0, 0, 0),
(598, '', 16, 0, 0, 0, 0, 0, 0),
(599, 'ʳƷ', 16, 0, 0, 0, 0, 0, 0),
(600, '', 16, 0, 0, 0, 0, 0, 0),
(601, 'δ', 16, 0, 0, 0, 0, 0, 0),
(602, '', 17, 0, 0, 0, 0, 0, 0),
(603, 'Ʒ', 17, 0, 0, 0, 0, 0, 0),
(604, '', 17, 0, 0, 0, 0, 0, 0),
(605, 'ʼǱ', 17, 0, 0, 0, 0, 0, 0),
(606, 'UPSԴ', 17, 0, 0, 0, 0, 1, 0),
(607, '忨', 17, 0, 0, 0, 0, 1, 0),
(608, '', 17, 0, 0, 0, 0, 0, 0),
(609, 'ԲƷ', 17, 0, 0, 0, 0, 0, 0),
(610, 'Ʒ', 17, 0, 0, 0, 0, 0, 0),
(611, '', 17, 0, 0, 0, 0, 0, 0),
(612, '豸', 17, 0, 0, 0, 0, 0, 0),
(613, 'Ʒ', 17, 0, 0, 0, 0, 0, 0),
(614, 'ԡƷ', 17, 0, 0, 0, 0, 0, 0),
(615, 'վ', 17, 0, 0, 0, 0, 0, 0),
(616, '', 17, 0, 0, 0, 0, 0, 0),
(617, 'ϢĿ', 17, 0, 0, 0, 0, 0, 0),
(618, '繤', 17, 0, 0, 0, 0, 0, 0),
(619, '', 17, 0, 0, 0, 0, 0, 0),
(620, 'Ӽ²', 17, 0, 0, 0, 0, 0, 0),
(621, 'ԲƷ豸', 17, 0, 0, 0, 0, 0, 0),
(622, 'Դ', 17, 0, 0, 0, 0, 0, 0),
(623, 'ԲƷӹ', 17, 0, 0, 0, 0, 0, 0),
(624, 'δ', 17, 0, 0, 0, 0, 0, 0),
(625, 'ƾ', 18, 0, 0, 0, 0, 0, 0),
(626, '߳', 18, 0, 0, 0, 0, 0, 0),
(627, 'Ƥ', 18, 0, 0, 0, 0, 0, 0),
(628, 'ԡʩ', 18, 0, 0, 0, 0, 1, 0),
(629, 'Ʒ', 18, 0, 0, 0, 0, 1, 0),
(630, 'ýƷ', 18, 0, 0, 0, 0, 0, 0),
(631, 'װ÷֯Ʒ', 18, 0, 0, 0, 0, 0, 0),
(632, 'þ', 18, 0, 0, 0, 0, 0, 0),
(633, 'ˢ', 18, 0, 0, 0, 0, 0, 0),
(634, 'ɡߡ̫ɡ', 18, 0, 0, 0, 0, 0, 0),
(635, 'ＰƷ', 18, 0, 0, 0, 0, 0, 0),
(636, 'Ѭ㼰Ѭ¯', 18, 0, 0, 0, 0, 0, 0),
(637, 'òƷ', 18, 0, 0, 0, 0, 0, 0),
(638, '塢', 18, 0, 0, 0, 0, 0, 0),
(639, 'Ь׻Ь', 18, 0, 0, 0, 0, 0, 0),
(640, '÷֯Ʒ', 18, 0, 0, 0, 0, 0, 0),
(641, 'ʩ', 18, 0, 0, 0, 0, 0, 0),
(642, 'ҾƷĿ', 18, 0, 0, 0, 0, 0, 0),
(643, 'ú', 18, 0, 0, 0, 0, 0, 0),
(644, 'ұ֯', 18, 0, 0, 0, 0, 0, 0),
(645, 'ûѧƷ', 18, 0, 0, 0, 0, 0, 0),
(646, 'Ҿ', 18, 0, 0, 0, 0, 0, 0),
(647, '˱', 18, 0, 0, 0, 0, 0, 0),
(648, 'Ʒ', 18, 0, 0, 1, 0, 0, 0),
(649, 'ӱ', 18, 0, 0, 0, 0, 0, 0),
(650, ';', 18, 0, 0, 0, 0, 0, 0),
(651, '̾', 18, 0, 0, 0, 0, 0, 0),
(652, '԰þ', 18, 0, 0, 0, 0, 0, 0),
(653, '򡢻', 18, 0, 0, 0, 0, 0, 0),
(654, 'ľƷ', 18, 0, 0, 0, 0, 0, 0),
(655, '', 18, 0, 0, 0, 0, 0, 0),
(656, 'ֽƷ', 18, 0, 0, 0, 0, 0, 0),
(657, 'մɡ´Ʒ', 18, 0, 0, 0, 0, 0, 0),
(658, 'ӤƷ', 18, 0, 0, 0, 0, 0, 0),
(659, 'ҾƷ', 18, 0, 0, 0, 0, 0, 0),
(660, 'ͯ', 18, 0, 0, 0, 0, 0, 0),
(661, 'ʱ', 18, 0, 0, 0, 0, 0, 0),
(662, 'δ', 18, 0, 0, 0, 0, 0, 0),
(663, 'ľ', 19, 0, 0, 0, 0, 0, 0),
(664, '칫Ҿ', 19, 0, 0, 0, 0, 0, 0),
(665, '绰ӵ绰', 19, 0, 0, 0, 0, 0, 0),
(666, 'ʵƷ', 19, 0, 0, 0, 0, 0, 0),
(667, 'ڻ', 19, 0, 0, 0, 0, 0, 0),
(668, '', 19, 0, 0, 0, 0, 0, 0),
(669, 'ѧģ͡þ', 19, 0, 0, 0, 0, 0, 0),
(670, 'ӡ', 19, 0, 0, 0, 0, 0, 0),
(671, 'CD', 19, 0, 0, 0, 0, 0, 0),
(672, '칫ֽ', 19, 0, 0, 0, 0, 0, 0),
(673, '', 19, 0, 0, 0, 0, 1, 0),
(674, 'ֽ', 19, 0, 0, 0, 0, 1, 0),
(675, '칫ĽƷ', 19, 0, 0, 0, 0, 0, 0),
(676, '칫ĽƷ', 19, 0, 0, 0, 0, 0, 0),
(677, '칫ĽĿ', 19, 0, 0, 0, 0, 0, 0),
(678, 'ֻ', 19, 0, 0, 0, 0, 0, 0),
(679, 'ͼɹͼ', 19, 0, 0, 0, 0, 0, 0),
(680, '칫ĽƷӹ', 19, 0, 0, 0, 0, 0, 0),
(681, 'ʴ', 19, 0, 0, 0, 0, 0, 0),
(682, 'ѧ', 19, 0, 0, 0, 0, 0, 0),
(683, '', 19, 0, 0, 0, 0, 0, 0),
(684, 'ӡ', 19, 0, 0, 0, 0, 0, 0),
(685, '', 19, 0, 0, 0, 0, 0, 0),
(686, 'Ĳ', 19, 0, 0, 0, 0, 0, 0),
(687, 'ͶӰ', 19, 0, 0, 0, 0, 0, 0),
(688, 'ѧʩ', 19, 0, 0, 0, 0, 0, 0),
(689, 'Ѷϵͳ', 19, 0, 0, 0, 0, 0, 0),
(690, 'ŵ绰', 19, 0, 0, 0, 0, 0, 0),
(691, 'δ', 19, 0, 0, 0, 0, 0, 0),
(692, 'ʯͼƷ', 20, 0, 0, 0, 0, 0, 0),
(693, '', 20, 0, 0, 0, 0, 0, 0),
(694, '', 20, 0, 0, 0, 0, 0, 0),
(695, 'ҵ豸', 20, 0, 0, 0, 0, 0, 0),
(696, 'úƷ', 20, 0, 0, 0, 0, 0, 0),
(697, 'UPSԴ', 20, 0, 0, 0, 0, 0, 0),
(698, '̫ܼԴ', 20, 0, 0, 0, 0, 0, 0),
(699, 'ʯͼӹ豸', 20, 0, 0, 0, 0, 0, 0),
(700, 'ԴĿ', 20, 0, 0, 0, 0, 0, 0),
(701, 'ԴƷ', 20, 0, 0, 0, 0, 1, 0),
(702, '', 20, 0, 0, 0, 0, 1, 0),
(703, 'Ȼ', 20, 0, 0, 0, 0, 0, 0),
(704, 'ԴƷӹ', 20, 0, 0, 0, 0, 0, 0),
(705, 'ú', 20, 0, 0, 0, 0, 0, 0),
(706, 'δ', 20, 0, 0, 0, 0, 0, 0),
(707, 'ˮʩ', 21, 1, 0, 0, 0, 0, 0),
(708, 'ˮѧƷ', 21, 0, 0, 0, 0, 0, 0),
(709, 'Ͻ', 21, 0, 0, 0, 0, 0, 0),
(710, '', 21, 0, 0, 0, 0, 0, 0),
(711, 'ʩ', 21, 0, 0, 0, 0, 0, 0),
(712, 'ʩ', 21, 0, 0, 0, 0, 0, 0),
(713, 'ֽ', 21, 0, 0, 0, 0, 0, 0),
(714, 'ϻ', 21, 0, 0, 0, 0, 0, 0),
(715, 'Ŀ', 21, 0, 0, 0, 0, 0, 0),
(716, '֯', 21, 0, 0, 0, 0, 0, 0),
(717, 'Ƥ', 21, 0, 0, 0, 0, 0, 0),
(718, '豸', 21, 0, 0, 0, 0, 0, 0),
(719, 'Ʒ', 21, 0, 1, 0, 0, 1, 0),
(720, 'Ʒӹ', 21, 0, 0, 0, 0, 1, 0),
(721, 'δ', 21, 0, 0, 0, 0, 1, 0),
(722, 'ͨŲƷ', 22, 0, 0, 0, 0, 0, 0),
(723, '﮵ء', 22, 0, 0, 0, 0, 0, 0),
(724, 'ͨѶƷ', 22, 0, 0, 0, 0, 0, 0),
(725, '绰ӵ绰', 22, 0, 0, 0, 0, 0, 0),
(726, 'ƶ绰', 22, 0, 0, 0, 0, 0, 0),
(727, 'زƷ', 22, 0, 0, 0, 0, 0, 0),
(728, '', 22, 0, 0, 0, 0, 0, 0),
(729, '硢豸', 22, 0, 0, 0, 0, 0, 0),
(730, 'ͨŵ', 22, 0, 0, 0, 0, 0, 0),
(731, 'ͨѶѶϵͳ', 22, 0, 0, 0, 0, 0, 0),
(732, 'Խ', 22, 0, 0, 0, 0, 0, 0),
(733, '', 22, 0, 0, 0, 0, 1, 0),
(734, '', 22, 0, 0, 0, 0, 1, 0),
(735, 'ſIPIC', 22, 0, 0, 0, 0, 0, 0),
(736, 'ŵ绰', 22, 0, 0, 0, 0, 0, 0),
(737, 'ͨŲƷ', 22, 0, 0, 0, 0, 0, 0),
(738, 'GPSϵͳ', 22, 0, 0, 0, 0, 0, 0),
(739, '', 22, 0, 0, 0, 0, 0, 0),
(740, '', 22, 0, 0, 0, 0, 0, 0),
(741, 'ͨѶƷ豸', 22, 0, 0, 0, 0, 0, 0),
(742, 'ƺ͵豸', 22, 0, 0, 0, 0, 0, 0),
(743, '״Ｐߵ', 22, 0, 0, 0, 0, 0, 0),
(744, 'Ѱ', 22, 0, 0, 0, 0, 0, 0),
(745, 'ֻ', 22, 0, 0, 0, 1, 0, 0),
(746, 'ʾ', 22, 0, 0, 0, 0, 0, 0),
(747, 'ͨѶƷӹ', 22, 0, 0, 0, 0, 0, 0),
(748, 'δ', 22, 0, 0, 0, 0, 0, 0),
(749, 'Ʒ', 23, 0, 0, 0, 0, 0, 0),
(750, '', 23, 0, 0, 0, 0, 0, 0),
(751, 'ʩ', 23, 0, 0, 0, 0, 0, 0),
(752, 'Ʒ', 23, 0, 0, 0, 0, 0, 0),
(753, '', 23, 0, 0, 0, 0, 0, 0),
(754, 'ΡƷ', 23, 0, 0, 0, 0, 0, 0),
(755, 'ＰƷ', 23, 0, 0, 0, 0, 0, 0),
(756, 'ݾƵƷ', 23, 0, 0, 0, 0, 0, 0),
(757, '', 23, 0, 0, 0, 0, 0, 0),
(758, '˶вƷ', 23, 0, 0, 0, 0, 1, 0),
(759, '', 23, 0, 0, 0, 0, 1, 0),
(760, '˿', 23, 0, 0, 0, 0, 0, 0),
(761, '˶Ʒ', 23, 0, 0, 0, 0, 0, 0),
(762, '˶ƷĿ', 23, 0, 0, 0, 0, 0, 0),
(763, '赸Ʒ', 23, 0, 0, 0, 0, 0, 0),
(764, '˶Ʒӹ', 23, 0, 0, 0, 0, 0, 0),
(765, 'δ', 23, 0, 0, 0, 0, 0, 0),
(766, '', 24, 0, 0, 0, 0, 0, 0),
(767, '', 24, 0, 0, 0, 0, 0, 0),
(768, 'ǩ֤', 24, 0, 0, 0, 0, 0, 0),
(769, 'Ƹ', 24, 0, 0, 0, 0, 0, 0),
(770, '̳а', 24, 0, 0, 0, 0, 0, 0),
(771, 'η', 24, 0, 0, 0, 0, 0, 0),
(772, 'Ȩת', 24, 0, 0, 0, 0, 0, 0),
(773, 'Ͷ', 24, 0, 0, 0, 0, 0, 0),
(774, '', 24, 0, 0, 0, 0, 0, 0),
(775, '', 24, 0, 0, 0, 0, 0, 0),
(776, '', 24, 0, 0, 0, 0, 0, 0),
(777, 'רת', 24, 0, 0, 0, 0, 0, 0),
(778, '̱ע', 24, 0, 0, 0, 0, 0, 0),
(779, '', 24, 0, 0, 0, 0, 0, 0),
(780, 'н', 24, 0, 0, 0, 0, 1, 0),
(781, 'Сٻ', 24, 0, 0, 0, 0, 1, 0),
(782, 'Ŀ', 24, 0, 0, 0, 0, 0, 0),
(783, 'չ', 24, 0, 0, 0, 0, 0, 0),
(784, '', 24, 0, 0, 0, 0, 0, 0),
(785, 'ѯ', 24, 0, 0, 0, 0, 0, 0),
(786, '߻', 24, 0, 0, 0, 0, 0, 0),
(787, '˾ע', 24, 0, 0, 0, 0, 0, 0),
(788, 'ѵ', 24, 0, 0, 0, 0, 0, 0),
(789, 'άޡװϴ', 24, 0, 0, 0, 0, 0, 0),
(790, 'Ʊ', 24, 0, 0, 0, 0, 0, 0),
(791, '', 24, 0, 0, 0, 0, 0, 0),
(792, 'ݡ', 24, 1, 0, 0, 0, 0, 0),
(793, '', 24, 1, 0, 0, 0, 0, 0),
(794, '', 24, 0, 0, 0, 0, 0, 0),
(795, 'ҽƷ', 24, 0, 0, 0, 0, 0, 0),
(796, '', 24, 0, 0, 0, 0, 0, 0),
(797, 'ɷ', 24, 0, 0, 0, 0, 0, 0),
(798, 'ޡ䵱', 24, 0, 0, 0, 0, 0, 0),
(799, '', 24, 0, 0, 0, 0, 0, 0),
(800, 'бꡢͶ', 24, 0, 0, 0, 0, 0, 0),
(801, 'δ', 24, 0, 0, 0, 0, 0, 0),
(802, '', 25, 0, 0, 0, 0, 0, 0),
(803, 'ͨȫ', 25, 0, 0, 0, 0, 0, 0),
(804, '̥', 25, 0, 0, 0, 0, 0, 0),
(805, '', 25, 0, 0, 0, 0, 0, 0),
(806, 'ݡ³', 25, 0, 0, 0, 1, 0, 0),
(807, '·豸', 25, 0, 0, 1, 0, 0, 0),
(808, '潻ͨƷþ', 25, 0, 0, 0, 0, 0, 0),
(809, 'ͨƷӹ', 25, 0, 0, 0, 0, 0, 0),
(810, '綯', 25, 0, 0, 0, 0, 0, 0),
(811, 'гֳ', 25, 0, 0, 0, 0, 0, 0),
(812, 'ʩ', 25, 0, 0, 0, 0, 1, 0),
(813, 'ͨƷ', 25, 0, 0, 0, 0, 1, 0),
(814, 'װ', 25, 0, 0, 0, 0, 0, 0),
(815, 'ͨĿ', 25, 0, 0, 0, 0, 0, 0),
(816, '', 25, 0, 0, 0, 0, 0, 0),
(817, 'δ', 25, 1, 0, 0, 0, 0, 0),
(818, 'ͨ..Ʒ', 25, 0, 0, 0, 0, 0, 0),
(819, 'ľ', 26, 0, 0, 0, 0, 0, 0),
(820, '', 26, 0, 0, 0, 0, 0, 0),
(821, '䡢ë', 26, 0, 0, 0, 0, 0, 0),
(822, '', 26, 0, 0, 0, 0, 0, 0),
(823, '綯', 26, 0, 0, 0, 0, 0, 0),
(824, '顢', 26, 0, 0, 0, 0, 0, 0),
(825, '', 26, 0, 0, 0, 0, 0, 0),
(826, '߳', 26, 0, 0, 0, 0, 0, 0),
(827, 'ǹ', 26, 0, 0, 0, 0, 0, 0),
(828, 'ģ', 26, 0, 0, 0, 0, 0, 0),
(829, '', 26, 0, 0, 0, 0, 0, 0),
(830, 'ͯ', 26, 0, 0, 0, 0, 0, 0),
(831, '', 26, 0, 0, 0, 0, 1, 0),
(832, '', 26, 0, 0, 0, 0, 1, 0),
(833, 'ƷƷӹ', 26, 0, 0, 0, 0, 0, 0),
(834, 'ƷƷĿ', 26, 0, 0, 0, 0, 0, 0),
(835, 'Ŀ', 26, 0, 0, 0, 0, 0, 0),
(836, '߼ӹ', 26, 0, 0, 1, 0, 0, 0),
(837, 'ߴ', 26, 0, 0, 0, 0, 0, 0),
(838, 'δ', 26, 0, 0, 0, 0, 0, 0),
(839, '', 27, 0, 0, 0, 0, 0, 0),
(840, '豸ҵƷ', 27, 0, 0, 0, 0, 0, 0),
(841, 'ҾƷ', 27, 0, 0, 0, 0, 0, 0),
(842, '湤ƷƷ', 27, 0, 0, 0, 0, 0, 0),
(843, '', 27, 0, 0, 0, 0, 0, 0),
(844, '˶вƷ', 27, 0, 0, 0, 0, 0, 0),
(845, '滯Ʒ', 27, 0, 0, 0, 0, 0, 0),
(846, '칫ĽƷ', 27, 0, 0, 0, 0, 0, 0),
(847, '氲ȫƷ', 27, 0, 0, 0, 0, 1, 0),
(848, 'ƤＰƷ', 27, 0, 0, 0, 0, 1, 0),
(849, 'ҽҩƷ', 27, 0, 0, 0, 0, 0, 0),
(850, 'Ʒ', 27, 0, 0, 0, 0, 0, 0),
(851, '֯Ʒ', 27, 0, 0, 0, 0, 0, 0),
(852, 'ӲƷ', 27, 0, 0, 0, 0, 0, 0),
(853, 'ЬЬ', 27, 0, 0, 0, 0, 0, 0),
(854, 'õ', 27, 0, 0, 0, 0, 0, 0),
(855, 'ԲƷ', 27, 0, 0, 0, 0, 0, 0),
(856, 'ͨѶƷ', 27, 0, 0, 0, 0, 0, 0),
(857, 'ũƷ', 27, 0, 0, 0, 0, 0, 0),
(858, 'Ħ', 27, 0, 0, 0, 0, 0, 0),
(859, '潨', 27, 0, 0, 0, 0, 0, 0),
(860, 'ұ', 27, 0, 0, 0, 0, 0, 0),
(861, 'ʳƷ', 27, 0, 0, 0, 0, 0, 0),
(862, '潻ͨƷþ', 27, 0, 0, 0, 0, 1, 0),
(863, 'δ', 27, 0, 0, 0, 0, 0, 0);

INSERT INTO eos_areas (`id`, `spelling`, `name`, `code_id`, `brief_name`) VALUES
(1, 'BJ', '', 110000, ''),
(2, 'TJ', '', 120000, ''),
(3, 'HE', 'ӱʡ', 130000, ''),
(4, 'SX', 'ɽʡ', 140000, ''),
(5, 'NM', 'ɹ', 150000, ''),
(6, 'LN', 'ʡ', 210000, ''),
(7, 'JL', 'ʡ', 220000, ''),
(8, 'HL', 'ʡ', 230000, ''),
(9, 'SH', 'Ϻ', 310000, ''),
(10, 'JS', 'ʡ', 320000, ''),
(11, 'ZJ', '㽭ʡ', 330000, ''),
(12, 'AH', 'ʡ', 340000, ''),
(13, 'FJ', 'ʡ', 350000, ''),
(14, 'JX', 'ʡ', 360000, ''),
(15, 'SD', 'ɽʡ', 370000, '³'),
(16, 'HA', 'ʡ', 410000, 'ԥ'),
(17, 'HB', 'ʡ', 420000, ''),
(18, 'HN', 'ʡ', 430000, ''),
(19, 'GD', '㶫ʡ', 440000, ''),
(20, 'GX', '׳', 450000, ''),
(21, 'HI', 'ʡ', 460000, ''),
(22, 'CQ', '', 500000, ''),
(23, 'SC', 'Ĵʡ', 510000, ''),
(24, 'GZ', 'ʡ', 520000, ''),
(25, 'YN', 'ʡ', 530000, ''),
(26, 'XZ', '', 540000, ''),
(27, 'SN', 'ʡ', 610000, ''),
(28, 'GS', 'ʡ', 620000, ''),
(29, 'QH', 'ຣʡ', 630000, ''),
(30, 'NX', 'Ļ', 640000, ''),
(31, 'XJ', '½ά', 650000, ''),
(32, 'TW', '̨ʡ', 710000, '̨'),
(33, 'HK', 'ر', 810000, ''),
(34, 'MO', 'ر', 820000, ''),
(50, NULL, '', 110100, NULL),
(51, NULL, '', 120100, NULL),
(52, NULL, 'ʯׯ', 130101, NULL),
(53, NULL, 'ɽ', 130201, NULL),
(54, NULL, 'ػʵ', 130301, NULL),
(55, NULL, 'żҿ', 130701, NULL),
(56, NULL, 'е', 130801, NULL),
(57, NULL, 'ȷ', 131001, NULL),
(58, NULL, '', 130401, NULL),
(59, NULL, '̨', 130501, NULL),
(60, NULL, '', 130601, NULL),
(61, NULL, '', 130901, NULL),
(62, NULL, 'ˮ', 133001, NULL),
(63, NULL, '̫ԭ', 140101, NULL),
(64, NULL, 'ͬ', 140201, NULL),
(65, NULL, 'Ȫ', 140301, NULL),
(66, NULL, '', 140501, NULL),
(67, NULL, '˷', 140601, NULL),
(68, NULL, '', 142201, NULL),
(69, NULL, 'ʯ', 142331, NULL),
(70, NULL, 'ܴ', 142401, NULL),
(71, NULL, 'ٷ', 142601, NULL),
(72, NULL, '˳', 142701, NULL),
(73, NULL, '', 140401, NULL),
(74, NULL, 'ͺ', 150101, NULL),
(75, NULL, 'ͷ', 150201, NULL),
(76, NULL, 'ں', 150301, NULL),
(77, NULL, '', 152601, NULL),
(78, NULL, 'ʤ', 152701, NULL),
(79, NULL, 'ٺ', 152801, NULL),
(80, NULL, '', 152921, NULL),
(81, NULL, '', 150401, NULL),
(82, NULL, 'ͨ', 152301, NULL),
(83, NULL, 'ֺ', 152502, NULL),
(84, NULL, '', 152101, NULL),
(85, NULL, '', 152201, NULL),
(86, NULL, '', 210101, NULL),
(87, NULL, '', 210201, NULL),
(88, NULL, 'ɽ', 210301, NULL),
(89, NULL, '˳', 210401, NULL),
(90, NULL, 'Ϫ', 210501, NULL),
(91, NULL, '', 210701, NULL),
(92, NULL, 'Ӫ', 210801, NULL),
(93, NULL, '', 210901, NULL),
(94, NULL, '̽', 211101, NULL),
(95, NULL, '', 211201, NULL),
(96, NULL, '', 211301, NULL),
(97, NULL, '', 211401, NULL),
(98, NULL, '', 210601, NULL),
(99, NULL, '', 220101, NULL),
(100, NULL, '', 220201, NULL),
(101, NULL, 'ƽ', 220301, NULL),
(102, NULL, 'Դ', 220401, NULL),
(103, NULL, '뽭', 220601, NULL),
(104, NULL, '׳', 222301, NULL),
(105, NULL, 'Ӽ', 222401, NULL),
(106, NULL, 'ͨ', 220501, NULL),
(107, NULL, '', 230101, NULL),
(108, NULL, '', 230301, NULL),
(109, NULL, '׸', 230401, NULL),
(110, NULL, '˫Ѽɽ', 230501, NULL),
(111, NULL, '', 230701, NULL),
(112, NULL, 'ľ˹', 230801, NULL),
(113, NULL, '̨', 230901, NULL),
(114, NULL, 'ĵ', 231001, NULL),
(115, NULL, '绯', 232301, NULL),
(116, NULL, '', 230201, NULL),
(117, NULL, '', 230601, NULL),
(118, NULL, 'ں', 232601, NULL),
(119, NULL, 'Ӹ', 232700, NULL),
(120, NULL, 'Ϻ', 310100, NULL),
(121, NULL, 'Ͼ', 320101, NULL),
(122, NULL, '', 320201, NULL),
(123, NULL, '', 320301, NULL),
(124, NULL, '', 320401, NULL),
(125, NULL, '', 320501, NULL),
(126, NULL, 'ͨ', 320600, NULL),
(127, NULL, 'Ƹ', 320701, NULL),
(128, NULL, '', 320801, NULL),
(129, NULL, 'γ', 320901, NULL),
(130, NULL, '', 321001, NULL),
(131, NULL, '', 321101, NULL),
(132, NULL, '', 330101, NULL),
(133, NULL, '', 330201, NULL),
(134, NULL, '', 330301, NULL),
(135, NULL, '', 330401, NULL),
(136, NULL, '', 330501, NULL),
(137, NULL, '', 330601, NULL),
(138, NULL, '', 330701, NULL),
(139, NULL, '', 330801, NULL),
(140, NULL, 'ɽ', 330901, NULL),
(141, NULL, 'ˮ', 332501, NULL),
(142, NULL, 'ٺ', 332602, NULL),
(143, NULL, 'Ϸ', 340101, NULL),
(144, NULL, 'ߺ', 340201, NULL),
(145, NULL, '', 340301, NULL),
(146, NULL, '', 340401, NULL),
(147, NULL, 'ɽ', 340501, NULL),
(148, NULL, '', 340601, NULL),
(149, NULL, 'ͭ', 340701, NULL),
(150, NULL, '', 340801, NULL),
(151, NULL, 'ɽ', 341001, NULL),
(152, NULL, '', 342101, NULL),
(153, NULL, '', 342201, NULL),
(154, NULL, '', 342301, NULL),
(155, NULL, '', 342401, NULL),
(156, NULL, '', 342501, NULL),
(157, NULL, '', 342601, NULL),
(158, NULL, '', 342901, NULL),
(159, NULL, '', 350101, NULL),
(160, NULL, '', 350201, NULL),
(161, NULL, '', 350301, NULL),
(162, NULL, '', 350401, NULL),
(163, NULL, 'Ȫ', 350501, NULL),
(164, NULL, '', 350601, NULL),
(165, NULL, 'ƽ', 352101, NULL),
(166, NULL, '', 352201, NULL),
(167, NULL, '', 352601, NULL),
(168, NULL, 'ϲ', 360101, NULL),
(169, NULL, '', 360201, NULL),
(170, NULL, '', 362101, NULL),
(171, NULL, 'Ƽ', 360301, NULL),
(172, NULL, 'Ž', 360401, NULL),
(173, NULL, '', 360501, NULL),
(174, NULL, 'ӥ̶', 360601, NULL),
(175, NULL, '˴', 362201, NULL),
(176, NULL, '', 362301, NULL),
(177, NULL, '', 362401, NULL),
(178, NULL, 'ٴ', 362502, NULL),
(179, NULL, '', 370101, NULL),
(180, NULL, 'ൺ', 370201, NULL),
(181, NULL, 'Ͳ', 370301, NULL),
(182, NULL, 'ׯ', 370401, NULL),
(183, NULL, 'Ӫ', 370501, NULL),
(184, NULL, '̨', 370601, NULL),
(185, NULL, 'Ϋ', 370701, NULL),
(186, NULL, '', 370801, NULL),
(187, NULL, '̩', 370901, NULL),
(188, NULL, '', 371001, NULL),
(189, NULL, '', 371100, NULL),
(190, NULL, '', 372301, NULL),
(191, NULL, '', 372401, NULL),
(192, NULL, 'ĳ', 372501, NULL),
(193, NULL, '', 372801, NULL),
(194, NULL, '', 372901, NULL),
(195, NULL, '֣', 410101, NULL),
(196, NULL, '', 410201, NULL),
(197, NULL, '', 410301, NULL),
(198, NULL, 'ƽɽ', 410401, NULL),
(199, NULL, '', 410501, NULL),
(200, NULL, 'ױ', 410601, NULL),
(201, NULL, '', 410701, NULL),
(202, NULL, '', 410801, NULL),
(203, NULL, '', 410901, NULL),
(204, NULL, '', 411001, NULL),
(205, NULL, '', 411101, NULL),
(206, NULL, 'Ͽ', 411201, NULL),
(207, NULL, '', 412301, NULL),
(208, NULL, 'ܿ', 412701, NULL),
(209, NULL, 'פ', 412801, NULL),
(210, NULL, '', 412901, NULL),
(211, NULL, '', 413001, NULL),
(212, NULL, '人', 420101, NULL),
(213, NULL, 'ʯ', 420201, NULL),
(214, NULL, 'ʮ', 420301, NULL),
(215, NULL, 'ɳ', 420400, NULL),
(216, NULL, '˲', 420501, NULL),
(217, NULL, '差', 420601, NULL),
(218, NULL, '', 420701, NULL),
(219, NULL, '', 420801, NULL),
(220, NULL, '', 422103, NULL),
(221, NULL, 'Т', 422201, NULL),
(222, NULL, '', 422301, NULL),
(223, NULL, '', 422421, NULL),
(224, NULL, 'ʩ', 422801, NULL),
(225, NULL, 'ɳ', 430101, NULL),
(226, NULL, '', 430401, NULL),
(227, NULL, '', 430501, NULL),
(228, NULL, '', 432801, NULL),
(229, NULL, '', 432901, NULL),
(230, NULL, 'ӹ', 430801, NULL),
(231, NULL, '', 433001, NULL),
(232, NULL, '', 433101, NULL),
(233, NULL, '', 430201, NULL),
(234, NULL, '̶', 430301, NULL),
(235, NULL, '', 430601, NULL),
(236, NULL, '', 430701, NULL),
(237, NULL, '', 432301, NULL),
(238, NULL, '¦', 432501, NULL),
(239, NULL, '', 440101, NULL),
(240, NULL, '', 440301, NULL),
(241, NULL, 'β', 441501, NULL),
(242, NULL, '', 441301, NULL),
(243, NULL, 'Դ', 441601, NULL),
(244, NULL, 'ɽ', 440601, NULL),
(245, NULL, 'Զ', 441801, NULL),
(246, NULL, 'ݸ', 441901, NULL),
(247, NULL, '麣', 440401, NULL),
(248, NULL, '', 440701, NULL),
(249, NULL, '', 441201, NULL),
(250, NULL, 'ɽ', 442001, NULL),
(251, NULL, 'տ', 440801, NULL),
(252, NULL, 'ï', 440901, NULL),
(253, NULL, 'ع', 440201, NULL),
(254, NULL, 'ͷ', 440501, NULL),
(255, NULL, '÷', 441401, NULL),
(256, NULL, '', 441701, NULL),
(257, NULL, '', 450101, NULL),
(258, NULL, '', 450401, NULL),
(259, NULL, '', 452501, NULL),
(260, NULL, '', 450301, NULL),
(261, NULL, 'ɫ', 452601, NULL),
(262, NULL, 'ӳ', 452701, NULL),
(263, NULL, '', 452802, NULL),
(264, NULL, '', 450201, NULL),
(265, NULL, '', 450501, NULL),
(266, NULL, '', 460100, NULL),
(267, NULL, '', 460200, NULL),
(268, NULL, 'ɶ', 510101, NULL),
(269, NULL, '', 513321, NULL),
(270, NULL, 'Ű', 513101, NULL),
(271, NULL, '', 513229, NULL),
(272, NULL, 'Թ', 510301, NULL),
(273, NULL, '', 500100, NULL),
(274, NULL, 'ϳ', 512901, NULL),
(275, NULL, '', 510501, NULL),
(276, NULL, '', 510601, NULL),
(277, NULL, '', 510701, NULL),
(278, NULL, '', 510901, NULL),
(279, NULL, 'ڽ', 511001, NULL),
(280, NULL, 'ɽ', 511101, NULL),
(281, NULL, '˱', 512501, NULL),
(282, NULL, 'Ԫ', 510801, NULL),
(283, NULL, '', 513021, NULL),
(284, NULL, '', 513401, NULL),
(285, NULL, '֦', 510401, NULL),
(286, NULL, 'ǭ', 500239, NULL),
(287, NULL, '', 520101, NULL),
(288, NULL, 'ˮ', 520200, NULL),
(289, NULL, 'ͭ', 522201, NULL),
(290, NULL, '˳', 522501, NULL),
(291, NULL, '', 522601, NULL),
(292, NULL, '', 522701, NULL),
(293, NULL, '', 522301, NULL),
(294, NULL, 'Ͻ', 522421, NULL),
(295, NULL, '', 522101, NULL),
(296, NULL, '', 530101, NULL),
(297, NULL, '', 530201, NULL),
(298, NULL, '', 532201, NULL),
(299, NULL, '', 532301, NULL),
(300, NULL, 'Ϫ', 532401, NULL),
(301, NULL, '', 532501, NULL),
(302, NULL, 'ɽ', 532621, NULL),
(303, NULL, '˼é', 532721, NULL),
(304, NULL, 'ͨ', 532101, NULL),
(305, NULL, '', 532821, NULL),
(306, NULL, '', 532901, NULL),
(307, NULL, 'ɽ', 533001, NULL),
(308, NULL, 'º', 533121, NULL),
(309, NULL, '', 533221, NULL),
(310, NULL, 'ˮ', 533321, NULL),
(311, NULL, 'е', 533421, NULL),
(312, NULL, 'ٲ', 533521, NULL),
(313, NULL, '', 540101, NULL),
(314, NULL, '', 542121, NULL),
(315, NULL, '˶', 542221, NULL),
(316, NULL, 'տ', 542301, NULL),
(317, NULL, '', 542421, NULL),
(318, NULL, '', 542523, NULL),
(319, NULL, '֥', 542621, NULL),
(320, NULL, '', 610101, NULL),
(321, NULL, 'ͭ', 610201, NULL),
(322, NULL, '', 610301, NULL),
(323, NULL, '', 610401, NULL),
(324, NULL, 'μ', 612101, NULL),
(325, NULL, '', 612301, NULL),
(326, NULL, '', 612401, NULL),
(327, NULL, '', 612501, NULL),
(328, NULL, 'Ӱ', 612601, NULL),
(329, NULL, '', 612701, NULL),
(330, NULL, '', 620101, NULL),
(331, NULL, '', 620401, NULL),
(332, NULL, '', 620301, NULL),
(333, NULL, 'ˮ', 620501, NULL),
(334, NULL, 'Ҵ', 622201, NULL),
(335, NULL, '', 622301, NULL),
(336, NULL, '', 622421, NULL),
(337, NULL, '', 622624, NULL),
(338, NULL, 'ƽ', 622701, NULL),
(339, NULL, '', 622801, NULL),
(340, NULL, '', 622901, NULL),
(341, NULL, 'ĺ', 623027, NULL),
(342, NULL, '', 620201, NULL),
(343, NULL, 'Ȫ', 622102, NULL),
(344, NULL, '', 630100, NULL),
(345, NULL, 'ƽ', 632121, NULL),
(346, NULL, 'Դ', 632221, NULL),
(347, NULL, 'ͬ', 632321, NULL),
(348, NULL, '', 632521, NULL),
(349, NULL, '', 632621, NULL),
(350, NULL, '', 632721, NULL),
(351, NULL, '', 632802, NULL),
(352, NULL, '', 640101, NULL),
(353, NULL, 'ʯɽ', 640201, NULL),
(354, NULL, '', 642101, NULL),
(355, NULL, 'ԭ', 642221, NULL),
(356, NULL, '³ľ', 650101, NULL),
(357, NULL, '', 650201, NULL),
(358, NULL, '³', 652101, NULL),
(359, NULL, '', 652201, NULL),
(360, NULL, '', 652301, NULL),
(361, NULL, '', 652701, NULL),
(362, NULL, '', 652801, NULL),
(363, NULL, '', 652901, NULL),
(364, NULL, 'ͼʲ', 653001, NULL),
(365, NULL, 'ʲ', 653101, NULL),
(366, NULL, '', 654101, NULL),
(367, NULL, '̨', 710001, NULL),
(368, NULL, '¡', 710002, NULL),
(369, NULL, '̨', 710020, NULL),
(370, NULL, '', 710019, NULL),
(371, NULL, '̨', 710008, NULL),
(372, NULL, '', 211001, NULL),
(373, NULL, '', 653201, NULL),
(374, NULL, '', 542200, NULL),
(375, NULL, 'һ', 542600, NULL),
(376, NULL, '', 820000, NULL),
(377, NULL, '', 810000, NULL);


INSERT INTO eos_membertypes (`id`, `access_id`, `name`, `picture`, `if_default`, `if_index`, `price_every_year`, `status`) VALUES
(1, 1, 'ѻԱ', 'default.gif', 1, 0, '0', 1),
(2, 0, 'óԱ', 'default.gif', 0, 0, '1000', 1),
(3, 0, 'ƻԱ', 'default.gif', 0, 0, '2000', 1),
(4, 0, 'VIPԱ', 'default.gif', 0, 1, '3000', 1),
(5, 0, 'ͨԱ', 'default.gif', 0, 0, '0', 0);

INSERT INTO eos_accesses VALUES ('1', 'ͨȨ', '1', '3', '3', '3', '3', '3', '3', '3', '1', '1', '1', '1', '1', '0', '3', '0', '0', '3', '2', '0');

##ĬϵĹ˾

INSERT INTO eos_companytypes (name,avaliable,picture) VALUES ('Ӧ', 1,''),('ɹ', 1,''),('', 1,''),('', 1,''),('', 1,'');

##ҳλ
INSERT INTO eos_adzones VALUES (2, '1', NULL, 'ҳСͼƬ', '6ͼƬһУҳʾ', 'XXXԪ/', 'index.php', 760, 45, 6, 12, NULL);


INSERT INTO eos_templets (`id`, `title`, `description`, `picture`, `status`) VALUES
(1, 'default', 'ĬϵĻԱҳ', 'default.jpg', 1),
(2, 'blue', 'ɫ', 'blue.jpg', 1),
(3, 'green', 'ɫ', 'green.jpg', 1);

INSERT INTO eos_stats (`id`, `sa`, `sb`, `description`, `sc`, `sd`, `se`) VALUES
(1, 'total', 'buy', '', 1, NULL, NULL),
(2, 'total', 'buy_today', '', 1, NULL, NULL),
(3, 'total', 'sell', 'Ӧ', 1, NULL, NULL),
(4, 'total', 'sell_today', 'չӦ', 1, NULL, NULL),
(5, 'total', 'product', 'Ʒ', 0, NULL, NULL),
(6, 'total', 'product_today', 'Ʒ', 0, NULL, NULL),
(7, 'total', 'company', 'ҵ', 0, NULL, NULL),
(8, 'total', 'company_today', 'ҵ', 0, NULL, NULL),
(9, 'total', 'member', 'Ա', 0, NULL, NULL),
(10, 'total', 'member_today', 'Ա', 0, NULL, NULL);