<?php

function vita_get_url_content($url) {
    if(!function_exists('file_get_contents')) {
        $file_contents = file_get_contents($url);
    } else {
        $ch = curl_init();
		$timeout = 2; 
		curl_setopt ($ch, CURLOPT_URL, $url);
		curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1); 
		curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
		$file_contents = curl_exec($ch);
		curl_close($ch);
    }
	return $file_contents;
}

function get_domain($filename) {
    $sitedomain = $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];  //获取地址
    $sitedomain_arr = explode("/",$sitedomain);
    $sitedomain_num = count($sitedomain_arr);

    for($i=0;$i<$sitedomain_num-1;$i++){
        $siteurl.=$sitedomain_arr[$i]."/";
    }
	if(substr($siteurl,-1)=="/"){
		$siteurl = substr($siteurl,0,strlen($siteurl)-1);					 
	}
	return $siteurl;
}

function get_file_time($filename) {
    $last_updatetime = filemtime($filename); 
    $time_diff = time() - $last_updatetime;
	$time_diff = intval($time_diff);
    return $time_diff;
}

function get_up_time($site_key) {
	$filename = TBK_CACHE."/time.txt";
	if(is_file($filename)){
		$site_time = file_get_contents( TBK_CACHE."/time.txt");
	}else{
		$site_time = 0;
	}
	$site_time = intval($site_time);
    return $site_time;
}

function get_site_key(){
    $sitedomain = base64_encode(get_domain());
	if(!is_dir(TBK_CACHE)){
		@mkdirs(TBK_CACHE);
	}	
	$filename = TBK_CACHE."/".$sitedomain.".txt";
	$is_up = 0;	
	if(!is_file($filename)){    //判断文件是否存在
        $is_up = 1;             //设置更新
	}else{                                          //文件存在
		$get_data = file_get_contents($filename);   //读取site_www
		$time_diff = get_file_time($filename);      //读取文件时间
		$site_time = get_up_time($get_data);        //读取更新时间   
		if($time_diff>=$site_time){                 
			$is_up = 1;			
		}
	}
	if($is_up){
		$get_url=PP_SERVER."/com/tbk_config.php?act=get_site_key&sitehost=".$sitedomain;
		$get_data = vita_get_url_content($get_url);
		file_put_contents($filename,$get_data);
	}    
	if($get_data){
	    get_site_time($get_data);
	}
	return $get_data;
}

function get_site_time($sitekey){
    $get_url=PP_SERVER."/com/tbk_config.php?act=get_site_time&sitehost=".$sitekey;
    $get_data = vita_get_url_content($get_url);	
	if($get_data){
		$filename = TBK_CACHE."/config.php";
		$is_up = 0;
    	if(!is_file($filename)){
        	$is_up = 1; 
		}else{
	    	$time_diff = get_file_time($filename);
			$site_time = get_up_time($sitewww);
			if($time_diff>=$site_time){                 
				$is_up = 1;			
			}
		}		
		if($is_up){	   
	   		get_site_config($sitekey);
		}	
		file_put_contents(TBK_CACHE."/time.txt",$get_data);
	}
	return $get_data;
}

function get_site_config($sitekey){
    $get_url=PP_SERVER."/com/tbk_config.php?act=get_site_config&sitehost=".$sitekey;
    $get_data = vita_get_url_content($get_url);
	$data_php = "<?php\n\n";
	$data_php.= $get_data."\n\n";	
	$data_php.= "?>";
	if(substr($data_php,8,6)!="config"){
		$data_php="";
	}
	
	if(strlen($data_php)>='10'){
		$data_php=iconv("utf-8","utf-8", $data_php);
		file_put_contents(TBK_CACHE."/config.php",$data_php);
	}
}

function get_site_htaccess($sitekey){
    $get_url=PP_SERVER."/com/tbk_config.php?act=get_site_htaccess&sitehost=".$sitekey;
    $get_data = vita_get_url_content($get_url);	
	if(strlen($data_php)>='10'){
		$data_php=iconv("utf-8","utf-8", $data_php);
		file_put_contents(".htaccess",$data_php);
	}
}

function src_to_array($src_array,$src_ex){
    if (is_array($src_array)){	   
        $src_array2 = array();
        foreach ($src_array as $row) {
            $src_array2[] = explode($src_ex, $row);
        }
    }
    return $src_array2;
}

function data_arr($filename,$src_ex,$str_table){
    $new_array = file(TBK_CACHE."/".$filename);
    $new_num = count($new_array);
    for($i=0;$i<$new_num;$i++){
        $new_array2[] = explode($src_ex, $new_array[$i]);
		$str_table_arr = explode(",", $str_table);
		$ii = 0;
		foreach ($str_table_arr as $row) {
            $str_table2 = explode($src_ex, $row);
			$new_arr[$i][$row] = $new_array2[$i][$ii];
			$ii++;
        }
    }
	return $new_arr;
}

function rand_str( $length = 12 ) {
    $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $password = '';
    for ( $i = 0; $i < $length; $i++ ){
    // 这里提供两种字符获取方式
    // 第一种是使用 substr 截取$chars中的任意一位字符；
    // 第二种是取字符数组 $chars 的任意元素
    // $password .= substr($chars, mt_rand(0, strlen($chars) - 1), 1);
        $password .= $chars[ mt_rand(0, strlen($chars) - 1) ];
    }
    return $password;
}


function writeFile($path, $content, $mod='w') {
 if (!file_exists($dirname = dirname($path))) { mkdirs($dirname);}
 $fp = fopen($path, $mod);
 if ($fp) {
  $r = @fwrite($fp, $content);
  fclose($fp);
  return $r;
 }
 return false;
}


function mkdirs($path) {
 if (!is_dir(dirname($path))) { mkdirs(dirname($path)); }
 if(!file_exists($path)) { return @mkdir($path); }
}


function getFileExt($path) {
 return strtolower(trim(substr(strrchr($path, '.'), 1)));
}


function listFile($path) {
 if(is_dir($path)) {
  $handle = @opendir($path);
  while( ($file = @readdir($handle)) !== false) {
   $fileArr[] = array('name'=>$file, 'type'=>(is_dir($path.$file) ? "dir" : "file"), 'size'=>getFileSize(@filesize($path.$file)), 'mtime'=>date("Y-m-d h:i:s",@filemtime($path.$file)));
  }
 } else { return false; }
 return $fileArr;
}


function getFileSize($filesize) {
 if($filesize >= 1073741824) {
  $filesize = round($filesize / 1073741824 * 100) / 100 . ' G';
 } elseif($filesize >= 1048576) {
  $filesize = round($filesize / 1048576 * 100) / 100 . ' M';
 } elseif($filesize >= 1024) {
  $filesize = round($filesize / 1024 * 100) / 100 . ' K';
 } else {
  $filesize = $filesize . ' bytes';
 }
 return $filesize;
}


function checkPath($str) {
 $str = str_replace("\\","/",$str);
 $str = substr($str,-1)=="/" ? $str : $str."/";
 $str = str_replace('//', '/', $str);
 $str = str_replace('http:/', 'http://', $str);
 return $str;
}
?>