<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 文章
class ArticleAction extends CommonAction{
	public function index()
	{
		//列表过滤器，生成查询Map对象
		$map = $this->_search ();
		if(intval($_REQUEST['cate_id'])!=0)
		{
			$cate_ids = D("ArticleCate")->getChildIds(intval($_REQUEST['cate_id']));
			$cate_ids[] = intval($_REQUEST['cate_id']);
			$map['cate_id'] = array("in",$cate_ids);
		}
		else 
		unset($map['cate_id']);
		
		$this->assign("cate_id",$_REQUEST['cate_id']);
		
		if (method_exists ( $this, '_filter' )) {
			$this->_filter ( $map );
		}
		$name=$this->getActionName();
		$model = D ($name);
		if (! empty ( $model )) {
			$this->_list ( $model, $map );
		}
		$this->assign("map",$map);
		$lang_envs = D("LangConf")->findAll();
		$lang_ids = array();
		$dispname_arr = array();
		$lang_names = array();
		foreach($lang_envs as $lang_item)
		{
			$dispname_arr[] = "name_".$lang_item['id'];
			$lang_ids[]=$lang_item['id'];
			$lang_names[] = $lang_item['lang_name'];
		}
		
		$default_lang_id = D("LangConf")->where("lang_name='".C('DEFAULT_LANG')."'")->field("id")->find();
		$default_lang_id = $default_lang_id['id'];  //默认语言的ID
		$select_dispname = "name_".$default_lang_id;
		
		$lang_ids = implode(",",$lang_ids);
		$this->assign("lang_ids",$lang_ids);
		$lang_names = implode(",",$lang_names);
		$this->assign("lang_names",$lang_names);

		$cate_list = D("ArticleCate")-> where("status=1")-> findAll();
		$cate_list = D("ArticleCate")-> toFormatTree($cate_list,$dispname_arr);
		
		$this->assign("select_dispname",$select_dispname);
		$this->assign("default_lang_id",$default_lang_id);
		$this->assign("cate_list",$cate_list);
		
		$this->display ();
		return;
	}
	//增
	public function add()
	{
		$lang_envs = D("LangConf")->findAll();
		$lang_ids = array();
		$dispname_arr = array();
		$lang_names = array();
		foreach($lang_envs as $lang_item)
		{
			$dispname_arr[] = "name_".$lang_item['id'];
			$lang_ids[]=$lang_item['id'];
			$lang_names[] = $lang_item['lang_name'];
		}
		$lang_ids = implode(",",$lang_ids);
		$this->assign("lang_ids",$lang_ids);
		$lang_names = implode(",",$lang_names);
		$this->assign("lang_names",$lang_names);

		$cate_list = D("ArticleCate")-> where("status=1")-> findAll();
		$cate_list = D("ArticleCate")-> toFormatTree($cate_list,$dispname_arr);	
		
		
		$default_lang_id = D("LangConf")->where("lang_name='".C('DEFAULT_LANG')."'")->field("id")->find();
		$default_lang_id = $default_lang_id['id'];  //默认语言的ID
		$select_dispname = "name_".$default_lang_id;
		
		
		$new_sort = D(MODULE_NAME)->where("status=1") -> max("sort") + 1;
		$this->assign('new_sort',$new_sort);
		$this->assign("select_dispname",$select_dispname);
		$this->assign("default_lang_id",$default_lang_id);
		$this->assign("cate_list",$cate_list);
		$this->display();
	}
	
	public function insert()
	{
		$lang_envs = D("LangConf")->findAll();
		$name=$this->getActionName();
		$model = D ($name);
		if (false === $model->create ()) {
			$this->error ( $model->getError () );
		}
		
		$cate_id = intval($_REQUEST['cate_id']);
		$model->type = D("ArticleCate")->where("id=".$cate_id)->getField("type");
		//保存当前数据对象
		$list = $model->add (); 
		if ($list!==false) { //保存成功
			
			//处理预览图
			if($_FILES['preview']['name']!='')
			{
				$tmp_file = $_FILES['attachment'];
				unset($_FILES['attachment']);
				$uplist = $this->uploadFile();
				if($uplist)
				{
				$preview_path = $uplist[0]['recpath'].$uplist[0]['savename'];
				D("Article")->where("id=".$list)->setField("preview",$preview_path);
				unset($_FILES);
				$_FILES['attachment'] = $tmp_file;
				}
			}
			else 
			{
				unset($_FILES['preview']);
			}
			//开始上传相关附件
			//先判断有上传的文件域
			$file_names = $_FILES['attachment']['name'];
			$file_diy_names = $_REQUEST['attachment'];
			foreach($file_names as $row_idx => $file_name)
			{
				if($file_name!="")
				{
					$keys[] = $row_idx;				 //有上传文件时将行号存入集合
				}
				elseif($file_diy_names[$row_idx]!='')
				{
					$diy_keys[]	= $row_idx;			//有自定义地址文件时将行号存入集合
				}
			}		
			$uplist = $this->uploadFile();	
			foreach($uplist as $key=>$attachment_item)
			{
				$attachment_item_data['file_path'] = $attachment_item['recpath'].$attachment_item['savename'];
				foreach($lang_envs as $lang_item)
				{
					$attachment_name_arr = $_REQUEST['attachment_name_'.$lang_item['id']];
					$attachment_item_data['name_'.$lang_item['id']] = $attachment_name_arr[$keys[$key]];
				}
				$attachment_id = D("Attachment")->add($attachment_item_data);
				$attachment_link_data['module'] = "Article";
				$attachment_link_data['rec_id'] = $list;
				$attachment_link_data['attachment_id'] = $attachment_id;
				D("AttachmentLink")->add($attachment_link_data);
			}	
			//开始存储自定义的链接
			foreach($diy_keys as $diy_key)
			{
				$attachment_item_data['file_path'] = $file_diy_names[$diy_key];
				foreach($lang_envs as $lang_item)
				{
					$attachment_name_arr = $_REQUEST['attachment_name_'.$lang_item['id']];
					$attachment_item_data['name_'.$lang_item['id']] = $attachment_name_arr[$diy_key];
				}
				$attachment_id = D("Attachment")->add($attachment_item_data);
				$attachment_link_data['module'] = "Article";
				$attachment_link_data['rec_id'] = $list;
				$attachment_link_data['attachment_id'] = $attachment_id;
				D("AttachmentLink")->add($attachment_link_data);
			}	
			
			$this->saveLog(1,$list);
			$this->assign ( 'jumpUrl', Cookie::get ( '_currentUrl_' ) );
			$this->success (L('ADD_SUCCESS'));
		} else {
			//失败提示
			$this->saveLog(0,$list);
			$this->error (L('ADD_FAILED'));
		}
	}
	
	
	//改
	public function edit()
	{		
		$name=$this->getActionName();
		$model = M ( $name );
		$id = $_REQUEST [$model->getPk ()];
		$vo = $model->getById ( $id );
		$this->assign ( 'vo', $vo );

		
		$lang_envs = D("LangConf")->findAll();
		$lang_ids = array();
		$dispname_arr = array();
		$lang_names = array();
		foreach($lang_envs as $lang_item)
		{
			$dispname_arr[] = "name_".$lang_item['id'];
			$lang_ids[]=$lang_item['id'];
			$lang_names[] = $lang_item['lang_name'];
		}
		$lang_ids = implode(",",$lang_ids);
		$this->assign("lang_ids",$lang_ids);
		$lang_names = implode(",",$lang_names);
		$this->assign("lang_names",$lang_names);

		$cate_list = D("ArticleCate")-> where("status=1")-> findAll();
		$cate_list = D("ArticleCate")-> toFormatTree($cate_list,$dispname_arr);	

		
		$default_lang_id = D("LangConf")->where("lang_name='".C('DEFAULT_LANG')."'")->field("id")->find();
		$default_lang_id = $default_lang_id['id'];  //默认语言的ID
		$select_dispname = "name_".$default_lang_id;
		

		$this->assign("select_dispname",$select_dispname);
		$this->assign("default_lang_id",$default_lang_id);
		$this->assign("cate_list",$cate_list);
		
		//开始输出相关附件
		
		$attachment_ids_arr = D("AttachmentLink")->where("module='Article' and rec_id=".$id)->findAll();
		if($attachment_ids_arr)
		{
			foreach ($attachment_ids_arr as $attachment_ids_item)
			{
				$attachment_ids[] = $attachment_ids_item['attachment_id'];
			}
		}
		else 
		{
			$attachment_ids[] = 0;
		}
		$attachment_ids = implode(",",$attachment_ids);
		$uploadList = D("Attachment")->where("id in(".$attachment_ids.")")->findAll();
		foreach($uploadList as $k=>$item)
		{
			foreach ($lang_envs as $lang_item)
			{
				$uploadList[$k]['names'][] = array('key'=>'attachment_name_'.$lang_item['id'].'[]','value'=>$item['name_'.$lang_item['id']],'lang_name'=>$lang_item['lang_name']);
			}
			$uploadList[$k]['is_ref'] = strtolower(substr($item['file_path'],0,7))=="http://"?'1':'0';
		}
		$this->assign("upload_list",$uploadList);
		$this->display();
	}
	
	public function update()
	{
		$lang_envs = D("LangConf")->findAll();
		$name=$this->getActionName();
		$model = D ( $name );
		if (false === $model->create ()) {
			$this->error ( $model->getError () );
		}
		$cate_id = intval($_REQUEST['cate_id']);
		$model->type = D("ArticleCate")->where("id=".$cate_id)->getField("type");
		// 更新数据
			// 更新数据
		$list=$model->save ();
		if (false !== $list) {
			//成功提示
			//处理预览图

			if($_FILES['preview']['name']!='')
			{
				$a_info = D("Article")->getById(intval($_REQUEST['id']));
				$tmp_file = $_FILES['attachment'];
				unset($_FILES['attachment']);
				$uplist = $this->uploadFile();
				if($uplist)
				{
					@unlink($this->getRealPath().$a_info['preview']);
					$preview_path = $uplist[0]['recpath'].$uplist[0]['savename'];
					D("Article")->where("id=".intval($_REQUEST['id']))->setField("preview",$preview_path);
					unset($_FILES);
					$_FILES['attachment'] = $tmp_file;
				}
			}
			else 
			{
				unset($_FILES['preview']);
			}
			
			//开始上传相关附件
			//先判断有上传的文件域
			$file_names = $_FILES['attachment']['name'];
			$file_diy_names = $_REQUEST['attachment'];
			foreach($file_names as $row_idx => $file_name)
			{
				if($file_name!="")
				{
					$keys[] = $row_idx;				
				}
				elseif($file_diy_names[$row_idx]!='')
				{
					$diy_keys[]	= $row_idx;			//有自定义地址文件时将行号存入集合
				}
			}
			$article_id = $_REQUEST['id'];
			$uplist = $this->uploadFile();	

			foreach($uplist as $key=>$attachment_item)
			{
				$attachment_item_data['file_path'] = $attachment_item['recpath'].$attachment_item['savename'];
				foreach($lang_envs as $lang_item)
				{
					$attachment_name_arr = $_REQUEST['attachment_name_'.$lang_item['id']];
					$attachment_item_data['name_'.$lang_item['id']] = $attachment_name_arr[$keys[$key]];
				}
				$attachment_id = D("Attachment")->add($attachment_item_data);
				$attachment_link_data['module'] = "Article";
				$attachment_link_data['rec_id'] = $article_id;
				$attachment_link_data['attachment_id'] = $attachment_id;
				D("AttachmentLink")->add($attachment_link_data);
			}	
			
			//开始存储自定义的链接
			foreach($diy_keys as $diy_key)
			{
				$attachment_item_data['file_path'] = $file_diy_names[$diy_key];
				foreach($lang_envs as $lang_item)
				{
					$attachment_name_arr = $_REQUEST['attachment_name_'.$lang_item['id']];
					$attachment_item_data['name_'.$lang_item['id']] = $attachment_name_arr[$diy_key];
				}
				$attachment_id = D("Attachment")->add($attachment_item_data);
				$attachment_link_data['module'] = "Article";
				$attachment_link_data['rec_id'] = $article_id;
				$attachment_link_data['attachment_id'] = $attachment_id;
				D("AttachmentLink")->add($attachment_link_data);
			}	

			//开始更新已有的附件名称
			$uploadids = $_REQUEST['uploadids'];
			foreach($uploadids as $row => $uploadid)
			{
				$data['id'] = $uploadid;
				foreach($lang_envs as $lang_item)
				{
					$name_arr = $_REQUEST['attachment_name_'.$lang_item['id']];
					$data['name_'.$lang_item['id']] = $name_arr[$row];
				}
				D("Attachment")->save($data);
			}
			$this->saveLog(1);
			$this->assign ( 'jumpUrl', Cookie::get ( '_currentUrl_' ) );
			$this->success (L('EDIT_SUCCESS'));
		} else {
			//错误提示
			$this->saveLog(0);
			$this->error (L('EDIT_FAILED'));
		}
		
	}
	
	public function delAttachment()
	{
		$attachment_id = intval($_REQUEST['attachment_id']);
		$article_id = intval($_REQUEST['article_id']);
		$attahcment_item = D("Attachment")->getById($attachment_id);
		if($rs = D("Attachment")->where("id=".$attachment_id)->delete())
		{
			@unlink($this->getRealPath().$attahcment_item['file_path']);
			D("AttachmentLink")->where("module='Article' and rec_id=".$article_id." and attachment_id=".$attachment_id)->delete();
			echo $rs;
		}
		else
		{
			echo 0;
		}
	}
	
	
	public function foreverdelete() {
		//删除指定记录
		$name=$this->getActionName();
		$model = D ($name);
		if (! empty ( $model )) {
			$pk = $model->getPk ();
			$id = $_REQUEST [$pk];
			if (isset ( $id )) {
				$condition = array ($pk => array ('in', explode ( ',', $id ) ) );
				if (false !== $model->where ( $condition )->delete ()) {
					//echo $model->getlastsql();
					//开始删除相关的附件
					$attachment_ids = D("AttachmentLink")->where("module='Article' and rec_id=".$id)->findAll();
					D("AttachmentLink")->where("module='Article' and rec_id=".$id)->delete();
					if($attachment_ids)
					{
						foreach($attachment_ids as $ids)
						{
							$attachment_ids_arr[] = $ids['attachment_id'];
						}
					}
					else 
					{
						$attachment_ids_arr[] = 0;
					}
					$attachment_arr = D("Attachment")->where("id in(".implode(',',$attachment_ids_arr).")")->findAll();
					D("Attachment")->where("id in(".implode(',',$attachment_ids_arr).")")->delete();
					foreach($attachment_arr as $attach_item)
					{
						@unlink($this->getRealPath().$attach_item['file_path']);
					}
					
					//开始删除相关的留言
					$msgList = D("Message")->where(array ("rec_id" => array ('in', explode ( ',', $id ) ),'rec_module'=>'Article' ))->findAll();
					D("Message")->where(array ("rec_id" => array ('in', explode ( ',', $id ) ),'rec_module'=>'Article' ))->delete();
					foreach($msgList as $msgItem)
					{
						D("Message")->where("pid=".$msgItem['id'])->delete();
					}
					
					$this->saveLog(1);
					$this->success (L('DEL_SUCCESS'));
				} else {
					$this->saveLog(0);
					$this->error (L('DEL_FAILED'));
				}
			} else {
				$this->saveLog(0);
				$this->error ( L('INVALID_OP') );
			}
		}
	}
	
	public function deletePreview()
	{
		$article_id = intval($_REQUEST['id']);
		$a_info = D("Article")->getById($article_id);
		if($a_info['preview']!="")
		{
			@unlink($this->getRealPath().$a_info['preview']);
			D("Article")->where("id=".$article_id)->setField("preview","");
		}
		
		$this->success (L('DEL_SUCCESS'));
	}
	
	//移动文章至分类
	public function moveArticle()
	{
		$name=$this->getActionName();
			$model = M ($name);
			if (! empty ( $model )) {
				$pk = $model->getPk ();
				$id = $_REQUEST [$pk];
				$cate_id = $_REQUEST['cate_id'];
				$cate_info = D("ArticleCate")->getById($cate_id);
				if (isset ( $id )) {
					$condition = array ($pk => array ('in', explode ( ',', $id ) ) );
					$list=$model->where ( $condition )->setField ( 'cate_id', $cate_id );
					$list=$model->where ( $condition )->setField ( 'type', $cate_info['type'] );
					if ($list!==false) {
						$this->saveLog(1);
						$this->success ( L('MOVE_SUCCESS') );
					} else {
						$this->saveLog(0);
						$this->error (L('MOVE_FAILED'));
					}
				} else {
					$this->saveLog(0);
					$this->error ( L('INVALID_OP') );
				}
			}
		$this->forward ();
	}
}
?>