<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 商品
class GoodsAction extends CommonAction{
	//查询
	public function search() {
		//列表过滤器，生成查询Map对象
		$map = $this->_search ();
		$map['status'] = 1;
		if(intval($_REQUEST['cate_id'])!=0)
		{
			$cate_ids = D("GoodsCate")->getChildIds(intval($_REQUEST['cate_id']));
			$cate_ids[] = intval($_REQUEST['cate_id']);
			$map['cate_id'] = array("in",$cate_ids);
		}
		else 
		unset($map['cate_id']);
		
		$this->assign("cate_id",$_REQUEST['cate_id']);
		
		if (method_exists ( $this, '_filter' )) {
			$this->_filter ( $map );
		}
		$name=$this->getActionName();
		$model = D ($name);
		if (! empty ( $model )) {
			$this->_list ( $model, $map );
		}
		$this->assign("map",$map);
		$lang_envs = D("LangConf")->findAll();
		$lang_ids = array();
		$dispname_arr = array();
		$lang_names = array();
		foreach($lang_envs as $lang_item)
		{
			$dispname_arr[] = "name_".$lang_item['id'];
			$lang_ids[]=$lang_item['id'];
			$lang_names[] = $lang_item['lang_name'];
		}
		
		$default_lang_id = D("LangConf")->where("lang_name='".C('DEFAULT_LANG')."'")->field("id")->find();
		$default_lang_id = $default_lang_id['id'];  //默认语言的ID
		$select_dispname = "name_".$default_lang_id;
		
		$lang_ids = implode(",",$lang_ids);
		$this->assign("lang_ids",$lang_ids);
		$lang_names = implode(",",$lang_names);
		$this->assign("lang_names",$lang_names);

		$cate_list = D("GoodsCate")-> where("status=1")-> findAll();
		$cate_list = D("GoodsCate")-> toFormatTree($cate_list,$dispname_arr);
		
		$this->assign("select_dispname",$select_dispname);
		$this->assign("default_lang_id",$default_lang_id);
		$this->assign("cate_list",$cate_list);
		
		$this->display ("Goods:search");
		return;
	}		
	//列表
	public function index() {
		//列表过滤器，生成查询Map对象
		$map = $this->_search ();
		$map['status'] = 1;
		if(intval($_REQUEST['cate_id'])!=0)
		{
			$cate_ids = D("GoodsCate")->getChildIds(intval($_REQUEST['cate_id']));
			$cate_ids[] = intval($_REQUEST['cate_id']);
			$map['cate_id'] = array("in",$cate_ids);
		}
		else 
		unset($map['cate_id']);
		
		$this->assign("cate_id",$_REQUEST['cate_id']);
		
		if (method_exists ( $this, '_filter' )) {
			$this->_filter ( $map );
		}
		$name=$this->getActionName();
		$model = D ($name);
		if (! empty ( $model )) {
			$this->_list ( $model, $map );
		}
		$this->assign("map",$map);
		$lang_envs = D("LangConf")->findAll();
		$lang_ids = array();
		$dispname_arr = array();
		$lang_names = array();
		foreach($lang_envs as $lang_item)
		{
			$dispname_arr[] = "name_".$lang_item['id'];
			$lang_ids[]=$lang_item['id'];
			$lang_names[] = $lang_item['lang_name'];
		}
		
		$default_lang_id = D("LangConf")->where("lang_name='".C('DEFAULT_LANG')."'")->field("id")->find();
		$default_lang_id = $default_lang_id['id'];  //默认语言的ID
		$select_dispname = "name_".$default_lang_id;
		
		$lang_ids = implode(",",$lang_ids);
		$this->assign("lang_ids",$lang_ids);
		$lang_names = implode(",",$lang_names);
		$this->assign("lang_names",$lang_names);

		$cate_list = D("GoodsCate")-> where("status=1")-> findAll();
		$cate_list = D("GoodsCate")-> toFormatTree($cate_list,$dispname_arr);
		
		$this->assign("select_dispname",$select_dispname);
		$this->assign("default_lang_id",$default_lang_id);
		$this->assign("cate_list",$cate_list);
		
		$this->display ();
		return;
	}	
	//回收站列表
	public function trash() {
		//列表过滤器，生成查询Map对象
		$map = $this->_search ();
		$map['status'] = -1;
		if (method_exists ( $this, '_filter' )) {
			$this->_filter ( $map );
		}
		$name=$this->getActionName();
		$model = D ($name);
		if (! empty ( $model )) {
			$this->_list ( $model, $map );
		}
		
		$this->display ();
		return;
	}
	//增
	public function add()
	{
		$spec_list = D("GoodsSpec")->where("session_id='".Session::id()."' and goods_id=0")->findAll();
			foreach($spec_list as $spec_item)
			{
				if(D("Spec")->where("img='".$spec_item['img']."'")->count()==0)
				{
					@unlink($this->getRealPath().$spec_item['img']);
				}
			}
			D("GoodsSpec")->where("session_id='".Session::id()."' and goods_id=0")->delete();
			
			
		$lang_envs = D("LangConf")->findAll();
		$lang_ids = array();
		$dispname_arr = array();
		$lang_names = array();
		foreach($lang_envs as $lang_item)
		{
			$dispname_arr[] = "name_".$lang_item['id'];
			$lang_ids[]=$lang_item['id'];
			$lang_names[] = $lang_item['lang_name'];
		}
		$lang_ids = implode(",",$lang_ids);
		$this->assign("lang_ids",$lang_ids);
		$lang_names = implode(",",$lang_names);
		$this->assign("lang_names",$lang_names);

		$cate_list = D("GoodsCate")-> where("status=1")-> findAll();
		$cate_list = D("GoodsCate")-> toFormatTree($cate_list,$dispname_arr);	
		
		$type_list = D("GoodsType")->findAll();
		
		$brand_list = D("Brand")->findAll();
		
		$default_lang_id = D("LangConf")->where("lang_name='".C('DEFAULT_LANG')."'")->field("id")->find();
		$default_lang_id = $default_lang_id['id'];  //默认语言的ID
		$select_dispname = "name_".$default_lang_id;
		
		
		$new_sort = D(MODULE_NAME)->where("status=1") -> max("sort") + 1;
		
		//输出重量单位
		$weight_list = D("Weight")->findAll();
		foreach($weight_list as $kk=>$vv)
		{
			$weight_list[$kk]['name'] = $vv['name_'.$default_lang_id];
		}
		$this->assign('weight_list',$weight_list);
		
		//会员等级列表
		$user_group = D("UserGroup")->where("status=1")->findAll();
		$lang_curr_id = D("LangConf")->where("lang_name='".FANWE_LANG_SET."'")->getField("id");
		foreach($user_group as $k=>$v)
		{
			$user_group[$k]['name'] = $v['name_'.$lang_curr_id];
		}
		
		
		//输出规格类型
		$spec_type_list = D("SpecType")->findAll();
		foreach($spec_type_list as $k=>$type_item)
		{
			$spec_type_list[$k]['name'] = $type_item['name_'.DEFAULT_LANG_ID];
		}
		$this->assign("spec_type_list",$spec_type_list);
		
		$this->assign("user_group",$user_group);
		$this->assign('new_sort',$new_sort);
		$this->assign("select_dispname",$select_dispname);
		$this->assign("default_lang_id",$default_lang_id);
		$this->assign("cate_list",$cate_list);
		$this->assign("type_list",$type_list);
		$this->assign("brand_list",$brand_list);
		$this->assign("goods_id",0);
		$this->assign("session_id",$_SESSION['verify']);
		$this->display();
	}
	
	public function insert()
	{
		
		//开始检测货号
		if(D("Goods")->where("sn='".$_POST['sn']."'")->count()>0||D("GoodsSpecItem")->where("sn='".$_POST['sn']."'")->count()>0)
		{
			$this->error(L("GOODS_SN_EXIST"));
		}
		$_POST['weight'] = toBaseWeight($_POST['weight'],$_POST['weight_unit']);  //转换重量
		$name=$this->getActionName();
		$model = D ($name);
		if (false === $model->create ()) {
			$this->error ( $model->getError () );
		}
		//保存当前数据对象
		$goods_id = $model->add (); 
		
		if($goods_id)
		{
			//会员等级价
			$user_group_price = $_REQUEST['user_group_price'];
			foreach($user_group_price as $k=>$group_price)
			{
				if($group_price>0)
				{
					$group_price_item['goods_id'] = $goods_id;
					$group_price_item['user_group_id'] = $k;
					$group_price_item['user_price'] = floatval($group_price);
					D("UserGroupPrice")->add($group_price_item);
				}
			}
			//开始处理图库与属性
			//属性
			$attr_value = $_REQUEST['attr_value'];
			$attr_price = $_REQUEST['attr_price'];
			$attr_stock = $_REQUEST['attr_stock'];
				
		   if($attr_value)
			{
				foreach($attr_value as $attr_id=>$attr_list)
				{
					$attr_item = array();
					foreach($attr_list as $lang_id=>$val_list)
					{
						foreach($val_list as $row_idx=>$val)
						{
							$attr_item[$row_idx]['attr_id'] = $attr_id;
							$attr_item[$row_idx]['goods_id'] = $goods_id;
							$attr_item[$row_idx]['attr_value_'.$lang_id] = $val;
							$attr_item[$row_idx]['price'] = floatval($attr_price[$attr_id][$row_idx]);
							$attr_item[$row_idx]['stock'] = intval($attr_stock[$attr_id][$row_idx]);
						}
					}					
					foreach ($attr_item as $val_item)
					{
						D("GoodsAttr")->add($val_item);
					}
				}
			}
			
			
			//图库
			$defalut_gallery_id = $_REQUEST['gallery_id'];
			if($_REQUEST['goods_gallerys'])
			{
				$goods_gallery = $_REQUEST['goods_gallerys'];
				foreach($goods_gallery as $gallery_id)
				{
					$gallery_item = D("GoodsGallery")->getById($gallery_id);
					$gallery_item['goods_id'] = $goods_id;
					if($gallery_item['id']==$defalut_gallery_id)
					{
						$gallery_item['is_default'] = 1;
					}
					D("GoodsGallery")->save($gallery_item);					
				}
			}

			
			//商品默认图片
			$goods_info = D("Goods")->getById($goods_id);
			$goods_img_info = D("GoodsGallery")->getById($defalut_gallery_id);
			$goods_info['origin_img'] = $goods_img_info['origin_img'];
			$goods_info['big_img'] = $goods_img_info['big_img'];
			$goods_info['small_img'] = $goods_img_info['small_img'];
			D("Goods")->save($goods_info);
			
			
			//规格

			//查询会员等级
			$user_group = D("UserGroup")->findAll();
			$spec_item_id = $_REQUEST['spec_item_id'];  //提交的规格
			$spec_item_sn = $_REQUEST['spec_item_sn'];  //规格货号
			$spec_item_weight = $_REQUEST['spec_item_weight'];  //规格重量
			$spec_item_stock = $_REQUEST['spec_item_stock'];  //规格库存
			$spec_item_shop_price = $_REQUEST['spec_item_shop_price'];  //商城价
			$spec_item_cost_price = $_REQUEST['spec_item_cost_price'];  //成本价
			$spec_type1_value_id = $_REQUEST['spec_type1_value_id'];   //规格一
			$spec_type2_value_id = $_REQUEST['spec_type2_value_id'];   //规格二
			
			if($spec_item_id)
			{
				$total_stock = 0;
				$insert_spec_list = $_REQUEST['insert_to_spec'];	
				$lang_envs = D("LangConf")->findAll();
				foreach($spec_item_id as $k=>$spec_item_id_row)
				{
					$spec_item = array();
					$spec_item['id'] = $spec_item_id[$k];
					$spec_item['sn'] = $spec_item_sn[$k]==''?$goods_info['sn']."_".(D("GoodsSpecItem")->where("goods_id=".$goods_id)->count()+1):$spec_item_sn[$k];
					$spec_item['goods_id'] = $goods_id;
					$spec_item['stock'] = $spec_item_stock[$k];
					$spec_item['shop_price'] = $spec_item_shop_price[$k];
					$spec_item['cost_price'] = $spec_item_cost_price[$k];
					$spec_item['weight'] = toBaseWeight($spec_item_weight[$k],$_POST['weight_unit']);
					$spec_item['spec1_type_id'] = intval(D("GoodsSpec")->where("id=".$spec_type1_value_id[$k])->getField("spec_type_id"));
					$spec_item['spec2_type_id'] = intval(D("GoodsSpec")->where("id=".$spec_type2_value_id[$k])->getField("spec_type_id"));
					$spec_item['spec1_id'] = intval($spec_type1_value_id[$k]);
					$spec_item['spec2_id'] = intval($spec_type2_value_id[$k]);
					$item_id = D("GoodsSpecItem")->add($spec_item);
					
					//提交会员价					
					foreach($user_group as $user_group_item)
					{
						$group_price_data = array();
						$group_price_data['goods_id'] = $goods_id;
						$group_price_data['user_group_id'] = $user_group_item['id'];
						$group_price_data['user_price'] = $_REQUEST['user_group_'.$user_group_item['id']][$k];
						$group_price_data['spec_item_id'] = $item_id;
						if(floatval($group_price_data['user_price'])!=0)
						D("UserGroupPrice")->add($group_price_data);
					}
					D("GoodsSpec")->where("id=".$spec_type1_value_id[$k])->setField("goods_id",$goods_id);
					D("GoodsSpec")->where("id=".$spec_type2_value_id[$k])->setField("goods_id",$goods_id);
					D("GoodsSpec")->where("id=".$spec_type1_value_id[$k])->setField("session_id",'');
					D("GoodsSpec")->where("id=".$spec_type2_value_id[$k])->setField("session_id",'');
					
					if(in_array($spec_type1_value_id[$k],$insert_spec_list))
					{
						$spec_item_new = D("GoodsSpec")->getById($spec_type1_value_id[$k]);
						$spec_item_ins = array();
						foreach ($lang_envs as $lang_item)
						{
							$spec_item_ins['spec_name_'.$lang_item['id']] = $spec_item_new['spec_name_'.$lang_item['id']];
						}
						$spec_item_ins['img'] = $spec_item_new['img'];
						$spec_item_ins['spec_type_id'] = $spec_item_new['spec_type_id'];
						$spec_id = D("Spec")->add($spec_item_ins);
						foreach($insert_spec_list as $kk=>$vv)
						{
							if($vv==$spec_type1_value_id[$k])
							{
								unset($insert_spec_list[$kk]);
							}
						}
						D("GoodsSpec")->where("id=".$spec_type1_value_id[$k])->setField("spec_id",$spec_id);
					}
					if(in_array($spec_type2_value_id[$k],$insert_spec_list))
					{
						$spec_item_new = D("GoodsSpec")->getById($spec_type2_value_id[$k]);
						$spec_item_ins = array();
						foreach ($lang_envs as $lang_item)
						{
							$spec_item_ins['spec_name_'.$lang_item['id']] = $spec_item_new['spec_name_'.$lang_item['id']];
						}
						$spec_item_ins['img'] = $spec_item_new['img'];
						$spec_item_ins['spec_type_id'] = $spec_item_new['spec_type_id'];
						$spec_id = D("Spec")->add($spec_item_ins);
						foreach($insert_spec_list as $kk=>$vv)
						{
							if($vv==$spec_type2_value_id[$k])
							{
								unset($insert_spec_list[$kk]);
							}
						}
						D("GoodsSpec")->where("id=".$spec_type2_value_id[$k])->setField("spec_id",$spec_id);
					}
					
					$total_stock+=intval($spec_item_stock[$k]);
				}
				
				$spec_list = D("GoodsSpec")->where("session_id='".Session::id()."' and goods_id=0")->findAll();
				foreach($spec_list as $spec_item)
				{
					if(D("Spec")->where("img='".$spec_item['img']."'")->count()==0)
					{
						@unlink($this->getRealPath().$spec_item['img']);
					}
				}
				D("GoodsSpec")->where("session_id='".Session::id()."' and goods_id=0")->delete();				
				D("Goods")->where("id=".$goods_id)->setField("stock",$total_stock);
			}
			else
			{
				$default_spec_item['sn'] = $goods_info['sn'];
				$default_spec_item['goods_id'] = $goods_info['id'];
				$default_spec_item['shop_price'] = $goods_info['shop_price'];
				$default_spec_item['stock'] = $goods_info['stock'];
				$default_spec_item['weight'] = $goods_info['weight'];
				$default_spec_item['cost_price'] = $goods_info['cost_price'];
				$default_spec_item['spec1_type_id'] = 0;
				$default_spec_item['spec2_type_id'] = 0;
				$default_spec_item['spec1_id'] = 0;
				$default_spec_item['spec2_id'] = 0;
				$default_spec_id = D("GoodsSpecItem")->add($default_spec_item);
				//提交会员价					

				$user_group_price = $_REQUEST['user_group_price'];
	
				foreach($user_group_price as $k=>$group_price)
				{
					if($group_price>0)
					{
						$group_price_item = array();
						$group_price_item['goods_id'] = $goods_info['id'];
						$group_price_item['spec_item_id'] = $default_spec_id;
						$group_price_item['user_group_id'] = $k;
						$group_price_item['user_price'] = floatval($group_price);
						
						D("UserGroupPrice")->add($group_price_item);
						
					}
				}
				
			}
			$this->saveLog(1,$goods_id);
			$this->success (L('ADD_SUCCESS'));		
		}
		else 
		{
			$this->saveLog(0,$goods_id);
			$this->error (L('ADD_FAILED'));
		}
	}
	
	//改
	public function edit()
	{		
		$name=$this->getActionName();
		$model = M ( $name );
		$id = $_REQUEST [$model->getPk ()];
		$vo = $model->getById ( $id );
		$vo['weight'] = fromBaseWeight($vo['weight'],$vo['weight_unit']);
		$this->assign ( 'vo', $vo );
		
		$spec_list = D("GoodsSpec")->where("session_id='".Session::id()."' and goods_id=".$id)->findAll();
			foreach($spec_list as $spec_item)
			{
				if(D("Spec")->where("img='".$spec_item['img']."'")->count()==0)
				{
					@unlink($this->getRealPath().$spec_item['img']);
				}
			}
			D("GoodsSpec")->where("session_id='".Session::id()."' and goods_id=".$id)->delete();
			
		
		$gallery_list = D("GoodsGallery")->where("goods_id=".$vo['id'])->findAll();
		$this->assign("gallery_list",$gallery_list);
		$default_gallery = D("GoodsGallery")->where("goods_id=".$vo['id']." and is_default=1")->find();
		$this->assign("default_gallery",$default_gallery);
		
		$lang_envs = D("LangConf")->findAll();
		$lang_ids = array();
		$dispname_arr = array();
		$lang_names = array();
		foreach($lang_envs as $lang_item)
		{
			$dispname_arr[] = "name_".$lang_item['id'];
			$lang_ids[]=$lang_item['id'];
			$lang_names[] = $lang_item['lang_name'];
		}
		$lang_ids = implode(",",$lang_ids);
		$this->assign("lang_ids",$lang_ids);
		$lang_names = implode(",",$lang_names);
		$this->assign("lang_names",$lang_names);

		$cate_list = D("GoodsCate")-> where("status=1")-> findAll();
		$cate_list = D("GoodsCate")-> toFormatTree($cate_list,$dispname_arr);	
		
		$type_list = D("GoodsType")->findAll();
		
		$brand_list = D("Brand")->findAll();
		
		$default_lang_id = D("LangConf")->where("lang_name='".C('DEFAULT_LANG')."'")->field("id")->find();
		$default_lang_id = $default_lang_id['id'];  //默认语言的ID
		$select_dispname = "name_".$default_lang_id;
		
		//输出重量单位
		$weight_list = D("Weight")->findAll();
		foreach($weight_list as $kk=>$vv)
		{
			$weight_list[$kk]['name'] = $vv['name_'.$default_lang_id];
		}
		$this->assign('weight_list',$weight_list);
		
		//会员等级列表
		$user_group = D("UserGroup")->where("status=1")->findAll();
		$lang_curr_id = D("LangConf")->where("lang_name='".FANWE_LANG_SET."'")->getField("id");
		$group_price = D("UserGroupPrice")->where("goods_id=".$id)->findAll();
		foreach($user_group as $k=>$v)
		{
			$user_group[$k]['name'] = $v['name_'.$lang_curr_id];
			foreach($group_price as $price_item)
			{
				if($price_item['user_group_id']==$v['id'])
				{
					$user_group[$k]['price'] = $price_item['user_price'];
				}
			}
		}
		
		$this->assign("user_group",$user_group);
		
		
		//取出当前商品的规格类型ID
		$spec_type1 = D("SpecType")->getById(intval(D("GoodsSpec")->where("goods_id=".$id." and idx=1")->getField("spec_type_id")));
		$spec_type2 = D("SpecType")->getById(intval(D("GoodsSpec")->where("goods_id=".$id." and idx=2")->getField("spec_type_id")));
		$this->assign("spec_type1",$spec_type1);
		$this->assign("spec_type2",$spec_type2);
		
		//输出规格一
		$idx = 1;
		$session_id = Session::id();
		//插入不存在的预设
		$res = D("GoodsSpec")->where("goods_id=".$id." and idx=".$idx)->findAll();
		$exist_spec_conf1_ids = array();
		foreach($res as $k=>$v)
		{
			array_push($exist_spec_conf1_ids,$v['spec_id']);
		}
		if(count($exist_spec_conf1_ids)==0)
		{
			$exist_spec_conf1_ids = 0;
		}
		else 
		{
			$exist_spec_conf1_ids = implode(",",$exist_spec_conf1_ids);
		}
		$not_exist_spec = D("Spec")->where("spec_type_id=".intval($spec_type1['id'])." and id not in(".$exist_spec_conf1_ids.")")->findAll();
		
		foreach ($not_exist_spec as $item)
		{
			$item['idx'] = $idx;
			$item['goods_id'] = $id;
			$item['session_id'] = $session_id;
			$item['spec_id'] = $item['id'];
			$item['id'] = 0;			
			D("GoodsSpec")->add($item);
		}
		$res = D("GoodsSpec")->where("goods_id=".$id." and idx=".$idx." and (session_id='".$session_id."' or session_id='')")->findAll();
		foreach($res as $k=>$v)
		{
			$spec1[$v['spec_type_id']]['spec_type'] = D("SpecType")->getById($v['spec_type_id']);
			$spec1[$v['spec_type_id']]['spec_type']['name'] = $spec1[$v['spec_type_id']]['spec_type']['name_'.DEFAULT_LANG_ID];
			$spec1[$v['spec_type_id']]['spec_list'][] = $v;			
		}		
		$this->assign('idx',$idx);
		$this->assign("spec_list",$spec1);
		
		$spec_list1_str = $this->fetch("GoodsSpec:loadSpecConf");			
		$this->assign("spec_list1",$spec_list1_str);


		//输出规格二
		$idx = 2;
		$session_id = Session::id();
		//插入不存在的预设
		$res = D("GoodsSpec")->where("goods_id=".$id." and idx=".$idx." and (session_id='".$session_id."' or session_id='')")->findAll();
		$exist_spec_conf2_ids = array();
		foreach($res as $k=>$v)
		{
			array_push($exist_spec_conf2_ids,$v['spec_id']);
		}
		if(count($exist_spec_conf2_ids)==0)
		{
			$exist_spec_conf2_ids = 0;
		}
		else 
		{
			$exist_spec_conf2_ids = implode(",",$exist_spec_conf2_ids);
		}
		$not_exist_spec = D("Spec")->where("spec_type_id=".intval($spec_type2['id'])." and id not in(".$exist_spec_conf2_ids.")")->findAll();
		
		foreach ($not_exist_spec as $item)
		{
			$item['idx'] = $idx;
			$item['goods_id'] = $id;
			$item['session_id'] = $session_id;
			$item['spec_id'] = $item['id'];
			$item['id'] = 0;			
			D("GoodsSpec")->add($item);
		}
		$res = D("GoodsSpec")->where("goods_id=".$id." and idx=".$idx)->findAll();
		foreach($res as $k=>$v)
		{
			$spec2[$v['spec_type_id']]['spec_type'] = D("SpecType")->getById($v['spec_type_id']);
			$spec2[$v['spec_type_id']]['spec_type']['name'] = $spec2[$v['spec_type_id']]['spec_type']['name_'.DEFAULT_LANG_ID];
			$spec2[$v['spec_type_id']]['spec_list'][] = $v;			
		}		
		$this->assign('idx',$idx);
		$this->assign("spec_list",$spec2);
		
		$spec_list2_str = $this->fetch("GoodsSpec:loadSpecConf");			
		$this->assign("spec_list2",$spec_list2_str);
		
		
		//输出当前的规格结构
		$user_group = D("UserGroup")->findAll();		
		foreach($user_group as $k=>$v)
		{
			$user_group[$k]['name'] = $v['name_'.DEFAULT_LANG_ID];			
		}
		
		
		
		
		$goods_spec_items = D("GoodsSpecItem")->where("goods_id=".$id." and (spec1_id<>0 or spec2_id<>0)")->findAll();
		foreach($goods_spec_items as $k=>$row)
		{
			$goods_spec_items[$k]['spec_type1'] = D('GoodsSpec')->getById($row['spec1_id']);
			$goods_spec_items[$k]['spec_type2'] = D('GoodsSpec')->getById($row['spec2_id']);
			$goods_spec_items[$k]['weight'] = fromBaseWeight($row['weight'],$vo['weight_unit']);
			foreach($user_group as $k=>$v)
			{
				$user_group[$k][$row['id']]['price'] = D("UserGroupPrice")->where("goods_id=".$id." and user_group_id=".$v['id']." and spec_item_id=".intval($row['id']))->getField("user_price");			
			}
		}
		$this->assign('spec_item_user_group',$user_group);
		$this->assign("spec_list",$goods_spec_items);
		$spec_item_table = $this->fetch("GoodsSpec:makeSpecItemTable");
		
		$this->assign("spec_item_table",$spec_item_table);
		
	
		//输出规格类型
		$spec_type_1 = intval(D("GoodsSpec")->where("goods_id=".$id." and idx=1")->getField("spec_type_id"));
		$spec_type_2 = intval(D("GoodsSpec")->where("goods_id=".$id." and idx=2")->getField("spec_type_id"));
		$spec_type_list1 = D("SpecType")->where("id<>".$spec_type_2)->findAll();
		$spec_type_list2 = D("SpecType")->where("id<>".$spec_type_1)->findAll();
		foreach($spec_type_list1 as $k=>$type_item)
		{
			$spec_type_list1[$k]['name'] = $type_item['name_'.DEFAULT_LANG_ID];
		}
		$this->assign("spec_type_list1",$spec_type_list1);
		foreach($spec_type_list2 as $k=>$type_item)
		{
			$spec_type_list2[$k]['name'] = $type_item['name_'.DEFAULT_LANG_ID];
		}
		$this->assign("spec_type_list2",$spec_type_list2);
		$this->assign("spec_type_1",$spec_type_1);
		$this->assign("spec_type_2",$spec_type_2);
		//规格结构结束
		
		$this->assign("select_dispname",$select_dispname);
		$this->assign("default_lang_id",$default_lang_id);
		$this->assign("cate_list",$cate_list);
		$this->assign("type_list",$type_list);
		$this->assign("brand_list",$brand_list);
		$this->assign("goods_id",$id);
		$this->assign("has_spec",D("GoodsSpecItem")->where("goods_id=".$id." and (spec1_id<>0 or spec2_id<>0)")->count());
		$this->assign("session_id",$_SESSION['verify']);
		$this->display();
	}
	
	public function update()
	{
		$_POST['weight'] = toBaseWeight($_POST['weight'],$_POST['weight_unit']);  //转换重量
		$name=$this->getActionName();
		$model = D ( $name );
		if (false === $model->create ()) {
			$this->error ( $model->getError () );
		}
		// 更新数据
		$list=$model->save ();
		
		$goods_id = intval($_REQUEST['id']); //商品ID
		
		if($list)
		{
			//会员等级价
			$user_group_price = $_REQUEST['user_group_price'];
			
			foreach($user_group_price as $k=>$group_price)
			{
				if($group_price>0)
				{
					$group_price_item['goods_id'] = $goods_id;
					$group_price_item['user_group_id'] = $k;
					$group_price_item['user_price'] = floatval($group_price);
					$group_price_item['id'] = intval(D("UserGroupPrice")->where("goods_id=".$goods_id." and user_group_id=".$k)->getField("id"));
					
					if($group_price_item['id']>0)
					D("UserGroupPrice")->save($group_price_item);
					else 					
					D("UserGroupPrice")->add($group_price_item);
				}
				else 
				{
					$group_price_item_id = D("UserGroupPrice")->where("goods_id=".$goods_id." and user_group_id=".$k)->getField("id");
					D("UserGroupPrice")->where("id=".$group_price_item_id)->delete();
				}
			}
			
			//开始处理图库与属性		
			
			
			//属性
			D("GoodsAttr")->where("goods_id=".$goods_id)->delete();
			$attr_value = $_REQUEST['attr_value'];
			$attr_price = $_REQUEST['attr_price'];
			$attr_stock = $_REQUEST['attr_stock'];
		    if($attr_value)
			{
				
				foreach($attr_value as $attr_id=>$attr_list)
				{
					$attr_item = array();
					foreach($attr_list as $lang_id=>$val_list)
					{
						foreach($val_list as $row_idx=>$val)
						{
							$attr_item[$row_idx]['attr_id'] = $attr_id;
							$attr_item[$row_idx]['goods_id'] = $goods_id;
							$attr_item[$row_idx]['attr_value_'.$lang_id] = $val;
							$attr_item[$row_idx]['price'] = floatval($attr_price[$attr_id][$row_idx]);
							$attr_item[$row_idx]['stock'] = intval($attr_stock[$attr_id][$row_idx]);
						}
					}		
					foreach ($attr_item as $val_item)
					{
						D("GoodsAttr")->add($val_item);
					}
				}
			}		
			
			
			//图库
			$defalut_gallery_id = $_REQUEST['gallery_id'];
			if($_REQUEST['goods_gallerys'])
			{
				$goods_gallery = $_REQUEST['goods_gallerys'];
				D("GoodsGallery")->where("goods_id=".$goods_id)->setField('is_default','0');  //先初始化默认图
				
				foreach($goods_gallery as $gallery_id)
				{
					$gallery_item = D("GoodsGallery")->getById($gallery_id);
					$gallery_item['goods_id'] = $goods_id;
					if($gallery_item['id']==$defalut_gallery_id)
					{
						$gallery_item['is_default'] = 1;
					}
					D("GoodsGallery")->save($gallery_item);					
				}
			}

			
			//商品默认图片
			$goods_info = D("Goods")->getById($goods_id);
			$goods_img_info = D("GoodsGallery")->getById($defalut_gallery_id);
			$goods_info['origin_img'] = $goods_img_info['origin_img'];
			$goods_info['big_img'] = $goods_img_info['big_img'];
			$goods_info['small_img'] = $goods_img_info['small_img'];
			D("Goods")->save($goods_info);
			
			//规格
			//查询会员等级
			$user_group = D("UserGroup")->findAll();
			$spec_item_id = $_REQUEST['spec_item_id'];  //提交的规格
			$spec_item_sn = $_REQUEST['spec_item_sn'];  //规格货号
			$spec_item_weight = $_REQUEST['spec_item_weight'];  //规格重量
			$spec_item_stock = $_REQUEST['spec_item_stock'];    //规格库存
			$spec_item_shop_price = $_REQUEST['spec_item_shop_price'];  //商城价
			$spec_item_cost_price = $_REQUEST['spec_item_cost_price'];  //成本价
			$spec_type1_value_id = $_REQUEST['spec_type1_value_id'];    //规格一
			$spec_type2_value_id = $_REQUEST['spec_type2_value_id'];    //规格二
			
//			dump($spec_item_sn);exit;
			if($spec_item_id)
			{
				D("GoodsSpecItem")->where("goods_id=".$goods_id." and spec1_id = 0 and spec2_id = 0")->delete();
				$total_stock = 0;
				D("UserGroupPrice")->where("goods_id=".$goods_id." and spec_item_id <> 0")->delete();
				$insert_spec_list = $_REQUEST['insert_to_spec'];	
				$lang_envs = D("LangConf")->findAll();
				foreach($spec_item_id as $k=>$spec_item_id_row)
				{
					$spec_item = array();
					$spec_item['id'] = intval($spec_item_id[$k]);
					$spec_item['sn'] = $spec_item_sn[$k]==''?$goods_info['sn']."_".(D("GoodsSpecItem")->where("goods_id=".$goods_id)->count()+1):$spec_item_sn[$k];
					$spec_item['goods_id'] = $goods_id;
					$spec_item['stock'] = $spec_item_stock[$k];
					$spec_item['shop_price'] = $spec_item_shop_price[$k];
					$spec_item['cost_price'] = $spec_item_cost_price[$k];
					$spec_item['weight'] = toBaseWeight($spec_item_weight[$k],$_POST['weight_unit']);
					$spec_item['spec1_type_id'] = intval(D("GoodsSpec")->where("id=".$spec_type1_value_id[$k])->getField("spec_type_id"));
					$spec_item['spec2_type_id'] = intval(D("GoodsSpec")->where("id=".$spec_type2_value_id[$k])->getField("spec_type_id"));
					$spec_item['spec1_id'] = intval($spec_type1_value_id[$k]);
					$spec_item['spec2_id'] = intval($spec_type2_value_id[$k]);
					if($spec_item['id']==0)
					{
						$item_id = D("GoodsSpecItem")->add($spec_item);
					}
					else 
					{
						$item_id = $spec_item['id'];
						D("GoodsSpecItem")->save($spec_item);
					}
					
					//提交会员价
									
					foreach($user_group as $user_group_item)
					{
						$group_price_data = array();
						$group_price_data['goods_id'] = $goods_id;
						$group_price_data['user_group_id'] = $user_group_item['id'];
						$group_price_data['user_price'] = $_REQUEST['user_group_'.$user_group_item['id']][$k];
						$group_price_data['spec_item_id'] = $item_id;
						if(floatval($group_price_data['user_price'])!=0)
						{
							D("UserGroupPrice")->add($group_price_data);
						}
					}
					
					D("GoodsSpec")->where("id=".$spec_type1_value_id[$k])->setField("goods_id",$goods_id);
					D("GoodsSpec")->where("id=".$spec_type2_value_id[$k])->setField("goods_id",$goods_id);
					D("GoodsSpec")->where("id=".$spec_type1_value_id[$k])->setField("session_id",'');
					D("GoodsSpec")->where("id=".$spec_type2_value_id[$k])->setField("session_id",'');
					if(in_array($spec_type1_value_id[$k],$insert_spec_list))
					{
						$spec_item_new = D("GoodsSpec")->getById($spec_type1_value_id[$k]);
						$spec_item_ins = array();
						foreach ($lang_envs as $lang_item)
						{
							$spec_item_ins['spec_name_'.$lang_item['id']] = $spec_item_new['spec_name_'.$lang_item['id']];
						}
						$spec_item_ins['img'] = $spec_item_new['img'];
						$spec_item_ins['spec_type_id'] = $spec_item_new['spec_type_id'];
						$spec_id = D("Spec")->add($spec_item_ins);
						foreach($insert_spec_list as $kk=>$vv)
						{
							if($vv==$spec_type1_value_id[$k])
							{
								unset($insert_spec_list[$kk]);
							}
						}
						D("GoodsSpec")->where("id=".$spec_type1_value_id[$k])->setField("spec_id",$spec_id);
					}
					if(in_array($spec_type2_value_id[$k],$insert_spec_list))
					{
						$spec_item_new = D("GoodsSpec")->getById($spec_type2_value_id[$k]);
						$spec_item_ins = array();
						foreach ($lang_envs as $lang_item)
						{
							$spec_item_ins['spec_name_'.$lang_item['id']] = $spec_item_new['spec_name_'.$lang_item['id']];
						}
						$spec_item_ins['img'] = $spec_item_new['img'];
						$spec_item_ins['spec_type_id'] = $spec_item_new['spec_type_id'];
						$spec_id = D("Spec")->add($spec_item_ins);
						foreach($insert_spec_list as $kk=>$vv)
						{
							if($vv==$spec_type2_value_id[$k])
							{
								unset($insert_spec_list[$kk]);
							}
						}
						D("GoodsSpec")->where("id=".$spec_type2_value_id[$k])->setField("spec_id",$spec_id);
					}
					
					$total_stock+=intval($spec_item_stock[$k]);
				}
				D("Goods")->where("id=".$goods_id)->setField("stock",$total_stock);
			}
			else
			{
				D("UserGroupPrice")->where("goods_id=".$goods_id." and spec_item_id <> 0")->delete(); //清除原有的会员等级价
				$exist_spec_item = D("GoodsSpecItem")->where("goods_id=".$goods_id." and spec1_id = 0 and spec2_id = 0")->find();
				D("GoodsSpecItem")->where("goods_id=".$goods_id." and id<>".intval($exist_spec_item['id']))->delete();
				if($exist_spec_item)
				{
					$exist_spec_item['sn'] = $goods_info['sn'];
					$exist_spec_item['stock'] = $goods_info['stock'];
					$exist_spec_item['shop_price'] = $goods_info['shop_price'];
					$exist_spec_item['weight'] = $goods_info['weight'];
					$exist_spec_item['cost_price'] = $goods_info['cost_price'];
					D("GoodsSpecItem")->save($exist_spec_item);
					
					
					//会员等级价
					$user_group_price = $_REQUEST['user_group_price'];					
					foreach($user_group_price as $k=>$group_price)
					{
						if($group_price>0)
						{
							$group_price_item  = array();
							$group_price_item['goods_id'] = $goods_id;
							$group_price_item['user_group_id'] = $k;
							$group_price_item['user_price'] = floatval($group_price);
							$group_price_item['spec_item_id'] = $exist_spec_item['id'];
				
							D("UserGroupPrice")->add($group_price_item);
						}
					}
				}
				else
				{
					$exist_spec_item['id'] = 0;
					$exist_spec_item['sn'] = $goods_info['sn'];
					$exist_spec_item['goods_id'] = $goods_info['id'];
					$exist_spec_item['stock'] = $goods_info['stock'];
					$exist_spec_item['shop_price'] = $goods_info['shop_price'];
					$exist_spec_item['weight'] = $goods_info['weight'];
					$exist_spec_item['cost_price'] = $goods_info['cost_price'];
					$exist_spec_item['spec1_type_id'] = 0;
					$exist_spec_item['spec2_type_id'] = 0;
					$exist_spec_item['spec1_id'] = 0;
					$exist_spec_item['spec2_id'] = 0;
					$defalut_spec_id = D("GoodsSpecItem")->add($exist_spec_item);
					
					//会员等级价
					$user_group_price = $_REQUEST['user_group_price'];					
					foreach($user_group_price as $k=>$group_price)
					{
						if($group_price>0)
						{
							$group_price_item  = array();
							$group_price_item['goods_id'] = $goods_id;
							$group_price_item['user_group_id'] = $k;
							$group_price_item['user_price'] = floatval($group_price);
							$group_price_item['spec_item_id'] = $defalut_spec_id;
				
							D("UserGroupPrice")->add($group_price_item);
						}
					}
				}
			}			
			$this->saveLog(1,$goods_id);
			$this->success (L('EDIT_SUCCESS'));		
		}
		else 
		{			
			$this->saveLog(0,$goods_id);
			$this->error (L('EDIT_FAILED'));
		}
	}
	
	
	//永久删除
	public function foreverdelete() {
		//删除指定记录
		$name=$this->getActionName();
		$model = D ($name);
		if (! empty ( $model )) {
			$pk = $model->getPk ();
			$id = $_REQUEST [$pk];
			if (isset ( $id )) {
				$condition = array ($pk => array ('in', explode ( ',', $id ) ) );
				$goods_list = $model->where ( $condition )->findAll();  //要删除商品列表
				if (false !== $model->where ( $condition )->delete ()) {
					//echo $model->getlastsql();
					foreach($goods_list as $goods_item)
					{
						D("GoodsAttr")->where("goods_id=".$goods_item['id'])->delete();
						$gallery_list = D("GoodsGallery")->where("goods_id=".$goods_item['id'])->findAll();
						foreach($gallery_list as $item)
						{
							@unlink($this->getRealPath().$item['small_img']);
							@unlink($this->getRealPath().$item['big_img']);
							@unlink($this->getRealPath().$item['origin_img']);
						}
						D("GoodsGallery")->where("goods_id=".$goods_item['id'])->delete();
					}
					//开始删除相关的留言
					$msgList = D("Message")->where(array ("rec_id" => array ('in', explode ( ',', $id ) ),'rec_module'=>'Goods' ))->findAll();
					D("Message")->where(array ("rec_id" => array ('in', explode ( ',', $id ) ),'rec_module'=>'Goods' ))->delete();
					foreach($msgList as $msgItem)
					{
						D("Message")->where("pid=".$msgItem['id'])->delete();
					}
					
					//开始删除相关会员价
					D("UserGroupPrice")->where(array ("goods_id" => array ('in', explode ( ',', $id ) ) ))->delete();
					
					//开始删除相关规格
					D("GoodsSpecItem")->where(array ("goods_id" => array ('in', explode ( ',', $id ) ) ))->delete();
					$spec_img_list = D("GoodsSpec")->where(array ("goods_id" => array ('in', explode ( ',', $id ) ) ))->findAll();
					foreach($spec_img_list as $img_item)
					{
						if($img_item['define_img'] == 1)
						{
							@unlink($this->getRealPath().$img_item['img']);
						}
					}					
					D("GoodsSpec")->where(array ("goods_id" => array ('in', explode ( ',', $id ) ) ))->delete();
					
					$this->saveLog(1);
					$this->success (L('DEL_SUCCESS'));
				} else {
					$this->saveLog(0);
					$this->error (L('DEL_FAILED'));
				}
			} else {
				$this->saveLog(0);
				$this->error ( L('INVALID_OP') );
			}
		}
		$this->forward ();
	}
	//移动商品至分类
	public function moveGoods()
	{
		$name=$this->getActionName();
			$model = M ($name);
			if (! empty ( $model )) {
				$pk = $model->getPk ();
				$id = $_REQUEST [$pk];
				$cate_id = $_REQUEST['cate_id'];
				if (isset ( $id )) {
					$condition = array ($pk => array ('in', explode ( ',', $id ) ) );
					$list=$model->where ( $condition )->setField ( 'cate_id', $cate_id );
					if ($list!==false) {
						$this->saveLog(1);
						$this->success ( L('MOVE_SUCCESS') );
					} else {
						$this->saveLog(0);
						$this->error (L('MOVE_FAILED'));
					}
				} else {
					$this->saveLog(0);
					$this->error ( L('INVALID_OP') );
				}
			}
		$this->forward ();
	}
	//获取图片信息
	public function setGallery()
	{
		$id = $_REQUEST['id'];
		$gallery = D("GoodsGallery")->getById($id);
		echo json_encode($gallery);
	}
	//删除图片
	public function delGallery()
	{
		$id = $_REQUEST['id'];
		$item = D("GoodsGallery")->getById($id);
		@unlink($this->getRealPath().$item['origin_img']);
		@unlink($this->getRealPath().$item['big_img']);
		@unlink($this->getRealPath().$item['small_img']);
		D("GoodsGallery")->where('id='.$id)->delete();
	}
	
	//获取类型的属性列表
	public function getTypeAttr()
	{
		$lang_envs = D("LangConf")->findAll();
		$type_id = $_REQUEST['type_id'];
		$goods_id = $_REQUEST['goods_id'];
		$attr_list = D("GoodsTypeAttr")->where("type_id=".$type_id)->findAll();
		if($attr_list)
		{
			foreach($attr_list as $k=>$attr_item)
			{
				$value_list = D("GoodsAttr")->where("attr_id=".$attr_item['id']." and goods_id=".$goods_id)->findAll();
				//获取出当前属性下的所有属性值
				
				$attr_list[$k]['row_count'] = D("GoodsAttr")->where("attr_id=".$attr_item['id']." and goods_id=".$goods_id)->count();
				
				foreach($value_list as $value_key => $value_row)
				{
					foreach($lang_envs as $lang_item)
					{
						//已有值
						$attr_list[$k]['value_'.$lang_item['id']][$value_key] = $value_row['attr_value_'.$lang_item['id']]?$value_row['attr_value_'.$lang_item['id']]:"";
						$attr_list[$k]['price'][$value_key] = $value_row['price']?$value_row['price']:"";
						$attr_list[$k]['stock'][$value_key] = $value_row['stock']?$value_row['stock']:""; 
					}
				}
				
				foreach($lang_envs as $lang_item)
				{
						//可选值
						$attr_list[$k]['attr_value_'.$lang_item['id']] = explode("\n",$attr_item['attr_value_'.$lang_item['id']]);
				}
			}
		}
		else 
		{
			$attr_list = array();
		}
		echo json_encode($attr_list);
	}
}
?>