<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 商品分类
class GoodsCateAction extends CommonAction{
	//列表
	public function index() {
		$lang_envs = D("LangConf")->findAll();
		$dispname_arr = array();
		foreach($lang_envs as $lang_item)
		{
			$dispname_arr[] = "name_".$lang_item['id'];
		}
		//列表过滤器，生成查询Map对象
		$map = $this->_search ();
		$map['status'] = 1;
		$map['pid'] = 0;
		if (method_exists ( $this, '_filter' )) {
			$this->_filter ( $map );
		}
		$name=$this->getActionName();
		$model = D ($name);
		if (! empty ( $model )) {
			$this->_list ( $model, $map, '', false, true, 'id','pid', $dispname_arr);
		}
		$this->display ();
		return;
	}
	//增
	public function add()
	{
		$lang_envs = D("LangConf")->field("id")->findAll();
		$dispname_arr = array();
		foreach($lang_envs as $lang_item)
		{
			$dispname_arr[] = "name_".$lang_item['id'];
		}
		$list = D(MODULE_NAME)-> where("status=1")-> findAll();
		$list = D(MODULE_NAME)-> toFormatTree($list,$dispname_arr);	
		
		$spec_type_list = D("SpecType")->findAll();
		foreach($spec_type_list as $k=>$v)
		{
			$spec_type_list[$k]['name'] = $v['name_'.DEFAULT_LANG_ID];
		}
		$this->assign("spec_type_list",$spec_type_list);
		
		$default_lang_id = D("LangConf")->where("lang_name='".C('DEFAULT_LANG')."'")->field("id")->find();
		$default_lang_id = $default_lang_id['id'];  //默认语言的ID
		$select_dispname = "name_".$default_lang_id;
		
		
		$new_sort = D(MODULE_NAME)->where("status=1") -> max("sort") + 1;
		$this->assign('new_sort',$new_sort);
		$this->assign("select_dispname",$select_dispname);
		$this->assign("cate_list",$list);
		$this->display();
	}
	//改
	public function edit()
	{
		$lang_envs = D("LangConf")->field("id")->findAll();
		$dispname_arr = array();
		foreach($lang_envs as $lang_item)
		{
			$dispname_arr[] = "name_".$lang_item['id'];
		}
		
		//开始获取当前分类与其子分类的ID
		$pk = D(MODULE_NAME)->getPk();
		$childIds = D(MODULE_NAME)->getChildIds($_REQUEST[$pk]);
		$childIds[] = $_REQUEST[$pk];
		$childIds_str = implode(",",$childIds);
		
		$list = D(MODULE_NAME)-> where("status=1 and ".$pk." not in(".$childIds_str.")")-> findAll();
		$list = D(MODULE_NAME)-> toFormatTree($list,$dispname_arr);	
		
		$spec_type_list = D("SpecType")->findAll();
		foreach($spec_type_list as $k=>$v)
		{
			$spec_type_list[$k]['name'] = $v['name_'.DEFAULT_LANG_ID];
		}
		$this->assign("spec_type_list",$spec_type_list);
		
		$default_lang_id = D("LangConf")->where("lang_name='".C('DEFAULT_LANG')."'")->field("id")->find();
		$default_lang_id = $default_lang_id['id'];  //默认语言的ID
		$select_dispname = "name_".$default_lang_id;
		
		$this->assign("select_dispname",$select_dispname);
		$this->assign("cate_list",$list);
				
		parent::edit();
	}
	
	//删
	public function foreverdelete() {
		//删除指定记录
		$name=$this->getActionName();
		$model = D ($name);
		if (! empty ( $model )) {
			$pk = $model->getPk ();
			$id = $_REQUEST [$pk];
			
			if (isset ( $id )) {
				//进行分类删除的验证
				if($model->where('pid='.$id)->count() > 0)
				$this->error(L('CHILD_CATE_EXIST'));
				if(D("Goods")->where("cate_id=".$id)->count() > 0)
				$this->error(L('GOODS_EXIST'));
				//验证结束
				$condition = array ($pk => array ('in', explode ( ',', $id ) ) );
				if (false !== $model->where ( $condition )->delete ()) {
					//echo $model->getlastsql();
					$this->saveLog(1);
					$this->success (L('DEL_SUCCESS'));
				} else {
					$this->saveLog(0);
					$this->error (L('DEL_FAILED'));
				}
			} else {
				$this->saveLog(0);
				$this->error ( L('INVALID_OP') );
			}
		}
		$this->forward ();
	}
}
?>