<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 后台首页
class IndexAction extends CommonAction{
	public function index()
	{
		if(!isset($_SESSION[C('USER_AUTH_KEY')])) {
			$this->assign('jumpUrl',U('Public/login'));
			$this->error(L('NOT_LOGIN'));
		}
		$this->display();
	}
	
// 顶部页面
	public function top() {
		C('SHOW_RUN_TIME',false);			// 运行时间显示
		C('SHOW_PAGE_TRACE',false);
		$model	=	M("RoleNav");
		if($_SESSION[C("ADMIN_AUTH_KEY")])
			$list	=	$model->field('id,name')->order("sort")->findAll(); 
		else
			$list	=	$model->where('status=1')->field('id,name')->order("sort")->findAll(); 
		$this->assign('roleNav',$list);
		$this->display();
	}
	// 尾部页面
	public function footer() {
		C('SHOW_RUN_TIME',false);			// 运行时间显示
		C('SHOW_PAGE_TRACE',false);
		$this->display();
	}
	// 菜单页面
	public function menu() {
		
        if(isset($_SESSION[C('USER_AUTH_KEY')])) {
            //显示菜单项
            $id	=	intval($_REQUEST['tag'])==0?1:intval($_REQUEST['tag']);

            $menu  = array();
            if($id>0)
            {
	            if(isset($_SESSION['menu'.$_SESSION[C('USER_AUTH_KEY')].$id])) {
	
	                //如果已经缓存，直接读取缓存
	                $menu   =  $_SESSION['menu'.$_SESSION[C('USER_AUTH_KEY')].$id];
	            }else {
	                //读取数据库模块列表生成菜单项
	                $node_model    =   M("RoleNode");				
					$where['status']=1;
					$where['nav_id']=$id;
	                $list	=	$node_model->where($where)->field('id,action,action_name,module,module_name')->order('sort asc')->select();
	                foreach($list as $key=>$action) {
	                   $menu[$action['module']]['navs'][] = $action;
	                   $menu[$action['module']]['name']	= $action['module_name'];
	                }
	                //缓存菜单访问
	                $_SESSION['menu'.$_SESSION[C('USER_AUTH_KEY')].$id]	=	$menu;
	            }
            }
            $this->assign('menu',$menu);
		}
		C('SHOW_RUN_TIME',false);			// 运行时间显示
		C('SHOW_PAGE_TRACE',false);
		$this->display();
	}

    // 后台首页 查看系统信息
    public function main() {
    	$sys_info = C("FANWE_INFO");
        $info = array(
            L('PHP_OS')=>PHP_OS,
            L('SERVER_ENV')=>$_SERVER["SERVER_SOFTWARE"],
            L('PHP_MODE')=>php_sapi_name(),
            L('SYS_VERSION')=>$sys_info['version'].' [ <a href="http://www.sunnyi.com" target="_blank">'.L('CHECK_UPDATE').'</a> ]',
            L('MAX_UPLOAD_LIMIT')=>ini_get('upload_max_filesize'),
            L('MAX_EXEC_TIME')=>ini_get('max_execution_time').L('SEC'),
            L('SERVER_TIME')=>date("Y年n月j日 H:i:s"),
            L('BJ_TIME')=>gmdate("Y".L('YEAR')."n".L('MONTH')."j".L('DAY')." H:i:s",time()+8*3600),
            L('SERVER_NAME')=>$_SERVER['SERVER_NAME'].' [ '.gethostbyname($_SERVER['SERVER_NAME']).' ]',
            L('FREE_SPACE')=>round((@disk_free_space(".")/(1024*1024)),2).'M',
            'register_globals'=>get_cfg_var("register_globals")=="1" ? "ON" : "OFF",
            'magic_quotes_gpc'=>(1===get_magic_quotes_gpc())?'YES':'NO',
            'magic_quotes_runtime'=>(1===get_magic_quotes_runtime())?'YES':'NO',
            );
        $this->assign('info',$info);
        $this->display();
    }
    
// 更换密码
    public function changePwd()
    {
        //对表单提交处理进行处理或者增加非表单数据
		if(md5($_POST['verify'])	!= $_SESSION['verify']) {
			$this->error(L('VERIFY_ERROR'));
		}
		$map	=	array();
        $map['adm_pwd']= pwdHash($_POST['oldpassword']);
        if(isset($_POST['adm_name'])) {
            $map['adm_name']	 =	 $_POST['adm_name'];
        }elseif(isset($_SESSION[C('USER_AUTH_KEY')])) {
            $map['id']		=	$_SESSION[C('USER_AUTH_KEY')];
        }
        //检查用户
        $User    =   new AdminModel();
        $result = $User->create();
        if (!$result){		
		// 如果创建失败 表示验证没有通过 输出错误提示信息
			$this->error($User->getError());
		}
        
        if(!$User->where($map)->field('id')->find()) {
            $this->error(L('PWD_OR_NAME_ERROR'));
        }else {
			$User->adm_pwd	=	pwdHash($_POST['adm_pwd']);
			$User->save();
			$this->success(L('CHANGE_PWD_SUCCESS'));
         }
    }
}
?>