<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 前台菜单列表
class NavAction extends CommonAction{
	//定义站内的操作结构（可用于菜单配置）
	private $nav_conf = array(
		'ScoreGoods'=>array(
			'index',
		),
		'Goods'=>array(  //商品模块
			'index',	 //列表操作
			'show',		 //展示操作
			'pick',		 //选购操作
			'advSearch', //搜索操作	
			'isBest',    //精品
			'isHot',     //热卖
			'isPromote', //促销
		),
		'Article'=>array(
			'index',	//列表
			'show',		//展示
			'type',		//类型
		),
		'User'=>array(
			'register', //注册
			'login',    //登录
		),
		'Cart'=>array(
			'listCart'	//购物车列表
		),
		'Link'=>array(
			'index'		//友情链接
		),
		'Brand'=>array(
			'index',	//品牌列表
			'show',		//品牌商品
		),
		'Message'	=>array(
			'index'
		)
	);
	//增
	public function add()
	{
		$this->assign("module_list",$this->nav_conf);  //输出模块列表
		$new_sort = D(MODULE_NAME)-> max("sort") + 1;
		$this->assign('new_sort',$new_sort);
		$this->display();
	}

	
	//改
	public function edit()
	{
		$this->assign("module_list",$this->nav_conf);  //输出模块列表
		
		$name=$this->getActionName();
		$model = M ( $name );
		$id = $_REQUEST [$model->getPk ()];
		$vo = $model->getById ( $id );
		
		$action_list = $this->nav_conf;
		$action_list = $action_list[$vo['rec_module']];
		$res = array();
		foreach($action_list as $k=>$v)
		{
			$res[$k] = array('value'=>$v,'name'=>L("LANG_SHOW_".$v));
		}
		$this->assign("action_list",$res);
		
		$this->assign ( 'vo', $vo );
		$this->display ();
	}
	
	public function getActionList()
	{
		$rec_module = $_REQUEST['rec_module'];
		$action_list = $this->nav_conf;
		$action_list = $action_list[$rec_module];
		$res = array();
		foreach($action_list as $k=>$v)
		{
			$res[$k] = array('value'=>$v,'name'=>L("LANG_SHOW_".$v));
		}
		echo json_encode($res);
	}
}
?>