<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

//商品
class GoodsModel extends MultiLangModel {
	protected $_validate = array(
			array('name','require',GOODS_NAME_REQUIRE), 
			array('cate_id','gtZero',GOODS_CATE_REQUIRE,0,'function'), // 自定义函数验证密码格式
			array('market_price','is_numeric',MARKET_PRICE_MUST_BE_NUM,2,'function'), 
			array('shop_price','is_numeric',SHOP_PRICE_MUST_BE_NUM,2,'function'), 
			array('promote_price','is_numeric',PROMOTE_PRICE_MUST_BE_NUM,2,'function'), 
			array('sort','is_numeric',SORT_MUST_BE_NUM,2,'function'), 
			array('stock','is_numeric',STOCK_MUST_BE_NUM,2,'function'), 
			array('promote_begin_time','checkDateFormat',PROMOTE_BEGIN_TIME_ERROR,2,'function'),
			array('promote_end_time','checkDateFormat',PROMOTE_END_TIME_ERROR,2,'function'),

		);
		
	protected $_auto = array ( 		
		array('status','1'),  // 新增的时候把status字段设置为1
		array('create_time','gmtTime',1,'function'), // 对create_time字段在插入的时候写入当前时间戳	
		array('update_time','gmtTime',3,'function'), 
		array('sn','genGoodsSn',3,'function'), 	   //未填写时自动生成货号
		array('promote_begin_time','localStrToTimeMin',3,'function'), 	   
		array('promote_end_time','localStrToTimeMax',3,'function'), 	   
		
	);
		
}
?>