<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------

// 文章
class ArticleAction extends SunnyiAction{
	public function _index()
	{
		$this->index($_REQUEST);
	}
    public function index($request){    
    	if($request)
		{
			$_REQUEST = $request;
		}	
		$cate_id = intval($_REQUEST['id']);
		if($cate_id>0&&D("ArticleCate")->where('id='.$cate_id)->count()==0)
		{
			$this->error(L("NO_ARTICLE_CATE"));
		}
		else 
		{
			//关键词
			$keywords = $_REQUEST['keywords']?trim($_REQUEST['keywords']):'';
			$this->assign('keywords',$keywords);
			
			//初始化分页
	    	$page = intval($_REQUEST[C("VAR_PAGE")]);
	    	if($page==0)
	    	$page = 1;
	    	$this->assign("page",$page);
    	
			$type = intval(D("ArticleCate")->where("id=".$cate_id)->getField("type"));  //查询当前分类的类型
			$cate_list = D("ArticleCate")->getArticleCateList(array("type"=>$type,'status'=>1));
			$cate_list = D("ArticleCate")->toFormatTree($cate_list);
			foreach($cate_list as $k=>$v)
			{
				if($cate_id==$v['id'])
				$cate_list[$k]['act'] = 1;
			}
			$this->assign('article_cate_list',$cate_list);  //输出分类树
			
			//查询当前分类信息
			$cate_info = D("ArticleCate")->getArticleCateItem("id=".$cate_id);	
			if($cate_info)
			{
				$this->assign("page_title",$cate_info['name_'.FANWE_LANG_ID]);	
				$navs = array('name'=>$cate_info['name_'.FANWE_LANG_ID],'url'=>$cate_info['url']);
				//输出当前页seo内容
	    		$data = array(
	    			'navs' => array(
	    			$navs,
	    			),
	    			'keyword'=>	$cate_info['seokeyword_'.FANWE_LANG_ID]!=''?$cate_info['seokeyword_'.FANWE_LANG_ID]:$cate_info['name_'.FANWE_LANG_ID],
	    			'content'=>	$cate_info['seocontent_'.FANWE_LANG_ID]!=''?$cate_info['seocontent_'.FANWE_LANG_ID]:$cate_info['name_'.FANWE_LANG_ID],
	    		);
	    		$this->assignSeo($data);    
			}
			else  //无ID为全部文章，或搜索
			{
				$this->assign("page_title",L("ARTICLE_LIST"));
				$navs = array('name'=>L("ARTICLE_LIST"),'url'=>U("Article/index"));
				//输出当前页seo内容
	    		$data = array(
	    			'navs' => array(
	    			$navs,
	    			),
	    			'keyword'=>	L("ARTICLE_LIST"),
	    			'content'=>	L("ARTICLE_LIST"),
	    		);
	    		$this->assignSeo($data);  				
			}
			
			//输出文章列表
			$article_result = D("Article")->searchArticleList($cate_id,$type,$keywords,$page);
			$this->assign("article_list",$article_result['article_list']);
    		//分页
			$page = new Page($article_result['article_total'],sunnyiC("ARTICLE_PAGE_LISTROWS"));   //初始化分页对象 		
			$p  =  $page->show();
	        $this->assign('pages',$p);
	        //end 分页  
			$this->display("Page:article_index");
		}
    }
    
    //输出类型文章
	public function type(){    	
		$type = intval($_REQUEST['id']);
		//初始化分页
	    	$page = intval($_REQUEST[C("VAR_PAGE")]);
	    	if($page==0)
	    	$page = 1;
	    	$this->assign("page",$page);
    	
			
			$cate_list = D("ArticleCate")->getArticleCateList(array("type"=>$type,'status'=>1));
			$cate_list = D("ArticleCate")->toFormatTree($cate_list);
			$this->assign('article_cate_list',$cate_list);  //输出分类树
			
			$this->assign("page_title",L("ARTICLE_TYPE_".$type));	
			$navs = array('name'=>L("ARTICLE_TYPE_".$type),'url'=>U("Article/type",array('type'=>$type)));
			//输出当前页seo内容
	    	$data = array(
	    		'navs' => array(
	    		$navs,
	    		),
	    		'keyword'=>	'',
	    		'content'=>	'',
	    		);
	    		$this->assignSeo($data);    
			
			
			//输出文章列表
			$article_result = D("Article")->searchArticleList(0,$type,$keywords='',$page);
			$this->assign("article_list",$article_result['article_list']);
    		//分页
			$page = new Page($article_result['article_total'],sunnyiC("ARTICLE_PAGE_LISTROWS"));   //初始化分页对象 		
			$p  =  $page->show();
	        $this->assign('pages',$p);
	        //end 分页  
			$this->display("Page:article_type");
		
    }
    
    //文章显示
    public function show()
    {
    	$article_id = intval($_REQUEST['id']);
    	if(D("Article")->where('id='.$article_id.' and status=1')->count()==0)
		{
			$this->error(L("NO_ARTICLE"));
		}
		else
		{
			if($this->check_ip_operation(get_client_ip(),"Article",1200,$article_id))
			D("Article")->where(array('id'=>$article_id,'status'=>1))->setInc("click_count");
			$article_info = D("Article")->getArticleItem(array('id'=>$article_id,'status'=>1));
			if($article_info['ref_link']!='')
			{
				//当有外链时跳到外链
				header('Location:'.$article_info['ref_link']);
				exit;
			}
			$type = $article_info['type'];
			
			$cate_list = D("ArticleCate")->getArticleCateList(array("type"=>$type,'status'=>1));
			$cate_list = D("ArticleCate")->toFormatTree($cate_list);
			foreach($cate_list as $k=>$v)
			{
				if($article_info['cate_id']==$v['id'])
				$cate_list[$k]['act'] = 1;
			}
			$this->assign('article_cate_list',$cate_list);  //输出分类树			
			$this->assign('article_info',$article_info);
			
			$cate_info = D("ArticleCate")->getArticleCateItem(array('id'=>$article_info['cate_id']));
			$navs = array('name'=>$article_info['name_'.FANWE_LANG_ID],'url'=>$article_info['url']);
			$navs_cate = array('name'=>$cate_info['name_'.FANWE_LANG_ID],'url'=>U("Article/index",array('id'=>$cate_info['id'])));
			//输出当前页seo内容
	    		$data = array(
	    			'navs' => array(
	    				$navs_cate,
	    				$navs,
	    			),
	    			'keyword'=>	$article_info['seokeyword_'.FANWE_LANG_ID]!=''?$article_info['seokeyword_'.FANWE_LANG_ID]:$cate_info['name_'.FANWE_LANG_ID].",".$article_info['name_'.FANWE_LANG_ID],
	    			'content'=>	$article_info['seocontent_'.FANWE_LANG_ID]!=''?$article_info['seocontent_'.FANWE_LANG_ID]:$cate_info['name_'.FANWE_LANG_ID].",".$article_info['name_'.FANWE_LANG_ID],
	    		);
	    		$this->assignSeo($data);  
	    		
	    	//开始输出下载的附件
	    	$attachment_list = D("Attachment")->getAttachmentList($article_info['id'],'Article');
	    	$this->assign("attachment_list",$attachment_list);
	    	
	    	
	    	
	    	//初始化分页
	    	$page = intval($_REQUEST[C("VAR_PAGE")]);
	    	if($page==0)
	    	$page = 1;
	    	
	    	$result = D("Message")->getMessageList('Article',$article_id,$page);
	    	$this->assign("message_list",$result['message_list']);
	    	//分页
			$page = new Page($result['message_total'],sunnyiC("ARTICLE_PAGE_LISTROWS"));   //初始化分页对象 		
			$p  =  $page->show();
	        $this->assign('pages',$p);
	        //end 分页  
        
	        
	        //上一款/下一款
//	        $cate_ids = D("ArticleCate")->getChildIds($article_info['cate_id']);
//	    	$cate_ids[] = $article_info['cate_id'];
//	    	$cate_ids = implode(",",$cate_ids);
			$cate_ids = $article_info['cate_id'];
	    	
			$next_id = D("Article")->where("id>".$article_info['id']." and cate_id in(".$cate_ids.")")->order("id asc")->getField("id");
			$prev_id = D("Article")->where("id<".$article_info['id']." and cate_id in(".$cate_ids.")")->order("id desc")->getField("id");
    		$this->assign("next_item",D("Article")->getArticleItem(array('id'=>$next_id,'status'=>1)));
    		$this->assign("prev_item",D("Article")->getArticleItem(array('id'=>$prev_id,'status'=>1)));
     		
    		
    		$this->assign("relate_articles",$this->getRelateArticle($article_info['id'],sunnyiC("RELATE_ARTICLE_COUNT")));
	    	$this->display("Page:article_show");				
			
		}
    }
    
    
    
	//获取相关文章
    private function getRelateArticle($article_id=0,$limit=10)
    {
       $aritcle_item = D("Article")->getById($article_id);
	   $cate_ids = D("ArticleCate")->getChildIds($aritcle_item['cate_id']);
	   $cate_ids[] = $aritcle_item['cate_id'];
	   $cate_ids = implode(",",$cate_ids);
	   $relate_articles = D("Article")->getArticleList("cate_id in(".$cate_ids.") and status=1 and id<>$article_id ",$limit);
	   return $relate_articles;
    }
}
?>