<?php
// +----------------------------------------------------------------------
// | Sunnyi 多语商城建站系统 (Build on ThinkPHP)
// +----------------------------------------------------------------------
// | Copyright (c) 2009 http://www.sunnyi.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 商易网络(admin@sunnyi.cn)
// +----------------------------------------------------------------------


// 品牌模块
class BrandAction extends SunnyiAction{
	public function _show()
	{		
		$this->show($_REQUEST);
	}
    public function index(){
    	
    	//初始化分页
    	$page = intval($_REQUEST[C("VAR_PAGE")]);
    	if($page==0)
    	$page = 1;
    	$this->assign("page",$page);
    	
    	$limit = ($page-1)*sunnyiC("GOODS_PAGE_LISTROWS").",".sunnyiC("GOODS_PAGE_LISTROWS");
    	$brand_list = D("Brand")->getBrandList('',$limit,'sort');
    	
    	
    	
    	$navs = array('name'=>L("BRAND_LIST"),'url'=>U("Brand/index"));   	
    	//分页
		$page = new Page(D("Brand")->count(),sunnyiC("GOODS_PAGE_LISTROWS"));   //初始化分页对象 		
		$p  =  $page->show();
        $this->assign('pages',$p);
        //end 分页  
        
        
        //输出当前页seo内容
    	$data = array(
    		'navs' => array(
    			$navs,
    		),
    		'keyword'=>	'',
    		'content'=>	'',
    	);
    	$this->assignSeo($data);  
    	
    	$this->assign("brand_list",$brand_list);
		$this->display("Page:brand_index");
    }
    
    //品牌下的商品列表
    public function show($request)
    {
    	//输出显示方式
		$list_type = intval(Session::get("list_type"));
		$this->assign("list_type",$list_type);	
		
		
    	if($request)
    	{
    		$_REQUEST = $request;
    	}
    	$brand_id = intval($_REQUEST['id']);
    	if(D("Brand")->where("id=".$brand_id)->count()==0)
    	{
    		$this->error(L("NO_BRAND"));
    	}
    	else 
    	{
    		$brand_info = D("Brand")->getBrandItem(array('id'=>$brand_id));
    		$this->assign("brand_info",$brand_info);
    		$this->assign("page_title",$brand_info['name_'.FANWE_LANG_ID]);
    		
    		//初始化分页
	    	$page = intval($_REQUEST[C("VAR_PAGE")]);
	    	if($page==0)
	    	$page = 1;
	    	$this->assign("page",$page);
	    	
	    	//排序
	    	$sort = '';
	    	if($_REQUEST['sort_field'])
	    	{
	    		$sort = $_REQUEST['sort_field'];  
	    		$this->assign("sort_field",$_REQUEST['sort_field']);
	    	}
	    	if($_REQUEST['sort_type'])
	    	{
	    		$sort.=" ".$_REQUEST['sort_type']; 	
	    		$this->assign("sort_type",$_REQUEST['sort_type']);
	    	}
    	
    	
	    	$goods_result = D("Goods")->searchGoodsList($cate_id=0,$brand_id,$type_id=0,$keywords='',$attr_value='',$rec_type='', $min_price=0,$max_price=0,$page,$sort);
	    	$this->assign("goods_list",$goods_result['goods_list']);
	    	
	    	$navs = array('name'=>L("BRAND_LIST"),'url'=>U("Brand/index")); 
	    	$navs_item = array('name'=>$brand_info['name_'.FANWE_LANG_ID],'url'=>$brand_info['url']);  	
	    	//分页
			$page = new Page($goods_result['goods_total'],sunnyiC("GOODS_PAGE_LISTROWS"));   //初始化分页对象 		
			$p  =  $page->show();
	        $this->assign('pages',$p);
	        //end 分页  
	        
	        
	        //输出当前页seo内容
	    	$data = array(
	    		'navs' => array(
	    			$navs,$navs_item
	    		),
	    		'keyword'=>	$brand_info['name_'.FANWE_LANG_ID].",".$brand_info['seokeyword_'.FANWE_LANG_ID],
	    		'content'=>	$brand_info['name_'.FANWE_LANG_ID].",".$brand_info['seocontent_'.FANWE_LANG_ID],
	    	);
	    	$this->assignSeo($data);  
	    	
	    	
	    	$this->display("Page:brand_show");
    	}
    }
}
?>